/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.internal.helper;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.internal.micrometer.PercentileHistogramBuckets;
import io.openliberty.microprofile.metrics30.setup.config.DefaultBucketConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.HistogramBucketConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.HistogramBucketMaxConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.HistogramBucketMinConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager;
import io.openliberty.microprofile.metrics30.setup.config.TimerBucketConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.TimerBucketMaxConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.TimerBucketMinConfiguration;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Snapshot;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BucketManager {
    private final Map<Double, BucketValue> buckets = new TreeMap<Double, BucketValue>();
    private final Map<String, Map<Double, BucketValue>> allBuckets = new TreeMap<String, Map<Double, BucketValue>>();
    private final BucketValue infiniteObject;
    private static boolean issuedBetaMessage = false;
    private static boolean issuedBetaWarning = false;
    private static final TraceComponent tc = Tr.register(BucketManager.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    static final long serialVersionUID = -7472102513790029670L;

    /*
     * WARNING - void declaration
     */
    public BucketManager(Metadata metadata) {
        DefaultBucketConfiguration defaultBucketConfig;
        String metricName = metadata.getName();
        this.infiniteObject = new BucketValue(0L, metadata.getUnit());
        double[] bucketArr = null;
        Optional defaultHistogramOption = ConfigProvider.getConfig().getOptionalValue("mp.metrics.distribution.percentiles-histogram.enabled", String.class);
        if (defaultHistogramOption.isPresent() && (defaultBucketConfig = MetricsConfigurationManager.getInstance().getDefaultBucketConfiguration(metricName)) != null && defaultBucketConfig.isEnabled()) {
            TreeSet<Double> defaultBucketsMicrometer;
            if (metadata.getType().equals("histogram")) {
                defaultBucketsMicrometer = new TreeSet<Double>();
                HistogramBucketMaxConfiguration defaultBucketMaxConfig = MetricsConfigurationManager.getInstance().getDefaultHistogramMaxBucketConfiguration(metricName);
                HistogramBucketMinConfiguration defaultBucketMinConfig = MetricsConfigurationManager.getInstance().getDefaultHistogramMinBucketConfiguration(metricName);
                double minHistogramValue = defaultBucketMinConfig != null ? (Double)defaultBucketMinConfig.getValue() : 0.0;
                double maxHistogramValue = defaultBucketMaxConfig != null ? (Double)defaultBucketMaxConfig.getValue() : Double.MAX_VALUE;
                defaultBucketsMicrometer.addAll(PercentileHistogramBuckets.getDefaultBuckets(minHistogramValue, maxHistogramValue, false));
                Iterator iterator = defaultBucketsMicrometer.iterator();
                while (iterator.hasNext()) {
                    this.buckets.put((Double)iterator.next(), new BucketValue(0L, metadata.getUnit()));
                }
            } else if (metadata.getType().equals("timer")) {
                defaultBucketsMicrometer = new TreeSet();
                TimerBucketMaxConfiguration defaultTimerMaxConfig = MetricsConfigurationManager.getInstance().getDefaultTimerMaxBucketConfiguration(metricName);
                TimerBucketMinConfiguration defaultTimerMinConfig = MetricsConfigurationManager.getInstance().getDefaultTimerMinBucketConfiguration(metricName);
                double minTimerValue = defaultTimerMinConfig != null ? (double)((Duration)defaultTimerMinConfig.getValue()).toMillis() / 1000.0 : 0.001;
                double maxTimerValue = defaultTimerMaxConfig != null ? (double)((Duration)defaultTimerMaxConfig.getValue()).toMillis() / 1000.0 : 30.0;
                defaultBucketsMicrometer.addAll(PercentileHistogramBuckets.getDefaultBuckets(minTimerValue, maxTimerValue, true));
                Iterator iterator = defaultBucketsMicrometer.iterator();
                while (iterator.hasNext()) {
                    this.buckets.put((Double)iterator.next(), new BucketValue(0L, metadata.getUnit()));
                }
            }
        }
        Optional histogramOptionalData = ConfigProvider.getConfig().getOptionalValue("mp.metrics.distribution.histogram.buckets", String.class);
        Optional timerOptionalData = ConfigProvider.getConfig().getOptionalValue("mp.metrics.distribution.timer.buckets", String.class);
        if (histogramOptionalData.isPresent() || timerOptionalData.isPresent()) {
            HistogramBucketConfiguration bucketsConfig = MetricsConfigurationManager.getInstance().getHistogramBucketConfiguration(metricName);
            TimerBucketConfiguration timerBucketsConfig = MetricsConfigurationManager.getInstance().getTimerBucketConfiguration(metricName);
            if (metadata.getType().equals("histogram") && bucketsConfig != null && bucketsConfig.getValues() != null && ((Double[])bucketsConfig.getValues()).length > 0) {
                double[] vals;
                double[] dArray = bucketArr = (vals = Stream.of((Double[])bucketsConfig.getValues()).mapToDouble(Double::doubleValue).toArray());
                int n = dArray.length;
                for (int i = 0; i < n; ++i) {
                    Double d = dArray[i];
                    this.buckets.put(d, new BucketValue(0L, metadata.getUnit()));
                }
                this.buckets.put(Double.POSITIVE_INFINITY, this.infiniteObject);
            }
            if (metadata.getType().equals("timer") && timerBucketsConfig != null && timerBucketsConfig.getValues() != null && ((Duration[])timerBucketsConfig.getValues()).length > 0) {
                Duration[] vals;
                for (Duration duration : vals = (Duration[])timerBucketsConfig.getValues()) {
                    try {
                        this.buckets.put((double)duration.toMillis() / 1000.0, new BucketValue(0L, metadata.getUnit()));
                    }
                    catch (Exception exception) {
                        void e;
                        FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.metrics30.internal.helper.BucketManager", (String)"131", (Object)this, (Object[])new Object[]{metadata});
                        e.printStackTrace();
                    }
                }
                this.buckets.put(Double.POSITIVE_INFINITY, this.infiniteObject);
            }
        }
        if (metadata != null && this.buckets != null && !this.buckets.isEmpty() && this.betaFenceCheck()) {
            this.allBuckets.put(metricName, this.buckets);
        }
    }

    private boolean betaFenceCheck() throws UnsupportedOperationException {
        if (!ProductInfo.getBetaEdition()) {
            if (!issuedBetaWarning) {
                Tr.warning((TraceComponent)tc, (String)"This method is beta and is not available.", (Object[])new Object[0]);
                issuedBetaWarning = true;
            }
        } else if (!issuedBetaMessage) {
            Tr.info((TraceComponent)tc, (String)("BETA: A beta method has been invoked for the class " + this.getClass().getName() + " for the first time."), (Object[])new Object[0]);
            issuedBetaMessage = true;
        }
        return issuedBetaMessage;
    }

    public void updateTimer(long value) {
        for (Map.Entry<String, Map<Double, BucketValue>> entry : this.allBuckets.entrySet()) {
            Map<Double, BucketValue> innerMap = entry.getValue();
            for (Map.Entry<Double, BucketValue> innerEntry : innerMap.entrySet()) {
                if (!(innerEntry.getKey() >= (double)value / 1.0E9)) continue;
                innerEntry.getValue().increment();
            }
        }
    }

    public void updateHistogram(long value) {
        for (Map.Entry<String, Map<Double, BucketValue>> entry : this.allBuckets.entrySet()) {
            Map<Double, BucketValue> innerMap = entry.getValue();
            for (Map.Entry<Double, BucketValue> innerEntry : innerMap.entrySet()) {
                if (!(innerEntry.getKey() >= (double)value)) continue;
                innerEntry.getValue().increment();
            }
        }
    }

    public Map<String, Map<Double, BucketValue>> getBuckets() {
        return this.allBuckets;
    }

    public Snapshot getBucketsSnap() {
        return (Snapshot)this.buckets;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class BucketValue {
        private long value;
        private final String unit;
        static final long serialVersionUID = -4804978754000425702L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public BucketValue(long value, String unit) {
            this.value = value;
            this.unit = unit;
        }

        public double getValue() {
            return this.value;
        }

        public String getUnit() {
            return this.unit;
        }

        public void increment() {
            ++this.value;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics30.internal.helper.BucketManager$BucketValue", BucketValue.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Bucket {
        private final double value;
        private final BucketValue bucketValue;
        static final long serialVersionUID = -4000846798799566332L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Bucket(double value, BucketValue newBucket) {
            this.value = value;
            this.bucketValue = newBucket;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics30.internal.helper.BucketManager$Bucket", Bucket.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
        }
    }
}

