/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc.outbound;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.outbound.WsocOutboundChain;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WsocChain {
    private static final TraceComponent tc = Tr.register(WsocChain.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    private final WsocOutboundChain owner;
    private final boolean isHttps;
    private String endpointName;
    private String tcpName;
    private String sslName;
    private String httpName;
    private String chainName;
    private ChannelFramework cfw;
    private volatile boolean enabled = false;
    private volatile boolean configured = false;
    private volatile ActiveConfiguration currentConfig = null;
    static final long serialVersionUID = -446740780409968248L;

    public WsocChain(WsocOutboundChain owner, boolean isHttps) {
        this.owner = owner;
        this.isHttps = isHttps;
        if (!isHttps) {
            this.configured = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void init(String chainId, ChannelFramework cfw) {
        block3: {
            this.tcpName = "TCP-" + chainId;
            this.sslName = "SSL-" + chainId;
            this.httpName = "HTTP-" + chainId;
            this.chainName = chainId;
            this.cfw = cfw;
            try {
                ChainData cd = cfw.getChain(this.chainName);
                if (cd != null) {
                    cfw.removeChain(cd);
                }
            }
            catch (ChainException cd) {
                void e;
                FFDCFilter.processException((Throwable)cd, (String)"com.ibm.ws.wsoc.outbound.WsocChain", (String)"106", (Object)this, (Object[])new Object[]{chainId, cfw});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Error stopping chain " + this.chainName), (Object[])new Object[]{this, e});
            }
        }
    }

    public void enable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("enable chain " + this), (Object[])new Object[0]);
        }
        this.enabled = true;
    }

    public void disable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("disable chain " + this), (Object[])new Object[0]);
        }
        this.enabled = false;
    }

    public void setConfigured(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("enable chain " + this), (Object[])new Object[0]);
        }
        this.configured = value;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void stop() {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("stop chain " + this), (Object[])new Object[0]);
            }
            if (this.currentConfig == null) {
                return;
            }
            try {
                ChainData cd = this.cfw.getChain(this.chainName);
                if (cd != null) {
                    this.cfw.removeChain(cd);
                }
            }
            catch (ChainException cd) {
                void e;
                FFDCFilter.processException((Throwable)cd, (String)"com.ibm.ws.wsoc.outbound.WsocChain", (String)"171", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Error stopping chain " + this.chainName), (Object[])new Object[]{this, e});
            }
        }
    }

    @FFDCIgnore(value={ChannelException.class, ChainException.class})
    public synchronized void update() {
        block22: {
            ActiveConfiguration newConfig;
            Map<String, Object> httpOptions;
            Map<String, Object> sslOptions;
            Map<String, Object> tcpOptions;
            block23: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("update chain " + this), (Object[])new Object[0]);
                }
                if (!this.enabled || !this.configured || FrameworkState.isStopping()) {
                    return;
                }
                ActiveConfiguration oldConfig = this.currentConfig;
                boolean validOldConfig = oldConfig == null ? false : oldConfig.validConfiguration;
                tcpOptions = this.owner.getTcpOptions();
                newConfig = new ActiveConfiguration(this.isHttps, tcpOptions, sslOptions = this.isHttps ? this.owner.getSslOptions() : null, httpOptions = this.owner.getHttpOptions());
                if (!newConfig.complete()) {
                    this.currentConfig = newConfig;
                    try {
                        ChainData cd = this.cfw.getChain(this.chainName);
                        if (cd != null) {
                            this.cfw.removeChain(cd);
                        }
                        break block22;
                    }
                    catch (ChainException e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("Error stopping chain " + this.chainName), (Object[])new Object[]{oldConfig, e});
                        }
                        break block22;
                    }
                }
                boolean sameConfig = newConfig.unchanged(oldConfig);
                if (validOldConfig && sameConfig) {
                    return;
                }
                try {
                    ChainData cd = this.cfw.getChain(this.chainName);
                    if (cd != null) {
                        this.cfw.removeChain(cd);
                    }
                    if (newConfig.tcpChanged(oldConfig)) {
                        this.removeChannel(this.tcpName);
                    }
                    if (newConfig.sslChanged(oldConfig)) {
                        this.removeChannel(this.sslName);
                    }
                    if (newConfig.httpChanged(oldConfig)) {
                        this.removeChannel(this.httpName);
                    }
                }
                catch (ChainException e) {
                    e.printStackTrace();
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block23;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Error stopping chain " + this.chainName), (Object[])new Object[]{oldConfig, e});
                }
            }
            this.currentConfig = newConfig;
            try {
                ChainData cd;
                ChannelData httpChannel;
                ChannelData sslChannel;
                HashMap<String, Object> chanProps;
                ChannelData tcpChannel = this.cfw.getChannel(this.tcpName);
                if (tcpChannel == null) {
                    String typeName = (String)tcpOptions.get("type");
                    chanProps = new HashMap<String, Object>(tcpOptions);
                    tcpChannel = this.cfw.addChannel(this.tcpName, this.cfw.lookupFactory(typeName), chanProps);
                }
                if (this.isHttps && (sslChannel = this.cfw.getChannel(this.sslName)) == null) {
                    sslChannel = this.cfw.addChannel(this.sslName, this.cfw.lookupFactory("SSLChannel"), new HashMap<String, Object>(sslOptions));
                }
                if ((httpChannel = this.cfw.getChannel(this.httpName)) == null) {
                    chanProps = new HashMap<String, Object>(httpOptions);
                    httpChannel = this.cfw.addChannel(this.httpName, this.cfw.lookupFactory("HTTPOutboundChannel"), chanProps);
                }
                if (null == (cd = this.cfw.getChain(this.chainName))) {
                    String[] chanList = this.isHttps ? new String[]{this.httpName, this.sslName, this.tcpName} : new String[]{this.httpName, this.tcpName};
                    cd = this.cfw.addChain(this.chainName, FlowType.OUTBOUND, chanList);
                    cd.setEnabled(this.enabled);
                }
                newConfig.validConfiguration = true;
            }
            catch (ChannelException channelException) {
            }
            catch (ChainException chainException) {
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wsoc.outbound.WsocChain", (String)"307", (Object)this, (Object[])new Object[0]);
            }
        }
    }

    @FFDCIgnore(value={ChannelException.class, ChainException.class})
    private void removeChannel(String name) {
        block4: {
            try {
                this.cfw.removeChannel(name);
            }
            catch (ChannelException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Error removing channel " + name), (Object[])new Object[]{this, e});
                }
            }
            catch (ChainException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Error removing channel " + name), (Object[])new Object[]{this, e});
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[@=" + System.identityHashCode(this) + ",enabled=" + this.enabled + ",configured=" + this.configured + ",chainName=" + this.chainName + ",config=" + this.currentConfig + "]";
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private final class ActiveConfiguration {
        final boolean isHttps;
        final Map<String, Object> tcpOptions;
        final Map<String, Object> sslOptions;
        final Map<String, Object> httpOptions;
        volatile int activePort = -1;
        boolean validConfiguration = false;
        static final long serialVersionUID = 4800572683598102817L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ActiveConfiguration(boolean isHttps, Map<String, Object> tcp, Map<String, Object> ssl, Map<String, Object> http) {
            this.isHttps = isHttps;
            this.tcpOptions = tcp;
            this.sslOptions = ssl;
            this.httpOptions = http;
            String attribute = isHttps ? "httpsPort" : "httpPort";
        }

        @Trivial
        public boolean complete() {
            if (this.tcpOptions == null || this.httpOptions == null) {
                return false;
            }
            return !this.isHttps || this.sslOptions != null;
        }

        protected boolean unchanged(ActiveConfiguration other) {
            if (other == null) {
                return false;
            }
            if (this.isHttps) {
                return this.tcpOptions == other.tcpOptions && this.sslOptions == other.sslOptions && this.httpOptions == other.httpOptions;
            }
            return this.tcpOptions == other.tcpOptions && this.httpOptions == other.httpOptions;
        }

        protected boolean tcpChanged(ActiveConfiguration other) {
            if (other == null) {
                return false;
            }
            return this.tcpOptions != other.tcpOptions;
        }

        protected boolean sslChanged(ActiveConfiguration other) {
            if (other == null) {
                return false;
            }
            return this.sslOptions != other.sslOptions;
        }

        protected boolean httpChanged(ActiveConfiguration other) {
            if (other == null) {
                return false;
            }
            return this.httpOptions != other.httpOptions;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ",complete=" + this.complete() + ",tcpOptions=" + System.identityHashCode(this.tcpOptions) + ",httpOptions=" + System.identityHashCode(this.httpOptions) + ",sslOptions=" + (this.isHttps ? Integer.valueOf(System.identityHashCode(this.sslOptions)) : "0") + "]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsoc.outbound.WsocChain$ActiveConfiguration", ActiveConfiguration.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
        }
    }
}

