/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.smap;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.resource.ResourcesImpl;
import com.ibm.ws.jsp.translator.utils.JspId;
import com.ibm.ws.jsp.translator.utils.SmapGenerator;
import com.ibm.ws.jsp.translator.utils.SmapStratum;
import com.ibm.ws.jsp.translator.visitor.JspVisitor;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.JspVisitorResult;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.generator.GenerateJspResult;
import com.ibm.ws.jsp.translator.visitor.generator.GenerateTagFileResult;
import com.ibm.ws.jsp.translator.visitor.smap.SmapVisitorResult;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateResult;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class SmapVisitor
extends JspVisitor {
    private SmapGenerator smapGenerator = null;
    private SmapStratum smapStratum = null;
    private List fileList = new ArrayList();
    private ResourcesImpl generatedFiles = null;
    private Map cdataJspIdMap = null;
    private int serviceMethodLineNumber = 0;
    private int tagMethodLineNumber = 0;
    private Map customTagMethodJspIdMap = null;
    private String validateResultId = null;
    static final long serialVersionUID = 8511924879540234844L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SmapVisitor(JspVisitorUsage visitorUsage, JspConfiguration jspConfiguration, JspCoreContext context, HashMap resultMap, JspVisitorInputMap inputMap) throws JspCoreException {
        super(visitorUsage, jspConfiguration, context, resultMap, inputMap);
        this.smapGenerator = new SmapGenerator();
        this.smapStratum = new SmapStratum("JSP");
        if (inputMap.containsKey("JspFiles")) {
            this.generatedFiles = (ResourcesImpl)inputMap.get("JspFiles");
            this.validateResultId = "JspValidate";
        } else if (inputMap.containsKey("TagFileFiles")) {
            this.generatedFiles = (ResourcesImpl)inputMap.get("TagFileFiles");
            this.validateResultId = "TagFileValidate";
        }
        this.smapGenerator.setOutputFileName(this.generatedFiles.getGeneratedSourceFile().getName());
        this.cdataJspIdMap = (Map)inputMap.get("CdataJspIdMap");
        GenerateJspResult genJspResult = (GenerateJspResult)resultMap.get("JspGenerate");
        if (genJspResult != null) {
            this.serviceMethodLineNumber = genJspResult.getServiceMethodLineNumber();
            this.customTagMethodJspIdMap = genJspResult.getCustomTagMethodJspIdMap();
        } else {
            GenerateTagFileResult genTagFileResult = (GenerateTagFileResult)resultMap.get("TagFileGenerate");
            this.tagMethodLineNumber = genTagFileResult.getTagMethodLineNumber();
            this.customTagMethodJspIdMap = genTagFileResult.getCustomTagMethodJspIdMap();
        }
    }

    private void addStartLineInfo(Element jspElement) {
        JspId jspId = new JspId(jspElement.getAttributeNS("http://java.sun.com/JSP/Page", "id"));
        if (!this.fileList.contains(jspId.getFilePath())) {
            this.smapStratum.addFile(jspId.getFileName(), jspId.getFilePath());
            this.fileList.add(jspId.getFilePath());
        }
        if (jspId.getStartGeneratedLineNum() > 0) {
            this.smapStratum.addLineData(jspId.getStartSourceLineNum(), jspId.getFileName(), 1, jspId.getStartGeneratedLineNum(), jspId.getStartGeneratedLineCount());
        }
    }

    private void addEndLineInfo(Element jspElement) {
        JspId jspId = new JspId(jspElement.getAttributeNS("http://java.sun.com/JSP/Page", "id"));
        if (jspId.getEndGeneratedLineNum() > 0) {
            this.smapStratum.addLineData(jspId.getEndSourceLineNum(), jspId.getFileName(), 1, jspId.getEndGeneratedLineNum(), jspId.getEndGeneratedLineCount());
        }
    }

    @Override
    public JspVisitorResult getResult() throws JspCoreException {
        this.smapGenerator.addStratum(this.smapStratum, true);
        JspOptions jspOptions = (JspOptions)this.inputMap.get("JspOptions");
        if (jspOptions.isKeepGenerated()) {
            FileOutputStream fos = null;
            PrintWriter so = null;
            try {
                File outSmap = new File(this.generatedFiles.getClassFile().getPath() + ".smap");
                fos = new FileOutputStream(outSmap);
                so = new PrintWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                so.print(this.smapGenerator.getString());
            }
            catch (IOException e) {
                throw new JspCoreException(e);
            }
            finally {
                if (so != null) {
                    so.close();
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        SmapVisitorResult result = new SmapVisitorResult(this.visitorUsage.getJspVisitorDefinition().getId(), this.smapGenerator);
        return result;
    }

    @Override
    protected void visitCustomTagStart(Element jspElement) throws JspCoreException {
        String customTagMethodJspId;
        JspId jspId = new JspId(jspElement.getAttributeNS("http://java.sun.com/JSP/Page", "id"));
        if (!this.fileList.contains(jspId.getFilePath())) {
            this.smapStratum.addFile(jspId.getFileName(), jspId.getFilePath());
            this.fileList.add(jspId.getFilePath());
        }
        if ((customTagMethodJspId = (String)this.customTagMethodJspIdMap.get(jspElement)) != null) {
            String syntaxLineNum = customTagMethodJspId.substring(0, customTagMethodJspId.indexOf(44));
            String lineCount = customTagMethodJspId.substring(customTagMethodJspId.indexOf(44) + 1);
            this.smapStratum.addLineData(jspId.getStartSourceLineNum(), jspId.getFileName(), 1, Integer.valueOf(syntaxLineNum), Integer.valueOf(lineCount));
        }
        if (jspId.getStartGeneratedLineNum() > 0) {
            this.smapStratum.addLineData(jspId.getStartSourceLineNum(), jspId.getFileName(), 1, jspId.getStartGeneratedLineNum(), jspId.getStartGeneratedLineCount());
        }
    }

    @Override
    protected void visitJspRootStart(Element jspElement) throws JspCoreException {
        JspId jspId = new JspId(jspElement.getAttributeNS("http://java.sun.com/JSP/Page", "id"));
        if (!this.fileList.contains(jspId.getFilePath())) {
            this.smapStratum.addFile(jspId.getFileName(), jspId.getFilePath());
            this.fileList.add(jspId.getFilePath());
        }
        if (this.serviceMethodLineNumber > 0) {
            this.smapStratum.addLineData(1, jspId.getFileName(), 1, this.serviceMethodLineNumber, 1);
        } else if (this.tagMethodLineNumber > 0) {
            this.smapStratum.addLineData(1, jspId.getFileName(), 1, this.tagMethodLineNumber, 1);
        }
    }

    @Override
    protected void visitPageDirectiveStart(Element jspElement) throws JspCoreException {
    }

    @Override
    protected void visitJspGetPropertyStart(Element jspElement) throws JspCoreException {
        this.addStartLineInfo(jspElement);
    }

    @Override
    protected void visitJspForwardStart(Element jspElement) throws JspCoreException {
        this.addStartLineInfo(jspElement);
    }

    @Override
    protected void visitJspPluginStart(Element jspElement) throws JspCoreException {
        this.addStartLineInfo(jspElement);
    }

    @Override
    protected void visitIncludeDirectiveStart(Element jspElement) throws JspCoreException {
    }

    @Override
    protected void visitJspSetPropertyStart(Element jspElement) throws JspCoreException {
        this.addStartLineInfo(jspElement);
    }

    @Override
    protected void visitJspIncludeStart(Element jspElement) throws JspCoreException {
        this.addStartLineInfo(jspElement);
    }

    @Override
    protected void visitJspAttributeStart(Element jspElement) throws JspCoreException {
        this.addStartLineInfo(jspElement);
    }

    @Override
    protected void visitJspElementStart(Element jspElement) throws JspCoreException {
        this.addStartLineInfo(jspElement);
    }

    @Override
    protected void visitJspBodyStart(Element jspElement) throws JspCoreException {
        this.addStartLineInfo(jspElement);
    }

    @Override
    protected void visitJspInvokeStart(Element jspElement) throws JspCoreException {
        this.addStartLineInfo(jspElement);
    }

    @Override
    protected void visitJspDoBodyStart(Element jspElement) throws JspCoreException {
        this.addStartLineInfo(jspElement);
    }

    @Override
    protected void visitTagDirectiveStart(Element jspElement) throws JspCoreException {
    }

    @Override
    protected void visitAttributeDirectiveStart(Element jspElement) throws JspCoreException {
    }

    @Override
    protected void visitVariableDirectiveStart(Element jspElement) throws JspCoreException {
    }

    @Override
    protected void visitJspParamsStart(Element jspElement) throws JspCoreException {
    }

    @Override
    protected void visitJspFallbackStart(Element jspElement) throws JspCoreException {
        this.addStartLineInfo(jspElement);
    }

    @Override
    protected void visitJspParamStart(Element jspElement) throws JspCoreException {
        this.addStartLineInfo(jspElement);
    }

    @Override
    protected void visitJspUseBeanStart(Element jspElement) throws JspCoreException {
        this.addStartLineInfo(jspElement);
    }

    @Override
    protected void visitJspExpressionStart(Element jspElement) throws JspCoreException {
        this.addStartLineInfo(jspElement);
    }

    @Override
    protected void visitJspScriptletStart(Element jspElement) throws JspCoreException {
        this.addScriptingLineInfo(jspElement);
    }

    @Override
    protected void visitJspDeclarationStart(Element jspElement) throws JspCoreException {
        this.addScriptingLineInfo(jspElement);
    }

    @Override
    protected void visitJspTextStart(Element jspElement) throws JspCoreException {
        this.addStartLineInfo(jspElement);
    }

    @Override
    protected void visitJspOutputStart(Element jspElement) throws JspCoreException {
    }

    @Override
    protected void visitUninterpretedTagStart(Element jspElement) throws JspCoreException {
        String uri = jspElement.getNamespaceURI();
        if (uri != null) {
            if (uri.startsWith("urn:jsptld:")) {
                uri = uri.substring(uri.indexOf("urn:jsptld:") + 11);
            } else if (uri.startsWith("urn:jsptagdir:")) {
                uri = uri.substring(uri.indexOf("urn:jsptagdir:") + 14);
            }
            ValidateResult validatorResult = (ValidateResult)this.resultMap.get(this.validateResultId);
            if (validatorResult.getTagLibMap().get(uri) != null) {
                this.visitCustomTagStart(jspElement);
            } else {
                this.addStartLineInfo(jspElement);
            }
        } else {
            this.addStartLineInfo(jspElement);
        }
    }

    @Override
    protected void visitJspParamEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitJspGetPropertyEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitJspRootEnd(Element jspElement) throws JspCoreException {
    }

    @Override
    protected void visitJspFallbackEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitJspUseBeanEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitJspForwardEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitJspPluginEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitJspSetPropertyEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitIncludeDirectiveEnd(Element jspElement) throws JspCoreException {
    }

    @Override
    protected void visitJspExpressionEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitPageDirectiveEnd(Element jspElement) throws JspCoreException {
    }

    @Override
    protected void visitJspIncludeEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitJspScriptletEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitJspDeclarationEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitJspTextEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitJspParamsEnd(Element jspElement) throws JspCoreException {
    }

    @Override
    protected void visitJspAttributeEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitJspElementEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitJspBodyEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitJspInvokeEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitJspDoBodyEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitTagDirectiveEnd(Element jspElement) throws JspCoreException {
    }

    @Override
    protected void visitAttributeDirectiveEnd(Element jspElement) throws JspCoreException {
    }

    @Override
    protected void visitVariableDirectiveEnd(Element jspElement) throws JspCoreException {
    }

    @Override
    protected void visitCustomTagEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitJspOutputEnd(Element jspElement) throws JspCoreException {
    }

    @Override
    protected void visitUninterpretedTagEnd(Element jspElement) throws JspCoreException {
        this.addEndLineInfo(jspElement);
    }

    @Override
    protected void visitCDataTag(CDATASection cdata) throws JspCoreException {
        String id = (String)this.cdataJspIdMap.get(new Integer(cdata.hashCode()));
        if (id != null) {
            JspId jspId = new JspId(id);
            if (!this.fileList.contains(jspId.getFilePath())) {
                this.smapStratum.addFile(jspId.getFileName(), jspId.getFilePath());
                this.fileList.add(jspId.getFilePath());
            }
            if (jspId.getStartGeneratedLineNum() > 0) {
                this.smapStratum.addLineData(jspId.getStartSourceLineNum(), jspId.getFileName(), jspId.getStartGeneratedLineCount(), jspId.getStartGeneratedLineNum(), 1);
            }
        }
    }

    private void addScriptingLineInfo(Element jspElement) {
        JspId jspId = new JspId(jspElement.getAttributeNS("http://java.sun.com/JSP/Page", "id"));
        if (!this.fileList.contains(jspId.getFilePath())) {
            this.smapStratum.addFile(jspId.getFileName(), jspId.getFilePath());
            this.fileList.add(jspId.getFilePath());
        }
        if (jspId.getStartGeneratedLineNum() > 0) {
            CDATASection cdata = (CDATASection)jspElement.getChildNodes().item(0);
            BufferedReader reader = new BufferedReader(new StringReader(cdata.getData()));
            int skipLeadingCount = 0;
            int skipTrailingCount = 0;
            int lineCount = 0;
            boolean contentFound = false;
            try {
                String line = null;
                while ((line = reader.readLine()) != null) {
                    ++lineCount;
                    if (line.trim().length() < 1) {
                        if (contentFound) {
                            ++skipTrailingCount;
                            continue;
                        }
                        ++skipLeadingCount;
                        continue;
                    }
                    contentFound = true;
                    skipTrailingCount = 0;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.smapStratum.addLineData(jspId.getStartSourceLineNum() + skipLeadingCount, jspId.getFileName(), lineCount - skipLeadingCount - skipTrailingCount, jspId.getStartGeneratedLineNum() + skipLeadingCount, 1);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.translator.visitor.smap.SmapVisitor", SmapVisitor.class, null, null);
    }
}

