/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LogRecordContext {
    private static final ThreadLocal<HashMap<String, String>> extensions = new ThreadLocal();
    private static final Map<String, WeakReference<Extension>> extensionMap = new HashMap<String, WeakReference<Extension>>();
    private static final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private static final Lock r = rwl.readLock();
    private static final Lock w = rwl.writeLock();
    public static final String PTHREADID = "thread";
    private static final ThreadLocal<Boolean> recursion = new ThreadLocal();
    private static final Extension THREAD_NAME_EXTENSION = new Extension(){

        @Override
        public String getValue() {
            return Thread.currentThread().getName();
        }
    };

    public static void addExtension(String extensionName, String extensionValue) {
        if (extensionName == null || extensionValue == null) {
            throw new IllegalArgumentException("Neither 'extensionName' nor 'extensionValue' parameter can be null. Extension Name=" + extensionName + " Extension Value=" + extensionValue);
        }
        HashMap<String, String> ext = extensions.get();
        if (ext == null) {
            ext = new HashMap();
            extensions.set(ext);
        }
        ext.put(extensionName, extensionValue);
    }

    public static boolean removeExtension(String extensionName) {
        if (extensionName == null) {
            throw new IllegalArgumentException("Parameter 'extensionName' can not be null");
        }
        HashMap<String, String> ext = extensions.get();
        return ext == null ? false : ext.remove(extensionName) != null;
    }

    public static void registerExtension(String key, Extension extension) {
        if (key == null || extension == null) {
            throw new IllegalArgumentException("Neither 'key' nor 'extension' parameter can be null.");
        }
        w.lock();
        try {
            if (extensionMap.containsKey(key)) {
                throw new IllegalArgumentException("Extension with the key " + key + " is registered already");
            }
            extensionMap.put(key, new WeakReference<Extension>(extension));
        }
        finally {
            w.unlock();
        }
    }

    public static boolean unregisterExtension(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Parameter 'key' can not be null");
        }
        w.lock();
        try {
            boolean bl = extensionMap.remove(key) != null;
            return bl;
        }
        finally {
            w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getExtensions(Map<String, String> map) throws IllegalArgumentException {
        WeakReference<Extension> extension;
        if (map == null) {
            throw new IllegalArgumentException("Parameter 'map' can not be null.");
        }
        if (recursion.get() == Boolean.TRUE) {
            return;
        }
        recursion.set(Boolean.TRUE);
        LinkedList<String> cleanup = new LinkedList<String>();
        r.lock();
        try {
            for (Map.Entry<String, WeakReference<Extension>> entry : extensionMap.entrySet()) {
                extension = (Extension)entry.getValue().get();
                if (extension == null) {
                    cleanup.add(entry.getKey());
                    continue;
                }
                String value = extension.getValue();
                if (value == null) continue;
                map.put(entry.getKey(), value);
            }
        }
        finally {
            r.unlock();
            recursion.remove();
        }
        if (cleanup.size() > 0) {
            w.lock();
            try {
                for (String string : cleanup) {
                    extension = extensionMap.remove(string);
                    if (extension == null || extension.get() == null) continue;
                    extensionMap.put(string, extension);
                }
            }
            finally {
                w.unlock();
            }
        }
        if (extensions.get() != null) {
            for (Map.Entry<String, Object> entry : extensions.get().entrySet()) {
                map.put(entry.getKey(), (String)entry.getValue());
            }
        }
    }

    static {
        extensionMap.put(PTHREADID, new WeakReference<Extension>(THREAD_NAME_EXTENSION));
    }

    public static interface Extension {
        public String getValue();
    }
}

