/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.opentracing.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.opentracing.internal.ActiveSpan;
import io.openliberty.opentracing.internal.OpentracingFilterHelper;
import io.openliberty.opentracing.internal.OpentracingFilterHelperProvider;
import io.openliberty.opentracing.internal.OpentracingTracerManager;
import io.openliberty.opentracing.internal.OpentracingUtils;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;

@Provider
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpentracingClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final TraceComponent tc = Tr.register(OpentracingClientFilter.class, (String)"OPENTRACING", (String)"io.openliberty.opentracing.internal.resources.Opentracing");
    private static ThreadLocal<Tracer> currentTracer = new ThreadLocal();
    public static final String CLIENT_CONTINUATION_PROP_ID = OpentracingClientFilter.class.getName() + ".Span";
    public static final String CLIENT_SPAN_SKIPPED_ID = OpentracingClientFilter.class.getName() + ".Skipped";
    public static final String CLIENT_FILTER_ENABLED_ID = OpentracingClientFilter.class.getName() + ".Enabled";
    private static final String TAG_COMPONENT_JAXRS = "jaxrs";
    private OpentracingFilterHelper helper;
    private boolean spanErrorLogged = false;
    static final long serialVersionUID = -3584427558882411992L;

    public OpentracingClientFilter() {
    }

    public OpentracingClientFilter(OpentracingFilterHelper helper) {
        this.helper = helper;
    }

    /*
     * WARNING - void declaration
     */
    public void filter(ClientRequestContext clientRequestContext) throws IOException {
        boolean process;
        String methodName = "filter(outgoing)";
        this.helper = OpentracingFilterHelperProvider.getInstance().getOpentracingFilterHelper();
        if (!this.isEnabled(clientRequestContext)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)(methodName + " trace disabled for method"), (Object[])new Object[0]);
            }
            return;
        }
        Tracer tracer = currentTracer.get();
        if (tracer == null) {
            tracer = OpentracingTracerManager.getTracer();
        }
        if (tracer == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " no tracer"), (Object[])new Object[0]);
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{OpentracingUtils.getTracerText(tracer)});
        }
        URI outgoingUri = clientRequestContext.getUri();
        String outgoingURL = outgoingUri.toURL().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " outgoing URL"), (Object[])new Object[]{outgoingURL});
        }
        if (process = true) {
            String buildSpanName = this.helper != null ? this.helper.getBuildSpanName(clientRequestContext) : outgoingURL;
            Tracer.SpanBuilder spanBuilder = tracer.buildSpan(buildSpanName);
            spanBuilder.withTag(Tags.SPAN_KIND.getKey(), "client");
            spanBuilder.withTag(Tags.HTTP_URL.getKey(), outgoingURL);
            spanBuilder.withTag(Tags.HTTP_METHOD.getKey(), clientRequestContext.getMethod());
            spanBuilder.withTag(Tags.COMPONENT.getKey(), TAG_COMPONENT_JAXRS);
            SpanContext parentSpanContext = (SpanContext)clientRequestContext.getProperty("child_of");
            if (parentSpanContext != null) {
                spanBuilder.ignoreActiveSpan().asChildOf(parentSpanContext);
            }
            try {
                Span span = spanBuilder.start();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " span"), (Object[])new Object[]{span});
                }
                Scope scope = null;
                tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new MultivaluedMapToTextMap((MultivaluedMap<String, Object>)clientRequestContext.getHeaders()));
                clientRequestContext.setProperty(CLIENT_CONTINUATION_PROP_ID, (Object)new ActiveSpan(span, scope));
            }
            catch (NoSuchMethodError span) {
                FFDCFilter.processException((Throwable)span, (String)"io.openliberty.opentracing.internal.OpentracingClientFilter", (String)"166", (Object)this, (Object[])new Object[]{clientRequestContext});
                if (!this.spanErrorLogged) {
                    void e;
                    Tr.error((TraceComponent)tc, (String)"OPENTRACING_COULD_NOT_START_SPAN", (Object[])new Object[]{e});
                    this.spanErrorLogged = true;
                }
            }
        } else {
            Span currentSpan = tracer.activeSpan();
            if (currentSpan != null) {
                tracer.inject(currentSpan.context(), Format.Builtin.HTTP_HEADERS, (Object)new MultivaluedMapToTextMap((MultivaluedMap<String, Object>)clientRequestContext.getHeaders()));
            }
        }
        clientRequestContext.setProperty(CLIENT_SPAN_SKIPPED_ID, (Object)(!process ? 1 : 0));
    }

    public void filter(ClientRequestContext clientRequestContext, ClientResponseContext clientResponseContext) throws IOException {
        String methodName = "filter(incoming)";
        this.helper = OpentracingFilterHelperProvider.getInstance().getOpentracingFilterHelper();
        if (!this.isEnabled(clientRequestContext)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)(methodName + " trace disabled for method"), (Object[])new Object[0]);
            }
            return;
        }
        Boolean skip = (Boolean)clientRequestContext.getProperty(CLIENT_SPAN_SKIPPED_ID);
        if (skip != null && skip.booleanValue()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"skipped"});
            }
            clientRequestContext.removeProperty(CLIENT_SPAN_SKIPPED_ID);
            return;
        }
        ActiveSpan activeSpan = (ActiveSpan)clientRequestContext.getProperty(CLIENT_CONTINUATION_PROP_ID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{activeSpan});
        }
        if (activeSpan == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " no continuation span"), (Object[])new Object[0]);
            }
            return;
        }
        clientRequestContext.removeProperty(CLIENT_CONTINUATION_PROP_ID);
        Integer httpStatus = clientResponseContext.getStatus();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " httpStatus"), (Object[])new Object[]{httpStatus});
        }
        Span span = activeSpan.getSpan();
        span.setTag(Tags.HTTP_STATUS.getKey(), (Number)httpStatus);
        if (clientResponseContext.getStatus() >= 400) {
            span.setTag(Tags.ERROR.getKey(), true);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " error"), (Object[])new Object[]{clientResponseContext.getStatus()});
            }
        }
        if (activeSpan.getScope() != null) {
            activeSpan.getScope().close();
        }
        span.finish();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " finish span"), (Object[])new Object[]{span});
        }
    }

    public static Tracer setCurrentTracer(Tracer tracer) {
        Tracer oldTracer = currentTracer.get();
        currentTracer.set(tracer);
        return oldTracer;
    }

    private boolean isEnabled(ClientRequestContext requestContext) {
        Object traceMethod = requestContext.getProperty(CLIENT_FILTER_ENABLED_ID);
        return traceMethod == null || traceMethod == Boolean.TRUE;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class MultivaluedMapToTextMap
    implements TextMap {
        private final MultivaluedMap<String, Object> mvMap;
        static final long serialVersionUID = -7134370512720481331L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public MultivaluedMapToTextMap(MultivaluedMap<String, Object> mvMap) {
            this.mvMap = mvMap;
        }

        @Trivial
        public Iterator<Map.Entry<String, String>> iterator() {
            throw new UnsupportedOperationException();
        }

        @Trivial
        public void put(String key, String value) {
            this.mvMap.add((Object)key, (Object)value);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.opentracing.internal.OpentracingClientFilter$MultivaluedMapToTextMap", MultivaluedMapToTextMap.class, (String)"OPENTRACING", (String)"io.openliberty.opentracing.internal.resources.Opentracing");
        }
    }
}

