/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.routing.member.internal;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.servlet.container.WebContainer;
import com.ibm.ws.collective.routing.member.VHostChangeListener;
import com.ibm.ws.collective.routing.member.VHostRoutingInfoManager;
import com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfo;
import com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfoMBeanImpl;
import com.ibm.ws.collective.routing.member.internal.CollectiveServletContextListener;
import com.ibm.ws.collective.routing.member.internal.HttpSessionPublishListener;
import com.ibm.ws.collective.routing.member.internal.WebModuleRoutingInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.ModuleMetaDataListener;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.FeatureProvisioner;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ModuleMetaDataListener.class, AllServiceListener.class, ApplicationStateListener.class}, property={"service.vendor=IBM", "includeAppsWithoutConfig=true"})
public class ApplicationRoutingInfoPublisher
implements ModuleMetaDataListener,
ApplicationStateListener,
AllServiceListener,
NotificationListener,
VHostChangeListener {
    private static final TraceComponent tc = Tr.register(ApplicationRoutingInfoPublisher.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
    private FeatureProvisioner provisionerService;
    private HttpSessionPublishListener httpSessionPublishListener;
    private final ConcurrentHashMap<String, ApplicationRouting> applicationRoutingMap = new ConcurrentHashMap();
    private final Object ariUpdatedOrCreated_lock = new Object(){
        static final long serialVersionUID = 6778557605091141864L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfoPublisher$1", 1.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
        }
    };
    private final AtomicServiceReference<ExecutorService> executorService = new AtomicServiceReference("executorService");
    BundleContext bundleContext = null;
    private final AtomicReference<VHostRoutingInfoManager> vhostRoutingInfoManagerRef = new AtomicReference();
    private boolean collectiveController = false;
    static final long serialVersionUID = 6680706841255633211L;

    /*
     * WARNING - void declaration
     */
    @Activate
    protected void activate(ComponentContext context) {
        block3: {
            this.bundleContext = context.getBundleContext();
            try {
                this.bundleContext.addServiceListener((ServiceListener)this, "(jmx.objectname=*com.ibm.websphere.application.ApplicationMBean*)");
                ClassLoader cl = ThreadContextHelper.getContextClassLoader();
                ThreadContextHelper.setClassLoader((ClassLoader)this.getClass().getClassLoader());
                WebContainer.addGlobalListener((String)"com.ibm.ws.collective.routing.member.internal.CollectiveServletContextListener");
                ThreadContextHelper.setClassLoader((ClassLoader)cl);
                CollectiveServletContextListener.attachApplicationRoutingInfoPublisher(this);
                Set installedFeatures = this.provisionerService.getInstalledFeatures();
                if (installedFeatures.contains("collectiveController-1.0")) {
                    Tr.debug((TraceComponent)tc, (String)"activate: Detected collective controller server. collectiveController = true", (Object[])new Object[0]);
                    this.collectiveController = true;
                }
            }
            catch (InvalidSyntaxException cl) {
                void e;
                FFDCFilter.processException((Throwable)cl, (String)"com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfoPublisher", (String)"113", (Object)this, (Object[])new Object[]{context});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("activate error " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.bundleContext = context.getBundleContext();
        this.bundleContext.removeServiceListener((ServiceListener)this);
        CollectiveServletContextListener.attachApplicationRoutingInfoPublisher(null);
        this.bundleContext = null;
    }

    @Reference(service=FeatureProvisioner.class)
    protected void setKernelProvisioner(FeatureProvisioner provisionerService) {
        this.provisionerService = provisionerService;
    }

    protected void unsetKernelProvisioner(FeatureProvisioner provisionerService) {
        this.provisionerService = null;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.RELUCTANT)
    protected void setHttpSessionPublishListener(HttpSessionPublishListener service) {
        if (FrameworkState.isStopping()) {
            return;
        }
        this.httpSessionPublishListener = service;
        this.httpSessionPublishListener.registerListener(this);
    }

    protected void unsetHttpSessionPublishListener(HttpSessionPublishListener service) {
        service.unregisterListener();
        this.httpSessionPublishListener = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setVHostRoutingInfoManager(VHostRoutingInfoManager service) {
        if (FrameworkState.isStopping()) {
            return;
        }
        this.vhostRoutingInfoManagerRef.set(service);
        service.addVHostChangeListener(this);
        UpdateApplicationRouting updateApplicationRouting = new UpdateApplicationRouting(service.getVirtualHosts());
        ExecutorService es = (ExecutorService)this.executorService.getService();
        if (es != null) {
            es.submit(updateApplicationRouting);
        } else {
            Tr.debug((TraceComponent)tc, (String)"setVHostRoutingInfoManager: updateApplicationRouting running on current thread", (Object[])new Object[0]);
            updateApplicationRouting.run();
        }
    }

    protected void unsetVHostRoutingInfoManager(VHostRoutingInfoManager service) {
        this.vhostRoutingInfoManagerRef.compareAndSet(service, null);
        service.removeVHostChangeListener(this);
    }

    @Reference(name="executorService", service=ExecutorService.class, policy=ReferencePolicy.DYNAMIC)
    protected void setExecutorService(ServiceReference<ExecutorService> executorService) {
        this.executorService.setReference(executorService);
        VHostRoutingInfoManager vhostRoutingInfoManagerInstance = this.vhostRoutingInfoManagerRef.get();
        ExecutorService es = (ExecutorService)this.executorService.getService();
        if (es != null && vhostRoutingInfoManagerInstance != null) {
            es.submit(new UpdateApplicationRouting(vhostRoutingInfoManagerInstance.getVirtualHosts()));
        }
    }

    protected void unsetExecutorService(ServiceReference<ExecutorService> executorService) {
        this.executorService.unsetReference(executorService);
    }

    public void moduleMetaDataCreated(MetaDataEvent<ModuleMetaData> event) throws MetaDataException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && event == null) {
            Tr.debug((TraceComponent)tc, (String)"ModuleMetaData event provided was null", (Object[])new Object[0]);
            return;
        }
        if (event.getMetaData() instanceof WebModuleMetaData) {
            WebModuleMetaData webModuleMetaData = (WebModuleMetaData)event.getMetaData();
            Container container = event.getContainer();
            ApplicationRouting applicationRouting = this.getApplicationRouting(webModuleMetaData);
            if (applicationRouting != null) {
                applicationRouting.addWebModuleMetaData(webModuleMetaData, container);
            } else {
                applicationRouting = new ApplicationRouting(webModuleMetaData, container);
                this.applicationRoutingMap.put(webModuleMetaData.getJ2EEName().getApplication(), applicationRouting);
            }
            applicationRouting.publishApplicationRoutingMbean();
        } else {
            Tr.debug((TraceComponent)tc, (String)("ModuleMetaData event provided is not an instance of WebModuleMetaData (" + ((ModuleMetaData)event.getMetaData()).getJ2EEName().getApplication() + ")"), (Object[])new Object[0]);
        }
    }

    public void moduleMetaDataDestroyed(MetaDataEvent<ModuleMetaData> event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && event == null) {
            Tr.debug((TraceComponent)tc, (String)"ModuleMetaData event provided was null", (Object[])new Object[0]);
            return;
        }
        if (event.getMetaData() instanceof WebModuleMetaData) {
            WebModuleMetaData webModuleMetaData = (WebModuleMetaData)event.getMetaData();
            ApplicationRouting applicationRouting = this.getApplicationRouting(webModuleMetaData);
            if (applicationRouting != null) {
                applicationRouting.removeWebModuleMetaData(webModuleMetaData);
            }
        } else {
            Tr.debug((TraceComponent)tc, (String)("ModuleMetaData event provided is not an instance of WebModuleMetaData (" + ((ModuleMetaData)event.getMetaData()).getJ2EEName().getApplication() + ")"), (Object[])new Object[0]);
        }
    }

    public void applicationStarted(ApplicationInfo applicationInfo) throws StateChangeException {
        if (FrameworkState.isStopping()) {
            return;
        }
        String applicationName = applicationInfo.getDeploymentName();
        if (null == applicationName) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"applicationStarted is not continuing because the ApplicationInfo object does not contain a deployment name.", (Object[])new Object[0]);
            }
            return;
        }
        ApplicationRouting applicationRouting = this.getApplicationRouting(applicationInfo);
        if (applicationRouting != null) {
            applicationRouting.setApplicationInfo(applicationInfo);
        } else {
            applicationRouting = new ApplicationRouting(applicationInfo);
            this.applicationRoutingMap.put(applicationInfo.getDeploymentName(), applicationRouting);
        }
        applicationRouting.setApplicationStarted(true);
        applicationRouting.publishApplicationRoutingMbean();
    }

    public void applicationStopped(ApplicationInfo applicationInfo) {
        if (FrameworkState.isStopping()) {
            return;
        }
        String appName = applicationInfo.getDeploymentName();
        if (null == appName) {
            Tr.debug((TraceComponent)tc, (String)("Application name was null, can't associate this event with any installed applications: " + applicationInfo.getName()), (Object[])new Object[0]);
            return;
        }
        ApplicationRouting applicationRouting = this.getApplicationRouting(applicationInfo);
        if (applicationRouting != null) {
            applicationRouting.setApplicationStarted(false);
        }
        if (this.bundleContext != null) {
            try {
                ServiceReference[] serviceReferences = this.bundleContext.getAllServiceReferences(null, "(&(jmx.objectname=*com.ibm.websphere.application.ApplicationMBean*)(&(name=" + appName + ")))");
                if (serviceReferences == null) {
                    Tr.debug((TraceComponent)tc, (String)("The web application " + appName + " has been stopped, and no ApplicationMBean can be found for it.  It is assumed to be a System WAB and it's application routing information is being removed."), (Object[])new Object[0]);
                    this.uninstallApplication(appName);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfoPublisher", (String)"320", (Object)this, (Object[])new Object[]{applicationInfo});
            }
        }
    }

    public void servletContextInitialized(String applicationName) {
        ApplicationRouting applicationRouting = this.applicationRoutingMap.get(applicationName);
        if (applicationRouting == null) {
            applicationRouting = new ApplicationRouting(applicationName);
            this.applicationRoutingMap.put(applicationName, applicationRouting);
        }
        Tr.debug((TraceComponent)tc, (String)("servletContextInitialized: applicationName: " + applicationName), (Object[])new Object[0]);
        applicationRouting.publishApplicationRoutingMbean();
    }

    public void servletContextDestroyed(String applicationName) {
        if (FrameworkState.isStopping()) {
            return;
        }
        if (applicationName == null) {
            Tr.debug((TraceComponent)tc, (String)("Application name was null, can't associate this event with any installed applications: " + applicationName), (Object[])new Object[0]);
            return;
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (4 == event.getType()) {
            ServiceReference sr = event.getServiceReference();
            String appName = (String)sr.getProperty("name");
            this.uninstallApplication(appName);
        }
    }

    private void uninstallApplication(String applicationName) {
        ApplicationRouting applicationRouting = this.applicationRoutingMap.remove(applicationName);
        if (applicationRouting != null) {
            applicationRouting.removeApplicationRoutingMbean();
        }
    }

    @Override
    public void onVhostChange(String vhostName, String[] oldAliases, String[] newAliases) {
        if (null == vhostName) {
            return;
        }
        if (FrameworkState.isStopping()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Skipping update of vhost data due to server in stopping state", (Object[])new Object[0]);
            }
            return;
        }
        VHostRoutingInfoManager vhostRoutingInfoManagerInstance = this.vhostRoutingInfoManagerRef.get();
        if (vhostRoutingInfoManagerInstance != null) {
            for (Map.Entry<String, ApplicationRouting> applicationRouting : this.applicationRoutingMap.entrySet()) {
                applicationRouting.getValue().updateApplicationvHostReferences(vhostRoutingInfoManagerInstance.getVirtualHosts());
                applicationRouting.getValue().publishApplicationRoutingMbean();
            }
        }
    }

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
    }

    private ApplicationRouting getApplicationRouting(WebModuleMetaData webModuleMetaData) {
        return this.applicationRoutingMap.get(webModuleMetaData.getJ2EEName().getApplication());
    }

    private ApplicationRouting getApplicationRouting(ApplicationInfo applicationInfo) {
        return this.applicationRoutingMap.get(applicationInfo.getDeploymentName());
    }

    public void httpSessionOptionsPublished() {
        VHostRoutingInfoManager vhostRoutingInfoManagerInstance = this.vhostRoutingInfoManagerRef.get();
        if (vhostRoutingInfoManagerInstance == null) {
            return;
        }
        ExecutorService es = (ExecutorService)this.executorService.getService();
        UpdateApplicationRouting updateApplicationRouting = new UpdateApplicationRouting(vhostRoutingInfoManagerInstance.getVirtualHosts());
        if (es != null) {
            es.submit(updateApplicationRouting);
        } else {
            Tr.debug((TraceComponent)tc, (String)"httpSessionOptionsPublished: updateApplicationRouting running on current thread", (Object[])new Object[0]);
            updateApplicationRouting.run();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private final class UpdateApplicationRouting
    implements Runnable {
        private final Map<String, Collection<String>> virtualHostsMap;
        static final long serialVersionUID = 3933954746402194985L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public UpdateApplicationRouting(Map<String, Collection<String>> virtualHostsMap) {
            this.virtualHostsMap = virtualHostsMap;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            for (Map.Entry applicationRoutingEntry : ApplicationRoutingInfoPublisher.this.applicationRoutingMap.entrySet()) {
                ApplicationRouting applicationRouting = (ApplicationRouting)applicationRoutingEntry.getValue();
                try {
                    applicationRouting.updateApplicationvHostReferences(this.virtualHostsMap);
                    applicationRouting.publishApplicationRoutingMbean();
                }
                catch (Throwable throwable) {
                    void t;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfoPublisher$UpdateApplicationRouting", (String)"454", (Object)this, (Object[])new Object[0]);
                    Tr.error((TraceComponent)tc, (String)("Caught exception while updating virtualHost or publishing: " + applicationRouting.getApplicationName()), (Object[])new Object[]{t});
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfoPublisher$UpdateApplicationRouting", UpdateApplicationRouting.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class ApplicationRouting {
        private String applicationName;
        private J2EEName j2eeName;
        private ApplicationInfo applicationInfo;
        private final ConcurrentLinkedQueue<WebModule> webModuleList = new ConcurrentLinkedQueue();
        private boolean applicationStarted = false;
        private ApplicationRoutingInfo applicationRoutingInfo;
        private String applicationRoutingInfoDigest;
        private ApplicationRoutingInfoMBeanImpl applicationRoutingInfoMBean;
        static final long serialVersionUID = 8198436594974653818L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ApplicationRouting(String applicationName) {
            this.applicationName = applicationName;
        }

        public ApplicationRouting(ApplicationInfo applicationInfo) {
            this.applicationInfo = applicationInfo;
            this.j2eeName = ((ExtendedApplicationInfo)applicationInfo).getMetaData().getJ2EEName();
            this.applicationName = applicationInfo.getDeploymentName();
        }

        public ApplicationRouting(WebModuleMetaData webModuleMetaData, Container webModuleContainer) {
            this.j2eeName = webModuleMetaData.getJ2EEName();
            this.webModuleList.add(new WebModule(webModuleMetaData, webModuleContainer));
        }

        public boolean isApplicationStarted() {
            return this.applicationStarted;
        }

        public void updateApplicationvHostReferences(Map<String, Collection<String>> virtualHosts) {
            for (WebModule webModule : this.webModuleList) {
                webModule.updateVhostWebModuleRoutingInfo(virtualHosts);
            }
        }

        public void removeWebModuleMetaData(WebModuleMetaData webModuleMetaData) {
            for (WebModule webModule : this.webModuleList) {
                if (webModule.getWebModuleMetaData() != webModuleMetaData) continue;
                this.webModuleList.remove(webModule);
                Tr.debug((TraceComponent)tc, (String)("Removed webModule: " + webModule + ", which contained webModuleMetaData: " + webModuleMetaData), (Object[])new Object[0]);
                break;
            }
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public void addWebModuleMetaData(WebModuleMetaData webModuleMetaData, Container webModuleContainer) {
            this.removeWebModuleMetaData(webModuleMetaData);
            this.j2eeName = webModuleMetaData.getJ2EEName();
            this.webModuleList.add(new WebModule(webModuleMetaData, webModuleContainer));
        }

        private boolean canPublishApplicationRoutingMbean() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("applicationName: " + this.applicationName + ", webModule: " + this.webModuleList + ", applicationInfo: " + this.applicationInfo + ", applicationStarted: " + this.applicationStarted + ", servletsContextInitialized: " + this.isServletsContextInitialized() + ", httpSessionOptionsPublished: " + this.isHttpSessionOptionsPublished()), (Object[])new Object[0]);
            }
            return !this.webModuleList.isEmpty() && this.applicationInfo != null && this.applicationStarted && this.isServletsContextInitialized() && this.isHttpSessionOptionsPublished();
        }

        private boolean isHttpSessionOptionsPublished() {
            return ApplicationRoutingInfoPublisher.this.collectiveController || ApplicationRoutingInfoPublisher.this.httpSessionPublishListener.isHttpSessionOptionsPublished();
        }

        public boolean isApplicationRoutingMbeanPublished() {
            return this.applicationRoutingInfoMBean != null;
        }

        public boolean isServletsContextInitialized() {
            for (WebModule webModule : this.webModuleList) {
                Tr.debug((TraceComponent)tc, (String)("isServletsContextInitialized: webModule: " + webModule + ", isServletContextInitialized: " + webModule.isServletContextInitialized()), (Object[])new Object[0]);
                if (webModule.isServletContextInitialized()) continue;
                return false;
            }
            return true;
        }

        public void setApplicationInfo(ApplicationInfo applicationInfo) {
            this.applicationInfo = applicationInfo;
            this.applicationName = applicationInfo.getDeploymentName();
            this.j2eeName = ((ExtendedApplicationInfo)applicationInfo).getMetaData().getJ2EEName();
        }

        public boolean getApplicationStarted() {
            return this.applicationStarted;
        }

        public void setApplicationStarted(boolean applicationStarted) {
            this.applicationStarted = applicationStarted;
        }

        public List<WebModuleRoutingInfo> getWebModuleRoutingInfo(Map<String, Collection<String>> virtualHostsMap) {
            ArrayList<WebModuleRoutingInfo> webModuleRoutingInfoList = new ArrayList<WebModuleRoutingInfo>();
            for (WebModule webModule : this.webModuleList) {
                webModuleRoutingInfoList.add(webModule.getWebModuleRoutingInfo(virtualHostsMap));
            }
            return webModuleRoutingInfoList;
        }

        public boolean isRoutable() {
            for (WebModule webModule : this.webModuleList) {
                if (!webModule.isRoutable()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void publishApplicationRoutingMbean() throws IllegalStateException {
            if (ApplicationRoutingInfoPublisher.this.vhostRoutingInfoManagerRef == null) {
                Tr.debug((TraceComponent)tc, (String)"publishApplicationRoutingMbean: vhostRoutingInfoManagerRef == null", (Object[])new Object[0]);
                return;
            }
            VHostRoutingInfoManager vhostRoutingInfoManagerInstance = (VHostRoutingInfoManager)ApplicationRoutingInfoPublisher.this.vhostRoutingInfoManagerRef.get();
            if (vhostRoutingInfoManagerInstance == null) {
                Tr.debug((TraceComponent)tc, (String)"publishApplicationRoutingMbean: vhostRoutingInfoManagerInstance == null", (Object[])new Object[0]);
                return;
            }
            Map<String, Collection<String>> virtualHostsMap = vhostRoutingInfoManagerInstance.getVirtualHosts();
            if (virtualHostsMap == null) {
                throw new IllegalStateException("Missing criteria to publish application routing mbean. virtualHostsMap is null.");
            }
            if (!this.canPublishApplicationRoutingMbean()) {
                Tr.debug((TraceComponent)tc, (String)("Missing criteria to publish application routing mbean. applicationName: " + this.applicationName + ", webModule: " + this.webModuleList + ", applicationInfo: " + this.applicationInfo + ", applicationStarted: " + this.applicationStarted + ", servletsContextInitialized: " + this.isServletsContextInitialized() + ", httpSessionOptionsPublished:" + this.isHttpSessionOptionsPublished()), (Object[])new Object[0]);
                return;
            }
            Object object = ApplicationRoutingInfoPublisher.this.ariUpdatedOrCreated_lock;
            synchronized (object) {
                if (this.applicationRoutingInfo == null) {
                    Tr.debug((TraceComponent)tc, (String)("publishApplicationRoutingMbean: applicationRoutingInfo New: applicationName: " + this.applicationName + ", size: " + this.getWebModuleRoutingInfo(virtualHostsMap).size() + ", isRoutable():" + this.isRoutable()), (Object[])new Object[0]);
                    try {
                        if (!this.isRoutable()) return;
                        this.applicationRoutingInfo = new ApplicationRoutingInfo(this.j2eeName, this.getWebModuleRoutingInfo(virtualHostsMap));
                        this.applicationRoutingInfoDigest = this.applicationRoutingInfo.getDigest();
                        this.applicationRoutingInfoMBean = new ApplicationRoutingInfoMBeanImpl(this.applicationRoutingInfo);
                        this.applicationRoutingInfoMBean.register();
                        if (!TraceComponent.isAnyTracingEnabled()) return;
                        if (!tc.isDebugEnabled()) return;
                        Tr.debug((TraceComponent)tc, (String)("Creating new MBean for ApplicationRoutingInfo =  " + this.applicationRoutingInfo + ", application: " + this.applicationRoutingInfo.getApplicationName() + ", j2eeName Application: " + this.applicationRoutingInfo.getJ2EEName().getApplication()), (Object[])new Object[0]);
                    }
                    catch (NotCompliantMBeanException notCompliantMBeanException) {
                        void e;
                        FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfoPublisher$ApplicationRouting", (String)"656", (Object)this, (Object[])new Object[0]);
                        if (!TraceComponent.isAnyTracingEnabled()) return;
                        if (!tc.isDebugEnabled()) return;
                        Tr.debug((TraceComponent)tc, (String)("Error registering ApplicationRoutingInfoMBean " + e.getMessage()), (Object[])new Object[0]);
                    }
                } else {
                    this.applicationRoutingInfo.update(this.getWebModuleRoutingInfo(virtualHostsMap));
                    Tr.debug((TraceComponent)tc, (String)("publishApplicationRoutingMbean: applicationRoutingInfo Update: applicationName: " + this.applicationName + ", size: " + this.getWebModuleRoutingInfo(virtualHostsMap).size() + ", isRoutable(virtualHostsMap): " + this.isRoutable()), (Object[])new Object[0]);
                    if (this.applicationRoutingInfo.getDigest().equals(this.applicationRoutingInfoDigest)) return;
                    this.applicationRoutingInfoDigest = this.applicationRoutingInfo.getDigest();
                    Tr.debug((TraceComponent)tc, (String)"publishApplicationRoutingMbean: digest has changed.", (Object[])new Object[0]);
                    if (this.isRoutable()) {
                        if (this.applicationRoutingInfoMBean != null) {
                            this.applicationRoutingInfoMBean.update(this.applicationRoutingInfo);
                            if (!TraceComponent.isAnyTracingEnabled()) return;
                            if (!tc.isDebugEnabled()) return;
                            Tr.debug((TraceComponent)tc, (String)("Updating MBean for ApplicationRoutingInfo =  " + this.applicationRoutingInfo), (Object[])new Object[0]);
                        } else {
                            try {
                                this.applicationRoutingInfoMBean = new ApplicationRoutingInfoMBeanImpl(this.applicationRoutingInfo);
                                this.applicationRoutingInfoMBean.register();
                                if (!TraceComponent.isAnyTracingEnabled()) return;
                                if (!tc.isDebugEnabled()) return;
                                Tr.debug((TraceComponent)tc, (String)("Creating new MBean for ApplicationRoutingInfo after restart of the application =  " + this.applicationRoutingInfo), (Object[])new Object[0]);
                            }
                            catch (NotCompliantMBeanException e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfoPublisher$ApplicationRouting", (String)"689", (Object)this, (Object[])new Object[0]);
                                if (!TraceComponent.isAnyTracingEnabled()) return;
                                if (!tc.isDebugEnabled()) return;
                                Tr.debug((TraceComponent)tc, (String)("Error registering ApplicationRoutingInfoMBean on application restart " + e.getMessage()), (Object[])new Object[0]);
                            }
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("No modules enabled for routing in app =  " + this.applicationRoutingInfo.getApplicationName() + " ... unregister MBean"), (Object[])new Object[0]);
                        }
                        this.removeApplicationRoutingMbean();
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeApplicationRoutingMbean() {
            Object object = ApplicationRoutingInfoPublisher.this.ariUpdatedOrCreated_lock;
            synchronized (object) {
                if (this.applicationRoutingInfoMBean != null) {
                    this.applicationRoutingInfoMBean.unregister();
                    Tr.debug((TraceComponent)tc, (String)("MBean associated with " + this.applicationRoutingInfo.getApplicationName() + " unregistered successfully"), (Object[])new Object[0]);
                    this.applicationRoutingInfoMBean = null;
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfoPublisher$ApplicationRouting", ApplicationRouting.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class WebModule {
        private final WebModuleMetaData webModuleMetaData;
        private final Container webModuleContainer;
        private WebModuleRoutingInfo webModuleRoutingInfo;
        private final J2EEName j2eeName;
        private final String applicationName;
        static final long serialVersionUID = 9047628005152668904L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public WebModule(WebModuleMetaData webModuleMetaData, Container webModuleContainer) {
            this.webModuleMetaData = webModuleMetaData;
            this.webModuleContainer = webModuleContainer;
            this.j2eeName = webModuleMetaData.getJ2EEName();
            this.applicationName = this.j2eeName.getApplication();
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public boolean isServletContextInitialized() {
            Tr.debug((TraceComponent)tc, (String)"isServletContextInitialized", (Object[])new Object[0]);
            WebAppConfiguration webAppConfiguration = (WebAppConfiguration)this.webModuleMetaData.getConfiguration();
            Tr.debug((TraceComponent)tc, (String)("setServletContextInitialized: " + webAppConfiguration), (Object[])new Object[0]);
            if (webAppConfiguration != null && webAppConfiguration.getSessionCookieConfig() != null) {
                Tr.debug((TraceComponent)tc, (String)("setServletContextInitialized: applicationName: " + this.applicationName + ", initialized: true"), (Object[])new Object[0]);
                return true;
            }
            Tr.debug((TraceComponent)tc, (String)("setServletContextInitialized: applicationName: " + this.applicationName + ", initialized : false"), (Object[])new Object[0]);
            return false;
        }

        public WebModuleMetaData getWebModuleMetaData() {
            return this.webModuleMetaData;
        }

        public Container getwebModuleContainer() {
            return this.webModuleContainer;
        }

        public void updateVhostWebModuleRoutingInfo(Map<String, Collection<String>> virtualHostsMap) {
            if (this.webModuleRoutingInfo != null) {
                this.webModuleRoutingInfo.updateVhosts(virtualHostsMap);
            }
        }

        public WebModuleRoutingInfo getWebModuleRoutingInfo(Map<String, Collection<String>> virtualHostsMap) {
            if (this.webModuleRoutingInfo != null) {
                this.webModuleRoutingInfo.update(this.webModuleMetaData, this.webModuleContainer, virtualHostsMap);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Updated WebModuleInfo for " + this.webModuleMetaData.getJ2EEName()), (Object[])new Object[0]);
                }
            } else {
                this.webModuleRoutingInfo = new WebModuleRoutingInfo(this.webModuleMetaData, this.webModuleContainer, virtualHostsMap);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Created WebModuleInfo for " + this.webModuleMetaData.getJ2EEName()), (Object[])new Object[0]);
                }
            }
            return this.webModuleRoutingInfo;
        }

        public boolean isRoutable() {
            return this.webModuleRoutingInfo.getJsonRepresentation().size() > 0;
        }

        public String toString() {
            return this.webModuleMetaData.getJ2EEName().getApplication() + "#" + this.webModuleMetaData.getName();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfoPublisher$WebModule", WebModule.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
        }
    }
}

