
 /********************************************************************************
* Licensed Materials - Property of IBM                                         *
* (C) Copyright IBM Corp. 2015, 2023.  All Rights Reserved.                          *
*                                                                              *
* US Government Users Restricted Rights - Use, duplication or disclosure       *
* restricted by GSA ADP Schedule Contract with IBM Corp.                       *
********************************************************************************/
		document.addEventListener('DOMContentLoaded', function() {
			
			var getDocHeight = function() {
				var D = document;
				return Math.max(D.body.scrollHeight, D.documentElement.scrollHeight, D.body.offsetHeight, D.documentElement.offsetHeight, D.body.clientHeight, D.documentElement.clientHeight);
			}
			var scrollToAnchor = function(link, isConnSummary) {
				var getBoundsTop, duration, chosenElement;

				if (isConnSummary) {
					chosenElement = document.getElementById(link);
					getBoundsTop = chosenElement.getBoundingClientRect().top;
					duration = 500;
				} else {
					chosenElement = document.querySelector('#' + link);
					getBoundsTop = chosenElement.getBoundingClientRect().top;
					duration = arguments.length <= 1 || arguments[1] === undefined ? 500 : arguments[1];
				}

				var mili = 15,
					scrollPosition = window.scrollY,
					scrollTarget = scrollPosition + (getBoundsTop - 44),
					scrollCount = 0,
					scrollStep = Math.PI / (duration / mili),
					scrollDirection = scrollTarget > scrollPosition ? 1 : -1,
					cosParameter = Math.abs(scrollTarget - scrollPosition) / 2,
					docHeight = getDocHeight(),
					marginOfError = Math.ceil(cosParameter - cosParameter * Math.cos(1 * scrollStep)),
					scrollMargin;

				var scrollInterval = setInterval(function() {
					var reachedEdge = scrollDirection > 0 ? window.scrollY + window.innerHeight >= docHeight - 1 : window.scrollY < 1;

					if (Math.abs(scrollTarget - window.scrollY) > marginOfError && !reachedEdge) {
						scrollCount += 1;
						scrollMargin = cosParameter - cosParameter * Math.cos(scrollCount * scrollStep);
						window.scrollTo(0, scrollPosition + scrollMargin * scrollDirection);
					} else {
						clearInterval(scrollInterval);

						if (isConnSummary) {
							chosenElement.classList.add('shake');
							chosenElement.classList.add('is-paused');

							setTimeout(function() {
								chosenElement.classList.remove('is-paused');
							}, 0);
						}
					}
				}, mili);
			};

			var browserVersion = detectIE();

			// Shared Variables
			var navHeight = 44;
			var recommendationItems = document.getElementsByClassName('recommendation-toggle');
            		var recommendationHelp = document.getElementsByClassName('recommendation-toggle-help');
            		var recommendationDetails = document.getElementsByClassName('recommendation-toggle-results');					
			var hasClass = function(el, cls) {
				return el != null && el.className && new RegExp("(\\s|^)" + cls + "(\\s|$)").test(el.className);
			};

           var checkForOpenFixesResults = function ( ) {
                // Check count if rule fix and rule results section are open
                var currentVisibleRuleFix = document.querySelectorAll('.rule-fix.show').length;
                var currentVisibleRuleResult = document.querySelectorAll('.rule-result.show').length;

                if ( currentVisibleRuleFix === 0 && currentVisibleRuleResult === 0 ) {
                    return true;
                } else {
                    return false;
                }
            };

			var checkForOpenArchiveDetails = function() {
				// Check if any archive details sections are open
				var currentVisibleArchive = document.querySelectorAll('.archive-details.show').length;

				if (currentVisibleArchive === 0) {
					return true;
				} else {
					return false;
				}
			};
			var toggleHideShowClasses = function(el, isTrue, subStringForHide, subStringForShow) {
				var stringForHide = subStringForHide || 'hide';
				var stringForShow = subStringForShow || 'show';

				if (isTrue) {
					el.classList.remove(stringForHide);
					el.classList.add(stringForShow);
				} else {
					el.classList.remove(stringForShow);
					el.classList.add(stringForHide);
				}
			};


			// Jump To Item
			var jumpToItems = document.querySelectorAll('.jump-item');
            var innerList = document.querySelectorAll('.inner--list--hide')[0];
            var archiveScrollBy = function(e) {
				e.preventDefault();

				var appId,
					appArchive,
					id,
					archiveDetail,
					archiveDetailCurrentLocation,
					archiveDetailTop,
					scrollToPosition,
					anchor = e.target.closest('a');

                if (anchor.tagName === "SPAN") {
                	anchor = anchor.parentElement;
                }

				var resultsSection, isHidden, archiveAnchor;

				if (anchor.href) {
					id = anchor.href.split('#')[1];
					archiveDetail = document.getElementById(id);

					if (hasClass(archiveDetail,'archive')) {
						resultsSection = archiveDetail.querySelector('.archive-details');
						isHidden = hasClass(resultsSection, 'hide');

						if (isHidden) {
							toggleHideShowClasses(resultsSection, isHidden);
							archiveAnchor = resultsSection.previousElementSibling.querySelector('.archive-toggle');
							archiveAnchor.text = "CLOSE_DETAILS";

							// we want to the opposite of the function
							// because it will return true if all closed
							if (!checkForOpenArchiveDetails() && hasClass(collapseAnchor, 'disabled')) {
								collapseAnchor.classList.remove('disabled');
							}
						}
					} else if (archiveDetail.tagName === "H2" || archiveDetail.tagName === "H3" || archiveDetail.tagName === "H4" || hasClass(archiveDetail,'rule')) {
						appId = id.split('_')[0];
						appArchive = document.getElementById(appId);

						if(appArchive != null) {
							if (hasClass(appArchive,'archive')) {
								resultsSection = appArchive.querySelector('.archive-details');
								isHidden = hasClass(resultsSection, 'hide');
	
								if (isHidden) {
									toggleHideShowClasses(resultsSection, isHidden);
									archiveAnchor = resultsSection.previousElementSibling.querySelector('.archive-toggle');
									archiveAnchor.text = "CLOSE_DETAILS";
	
									// we want to the opposite of the function
									// because it will return true if all closed
									if (!checkForOpenArchiveDetails() && hasClass(collapseAnchor, 'disabled')) {
										collapseAnchor.classList.remove('disabled');
									}
								}
							}
						}

					}
					
					if (browserVersion) {
						archiveDetailCurrentLocation = archiveDetail.getBoundingClientRect();
						archiveDetailTop = archiveDetailCurrentLocation.top;
						scrollToPosition = archiveDetailTop - navHeight;
						
						window.scrollBy(0, scrollToPosition);
					} else {
						scrollToAnchor(id);
					}
                    
                    innerList.style.display = 'none';
                    
                    setTimeout(function() {
                    	innerList.removeAttribute('style');
                    }, 1000);
				}
			};

			for (var h = 0; h < jumpToItems.length; h++) {
				var jumpToItem = jumpToItems[h];
				jumpToItem.addEventListener('click', archiveScrollBy, false);
			}

			// Toggle Fixed/Non-Fixed Jump To
			var scrolledElement = document.querySelector('.nav-wrapper');
			var listener = function() {
				var y = window.pageYOffset;
				var container = document.getElementById("reportContainer")
				if(container) {
					var toBeFixed = y >= 490;
					toggleHideShowClasses(scrolledElement, toBeFixed, 'na-fixed', 'fixed-in-bluemix');
					var jumpBox = document.getElementsByClassName('jump-to-nav');
					if(toBeFixed) {//align the jump to box to the right end of the js-rule-severity rather than using
						//using a percent to alignment will always be accurate reqargless of the size of the window
						jumpBox[0].style.right = document.getElementById("js-rule-severity").getBoundingClientRect().left+'px';
					} else {
						jumpBox[0].removeAttribute('style');
					}
				} else {
					var scrolledElementClientRect = scrolledElement.getBoundingClientRect();
					var top = scrolledElementClientRect.top;
					var toBeFixed = y >= top;
					toggleHideShowClasses(scrolledElement, toBeFixed, 'na-fixed', 'fixed');
				}
			};

			window.addEventListener('scroll', listener, false);


           // Toggle Hidden Rows in Connectivity Summary
            var plus = '+', minus = '-';
            var activeCell = document.querySelectorAll('.summary .col1summarymodule, .summary .col1summarymodule .status');
            var summaryRows = document.querySelectorAll('.summary');
            var hiddenRows = document.querySelectorAll('[id^="rowHiddenMod"]');
            var toggleHiddenRows = function ( e ) {
                e.preventDefault();
                e.stopPropagation();

                var target;
                if ( e.target.tagName === 'SPAN' ) {
                    target = e.target.parentElement.parentElement;
                } else {
                    target = e.target.parentElement;
                }

                for (var m = 0; m < summaryRows.length; m++) {
                    if ( target === summaryRows[m] ) {
                        var plusMinus;
                        var hiddenRowIdx = m + 1;
                        var targetClass = '[id^="rowHiddenMod' + hiddenRowIdx + '"]';
                        var neededRows = document.querySelectorAll(targetClass);

                        for (var n = 0; n < neededRows.length; n++) {
                            var targetRow = neededRows[n];
                            var isExpanded = hasClass(targetRow, 'visibleRow');

                            toggleHideShowClasses(targetRow, !isExpanded, 'hiddenRow', 'visibleRow');

                            if ( isExpanded ) {
                                if ( n === 0 ) {
                                    plusMinus = targetRow.previousElementSibling.querySelector('.status');
                                    plusMinus.textContent = plus;
                                }
                            } else {
                                if ( n === 0 ) {
                                    plusMinus = targetRow.previousElementSibling.querySelector('.status');
                                    plusMinus.textContent = minus;
                                }

                                var innerTDs = targetRow.querySelectorAll('.col2thru12 a');
                                for (var p = 0; p < innerTDs.length; p++) {
                                    var innerTD = innerTDs[p];

                                    innerTD.addEventListener('click', showTable, false);
                                }
                            }
                        }
                    }
                }
            };

            for (var l = 0; l < activeCell.length; l++) {
                var cell = activeCell[l];
                cell.addEventListener('click', toggleHiddenRows, false);
            }

            // Link Headers to Results from Connectivity Summary
            var connectivitySummaryHeader = document.querySelectorAll('.connectivity-summary .results th a');
            var showTableFromHeader = function ( e ) {
                // use preventDefault to allow us to use window.scrollBy
                e.preventDefault();

                var id, table, resultsSection,
                    target = e.target;

                if ( target.href ) {
                    id = target.href.split('#')[1];
                    table = document.getElementById(id);
 
                    if (browserVersion) {
                        var navCurrentLocation = table.getBoundingClientRect();
                        navCurrentLocation = navCurrentLocation.top - navHeight;
                        window.scrollBy( 0, navCurrentLocation );
                    } else {
                        setTimeout( function ( ) {
                            scrollToAnchor( id );
                        }, 0);
                    }
                }
            };

            for (var tableHeaders = 0; tableHeaders < connectivitySummaryHeader.length; tableHeaders++) {
                var tableHeader = connectivitySummaryHeader[tableHeaders];
                tableHeader.addEventListener('click', showTableFromHeader, false);
            }


            // Link Integer to Results Tables from Connectivity Summary
            var connectivitySummaryCell = document.querySelectorAll('.summary .col2thru12 a');
            var showTable = function ( e ) {
                // use preventDefault to allow us to use window.scrollBy
                e.preventDefault();

                var id, table, resultsSection,
                    isHidden, target, anchor;

                if ( e.target.tagName === 'A' ) {
                    target = e.target;
                } else {
                    target = e.target.parentElement;
                }

                if ( target.href ) {
                    id = target.href.split('#')[1];
                    table = document.getElementById(id);
                    resultsSection = table.parentElement.parentElement.parentElement;
                    anchor = resultsSection.previousElementSibling.previousElementSibling.querySelector('.results-toggle');
                    isHidden = hasClass(resultsSection, 'hide');

                    if ( isHidden ) {
                        toggleHideShowClasses(resultsSection, isHidden);

                        anchor.text = "CLOSE_RESULTS";

                        // we want to the opposite of the function
                        // because it will return true if all closed
                        if ( !checkForOpenFixesResults() && hasClass(collapseAnchor, 'disabled') ) {
                            collapseAnchor.classList.remove('disabled');
                        }
                    }

                    if (browserVersion) {
                        var navCurrentLocation = table.getBoundingClientRect();
                        navCurrentLocation = navCurrentLocation.top - navHeight;
                        window.scrollBy(0, navCurrentLocation);
                    } else {
                        setTimeout( function ( ) {
                            scrollToAnchor( id, true );
                        }, 0);
                    }
                }
            };

            for (var o = 0; o < connectivitySummaryCell.length; o++) {
                var anchorCell = connectivitySummaryCell[o];
                anchorCell.addEventListener('click', showTable, false);
            }

            // Link Rule Help to Other Rule Helps
            var ruleHelpInnerLinks = document.querySelectorAll('.Rule-Help__Inner-Link');
            var showRuleHelp = function ( e ) {
                // use preventDefault to allow us to use window.scrollBy
                e.preventDefault();

                var id, table, resultsSection,
                    isHidden, isAdditionalHelp, target, anchor;

                if ( e.target.href ) {
                    id = e.target.href.split('#')[1];
                    resultsSection = document.getElementById(id);
                    isAdditionalHelp = hasClass(resultsSection, 'rule-additional-help');
                    
                    if (!isAdditionalHelp) {
                        anchor = resultsSection.previousElementSibling.querySelector('.rule-help-toggle');
                        isHidden = hasClass(resultsSection, 'hide');

                        if ( isHidden ) {
                            toggleHideShowClasses(resultsSection, isHidden);

                            anchor.text = "CLOSE_RULE_HELP";

                            // we want to the opposite of the function
                            // because it will return true if all closed
                            if ( !checkForOpenFixesResults() && hasClass(collapseAnchor, 'disabled') ) {
                                collapseAnchor.classList.remove('disabled');
                            }
                        }
                    }
 
                    if (browserVersion) {
                        var navCurrentLocation = resultsSection.getBoundingClientRect();
                        navCurrentLocation = navCurrentLocation.top - navHeight;
                        window.scrollBy( 0, navCurrentLocation );
                    } else {
                        scrollToAnchor( id );
                    }
                }
            };

            for (var innerLinks = 0; innerLinks < ruleHelpInnerLinks.length; innerLinks++) {
                var innerLink = ruleHelpInnerLinks[innerLinks];
                innerLink.addEventListener('click', showRuleHelp, false);
            }

			var showArchiveDetail = function(e) {
				// use preventDefault to allow us to use window.scrollBy
				e.preventDefault();

				var id, table, resultsSection,
					isHidden, target, anchor;

				if (e.target.href) {
					id = e.target.href.split('#')[1];
					resultsSection = document.getElementById(id);
					anchor = resultsSection.previousElementSibling.querySelector('.archive-toggle');
					isHidden = hasClass(resultsSection, 'hide');

					if (isHidden) {
						toggleHideShowClasses(resultsSection, isHidden);

						anchor.text = "CLOSE_DETAILS";

						// we want to the opposite of the function
						// because it will return true if all closed
						if (!checkForOpenArchiveDetails() && hasClass(collapseAnchor, 'disabled')) {
							collapseAnchor.classList.remove('disabled');
						}
					}

					if (browserVersion) {
						var navCurrentLocation = resultsSection.getBoundingClientRect();
						navCurrentLocation = navCurrentLocation.top - navHeight;
						window.scrollBy(0, navCurrentLocation);
					} else {
						scrollToAnchor(id);
					}
				}
			};
			
			// Toggle Rewrite Config
			var mavenConfigAnchor = document.getElementsByClassName('maven-config');
			var gradleConfigAnchor = document.getElementsByClassName('gradle-config');
			if (mavenConfigAnchor.length > 0 && gradleConfigAnchor.length > 0) {
				mavenConfigAnchor = mavenConfigAnchor[0];
				gradleConfigAnchor = gradleConfigAnchor[0];
				var toggleRewriteConfig = function(e) {
					var anchor = e.target.closest('a'),
					toggleAnchor = anchor.parentElement.getElementsByClassName('disabled')[0]
					isGradleAnchor = hasClass(anchor, 'gradle-config');
					mavenConfig = document.getElementById('js-maven-config');
					gradleConfig = document.getElementById('js-gradle-config');
					
					// prevent default behavior
					e.preventDefault();
					
					if(isGradleAnchor) {
						mavenConfig.classList.remove('show');
						mavenConfig.classList.add('hide');
						
						gradleConfig.classList.remove('hide');
						gradleConfig.classList.add('show');
					} else {
						gradleConfig.classList.remove('show');
						gradleConfig.classList.add('hide');
						
						mavenConfig.classList.remove('hide');
						mavenConfig.classList.add('show');
					}
					
					// disable other toggle anchor
					if (toggleAnchor) {
						toggleAnchor.classList.remove('disabled');
						anchor.classList.add('disabled');
					}
				}
				
				mavenConfigAnchor.addEventListener('click', toggleRewriteConfig);
	        	gradleConfigAnchor.addEventListener('click', toggleRewriteConfig);
        	}


			// Expand | Collapse Toggle
			var expandAnchor = document.getElementsByClassName('expand-all')[0];
			var collapseAnchor = document.getElementsByClassName('collapse-all')[0];
			var archiveListItem = document.getElementsByClassName('archive');
			var archiveDetailContent = document.getElementsByClassName('archive-details');
			var archiveAnchor = document.getElementsByClassName('archive-toggle');
			var ruleListItem = document.getElementsByClassName('rule');
            var ruleFixContent = document.getElementsByClassName('rule-fix');
            var ruleResultContent = document.getElementsByClassName('rule-result');
            var ruleFixAnchor = document.getElementsByClassName('rule-help-toggle');
            var ruleResultAnchor = document.getElementsByClassName('results-toggle');
			var toggleAllContents = function(e) {
				var anchor = e.target.closest('a'),
				toggleAnchor = anchor.parentElement.getElementsByClassName('disabled')[0],
				isExpandAll = hasClass(anchor, 'expand-all'),
				archiveListLength = archiveListItem.length,
				archiveListLengthAt0 = archiveListLength - 1;
				ruleListLength = ruleListItem.length,
                ruleListLengthAt0 = ruleListLength - 1;

				// prevent default behavior
				e.preventDefault();

				for (var arc = 0; arc < archiveListLength; arc++) {
					var currentAnchor = archiveAnchor[arc];
					var currentContent = currentAnchor.closest('.archive').getElementsByClassName('archive-details')[0];
					var isCurrentContentHidden = hasClass(currentContent, 'hide');
					var toExpandAll = isExpandAll && isCurrentContentHidden;
					var toCollapseAll = !isExpandAll && !isCurrentContentHidden;

					toggleHideShowClasses(currentContent, isExpandAll);

					if (isExpandAll) {
						currentAnchor.text = "CLOSE_DETAILS";

						if (arc === archiveListLengthAt0) {
							expandAnchor.classList.add('disabled');
						}
					} else {
						currentAnchor.text = "SHOW_DETAILS";

						if (checkForOpenArchiveDetails()) {
							collapseAnchor.classList.add('disabled');
						}
					}
				}
				
				for (var rule = 0; rule < ruleListLength; rule++) {
                    var currentFixContent = ruleFixContent[rule],
                    currentResultContent = ruleResultContent[rule],
                    isCurrentFixContentHidden = hasClass(currentFixContent, 'hide'),
                    isCurrentResultContentHidden = hasClass(currentResultContent, 'hide'),
                    currentFixAnchor = ruleFixAnchor[rule],
                    currentResultAnchor = ruleResultAnchor[rule],
                    toExpandAll = isExpandAll && isCurrentFixContentHidden || isExpandAll && isCurrentResultContentHidden,
                    toCollapseAll = !isExpandAll && !isCurrentFixContentHidden || !isExpandAll && !isCurrentResultContentHidden;

                    toggleHideShowClasses( currentFixContent, isExpandAll );
                    if(currentResultContent != null) {
                    	toggleHideShowClasses( currentResultContent, isExpandAll );
                    }

                    if ( isExpandAll ) {
                        currentFixAnchor.text = "CLOSE_RULE_HELP";
                        if(currentResultAnchor != null) {
                        	currentResultAnchor.text = "CLOSE_RESULTS";
                        }

                        if ( rule === ruleListLengthAt0 ) {
                            expandAnchor.classList.add('disabled');
                        }
                    } else {
                        currentFixAnchor.text = "SHOW_RULE_HELP";
                        if(currentResultAnchor != null) {
                        	currentResultAnchor.text = "SHOW_RESULTS";
                        }

                        if ( checkForOpenFixesResults() ) {
                            collapseAnchor.classList.add('disabled');
                        }
                    }
                }

				// disable other toggle anchor
				if (toggleAnchor) {
					toggleAnchor.classList.remove('disabled');
					anchor.classList.add('disabled');
				}
			};
			
            expandAnchor.addEventListener('click', toggleAllContents);
        	collapseAnchor.addEventListener('click', toggleAllContents);


			// Toggle Archive Detail Sections
			var toggleArchiveDetailSections = function(e) {
				e.preventDefault();

				var obj = {
						className: "archive-details",
						closeArchiveDetail: "CLOSE_DETAILS",
						showArchiveDetail: "SHOW_DETAILS"
					};

				var el = e.target.closest('.archive').getElementsByClassName(obj.className)[0];
				var isHidden = hasClass(el, 'hide');

				toggleHideShowClasses(el, isHidden);

				if (isHidden) {
					e.target.text = obj.closeArchiveDetail;

					// removed disabled on collapse anchor
					if (!checkForOpenArchiveDetails() && hasClass(collapseAnchor, 'disabled')) {
						collapseAnchor.classList.remove('disabled');
					}
					var currentHiddenArchive = document.querySelectorAll('.archive-details.hide').length;
					if(currentHiddenArchive===0) {
						expandAnchor.classList.add('disabled');
					}
				} else {
					e.target.text = obj.showArchiveDetail;

					// Hide nested archive detail sections also
					var nestedArchiveAnchors = el.getElementsByClassName('recommendation-toggle');
					for (var i=0; i < nestedArchiveAnchors.length; i++) {
						closeNestedArchiveDetailSections(nestedArchiveAnchors[i]);
					}

					// removed disabled on expand anchor
					if (hasClass(expandAnchor, 'disabled')) {
						expandAnchor.classList.remove('disabled');
					}

					if (checkForOpenArchiveDetails()) {
						collapseAnchor.classList.add('disabled');
					}
				}
			};

			var closeNestedArchiveDetailSections = function(targetElement) {
				var obj = {
						className: "archive-details",
						closeArchiveDetail: "CLOSE_DETAILS",
						showArchiveDetail: "SHOW_DETAILS"
					};

				var el = targetElement.closest('.archive').getElementsByClassName(obj.className)[0];

				var isHidden = hasClass(el, 'hide');

				if (!isHidden) {
					toggleHideShowClasses(el, isHidden);
					targetElement.text = obj.showArchiveDetail;

					// Hide nested archive detail sections also
					var nestedArchiveAnchors = el.getElementsByClassName('recommendation-toggle');
					for (var i=0; i < nestedArchiveAnchors.length; i++) {
						closeNestedArchiveDetailSections(nestedArchiveAnchors[i]);
					}
				}

			};

			// Toggle Archive Details
			for (var i = 0; i < recommendationItems.length; i++) {
				var anchorArchive = recommendationItems[i];
				anchorArchive.addEventListener('click', function(e) {
					toggleArchiveDetailSections(e);
				}, false);
			}

           // Toggle Individual Rule Help/Results Sections
            var toggleResultsbyRuleSections =  function ( e, obj ) {
                e.preventDefault();

                var el = e.target.closest('.rule').getElementsByClassName(obj.className)[0];
                var isHidden = hasClass(el, 'hide');

                toggleHideShowClasses(el, isHidden);

                if ( isHidden ) {
                    e.target.text = obj.closeRuleHelp;

                    // removed disabled on collapse anchor
                    if ( !checkForOpenFixesResults() && hasClass(collapseAnchor, 'disabled') ) {
                        collapseAnchor.classList.remove('disabled');
                    }
                } else {
                    e.target.text = obj.showRuleHelp;

                    // removed disabled on expand anchor
                    if ( hasClass(expandAnchor, 'disabled') ) {
                        expandAnchor.classList.remove('disabled');
                    }

                    if ( checkForOpenFixesResults() ) {
                        collapseAnchor.classList.add('disabled');
                    }
                }
            };

            // Toggle Rule Help
            for (var i = 0; i < recommendationHelp.length; i++) {
                var anchorRuleFix = recommendationHelp[i];
                anchorRuleFix.addEventListener('click', function ( e ) {
                    var obj = {
                        className: "rule-fix",
                        closeRuleHelp: "CLOSE_RULE_HELP",
                        showRuleHelp: "SHOW_RULE_HELP"
                    };

                    toggleResultsbyRuleSections(e, obj);
                }, false);
            }

            // Toggle Results
            for (var j = 0; j < recommendationDetails.length; j++) {
                var anchorResults = recommendationDetails[j];
                anchorResults.addEventListener('click', function ( e ) {
                    var obj = {
                        className: "rule-result",
                        closeRuleHelp: "CLOSE_RESULTS",
                        showRuleHelp: "SHOW_RESULTS"
                    };

                    toggleResultsbyRuleSections(e, obj);
                }, false);
            }


            // Toggle Rules Analyzed
            var readMoreLessAnchors = document.querySelectorAll('.read-more, .read-less, .detailed-read-more-button');
            var analyzedDetailSection = document.querySelector('#js-rules-analyzed-detail');
            var toggleAnalyzedDetailSection = function ( e ) {
                e.preventDefault();
                e.stopPropagation();

                var expandedButton = document.querySelector('.detailed-read-more-button'),
                    isExpandedReadMore = hasClass(e.target, 'detailed-read-more-button'),
                    isReadMore = hasClass(analyzedDetailSection, 'read-less'),
                    currentLink = document.querySelector('.read-more'),
                    siblingLink = document.querySelector('.read-less');

                if (!isReadMore) {
                    currentLink = document.querySelector('.read-less');
                    siblingLink = document.querySelector('.read-more');
                }

                if ( isExpandedReadMore && isReadMore ) {
                    e.target.text ="SHOW_LESS";
                    e.target.title ="SHOW_LESS";
                }

                if ( !isExpandedReadMore && isReadMore ) { 
                	expandedButton.text = "SHOW_LESS"; 
                	expandedButton.title = "SHOW_LESS";
                }

                if ( isExpandedReadMore && !isReadMore ) {
                    e.target.text ="SHOW_MORE";
                    e.target.title ="SHOW_MORE";
                }

                if ( !isExpandedReadMore && !isReadMore ) { 
                	expandedButton.text = "SHOW_MORE"; 
                	expandedButton.title = "SHOW_MORE";
                }

                toggleHideShowClasses(analyzedDetailSection, isReadMore, 'read-less', 'read-more');
                currentLink.classList.add('disabled');
                siblingLink.classList.remove('disabled');
            };

            for (var k = 0; k < readMoreLessAnchors.length; k++) {
                var readMoreLessAnchor = readMoreLessAnchors[k];
                var rulesAnalyzedRoot = document.getElementById('js-rules-analyzed-detail');

                if (readMoreLessAnchor !== rulesAnalyzedRoot) {
                    readMoreLessAnchor.addEventListener('click', toggleAnalyzedDetailSection);
                }
            }

		}, false);
		
