/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage.bundlefile;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.ZipBundleFile;

public class DirZipBundleEntry
extends BundleEntry {
    private ZipBundleFile bundleFile;
    String name;

    public DirZipBundleEntry(ZipBundleFile bundleFile, String name2) {
        this.name = name2.length() > 0 && name2.charAt(0) == '/' ? name2.substring(1) : name2;
        this.bundleFile = bundleFile;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getTime() {
        return 0L;
    }

    @Override
    public URL getLocalURL() {
        try {
            return new URL("jar:" + this.bundleFile.basefile.toURL() + "!/" + this.name);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public URL getFileURL() {
        try {
            return this.bundleFile.extractDirectory(this.name).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

