/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.container;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.internal.framework.FilterImpl;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class Capabilities {
    public static final Pattern MANDATORY_ATTR = Pattern.compile("\\(([^(=<>]+)\\s*[=<>]\\s*[^)]+\\)");
    public static final String SYNTHETIC_REQUIREMENT = "org.eclipse.osgi.container.synthetic";
    Map<String, NamespaceSet> namespaceSets = new HashMap<String, NamespaceSet>();

    public static boolean matches(Filter f, Capability candidate, boolean matchMandatory) {
        if (f != null && !f.matches(candidate.getAttributes())) {
            return false;
        }
        if (matchMandatory) {
            String mandatory = candidate.getDirectives().get("mandatory");
            if (mandatory == null) {
                return true;
            }
            if (f == null) {
                return false;
            }
            Matcher matcher = MANDATORY_ATTR.matcher(f.toString());
            String[] mandatoryAttrs = ManifestElement.getArrayFromList(mandatory, ",");
            boolean allPresent = true;
            String[] stringArray = mandatoryAttrs;
            int n = mandatoryAttrs.length;
            int n2 = 0;
            while (n2 < n) {
                String mandatoryAttr = stringArray[n2];
                matcher.reset();
                boolean found = false;
                while (matcher.find()) {
                    int numGroups = matcher.groupCount();
                    int i = 1;
                    while (i <= numGroups) {
                        if (mandatoryAttr.equals(matcher.group(i))) {
                            found = true;
                        }
                        ++i;
                    }
                }
                allPresent &= found;
                ++n2;
            }
            return allPresent;
        }
        return true;
    }

    public Collection<String> addCapabilities(ModuleRevision revision) {
        ArrayList<String> packageNames = null;
        for (ModuleCapability capability : revision.getModuleCapabilities(null)) {
            Object packageName;
            NamespaceSet namespaceSet = this.namespaceSets.get(capability.getNamespace());
            if (namespaceSet == null) {
                namespaceSet = new NamespaceSet(capability.getNamespace());
                this.namespaceSets.put(capability.getNamespace(), namespaceSet);
            }
            namespaceSet.addCapability(capability);
            if (!"osgi.wiring.package".equals(capability.getNamespace()) || !((packageName = capability.getAttributes().get("osgi.wiring.package")) instanceof String)) continue;
            if (packageNames == null) {
                packageNames = new ArrayList<String>();
            }
            packageNames.add((String)packageName);
        }
        return packageNames == null ? Collections.emptyList() : packageNames;
    }

    public void removeCapabilities(ModuleRevision revision) {
        for (ModuleCapability capability : revision.getModuleCapabilities(null)) {
            NamespaceSet namespaceSet = this.namespaceSets.get(capability.getNamespace());
            if (namespaceSet == null) continue;
            namespaceSet.removeCapability(capability);
        }
    }

    public List<ModuleCapability> findCapabilities(Requirement requirement) {
        NamespaceSet namespaceSet = this.namespaceSets.get(requirement.getNamespace());
        if (namespaceSet == null) {
            return Collections.emptyList();
        }
        return namespaceSet.findCapabilities(requirement);
    }

    static class NamespaceSet {
        private final String name;
        private final Map<String, Set<ModuleCapability>> indexes = new HashMap<String, Set<ModuleCapability>>();
        private final Set<ModuleCapability> all = new HashSet<ModuleCapability>();
        private final Set<ModuleCapability> nonStringIndexes = new HashSet<ModuleCapability>(0);
        private final boolean matchMandatory;

        NamespaceSet(String name2) {
            this.name = name2;
            this.matchMandatory = "osgi.wiring.package".equals(name2) || "osgi.wiring.bundle".equals(name2) || "osgi.wiring.host".equals(name2);
        }

        void addCapability(ModuleCapability capability) {
            if (!this.name.equals(capability.getNamespace())) {
                throw new IllegalArgumentException("Invalid namespace: " + capability.getNamespace() + ": expecting: " + this.name);
            }
            this.all.add(capability);
            Object index = capability.getAttributes().get(this.name);
            if (index == null) {
                return;
            }
            List<Object> indexCollection = null;
            if (index instanceof Collection) {
                indexCollection = (List<Object>)index;
            } else if (index.getClass().isArray()) {
                indexCollection = Arrays.asList((Object[])index);
            }
            if (indexCollection == null) {
                this.addIndex(index, capability);
            } else {
                for (Object e : indexCollection) {
                    this.addIndex(e, capability);
                }
            }
        }

        private void addIndex(Object indexKey, ModuleCapability capability) {
            if (!(indexKey instanceof String)) {
                this.nonStringIndexes.add(capability);
            } else {
                Set<ModuleCapability> capabilities = this.indexes.get(indexKey);
                if (capabilities == null) {
                    capabilities = new HashSet<ModuleCapability>(1);
                    this.indexes.put((String)indexKey, capabilities);
                }
                capabilities.add(capability);
            }
        }

        void removeCapability(ModuleCapability capability) {
            if (!this.name.equals(capability.getNamespace())) {
                throw new IllegalArgumentException("Invalid namespace: " + capability.getNamespace() + ": expecting: " + this.name);
            }
            this.all.remove(capability);
            Object index = capability.getAttributes().get(this.name);
            if (index == null) {
                return;
            }
            List<Object> indexCollection = null;
            if (index instanceof Collection) {
                indexCollection = (List<Object>)index;
            } else if (index.getClass().isArray()) {
                indexCollection = Arrays.asList((Object[])index);
            }
            if (indexCollection == null) {
                this.removeIndex(index, capability);
            } else {
                for (Object e : indexCollection) {
                    this.removeIndex(e, capability);
                }
            }
        }

        private void removeIndex(Object indexKey, ModuleCapability capability) {
            if (!(indexKey instanceof String)) {
                this.nonStringIndexes.remove(capability);
            } else {
                Set<ModuleCapability> capabilities = this.indexes.get(indexKey);
                if (capabilities != null) {
                    capabilities.remove(capability);
                }
            }
        }

        List<ModuleCapability> findCapabilities(Requirement requirement) {
            List<ModuleCapability> result;
            Object syntheticAttr;
            boolean synthetic;
            if (!this.name.equals(requirement.getNamespace())) {
                throw new IllegalArgumentException("Invalid namespace: " + requirement.getNamespace() + ": expecting: " + this.name);
            }
            FilterImpl f = null;
            String filterSpec = requirement.getDirectives().get("filter");
            if (filterSpec != null) {
                try {
                    f = FilterImpl.newInstance(filterSpec);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    return Collections.emptyList();
                }
            }
            boolean bl = synthetic = (syntheticAttr = requirement.getAttributes().get(Capabilities.SYNTHETIC_REQUIREMENT)) instanceof Boolean ? (Boolean)syntheticAttr : false;
            if (filterSpec == null) {
                result = this.match(null, this.all, synthetic);
            } else {
                String indexKey = f.getPrimaryKeyValue(this.name);
                if (indexKey == null) {
                    result = this.match(f, this.all, synthetic);
                } else {
                    Set<ModuleCapability> indexed = this.indexes.get(indexKey);
                    result = indexed == null ? new ArrayList<ModuleCapability>(0) : this.match(f, indexed, synthetic);
                    if (!this.nonStringIndexes.isEmpty()) {
                        List<ModuleCapability> nonStringResult = this.match(f, this.nonStringIndexes, synthetic);
                        for (ModuleCapability capability : nonStringResult) {
                            if (result.contains(capability)) continue;
                            result.add(capability);
                        }
                    }
                }
            }
            return result;
        }

        private List<ModuleCapability> match(Filter f, Set<ModuleCapability> candidates, boolean synthetic) {
            ArrayList<ModuleCapability> result = new ArrayList<ModuleCapability>(1);
            for (ModuleCapability candidate : candidates) {
                if (!Capabilities.matches(f, candidate, !synthetic && this.matchMandatory)) continue;
                result.add(candidate);
            }
            return result;
        }
    }
}

