/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer.json;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.ws.report.Messages;
import com.ibm.ws.report.technology.AbstractTechnology;
import com.ibm.ws.report.technology.TechSummary;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.writer.ReportWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class JSONEvaluationReportWriter
implements ReportWriter {
    private SortedMap<String, String> scanOptions = null;
    private Map<String, Set<String>> incompleteReportErrorsPerApplication = null;
    private String returnString;
    private static final int ROW_FOR_OPEN_LIBERTY = 0;
    private static final int ROW_FOR_LIBERTY_CORE_855 = 1;
    private static final int ROW_FOR_LIBERTY_PROFLIE_855 = 2;
    private static final int ROW_FOR_FULL_855 = 3;
    private static final int ROW_FOR_LIBERTY_PROFILE_ND_855 = 4;
    private static final int ROW_FOR_FULL_ND_855 = 5;
    private static final int ROW_FOR_LIBERTY_PROFILE_ZOS_855 = 6;
    private static final int ROW_FOR_FULL_ZOS_855 = 7;
    private boolean hasSingleSummaryTable = false;
    private boolean[] supportedPlatforms = new boolean[]{true, true, true, true, true, true, true, true, true};
    private SortedMap<String, TechSummary> listOfTechSummaries = null;
    private final boolean[] showColumn = new boolean[9];
    private final String[] columnNames = new String[]{"OpenLiberty", "WASLibertyCore", "WASLibertyProfile", "WASFullProfile", "WASNDLiberty", "WASNDFullProfile", "WASZOSLiberty", "WASZOSFull"};
    private final String[] techNames = new String[]{"openLiberty", "libertyCore", "liberty", "websphereTraditional", "ndLiberty", "ndTraditional", "zosLiberty", "zosTraditional"};
    private List<String> applicationNames = new ArrayList<String>();

    public JSONEvaluationReportWriter(List<String> arrayOfProjects, SortedMap<String, TechSummary> listOfTechSummaries, List<String> productsToShow, SortedMap<String, String> scanOptions, Map<String, Set<String>> mapOfAppNameToDescs) {
        this.incompleteReportErrorsPerApplication = mapOfAppNameToDescs;
        this.scanOptions = scanOptions;
        this.applicationNames = arrayOfProjects;
        Collections.sort(this.applicationNames);
        this.listOfTechSummaries = listOfTechSummaries;
        this.hasSingleSummaryTable = listOfTechSummaries.size() == 1;
        for (String product : productsToShow) {
            if (product.equals(Messages.getString("OpenLiberty"))) {
                this.showColumn[0] = true;
                continue;
            }
            if (product.equals(Messages.getString("WASLibertyCore"))) {
                this.showColumn[1] = true;
                continue;
            }
            if (product.equals(Messages.getString("WASLibertyProfile"))) {
                this.showColumn[2] = true;
                continue;
            }
            if (product.equals(Messages.getString("WASFullProfile"))) {
                this.showColumn[3] = true;
                continue;
            }
            if (product.equals(Messages.getString("WASNDLiberty"))) {
                this.showColumn[4] = true;
                continue;
            }
            if (product.equals(Messages.getString("WASNDFullProfile"))) {
                this.showColumn[5] = true;
                continue;
            }
            if (product.equals(Messages.getString("WASZOSLiberty"))) {
                this.showColumn[6] = true;
                continue;
            }
            if (!product.equals(Messages.getString("WASZOSFull"))) continue;
            this.showColumn[7] = true;
        }
    }

    public void addSummaryAndTable(OrderedJSONObject container) {
        this.determineOverallPlatformSupport();
        TechSummary firstTechSummary = (TechSummary)this.listOfTechSummaries.get(this.listOfTechSummaries.firstKey());
        String applicationName = this.getAppName(firstTechSummary.getProjectName());
        this.writeApplicationSummaryAndTechArray(container, firstTechSummary, applicationName);
    }

    private void buildRow(String label, int[] rowXs, JSONArray techArray) {
        OrderedJSONObject resultObject = new OrderedJSONObject();
        resultObject.put("technology", label);
        int i = 0;
        while (i < this.showColumn.length) {
            if (this.showColumn[i]) {
                resultObject.put(this.techNames[i], (Object)(rowXs[i] != -1 ? 1 : 0));
            }
            ++i;
        }
        techArray.add(resultObject);
    }

    private JSONArray getAllOptions() {
        JSONArray allOptions = new JSONArray();
        for (String key : this.scanOptions.keySet()) {
            allOptions.add(this.scanOptions.get(key));
        }
        return allOptions;
    }

    @Override
    public String getResult() {
        return this.returnString;
    }

    private OrderedJSONObject buildSummary(boolean[] platformsSupported) {
        OrderedJSONObject perAppSummaryObject = new OrderedJSONObject();
        int i = 0;
        while (i < this.columnNames.length) {
            if (this.showColumn[i]) {
                perAppSummaryObject.put(this.techNames[i], (Object)platformsSupported[i]);
            }
            ++i;
        }
        return perAppSummaryObject;
    }

    private void writeApplicationsSection(OrderedJSONObject jsonObject) {
        JSONArray applicationsArray = new JSONArray();
        for (String key : this.listOfTechSummaries.keySet()) {
            TechSummary summary = (TechSummary)this.listOfTechSummaries.get(key);
            OrderedJSONObject app = new OrderedJSONObject();
            app.put("application", key);
            String applicationName = this.getAppName(key);
            this.writeApplicationSummaryAndTechArray(app, summary, applicationName);
            applicationsArray.add(app);
        }
        jsonObject.put("applications", applicationsArray);
    }

    private String getAppName(String key) {
        return key.contains("/") ? key.substring(key.lastIndexOf(47) + 1) : key;
    }

    private void writeApplicationSummaryAndTechArray(OrderedJSONObject app, TechSummary summary, String applicationName) {
        ArrayList<String> footnoteEntries = new ArrayList<String>();
        app.put("summary", this.buildSummary(summary.getSupportedPlatforms()));
        TreeMap<TechSummary.OrderedTech, TreeSet<TechSummary.OrderedTech>> mapOfRowHeaderToTechnologies = summary.getMapOfRowHeaderToTechnologies();
        JSONArray techArray = new JSONArray();
        for (TechSummary.OrderedTech techLineBreak : mapOfRowHeaderToTechnologies.keySet()) {
            TreeSet<TechSummary.OrderedTech> setOfTech = mapOfRowHeaderToTechnologies.get(techLineBreak);
            for (TechSummary.OrderedTech orderedTech : setOfTech) {
                AbstractTechnology tech = orderedTech.getTech();
                String techName = tech.getName();
                String techReferredToAs = tech.getReferredToAs();
                if (!techName.startsWith("line-break")) {
                    this.buildRow(techName, tech.getSupport(), techArray);
                }
                if (techReferredToAs == null) continue;
                String footnoteContent = tech.getId().equals("TechName_JAXRPCPrevalidatedAppProvided") || tech.getId().equals("TechName_JAXRPCPrevalidated") ? techReferredToAs : Messages.getFormattedMessage(Messages.getString("ReportWriter_Technology_Also_Known_As"), techName, techReferredToAs);
                footnoteEntries.add(footnoteContent);
            }
        }
        app.put("technologies", techArray);
        this.addApplicationFootnotes(app, applicationName, footnoteEntries);
    }

    @Override
    public void writeReport() {
        OrderedJSONObject reportObject = new OrderedJSONObject();
        this.determineOverallPlatformSupport();
        ReportUtility.writeJSONHeader(reportObject, "technology", "2.3", this.getAllOptions());
        this.writeApplicationsSection(reportObject);
        reportObject.put("overallSummary", this.buildSummary(this.supportedPlatforms));
        this.convertJsonToString(reportObject);
    }

    private void convertJsonToString(OrderedJSONObject reportObject) {
        try {
            String jsonString = reportObject.serialize(true);
            this.returnString = jsonString = jsonString.replace("\\/", "/");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void determineOverallPlatformSupport() {
        if (!this.hasSingleSummaryTable) {
            for (TechSummary summary : this.listOfTechSummaries.values()) {
                boolean[] platformsSupportedByApp = summary.getSupportedPlatforms();
                int i = 0;
                while (i < platformsSupportedByApp.length) {
                    this.supportedPlatforms[i] = !platformsSupportedByApp[i] ? false : this.supportedPlatforms[i];
                    ++i;
                }
            }
        } else {
            this.supportedPlatforms = this.listOfTechSummaries.values().iterator().next().getSupportedPlatforms();
        }
    }

    private void writeFooterObject(OrderedJSONObject reportObject, List<String> footnotes) {
        JSONArray footnoteArray = new JSONArray();
        for (String footnoteEntry : footnotes) {
            footnoteArray.add(footnoteEntry);
        }
        reportObject.put("footnotes", footnoteArray);
    }

    private void addApplicationFootnotes(OrderedJSONObject jsonObject, String applicationName, List<String> footnoteEntries) {
        Set<String> setOfIncompleteReportErrors = this.incompleteReportErrorsPerApplication.get(applicationName);
        JSONArray arrayOfIncompleteReportErrors = new JSONArray();
        if (setOfIncompleteReportErrors != null) {
            for (String reportErrorMessage : setOfIncompleteReportErrors) {
                arrayOfIncompleteReportErrors.add(reportErrorMessage);
            }
        }
        jsonObject.put("incompleteReportErrors", arrayOfIncompleteReportErrors);
        this.writeFooterObject(jsonObject, footnoteEntries);
    }
}

