/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer.json;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.ws.report.Messages;
import com.ibm.ws.report.analyze.AnalysisResults;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.utilities.RuleInfo;
import com.ibm.ws.report.utilities.RuleSeverity;
import com.ibm.ws.report.writer.DetailAnalysisReportWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;

public class JSONDetailAnalysisReportWriter
extends DetailAnalysisReportWriter {
    private List<String> projects = null;
    private List<String> applicationNames = null;
    private final Map<String, String> categoryNameToKey;
    private int totalRulesFlagged = 0;
    protected boolean includeHelpLocation = false;
    private final int maxUserDefinedRuleResults;
    protected AnalysisResults analysisResults;
    String returnString;

    public JSONDetailAnalysisReportWriter(List<String> arrayOfProjects, String[] sourceOptions, String[] targetOptions, SortedMap<String, String> scanOptions, Map<String, List<DetailResult>> results, Map<String, Map<String, Map<String, List<String>>>> rulesAnalyzed, boolean formatByFile, Map<String, String> ruleHelp, Map<String, RuleSeverity> ruleSeverities, Map<String, RuleInfo> costs, List<String> applicationNames, Map<String, String> categoryNameToKey, boolean includeHelpLocation, int maxUserDefinedRuleResults, AnalysisResults analysisResults) {
        super(arrayOfProjects, sourceOptions, targetOptions, scanOptions, results, rulesAnalyzed, formatByFile, ruleHelp, null, ruleSeverities, costs, false, analysisResults != null ? analysisResults.getMapOfDescToAnalysisRules() : null);
        this.categoryNameToKey = categoryNameToKey;
        this.analysisResults = analysisResults;
        this.applicationNames = applicationNames;
        Collections.sort(this.applicationNames);
        this.projects = arrayOfProjects;
        this.includeHelpLocation = includeHelpLocation;
        this.totalRulesFlagged = this.numInfoRules + this.numWarningRules + this.numSevereRules + this.numNoSeverityRules;
        this.maxUserDefinedRuleResults = maxUserDefinedRuleResults;
    }

    private void buildHeader(OrderedJSONObject rootObject) {
        ReportUtility.writeJSONHeader(rootObject, "analysis", "1.4", this.getAllOptions());
        this.buildDashboard(rootObject);
        if (this.totalRulesFlagged > 0) {
            this.buildRuleSeveritySummary(rootObject);
        }
        JSONArray applicationsArray = new JSONArray();
        if (this.projects.size() != 0) {
            for (String appName : this.projects) {
                applicationsArray.add(appName);
            }
        } else {
            applicationsArray.add(this.projects.get(0));
        }
        rootObject.put("applications", applicationsArray);
    }

    public void buildDashboard(OrderedJSONObject rootObject) {
        rootObject.put("totalRulesFlagged", (Object)this.totalRulesFlagged);
        int numFilesAffected = this.filesAffected.size();
        rootObject.put("filesAffected", (Object)numFilesAffected);
        rootObject.put("totalResults", (Object)this.totalNumberOfResults);
    }

    public void buildRuleSeveritySummary(OrderedJSONObject rootObject) {
        JSONArray severityArray = this.getSeveritiesSummary();
        rootObject.put("severitySummary", severityArray);
    }

    public void buildRulesArray(OrderedJSONObject rootObject) {
        JSONArray rulesArray = new JSONArray();
        List ruleResults = null;
        for (String ruleIdentifier : this.ruleIdentifiers) {
            RuleInfo costEntry;
            String ruleId = this.parseRuleIdFromIdentfier(ruleIdentifier);
            boolean isUserRule = ruleId.startsWith("userDefined_");
            String ruleDesc = this.parseRuleNameFromIdentfier(ruleIdentifier);
            JSONArray resultsArray = new JSONArray();
            OrderedJSONObject rulesObject = new OrderedJSONObject();
            RuleSeverity sev = (RuleSeverity)((Object)this.severityByRuleId.get(ruleId));
            String severityString = null;
            switch (sev) {
                case SEVERE: {
                    severityString = Messages.getString("ANALYSIS_REPORT_SEVERITY_SEVERE_LABEL");
                    break;
                }
                case WARNING: {
                    severityString = Messages.getString("ANALYSIS_REPORT_SEVERITY_WARNING_LABEL");
                    break;
                }
                case INFO: {
                    severityString = Messages.getString("ANALYSIS_REPORT_SEVERITY_INFO_LABEL");
                    break;
                }
                default: {
                    severityString = Messages.getString("ANALYSIS_REPORT_SEVERITY_NONE_LABEL");
                }
            }
            rulesObject.put("ruleName", ruleDesc);
            rulesObject.put("ruleId", ruleId);
            if (this.includeHelpLocation) {
                rulesObject.put("ruleHelpLocation", this.ruleHelp.get(ruleId));
                String help = null;
                try {
                    help = ReportUtility.loadRuleHelpBody((String)this.ruleHelp.get(ruleId), isUserRule);
                    rulesObject.put("ruleHelpEncoded", Base64.getEncoder().encodeToString(help.replaceAll("\\r\\n?", "\n").getBytes(StandardCharsets.UTF_8)));
                }
                catch (Exception e) {
                    ReportUtility.logger.get().log(Level.SEVERE, e.getMessage(), e);
                }
            }
            LinkedHashSet<String> recipes = this.analysisResults.getRuleRecipes(ruleId);
            String defaultRecipe = null;
            JSONArray altRecipes = new JSONArray();
            if (recipes != null) {
                boolean recipeIndex = false;
                for (String recipe : recipes) {
                    if (!recipeIndex) {
                        defaultRecipe = recipe;
                        rulesObject.put("recipe", recipe);
                        continue;
                    }
                    altRecipes.add(recipe);
                }
            }
            if ((costEntry = (RuleInfo)this.ruleCosts.get(ruleId)) != null) {
                String devCost = this.formatCost(Float.valueOf(costEntry.devCost));
                String instanceCost = this.formatCost(Float.valueOf(costEntry.instanceCost));
                if (defaultRecipe != null) {
                    if ((double)costEntry.devCost > 0.1) {
                        devCost = "0.1";
                    }
                    instanceCost = "0";
                }
                rulesObject.put("devCost", devCost);
                rulesObject.put("instanceCost", instanceCost);
                String complexity = costEntry.complexity;
                if (complexity != null) {
                    rulesObject.put("complexity", complexity);
                }
            }
            rulesObject.put("severity", severityString);
            rulesObject.put("severityId", sev.toString());
            rulesObject.put("recipe", defaultRecipe);
            rulesObject.put("alternativeRecipes", altRecipes);
            String category = (String)this.categoryByRuleDesc.get(ruleDesc);
            rulesObject.put("category", category);
            String categoryKey = this.categoryNameToKey.get(category);
            if (categoryKey != null) {
                rulesObject.put("categoryId", categoryKey);
            }
            ruleResults = (List)this.resultsByRuleId.get(ruleId);
            TreeMap<String, Integer> referencedClassesPerFile = null;
            HashSet<String> processedApps = new HashSet<String>();
            int numResultsForRule = 0;
            if (!ruleResults.isEmpty()) {
                ReportUtility.sortDetailResults(ruleResults);
                String lastFileName = null;
                String thisFileName = null;
                OrderedJSONObject resultsObject = new OrderedJSONObject();
                JSONArray detailsArray = new JSONArray();
                for (DetailResult nextResult : ruleResults) {
                    String appName = ReportUtility.getFirstArchiveName(nextResult.getFileName());
                    if (!processedApps.contains(appName) && nextResult.getReferencedClasses() != null) {
                        Map<String, Integer> processedAppsForResult = nextResult.getReferencedClasses();
                        if (referencedClassesPerFile == null) {
                            referencedClassesPerFile = new TreeMap<String, Integer>(processedAppsForResult);
                        } else {
                            for (Map.Entry<String, Integer> entry : processedAppsForResult.entrySet()) {
                                String entryKey = entry.getKey();
                                Integer entryTotal = entry.getValue();
                                Integer total = referencedClassesPerFile.get(entryKey);
                                referencedClassesPerFile.put(entryKey, total == null ? entryTotal : total + entryTotal);
                            }
                        }
                        processedApps.add(appName);
                    }
                    thisFileName = nextResult.getFileName().trim();
                    if (this.maxUserDefinedRuleResults == -1 || !ruleId.startsWith("userDefined_") || numResultsForRule < this.maxUserDefinedRuleResults) {
                        if (lastFileName == null) {
                            resultsObject.put("fileName", thisFileName);
                            resultsObject.put("details", detailsArray);
                            resultsArray.add(resultsObject);
                            lastFileName = thisFileName;
                        } else if (!thisFileName.equals(lastFileName)) {
                            resultsObject = new OrderedJSONObject();
                            detailsArray = new JSONArray();
                            resultsObject.put("fileName", thisFileName);
                            resultsObject.put("details", detailsArray);
                            resultsArray.add(resultsObject);
                            lastFileName = thisFileName;
                        }
                    }
                    OrderedJSONObject detailsObject = new OrderedJSONObject();
                    String ruleName = nextResult.getRuleName();
                    if (ruleName.equals("URLRuleBluemixPaas") || ruleName.equals("URLRuleDockerCloud")) {
                        detailsObject.put("reference", nextResult.getReference().replaceAll("[^0-9].*", ""));
                    } else {
                        detailsObject.put("reference", nextResult.getReference());
                    }
                    detailsObject.put("match", nextResult.getCriteria());
                    detailsObject.put("lineNumber", (Object)nextResult.getLineNumber());
                    int i = 0;
                    while (i < nextResult.getNumberOfOccurrences()) {
                        if (this.maxUserDefinedRuleResults == -1 || !ruleId.startsWith("userDefined_") || numResultsForRule < this.maxUserDefinedRuleResults) {
                            detailsArray.add(detailsObject);
                        }
                        ++numResultsForRule;
                        ++i;
                    }
                }
            }
            rulesObject.put("totalResults", (Object)numResultsForRule);
            rulesObject.put("results", resultsArray);
            if (referencedClassesPerFile != null) {
                JSONArray referencedClassesArray = new JSONArray();
                for (Map.Entry entry : referencedClassesPerFile.entrySet()) {
                    OrderedJSONObject detailsObject = new OrderedJSONObject();
                    detailsObject.put("class", entry.getKey());
                    detailsObject.put("total", entry.getValue());
                    referencedClassesArray.add(detailsObject);
                }
                rulesObject.put("referencedClasses", referencedClassesArray);
            }
            rulesArray.add(rulesObject);
        }
        rootObject.put("rules", rulesArray);
        if (this.analysisResults.containsAutomatedFix()) {
            rootObject.put("automatedFixConfig", this.analysisResults.getRewriteJSONConfig());
        }
        try {
            String json = rootObject.serialize(true);
            this.returnString = json = json.replace("\\/", "/");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private JSONArray getAllOptions() {
        JSONArray allOptions = new JSONArray();
        ArrayList<String[]> optionsList = new ArrayList<String[]>();
        optionsList.add(this.sourceOptions);
        optionsList.add(this.targetOptions);
        if (this.scanOptions != null && !this.scanOptions.isEmpty()) {
            String[] optionsArr = this.scanOptions.values().toArray(new String[this.scanOptions.size()]);
            optionsList.add(optionsArr);
        }
        Iterator iterator = optionsList.iterator();
        while (iterator.hasNext()) {
            String[] optionList;
            String[] stringArray = optionList = (String[])iterator.next();
            int n = optionList.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                allOptions.add(option);
                ++n2;
            }
        }
        return allOptions;
    }

    private JSONArray getSeveritiesSummary() {
        JSONArray severityArray = new JSONArray();
        this.addRuleSeverityObject(severityArray, Messages.getString("ANALYSIS_REPORT_SEVERITY_SEVERE_LABEL"), RuleSeverity.SEVERE, this.numSevereRules, this.numSevereRuleResults);
        this.addRuleSeverityObject(severityArray, Messages.getString("ANALYSIS_REPORT_SEVERITY_WARNING_LABEL"), RuleSeverity.WARNING, this.numWarningRules, this.numWarningRuleResults);
        this.addRuleSeverityObject(severityArray, Messages.getString("ANALYSIS_REPORT_SEVERITY_INFO_LABEL"), RuleSeverity.INFO, this.numInfoRules, this.numInfoRuleResults);
        this.addRuleSeverityObject(severityArray, Messages.getString("ANALYSIS_REPORT_SEVERITY_NONE_LABEL"), RuleSeverity.NONE, this.numNoSeverityRules, this.numNoSeverityRuleResults);
        return severityArray;
    }

    private void addRuleSeverityObject(JSONArray severityArray, String label, RuleSeverity severity, int numRules, int numResults) {
        if (numRules > 0) {
            OrderedJSONObject jsonObject = new OrderedJSONObject();
            jsonObject.put("severity", label);
            jsonObject.put("severityId", severity.toString());
            jsonObject.put("totalRulesFlagged", (Object)numRules);
            jsonObject.put("totalResults", (Object)numResults);
            jsonObject.put("totalRulesFlaggedWithAutomatedFix", (Object)this.analysisResults.getSeverityRecipeCount(severity));
            jsonObject.put("totalResultsWithAutomatedFix", (Object)this.analysisResults.getSeverityRecipeResultCount(severity));
            severityArray.add(jsonObject);
        }
    }

    @Override
    public String getResult() {
        return this.returnString;
    }

    @Override
    public void writeReport() {
        OrderedJSONObject rootObject = new OrderedJSONObject();
        this.buildHeader(rootObject);
        this.buildRulesArray(rootObject);
        this.close();
    }
}

