/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.utilities;

import com.ibm.ws.report.Messages;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum RuleSeverity {
    SEVERE("severe", Messages.getString("ANALYSIS_REPORT_SEVERITY_SEVERE_LABEL"), Messages.getString("ANALYSIS_REPORT_SEVERITY_SEVERE_DESCRIPTION")),
    WARNING("warning", Messages.getString("ANALYSIS_REPORT_SEVERITY_WARNING_LABEL"), Messages.getString("ANALYSIS_REPORT_SEVERITY_WARNING_DESCRIPTION")),
    INFO("info", Messages.getString("ANALYSIS_REPORT_SEVERITY_INFO_LABEL"), Messages.getString("ANALYSIS_REPORT_SEVERITY_INFO_DESCRIPTION")),
    NONE("none", Messages.getString("ANALYSIS_REPORT_SEVERITY_NONE_LABEL"), Messages.getString("ANALYSIS_REPORT_SEVERITY_NONE_DESCRIPTION"));

    private static final Map<String, RuleSeverity> lookupLabel;
    private final String labelParm;
    private final String translatableLabel;
    private final String desc;

    static {
        lookupLabel = new HashMap<String, RuleSeverity>();
        for (RuleSeverity s : EnumSet.allOf(RuleSeverity.class)) {
            lookupLabel.put(s.labelParm, s);
        }
    }

    public static RuleSeverity getRuleSeverity(String option) {
        RuleSeverity sev = lookupLabel.get(option);
        return sev == null ? NONE : sev;
    }

    private RuleSeverity(String label, String translatableLabel, String desc) {
        this.labelParm = label;
        this.translatableLabel = translatableLabel;
        this.desc = desc;
    }

    public String toString() {
        return this.labelParm;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getTranslatableLabel() {
        return this.translatableLabel;
    }
}

