/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.inventory;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.ws.report.inventory.Archive;
import com.ibm.ws.report.inventory.ArchiveInventory;
import com.ibm.ws.report.inventory.Jar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class UtilityJar
extends Jar
implements Iterable<String> {
    private final SortedSet<String> packages = new TreeSet<String>();
    public static final ArchiveInventory.ArchiveTypes ARCHIVE_TYPE = ArchiveInventory.ArchiveTypes.UTILITY_JAR;
    public static final String EXTENSION = ARCHIVE_TYPE.typeExtension();

    public UtilityJar(String name2) {
        super(name2);
    }

    @Override
    public ArchiveInventory.ArchiveTypes getArchiveType() {
        return ARCHIVE_TYPE;
    }

    @Override
    public String getExtension() {
        return EXTENSION;
    }

    public void addPackage(String packageName) {
        this.packages.add(packageName);
    }

    public void addPackages(String[] packageNames) {
        this.packages.addAll(Arrays.asList(packageNames));
    }

    @Override
    public Iterator<String> iterator() {
        return this.packages.iterator();
    }

    @Override
    public OrderedJSONObject toJSON(boolean isTopArchive, Map<String, String> sharedLibrariesChecksumMap) {
        OrderedJSONObject archiveInventoryObject = new OrderedJSONObject();
        archiveInventoryObject.put("archiveName", this.getFullName());
        archiveInventoryObject.put("moduleType", this.getArchiveType().getType());
        if (this.archiveSize != 0L) {
            archiveInventoryObject.put("moduleSize", (Object)this.archiveSize);
        }
        if (this.checksum != null) {
            archiveInventoryObject.put("checksum", this.checksum);
        }
        JSONArray containedPackagesArray = new JSONArray();
        for (String name2 : this.packages) {
            containedPackagesArray.add(name2);
        }
        archiveInventoryObject.put("containedPackages", containedPackagesArray);
        ArrayList<String> sortedKeys = new ArrayList<String>(this.getSubArchiveNames());
        if (!sortedKeys.isEmpty()) {
            JSONArray containedArchivesArray = new JSONArray();
            Collections.sort(sortedKeys);
            for (String key : sortedKeys) {
                Archive nextArchive = this.getArchive(key);
                OrderedJSONObject jsonArchive = nextArchive.toJSON(false, sharedLibrariesChecksumMap);
                containedArchivesArray.add(jsonArchive);
            }
            archiveInventoryObject.put("containedArchiveInventory", containedArchivesArray);
        }
        return archiveInventoryObject;
    }
}

