/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.inventory;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.ws.report.Messages;
import com.ibm.ws.report.inventory.AppPackage;
import com.ibm.ws.report.inventory.ArchiveInventory;
import com.ibm.ws.report.inventory.qos.QosClusterTarget;
import com.ibm.ws.report.inventory.qos.QosDeploymentTargets;
import com.ibm.ws.report.inventory.qos.QosServerTarget;
import com.ibm.ws.report.inventory.qos.QosSessionPersistenceType;
import com.ibm.ws.report.inventory.qos.QosTransactionLogType;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;

public abstract class Archive {
    protected Archive parent = null;
    protected ArchiveInventory inv = new ArchiveInventory();
    private final String fullName;
    private final String name;
    private String raveTreeLabelName;
    private String version;
    private String metadataComplete;
    private String ejbJarMetadataComplete;
    protected String checksum;
    protected long archiveSize;
    private final int[] fields = new int[Fields.values().length];
    private final int[] subFields = new int[Fields.values().length];
    private List<AppPackage> listOfAllPackagesInApp;
    private final Map<String, AppPackage> mapToPackageList = new HashMap<String, AppPackage>();
    private final SortedMap<String, String> mapOfUnusedArchives = new TreeMap<String, String>();
    private final SortedMap<String, String> mapOfUnusedArchiveChecksums = new TreeMap<String, String>();
    private final SortedMap<String, String> mapOfSharedLibDependencies = new TreeMap<String, String>();
    private final int[] issueCount = new int[AppPackage.Issue.values().length];
    private final int[] archiveIssueCount = new int[AppPackage.Issue.values().length];
    private boolean hasIssues = false;
    private final int[] archiveCountPerIssueTypeArray = new int[AppPackage.Issue.values().length];
    private boolean hasAnnotations = false;
    private final Set<String> suggestionsToRemove = new HashSet<String>();
    private final Set<String> springManifestVersion = new HashSet<String>();
    private final Set<String> springSchemaVersion = new HashSet<String>();
    private String webSphereEdition;
    private String webSphereVersion;
    private String adminHost;
    private String adminPort;
    private String cellName;
    private boolean isZos;
    private QosDeploymentTargets deploymentTargets;
    private int recommendedNumberOfReplicas;
    private int recommendedMinimumNumberOfReplicas;
    private int recommendedMaximumNumberOfReplicas;
    private final Set<Archive> sharedLibraries = new TreeSet<Archive>(new Comparator<Archive>(){

        @Override
        public int compare(Archive e1, Archive e2) {
            return e1.getFullName().compareTo(e2.getFullName());
        }
    });
    private final Set<String> annotationTypeSet = new HashSet<String>();
    private String numExcessClassFiles = null;
    private String numWebModuleResources = null;
    private boolean ejbJarXmlFound = false;
    private final SortedMap<String, Set<String>> mapOfSystemProperties = new TreeMap<String, Set<String>>();

    public Set<Archive> getSharedLibraries() {
        return this.sharedLibraries;
    }

    public Archive(String fullName) {
        if (fullName == null || fullName.length() == 0) {
            throw new IllegalArgumentException("The name of the Archive must not be null, and contain at least one character");
        }
        if (!fullName.endsWith(String.valueOf('.') + this.getExtension())) {
            throw new IllegalArgumentException("The extension of " + fullName + " needs to be ." + this.getExtension());
        }
        this.fullName = fullName;
        this.name = fullName.contains("/") ? fullName.substring(fullName.lastIndexOf(47) + 1) : fullName;
        this.raveTreeLabelName = this.name;
    }

    public abstract ArchiveInventory.ArchiveTypes getArchiveType();

    public abstract String getExtension();

    public void addArchive(Archive sub) {
        if (sub == null) {
            throw new IllegalArgumentException("Parameter must not be null");
        }
        if (sub.parent != null) {
            throw new IllegalArgumentException("The Archive " + sub.fullName + " cannot be added to " + this.fullName + " because it is already contained within " + sub.parent.fullName);
        }
        assert (sub.inv.parentInv == null);
        if (this.getSubArchiveNames().contains(sub.fullName)) {
            throw new IllegalArgumentException("The Archive " + this.fullName + " already contains an Archive of the name " + sub.fullName);
        }
        if (!this.getArchiveType().canContain(sub.getArchiveType())) {
            throw new IllegalArgumentException("Cannot add " + sub.getFullName() + " to " + this.getFullName() + ". The archive type is not allowed in the containing archive.");
        }
        this.inv.put(sub);
        sub.parent = this;
        this.consolidateAddedArchive(sub);
    }

    public void addSharedLibrary(Archive sub) {
        this.sharedLibraries.add(sub);
    }

    private void consolidateAddedArchive(Archive sub) {
        Archive current = this;
        Archive prev = sub;
        while (current != null) {
            assert (current.getSubArchiveNames().contains(prev.fullName));
            assert (prev.parent == current);
            int i = 0;
            while (i < current.subFields.length) {
                int n = i;
                current.subFields[n] = current.subFields[n] + (sub.fields[i] + sub.subFields[i]);
                ++i;
            }
            prev = current;
            current = current.parent;
        }
    }

    private void consolidateIncrement(Fields f) {
        Archive current = this.parent;
        Archive prev = this;
        while (current != null) {
            assert (current.getSubArchiveNames().contains(prev.fullName));
            assert (prev.parent == current);
            int n = f.ordinal();
            current.subFields[n] = current.subFields[n] + 1;
            prev = current;
            current = current.parent;
        }
    }

    public boolean containsArchive(String fullName) {
        return this.inv.contains(fullName);
    }

    public Archive getArchive(String nameAndExtension) {
        if (nameAndExtension == null) {
            throw new IllegalArgumentException("The Archive must not be null");
        }
        return this.inv.get(nameAndExtension);
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String inventoryDetails() {
        Fields f;
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.fullName) + "======================\n");
        Enum[] enumArray = Fields.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            f = enumArray[n2];
            sb.append(String.format("%-30s%d%n", f.toString(), this.fields[f.ordinal()]));
            ++n2;
        }
        enumArray = Fields.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            f = enumArray[n2];
            sb.append(String.format("%-30s%d%n", "SUB-" + f.toString(), this.subFields[f.ordinal()]));
            ++n2;
        }
        sb.append("Inventory======================\n");
        enumArray = ArchiveInventory.ArchiveTypes.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum arcType = enumArray[n2];
            sb.append(String.format("%-30s%d%n", ((ArchiveInventory.ArchiveTypes)arcType).toString(), this.inv.getArchiveCount((ArchiveInventory.ArchiveTypes)arcType)));
            ++n2;
        }
        sb.append('\n');
        return sb.toString();
    }

    public Archive getParentArchive() {
        return this.parent;
    }

    public Set<String> getSubArchiveNames() {
        return this.inv.getArchiveNames();
    }

    public Collection<Archive> getSubArchives() {
        return this.inv.getArchiveCollection();
    }

    public int getArchiveCount(ArchiveInventory.ArchiveTypes arcType) {
        return this.inv.getArchiveCount(arcType);
    }

    public int getField(Fields f) {
        return this.fields[f.ordinal()];
    }

    public int getSubField(Fields f) {
        return this.subFields[f.ordinal()];
    }

    public int getFieldTotal(Fields f) {
        return this.fields[f.ordinal()] + this.subFields[f.ordinal()];
    }

    public int getFieldTotal(EnumSet<Fields> setOFFields) {
        int total = 0;
        for (Fields nextField : setOFFields) {
            total += this.fields[nextField.ordinal()] + this.subFields[nextField.ordinal()];
        }
        return total;
    }

    public void incrementField(Fields f) {
        int n = f.ordinal();
        this.fields[n] = this.fields[n] + 1;
        this.consolidateIncrement(f);
    }

    public int getTotalNumberOfArchives() {
        return this.inv.getTotalNumberOfArchives();
    }

    public int getTotalLevelsOfDescendants() {
        int count = 1;
        Collection<Archive> children = this.getSubArchives();
        int biggestDepth = 0;
        for (Archive next : children) {
            int thisDepth = next.getTotalLevelsOfDescendants();
            if (thisDepth <= biggestDepth) continue;
            biggestDepth = thisDepth;
        }
        return count + biggestDepth;
    }

    public int getTotalArchiveCount() {
        int count = 1;
        Collection<Archive> children = this.getSubArchives();
        for (Archive next : children) {
            count += next.getTotalArchiveCount();
        }
        return count;
    }

    public void setMetadataComplete(String value) {
        this.metadataComplete = value.toLowerCase();
    }

    public String getMetadataComplete() {
        return this.metadataComplete;
    }

    public String getEjbJarMetadataComplete() {
        return this.ejbJarMetadataComplete;
    }

    public void setEjbJarMetadataComplete(String ejbJarMetadataComplete) {
        this.ejbJarMetadataComplete = ejbJarMetadataComplete;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String v) {
        this.version = v;
    }

    public Set<String> getSpringManifestVersions() {
        return this.springManifestVersion;
    }

    public void addSpringManifestVersion(String v) {
        this.springManifestVersion.add(v);
    }

    public String getSpringManifestVersionsString() {
        HashSet<String> versionSet = new HashSet<String>();
        versionSet.addAll(this.getSpringManifestVersions());
        StringBuilder versionString = new StringBuilder();
        for (Archive next : this.getSubArchives()) {
            versionSet.addAll(next.getSpringManifestVersions());
        }
        if (versionSet != null && !versionSet.isEmpty()) {
            for (String springVersion : versionSet) {
                versionString.append(springVersion);
                versionString.append(", ");
            }
            return versionString.substring(0, versionString.length() - 2);
        }
        return null;
    }

    public Set<String> getSpringSchemaVersions() {
        return this.springSchemaVersion;
    }

    public void addSpringSchemaVersion(String v) {
        this.springSchemaVersion.add(v);
    }

    public String getSpringSchemaVersionsString() {
        HashSet<String> versionSet = new HashSet<String>();
        versionSet.addAll(this.getSpringSchemaVersions());
        StringBuilder versionString = new StringBuilder();
        for (Archive next : this.getSubArchives()) {
            versionSet.addAll(next.getSpringSchemaVersions());
        }
        if (versionSet != null && !versionSet.isEmpty()) {
            for (String springVersion : versionSet) {
                versionString.append(springVersion);
                versionString.append(", ");
            }
            return versionString.substring(0, versionString.length() - 2);
        }
        return null;
    }

    public void addPackage(AppPackage pack, AppPackage.Issue issue, String locations) {
        if (this.listOfAllPackagesInApp == null) {
            this.listOfAllPackagesInApp = new ArrayList<AppPackage>();
        }
        String[] arrOfLocations = locations.split(",");
        pack.addIssue(issue);
        String[] stringArray = arrOfLocations;
        int n = arrOfLocations.length;
        int n2 = 0;
        while (n2 < n) {
            String prob = stringArray[n2];
            pack.addLocation(issue, prob);
            int n3 = issue.ordinal();
            this.issueCount[n3] = this.issueCount[n3] + 1;
            this.hasIssues = true;
            ++n2;
        }
        if (!this.mapToPackageList.containsKey(pack.getName())) {
            this.listOfAllPackagesInApp.add(pack);
            this.mapToPackageList.put(pack.getName(), pack);
        }
    }

    public void replacePackage(int index, AppPackage pack) {
        this.listOfAllPackagesInApp.set(index, pack);
    }

    public int getPackageIndex(AppPackage pack) {
        return this.listOfAllPackagesInApp.indexOf(pack);
    }

    public List<AppPackage> getPackages() {
        return this.listOfAllPackagesInApp;
    }

    public SortedMap<String, String> getUnusedArchives() {
        return this.mapOfUnusedArchives;
    }

    public SortedMap<String, String> getUnusedArchiveChecksums() {
        return this.mapOfUnusedArchiveChecksums;
    }

    public SortedMap<String, String> getSharedLibDependencies() {
        return this.mapOfSharedLibDependencies;
    }

    public void addUnusedArchive(String archive, String referencedBy, String checksum) {
        this.hasIssues = true;
        int n = AppPackage.Issue.UNUSED_ARCHIVES.ordinal();
        this.issueCount[n] = this.issueCount[n] + 1;
        this.mapOfUnusedArchives.put(archive, referencedBy);
        this.mapOfUnusedArchiveChecksums.put(archive, checksum);
    }

    public void addSharedLibDependencies(String referencingClass, String referencedClass) {
        this.hasIssues = true;
        int n = AppPackage.Issue.SHARED_LIB_DEPENDENCIES.ordinal();
        this.issueCount[n] = this.issueCount[n] + 1;
        this.mapOfSharedLibDependencies.put(referencingClass, referencedClass);
    }

    public boolean hasIssues() {
        return this.hasIssues;
    }

    public AppPackage getPackage(String packageName) {
        return this.mapToPackageList.get(packageName);
    }

    public void sortPackages() {
        if (this.listOfAllPackagesInApp != null) {
            Collections.sort(this.listOfAllPackagesInApp, new Comparator<AppPackage>(){

                @Override
                public int compare(AppPackage o1, AppPackage o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
    }

    public int getTotalIssueCount(AppPackage.Issue issue) {
        return this.issueCount[issue.ordinal()];
    }

    public int getArchiveIssueCount(AppPackage.Issue issue) {
        return this.archiveIssueCount[issue.ordinal()];
    }

    public OrderedJSONObject toJSON(boolean isTopArchive, Map<String, String> sharedLibrariesChecksumMap) {
        ArrayList<String> sortedKeys;
        int count;
        int n;
        int n2;
        Object object;
        ArchiveInventory.ArchiveTypes[] containedArchiveTypes;
        String springBeanSchemaVersion;
        OrderedJSONObject archiveInventoryObject = new OrderedJSONObject();
        archiveInventoryObject.put("archiveName", this.fullName);
        archiveInventoryObject.put("moduleType", this.getArchiveType().getType());
        archiveInventoryObject.put("moduleVersion", this.version);
        String springManifestVersion = this.getSpringManifestVersionsString();
        if (springManifestVersion != null) {
            archiveInventoryObject.put("springVersion", springManifestVersion);
        }
        if ((springBeanSchemaVersion = this.getSpringSchemaVersionsString()) != null) {
            archiveInventoryObject.put("springBeanSchemaVersion", springBeanSchemaVersion);
        }
        if (this.metadataComplete == null) {
            if (this.getArchiveType().isMetadataCompletePossible()) {
                archiveInventoryObject.put("metadataComplete", Messages.getString("INVENTORY_REPORT_UNSPECIFIED_ATTRIBUTE"));
            } else {
                archiveInventoryObject.put("metadataComplete", this.metadataComplete);
            }
        } else if (this.metadataComplete.equals("ignored")) {
            archiveInventoryObject.put("metadataComplete", Messages.getString("INVENTORY_REPORT_IGNORED_ATTRIBUTE"));
        } else {
            archiveInventoryObject.put("metadataComplete", this.metadataComplete);
        }
        if (this.archiveSize != 0L) {
            archiveInventoryObject.put("moduleSize", (Object)this.archiveSize);
        }
        if (this.checksum != null) {
            archiveInventoryObject.put("checksum", this.checksum);
        }
        if ((containedArchiveTypes = ArchiveInventory.ArchiveTypes.getAllowedArchiveTypes(this.getArchiveType())).length > 0 && !ArchiveInventory.ArchiveTypes.isJarArchiveType(this.getArchiveType())) {
            OrderedJSONObject archiveSummaryObject = new OrderedJSONObject();
            object = containedArchiveTypes;
            n2 = containedArchiveTypes.length;
            n = 0;
            while (n < n2) {
                Enum arcType = object[n];
                count = this.getArchiveCount((ArchiveInventory.ArchiveTypes)arcType);
                archiveSummaryObject.put(((ArchiveInventory.ArchiveTypes)arcType).getJsonKey(), (Object)count);
                ++n;
            }
            archiveInventoryObject.put("archives", archiveSummaryObject);
        }
        OrderedJSONObject summaryObject = new OrderedJSONObject();
        object = Fields.values();
        n2 = ((Fields[])object).length;
        n = 0;
        while (n < n2) {
            Enum field = object[n];
            count = this.getFieldTotal((Fields)field);
            summaryObject.put(((Fields)field).getJsonKey(), (Object)count);
            ++n;
        }
        archiveInventoryObject.put("summary", summaryObject);
        if (isTopArchive) {
            OrderedJSONObject problemSummary = this.getProblemSummary();
            LinkedHashMap<String, String> locationMapAcross = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> locationMapWithin = new LinkedHashMap<String, String>();
            LinkedHashMap<List<String>, List<String>> javaMap = new LinkedHashMap<List<String>, List<String>>();
            LinkedHashMap<List<String>, List<String>> wasMap = new LinkedHashMap<List<String>, List<String>>();
            LinkedHashMap<List<String>, List<String>> ossMap = new LinkedHashMap<List<String>, List<String>>();
            HashMap<List<String>, List<String>> ossVersionMap = new HashMap<List<String>, List<String>>();
            LinkedHashMap<List<String>, List<String>> missingDependencyMap = new LinkedHashMap<List<String>, List<String>>();
            JSONArray dupClassesWithinArray = new JSONArray();
            JSONArray dupClassesAcrossArray = new JSONArray();
            JSONArray javaClassesArray = new JSONArray();
            JSONArray dupWebSphereArray = new JSONArray();
            JSONArray ossClassesArray = new JSONArray();
            JSONArray problemDetailArray = new JSONArray();
            JSONArray unusedArchiveArray = new JSONArray();
            JSONArray missingDependencyArray = new JSONArray();
            JSONArray sharedLibDepArray = new JSONArray();
            JSONArray systemPropertiesArray = new JSONArray();
            OrderedJSONObject dupClassesWithin = new OrderedJSONObject();
            OrderedJSONObject dupClassesAcross = new OrderedJSONObject();
            OrderedJSONObject javaClasses = new OrderedJSONObject();
            OrderedJSONObject wasClasses = new OrderedJSONObject();
            OrderedJSONObject ossClasses = new OrderedJSONObject();
            OrderedJSONObject unusedArchives = new OrderedJSONObject();
            OrderedJSONObject missingDependencies = new OrderedJSONObject();
            OrderedJSONObject sharedLibraries = new OrderedJSONObject();
            OrderedJSONObject systemProperties = new OrderedJSONObject();
            List<AppPackage> pkgs = this.getPackages();
            if (pkgs != null) {
                for (AppPackage pkg : pkgs) {
                    List<String> list;
                    List<AppPackage.Issue> issueList = pkg.getIssues();
                    if (issueList.contains((Object)AppPackage.Issue.DUPLICATE_CLASS)) {
                        List<String> listOfLocations = pkg.getLocations(AppPackage.Issue.DUPLICATE_CLASS);
                        this.addLocation(listOfLocations, pkg, locationMapAcross, locationMapWithin);
                    }
                    if (issueList.contains((Object)AppPackage.Issue.JAVA_EE_SE_CLASS)) {
                        list = pkg.getLocations(AppPackage.Issue.JAVA_EE_SE_CLASS);
                        this.addToMap(javaMap, pkg, list);
                    }
                    if (issueList.contains((Object)AppPackage.Issue.WAS_CLASS)) {
                        list = pkg.getLocations(AppPackage.Issue.WAS_CLASS);
                        this.addToMap(wasMap, pkg, list);
                    }
                    if (issueList.contains((Object)AppPackage.Issue.OSS_CLASS)) {
                        list = pkg.getLocations(AppPackage.Issue.OSS_CLASS);
                        this.addToMap(ossMap, pkg, list);
                        ArrayList<String> ossVersions = new ArrayList<String>();
                        ossVersions.add(pkg.getAffectServers());
                        ossVersionMap.put(list, ossVersions);
                    }
                    if (!issueList.contains((Object)AppPackage.Issue.MISSING_DEP)) continue;
                    list = pkg.getLocations(AppPackage.Issue.MISSING_DEP);
                    this.addToMap(missingDependencyMap, pkg, list);
                }
            }
            LinkedHashMap<List<String>, List<String>> dupClassesAcrossMap = this.convertStringMapToListMap(locationMapAcross);
            LinkedHashMap<List<String>, List<String>> dupClassesWithinMap = this.convertStringMapToListMap(locationMapWithin);
            SortedMap<String, String> locationMapUnusedJars = this.getUnusedArchives();
            SortedMap<String, String> checksumMapUnusedJars = this.getUnusedArchiveChecksums();
            SortedMap<String, String> locationMapSharedLibDependencies = this.getSharedLibDependencies();
            SortedMap<String, String> mapOfSystemProperties = this.getMapOfSystemProperties();
            this.addObjectToArray(dupClassesWithinArray, dupClassesWithinMap, null);
            dupClassesWithin.put("duplicateClassesWithinClassLoader", dupClassesWithinArray);
            this.addObjectToArray(dupClassesAcrossArray, dupClassesAcrossMap, null);
            dupClassesAcross.put("duplicateClassesAcrossApplication", dupClassesAcrossArray);
            this.addObjectToArray(javaClassesArray, javaMap, null);
            javaClasses.put("javaEEandSEClasses", javaClassesArray);
            this.addObjectToArray(dupWebSphereArray, wasMap, null);
            wasClasses.put("duplicateWebSphereClasses", dupWebSphereArray);
            this.addObjectToArray(ossClassesArray, ossMap, ossVersionMap);
            ossClasses.put("openSourceSoftwareClasses", ossClassesArray);
            this.addObjectToUnusedArchiveArray(unusedArchiveArray, locationMapUnusedJars, checksumMapUnusedJars, sharedLibrariesChecksumMap);
            unusedArchives.put("archivesNotReferenced", unusedArchiveArray);
            this.addObjectToMissingDependencyArray(missingDependencyArray, missingDependencyMap);
            missingDependencies.put("missingDependencies", missingDependencyArray);
            this.addObjectToSystemPropertiesArray(systemPropertiesArray, mapOfSystemProperties);
            systemProperties.put("classesWithSystemLevelJVMConfiguration", systemPropertiesArray);
            this.addObjectToSharedLibDepArray(sharedLibDepArray, locationMapSharedLibDependencies);
            sharedLibraries.put("sharedLibraryDependencies", sharedLibDepArray);
            problemDetailArray.add(dupClassesWithin);
            problemDetailArray.add(dupClassesAcross);
            problemDetailArray.add(javaClasses);
            problemDetailArray.add(wasClasses);
            problemDetailArray.add(ossClasses);
            problemDetailArray.add(unusedArchives);
            problemDetailArray.add(missingDependencies);
            problemDetailArray.add(systemProperties);
            problemDetailArray.add(sharedLibraries);
            archiveInventoryObject.put("potentialDeploymentProblemsSummary", problemSummary);
            archiveInventoryObject.put("potentialDeploymentProblemsDetails", problemDetailArray);
            if (this.getArchiveType().equals((Object)ArchiveInventory.ArchiveTypes.WAR) || this.getArchiveType().equals((Object)ArchiveInventory.ArchiveTypes.EAR)) {
                HashSet<String> suggestedArchives = new HashSet<String>(this.getMetadataSuggestions(false));
                ArrayList<String> sortedSuggestedArchives = new ArrayList<String>(suggestedArchives);
                Collections.sort(sortedSuggestedArchives);
                JSONArray archiveArray = new JSONArray();
                for (String archive : sortedSuggestedArchives) {
                    archiveArray.add(archive);
                }
                OrderedJSONObject archiveList = new OrderedJSONObject();
                archiveList.put("archivesThatAreCandidatesForMetadataCompleteTrueAttribute", archiveArray);
                this.buildExcessFileObject(ExcessFileType.EXCESS_CLASS, archiveList);
                this.buildExcessFileObject(ExcessFileType.EXCESS_WEB_MODULE_RESOURCE, archiveList);
                archiveInventoryObject.put("performanceConsiderations", archiveList);
            }
            if (this.deploymentTargets != null) {
                OrderedJSONObject operationalConsidersationsObject = new OrderedJSONObject();
                OrderedJSONObject deploymentTargetObject = new OrderedJSONObject();
                JSONArray clustersArray = new JSONArray();
                for (QosClusterTarget cluster : this.deploymentTargets.getClusterTargets()) {
                    OrderedJSONObject staticClusterObject = this.getJsonForCluster(cluster);
                    clustersArray.add(staticClusterObject);
                }
                deploymentTargetObject.put("clusters", clustersArray);
                JSONArray nonClusteredServersArray = new JSONArray();
                for (QosServerTarget server : this.deploymentTargets.getServerTargets()) {
                    OrderedJSONObject nonClusteredServerObject = new OrderedJSONObject();
                    nonClusteredServerObject.put("name", server.getServerName());
                    nonClusteredServerObject.put("node", server.getNodeName());
                    nonClusteredServerObject.put("type", server.getServerType());
                    nonClusteredServersArray.add(nonClusteredServerObject);
                }
                deploymentTargetObject.put("nonClusteredServers", nonClusteredServersArray);
                if (!deploymentTargetObject.isEmpty()) {
                    operationalConsidersationsObject.put("deploymentTargets", deploymentTargetObject);
                    archiveInventoryObject.put("operationalConsiderations", operationalConsidersationsObject);
                }
            }
        }
        if (!(sortedKeys = new ArrayList<String>(this.getSubArchiveNames())).isEmpty()) {
            JSONArray containedArchivesArray = new JSONArray();
            Collections.sort(sortedKeys);
            for (String key : sortedKeys) {
                Archive nextArchive = this.getArchive(key);
                OrderedJSONObject jsonArchive = nextArchive.toJSON(false, sharedLibrariesChecksumMap);
                containedArchivesArray.add(jsonArchive);
            }
            archiveInventoryObject.put("containedArchiveInventory", containedArchivesArray);
        }
        return archiveInventoryObject;
    }

    private OrderedJSONObject getJsonForCluster(QosClusterTarget cluster) {
        OrderedJSONObject clusterObject = new OrderedJSONObject();
        clusterObject.put("name", cluster.getName());
        clusterObject.put("clusterId", String.valueOf(cluster.getName()) + "_" + cluster.getXmiId());
        ReportUtility.addClusterTypeAndMinMaxToClusterJson(clusterObject, cluster.isDynamic(), cluster.getEffectiveMinInstances(), cluster.getEffectiveMaxInstances(), String.valueOf(cluster.getMembers().size()));
        clusterObject.put("isConfigDefault", (Object)cluster.isConfigDefault());
        JSONArray membersArray = new JSONArray();
        for (QosServerTarget server : cluster.getMembers()) {
            OrderedJSONObject serverMemberObject = new OrderedJSONObject();
            serverMemberObject.put("name", server.getServerName());
            serverMemberObject.put("node", server.getNodeName());
            membersArray.add(serverMemberObject);
        }
        clusterObject.put("members", membersArray);
        ReportUtility.addSessionPersistenceTypeToClusterJson(clusterObject, cluster.getSessionReplicationType());
        ReportUtility.addTransactionLogTypeToClusterJson(clusterObject, cluster.getTransactionLogType());
        return clusterObject;
    }

    private void addObjectToSystemPropertiesArray(JSONArray systemPropertiesArray, SortedMap<String, String> map) {
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            OrderedJSONObject classWithSystemProperties = new OrderedJSONObject();
            classWithSystemProperties.put("classFile", key);
            JSONArray methodArray = new JSONArray();
            String[] stringArray = ((String)map.get(key)).split(", ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                methodArray.add(entry);
                ++n2;
            }
            classWithSystemProperties.put("methodsFound", methodArray);
            systemPropertiesArray.add(classWithSystemProperties);
        }
    }

    private void buildExcessFileObject(ExcessFileType type, OrderedJSONObject archiveList) {
        TreeMap<String, String> archivesWithExcessiveFiles = this.getArchivesWithExcessFiles(type);
        Set<String> archiveKeySet = archivesWithExcessiveFiles.keySet();
        JSONArray archiveArray = new JSONArray();
        for (String archiveName : archiveKeySet) {
            OrderedJSONObject archiveObject = new OrderedJSONObject();
            int numClasses = Integer.parseInt(archivesWithExcessiveFiles.get(archiveName));
            archiveObject.put("archiveName", archiveName);
            archiveObject.put("numberOfFiles", (Object)numClasses);
            archiveArray.add(archiveObject);
        }
        archiveList.put(type.getJsonName(), archiveArray);
    }

    private OrderedJSONObject getProblemSummary() {
        OrderedJSONObject probSummaryObj = new OrderedJSONObject();
        probSummaryObj.put("archivesContainingDuplicateClasses", (Object)this.getArchiveCount(AppPackage.Issue.DUPLICATE_CLASS));
        probSummaryObj.put("archivesContainingJavaEEorSEClasses", (Object)this.getArchiveCount(AppPackage.Issue.JAVA_EE_SE_CLASS));
        probSummaryObj.put("archivesContainingConflictingOpenSourceSoftwareClasses", (Object)this.getArchiveCount(AppPackage.Issue.OSS_CLASS));
        probSummaryObj.put("archivesContainingWebSphereClasses", (Object)this.getArchiveCount(AppPackage.Issue.WAS_CLASS));
        probSummaryObj.put("archivesNotReferencedInTheApplication", (Object)this.getArchiveCount(AppPackage.Issue.UNUSED_ARCHIVES));
        probSummaryObj.put("archivesWithMissingDependenciesInTheApplication", (Object)this.getArchiveCount(AppPackage.Issue.MISSING_DEP));
        probSummaryObj.put("classesWithSystemLevelJVMConfiguration", (Object)this.getArchiveCount(AppPackage.Issue.SYSTEM_LEVEL_PROPERTIES));
        probSummaryObj.put("sharedLibrariesReferencingApplicationClasses", (Object)this.getArchiveCount(AppPackage.Issue.SHARED_LIB_DEPENDENCIES));
        return probSummaryObj;
    }

    private LinkedHashMap<List<String>, List<String>> convertStringMapToListMap(LinkedHashMap<String, String> locationMapWithin) {
        Set<String> withinSet = locationMapWithin.keySet();
        LinkedHashMap<List<String>, List<String>> locListMap = new LinkedHashMap<List<String>, List<String>>();
        for (String k : withinSet) {
            ArrayList<String> keyList = new ArrayList<String>();
            ArrayList<String> valueList = new ArrayList<String>();
            keyList.add(k);
            valueList.add(locationMapWithin.get(k));
            locListMap.put(keyList, valueList);
        }
        return locListMap;
    }

    private void addObjectToArray(JSONArray array, LinkedHashMap<List<String>, List<String>> map, HashMap<List<String>, List<String>> versionMap) {
        Set<List<String>> keySet = map.keySet();
        if (!keySet.isEmpty()) {
            for (List<String> key : keySet) {
                String packages = map.get(key).toString();
                String locations = key.toString();
                JSONArray pkgArray = new JSONArray();
                JSONArray locArray = new JSONArray();
                String[] packageArray = this.splitStringValues(packages);
                String[] locationArray = this.splitStringValues(locations);
                String[] stringArray = packageArray;
                int n = packageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String pkg = stringArray[n2];
                    pkgArray.add(pkg);
                    ++n2;
                }
                stringArray = locationArray;
                n = locationArray.length;
                n2 = 0;
                while (n2 < n) {
                    String loc = stringArray[n2];
                    locArray.add(loc);
                    ++n2;
                }
                OrderedJSONObject conflictingPackages = new OrderedJSONObject();
                conflictingPackages.put("conflictingPackages", pkgArray);
                conflictingPackages.put("packageLocation", locArray);
                if (versionMap != null && versionMap.containsKey(key)) {
                    String versions = versionMap.get(key).toString();
                    String[] vArray = this.splitStringValues(versions);
                    JSONArray verArray = new JSONArray();
                    String[] stringArray2 = vArray;
                    int n3 = vArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String version = stringArray2[n4];
                        verArray.add(version);
                        ++n4;
                    }
                    conflictingPackages.put("appliesTo", verArray);
                }
                array.add(conflictingPackages);
            }
        }
    }

    private String[] splitStringValues(String str) {
        String newString = str.replaceAll("\\[|\\]|\\s+", "");
        String[] parts = newString.split(",");
        return parts;
    }

    private void addObjectToUnusedArchiveArray(JSONArray array, SortedMap<String, String> map, SortedMap<String, String> checksumMap, Map<String, String> sharedLibrariesChecksumMap) {
        Set<String> keySet = map.keySet();
        if (!keySet.isEmpty()) {
            for (String key : keySet) {
                OrderedJSONObject archiveNotReferenced = new OrderedJSONObject();
                archiveNotReferenced.put("archive", key.toString());
                archiveNotReferenced.put("referencedBy", ((String)map.get(key)).toString());
                String archiveChecksum = (String)checksumMap.get(key);
                if (archiveChecksum == null) {
                    archiveChecksum = sharedLibrariesChecksumMap.get(key);
                }
                archiveNotReferenced.put("checksum", archiveChecksum);
                array.add(archiveNotReferenced);
            }
        }
    }

    private void addObjectToSharedLibDepArray(JSONArray array, SortedMap<String, String> map) {
        Set<String> keySet = map.keySet();
        if (!keySet.isEmpty()) {
            for (String key : keySet) {
                JSONArray referencesArray = new JSONArray();
                String[] stringArray = ((String)map.get(key)).split("<br>");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    referencesArray.add(item);
                    ++n2;
                }
                OrderedJSONObject sharedLibraryDependencies = new OrderedJSONObject();
                sharedLibraryDependencies.put("sharedLibrary", key);
                sharedLibraryDependencies.put("referencedApplicationClass", referencesArray);
                array.add(sharedLibraryDependencies);
            }
        }
    }

    private void addObjectToMissingDependencyArray(JSONArray array, LinkedHashMap<List<String>, List<String>> map) {
        Set<List<String>> keySet = map.keySet();
        if (!keySet.isEmpty()) {
            for (List<String> key : keySet) {
                String packages = map.get(key).toString();
                String locations = key.toString();
                JSONArray dependencyArray = new JSONArray();
                JSONArray arcArray = new JSONArray();
                Object[] packageArray = this.splitStringValues(packages);
                Object[] locationArray = this.splitStringValues(locations);
                Arrays.sort(packageArray);
                Arrays.sort(locationArray);
                Object[] objectArray = packageArray;
                int n = packageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object pkg = objectArray[n2];
                    dependencyArray.add(pkg);
                    ++n2;
                }
                objectArray = locationArray;
                n = locationArray.length;
                n2 = 0;
                while (n2 < n) {
                    Object loc = objectArray[n2];
                    arcArray.add(loc);
                    ++n2;
                }
                OrderedJSONObject missingDependency = new OrderedJSONObject();
                missingDependency.put("missingDependencies", dependencyArray);
                missingDependency.put("archive", arcArray);
                array.add(missingDependency);
            }
        }
    }

    private void addToMap(HashMap<List<String>, List<String>> dupMap, AppPackage pkg, List<String> list) {
        if (dupMap.containsKey(list)) {
            List<String> newList = dupMap.get(list);
            newList.add(pkg.getName());
            dupMap.put(list, newList);
        } else {
            ArrayList<String> pkgName = new ArrayList<String>();
            pkgName.add(pkg.getName());
            dupMap.put(list, pkgName);
        }
    }

    private void addLocation(List<String> listOfLocations, AppPackage pack, LinkedHashMap<String, String> locationMapAcross, LinkedHashMap<String, String> locationMapWithin) {
        StringBuilder dupLocationSB = new StringBuilder();
        boolean includeInWithin = false;
        boolean includeInBoth = false;
        String prevParentArcName = "";
        LinkedHashMap<String, StringBuilder> mapOfParentArchToChild = new LinkedHashMap<String, StringBuilder>();
        int i = 0;
        while (i < listOfLocations.size()) {
            StringBuilder childArchs;
            String currentPackageLocation = listOfLocations.get(i);
            String currentParentArcName = Pattern.compile("([a-zA-Z]:)?\\/.*").matcher(currentPackageLocation).replaceFirst("");
            if (currentParentArcName.equals(currentPackageLocation)) {
                currentParentArcName = "topArchive";
            }
            if (mapOfParentArchToChild.containsKey(currentParentArcName)) {
                childArchs = (StringBuilder)mapOfParentArchToChild.get(currentParentArcName);
                childArchs.append(", ");
                childArchs.append(currentPackageLocation);
                mapOfParentArchToChild.put(currentParentArcName, childArchs);
            } else {
                childArchs = new StringBuilder(currentPackageLocation);
                mapOfParentArchToChild.put(currentParentArcName, childArchs);
            }
            if (!includeInWithin && !prevParentArcName.isEmpty() && currentPackageLocation.endsWith(".jar") && currentParentArcName.equals(prevParentArcName)) {
                includeInWithin = true;
                if (i > 1) {
                    includeInBoth = true;
                }
            }
            if (includeInWithin && !prevParentArcName.equals(currentParentArcName)) {
                includeInBoth = true;
            }
            prevParentArcName = currentParentArcName;
            dupLocationSB.append(currentPackageLocation);
            if (i + 1 != listOfLocations.size()) {
                dupLocationSB.append(", ");
            }
            ++i;
        }
        if (includeInBoth) {
            this.addToLocationMap(locationMapAcross, null, dupLocationSB, pack);
            for (String key : mapOfParentArchToChild.keySet()) {
                StringBuilder locationsSB = (StringBuilder)mapOfParentArchToChild.get(key);
                String locations = locationsSB.toString();
                if (!locations.contains(", ") || !key.endsWith(".war") && !key.endsWith(".ear")) continue;
                this.addToLocationMap(locationMapWithin, null, locationsSB, pack);
            }
        } else if (includeInWithin) {
            this.addToLocationMap(locationMapWithin, null, dupLocationSB, pack);
        } else {
            this.addToLocationMap(locationMapAcross, null, dupLocationSB, pack);
        }
    }

    private void addToLocationMap(LinkedHashMap<String, String> locationMap, Map<String, String> serverMap, StringBuilder sb, AppPackage pack) {
        String locations = sb.toString();
        if (serverMap != null) {
            serverMap.put(locations, pack.getAffectServers());
        }
        if (locationMap.containsKey(locations)) {
            String packageNames = locationMap.get(locations);
            packageNames = String.valueOf(packageNames) + ", " + pack.getName();
            locationMap.put(locations, packageNames);
        } else {
            locationMap.put(locations, pack.getName());
        }
    }

    public Set<String> getMetadataSuggestions(boolean recursed) {
        HashSet<String> metadataSuggestions = new HashSet<String>();
        if (this.getArchiveType().equals((Object)ArchiveInventory.ArchiveTypes.EAR)) {
            Collection<Archive> archiveInventory = this.getSubArchives();
            for (Archive arch : archiveInventory) {
                Set<String> results = arch.getMetadataSuggestions(true);
                metadataSuggestions.addAll(results);
            }
        } else if (this.getArchiveType().equals((Object)ArchiveInventory.ArchiveTypes.WAR)) {
            String version = this.getVersion();
            double versionNum = -1.0;
            if (version != null) {
                try {
                    versionNum = Double.parseDouble(version);
                }
                catch (NumberFormatException numberFormatException) {
                    version = null;
                }
            }
            if (!(version != null && !(versionNum > 2.4) || this.isMetadataCompleteTrue() && !this.isEjbJarXmlFound())) {
                ArchiveInventory containedArchives = this.inv;
                if (!containedArchives.getArchiveCollection().isEmpty()) {
                    Collection<Archive> subArchives = this.getSubArchives();
                    int numTotalArchives = subArchives.size();
                    int numTotalEJBArchives = containedArchives.getArchiveCount(ArchiveInventory.ArchiveTypes.EJB_JAR);
                    HashSet<String> ejbMetadataSuggestions = new HashSet<String>();
                    for (Archive archive : containedArchives) {
                        String metadataCompleteValue = archive.getMetadataComplete();
                        if (archive.getArchiveType().equals((Object)ArchiveInventory.ArchiveTypes.EJB_JAR)) {
                            if ((!this.ejbJarXmlFound || this.getEjbJarMetadataComplete() != null && !this.ejbJarMetadataComplete.equals("false")) && (this.ejbJarXmlFound || this.isMetadataCompleteTrue())) continue;
                            this.addMetadataSuggestions(recursed, metadataSuggestions, archive, true, ejbMetadataSuggestions);
                            continue;
                        }
                        if (!archive.getArchiveType().equals((Object)ArchiveInventory.ArchiveTypes.WEB_FRAGMENT_JAR) || this.isMetadataCompleteTrue()) continue;
                        boolean compareVal = metadataCompleteValue == null || metadataCompleteValue.equals("false");
                        this.addMetadataSuggestions(recursed, metadataSuggestions, archive, compareVal, ejbMetadataSuggestions);
                    }
                    if (ejbMetadataSuggestions.size() != numTotalEJBArchives) {
                        metadataSuggestions.removeAll(ejbMetadataSuggestions);
                    }
                    if (metadataSuggestions.size() != numTotalArchives) {
                        this.suggestionsToRemove.add(this.fullName);
                    } else {
                        metadataSuggestions.clear();
                    }
                }
                if (!(this.suggestionsToRemove.contains(this.getFullName()) || this.hasAnnotations || this.isMetadataCompleteTrue())) {
                    if (recursed) {
                        String archivePathName = ReportUtility.getArchiveNamePath(this.getFullName(), true);
                        metadataSuggestions.add(archivePathName);
                    } else {
                        metadataSuggestions.add(this.name);
                    }
                }
            }
        } else if (this.getArchiveType().isMetadataCompletePossible() && !this.hasAnnotations && !this.isMetadataCompleteTrue()) {
            String archivePathName = ReportUtility.getArchiveNamePath(this.getFullName(), true);
            metadataSuggestions.add(archivePathName);
        }
        return metadataSuggestions;
    }

    private void addMetadataSuggestions(boolean recursed, Set<String> metadataSuggestions, Archive archive, boolean compareValue, Set<String> ejbMetadataSuggestions) {
        if (!archive.hasAnnotations && compareValue) {
            String archivePathName = archive.name;
            if (recursed) {
                archivePathName = ReportUtility.getArchiveNamePath(archive.getFullName(), true);
            }
            metadataSuggestions.add(archivePathName);
            if (archive.getArchiveType() == ArchiveInventory.ArchiveTypes.EJB_JAR) {
                ejbMetadataSuggestions.add(archivePathName);
            }
        }
    }

    public TreeMap<String, String> getArchivesWithExcessFiles(ExcessFileType type) {
        String numExcessFiles;
        TreeMap<String, String> archivesWithExcessFiles = new TreeMap<String, String>();
        if (this.getArchiveType() == ArchiveInventory.ArchiveTypes.EAR) {
            Collection<Archive> archiveInventory = this.getSubArchives();
            for (Archive arch : archiveInventory) {
                TreeMap<String, String> results = arch.getArchivesWithExcessFiles(type);
                archivesWithExcessFiles.putAll(results);
            }
        } else if (this.getArchiveType() == ArchiveInventory.ArchiveTypes.WAR && (numExcessFiles = this.getNumExcessFiles(type)) != null) {
            archivesWithExcessFiles.put(this.name, numExcessFiles);
        }
        return archivesWithExcessFiles;
    }

    public boolean hasAnnotations() {
        return this.hasAnnotations;
    }

    public void setHasAnnotations(DetailResult result) {
        this.hasAnnotations = true;
        this.addAnnoType(result.getCriteria());
    }

    public boolean isEjbJarXmlFound() {
        return this.ejbJarXmlFound;
    }

    public void setEjbJarXmlFound(boolean ejbJarXmlFound) {
        this.ejbJarXmlFound = ejbJarXmlFound;
    }

    public boolean isMetadataCompleteTrue() {
        if (this.ejbJarXmlFound) {
            return this.getEjbJarMetadataComplete() != null && this.getEjbJarMetadataComplete().equalsIgnoreCase("true");
        }
        return this.getMetadataComplete() != null && this.getMetadataComplete().equalsIgnoreCase("true");
    }

    public void addAnnoType(String annoTypeSet) {
        this.annotationTypeSet.add(annoTypeSet);
    }

    public Set<String> getAnnoTypeSet() {
        return this.annotationTypeSet;
    }

    public String getNumExcessFiles(ExcessFileType type) {
        switch (type) {
            case EXCESS_CLASS: {
                return this.numExcessClassFiles;
            }
            case EXCESS_WEB_MODULE_RESOURCE: {
                return this.numWebModuleResources;
            }
        }
        return null;
    }

    public void setNumExcessFiles(ExcessFileType type, String numExcessFiles) {
        switch (type) {
            case EXCESS_CLASS: {
                this.numExcessClassFiles = numExcessFiles;
                break;
            }
            case EXCESS_WEB_MODULE_RESOURCE: {
                this.numWebModuleResources = numExcessFiles;
            }
        }
    }

    public int[] calculateArchiveCountsPerIssueType() {
        int i;
        int[] subArchiveCount;
        for (Archive arch : this.getSubArchives()) {
            subArchiveCount = arch.calculateArchiveCountsPerIssueType();
            i = 0;
            while (i < subArchiveCount.length) {
                int n = i;
                this.archiveCountPerIssueTypeArray[n] = this.archiveCountPerIssueTypeArray[n] + subArchiveCount[i];
                ++i;
            }
        }
        for (Archive arch : this.getSharedLibraries()) {
            subArchiveCount = arch.calculateArchiveCountsPerIssueType();
            i = 0;
            while (i < subArchiveCount.length) {
                int n = i;
                this.archiveCountPerIssueTypeArray[n] = this.archiveCountPerIssueTypeArray[n] + subArchiveCount[i];
                ++i;
            }
        }
        int i2 = 0;
        while (i2 < this.archiveIssueCount.length) {
            if (this.archiveIssueCount[i2] > 0) {
                int n = i2;
                this.archiveCountPerIssueTypeArray[n] = this.archiveCountPerIssueTypeArray[n] + 1;
            }
            ++i2;
        }
        return this.archiveCountPerIssueTypeArray;
    }

    public int getArchiveCount(AppPackage.Issue issue) {
        return this.archiveCountPerIssueTypeArray[issue.ordinal()];
    }

    public void updateArchiveIssueCount(AppPackage.Issue issue) {
        int n = issue.ordinal();
        this.archiveIssueCount[n] = this.archiveIssueCount[n] + 1;
    }

    public int[] getArchiveIssueCount() {
        return this.archiveIssueCount;
    }

    public void setRaveTreeName(String raveTreeLabelName) {
        this.raveTreeLabelName = raveTreeLabelName;
    }

    public String getRaveTreeName() {
        return this.raveTreeLabelName;
    }

    public SortedMap<String, String> getMapOfSystemProperties() {
        TreeMap<String, String> stringSeperatedValuesMap = new TreeMap<String, String>();
        Set<String> keySet = this.mapOfSystemProperties.keySet();
        for (String key : keySet) {
            ArrayList sortedMapValues = new ArrayList((Collection)this.mapOfSystemProperties.get(key));
            Collections.sort(sortedMapValues);
            StringBuffer stringSeperatedValues = new StringBuffer();
            int i = 0;
            for (String value : sortedMapValues) {
                if (++i == sortedMapValues.size()) {
                    stringSeperatedValues.append(value);
                    continue;
                }
                stringSeperatedValues.append(String.valueOf(value) + ", ");
            }
            stringSeperatedValuesMap.put(key, stringSeperatedValues.toString());
        }
        return stringSeperatedValuesMap;
    }

    public void addToMapOfSystemProperties(String key, String value) {
        this.hasIssues = true;
        if (this.mapOfSystemProperties.containsKey(key)) {
            Set tempSet = (Set)this.mapOfSystemProperties.get(key);
            tempSet.add(value);
        } else {
            HashSet<String> newSet = new HashSet<String>();
            newSet.add(value);
            this.mapOfSystemProperties.put(key, newSet);
        }
    }

    public long getArchiveSize() {
        return this.archiveSize;
    }

    public void setArchiveSize(long archiveSize) {
        this.archiveSize = archiveSize;
    }

    public void setQoSVariables(String edition, String webSphereVersion, String adminHost, int adminPort, String cellName, boolean isZos, QosDeploymentTargets deploymentTargets, int recommendedNumberOfReplicas, int recommendedMinimumNumberOfReplicas, int recommendedMaximumNumberOfReplicas) {
        this.webSphereEdition = edition;
        this.webSphereVersion = webSphereVersion;
        this.adminHost = adminHost;
        this.adminPort = String.valueOf(adminPort);
        this.cellName = cellName;
        this.isZos = isZos;
        this.deploymentTargets = deploymentTargets;
        this.recommendedNumberOfReplicas = recommendedNumberOfReplicas;
        this.recommendedMinimumNumberOfReplicas = recommendedMinimumNumberOfReplicas;
        this.recommendedMaximumNumberOfReplicas = recommendedMaximumNumberOfReplicas;
    }

    public String getWebSphereEdition() {
        return this.webSphereEdition;
    }

    public String getWebSphereVersion() {
        return this.webSphereVersion;
    }

    public String getAdminPort() {
        return this.adminPort;
    }

    public String getCellName() {
        return this.cellName;
    }

    public boolean isZos() {
        return this.isZos;
    }

    public QosDeploymentTargets getDeploymentTargets() {
        return this.deploymentTargets;
    }

    public List<String> getListOfDeployedServer() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.deploymentTargets == null || this.deploymentTargets.getServerTargets() == null) {
            return result;
        }
        for (QosServerTarget server : this.deploymentTargets.getServerTargets()) {
            result.add(server.getServerName());
        }
        return result;
    }

    public List<String> getListOfClusters() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.deploymentTargets == null || this.deploymentTargets.getClusterTargets() == null) {
            return result;
        }
        for (QosClusterTarget cluster : this.deploymentTargets.getClusterTargets()) {
            result.add(cluster.getName());
        }
        return result;
    }

    public String getAdminHost() {
        return this.adminHost;
    }

    public List<String> getListOfClustersWithSessionReplication() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.deploymentTargets == null || this.deploymentTargets.getClusterTargets() == null) {
            return result;
        }
        for (QosClusterTarget cluster : this.deploymentTargets.getClusterTargets()) {
            if (!cluster.getSessionReplicationType().equals((Object)QosSessionPersistenceType.MEMORY_TO_MEMORY)) continue;
            result.add(cluster.getName());
        }
        return result;
    }

    public List<String> getListOfClustersWithSessionDatabase() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.deploymentTargets == null || this.deploymentTargets.getClusterTargets() == null) {
            return result;
        }
        for (QosClusterTarget cluster : this.deploymentTargets.getClusterTargets()) {
            if (!cluster.getSessionReplicationType().equals((Object)QosSessionPersistenceType.DATABASE)) continue;
            result.add(cluster.getName());
        }
        return result;
    }

    public List<String> getListOfClustersWithTransactionLogDatabase() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.deploymentTargets == null || this.deploymentTargets.getClusterTargets() == null) {
            return result;
        }
        for (QosClusterTarget cluster : this.deploymentTargets.getClusterTargets()) {
            if (!cluster.getTransactionLogType().equals((Object)QosTransactionLogType.DATABASE)) continue;
            result.add(cluster.getName());
        }
        return result;
    }

    public List<String> getListOfClustersWithTransactionLogFile() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.deploymentTargets == null || this.deploymentTargets.getClusterTargets() == null) {
            return result;
        }
        for (QosClusterTarget cluster : this.deploymentTargets.getClusterTargets()) {
            if (!cluster.getTransactionLogType().equals((Object)QosTransactionLogType.FILE)) continue;
            result.add(cluster.getName());
        }
        return result;
    }

    public int getRecommendedNumberOfReplicas() {
        return this.recommendedNumberOfReplicas;
    }

    public int getRecommendedMinimumNumberOfReplicas() {
        return this.recommendedMinimumNumberOfReplicas;
    }

    public int getRecommendedMaximumNumberOfReplicas() {
        if (this.recommendedMaximumNumberOfReplicas == -1 && this.recommendedNumberOfReplicas > -1) {
            return this.recommendedNumberOfReplicas;
        }
        return this.recommendedMaximumNumberOfReplicas;
    }

    public static enum AnnotationType {
        CDI,
        COMMON_ANNOTATIONS,
        COMMON_INTERCEPTOR,
        COMMON_SECURITY,
        JCA,
        JNDI,
        DI,
        EJB,
        FACES,
        JMS,
        MAIL,
        PERSISTENCE,
        PROCESSING,
        SERVLET,
        SCI,
        VALIDATION,
        WEB_SERVICES,
        WEB_SOCKET,
        UNKNOWN;

        private static final Map<String, AnnotationType> annotationsToTypeMap;

        static {
            annotationsToTypeMap = new HashMap<String, AnnotationType>();
            annotationsToTypeMap.put("javax.decorator", CDI);
            annotationsToTypeMap.put("javax.enterprise.context", CDI);
            annotationsToTypeMap.put("javax.enterprise.event.Observes", CDI);
            annotationsToTypeMap.put("javax.enterprise.inject", CDI);
            annotationsToTypeMap.put("javax.enterprise.util.Nonbinding", CDI);
            annotationsToTypeMap.put("javax.annotation", COMMON_ANNOTATIONS);
            annotationsToTypeMap.put("javax.interceptor", COMMON_INTERCEPTOR);
            annotationsToTypeMap.put("javax.annotation.security", COMMON_SECURITY);
            annotationsToTypeMap.put("javax.inject", DI);
            annotationsToTypeMap.put("javax.ejb", EJB);
            annotationsToTypeMap.put("javax.faces", FACES);
            annotationsToTypeMap.put("javax.resource.spi", JCA);
            annotationsToTypeMap.put("javax.resource", JCA);
            annotationsToTypeMap.put("javax.jms", JMS);
            annotationsToTypeMap.put("javax.annotation.sql", JNDI);
            annotationsToTypeMap.put("javax.mail", MAIL);
            annotationsToTypeMap.put("javax.persistence", PERSISTENCE);
            annotationsToTypeMap.put("javax.annotation.processing", PROCESSING);
            annotationsToTypeMap.put("javax.servlet.annotation.HandlesTypes", SCI);
            annotationsToTypeMap.put("javax.servlet.annotation", SERVLET);
            annotationsToTypeMap.put("javax.servlet.sip.annotation", SERVLET);
            annotationsToTypeMap.put("javax.validation", VALIDATION);
            annotationsToTypeMap.put("javax.websocket", WEB_SOCKET);
            annotationsToTypeMap.put("javax.ws.rs", WEB_SERVICES);
            annotationsToTypeMap.put("javax.xml.ws", WEB_SERVICES);
            annotationsToTypeMap.put("javax.jws", WEB_SERVICES);
        }

        public static AnnotationType getAnnotationType(String fullAnnoName) {
            if (annotationsToTypeMap.containsKey(fullAnnoName)) {
                return annotationsToTypeMap.get(fullAnnoName);
            }
            int indexOfPackage = fullAnnoName.lastIndexOf(46);
            if (indexOfPackage != -1) {
                fullAnnoName = fullAnnoName.substring(0, indexOfPackage);
                return AnnotationType.getAnnotationType(fullAnnoName);
            }
            return UNKNOWN;
        }
    }

    public static enum ExcessFileType {
        EXCESS_CLASS("DetectExcessClassFiles", "webModulesWithExcessiveClassFiles", Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_EXCESSIVE_CLASS_TITLE"), Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_EXCESSIVE_CLASS_SUMMARY_WAR"), Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_EXCESSIVE_CLASS_SUMMARY"), Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_EXCESSIVE_CLASS_HEADER_CLASS_FILES"), Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_EXCESSIVE_CLASSES_DESC_TXT"), Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_EXCESSIVE_CLASS_SUMMARY_WAR_DESC_TXT")),
        EXCESS_WEB_MODULE_RESOURCE("DetectExcessResourcesInWebModule", "webModulesWithExcessiveStaticResources", Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_EXCESSIVE_WEB_MODULE_RESOURCE_ARCHIVE_LIST"), Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_EXCESSIVE_WEB_MODULE_RESOURCE_SUMMARY_WAR"), Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_EXCESSIVE_WEB_MODULE_RESOURCE_SUMMARY"), Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_EXCESSIVE_WEB_MODULE_RESOURCE_ARCHIVE_LIST_HEADER_CLASS_FILES"), Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_EXCESSIVE_WEB_MODULE_RESOURCE_DESC_TXT"), Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_EXCESSIVE_WEB_MODULE_RESOURCE_SUMMARY_WAR_DESC_TXT"));

        private final String ruleName;
        private final String jsonName;
        private final String archiveList;
        private final String warSummary;
        private final String summary;
        private final String fileType;
        private final String textDesc;
        private final String textWARDesc;

        private ExcessFileType(String ruleName, String jsonName, String archiveList, String warSummary, String summary, String files, String textDesc, String textWARDesc) {
            this.ruleName = ruleName;
            this.jsonName = jsonName;
            this.archiveList = archiveList;
            this.warSummary = warSummary;
            this.summary = summary;
            this.fileType = files;
            this.textDesc = textDesc;
            this.textWARDesc = textWARDesc;
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public String getJsonName() {
            return this.jsonName;
        }

        public String getArchiveList() {
            return this.archiveList;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getWarSummary() {
            return this.warSummary;
        }

        public String getFileType() {
            return this.fileType;
        }

        public String getTxtDesc() {
            return this.textDesc;
        }

        public String getTxtWARDesc() {
            return this.textWARDesc;
        }
    }

    public static enum Fields {
        SERVLETS("INVENTORY_REPORT_SERVLETS", "CountServlets", "servlets", "#9855D4"),
        JSP_FILES("INVENTORY_REPORT_JSP_FILES", "CountJspFiles", "jsps", "#D7AAFF"),
        JPA_ENTITIES("INVENTORY_REPORT_JPA_ENTITIES", "CountJPAEntityBeans", "jpaEntities", "#B4E051"),
        BMP_ENTITY_BEANS("INVENTORY_REPORT_BMP_ENTITY_BEANS", "CountBMPEntityBeans", "bmpEntityBeans", "#008571"),
        CMP_ENTITY_BEANS("INVENTORY_REPORT_CMP_ENTITY_BEANS", "CountCMPEntityBeans", "cmpEntityBeans", "#41D6C3"),
        MESSAGE_DRIVEN_BEANS("INVENTORY_REPORT_MESSAGE_DRIVEN_BEANS", "CountMessageDrivenBeans", "messageDrivenBeans", "#3076A1"),
        SINGLETON_SESSION_BEANS("INVENTORY_REPORT_SINGLETON_SESSION_BEANS", "CountSingletonSessionBeans", "singletonSessionBeans", "#7CC7FF"),
        STATEFUL_SESSION_BEANS("INVENTORY_REPORT_STATEFUL_SESSION_BEANS", "CountStatefulSessionBeans", "statefulSessionBeans", "#478DE4"),
        STATELESS_SESSION_BEANS("INVENTORY_REPORT_STATELESS_SESSION_BEANS", "CountStatelessSessionBeans", "statelessSessionBeans", "#264A60"),
        CONSUMER_JAXRPC("INVENTORY_REPORT_CONSUMER_JAXRPC", "CountJAXRPCConsumers", "jaxrpcConsumers", "#CE3709"),
        PROVIDER_JAXRPC("INVENTORY_REPORT_PROVIDER_JAXRPC", "CountJAXRPCProviders", "jaxrpcProviders", "#FFA573"),
        CONSUMER_JAXRS("INVENTORY_REPORT_CONSUMER_JAXRS", "CountJAXRSConsumers", "jaxrsConsumers", "#2D660A"),
        PROVIDER_JAXRS("INVENTORY_REPORT_PROVIDER_JAXRS", "CountJAXRSProviders", "jaxrsProviders", "#5AA700"),
        CONSUMER_JAXWS("INVENTORY_REPORT_CONSUMER_JAXWS", "CountJAXWSConsumers", "jaxwsConsumers", "#ABAB09"),
        PROVIDER_JAXWS("INVENTORY_REPORT_PROVIDER_JAXWS", "CountJAXWSProviders", "jaxwsProviders", "#E0D951"),
        SPRING_BEANS("INVENTORY_REPORT_SPRING_BEANS", "CountSpringBeans", "springBeans", "#fffb00");

        private final String messageKey;
        private final String ruleName;
        private final String color;
        private final String jsonKey;
        private static Map<String, Fields> lookup;
        private static final EnumSet<Fields> webServices;
        private static final EnumSet<Fields> ejbBeans;
        private static final EnumSet<Fields> springBeans;

        static {
            webServices = EnumSet.of(CONSUMER_JAXRPC, new Fields[]{PROVIDER_JAXRPC, CONSUMER_JAXRS, PROVIDER_JAXRS, CONSUMER_JAXWS, PROVIDER_JAXWS});
            ejbBeans = EnumSet.of(BMP_ENTITY_BEANS, new Fields[]{CMP_ENTITY_BEANS, MESSAGE_DRIVEN_BEANS, SINGLETON_SESSION_BEANS, STATEFUL_SESSION_BEANS, STATELESS_SESSION_BEANS});
            springBeans = EnumSet.of(SPRING_BEANS);
        }

        public static Fields getField(String name2) {
            if (lookup == null) {
                Fields.initMapping();
            }
            return lookup.get(name2);
        }

        private static void initMapping() {
            lookup = new HashMap<String, Fields>();
            Fields[] fieldsArray = Fields.values();
            int n = fieldsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Fields s = fieldsArray[n2];
                lookup.put(s.ruleName, s);
                ++n2;
            }
        }

        private Fields(String key, String name2, String json, String colorCode) {
            this.messageKey = key;
            this.ruleName = name2;
            this.color = colorCode;
            this.jsonKey = json;
        }

        public static EnumSet<Fields> getEjbBeanFields() {
            return ejbBeans;
        }

        public static EnumSet<Fields> getWebServiceFields() {
            return webServices;
        }

        public static EnumSet<Fields> getSpringBeanFields() {
            return springBeans;
        }

        public String getLabel() {
            return Messages.getMessage(this.messageKey, new Object[0]);
        }

        public String getColor() {
            return this.color;
        }

        public String getJsonKey() {
            return this.jsonKey;
        }

        public boolean isEJBBean() {
            return ejbBeans.contains((Object)this);
        }

        public boolean isWebService() {
            return webServices.contains((Object)this);
        }

        public boolean isSpringBean() {
            return springBeans.contains((Object)this);
        }

        public String toString() {
            return this.getLabel();
        }
    }
}

