/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.utilities;

import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectAttribute;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.DetectDTD;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectEnumOrField;
import com.ibm.ws.report.binary.rules.DetectFeature;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.rules.DetectHtmlActionTag;
import com.ibm.ws.report.binary.rules.DetectJspTaglib;
import com.ibm.ws.report.binary.rules.DetectManifestAttribute;
import com.ibm.ws.report.binary.rules.DetectMethod;
import com.ibm.ws.report.binary.rules.DetectMultipleCriteria;
import com.ibm.ws.report.binary.rules.DetectPackage;
import com.ibm.ws.report.binary.rules.DetectPackageAndBundleImports;
import com.ibm.ws.report.binary.rules.DetectProperty;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.DetectStringLiteral;
import com.ibm.ws.report.binary.rules.Rule;
import com.ibm.ws.report.binary.utilities.ArgumentDetail;
import com.ibm.ws.report.binary.utilities.BinaryReportBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RuleHelper {
    public static String[] detectElementNames = new String[]{"detectAnnotation", "detectClass", "detectConstructor", "detectConstructorParameter", "detectEnumOrField", "detectFile", "detectJspTaglib", "detectHtmlActionTag", "detectManifestAttribute", "detectMethod", "detectMethodParameter", "detectPackage", "detectProperty", "detectStringLiteral", "detectAttribute", "detectDTD", "detectElement", "or", "and"};

    public static DetectMethod createDetectMethodRule(Element parent, String ruleName, String desc) {
        return RuleHelper.createDetectMethodRule(parent, ruleName, desc, DetectRule.FlagOnce.NONE);
    }

    public static DetectMethod createDetectMethodRule(Element parent, String ruleName, String desc, DetectRule.FlagOnce flagOnce) {
        String elementName = parent.getTagName();
        NamedNodeMap attrs = parent.getAttributes();
        String methodName = RuleHelper.getStringAttribute(attrs, "name");
        if (elementName.equals("detectConstructor") || elementName.equals("detectConstructorParameter")) {
            methodName = "<init>";
        }
        String owner = RuleHelper.getStringAttribute(attrs, "owners");
        String returnType = RuleHelper.getStringAttribute(attrs, "returnType");
        String args = RuleHelper.getStringAttribute(attrs, "arguments");
        String excludePackageNames = RuleHelper.getStringAttribute(attrs, "excludePackageNames");
        String catchExceptions = RuleHelper.getStringAttribute(attrs, "flagCatchExceptions");
        String unhandledExceptions = RuleHelper.getStringAttribute(attrs, "flagUnhandledExceptions");
        flagOnce = RuleHelper.getFlagOnce(flagOnce, attrs);
        boolean hideResult = RuleHelper.getHideResult(attrs);
        ArrayList<ArgumentDetail> argDetails = null;
        if (elementName.equals("detectMethodParameter") || elementName.equals("detectConstructorParameter")) {
            NodeList detectChildren = parent.getElementsByTagName("argument");
            int numArgs = detectChildren.getLength();
            argDetails = new ArrayList<ArgumentDetail>(numArgs);
            int j = 0;
            while (j < numArgs) {
                Element nextValue = (Element)detectChildren.item(j);
                NamedNodeMap fieldAttrs = nextValue.getAttributes();
                String position = RuleHelper.getStringAttribute(fieldAttrs, "position");
                int pos = Integer.parseInt(position);
                boolean flagVar = RuleHelper.getBooleanAttribute(fieldAttrs, "flagVariable");
                String flagValue = RuleHelper.getStringAttribute(fieldAttrs, "flagStringLiteral");
                String flagVarValue = RuleHelper.getStringAttribute(fieldAttrs, "flagVariableValue");
                String flagType = RuleHelper.getStringAttribute(fieldAttrs, "flagType");
                boolean flagTypeLiteral = RuleHelper.getBooleanAttribute(fieldAttrs, "flagTypeLiteral");
                ArgumentDetail argDetail = new ArgumentDetail(pos, flagVar, flagTypeLiteral, flagValue, flagVarValue, flagType);
                argDetails.add(argDetail);
                ++j;
            }
        }
        DetectMethod thisRule = new DetectMethod(ruleName, desc, RuleHelper.splitArgs(methodName), RuleHelper.splitArgs(owner), returnType, args, RuleHelper.splitArgs(excludePackageNames), flagOnce, hideResult, argDetails, RuleHelper.splitArgs(catchExceptions), RuleHelper.splitArgs(unhandledExceptions), false);
        return thisRule;
    }

    public static DetectPackage createDetectPackageRule(Element parent, String ruleName, String desc) {
        return RuleHelper.createDetectPackageRule(parent, ruleName, desc, DetectRule.FlagOnce.NONE);
    }

    public static DetectPackage createDetectPackageRule(Element parent, String ruleName, String desc, DetectRule.FlagOnce flagOnce) {
        NamedNodeMap attrs = parent.getAttributes();
        String packageName = RuleHelper.getStringAttribute(attrs, "names");
        boolean useAppProvidedLibraries = RuleHelper.getBooleanAttribute(attrs, "useAppProvidedLibraries");
        boolean skipScanForUsage = RuleHelper.getBooleanAttribute(attrs, "skipScanForUsage");
        boolean providedAndUsed = RuleHelper.getBooleanAttribute(attrs, "detectProvidedAndUsed");
        boolean validateBundleImports = RuleHelper.getBooleanAttribute(attrs, "validateBundleImports");
        String excludeClassNames = RuleHelper.getStringAttribute(attrs, "excludeClassNames");
        String excludePackageNames = RuleHelper.getStringAttribute(attrs, "excludePackageNames");
        String providedPackageNames = RuleHelper.getStringAttribute(attrs, "providedPackages");
        String excludeReferences = RuleHelper.getStringAttribute(attrs, "excludeReferences");
        flagOnce = RuleHelper.getFlagOnce(flagOnce, attrs);
        boolean hideResult = RuleHelper.getHideResult(attrs);
        DetectPackage thisRule = null;
        thisRule = validateBundleImports ? new DetectPackageAndBundleImports(ruleName, desc, RuleHelper.splitArgs(packageName), useAppProvidedLibraries, skipScanForUsage, RuleHelper.splitArgs(excludeClassNames), RuleHelper.splitArgs(excludePackageNames), flagOnce == DetectRule.FlagOnce.ARCHIVE, validateBundleImports) : new DetectPackage(ruleName, desc, RuleHelper.splitArgs(packageName), useAppProvidedLibraries, skipScanForUsage, RuleHelper.splitArgs(excludeClassNames), RuleHelper.splitArgs(excludePackageNames), flagOnce, hideResult, providedAndUsed, RuleHelper.splitArgs(providedPackageNames), excludeReferences);
        return thisRule;
    }

    public static DetectClass createDetectClassRule(Element parent, String ruleName, String desc) {
        return RuleHelper.createDetectClassRule(parent, ruleName, desc, DetectRule.FlagOnce.NONE);
    }

    public static DetectClass createDetectClassRule(Element parent, String ruleName, String desc, DetectRule.FlagOnce flagOnce) {
        NamedNodeMap attrs = parent.getAttributes();
        String className = RuleHelper.getStringAttribute(attrs, "names");
        String classNameRegex = RuleHelper.getStringAttribute(attrs, "classNamePattern");
        String extendsClass = RuleHelper.getStringAttribute(attrs, "extends");
        String implementsClass = RuleHelper.getStringAttribute(attrs, "implements");
        boolean useAppProvidedLibraries = RuleHelper.getBooleanAttribute(attrs, "useAppProvidedLibraries");
        boolean skipScanForUsage = RuleHelper.getBooleanAttribute(attrs, "skipScanForUsage");
        flagOnce = RuleHelper.getFlagOnce(flagOnce, attrs);
        boolean hideResult = RuleHelper.getHideResult(attrs);
        NodeList detectChildren = parent.getElementsByTagName("missingMethod");
        int numChildren = detectChildren.getLength();
        String[] missingMethods = new String[numChildren];
        String[] missingMethodArgs = new String[numChildren];
        RuleHelper.getMethodInfo(detectChildren, missingMethods, missingMethodArgs);
        detectChildren = parent.getElementsByTagName("implementsMethod");
        numChildren = detectChildren.getLength();
        String[] implMethods = new String[numChildren];
        String[] implMethodArgs = new String[numChildren];
        String[] implMethodAccessFlags = new String[numChildren];
        RuleHelper.getImplMethodInfo(detectChildren, implMethods, implMethodArgs, implMethodAccessFlags);
        DetectClass thisRule = new DetectClass(ruleName, desc, RuleHelper.splitArgs(className), useAppProvidedLibraries, skipScanForUsage, flagOnce, hideResult, RuleHelper.splitArgs(extendsClass), RuleHelper.splitArgs(implementsClass), missingMethods, missingMethodArgs, implMethods, implMethodArgs, classNameRegex, implMethodAccessFlags);
        return thisRule;
    }

    protected static DetectRule.FlagOnce getFlagOnce(DetectRule.FlagOnce flagOnce, NamedNodeMap attrs) {
        DetectRule.FlagOnce thisFlagOnce = flagOnce;
        if (flagOnce == DetectRule.FlagOnce.NONE) {
            boolean flagOncePerModule = RuleHelper.getBooleanAttribute(attrs, "flagOnce");
            boolean flagOncePerFile = RuleHelper.getBooleanAttribute(attrs, "flagOncePerFile");
            if (flagOncePerModule) {
                thisFlagOnce = DetectRule.FlagOnce.ARCHIVE;
            } else if (flagOncePerFile) {
                thisFlagOnce = DetectRule.FlagOnce.FILE;
            }
        }
        return thisFlagOnce;
    }

    protected static boolean getHideResult(NamedNodeMap attrs) {
        return RuleHelper.getBooleanAttribute(attrs, "hideResult");
    }

    protected static void getMethodInfo(NodeList methodElements, String[] methodNames, String[] methodArgs) {
        int numChildren = methodElements.getLength();
        int j = 0;
        while (j < numChildren) {
            String args;
            Element nextMethod = (Element)methodElements.item(j);
            NamedNodeMap methodAttrs = nextMethod.getAttributes();
            String nameAttr = RuleHelper.getStringAttribute(methodAttrs, "name");
            if (nameAttr != null) {
                methodNames[j] = nameAttr;
            }
            if ((args = RuleHelper.getStringAttribute(methodAttrs, "arguments")) != null) {
                methodArgs[j] = args;
            }
            ++j;
        }
    }

    protected static void getImplMethodInfo(NodeList methodElements, String[] methodNames, String[] methodArgs, String[] accessFlags) {
        int numChildren = methodElements.getLength();
        int j = 0;
        while (j < numChildren) {
            String accessFlag;
            String args;
            Element nextMethod = (Element)methodElements.item(j);
            NamedNodeMap methodAttrs = nextMethod.getAttributes();
            String nameAttr = RuleHelper.getStringAttribute(methodAttrs, "name");
            if (nameAttr != null) {
                methodNames[j] = nameAttr;
            }
            if ((args = RuleHelper.getStringAttribute(methodAttrs, "arguments")) != null) {
                methodArgs[j] = args;
            }
            if ((accessFlag = RuleHelper.getStringAttribute(methodAttrs, "accessFlag")) != null) {
                accessFlags[j] = accessFlag;
            }
            ++j;
        }
    }

    public static DetectAnnotation createDetectAnnotationRule(Element parent, String ruleName, String desc) {
        return RuleHelper.createDetectAnnotationRule(parent, ruleName, desc, DetectRule.FlagOnce.NONE);
    }

    public static DetectAnnotation createDetectAnnotationRule(Element parent, String ruleName, String desc, DetectRule.FlagOnce flagOnce) {
        NamedNodeMap attrs = parent.getAttributes();
        String className = RuleHelper.getStringAttribute(attrs, "name");
        String type = RuleHelper.getStringAttribute(attrs, "type");
        flagOnce = RuleHelper.getFlagOnce(flagOnce, attrs);
        boolean hideResult = RuleHelper.getHideResult(attrs);
        String accessFlag = RuleHelper.getStringAttribute(attrs, "accessFlag");
        String defaultValue = RuleHelper.getStringAttribute(attrs, "defaultValue");
        String attributeName = RuleHelper.getStringAttribute(attrs, "attributeName");
        if (attributeName == null) {
            attributeName = "value";
        }
        String missingAttributeName = RuleHelper.getStringAttribute(attrs, "missingAttribute");
        NodeList detectChildren = parent.getElementsByTagName("field");
        int numValues = detectChildren.getLength();
        String[] values = new String[numValues];
        int j = 0;
        while (j < numValues) {
            Element nextValue = (Element)detectChildren.item(j);
            NamedNodeMap fieldAttrs = nextValue.getAttributes();
            String field = RuleHelper.getStringAttribute(fieldAttrs, "value");
            if (field != null) {
                values[j] = field;
            }
            ++j;
        }
        detectChildren = parent.getElementsByTagName("location");
        numValues = detectChildren.getLength();
        String location = null;
        String locationClass = null;
        String defaultName = null;
        if (numValues > 0) {
            Element nextValue = (Element)detectChildren.item(0);
            NamedNodeMap fieldAttrs = nextValue.getAttributes();
            location = RuleHelper.getStringAttribute(fieldAttrs, "type");
            locationClass = RuleHelper.getStringAttribute(fieldAttrs, "class");
            defaultName = RuleHelper.getStringAttribute(fieldAttrs, "defaultName");
        }
        DetectAnnotation thisRule = new DetectAnnotation(ruleName, desc, RuleHelper.splitArgs(className), attributeName, type, values, defaultValue, accessFlag, flagOnce, hideResult, location, defaultName, missingAttributeName, locationClass);
        return thisRule;
    }

    public static DetectEnumOrField createDetectEnumOrFieldRule(Element parent, String ruleName, String desc) {
        return RuleHelper.createDetectEnumOrFieldRule(parent, ruleName, desc, DetectRule.FlagOnce.NONE);
    }

    public static DetectEnumOrField createDetectEnumOrFieldRule(Element parent, String ruleName, String desc, DetectRule.FlagOnce flagOnce) {
        NamedNodeMap attrs = parent.getAttributes();
        String type = RuleHelper.getStringAttribute(attrs, "type");
        flagOnce = RuleHelper.getFlagOnce(flagOnce, attrs);
        boolean hideResult = RuleHelper.getHideResult(attrs);
        String value = RuleHelper.getStringAttribute(attrs, "value");
        DetectEnumOrField thisRule = new DetectEnumOrField(ruleName, desc, type, RuleHelper.splitArgs(value), flagOnce, hideResult);
        return thisRule;
    }

    public static DetectProperty createDetectPropertyRule(Element parent, String ruleName, String desc) {
        return RuleHelper.createDetectPropertyRule(parent, ruleName, desc, DetectRule.FlagOnce.NONE);
    }

    public static DetectProperty createDetectPropertyRule(Element parent, String ruleName, String desc, DetectRule.FlagOnce flagOnce) {
        NamedNodeMap attrs = parent.getAttributes();
        String file = RuleHelper.getStringAttribute(attrs, "file");
        boolean detectPomProperties = RuleHelper.getBooleanAttribute(attrs, "detectPomProperties");
        boolean detectMessageProperties = RuleHelper.getBooleanAttribute(attrs, "detectMessageProperties");
        NodeList detectChildren = parent.getElementsByTagName("property");
        int numProps = detectChildren.getLength();
        String[] keys = new String[numProps];
        String[] values = new String[numProps];
        int j = 0;
        while (j < numProps) {
            String value;
            String key;
            Element nextProperty = (Element)detectChildren.item(j);
            NamedNodeMap fieldAttrs = nextProperty.getAttributes();
            keys[j] = key = RuleHelper.getStringAttribute(fieldAttrs, "key");
            values[j] = value = RuleHelper.getStringAttribute(fieldAttrs, "value");
            ++j;
        }
        flagOnce = RuleHelper.getFlagOnce(flagOnce, attrs);
        boolean hideResult = RuleHelper.getHideResult(attrs);
        DetectProperty thisRule = new DetectProperty(ruleName, desc, file, keys, values, flagOnce, hideResult, detectPomProperties, detectMessageProperties);
        return thisRule;
    }

    public static DetectStringLiteral createDetectStringLiteralRule(Element parent, String ruleName, String desc) {
        return RuleHelper.createDetectStringLiteralRule(parent, ruleName, desc, DetectRule.FlagOnce.NONE);
    }

    public static DetectStringLiteral createDetectStringLiteralRule(Element parent, String ruleName, String desc, DetectRule.FlagOnce flagOnce) {
        NamedNodeMap attrs = parent.getAttributes();
        NodeList detectChildren = parent.getElementsByTagName("literal");
        int numLiterals = detectChildren.getLength();
        Pattern[] stringLiterals = new Pattern[numLiterals];
        int j = 0;
        while (j < numLiterals) {
            Element nextLiteral = (Element)detectChildren.item(j);
            String patternAttr = RuleHelper.getStringAttribute(nextLiteral.getAttributes(), "value");
            if (patternAttr != null) {
                stringLiterals[j] = Pattern.compile(patternAttr);
            }
            ++j;
        }
        flagOnce = RuleHelper.getFlagOnce(flagOnce, attrs);
        boolean hideResult = RuleHelper.getHideResult(attrs);
        return new DetectStringLiteral(ruleName, desc, stringLiterals, flagOnce, hideResult);
    }

    public static List<Rule> getRules(Element parent, String ruleName, String desc, String elementName, DetectRule.FlagOnce flagOnceType) {
        NodeList detectNodes = parent.getElementsByTagName(elementName);
        int numDetectNodes = detectNodes.getLength();
        ArrayList<Rule> detectRules = null;
        if (numDetectNodes > 0) {
            detectRules = new ArrayList<Rule>(numDetectNodes);
            int i = 0;
            while (i < numDetectNodes) {
                Element nextDetectNode = (Element)detectNodes.item(i);
                Rule thisRule = RuleHelper.createRule(nextDetectNode, ruleName, desc, elementName, flagOnceType);
                detectRules.add(thisRule);
                ++i;
            }
        }
        return detectRules;
    }

    public static List<Rule> getChildRules(Element parent, String ruleName, String desc, DetectRule.FlagOnce flagOnceType) {
        NodeList detectNodes = parent.getChildNodes();
        int numDetectNodes = detectNodes.getLength();
        ArrayList<Rule> detectRules = null;
        if (numDetectNodes > 0) {
            List<String> validRules = Arrays.asList(detectElementNames);
            detectRules = new ArrayList<Rule>(numDetectNodes);
            int i = 0;
            while (i < numDetectNodes) {
                Node nextDetectNode = detectNodes.item(i);
                String elementName = nextDetectNode.getNodeName();
                if (nextDetectNode instanceof Element && validRules.contains(elementName)) {
                    Rule thisRule = RuleHelper.createRule((Element)nextDetectNode, ruleName, desc, elementName, flagOnceType);
                    detectRules.add(thisRule);
                }
                ++i;
            }
        }
        return detectRules;
    }

    public static Rule createRule(Element node, String ruleName, String desc, String elementName, DetectRule.FlagOnce flagOnce) {
        DetectRule thisRule = null;
        if (elementName.equals("detectAnnotation")) {
            thisRule = RuleHelper.createDetectAnnotationRule(node, ruleName, desc, flagOnce);
        } else if (elementName.equals("detectClass")) {
            thisRule = RuleHelper.createDetectClassRule(node, ruleName, desc, flagOnce);
        } else if (elementName.equals("detectEnumOrField")) {
            thisRule = RuleHelper.createDetectEnumOrFieldRule(node, ruleName, desc, flagOnce);
        } else if (elementName.equals("detectFile")) {
            thisRule = RuleHelper.createDetectFileRule(node, ruleName, desc, flagOnce);
        } else if (elementName.equals("detectJspTaglib")) {
            thisRule = RuleHelper.createDetectJspTaglibRule(node, ruleName, desc, flagOnce);
        } else if (elementName.equals("detectHtmlActionTag")) {
            thisRule = RuleHelper.createDetectHtmlActionTagRule(node, ruleName, desc, flagOnce);
        } else if (elementName.equals("detectManifestAttribute")) {
            thisRule = RuleHelper.createDetectManifestAttributeRule(node, ruleName, desc, flagOnce);
        } else if (elementName.equals("detectMethod") || elementName.equals("detectMethodParameter") || elementName.equals("detectConstructor") || elementName.equals("detectConstructorParameter")) {
            thisRule = RuleHelper.createDetectMethodRule(node, ruleName, desc, flagOnce);
        } else if (elementName.equals("detectPackage")) {
            thisRule = RuleHelper.createDetectPackageRule(node, ruleName, desc, flagOnce);
        } else if (elementName.equals("detectProperty")) {
            thisRule = RuleHelper.createDetectPropertyRule(node, ruleName, desc, flagOnce);
        } else if (elementName.equals("detectStringLiteral")) {
            thisRule = RuleHelper.createDetectStringLiteralRule(node, ruleName, desc, flagOnce);
        } else if (elementName.equals("detectAttribute")) {
            thisRule = RuleHelper.createDetectAttributeRule(node, ruleName, desc, flagOnce);
        } else if (elementName.equals("detectDTD")) {
            thisRule = RuleHelper.createDetectDTDRule(node, ruleName, desc, flagOnce);
        } else if (elementName.equals("detectElement")) {
            thisRule = RuleHelper.createDetectElementRule(node, ruleName, desc, flagOnce);
        } else if (elementName.equals("and")) {
            thisRule = RuleHelper.createDetectMultipleCriteriaRule(node, ruleName, desc, DetectMultipleCriteria.LogicType.AND);
        } else if (elementName.equals("or")) {
            thisRule = RuleHelper.createDetectMultipleCriteriaRule(node, ruleName, desc, DetectMultipleCriteria.LogicType.OR);
        }
        return thisRule;
    }

    public static DetectMultipleCriteria createDetectMultipleCriteriaRule(Element parent, String ruleName, String desc, DetectMultipleCriteria.LogicType logicType) {
        Node grandParent = parent.getParentNode();
        NamedNodeMap attrs = parent.getAttributes();
        DetectRule.FlagOnce flagOnce = DetectRule.FlagOnce.NONE;
        flagOnce = RuleHelper.getFlagOnce(flagOnce, attrs);
        boolean hideResult = RuleHelper.getHideResult(attrs);
        ArrayList<Rule> theRules = new ArrayList();
        if ("detectMultipleCriteria".equals(parent.getTagName())) {
            String[] stringArray = detectElementNames;
            int n = detectElementNames.length;
            int n2 = 0;
            while (n2 < n) {
                String elementName = stringArray[n2];
                List<Rule> detectRules = RuleHelper.getRules(parent, ruleName, desc, elementName, flagOnce);
                if (detectRules != null) {
                    theRules.addAll(detectRules);
                }
                ++n2;
            }
        } else {
            theRules = RuleHelper.getChildRules(parent, ruleName, desc, flagOnce);
        }
        boolean isRoot = grandParent instanceof Element && grandParent.getNodeName().equals("rule");
        DetectMultipleCriteria thisRule = new DetectMultipleCriteria(ruleName, desc, theRules, flagOnce, logicType, hideResult, isRoot);
        return thisRule;
    }

    public static DetectFeature createDetectFeatureRule(BinaryReportBuilder builder, Element parent, String ruleName, String desc) {
        Element child;
        NodeList detectChildren;
        Element nextDetectNode;
        Rule detectJavaxImpl = null;
        Rule detectJakartaImpl = null;
        NodeList detectNodes = parent.getElementsByTagName("detectJavaxImplementationProvided");
        int numDetectNodes = detectNodes.getLength();
        if (numDetectNodes > 0) {
            nextDetectNode = (Element)detectNodes.item(0);
            detectChildren = nextDetectNode.getElementsByTagName("detectPackage");
            if (detectChildren.getLength() == 0) {
                detectChildren = nextDetectNode.getElementsByTagName("detectClass");
            }
            child = (Element)detectChildren.item(0);
            detectJavaxImpl = RuleHelper.createRule(child, ruleName, desc, child.getLocalName(), DetectRule.FlagOnce.NONE);
        }
        if ((numDetectNodes = (detectNodes = parent.getElementsByTagName("detectJakartaImplementationProvided")).getLength()) > 0) {
            nextDetectNode = (Element)detectNodes.item(0);
            detectChildren = nextDetectNode.getElementsByTagName("detectPackage");
            if (detectChildren.getLength() == 0) {
                detectChildren = nextDetectNode.getElementsByTagName("detectClass");
            }
            child = (Element)detectChildren.item(0);
            detectJakartaImpl = RuleHelper.createRule(child, ruleName, desc, child.getLocalName(), DetectRule.FlagOnce.NONE);
        }
        HashMap<String, List<Rule>> detectUsageRules = new HashMap<String, List<Rule>>();
        detectNodes = parent.getElementsByTagName("detectUsage");
        numDetectNodes = detectNodes.getLength();
        int j = 0;
        while (j < numDetectNodes) {
            Element nextDetectNode2 = (Element)detectNodes.item(j);
            String featureName = nextDetectNode2.getAttribute("feature");
            if (featureName.isEmpty()) {
                featureName = desc;
            }
            List<Rule> rules = null;
            if (detectUsageRules.containsKey(featureName)) {
                rules = (List)detectUsageRules.get(featureName);
            } else {
                rules = new ArrayList();
                detectUsageRules.put(featureName, rules);
            }
            Rule usageRule = null;
            String rule = nextDetectNode2.getAttribute("fileName");
            if (!rule.isEmpty()) {
                String ruleId = builder.loadOneRule(rule, null);
                usageRule = builder._reportRules.get(ruleId);
                builder._reportRules.remove(ruleId);
                builder._ruleIds.remove(ruleId);
                rules.add(usageRule);
            } else {
                NodeList children = nextDetectNode2.getElementsByTagName("*");
                int size = children.getLength();
                int i = 0;
                while (i < size) {
                    Element nextChild = (Element)children.item(i);
                    String childName = nextChild.getLocalName();
                    if (childName.startsWith("detect")) {
                        usageRule = RuleHelper.createRule(nextChild, ruleName, featureName, childName, DetectRule.FlagOnce.NONE);
                        rules.add(usageRule);
                    }
                    ++i;
                }
            }
            ++j;
        }
        DetectFeature thisRule = new DetectFeature(ruleName, desc, detectJavaxImpl, detectJakartaImpl, detectUsageRules);
        return thisRule;
    }

    public static DetectElement createDetectElementRule(Element parent, String ruleName, String desc) {
        return RuleHelper.createDetectElementRule(parent, ruleName, desc, DetectRule.FlagOnce.NONE);
    }

    public static DetectElement createDetectElementRule(Element parent, String ruleName, String desc, DetectRule.FlagOnce flagOnce) {
        NamedNodeMap attrs = parent.getAttributes();
        String tags = RuleHelper.getStringAttribute(attrs, "tags");
        String parentTag = RuleHelper.getStringAttribute(attrs, "parentTags");
        String value = RuleHelper.getStringAttribute(attrs, "value");
        String namespace = RuleHelper.getStringAttribute(attrs, "namespace");
        String docNamespace = RuleHelper.getStringAttribute(attrs, "documentNamespace");
        boolean onlyValidateDocNamespaceIfPresent = false;
        String documentNamespaceToValidate = RuleHelper.getStringAttribute(attrs, "validateDocumentNamespace");
        if (documentNamespaceToValidate == null && (documentNamespaceToValidate = RuleHelper.getStringAttribute(attrs, "validateDocumentNamespaceIfPresent")) != null) {
            onlyValidateDocNamespaceIfPresent = true;
        }
        String missingChildElement = RuleHelper.getStringAttribute(attrs, "missingChildElement");
        String missingChildElementValue = RuleHelper.getStringAttribute(attrs, "missingChildElementValue");
        String missingChildElementAttribute = RuleHelper.getStringAttribute(attrs, "missingChildElementAttribute");
        String missingChildElementAttributeValue = RuleHelper.getStringAttribute(attrs, "missingChildElementAttributeValue");
        boolean flagNotEmpty = RuleHelper.getBooleanAttribute(attrs, "flagNotEmpty");
        boolean flagDuplicate = RuleHelper.getBooleanAttribute(attrs, "flagDuplicate");
        NodeList detectElementChildren = parent.getElementsByTagName("xmlFile");
        int numXmlFiles = detectElementChildren.getLength();
        String[] xmlFiles = new String[numXmlFiles];
        int j = 0;
        while (j < numXmlFiles) {
            Element nextXmlFile = (Element)detectElementChildren.item(j);
            String patternAttr = RuleHelper.getStringAttribute(nextXmlFile.getAttributes(), "pattern");
            if (patternAttr != null) {
                xmlFiles[j] = patternAttr;
            }
            ++j;
        }
        boolean flagOnRootNode = RuleHelper.getBooleanAttribute(attrs, "flagRootNode");
        boolean flagNoRootNodePresent = RuleHelper.getBooleanAttribute(attrs, "flagNoRootNode");
        DetectRule.XMLFileType xmlFileType = RuleHelper.getXMLFileType(attrs);
        flagOnce = RuleHelper.getFlagOnce(flagOnce, attrs);
        boolean hideResult = RuleHelper.getHideResult(attrs);
        DetectElement thisRule = new DetectElement(ruleName, desc, RuleHelper.splitArgs(tags), xmlFiles, xmlFileType, flagOnRootNode, value, namespace, flagOnce, hideResult, docNamespace, flagNoRootNodePresent, missingChildElement, missingChildElementValue, flagNotEmpty, missingChildElementAttribute, missingChildElementAttributeValue, documentNamespaceToValidate, onlyValidateDocNamespaceIfPresent, RuleHelper.splitArgs(parentTag), flagDuplicate);
        return thisRule;
    }

    private static DetectRule.XMLFileType getXMLFileType(NamedNodeMap attrs) {
        String xmlFileTypeParameter = RuleHelper.getStringAttribute(attrs, "xmlFileType");
        return DetectRule.XMLFileType.getXMLFileType(xmlFileTypeParameter);
    }

    public static DetectAttribute createDetectAttributeRule(Element parent, String ruleName, String desc) {
        return RuleHelper.createDetectAttributeRule(parent, ruleName, desc, DetectRule.FlagOnce.NONE);
    }

    public static DetectAttribute createDetectAttributeRule(Element parent, String ruleName, String desc, DetectRule.FlagOnce flagOnce) {
        NamedNodeMap attrs = parent.getAttributes();
        String tags = RuleHelper.getStringAttribute(attrs, "tags");
        String value = RuleHelper.getStringAttribute(attrs, "attributeValue");
        String attributeName = RuleHelper.getStringAttribute(attrs, "attributeName");
        String namespace = RuleHelper.getStringAttribute(attrs, "namespace");
        String attributeNamespace = RuleHelper.getStringAttribute(attrs, "attributeNamespace");
        NodeList detectElementChildren = parent.getElementsByTagName("xmlFile");
        int numXmlFiles = detectElementChildren.getLength();
        String[] xmlFiles = new String[numXmlFiles];
        int j = 0;
        while (j < numXmlFiles) {
            Element nextXmlFile = (Element)detectElementChildren.item(j);
            String patternAttr = RuleHelper.getStringAttribute(nextXmlFile.getAttributes(), "pattern");
            if (patternAttr != null) {
                xmlFiles[j] = patternAttr;
            }
            ++j;
        }
        DetectRule.XMLFileType xmlFileType = RuleHelper.getXMLFileType(attrs);
        flagOnce = RuleHelper.getFlagOnce(flagOnce, attrs);
        boolean hideResult = RuleHelper.getHideResult(attrs);
        String documentNamespaceToValidate = RuleHelper.getStringAttribute(attrs, "validateDocumentNamespace");
        String documentNamespace = RuleHelper.getStringAttribute(attrs, "documentNamespace");
        boolean flagIfAttributeMissing = RuleHelper.getBooleanAttribute(attrs, "flagIfAttributeMissing");
        DetectAttribute thisRule = new DetectAttribute(ruleName, desc, RuleHelper.splitArgs(tags), xmlFiles, xmlFileType, namespace, attributeName, value, attributeNamespace, flagOnce, hideResult, documentNamespaceToValidate, documentNamespace, flagIfAttributeMissing);
        return thisRule;
    }

    public static DetectManifestAttribute createDetectManifestAttributeRule(Element parent, String ruleName, String desc) {
        return RuleHelper.createDetectManifestAttributeRule(parent, ruleName, desc, DetectRule.FlagOnce.NONE);
    }

    public static DetectManifestAttribute createDetectManifestAttributeRule(Element parent, String ruleName, String desc, DetectRule.FlagOnce flagOnce) {
        NamedNodeMap attrs = parent.getAttributes();
        String name2 = RuleHelper.getStringAttribute(attrs, "name");
        String value = RuleHelper.getStringAttribute(attrs, "value");
        String archiveName = RuleHelper.getStringAttribute(attrs, "archiveName");
        flagOnce = RuleHelper.getFlagOnce(flagOnce, attrs);
        boolean hideResult = RuleHelper.getHideResult(attrs);
        DetectManifestAttribute thisRule = new DetectManifestAttribute(ruleName, desc, name2, value, archiveName, flagOnce, hideResult);
        return thisRule;
    }

    public static DetectDTD createDetectDTDRule(Element parent, String ruleName, String desc) {
        return RuleHelper.createDetectDTDRule(parent, ruleName, desc, DetectRule.FlagOnce.NONE);
    }

    public static DetectDTD createDetectDTDRule(Element parent, String ruleName, String desc, DetectRule.FlagOnce flagOnce) {
        NodeList xmlFileNodes = parent.getElementsByTagName("xmlFile");
        int numXmlFiles = xmlFileNodes.getLength();
        String[] xmlFiles = new String[numXmlFiles];
        int j = 0;
        while (j < numXmlFiles) {
            Element nextXmlFile = (Element)xmlFileNodes.item(j);
            String patternAttr = RuleHelper.getStringAttribute(nextXmlFile.getAttributes(), "pattern");
            if (patternAttr != null) {
                xmlFiles[j] = patternAttr;
            }
            ++j;
        }
        NamedNodeMap attrs = parent.getAttributes();
        String rootElementName = RuleHelper.getStringAttribute(attrs, "rootTag");
        String dtdName = RuleHelper.getStringAttribute(attrs, "dtdName");
        boolean flagNullDocTypeWhenNoVersionAttrExists = RuleHelper.getBooleanAttribute(attrs, "flagNullDocTypeWhenNoVersionAttrExists");
        flagOnce = RuleHelper.getFlagOnce(flagOnce, attrs);
        boolean hideResult = RuleHelper.getHideResult(attrs);
        DetectDTD thisRule = new DetectDTD(ruleName, desc, rootElementName, dtdName, xmlFiles, flagOnce, hideResult, flagNullDocTypeWhenNoVersionAttrExists);
        return thisRule;
    }

    public static DetectJspTaglib createDetectJspTaglibRule(Element parent, String ruleName, String desc) {
        return RuleHelper.createDetectJspTaglibRule(parent, ruleName, desc, DetectRule.FlagOnce.NONE);
    }

    public static DetectJspTaglib createDetectJspTaglibRule(Element parent, String ruleName, String desc, DetectRule.FlagOnce flagOnce) {
        NodeList detectElementChildren = parent.getElementsByTagName("taglib");
        int numTaglibs = detectElementChildren.getLength();
        String[] taglibs = new String[numTaglibs];
        int j = 0;
        while (j < numTaglibs) {
            Element nextTaglib = (Element)detectElementChildren.item(j);
            String nameAttr = RuleHelper.getStringAttribute(nextTaglib.getAttributes(), "name");
            if (nameAttr != null) {
                taglibs[j] = nameAttr;
            }
            ++j;
        }
        NamedNodeMap attrs = parent.getAttributes();
        flagOnce = RuleHelper.getFlagOnce(flagOnce, attrs);
        boolean hideResult = RuleHelper.getHideResult(attrs);
        DetectJspTaglib thisRule = new DetectJspTaglib(ruleName, desc, taglibs, flagOnce, hideResult);
        return thisRule;
    }

    public static DetectHtmlActionTag createDetectHtmlActionTagRule(Element parent, String ruleName, String desc) {
        return RuleHelper.createDetectHtmlActionTagRule(parent, ruleName, desc, DetectRule.FlagOnce.NONE);
    }

    public static DetectHtmlActionTag createDetectHtmlActionTagRule(Element parent, String ruleName, String desc, DetectRule.FlagOnce flagOnce) {
        NamedNodeMap attrs = parent.getAttributes();
        NodeList detectElementChildren = parent.getElementsByTagName("taglibUri");
        int numUriList = detectElementChildren.getLength();
        String[] uriList = new String[numUriList];
        int j = 0;
        while (j < numUriList) {
            Element nextUri = (Element)detectElementChildren.item(j);
            String nameAttr = RuleHelper.getStringAttribute(nextUri.getAttributes(), "name");
            if (nameAttr != null) {
                uriList[j] = nameAttr;
            }
            ++j;
        }
        detectElementChildren = parent.getElementsByTagName("htmlAction");
        int numhtmlActionList = detectElementChildren.getLength();
        String[] htmlActionList = new String[numhtmlActionList];
        int j2 = 0;
        while (j2 < numhtmlActionList) {
            Element nextHtmlAction = (Element)detectElementChildren.item(j2);
            String nameAttr = RuleHelper.getStringAttribute(nextHtmlAction.getAttributes(), "name");
            if (nameAttr != null) {
                htmlActionList[j2] = nameAttr;
            }
            ++j2;
        }
        flagOnce = RuleHelper.getFlagOnce(flagOnce, attrs);
        boolean hideResult = RuleHelper.getHideResult(attrs);
        DetectHtmlActionTag thisRule = new DetectHtmlActionTag(ruleName, desc, uriList, htmlActionList, flagOnce, hideResult);
        return thisRule;
    }

    public static DetectFile createDetectFileRule(Element parent, String ruleName, String desc) {
        return RuleHelper.createDetectFileRule(parent, ruleName, desc, DetectRule.FlagOnce.NONE);
    }

    public static DetectFile createDetectFileRule(Element parent, String ruleName, String desc, DetectRule.FlagOnce flagOnce) {
        NodeList detectFileChildren = parent.getElementsByTagName("file");
        int numFiles = detectFileChildren.getLength();
        Pattern[] files = new Pattern[numFiles];
        String[] folders = new String[numFiles];
        String[] fileNames = new String[numFiles];
        int j = 0;
        while (j < numFiles) {
            String fileNameAttr;
            String folderAttr;
            Element nextXmlFile = (Element)detectFileChildren.item(j);
            String patternAttr = RuleHelper.getStringAttribute(nextXmlFile.getAttributes(), "pattern");
            if (patternAttr != null) {
                files[j] = Pattern.compile(patternAttr);
            }
            if ((folderAttr = RuleHelper.getStringAttribute(nextXmlFile.getAttributes(), "folder")) != null) {
                folders[j] = folderAttr;
            }
            if ((fileNameAttr = RuleHelper.getStringAttribute(nextXmlFile.getAttributes(), "fileName")) != null) {
                fileNames[j] = fileNameAttr;
            }
            ++j;
        }
        NamedNodeMap attrs = parent.getAttributes();
        flagOnce = RuleHelper.getFlagOnce(flagOnce, attrs);
        boolean hideResult = RuleHelper.getHideResult(attrs);
        boolean flagMissing = RuleHelper.getBooleanAttribute(attrs, "flagMissingFile");
        boolean detectPomProperties = RuleHelper.getBooleanAttribute(attrs, "detectPomProperties");
        boolean detectMessageProperties = RuleHelper.getBooleanAttribute(attrs, "detectMessageProperties");
        DetectFile thisRule = new DetectFile(ruleName, desc, files, flagOnce, hideResult, folders, fileNames, flagMissing, detectPomProperties, detectMessageProperties);
        return thisRule;
    }

    public static String[] splitArgs(String s) {
        if (s != null) {
            String newS = s.replace(" ", "");
            return newS.split(",");
        }
        return null;
    }

    private static boolean getBooleanAttribute(NamedNodeMap attrsNode, String attributeName) {
        Node attrNode;
        boolean flag = false;
        if (attrsNode != null && (attrNode = attrsNode.getNamedItem(attributeName)) != null) {
            String attrValue = attrNode.getNodeValue();
            flag = attrValue.equals("1") ? true : Boolean.parseBoolean(attrValue);
        }
        return flag;
    }

    private static String getStringAttribute(NamedNodeMap attrsNode, String attributeName) {
        Node attrNode;
        String attrValue = null;
        if (attrsNode != null && (attrNode = attrsNode.getNamedItem(attributeName)) != null) {
            attrValue = attrNode.getNodeValue();
        }
        return attrValue;
    }
}

