/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.utilities;

import com.ibm.ws.appconversion.jsp.core.model.CoreJspNodeModelMapper;
import com.ibm.ws.appconversion.jsp.core.model.JspNode;
import com.ibm.ws.appconversion.jsp.core.model.JspNodeType;
import com.ibm.ws.appconversion.jsp.core.model.TagIndex;
import com.ibm.ws.appconversion.jsp.core.model.TagLib;
import com.ibm.ws.appconversion.jsp.core.model.TagLibInfo;
import com.ibm.ws.appconversion.jsp.core.util.CoreJspHelper;
import com.ibm.ws.report.binary.utilities.JSPResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JspRuleUtil {
    public static final String GET_PROPERTY_ELEMENT = "getProperty";
    public static final String SET_PROPERTY_ELEMENT = "setProperty";
    public static final String FORWARD_ELEMENT = "forward";
    public static final String INCLUDE_ELEMENT = "include";
    public static final String PARAM_ELEMENT = "param";
    public static final String USE_BEAN_ELEMENT = "useBean";
    public static final String NAME_ATTR = "name";
    public static final String PROPERTY_ATTR = "property";
    public static final String PAGE_ATTR = "page";
    public static final String FLUSH_ATTR = "flush";
    public static final String VALUE_ATTR = "value";
    public static final String ID_ATTR = "id";
    public static final String SCOPE_ATTR = "scope";
    public static final String CLASS_ATTR = "class";
    public static final String TYPE_ATTR = "type";
    public static final String BEAN_NAME_ATTR = "beanName";
    public static final String JSP_DEFAULT_PREFIX = "jsp";
    public static final String JSP_DEFAULT_TLD = "com/ibm/ws/appconversion/weblogic/jsp/default.tld";
    public static Map<String, Set<String>> defaultJspAttributes = new HashMap<String, Set<String>>();

    static {
        HashSet<String> getPropertyAttrs = new HashSet<String>();
        getPropertyAttrs.add(NAME_ATTR);
        getPropertyAttrs.add(PROPERTY_ATTR);
        defaultJspAttributes.put(GET_PROPERTY_ELEMENT, getPropertyAttrs);
        HashSet<String> setPropertyAttrs = new HashSet<String>();
        setPropertyAttrs.add(NAME_ATTR);
        setPropertyAttrs.add(PROPERTY_ATTR);
        defaultJspAttributes.put(SET_PROPERTY_ELEMENT, setPropertyAttrs);
        HashSet<String> forwardAttrs = new HashSet<String>();
        forwardAttrs.add(PAGE_ATTR);
        defaultJspAttributes.put(FORWARD_ELEMENT, forwardAttrs);
        HashSet<String> includeAttrs = new HashSet<String>();
        includeAttrs.add(PAGE_ATTR);
        includeAttrs.add(FLUSH_ATTR);
        defaultJspAttributes.put(INCLUDE_ELEMENT, includeAttrs);
        HashSet<String> paramAttrs = new HashSet<String>();
        paramAttrs.add(NAME_ATTR);
        paramAttrs.add(VALUE_ATTR);
        defaultJspAttributes.put(PARAM_ELEMENT, paramAttrs);
        HashSet<String> useBeanAttrs = new HashSet<String>();
        useBeanAttrs.add(ID_ATTR);
        useBeanAttrs.add(SCOPE_ATTR);
        useBeanAttrs.add(CLASS_ATTR);
        useBeanAttrs.add(TYPE_ATTR);
        useBeanAttrs.add(BEAN_NAME_ATTR);
        defaultJspAttributes.put(USE_BEAN_ELEMENT, useBeanAttrs);
    }

    public static String[] getTagLibs(String jspData) {
        ArrayList<String> taglibList = new ArrayList<String>();
        String remainderJspData = jspData;
        int remainderLength = remainderJspData.length();
        boolean done = false;
        while (!done) {
            int beginIndex = remainderJspData.indexOf("<%@");
            if (beginIndex > -1) {
                int endIndex = remainderJspData.indexOf("%>", beginIndex);
                if (endIndex > -1) {
                    int remainderIndex;
                    String thisDirective = remainderJspData.substring(beginIndex, endIndex);
                    if (thisDirective.contains("taglib")) {
                        taglibList.add(thisDirective);
                    }
                    if (remainderLength > (remainderIndex = endIndex + 2)) {
                        remainderJspData = remainderJspData.substring(remainderIndex);
                        continue;
                    }
                    done = true;
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        String[] taglibs = new String[taglibList.size()];
        return taglibList.toArray(taglibs);
    }

    public static Map<String, String> getPrefixToTldURLMap(JSPResource jspResource) {
        HashMap<String, String> tagPrefixToURIMap = new HashMap<String, String>();
        List<JspNode> directiveNodes = CoreJspHelper.filterForNodeType(jspResource.getJSPNodes(), JspNodeType.DIRECTIVE);
        for (JspNode jspNode : directiveNodes) {
            TagLibInfo tli = CoreJspNodeModelMapper.getTagLibInfo(jspNode);
            if (tli == null) continue;
            tagPrefixToURIMap.put(tli.getPrefix(), tli.getUri());
        }
        return tagPrefixToURIMap;
    }

    public static List<TagIndex> getTagIndexes(JSPResource resource) {
        ArrayList<TagIndex> result = new ArrayList<TagIndex>();
        List<JspNode> nodes = CoreJspHelper.filterForNodeType(resource.getJSPNodes(), JspNodeType.HTML_ACTION);
        nodes.addAll(CoreJspHelper.filterForNodeType(resource.getJSPNodes(), JspNodeType.JSP_ACTION));
        for (JspNode jspNode : nodes) {
            TagIndex ti = CoreJspNodeModelMapper.getTagIndex(jspNode);
            if (ti == null) continue;
            result.add(ti);
        }
        return result;
    }

    public static List<JspNode> getNodesByTaglibUriList(JSPResource resource, String[] taglibUriList) {
        ArrayList<JspNode> resultList = new ArrayList<JspNode>();
        String[] stringArray = taglibUriList;
        int n = taglibUriList.length;
        int n2 = 0;
        while (n2 < n) {
            String taglibUri = stringArray[n2];
            TagLib taglib = JspRuleUtil.getTagLibFromURI(resource, taglibUri);
            if (taglib != null) {
                resultList.addAll(JspRuleUtil.getNodesByPrefix(resource, taglib.getPrefix()));
            }
            ++n2;
        }
        return resultList;
    }

    public static TagLib getTagLibFromURI(JSPResource resource, String taglibUri) {
        List<JspNode> jspNodes = CoreJspHelper.filterForNodeType(resource.getJSPNodes(), JspNodeType.DIRECTIVE);
        TagLib taglib = null;
        for (JspNode jspNode : jspNodes) {
            TagLib tl;
            if (!TagLib.isTagLibDirective(jspNode.getData()) || !(tl = new TagLib(jspNode.getData(), jspNode.getLine(), jspNode.getOffset(), jspNode.getData().length())).getUri().matches(taglibUri)) continue;
            taglib = tl;
            break;
        }
        return taglib;
    }

    public static List<JspNode> getNodesByPrefix(JSPResource resource, String prefix) {
        ArrayList<JspNode> resultList = new ArrayList<JspNode>();
        List<JspNode> jspNodes = CoreJspHelper.filterForNodeType(resource.getJSPNodes(), JspNodeType.HTML_ACTION);
        String htmlPrefixExpression = "<(\\s*)" + prefix + ":(.*)";
        for (JspNode jspNode : jspNodes) {
            if (!jspNode.getData().matches(htmlPrefixExpression)) continue;
            resultList.add(jspNode);
        }
        return resultList;
    }
}

