/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom.inventory;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.utilities.Constants;
import com.ibm.ws.report.technology.DetailResult;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class MissingDependencies
extends DetectFile {
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.java.MissingDepenedies";
    protected static final Pattern[] classFile = new Pattern[]{Constants.CLASS_FILE_REG};
    protected Map<String, String> missingClasses = new HashMap<String, String>();

    public MissingDependencies() {
        this("DependencyMap", RULE_DESC, classFile, false);
    }

    public MissingDependencies(String ruleName, String desc, Pattern[] files, boolean flagOnce) {
        super(ruleName, desc, files, flagOnce);
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        Map<String, Set<String>> mapOfClassNamesReferencedByArch = store.getMapReferencedPackageNames();
        for (String item : mapOfClassNamesReferencedByArch.keySet()) {
            Set<String> referencedClasses = mapOfClassNamesReferencedByArch.get(item);
            Iterator<String> iterator = referencedClasses.iterator();
            while (iterator.hasNext()) {
                String qualRefName;
                String pack = qualRefName = iterator.next();
                if (store.getImplementedPackageNames().contains(qualRefName) || !qualRefName.contains(".")) continue;
                if (this.missingClasses.containsKey(pack)) {
                    this.missingClasses.put(pack, String.valueOf(this.missingClasses.get(pack)) + "," + item);
                    continue;
                }
                this.missingClasses.put(pack, item);
            }
        }
        for (String key : this.missingClasses.keySet()) {
            this.detailResults.add(new DetailResult("MissingDep", null, this.ruleDescription, this.missingClasses.get(key), 1, key, 0));
        }
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.missingClasses.clear();
    }
}

