/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom.inventory;

import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.ClassOrPackageDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassOrPackageOccurrence;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DetectSession
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JspRule, RuleType.JavaRule);
    protected static final String RULE_NAME = "DetectSession";
    protected static final String RULE_DESC = "DetectSession";
    protected static final String HTTP_PACKAGE = "javax.servlet.http";
    protected static final String HTTPSESSION_CLASS = "javax.servlet.http.HttpSession";
    protected static final String JAKARTA_HTTP_PACKAGE = "jakarta.servlet.http";
    protected static final String JAKARTA_HTTPSESSION_CLASS = "jakarta.servlet.http.HttpSession";
    Set<String> appsUsingSessions = null;

    public DetectSession() {
        super("DetectSession", "DetectSession", true);
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        this.appsUsingSessions = store.getAppsUsingSessions();
        if (this.appsUsingSessions != null) {
            Set<String> keys = store.getJspKeys();
            for (String key : keys) {
                this.updateSessionUse(key);
            }
            keys = store.getClassDataStoreKeys();
            if (!keys.isEmpty()) {
                for (String key : keys) {
                    ClassDataStore data = store.getClassDataStore(key);
                    this.processPackageDetails(data.getPackageDetails(HTTP_PACKAGE), HTTPSESSION_CLASS, key);
                    this.processPackageDetails(data.getPackageDetails(JAKARTA_HTTP_PACKAGE), JAKARTA_HTTPSESSION_CLASS, key);
                }
            }
        }
    }

    public void updateSessionUse(String fileName) {
        String appName = ReportUtility.getFirstArchiveName(fileName);
        if (appName != null) {
            this.appsUsingSessions.add(appName);
        }
    }

    private void processPackageDetails(ClassOrPackageDetails[] packageDetails, String sessionClass, String key) {
        if (packageDetails != null) {
            ClassOrPackageDetails[] classOrPackageDetailsArray = packageDetails;
            int n = packageDetails.length;
            int n2 = 0;
            while (n2 < n) {
                ClassOrPackageDetails packageDetail = classOrPackageDetailsArray[n2];
                Map<String, ClassOrPackageOccurrence> mapOfReferenceAndLineInfo = packageDetail.getReferenceAndLineInfo();
                for (ClassOrPackageOccurrence packageOccurrences : mapOfReferenceAndLineInfo.values()) {
                    List<String> lineNumberClassNames = packageOccurrences.getLineNumberClassNames();
                    List<String> parameterClassNames = packageOccurrences.getParameterClassNames();
                    List<String> returnTypeClassNames = packageOccurrences.getReturnTypeClassNames();
                    if (!(lineNumberClassNames != null && lineNumberClassNames.contains(sessionClass) || parameterClassNames != null && parameterClassNames.contains(sessionClass)) && (returnTypeClassNames == null || !returnTypeClassNames.contains(sessionClass))) continue;
                    this.updateSessionUse(key);
                }
                ++n2;
            }
        }
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }
}

