/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom.inventory;

import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.MethodDetails;
import com.ibm.ws.report.binary.asm.utilities.MethodInfo;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.asm.utilities.StackDetails;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectMethod;
import com.ibm.ws.report.binary.rules.DetectPackage;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class CountJAXRPCConsumers
extends DetectMethod {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.XmlRule, RuleType.JavaRule);
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.java.jaxrpcConsumers";
    protected static final Pattern INVOKE_OWNER_NAME = Pattern.compile("javax\\.xml\\.rpc\\.Call");
    protected static final String INVOKE_METHOD_NAME_STRING = "invoke";
    protected static final String INVOKE_ONE_WAY_METHOD_NAME_STRING = "invokeOneWay";
    protected static final String[] INVOKE_METHODS = new String[]{"invoke", "invokeOneWay"};
    protected static final Pattern SERVICE_LOCATOR_STRING = Pattern.compile(".*ServiceLocator");
    protected static final Pattern SERVICE_LOCATOR_FILE_STRING = Pattern.compile(".*ServiceLocator\\.class");
    protected Map<String, Set<String>> serviceLocatorClassesToImplementedInterfaces = new HashMap<String, Set<String>>();
    protected Map<String, List<MethodInfo>> locatorConstructorClassesToGetterMethodsImplemented = new HashMap<String, List<MethodInfo>>();
    protected Map<String, String> locatorConstructorClassesToOwnerName = new HashMap<String, String>();
    protected static final Pattern SERVICE_CLASS = Pattern.compile("javax\\.xml\\.rpc\\.Service");
    protected Set<String> serviceClassName = new HashSet<String>();
    protected static final Pattern IMPLEMENTS_SERVICE_CLASS = Pattern.compile(".*_Service");
    protected Map<String, HashSet<String>> possiblyImplementsServiceInterface = new HashMap<String, HashSet<String>>();
    protected static final Pattern CREATE_SERVICE_OWNER_NAME = Pattern.compile("javax\\.xml\\.rpc\\.ServiceFactory");
    protected static final String CREATE_SERVICE_METHOD_NAME_STRING = "createService";
    protected static final Pattern CREATE_SERVICE_METHOD_NAME = Pattern.compile("createService");
    protected static final String[] SERVICELOCATORCONSTRUCTOR_SERVICEFACTORYMETHOD = new String[]{"<init>", "createService"};
    protected static final String GET_PORT_METHOD_NAME_STRING = "getPort";
    protected static final String GET_PORTS_METHOD_NAME_STRING = "getPorts";
    protected static final String[] GET_PORTS_METHODS = new String[]{"getPort", "getPorts"};
    protected static final Pattern LOOKUP_ARGUMENT_STRING = Pattern.compile(".*Service");
    protected static final String LOOKUP_METHOD_NAME_STRING = "lookup";
    protected static final Pattern LOOKUP_OWNER_NAME = Pattern.compile("javax\\.naming\\.InitialContext");
    protected static final Pattern STRING_CLASS = Pattern.compile("java\\.lang\\.String");
    protected Map<String, List<MethodInfo>> lookupClassesToGetterMethodsImplemented = new HashMap<String, List<MethodInfo>>();
    protected static final Pattern WEBSERVICE_EXTENDS_REMOTE = Pattern.compile("java\\.rmi\\.Remote");
    protected static final Pattern WEBSERVICE_IMPLEMENTS_SESSIONBEAN = Pattern.compile("javax\\.ejb\\.SessionBean");
    protected Set<String> webServiceClassName = new HashSet<String>();
    DetectElement _detectRpcMapping = null;
    protected static final String[] jaxrpcMappingsTag = new String[]{"jaxrpc-mapping-file"};
    protected static final String[] fileName = new String[]{"META-INF/application-client.xml", "WEB-INF/web.xml"};
    protected static final String[] allMethods = new String[]{"get*", "<init>", "invoke", "invokeOneWay", "lookup", "createService"};
    protected static final String[] allOwners = new String[]{"*"};
    protected DetectPackage _detectJaxrpcPackages = null;
    protected static final String[] jaxrpcPackage = new String[]{"javax.xml.rpc*"};
    protected DetectClass _detectRmiRemoteOrSessionBean = null;
    protected DetectPackage _detectWebservicesPackages = null;
    protected static final String[] webservicesPackage = new String[]{"com.ibm.ws.webservices*"};
    protected static final String[] webServiceExtendClassNames = new String[]{"java.rmi.Remote"};
    protected static final String[] webServiceImplementClassNames = new String[]{"javax.ejb.SessionBean"};
    protected boolean foundRmiRemoteOrSessionbean = false;
    protected List<DetailResult> detailResults1and2 = new ArrayList<DetailResult>();
    protected List<DetailResult> detailResults3 = new ArrayList<DetailResult>();
    protected List<DetailResult> detailResults7 = new ArrayList<DetailResult>();
    protected Set<String> classNamesFlaggedConsumers = new HashSet<String>();

    public CountJAXRPCConsumers() {
        super("CountJAXRPCConsumers", RULE_DESC, false);
        this.requireStackDetails = true;
        this._detectJaxrpcPackages = new DetectPackage("CountJAXRPCConsumers", RULE_DESC, jaxrpcPackage, true, false, null, null, true);
        this._detectRpcMapping = new DetectElement("CountJAXRPCConsumers", RULE_DESC, jaxrpcMappingsTag, fileName, null, null, false, null, null, null, false, null, null, null, false, null, false);
        this._detectWebservicesPackages = new DetectPackage("CountJAXRPCConsumers", RULE_DESC, webservicesPackage, false, false, null, null, true);
        this._detectRmiRemoteOrSessionBean = new DetectClass("CountJAXRPCConsumers", RULE_DESC, null, false, false, true, webServiceExtendClassNames, webServiceImplementClassNames, null, null, null, null){

            @Override
            protected boolean includeInResults(ClassDataStore data, String filename) {
                CountJAXRPCConsumers.this.foundRmiRemoteOrSessionbean = true;
                return false;
            }
        };
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectRpcMapping.clearResults();
        this._detectJaxrpcPackages.clearResults();
        this._detectWebservicesPackages.clearResults();
        this.serviceClassName.clear();
        this.serviceLocatorClassesToImplementedInterfaces.clear();
        this.webServiceClassName.clear();
        this.lookupClassesToGetterMethodsImplemented.clear();
        this.locatorConstructorClassesToGetterMethodsImplemented.clear();
        this.locatorConstructorClassesToOwnerName.clear();
        this.classNamesFlaggedConsumers.clear();
        this.detailResults1and2.clear();
        this.detailResults3.clear();
        this.detailResults7.clear();
        this.foundRmiRemoteOrSessionbean = false;
    }

    @Override
    public String[] getMethodNames() {
        return allMethods;
    }

    @Override
    public String[] getOwners() {
        return allOwners;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return fileName;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        this._detectRpcMapping.analyze(store, detectOnce);
        this._detectJaxrpcPackages.analyze(store, detectOnce);
        this._detectWebservicesPackages.analyze(store, detectOnce);
        this._detectRmiRemoteOrSessionBean.analyze(store, detectOnce);
        HashMap<String, MethodInfo> classesToGetPort = new HashMap();
        Set<String> keys = store.getClassDataStoreKeys();
        for (String key : keys) {
            Map<String, MethodDetails> mdMap;
            boolean shouldScan = ReportUtility.shouldScanClassFileForRules(key);
            if (!shouldScan) continue;
            ClassDataStore data = store.getClassDataStore(key);
            String[] implementedInterfacesArr = data.getImplementedInterfaces();
            if (implementedInterfacesArr != null) {
                String[] stringArray = implementedInterfacesArr;
                int n = implementedInterfacesArr.length;
                int n2 = 0;
                while (n2 < n) {
                    String implInter = stringArray[n2];
                    if (SERVICE_CLASS.matcher(implInter).matches()) {
                        this.serviceClassName.add(data.getClassName());
                    }
                    if (IMPLEMENTS_SERVICE_CLASS.matcher(implInter).matches()) {
                        Set set = this.possiblyImplementsServiceInterface.get(implInter);
                        if (set == null) {
                            HashSet<String> newSet = new HashSet<String>();
                            newSet.add(data.getClassName());
                            this.possiblyImplementsServiceInterface.put(implInter, newSet);
                        } else {
                            this.possiblyImplementsServiceInterface.get(implInter).add(data.getClassName());
                        }
                    }
                    if (WEBSERVICE_IMPLEMENTS_SESSIONBEAN.matcher(implInter).matches()) {
                        this.webServiceClassName.add(data.getClassName());
                    }
                    if (WEBSERVICE_EXTENDS_REMOTE.matcher(implInter).matches()) {
                        this.webServiceClassName.add(data.getClassName());
                    }
                    ++n2;
                }
                if (SERVICE_LOCATOR_FILE_STRING.matcher(key).matches()) {
                    HashSet<String> implementedInterfaces = new HashSet<String>(Arrays.asList(implementedInterfacesArr));
                    this.serviceLocatorClassesToImplementedInterfaces.put(data.getClassName(), implementedInterfaces);
                }
            }
            if ((mdMap = data.getMethodDetails()) == null) continue;
            ArrayList<MethodInfo> getters = new ArrayList<MethodInfo>();
            for (Map.Entry entry : mdMap.entrySet()) {
                MethodDetails md = (MethodDetails)entry.getValue();
                Set<MethodInfo> miSet = md.getMethodInfo("*");
                for (MethodInfo mi : miSet) {
                    String methodNameStr = mi.getName();
                    if (!methodNameStr.startsWith("get")) continue;
                    getters.add(mi);
                }
            }
            classesToGetPort = this.getPortCallsForClass(key, mdMap);
            this.addServiceLocatorAndServiceFactoryResults(key, mdMap, classesToGetPort, getters);
            this.addLookupResults(key, mdMap, classesToGetPort, getters);
            this.addInvokeResults(key, mdMap);
        }
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        List<DetailResult> xmlResults = this._detectRpcMapping.getResults(store);
        finalResults.addAll(this.getInitialContextGetConsumerResults());
        finalResults.addAll(this.getServiceLocatorGetConsumerResults());
        if (this._detectJaxrpcPackages.getResults(store).size() > 0 || this._detectWebservicesPackages.getResults(store).size() > 0 || this.foundRmiRemoteOrSessionbean) {
            this.logDetailResults(xmlResults, "CountJAXRPCConsumer: 6. A web.xml or application-client.xml contains the <jaxrpc-mapping-file> xml tag results:\n");
            finalResults.addAll(xmlResults);
        } else if (xmlResults != null && xmlResults.size() > 0) {
            ReportUtility.logger.get().log(Level.FINE, "CountJAXRPCConsumers - No java evidence of jaxrpc was found so xml results weren't flagged: " + xmlResults.toString());
        }
        this.logDetailResults(this.detailResults1and2, "CountJAXRPCConsumer: 1. A class contains a ServiceFactory constructor and a getPort or getPorts method call\n and 2. A class contains a ServiceLocator constructor and a getPort or getPorts method call results:\n");
        finalResults.addAll(this.detailResults1and2);
        this.logDetailResults(this.detailResults3, "CountJAXRPCConsumer: 3. A class contains a context lookup for a \".*Service\" and a getPort or getPorts method call results:\n");
        finalResults.addAll(this.detailResults3);
        this.logDetailResults(this.detailResults7, "CountJAXRPCConsumer: 7. A javax.xml.rpc.Call.invoke or invokeOneWay method is called results:\n");
        finalResults.addAll(this.detailResults7);
        return finalResults;
    }

    private void addLookupResults(String key, Map<String, MethodDetails> mdMap, Map<String, MethodInfo> classesToGetPort, List<MethodInfo> getters) {
        MethodDetails mdLookup = mdMap.get(LOOKUP_METHOD_NAME_STRING);
        if (mdLookup != null) {
            for (MethodInfo mi : mdLookup.getMethodInfo("*")) {
                String owner = mi.getOwner();
                if (!LOOKUP_OWNER_NAME.matcher(owner).matches()) continue;
                Map<String, List<ArrayDeque<StackDetails>>> stackInfo = mi.getMethodAndStackInfo();
                Map<String, List<Integer>> info = mi.getMethodAndLineInfo();
                Set<String> methodKeys = info.keySet();
                for (String methodKey : methodKeys) {
                    List<Integer> lineNumbers = info.get(methodKey);
                    List<ArrayDeque<StackDetails>> stackDetails = stackInfo.get(methodKey);
                    int numLines = lineNumbers.size();
                    int index = 0;
                    while (index < numLines) {
                        String valueStr;
                        Object value;
                        StackDetails.StackType st;
                        StackDetails sd;
                        Integer lineNumber = lineNumbers.get(index);
                        ArrayDeque<StackDetails> sdd = stackDetails.get(index);
                        Object copySdd = sdd.clone();
                        List<StackDetails> methodArguments = this.getMethodArguments(owner, (ArrayDeque<StackDetails>)copySdd, lineNumber, false);
                        if (methodArguments != null && !methodArguments.isEmpty() && (sd = methodArguments.get(0)) != null && (st = sd.getType()).equals((Object)StackDetails.StackType.CONSTANT_STRING_LITERAL) && (value = sd.getValue()) instanceof String && LOOKUP_ARGUMENT_STRING.matcher(valueStr = (String)value).matches()) {
                            MethodInfo getPortMi = classesToGetPort.get(key);
                            if (getPortMi != null) {
                                String getPortOwner = getPortMi.getOwner();
                                if (!this.classNamesFlaggedConsumers.contains(key) && (SERVICE_CLASS.matcher(getPortOwner).matches() || this.ownerImplementsServiceInterface(getPortOwner))) {
                                    this.detailResults3.add(new DetailResult(this.ruleName, key, this.ruleDescription, String.valueOf(owner) + mi.getName() + "(), " + getPortMi.getOwner() + "." + getPortMi.getName() + "()"));
                                    this.classNamesFlaggedConsumers.add(key);
                                } else {
                                    this.lookupClassesToGetterMethodsImplemented.put(key, getters);
                                }
                            } else {
                                this.lookupClassesToGetterMethodsImplemented.put(key, getters);
                            }
                        }
                        ++index;
                    }
                }
            }
        }
    }

    private void addInvokeResults(String key, Map<String, MethodDetails> mdMap) {
        String[] stringArray = INVOKE_METHODS;
        int n = INVOKE_METHODS.length;
        int n2 = 0;
        while (n2 < n) {
            String invokeMethod = stringArray[n2];
            MethodDetails mdInvoke = mdMap.get(invokeMethod);
            if (mdInvoke != null) {
                for (MethodInfo mi : mdInvoke.getMethodInfo("*")) {
                    String owner = mi.getOwner();
                    if (INVOKE_OWNER_NAME.matcher(owner).matches()) {
                        if (this.classNamesFlaggedConsumers.contains(key)) continue;
                        this.detailResults7.add(new DetailResult(this.ruleName, key, this.ruleDescription, String.valueOf(owner) + mi.getName() + "()"));
                        this.classNamesFlaggedConsumers.add(key);
                        continue;
                    }
                    ReportUtility.logger.get().log(Level.FINE, "CountJAXRPCConsumers - Invoke owner wasn't javax.xml.rpc.Call, but was " + owner);
                }
            }
            ++n2;
        }
    }

    private void addServiceLocatorAndServiceFactoryResults(String key, Map<String, MethodDetails> mdMap, Map<String, MethodInfo> classesToGetPort, List<MethodInfo> getters) {
        String[] stringArray = SERVICELOCATORCONSTRUCTOR_SERVICEFACTORYMETHOD;
        int n = SERVICELOCATORCONSTRUCTOR_SERVICEFACTORYMETHOD.length;
        int n2 = 0;
        while (n2 < n) {
            String methodName = stringArray[n2];
            MethodDetails mdMethod = mdMap.get(methodName);
            boolean isConstructor = methodName.equals("<init>");
            if (mdMethod != null) {
                for (MethodInfo mi : mdMethod.getMethodInfo("*")) {
                    String owner = mi.getOwner();
                    if ((!SERVICE_LOCATOR_STRING.matcher(owner).matches() || !isConstructor) && (!CREATE_SERVICE_OWNER_NAME.matcher(owner).matches() || !CREATE_SERVICE_METHOD_NAME.matcher(methodName).matches())) continue;
                    MethodInfo getPortMi = classesToGetPort.get(key);
                    if (getPortMi != null) {
                        String getPortOwner = getPortMi.getOwner();
                        if (!this.classNamesFlaggedConsumers.contains(key) && (SERVICE_CLASS.matcher(getPortOwner).matches() || this.ownerImplementsServiceInterface(getPortOwner))) {
                            this.detailResults1and2.add(new DetailResult(this.ruleName, key, this.ruleDescription, String.valueOf(owner) + "(), " + getPortOwner + "." + getPortMi.getName() + "()"));
                            this.classNamesFlaggedConsumers.add(key);
                            continue;
                        }
                        if (!isConstructor) continue;
                        this.locatorConstructorClassesToGetterMethodsImplemented.put(key, getters);
                        this.locatorConstructorClassesToOwnerName.put(key, owner);
                        continue;
                    }
                    if (!isConstructor) continue;
                    this.locatorConstructorClassesToGetterMethodsImplemented.put(key, getters);
                    this.locatorConstructorClassesToOwnerName.put(key, owner);
                }
            }
            ++n2;
        }
    }

    private boolean ownerImplementsServiceInterface(String owner) {
        for (String serviceClass : this.serviceClassName) {
            HashSet<String> setOfClasses = this.possiblyImplementsServiceInterface.get(serviceClass);
            if (setOfClasses == null || !setOfClasses.contains(owner)) continue;
            return true;
        }
        return false;
    }

    private Map<String, MethodInfo> getPortCallsForClass(String key, Map<String, MethodDetails> mdMap) {
        HashMap<String, MethodInfo> retMap = new HashMap<String, MethodInfo>();
        String[] stringArray = GET_PORTS_METHODS;
        int n = GET_PORTS_METHODS.length;
        int n2 = 0;
        while (n2 < n) {
            String getPortsNameString = stringArray[n2];
            MethodDetails mdGetPorts = mdMap.get(getPortsNameString);
            if (mdGetPorts != null) {
                for (MethodInfo mi : mdGetPorts.getMethodInfo("*")) {
                    retMap.put(key, mi);
                }
            }
            ++n2;
        }
        return retMap;
    }

    public List<DetailResult> getInitialContextGetConsumerResults() {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        for (Map.Entry<String, List<MethodInfo>> entry : this.lookupClassesToGetterMethodsImplemented.entrySet()) {
            List<MethodInfo> miList = entry.getValue();
            if (miList == null) continue;
            for (MethodInfo mi : miList) {
                if (mi == null) continue;
                String owner = mi.getOwner();
                if (this.serviceClassName.contains(owner)) {
                    if (this.classNamesFlaggedConsumers.contains(entry.getKey())) continue;
                    this.classNamesFlaggedConsumers.add(entry.getKey());
                    finalResults.add(new DetailResult(this.ruleName, entry.getKey(), this.ruleDescription, "javax.naming.InitialContext.lookup(), " + owner + "." + mi.getName()));
                    continue;
                }
                ReportUtility.logger.get().log(Level.FINE, "CountJAXRPCConsumers - Class " + entry.getKey() + " did not match the service regex (javax.xml.rpc.Service)");
            }
        }
        this.logDetailResults(finalResults, "CountJAXRPCConsumer: 4. A class contains a context lookup for a \".*Service\" and calls the Service.get<ConsumerName> method results:\n");
        return finalResults;
    }

    public void logDetailResults(List<DetailResult> finalResults, String message) {
        if (finalResults != null && finalResults.size() > 0) {
            ReportUtility.logger.get().log(Level.FINE, String.valueOf(message) + finalResults.toString());
        }
    }

    public List<DetailResult> getServiceLocatorGetConsumerResults() {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        for (String serviceLocatorConstructorFilename : this.locatorConstructorClassesToGetterMethodsImplemented.keySet()) {
            List<MethodInfo> miList = this.locatorConstructorClassesToGetterMethodsImplemented.get(serviceLocatorConstructorFilename);
            String methodName = null;
            String owner = null;
            if (miList != null) {
                for (MethodInfo mi : miList) {
                    if (!this.webServiceClassName.contains(mi.getReturnType())) continue;
                    methodName = mi.getName();
                    owner = mi.getOwner();
                }
            }
            String ownerOfConstructor = this.locatorConstructorClassesToOwnerName.get(serviceLocatorConstructorFilename);
            Set<String> implementedInterfaces = this.serviceLocatorClassesToImplementedInterfaces.get(ownerOfConstructor);
            boolean implementsServiceInterface = false;
            if (implementedInterfaces != null) {
                for (String implInterface : implementedInterfaces) {
                    if (!this.serviceClassName.contains(implInterface)) continue;
                    implementsServiceInterface = true;
                }
            }
            if (methodName != null) {
                if (implementsServiceInterface) {
                    if (this.classNamesFlaggedConsumers.contains(serviceLocatorConstructorFilename)) continue;
                    this.classNamesFlaggedConsumers.add(serviceLocatorConstructorFilename);
                    finalResults.add(new DetailResult(this.ruleName, serviceLocatorConstructorFilename, this.ruleDescription, String.valueOf(ownerOfConstructor) + "(), " + owner + "." + methodName + "()"));
                    continue;
                }
                ReportUtility.logger.get().log(Level.FINE, "CountJAXRPCConsumers - Class " + serviceLocatorConstructorFilename + " did not implement javax.xml.rpc.Service");
                continue;
            }
            ReportUtility.logger.get().log(Level.FINE, "CountJAXRPCConsumers - Class " + serviceLocatorConstructorFilename + " did not implement java.rmi.Remote or javax.ejb.SessionBean");
        }
        this.logDetailResults(finalResults, "CountJAXRPCConsumer: 5. A class contains a ServiceLocator constructor, it calls method ServiceLocator.get<ConsumerName>, and that ServiceLocator implements it's corresponding service results:\n");
        return finalResults;
    }
}

