/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.rules.DetectPackage;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class WebSphereWebServicesGeneralRule
extends DetectPackage {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule);
    protected static final String[] webServicesPackages = new String[]{"com.ibm.websphere.webservices*", "com.ibm.websphere.websvcs.rm*", "com.ibm.websphere.wsaddressing*", "com.ibm.websphere.wsrf*", "com.ibm.websphere.wssecurity*", "com.ibm.websphere.cache.webservices", "com.ibm.ws.webservices*", "com.ibm.ws.websvcs*", "com.ibm.ws.wssecurity*", "com.ibm.wsspi.soapcontainer", "com.ibm.wsspi.webservices*", "com.ibm.wsspi.wssecurity*", "com.ibm.wsspi.wsaddressing", "com.ibm.wsspi.wsrm*"};
    protected static final String PATTERN_STRING = ".*(_Deser|_Helper|_Ser|Stub|Locator|Information)\\.class";
    protected static final Pattern[] generatedFileName = new Pattern[]{Pattern.compile(".*(_Deser|_Helper|_Ser|Stub|Locator|Information)\\.class")};
    protected DetectFile webServicesDetectFile = null;
    protected Set<String> fitsNamingConvention = new HashSet<String>();
    protected static final String[] stubExtendClassNames = new String[]{"com.ibm.ws.webservices.engine.client.Stub"};
    protected static final String[] informationImplementClassNames = new String[]{"com.ibm.ws.webservices.multiprotocol.ServiceInformation"};
    protected static final String[] locatorExtendClassNames = new String[]{"com.ibm.ws.webservices.multiprotocol.AgnosticService"};
    protected static final String[] locatorImplementClassNames = new String[]{"com.ibm.ws.webservices.multiprotocol.GeneratedService"};
    protected static final String[] _serExtendClassNames = new String[]{"com.ibm.ws.webservices.engine.encoding.ser.BeanSerializer", "com.ibm.ws.webservices.engine.encoding.ser.SimpleBeanSerializer"};
    protected static final String[] _deserExtendClassNames = new String[]{"com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer", "com.ibm.ws.webservices.engine.encoding.ser.SimpleBeanDeserializer"};
    protected static final String[] _helperGetTypeDescMethod = new String[]{"getTypeDesc"};
    protected static final String[] _helperGetSerializerMethod = new String[]{"getSerializer"};
    protected static final String[] _helperGetDeserializerMethod = new String[]{"getDeserializer"};
    protected static final String[] _helperMethods = new String[]{_helperGetTypeDescMethod[0], _helperGetSerializerMethod[0], _helperGetDeserializerMethod[0]};
    protected static final String[] _helperClass = new String[]{"*"};
    protected DetectClass stubDetectClass = null;
    protected DetectClass informationDetectClass = null;
    protected DetectClass locatorDetectExtendClass = null;
    protected DetectClass locatorDetectImplementClass = null;
    protected DetectClass _serDetectClass = null;
    protected DetectClass _deserDetectClass = null;
    protected DetectClass _helperDetectClassGetTypeDesc = null;
    protected DetectClass _helperDetectClassGetSerializer = null;
    protected DetectClass _helperDetectClassGetDeserializer = null;
    protected boolean flagGeneratedClasses;
    protected List<DetailResult> generatedRuleResults = new ArrayList<DetailResult>();

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    public WebSphereWebServicesGeneralRule(String ruleName, String desc, DetectRule.FlagOnce flagOnce, boolean flagGeneratedClasses) {
        this(ruleName, desc, webServicesPackages, false, false, null, null, flagOnce, flagGeneratedClasses);
    }

    public WebSphereWebServicesGeneralRule(String ruleName, String desc, String[] packageNames, boolean useAppProvidedLibraries, boolean skipScanForUsage, String[] excludeClassNames, String[] excludePackageNames, DetectRule.FlagOnce flagOnce, boolean flagGeneratedClasses) {
        super(ruleName, desc, packageNames, useAppProvidedLibraries, skipScanForUsage, excludeClassNames, excludePackageNames, flagOnce);
        this.flagGeneratedClasses = flagGeneratedClasses;
        this.stubDetectClass = new DetectClass(ruleName, desc, null, false, false, false, stubExtendClassNames, null, null, null, null, null);
        this.informationDetectClass = new DetectClass(ruleName, desc, null, false, false, false, null, informationImplementClassNames, null, null, null, null);
        this.locatorDetectExtendClass = new DetectClass(ruleName, desc, null, false, false, false, locatorExtendClassNames, null, null, null, null, null);
        this.locatorDetectImplementClass = new DetectClass(ruleName, desc, null, false, false, false, null, locatorImplementClassNames, null, null, null, null);
        this._serDetectClass = new DetectClass(ruleName, desc, null, false, false, false, _serExtendClassNames, null, null, null, null, null);
        this._deserDetectClass = new DetectClass(ruleName, desc, null, false, false, false, _deserExtendClassNames, null, null, null, null, null);
        this._helperDetectClassGetTypeDesc = new DetectClass(ruleName, desc, null, false, false, false, _helperClass, null, null, null, _helperGetTypeDescMethod, null);
        this._helperDetectClassGetSerializer = new DetectClass(ruleName, desc, null, false, false, false, _helperClass, null, null, null, _helperGetSerializerMethod, null);
        this._helperDetectClassGetDeserializer = new DetectClass(ruleName, desc, null, false, false, false, _helperClass, null, null, null, _helperGetDeserializerMethod, null);
        this.webServicesDetectFile = new DetectFile(ruleName, desc, generatedFileName, false){

            @Override
            public void analyze(SimpleDataStore store, boolean detectOnce) {
                WebSphereWebServicesGeneralRule.this.fitsNamingConvention = store.getMatchingFileNames(generatedFileName[0]);
            }
        };
    }

    @Override
    public String[] getMethodNames() {
        return _helperMethods;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this.stubDetectClass.analyze(store, detectOnce);
        this.informationDetectClass.analyze(store, detectOnce);
        this.locatorDetectExtendClass.analyze(store, detectOnce);
        this.locatorDetectImplementClass.analyze(store, detectOnce);
        this._serDetectClass.analyze(store, detectOnce);
        this._deserDetectClass.analyze(store, detectOnce);
        this._helperDetectClassGetTypeDesc.analyze(store, detectOnce);
        this._helperDetectClassGetSerializer.analyze(store, detectOnce);
        this._helperDetectClassGetDeserializer.analyze(store, detectOnce);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.webServicesDetectFile.clearResults();
        this.stubDetectClass.clearResults();
        this.informationDetectClass.clearResults();
        this.locatorDetectExtendClass.clearResults();
        this.locatorDetectImplementClass.clearResults();
        this._serDetectClass.clearResults();
        this._deserDetectClass.clearResults();
        this._helperDetectClassGetTypeDesc.clearResults();
        this._helperDetectClassGetSerializer.clearResults();
        this._helperDetectClassGetDeserializer.clearResults();
        this.fitsNamingConvention.clear();
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        List<DetailResult> webServicesResults = super.getResults(store);
        this.generatedRuleResults.addAll(this.logDetailResults(this.stubDetectClass.getResults(store), "Classes that extend Stub"));
        this.generatedRuleResults.addAll(this.logDetailResults(this.informationDetectClass.getResults(store), "Classes that implement ServiceInformation"));
        this.generatedRuleResults.addAll(this.getMatchingResults(this.locatorDetectExtendClass.getResults(store), this.locatorDetectImplementClass.getResults(store), "Classes that extend AgnosticService", "Classes that implement GeneratedService"));
        this.generatedRuleResults.addAll(this.logDetailResults(this._serDetectClass.getResults(store), "Classes that extend BeanSerializer and SimpleBeanSerializer"));
        this.generatedRuleResults.addAll(this.logDetailResults(this._deserDetectClass.getResults(store), "Classes that extend BeanDeserializer and SimpleBeanDeserializer"));
        this.generatedRuleResults.addAll(this.getMatchingResults(this._helperDetectClassGetTypeDesc.getResults(store), this.getMatchingResults(this._helperDetectClassGetSerializer.getResults(store), this._helperDetectClassGetDeserializer.getResults(store), "Classes with a getSerializer method", "Classes with a getDeserializer method"), "Classes with a getTypeDesc method", "Classes with a getSerializer and getDeserializer method"));
        if (!webServicesResults.isEmpty()) {
            this.webServicesDetectFile.analyze(store, false);
            for (DetailResult res : webServicesResults) {
                String file = res.getFileName();
                boolean flaggedByGeneratedFileRule = this.flaggedByGeneratedFile(file);
                if (this.flagGeneratedClasses) {
                    if (!flaggedByGeneratedFileRule) continue;
                    if (this.fitsNamingConvention.contains(file)) {
                        finalResults.add(res);
                        continue;
                    }
                    ReportUtility.logger.get().log(Level.FINE, "WebSphereWebServicesGeneralRule - " + file + " did not fit the naming convention " + PATTERN_STRING);
                    continue;
                }
                if (flaggedByGeneratedFileRule && this.fitsNamingConvention.contains(file)) continue;
                finalResults.add(res);
            }
        }
        return finalResults;
    }

    public boolean flaggedByGeneratedFile(String file) {
        for (DetailResult res : this.generatedRuleResults) {
            if (!file.equals(res.getFileName())) continue;
            return true;
        }
        return false;
    }

    public List<DetailResult> getMatchingResults(List<DetailResult> results1, List<DetailResult> results2, String listName1, String listName2) {
        ArrayList<DetailResult> matchedResults = new ArrayList<DetailResult>();
        List<String> unmatchedFilesList1 = this.copyDetailResultListToStringList(results1);
        List<String> unmatchedFilesList2 = this.copyDetailResultListToStringList(results2);
        for (DetailResult res1 : results1) {
            String filename1 = res1.getFileName();
            for (DetailResult res2 : results2) {
                String filename2 = res2.getFileName();
                if (!filename1.equals(filename2)) continue;
                matchedResults.add(new DetailResult(this.ruleName, filename1, this.ruleDescription, String.valueOf(res1.getCriteria()) + ", " + res2.getCriteria()));
                unmatchedFilesList1.remove(filename1);
                unmatchedFilesList2.remove(filename2);
            }
        }
        ReportUtility.logger.get().log(Level.FINE, "WebSphereWebServicesGeneralRule - " + listName1 + ": " + unmatchedFilesList1.toString());
        ReportUtility.logger.get().log(Level.FINE, "WebSphereWebServicesGeneralRule - " + listName2 + ": " + unmatchedFilesList2.toString());
        return matchedResults;
    }

    public List<String> copyDetailResultListToStringList(List<DetailResult> results) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (DetailResult res : results) {
            returnList.add(res.getFileName());
        }
        return returnList;
    }

    public List<DetailResult> logDetailResults(List<DetailResult> results, String resultType) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (DetailResult res : results) {
            fileNames.add(res.getFileName());
        }
        ReportUtility.logger.get().log(Level.FINE, "WebSphereWebServicesGeneralRule - " + resultType + ": " + ((Object)fileNames).toString());
        return results;
    }
}

