/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.ClassOrPackageDetails;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAttribute;
import com.ibm.ws.report.binary.rules.DetectProperty;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.DetectStringLiteral;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class URLRule
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.XmlRule, RuleType.JavaRule, RuleType.PropertyRule);
    protected static String RULE_NAME;
    protected static final String RULE_DESC = "appconversion.cloud.rules.URLRule";
    public static String attributeValue;
    public static final Pattern CONTENT_UP_UNTIL_LAST_ARCHIVE_PATTERN;
    public DetectStringLiteral detectStringLiteral;
    public DetectProperty detectProperty;
    public DetectAttribute detectAttribute;
    Map<String, Map<String, Integer>> mapOfArchiveToResults = new HashMap<String, Map<String, Integer>>();

    static {
        attributeValue = "http(s)?://(?!(www\\.w3\\.org/|schemas\\.xmlsoap\\.org/)).+";
        CONTENT_UP_UNTIL_LAST_ARCHIVE_PATTERN = Pattern.compile("(.*)(?<=\\.(war|jar|rar))");
    }

    public URLRule(String regex, String ruleName) {
        super(ruleName, RULE_DESC, false);
        RULE_NAME = ruleName;
        String[] stringLiteralRegex = new String[]{regex};
        Pattern[] stringLiteralPattern = new Pattern[]{Pattern.compile(stringLiteralRegex[0])};
        this.detectStringLiteral = new DetectStringLiteral(RULE_NAME, RULE_DESC, stringLiteralPattern, false){

            @Override
            protected boolean includeInResults(ClassOrPackageDetails cd, String filename) {
                String matchCriteria = cd.getClassOrPackageName();
                URLRule.this.addToMap(filename, matchCriteria);
                return false;
            }
        };
        this.detectProperty = new DetectProperty(RULE_NAME, RULE_DESC, ".*\\.properties", null, stringLiteralRegex, false){

            @Override
            protected boolean includeInResults(Properties props, String filename, Object key) {
                String value = (String)props.get(key);
                String matchCriteria = key + "=" + value;
                URLRule.this.addToMap(filename, matchCriteria);
                return false;
            }
        };
        this.detectAttribute = new DetectAttribute(RULE_NAME, RULE_DESC, new String[]{"address"}, new String[]{".*\\.(?i:wsdl)"}, "*", "location", attributeValue, null, false, null, null){

            @Override
            protected boolean includeInResults(String fileName, Node node) {
                String attrValue = this.attributeValue != null ? "=" + this.attributeValue : "";
                String value = node.getNodeValue();
                if (value != null) {
                    attrValue = "=" + value;
                }
                String ownerElementName = ((Attr)node).getOwnerElement().getLocalName();
                URLRule.this.addToMap(fileName, String.valueOf(ownerElementName) + "." + node.getLocalName() + attrValue);
                return false;
            }
        };
    }

    public void addToMap(String path, String matchCriteria) {
        Map<Object, Object> mapOfURLToNUmberofHits;
        String archiveName = path;
        Matcher m = CONTENT_UP_UNTIL_LAST_ARCHIVE_PATTERN.matcher(archiveName);
        if (m.find()) {
            archiveName = m.group();
        }
        if (this.mapOfArchiveToResults.containsKey(archiveName)) {
            mapOfURLToNUmberofHits = this.mapOfArchiveToResults.get(archiveName);
        } else {
            mapOfURLToNUmberofHits = new HashMap();
            this.mapOfArchiveToResults.put(archiveName, mapOfURLToNUmberofHits);
        }
        Integer count = (Integer)mapOfURLToNUmberofHits.get(matchCriteria);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        mapOfURLToNUmberofHits.put(matchCriteria, count);
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        this.detectStringLiteral.analyze(store, detectOnce);
        this.detectProperty.analyze(store, detectOnce);
        this.detectAttribute.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        for (Map.Entry<String, Map<String, Integer>> entry : this.mapOfArchiveToResults.entrySet()) {
            String archiveName = String.valueOf(entry.getKey()) + " ";
            Map<String, Integer> mapOfURLToNUmberofHits = entry.getValue();
            for (Map.Entry<String, Integer> resultEntry : mapOfURLToNUmberofHits.entrySet()) {
                String matchCriteria = resultEntry.getKey();
                int count = resultEntry.getValue();
                String countMessage = count > 1 ? Messages.getString("Report_Reference_Count_Plural") : Messages.getString("Report_Reference_Count");
                String finalMessage = Messages.getFormattedMessage(countMessage, Integer.toString(count));
                this.detailResults.add(new DetailResult(this.ruleName, archiveName, this.ruleDescription, matchCriteria, count, finalMessage, 0));
            }
        }
        return this.detailResults;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.mapOfArchiveToResults.clear();
    }

    @Override
    public String[] getFileNames() {
        return new String[]{".*\\.(?i:wsdl|props|properties)"};
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }
}

