/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class TomcatContextEnvironment
extends DetectElement {
    protected static final String RULE_NAME = "TomcatContextEnvironment";
    protected static final String RULE_DESC = "appconversion.tomcat.rule.xml.context.environment";
    protected static final String ENV_ENTRY_NAME_KEY = "env-entry-name";
    protected static final String ENV_ENTRY_TYPE_KEY = "env-entry-type";
    protected static final String ENV_ENTRY_VALUE_KEY = "env-entry-value";
    protected static final String NAME_KEY = "name";
    protected static final String VALUE_KEY = "value";
    protected static final String TYPE_KEY = "type";
    protected static final String OVERRIDE_KEY = "override";
    protected static final String[] WEB_XML_FILENAMES = new String[]{"WEB-INF/web.xml"};
    protected static final String[] WEB_XML_TAGS = new String[]{"env-entry"};
    protected static final String[] CONTEXT_XML_FILENAMES = new String[]{"META-INF/context.xml"};
    protected static final String[] CONTEXT_XML_TAGS = new String[]{"Environment"};
    protected static final String[] CONTEXT_XML_PARENT_TAGS = new String[]{"Context"};
    protected static final String[] ALL_FILENAMES = new String[]{WEB_XML_FILENAMES[0], CONTEXT_XML_FILENAMES[0]};
    private List<EnvironmentElementInfo> webXMLEnvironmentElements;
    private List<EnvironmentElementInfo> contextXMLEnvironmentElements;
    private DetectElement detectContextEnvironment = new DetectElement("TomcatContextEnvironment", "appconversion.tomcat.rule.xml.context.environment", CONTEXT_XML_TAGS, CONTEXT_XML_FILENAMES, null, null, false, null, null, null, false, null, null, null, false, CONTEXT_XML_PARENT_TAGS, false){

        @Override
        protected boolean includeInResults(Node node, String key, XMLResource resource) {
            EnvironmentElementInfo info = new EnvironmentElementInfo(node, key, resource.getNodeLineNumber(node));
            TomcatContextEnvironment.this.contextXMLEnvironmentElements.add(info);
            return false;
        }
    };

    public TomcatContextEnvironment() {
        super(RULE_NAME, Messages.getRuleDescription(RULE_DESC), WEB_XML_TAGS, WEB_XML_FILENAMES, null, null, false, null, null, null, false);
        this.webXMLEnvironmentElements = new ArrayList<EnvironmentElementInfo>();
        this.contextXMLEnvironmentElements = new ArrayList<EnvironmentElementInfo>();
    }

    @Override
    public String[] getFileNames() {
        return ALL_FILENAMES;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this.detectContextEnvironment.analyze(store, detectOnce);
    }

    @Override
    public boolean includeInResults(Node node, String key, XMLResource resource) {
        this.webXMLEnvironmentElements.add(new EnvironmentElementInfo(node));
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        finalResults = new ArrayList<DetailResult>();
        for (EnvironmentElementInfo contextElement : this.contextXMLEnvironmentElements) {
            i = 0;
            found = false;
            if (EnvironmentElementInfo.access$0(contextElement) != null && EnvironmentElementInfo.access$1(contextElement) != null && EnvironmentElementInfo.access$2(contextElement) != null) ** GOTO lbl18
            continue;
lbl-1000:
            // 1 sources

            {
                webElement = this.webXMLEnvironmentElements.get(i);
                if (EnvironmentElementInfo.access$0(contextElement).equals(EnvironmentElementInfo.access$0(webElement))) {
                    if (EnvironmentElementInfo.access$1(contextElement).equals(EnvironmentElementInfo.access$1(webElement))) {
                        if (!EnvironmentElementInfo.access$3(contextElement) && !EnvironmentElementInfo.access$2(contextElement).equals(EnvironmentElementInfo.access$2(webElement))) {
                            finalResults.add(new DetailResult("TomcatContextEnvironment", EnvironmentElementInfo.access$4(contextElement), Messages.getRuleDescription("appconversion.tomcat.rule.xml.context.environment"), TomcatContextEnvironment.CONTEXT_XML_TAGS[0], 1, null, EnvironmentElementInfo.access$5(contextElement)));
                        }
                    } else {
                        finalResults.add(new DetailResult("TomcatContextEnvironment", EnvironmentElementInfo.access$4(contextElement), Messages.getRuleDescription("appconversion.tomcat.rule.xml.context.environment"), TomcatContextEnvironment.CONTEXT_XML_TAGS[0], 1, null, EnvironmentElementInfo.access$5(contextElement)));
                    }
                    found = true;
                }
                ++i;
lbl18:
                // 2 sources

                ** while (!found && i < this.webXMLEnvironmentElements.size())
            }
lbl19:
            // 1 sources

            if (found) continue;
            finalResults.add(new DetailResult("TomcatContextEnvironment", EnvironmentElementInfo.access$4(contextElement), Messages.getRuleDescription("appconversion.tomcat.rule.xml.context.environment"), TomcatContextEnvironment.CONTEXT_XML_TAGS[0], 1, null, EnvironmentElementInfo.access$5(contextElement)));
        }
        return finalResults;
    }

    private class EnvironmentElementInfo {
        private final String name;
        private final String type;
        private boolean override;
        private final String value;
        private String key;
        private int line;

        EnvironmentElementInfo(Node envEntryNode) {
            this.name = XMLRuleUtil.getAttributeOrChildNodeValue(envEntryNode, TomcatContextEnvironment.ENV_ENTRY_NAME_KEY);
            this.value = XMLRuleUtil.getAttributeOrChildNodeValue(envEntryNode, TomcatContextEnvironment.ENV_ENTRY_VALUE_KEY);
            this.type = XMLRuleUtil.getAttributeOrChildNodeValue(envEntryNode, TomcatContextEnvironment.ENV_ENTRY_TYPE_KEY);
        }

        EnvironmentElementInfo(Node environmentNode, String key, int line) {
            this.key = key;
            this.line = line;
            Node nameNode = environmentNode.getAttributes().getNamedItem(TomcatContextEnvironment.NAME_KEY);
            Node valueNode = environmentNode.getAttributes().getNamedItem(TomcatContextEnvironment.VALUE_KEY);
            Node typeNode = environmentNode.getAttributes().getNamedItem(TomcatContextEnvironment.TYPE_KEY);
            Node overrideNode = environmentNode.getAttributes().getNamedItem(TomcatContextEnvironment.OVERRIDE_KEY);
            this.name = nameNode == null ? null : nameNode.getNodeValue();
            this.value = valueNode == null ? null : valueNode.getNodeValue();
            this.type = typeNode == null ? null : typeNode.getNodeValue();
            this.override = overrideNode == null || !"false".equalsIgnoreCase(overrideNode.getNodeValue());
        }

        static /* synthetic */ String access$0(EnvironmentElementInfo environmentElementInfo) {
            return environmentElementInfo.name;
        }

        static /* synthetic */ String access$1(EnvironmentElementInfo environmentElementInfo) {
            return environmentElementInfo.type;
        }

        static /* synthetic */ String access$2(EnvironmentElementInfo environmentElementInfo) {
            return environmentElementInfo.value;
        }

        static /* synthetic */ boolean access$3(EnvironmentElementInfo environmentElementInfo) {
            return environmentElementInfo.override;
        }

        static /* synthetic */ String access$4(EnvironmentElementInfo environmentElementInfo) {
            return environmentElementInfo.key;
        }

        static /* synthetic */ int access$5(EnvironmentElementInfo environmentElementInfo) {
            return environmentElementInfo.line;
        }
    }
}

