/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServersideAsyncSupportRequired
extends DetectAnnotation {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule, RuleType.XmlRule);
    protected static final String RULE_NAME = "ServersideAsyncSupportRequired";
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.jakartaee9.restfulws.ServersideAsyncSupportRequired";
    protected static final String suspendedInterfaceJavax = "javax.ws.rs.container.Suspended";
    protected static final String suspendedInterfaceJakarta = "jakarta.ws.rs.container.Suspended";
    protected static final String[] suspendedInterfaceArr = new String[]{"javax.ws.rs.container.Suspended", "jakarta.ws.rs.container.Suspended"};
    protected static final String[] tags = new String[]{"servlet"};
    protected static final String[] fileNames = new String[]{"WEB-INF/web.xml"};
    protected DetectElement _detectWebXmlProperties = new DetectElement("ServersideAsyncSupportRequired", "com.ibm.ws.report.binary.jakartaee9.restfulws.ServersideAsyncSupportRequired", tags, fileNames, null, null, false, null, null, null, false){

        @Override
        protected boolean includeInResults(Node result, String key, XMLResource resource) {
            ServersideAsyncSupportRequired.this.webXmlExists = true;
            if (!ServersideAsyncSupportRequired.this.asyncSupportedFound || !ServersideAsyncSupportRequired.this.servletClassUsed) {
                NodeList nodeList = result.getChildNodes();
                int i = 0;
                while (i < nodeList.getLength()) {
                    Node child = nodeList.item(i);
                    if (child != null) {
                        String nodeName = child.getNodeName();
                        if (nodeName.contentEquals("servlet-class")) {
                            ServersideAsyncSupportRequired.this.servletClassUsed = true;
                        }
                        if (nodeName.contentEquals("async-supported")) {
                            ServersideAsyncSupportRequired.this.asyncSupportedFound = true;
                        }
                    }
                    ++i;
                }
            }
            return false;
        }
    };
    protected boolean webXmlExists = false;
    protected boolean asyncSupportedFound = false;
    protected boolean servletClassUsed = false;

    public ServersideAsyncSupportRequired() {
        super(RULE_NAME, RULE_DESC, suspendedInterfaceArr, null, null, null, null, null, true, "method", null, null);
    }

    @Override
    public String[] getAnnotations() {
        return suspendedInterfaceArr;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return fileNames;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectWebXmlProperties.clearResults();
        this.webXmlExists = false;
        this.asyncSupportedFound = false;
        this.servletClassUsed = false;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._detectWebXmlProperties.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> parentResultsList = super.getResults(store);
        if (!parentResultsList.isEmpty() && this.webXmlExists && this.servletClassUsed && !this.asyncSupportedFound) {
            return parentResultsList;
        }
        return new ArrayList<DetailResult>();
    }
}

