/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.appconversion.jsp.core.model.JspNode;
import com.ibm.ws.appconversion.jsp.core.model.JspNodeType;
import com.ibm.ws.appconversion.jsp.core.util.CoreJspHelper;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.JSPResource;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JspNestedQuotesRule
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JspRule);
    protected static final String RULE_NAME = "JspNestedQuotesRule";
    protected static final String RULE_DESC = "appconversion.competitive.rule.jspNestedQuotesRule";
    public static final char singleQuoteChar = '\'';
    public static final char dblQuoteChar = '\"';
    static final String anything = ".*";
    static final String singleQuote = "'";
    static final String doubleQuote = "\"";
    static final String backslash = "\\\\";
    static final Pattern patternWithSingleQuotes = Pattern.compile(".*'.*'.*");
    static final Pattern patternWithDoubleQuotes = Pattern.compile(".*\".*\".*");
    static final Pattern patternWithEscapedSingleQuotes = Pattern.compile(".*\\\\'.*\\\\'.*");
    static final Pattern patternWithEscapedDoubleQuotes = Pattern.compile(".*\\\\\".*\\\\\".*");

    public JspNestedQuotesRule() {
        super(RULE_NAME, RULE_DESC, false);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        Set<String> keys = store.getJspKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                JSPResource jspData = store.getJsp(key);
                List<JspNode> jspNodes = jspData.getJSPNodes();
                for (JspNode node : jspNodes) {
                    if (node.getJspNodeType() != JspNodeType.HTML_ACTION) continue;
                    String actionNodeData = node.getData();
                    List<JspNode> expressionNodes = CoreJspHelper.filterForNodeType(node.getChildren(), JspNodeType.EXPRESSION);
                    for (JspNode expNode : expressionNodes) {
                        StringBuilder sb;
                        char charAfter;
                        String expNodeData = expNode.getData();
                        int indexB4exp = actionNodeData.indexOf(expNodeData) - 1;
                        int indexAfterExp = actionNodeData.indexOf(expNodeData) + expNodeData.length();
                        char charB4 = actionNodeData.charAt(indexB4exp);
                        boolean surroundedBySingles = charB4 == (charAfter = actionNodeData.charAt(indexAfterExp)) && charB4 == '\'';
                        boolean surroundedByDoubles = charB4 == charAfter && charB4 == '\"';
                        Matcher matcherWithSingleQuotes = patternWithSingleQuotes.matcher(expNodeData);
                        Matcher matcherWithDoubleQuotes = patternWithDoubleQuotes.matcher(expNodeData);
                        Matcher matcherWithEscapedSingleQuotes = patternWithEscapedSingleQuotes.matcher(expNodeData);
                        Matcher matcherWithEscapedDoubleQuotes = patternWithEscapedDoubleQuotes.matcher(expNodeData);
                        boolean containsSingleQuotes = matcherWithSingleQuotes.matches();
                        boolean containsDoubleQuotes = matcherWithDoubleQuotes.matches();
                        boolean containsEscapedSingleQuotes = matcherWithEscapedSingleQuotes.matches();
                        boolean containsEscapedDoubleQuotes = matcherWithEscapedDoubleQuotes.matches();
                        if (surroundedBySingles && containsSingleQuotes && !containsEscapedSingleQuotes) {
                            sb = new StringBuilder();
                            sb.append(singleQuote).append(expNodeData).append(singleQuote);
                            this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, sb.toString(), 1, null, expNode.getLine()));
                        }
                        if (!surroundedByDoubles || !containsDoubleQuotes || containsEscapedDoubleQuotes) continue;
                        sb = new StringBuilder();
                        sb.append(doubleQuote).append(expNodeData).append(doubleQuote);
                        this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, sb.toString(), 1, null, expNode.getLine()));
                    }
                }
            }
        }
    }
}

