/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class EJBInDefaultPackage
extends DetectRule {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule);
    protected static final String RULE_NAME = "EJBInDefaultPackage";
    protected static final String RULE_DESC = "appconversion.weblogic.java.EJBInDefaultPackage";
    protected static final String[] implementsClass = new String[]{"javax.ejb.EnterpriseBean", "javax.ejb.EntityBean", "javax.ejb.MessageDrivenBean", "javax.ejb.SessionBean"};
    protected static final String[] annotationNames = new String[]{"javax.ejb.MessageDriven", "javax.ejb.Stateless", "javax.ejb.Stateful"};
    protected static final String location = "class";
    DetectClass _detectEJBInterfaceImplementaions = new DetectClass("EJBInDefaultPackage", "appconversion.weblogic.java.EJBInDefaultPackage", null, false, false, false, null, implementsClass, null, null, null, null);
    DetectAnnotation _detectEJBAnnotations = new DetectAnnotation("EJBInDefaultPackage", "appconversion.weblogic.java.EJBInDefaultPackage", annotationNames, null, null, null, null, null, false, "class", null, null);

    public EJBInDefaultPackage() {
        this(RULE_NAME, RULE_DESC, false);
    }

    public EJBInDefaultPackage(String ruleName, String desc, boolean flagOnce) {
        super(ruleName, desc, flagOnce);
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        this._detectEJBInterfaceImplementaions.analyze(store, detectOnce);
        this._detectEJBAnnotations.analyze(store, detectOnce);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectEJBInterfaceImplementaions.clearResults();
        this._detectEJBAnnotations.clearResults();
    }

    @Override
    public String[] getAnnotations() {
        return annotationNames;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        List<DetailResult> results = this._detectEJBInterfaceImplementaions.getResults(store);
        results.addAll(this._detectEJBAnnotations.getResults(store));
        for (DetailResult result : results) {
            if (ReportUtility.getPackage(result.getFileName()) != null) continue;
            finalResults.add(result);
        }
        return finalResults;
    }
}

