/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectAttribute;
import com.ibm.ws.report.binary.rules.DetectDTD;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

public class DoNotUseJaxWsAnnotationsInNonEE5Project
extends DetectAnnotation {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule, RuleType.XmlRule);
    protected static final String RULE_NAME = "DoNotUseJaxWsAnnotationsInNonEE5Project";
    protected static final String RULE_DESC = "appconversion.was2was.70.removed.features.DoNotUseJaxWsAnnotationsInNonEE5Project";
    protected DetectDTD _detectDTDs = new DetectDTD("DoNotUseJaxWsAnnotationsInNonEE5Project", "appconversion.was2was.70.removed.features.DoNotUseJaxWsAnnotationsInNonEE5Project", ".*((application-client_1_(2|3))|(web-app_2_(2|3))|(ejb-jar_(1_1|2_0))).*", DTD_FILENAMES, false, false);
    protected static final String DTD_NAMES = ".*((application-client_1_(2|3))|(web-app_2_(2|3))|(ejb-jar_(1_1|2_0))).*";
    protected static final String[] DTD_FILENAMES = new String[]{"(.*/)?(META-INF|WEB-INF)/ejb-jar\\.xml", "META-INF/application-client.xml", "WEB-INF/web.xml"};
    protected DetectAttribute _ejbJarsLessThanV3 = new DetectAttribute("DoNotUseJaxWsAnnotationsInNonEE5Project", "appconversion.was2was.70.removed.features.DoNotUseJaxWsAnnotationsInNonEE5Project", EJB_JAR_TAG, EJB_JAR_XML_FILENAME, null, "version", "2\\.1", null, false, null, null);
    protected static final String[] EJB_JAR_TAG = new String[]{"ejb-jar"};
    protected static final String[] EJB_JAR_XML_FILENAME = new String[]{"(.*/)?(META-INF|WEB-INF)/ejb-jar\\.xml"};
    protected static final String VERSION_ATTRIBUTE = "version";
    protected static final String EJB_VERSION_ATTRIBUTE_VALUE = "2\\.1";
    protected DetectAttribute _appClientsLessThanV5 = null;
    protected static final String[] APPCL_APP_TAG = new String[]{"application-client"};
    protected static final String[] APPCL_APP_XML_FILENAME = new String[]{"META-INF/application-client.xml"};
    protected static final String APPCL_VERSION_ATTRIBUTE_VALUE = "1\\.4";
    protected DetectAttribute _webModulesLessThanV25 = new DetectAttribute("DoNotUseJaxWsAnnotationsInNonEE5Project", "appconversion.was2was.70.removed.features.DoNotUseJaxWsAnnotationsInNonEE5Project", WEB_APP_TAG, WEB_APP_XML_FILENAME, null, "version", "2\\.4", null, false, null, null);
    protected static final String[] WEB_APP_TAG = new String[]{"web-app"};
    protected static final String[] WEB_APP_XML_FILENAME = new String[]{"WEB-INF/web.xml"};
    protected static final String WEB_VERSION_ATTRIBUTE_VALUE = "2\\.4";
    protected static String[] JAXWS_ANNOTATION_CLASSES = new String[]{"javax.jws.WebService", "javax.jws.WebMethod", "javax.jws.Oneway", "javax.jws.WebParam", "javax.jws.WebResult", "javax.jws.HandlerChain", "javax.jws.soap.InitParam", "javax.jws.soap.SOAPBinding", "javax.jws.soap.SOAPMessageHandler", "javax.jws.soap.SOAPMessageHandlers", "javax.xml.ws.Action", "javax.xml.ws.BindingType", "javax.xml.ws.FaultAction", "javax.xml.ws.RequestWrapper", "javax.xml.ws.RespectBinding", "javax.xml.ws.ResponseWrapper", "javax.xml.ws.ServiceMode", "javax.xml.ws.WebEndpoint", "javax.xml.ws.WebFault", "javax.xml.ws.WebServiceClient", "javax.xml.ws.WebServiceProvider", "javax.xml.ws.WebServiceRef", "javax.xml.ws.WebServiceRefs", "javax.annotation.Generated", "javax.annotation.PostConstruct", "javax.annotation.PreDetroy", "javax.annotation.Resource", "javax.annotation.Resources"};

    public DoNotUseJaxWsAnnotationsInNonEE5Project() {
        this(RULE_NAME, RULE_DESC, JAXWS_ANNOTATION_CLASSES, null, null, null, null, null, false, null, null, null);
    }

    public DoNotUseJaxWsAnnotationsInNonEE5Project(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, boolean flagOnce, String location, String defaultName, String missingAttributeName) {
        super(ruleName, desc, classNames, attributeName, attributeType, attributeValues, defaultValue, accessFlag, flagOnce, location, defaultName, missingAttributeName);
        this._appClientsLessThanV5 = new DetectAttribute(RULE_NAME, RULE_DESC, APPCL_APP_TAG, APPCL_APP_XML_FILENAME, null, VERSION_ATTRIBUTE, APPCL_VERSION_ATTRIBUTE_VALUE, null, false, null, null);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._ejbJarsLessThanV3.clearResults();
        this._webModulesLessThanV25.clearResults();
        this._appClientsLessThanV5.clearResults();
        this._detectDTDs.clearResults();
    }

    @Override
    public String[] getFileNames() {
        return DTD_FILENAMES;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._ejbJarsLessThanV3.analyze(store, detectOnce);
        this._webModulesLessThanV25.analyze(store, detectOnce);
        this._appClientsLessThanV5.analyze(store, detectOnce);
        this._detectDTDs.analyze(store, detectOnce);
    }

    public void addFileNames(List<String> fileNames, String fileName) {
        String[] fileTypes = new String[]{".war", ".jar"};
        int index = -1;
        String[] stringArray = fileTypes;
        int n = fileTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            index = fileName.indexOf(type);
            if (index > -1) break;
            ++n2;
        }
        if (index > -1) {
            fileNames.add(fileName.substring(0, index + 4));
        }
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> parentResultsList = super.getResults(store);
        if (!parentResultsList.isEmpty()) {
            String fileName;
            List<DetailResult> dtdCatches = this._detectDTDs.getResults(store);
            List<DetailResult> ejbVersionCatches = this._ejbJarsLessThanV3.getResults(store);
            List<DetailResult> webVersionCatches = this._webModulesLessThanV25.getResults(store);
            List<DetailResult> appClientVersionCatches = this._appClientsLessThanV5.getResults(store);
            ArrayList<String> lessThanEE5ProjectNames = new ArrayList<String>();
            for (DetailResult nextResult : dtdCatches) {
                fileName = nextResult.getFileName();
                this.addFileNames(lessThanEE5ProjectNames, fileName);
            }
            for (DetailResult nextResult : ejbVersionCatches) {
                fileName = nextResult.getFileName();
                this.addFileNames(lessThanEE5ProjectNames, fileName);
            }
            for (DetailResult nextResult : webVersionCatches) {
                fileName = nextResult.getFileName();
                this.addFileNames(lessThanEE5ProjectNames, fileName);
            }
            for (DetailResult nextResult : appClientVersionCatches) {
                fileName = nextResult.getFileName();
                this.addFileNames(lessThanEE5ProjectNames, fileName);
            }
            Iterator<DetailResult> it = parentResultsList.iterator();
            while (it.hasNext()) {
                DetailResult nextResult = it.next();
                fileName = nextResult.getFileName();
                int index = fileName.indexOf(".war");
                if (index == -1) {
                    index = fileName.indexOf(".jar");
                }
                if (index > -1) {
                    fileName = fileName.substring(0, index + 4);
                }
                if (lessThanEE5ProjectNames.contains(fileName)) continue;
                it.remove();
            }
        }
        return parentResultsList;
    }
}

