/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.appconversion.jsp.core.model.JspNode;
import com.ibm.ws.appconversion.jsp.core.model.JspNodeType;
import com.ibm.ws.appconversion.jsp.core.util.CoreJspHelper;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.Constants;
import com.ibm.ws.report.binary.utilities.JSPResource;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

public class DetectWelcomeFileRequestQueryString
extends DetectRule {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JspRule, RuleType.XmlRule);
    protected static final String RULE_NAME = "DetectWelcomeFileRequestQueryString";
    protected static final String RULE_DESC = "appconversion.competitive.rule.jspWelcomeFileRequestStringQuery";
    private static final String REQUEST_GET_QUERY_STRING = "request.getQueryString()";
    private static final Pattern COUNT_NEW_LINES_PATTERN = Pattern.compile("\r\n|\r|\n");
    private static final Pattern NON_WHITESPACE_CHARACTER_PATTERN = Pattern.compile("\\S");
    private static final Pattern CONTAINS_REQUEST_QUERY_STRING_PATTERN = Pattern.compile("[\\s\\S]*[^a-zA-Z_\\$]request\\s*\\.\\s*getQueryString\\s*\\(\\s*\\)[\\s\\S]*");
    private static final String SUPER_REQUEST_QUERY_STRING_REGEX = "([^a-zA-Z$_]request\\s*\\.\\s*getQueryString\\s*\\(\\s*\\))|(\\/\\*[\\s\\S]*?[^a-zA-Z$_]request\\s*\\.\\s*getQueryString\\s*\\(\\s*\\)[\\s\\S]*?\\*\\/)|(\\/\\/.*[^a-zA-Z$_]request\\s*\\.\\s*getQueryString\\s*\\(\\s*\\).*)";
    private static final Pattern SUPER_REQUEST_QUERY_STRING_PATTERN = Pattern.compile("([^a-zA-Z$_]request\\s*\\.\\s*getQueryString\\s*\\(\\s*\\))|(\\/\\*[\\s\\S]*?[^a-zA-Z$_]request\\s*\\.\\s*getQueryString\\s*\\(\\s*\\)[\\s\\S]*?\\*\\/)|(\\/\\/.*[^a-zA-Z$_]request\\s*\\.\\s*getQueryString\\s*\\(\\s*\\).*)");
    private static final String WELCOME_FILE_JSP_VALUE_REGEXP = "/|\\\\.+\\.jsp";
    private static final Pattern WELCOME_FILE_JSP_VALUE_PATTERN = Pattern.compile("/|\\\\.+\\.jsp");
    protected static final String[] webXml = new String[]{"WEB-INF/web.xml"};
    protected static final String[] tag = new String[]{"welcome-file"};
    protected static final String tagValue = ".+\\.jsp";
    protected Set<String> jspWelcomeFiles = new HashSet<String>();
    protected Map<String, List<Integer>> jspWithRequestQueryString = new HashMap<String, List<Integer>>();
    protected DetectElement _welcomeFileWebXml = new DetectElement("DetectWelcomeFileRequestQueryString", "appconversion.competitive.rule.jspWelcomeFileRequestStringQuery", tag, webXml, ".+\\.jsp", null, false, null, null, null, false){

        @Override
        public boolean includeInResults(Node result, String key, XMLResource resource) {
            String value = XMLRuleUtil.getTextWithoutWhitespace(result);
            if (WELCOME_FILE_JSP_VALUE_PATTERN.matcher(value).matches()) {
                value = value.substring(1);
            }
            value = value.replace("\\", "/");
            String warName = ReportUtility.getLastArchiveFileName(key);
            StringBuilder sb = new StringBuilder();
            sb.append(warName).append("/").append(value);
            DetectWelcomeFileRequestQueryString.this.jspWelcomeFiles.add(sb.toString());
            return false;
        }
    };

    public DetectWelcomeFileRequestQueryString() {
        this(RULE_NAME, RULE_DESC, DetectRule.FlagOnce.NONE);
    }

    public DetectWelcomeFileRequestQueryString(String ruleName, String desc, DetectRule.FlagOnce flagOnceType) {
        super(ruleName, desc, flagOnceType);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return webXml;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.jspWelcomeFiles.clear();
        this.jspWithRequestQueryString.clear();
        this._welcomeFileWebXml.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        Set<String> keys = store.getJspKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                List<Integer> lineNumbers;
                JSPResource jspResource = store.getJsp(key);
                if (!Constants.JSP_ONLY_REGEX.matcher(key).matches() || (lineNumbers = this.containsCallToRequestQueryString(jspResource)).isEmpty()) continue;
                this.jspWithRequestQueryString.put(key, lineNumbers);
            }
        } else {
            this._welcomeFileWebXml.analyze(store, detectOnce);
        }
    }

    protected List<Integer> containsCallToRequestQueryString(JSPResource jspResource) {
        ArrayList<Integer> lineNumbers = new ArrayList<Integer>();
        List<JspNode> scriptletNodes = CoreJspHelper.filterForNodeType(jspResource.getJSPNodes(), JspNodeType.SCRIPTLET);
        for (JspNode jspNode : scriptletNodes) {
            String data = jspNode.getData();
            Matcher containsRequestGetQuerySTringMatcher = CONTAINS_REQUEST_QUERY_STRING_PATTERN.matcher(data);
            if (!containsRequestGetQuerySTringMatcher.matches()) continue;
            int lineNumber = jspNode.getLine();
            String dataAfterScriptletTag = data.substring(2);
            Matcher nonWhiteSpaceMatcher = NON_WHITESPACE_CHARACTER_PATTERN.matcher(dataAfterScriptletTag);
            int indexToStartCountingNewLinesFrom = 2;
            if (nonWhiteSpaceMatcher.find()) {
                indexToStartCountingNewLinesFrom = nonWhiteSpaceMatcher.start();
            }
            Matcher requestGetQueryStringMatcher = SUPER_REQUEST_QUERY_STRING_PATTERN.matcher(data);
            while (requestGetQueryStringMatcher.find()) {
                int index = requestGetQueryStringMatcher.start();
                String foundString = requestGetQueryStringMatcher.group(1);
                if (indexToStartCountingNewLinesFrom < index) {
                    String dataFromLastOccurrenceToThisOne = data.substring(indexToStartCountingNewLinesFrom, index);
                    Matcher newLineMatcher = COUNT_NEW_LINES_PATTERN.matcher(dataFromLastOccurrenceToThisOne);
                    while (newLineMatcher.find()) {
                        ++lineNumber;
                    }
                }
                if (foundString != null) {
                    lineNumbers.add(lineNumber);
                }
                indexToStartCountingNewLinesFrom = index;
            }
        }
        return lineNumbers;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        for (Map.Entry<String, List<Integer>> entry : this.jspWithRequestQueryString.entrySet()) {
            String jsp = entry.getKey();
            if (!this.jspWelcomeFiles.contains(jsp)) continue;
            List<Integer> lineNumbers = entry.getValue();
            for (Integer lineNumber : lineNumbers) {
                this.detailResults.add(new DetailResult(this.ruleName, jsp, this.ruleDescription, REQUEST_GET_QUERY_STRING, 1, null, lineNumber));
            }
        }
        return this.detailResults;
    }
}

