/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DetectConstructorInjectedResources
extends DetectAnnotation {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule);
    protected static final String RULE_NAME = "DetectConstructorInjectedResources";
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.jakartaee9.restfulws.DetectConstructorInjectedResources";
    protected static final String QueryParamClassJavax = "javax.ws.rs.QueryParam";
    protected static final String QueryParamClassJakarta = "jakarta.ws.rs.QueryParam";
    protected static final String[] queryClassNames = new String[]{"javax.ws.rs.QueryParam", "jakarta.ws.rs.QueryParam"};
    protected static final String PathClassJavax = "javax.ws.rs.Path";
    protected static final String PathClassJakarta = "jakarta.ws.rs.Path";
    protected static final String[] pathClassNames = new String[]{"javax.ws.rs.Path", "jakarta.ws.rs.Path"};
    protected static final String[] interestedAnnotations = new String[]{"javax.ws.rs.Path", "jakarta.ws.rs.Path", "javax.ws.rs.QueryParam", "jakarta.ws.rs.QueryParam"};
    protected DetectAnnotation _classPathAnnotations = null;
    protected Set<String> resourceClasses = new HashSet<String>();

    public DetectConstructorInjectedResources() {
        this(RULE_NAME, RULE_DESC, queryClassNames, null, null, null, null, null, false, "method", null, null);
    }

    public DetectConstructorInjectedResources(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, boolean flagOnce, String location, String defaultName, String missingAttributeName) {
        super(ruleName, desc, classNames, attributeName, attributeType, attributeValues, defaultValue, accessFlag, flagOnce, location, defaultName, missingAttributeName);
        this._classPathAnnotations = new DetectAnnotation(RULE_NAME, RULE_DESC, pathClassNames, null, null, null, null, null, false, "class", null, null){

            @Override
            protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
                DetectConstructorInjectedResources.this.resourceClasses.add(key);
                return false;
            }
        };
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._classPathAnnotations.analyze(store, detectOnce);
    }

    @Override
    protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
        String reference = ad.getReference();
        return reference != null && reference.equals("Method <init>");
    }

    @Override
    public String[] getAnnotations() {
        return interestedAnnotations;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> results = super.getResults(store);
        Iterator<DetailResult> it = results.iterator();
        while (it.hasNext()) {
            DetailResult result = it.next();
            String classPath = result.getFileName();
            if (this.resourceClasses.contains(classPath)) continue;
            it.remove();
        }
        return results;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.resourceClasses.clear();
    }
}

