/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.DetectStringLiteral;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class DeprecatedAppletAPI
extends DetectClass {
    protected static EnumSet<RuleType> ruleTypes = EnumSet.of(RuleType.JavaRule);
    protected static final String RULE_NAME = "DeprecatedAppletAPI";
    protected static final String RULE_DESC = "appconversion.jre.17.DeprecatedAppletAPI";
    static String[] classes = new String[]{"java.applet.Applet", "java.applet.AppletStub", "java.applet.AppletContext", "java.applet.AudioClip", "javax.swing.JApplet", "java.beans.AppletInitializer"};
    static String[] interestedClasses = new String[]{"java.applet.Applet", "java.applet.AppletStub", "java.applet.AppletContext", "java.applet.AudioClip", "javax.swing.JApplet", "java.beans.AppletInitializer", "javax.naming.Context"};
    DetectStringLiteral appletField = null;
    DetectClass appletFieldClass = null;
    String[] fieldClass = new String[]{"javax.naming.Context"};
    Set<String> contextClasses = new HashSet<String>();

    public DeprecatedAppletAPI() {
        super(RULE_NAME, RULE_DESC, classes, false, false, false, null, null, null, null, null, null);
        this.appletField = new DetectStringLiteral(RULE_NAME, RULE_DESC, new Pattern[]{Pattern.compile("java\\.naming\\.applet")}, false);
        this.appletFieldClass = new DetectClass(RULE_NAME, RULE_DESC, this.fieldClass, false, false, false, null, null, null, null, null, null){

            @Override
            protected boolean includeInResults(ClassDataStore data, String filename) {
                DeprecatedAppletAPI.this.contextClasses.add(filename);
                return false;
            }
        };
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> parentResults = super.getResults(store);
        List<DetailResult> detectStringLiteralResults = this.appletField.getResults(store);
        for (DetailResult result : detectStringLiteralResults) {
            if (!this.contextClasses.contains(result.getFileName())) continue;
            parentResults.add(result);
        }
        return parentResults;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this.appletField.analyze(store, detectOnce);
        this.appletFieldClass.analyze(store, detectOnce);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleTypes;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.appletField.clearResults();
        this.contextClasses.clear();
    }

    @Override
    public String[] getClassNames() {
        return interestedClasses;
    }
}

