/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.appconversion.jsp.core.model.JspNode;
import com.ibm.ws.appconversion.jsp.core.model.JspNodeType;
import com.ibm.ws.appconversion.jsp.core.util.CoreJspHelper;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectDTD;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectJspTaglib;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.JSPResource;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BehaviorJSTLELReservedWords
extends DetectJspTaglib {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.XmlRule, RuleType.JspRule);
    protected static final String RULE_NAME = "BehavaiorJSTLELReservedWords";
    protected static final String RULE_DESC = "appconversion.was2was.80.behavior.JSPJavaKeywordsEL";
    protected static final String[] elIgnoredTag = new String[]{"el-ignored"};
    protected static final String[] webXmlFileName = new String[]{"WEB-INF/web.xml"};
    protected static final String dftNamespace = "*";
    protected static final String valueTrue = "(?i:true)";
    protected static final String dtdNameForVersionsLessThan24 = "http://java\\.sun\\.com/dtd/web-app_2_3\\.dtd|http://java\\.sun\\.com/j2ee/dtds/web-app_2_2\\.dtd";
    protected DetectDTD _detectWebXmlVersionLessThan24 = null;
    protected DetectElement _detectWebXmlElIgnored = null;
    Map<String, Set<String>> webXmlPathToPatterns = new HashMap<String, Set<String>>();
    Set<String> jspsWithElIgnoredExplicitlyFalseSet = new HashSet<String>();
    Map<String, List<DetailResult>> jspToDetailResults = new HashMap<String, List<DetailResult>>();

    public BehaviorJSTLELReservedWords() {
        this(RULE_NAME, RULE_DESC, (String[])null, false);
    }

    public BehaviorJSTLELReservedWords(String ruleName, String desc, String[] taglibs, boolean flagOnce) {
        super(ruleName, desc, taglibs, flagOnce);
        this._detectWebXmlElIgnored = new DetectElement(ruleName, desc, elIgnoredTag, webXmlFileName, valueTrue, dftNamespace, false, null, null, null, false){

            @Override
            protected boolean includeInResults(Node node, String fileName, XMLResource resource) {
                String warFileName;
                Node parent = node.getParentNode();
                List<Element> children = XMLRuleUtil.getChildElements((Element)parent, BehaviorJSTLELReservedWords.dftNamespace, "url-pattern");
                HashSet<String> urlPatterns = new HashSet<String>();
                if (children != null && children.size() > 0) {
                    for (Element el : children) {
                        String value = XMLRuleUtil.getTextWithoutWhitespace(el);
                        if (value == null) continue;
                        urlPatterns.add(value);
                    }
                }
                if ((warFileName = BehaviorJSTLELReservedWords.this.getWarFileName(fileName)) == null) {
                    warFileName = fileName;
                }
                if (BehaviorJSTLELReservedWords.this.webXmlPathToPatterns.containsKey(warFileName)) {
                    Set<String> previousUrlPatterns = BehaviorJSTLELReservedWords.this.webXmlPathToPatterns.get(warFileName);
                    previousUrlPatterns.addAll(urlPatterns);
                } else {
                    BehaviorJSTLELReservedWords.this.webXmlPathToPatterns.put(warFileName, urlPatterns);
                }
                return false;
            }
        };
        this._detectWebXmlVersionLessThan24 = new DetectDTD(RULE_NAME, RULE_DESC, dtdNameForVersionsLessThan24, webXmlFileName, false, false);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return webXmlFileName;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectWebXmlElIgnored.clearResults();
        this._detectWebXmlVersionLessThan24.clearResults();
        this.webXmlPathToPatterns.clear();
        this.jspsWithElIgnoredExplicitlyFalseSet.clear();
        this.jspToDetailResults.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        this._detectWebXmlElIgnored.analyze(store, detectOnce);
        this._detectWebXmlVersionLessThan24.analyze(store, detectOnce);
        Set<String> keys = store.getJspKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                ArrayList<DetailResult> currentResults = new ArrayList<DetailResult>();
                JSPResource jspResource = store.getJsp(key);
                List<JspNode> jspNodes = jspResource.getJSPNodes();
                List<JspNode> directiveJSPNodes = CoreJspHelper.filterForNodeType(jspNodes, JspNodeType.DIRECTIVE);
                List<JspNode> elNodes = CoreJspHelper.filterForNodeType(jspNodes, JspNodeType.EL);
                Boolean ignoreELFromDirective = null;
                Boolean ignoreJSFFromDirective = null;
                for (JspNode jspNode : directiveJSPNodes) {
                    ignoreELFromDirective = CoreJspHelper.isELIgnoredFromPageDirective(jspNode);
                    if (Boolean.TRUE.equals(ignoreELFromDirective)) {
                        return;
                    }
                    if (ignoreJSFFromDirective != null) continue;
                    ignoreJSFFromDirective = CoreJspHelper.isJSFIgnoredFromPageDirective(jspNode);
                }
                if (Boolean.FALSE.equals(ignoreELFromDirective)) {
                    this.jspsWithElIgnoredExplicitlyFalseSet.add(key);
                }
                for (JspNode jspNode : elNodes) {
                    String nodeData = jspNode.getData();
                    if (ignoreJSFFromDirective != null && ignoreJSFFromDirective.equals(Boolean.TRUE) && nodeData.startsWith("#{") || !CoreJspHelper.containsReservedKeyword(nodeData)) continue;
                    currentResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, jspNode.getData(), 1, null, jspNode.getLine()));
                }
                this.jspToDetailResults.put(key, currentResults);
            }
        }
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        List<DetailResult> webXmlFilesWithVersionLessThan24 = this._detectWebXmlVersionLessThan24.getResults(store);
        for (DetailResult nextResult : webXmlFilesWithVersionLessThan24) {
            String fileName = nextResult.getFileName();
            String warFileName = this.getWarFileName(fileName);
            if (warFileName == null) {
                warFileName = fileName;
            }
            this.webXmlPathToPatterns.put(warFileName, new HashSet());
        }
        Set<String> jspFileNames = this.jspToDetailResults.keySet();
        for (String fileName : jspFileNames) {
            List<DetailResult> resultsForThisJsp = this.jspToDetailResults.get(fileName);
            if (resultsForThisJsp.isEmpty()) continue;
            if (this.jspsWithElIgnoredExplicitlyFalseSet.contains(fileName)) {
                finalResults.addAll(resultsForThisJsp);
                continue;
            }
            String warFileName = this.getWarFileName(fileName);
            if (warFileName != null) {
                if (this.webXmlPathToPatterns.containsKey(warFileName)) {
                    Set<String> urlPatterns = this.webXmlPathToPatterns.get(warFileName);
                    if (urlPatterns.isEmpty()) continue;
                    boolean foundMatch = false;
                    for (String nextPattern : urlPatterns) {
                        if (!this.jspNameMatchesUrlPattern(fileName, nextPattern)) continue;
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch) continue;
                    finalResults.addAll(resultsForThisJsp);
                    continue;
                }
                finalResults.addAll(resultsForThisJsp);
                continue;
            }
            finalResults.addAll(resultsForThisJsp);
        }
        return finalResults;
    }

    protected String getWarFileName(String fileName) {
        String warFileName = null;
        int index = fileName.lastIndexOf(".war");
        if (index > -1) {
            warFileName = fileName.substring(0, index + 4);
        }
        return warFileName;
    }

    private boolean jspNameMatchesUrlPattern(String jspFileName, String urlPattern) {
        String resPathAndName = jspFileName;
        String resName = jspFileName.substring(jspFileName.lastIndexOf(47) + 1);
        String resExt = jspFileName.substring(jspFileName.lastIndexOf(46) + 1);
        String fileNamePattern = "";
        if (urlPattern.contains("/")) {
            String dir = urlPattern.substring(0, urlPattern.lastIndexOf(47) + 1);
            String pathOnly = resPathAndName.substring(0, resPathAndName.indexOf(resName));
            if (!pathOnly.endsWith(dir)) {
                return false;
            }
            fileNamePattern = urlPattern.substring(urlPattern.lastIndexOf(47) + 1);
        } else {
            fileNamePattern = urlPattern;
        }
        if (fileNamePattern.equals(dftNamespace)) {
            return true;
        }
        if (fileNamePattern.contains("*.")) {
            String extPattern = fileNamePattern.substring(fileNamePattern.indexOf("*.") + 2);
            return resExt.equals(extPattern);
        }
        return fileNamePattern.equals(resName);
    }
}

