/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectPackage;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BehaviorApplicationWithJSF
extends DetectElement {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule, RuleType.XmlRule);
    protected static final String RULE_NAME = "BehaviorApplicationWithJSF";
    protected static final String RULE_DESC = "appconversion.was2was.80.behavior.JSFInApplications";
    protected static final boolean FLAG_ONCE = true;
    protected static final String[] tags = new String[]{"faces-config"};
    protected static final String[] fileNames = new String[]{"^(?!(web|.*/web)(?=\\.xml))(.*\\.xml)$"};
    protected static final String[] dtdNames = new String[]{"http://java.sun.com/dtd/web-facesconfig_1_0.dtd", "http://java.sun.com/dtd/web-facesconfig_1_1.dtd"};
    protected static final String[] webXml = new String[]{"WEB-INF/web.xml"};
    protected static final String[] tagListenerClass = new String[]{"listener-class"};
    protected static final String valueListenerClass = "com\\.sun\\.faces\\..*";
    protected static final String[] allXmlFiles = new String[]{fileNames[0], webXml[0]};
    protected static final String[] packageNames = new String[]{"com.sun.faces*"};
    protected static final String[] implementationPackageNames = new String[]{"com.sun.faces", "com.sun.faces.application", "com.sun.faces.application.annotation", "com.sun.faces.application.resource", "com.sun.faces.application.view", "com.sun.faces.component", "com.sun.faces.component.behavior", "com.sun.faces.component.validator", "com.sun.faces.component.visit", "com.sun.faces.config", "com.sun.faces.config.configprovider", "com.sun.faces.config.processor", "com.sun.faces.context", "com.sun.faces.context.flash", "com.sun.faces.el", "com.sun.faces.ext.component", "com.sun.faces.ext.render", "com.sun.faces.ext.taglib", "com.sun.faces.ext.validator", "com.sun.faces.facelets", "com.sun.faces.facelets.compiler", "com.sun.faces.facelets.component", "com.sun.faces.facelets.el", "com.sun.faces.facelets.impl", "com.sun.faces.facelets.tag", "com.sun.faces.facelets.tag.composite", "com.sun.faces.facelets.tag.jsf", "com.sun.faces.facelets.tag.jsf.core", "com.sun.faces.facelets.tag.jsf.html", "com.sun.faces.facelets.tag.jstl.core", "com.sun.faces.facelets.tag.jstl.fn", "com.sun.faces.facelets.tag.ui", "com.sun.faces.facelets.util", "com.sun.faces.io", "com.sun.faces.lifecycle", "com.sun.faces.mgbean", "com.sun.faces.renderkit", "com.sun.faces.renderkit.html_basic", "com.sun.faces.scripting", "com.sun.faces.spi", "com.sun.faces.taglib", "com.sun.faces.taglib.html_basic", "com.sun.faces.taglib.jsf_core", "com.sun.faces.util", "com.sun.faces.vendor"};
    protected DetectElement _listenerClass = null;
    protected DetectPackage _sunFacesPackage = null;
    protected DetectPackage _detectImplementation = null;

    public BehaviorApplicationWithJSF() {
        this(RULE_NAME, RULE_DESC, tags, fileNames, null, null, true, null, null, null, false);
    }

    public BehaviorApplicationWithJSF(String ruleName, String desc, String[] tags, String[] fileNames, String value, String namespace, boolean flagOnce, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty) {
        super(ruleName, desc, tags, fileNames, value, namespace, flagOnce, docNamespace, missingChildElement, missingChildElementValue, flagNotEmpty);
        this._listenerClass = new DetectElement(ruleName, desc, tagListenerClass, webXml, valueListenerClass, null, true, null, null, null, false);
        this._sunFacesPackage = new DetectPackage(ruleName, desc, packageNames, false, false, null, null, true);
        this._detectImplementation = new DetectPackage(ruleName, desc, implementationPackageNames, true, true, null, null, false);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return allXmlFiles;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._listenerClass.clearResults();
        this._sunFacesPackage.clearResults();
        this._detectImplementation.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._listenerClass.analyze(store, detectOnce);
        this._sunFacesPackage.analyze(store, detectOnce);
        this._detectImplementation.analyze(store, detectOnce);
    }

    protected boolean doesContainDTDName(String matchDtdName) {
        boolean flag = false;
        String[] stringArray = dtdNames;
        int n = dtdNames.length;
        int n2 = 0;
        while (n2 < n) {
            String dtdName = stringArray[n2];
            if (matchDtdName.equals(dtdName)) {
                return true;
            }
            ++n2;
        }
        return flag;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> parentResults = super.getResults(store);
        List<DetailResult> implementationResults = this._detectImplementation.getResults(store);
        ArrayList<String> implPackageNamesArr = new ArrayList<String>(Arrays.asList(implementationPackageNames));
        for (DetailResult implRes : implementationResults) {
            if (!implPackageNamesArr.contains(implRes.getCriteria())) continue;
            implPackageNamesArr.remove(implRes.getCriteria());
        }
        if (!implPackageNamesArr.isEmpty()) {
            List<DetailResult> sunFacesPackageResults;
            List<DetailResult> listenerClassResults = this._listenerClass.getResults(store);
            if (!listenerClassResults.isEmpty()) {
                for (DetailResult nextResult : listenerClassResults) {
                    if (!this.flag(nextResult.getFileName())) continue;
                    parentResults.add(nextResult);
                }
            }
            if (!(sunFacesPackageResults = this._sunFacesPackage.getResults(store)).isEmpty()) {
                for (DetailResult nextResult : sunFacesPackageResults) {
                    if (!this.flag(nextResult.getFileName())) continue;
                    parentResults.add(nextResult);
                }
            }
        }
        return parentResults;
    }

    @Override
    public boolean includeInResults(Node result, String key, XMLResource resource) {
        boolean includeInResults = false;
        Document doc = resource.getDocument();
        DocumentType docType = doc.getDoctype();
        if (docType != null && docType.getSystemId() != null) {
            String systemId = docType.getSystemId();
            includeInResults = this.doesContainDTDName(systemId);
        } else {
            includeInResults = this.isV1_2(doc);
        }
        return includeInResults;
    }

    private boolean isV1_2(Document doc) {
        Element root = doc.getDocumentElement();
        String version = root.getAttribute("version");
        return version != null && version.equals("1.2");
    }
}

