/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAttribute;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AbsoluteOrderingBehaviorChange
extends DetectAttribute {
    protected static final String RULE_NAME = "AbsoluteOrderingBehaviorChange";
    protected static final String RULE_DESC = "appconversion.javaee7.servlet.AbsoluteOrderingBehaviorChange";
    protected static final String[] WEB_APP_TAG = new String[]{"web-app"};
    protected static final String[] WEB_XML_FILE_NAME = new String[]{"WEB-INF/web.xml"};
    protected static final String METADATA_COMPLETE_ATTRIBUTE = "metadata-complete";
    protected static final String METADATA_COMPLETE_VALUE = "(?i)true";
    protected static final String[] NAME_TAG = new String[]{"name"};
    protected static final String[] WEB_FRAGMENT_TAG = new String[]{"web-fragment"};
    protected static final String[] WEB_FRAGMENT_XML_FILE_NAME = new String[]{"META-INF/web-fragment.xml"};
    protected static final String ABSOLUTE_ORDERING_ELEMENT = "absolute-ordering";
    protected static final String[] allXmlFiles = new String[]{WEB_XML_FILE_NAME[0], WEB_FRAGMENT_XML_FILE_NAME[0]};
    Map<String, Set<String>> projectToAbsoluteOrderingInfo = new HashMap<String, Set<String>>();
    Map<String, List<WebFragmentNameInfo>> projectToWebFragmentNames = new HashMap<String, List<WebFragmentNameInfo>>();
    protected DetectElement _detectWebFragmentNameElements = null;

    public AbsoluteOrderingBehaviorChange() {
        this(RULE_NAME, RULE_DESC, WEB_APP_TAG, WEB_XML_FILE_NAME, null, METADATA_COMPLETE_ATTRIBUTE, METADATA_COMPLETE_VALUE, null, false, null, null);
    }

    public AbsoluteOrderingBehaviorChange(String ruleName, String desc, String[] tags, String[] fileNames, String namespace, String attributeName, String attributeValue, String attributeNamespace, boolean flagOnce, String validateNamespace, String docNamespace) {
        super(ruleName, desc, tags, fileNames, namespace, attributeName, attributeValue, attributeNamespace, flagOnce, validateNamespace, docNamespace);
        this._detectWebFragmentNameElements = new DetectElement(ruleName, desc, NAME_TAG, WEB_FRAGMENT_XML_FILE_NAME, null, null, false, null, null, null, false, null, null, null, false, WEB_FRAGMENT_TAG, false){

            @Override
            protected boolean includeInResults(Node node, String fileName, XMLResource resource) {
                String warFileName = AbsoluteOrderingBehaviorChange.this.getWarFileName(fileName);
                if (warFileName != null) {
                    List<Object> webFragmentNames = null;
                    if (AbsoluteOrderingBehaviorChange.this.projectToWebFragmentNames.containsKey(warFileName)) {
                        webFragmentNames = AbsoluteOrderingBehaviorChange.this.projectToWebFragmentNames.get(warFileName);
                    } else {
                        webFragmentNames = new ArrayList();
                        AbsoluteOrderingBehaviorChange.this.projectToWebFragmentNames.put(warFileName, webFragmentNames);
                    }
                    String thisWebFragmentName = XMLRuleUtil.getTextWithoutWhitespace(node);
                    if (thisWebFragmentName != null && thisWebFragmentName.length() > 0) {
                        int lineNumber = resource.getNodeLineNumber(node);
                        WebFragmentNameInfo info = new WebFragmentNameInfo(fileName, thisWebFragmentName, lineNumber);
                        webFragmentNames.add(info);
                    }
                }
                return false;
            }
        };
    }

    @Override
    public String[] getFileNames() {
        return allXmlFiles;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectWebFragmentNameElements.clearResults();
        this.projectToAbsoluteOrderingInfo.clear();
        this.projectToWebFragmentNames.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._detectWebFragmentNameElements.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        Set<String> keys = this.projectToWebFragmentNames.keySet();
        for (String key : keys) {
            Set<String> namesIncluded = this.projectToAbsoluteOrderingInfo.get(key);
            if (namesIncluded == null) continue;
            List<WebFragmentNameInfo> infos = this.projectToWebFragmentNames.get(key);
            for (WebFragmentNameInfo nextInfo : infos) {
                if (namesIncluded.contains(nextInfo.webFragmentName)) continue;
                finalResults.add(new DetailResult(this.ruleName, nextInfo.resourceFileName, this.ruleDescription, NAME_TAG[0], 1, null, nextInfo.nameNodeLineNumber));
            }
        }
        return finalResults;
    }

    protected String getWarFileName(String fileName) {
        String warFileName = null;
        int index = fileName.lastIndexOf(".war");
        if (index > -1) {
            warFileName = fileName.substring(0, index + 4);
        }
        return warFileName;
    }

    @Override
    protected boolean includeInResults(String fileName, Node node) {
        Element rootElement;
        List<Element> absoluteOrderingElements;
        String warFileName = this.getWarFileName(fileName);
        if (warFileName != null && (absoluteOrderingElements = XMLRuleUtil.getChildElements(rootElement = ((Attr)node).getOwnerElement(), "*", ABSOLUTE_ORDERING_ELEMENT)) != null && !absoluteOrderingElements.isEmpty()) {
            HashSet<String> namesIncluded = new HashSet<String>();
            for (Element absOrderElement : absoluteOrderingElements) {
                List<Element> names = XMLRuleUtil.getChildElements(absOrderElement, "*", NAME_TAG[0]);
                if (names == null) continue;
                for (Element nextName : names) {
                    String nameValue = XMLRuleUtil.getTextWithoutWhitespace(nextName);
                    if (nameValue == null || nameValue.length() <= 0) continue;
                    namesIncluded.add(nameValue);
                }
            }
            this.projectToAbsoluteOrderingInfo.put(warFileName, namesIncluded);
        }
        return false;
    }

    private class WebFragmentNameInfo {
        public String resourceFileName;
        public String webFragmentName;
        public int nameNodeLineNumber;

        public WebFragmentNameInfo(String fileName, String name2, int lineNumber) {
            this.resourceFileName = fileName;
            this.webFragmentName = name2;
            this.nameNodeLineNumber = lineNumber;
        }
    }
}

