/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectPackage;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.Constants;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class DetectPackageAndBundleImports
extends DetectPackage {
    protected boolean validateBundleImports = false;
    protected Map<String, Manifest> manifests = new HashMap<String, Manifest>();
    protected Map<String, String> includePackageForClass = new HashMap<String, String>();

    public DetectPackageAndBundleImports(String ruleName, String desc, String[] packageNames, boolean useAppProvidedLibraries, boolean skipScanForUsage, String[] excludeClassNames, String[] excludePackageNames, boolean flagOnce, boolean validateBundleImports) {
        super(ruleName, desc, packageNames, useAppProvidedLibraries, skipScanForUsage, excludeClassNames, excludePackageNames, flagOnce);
        this.validateBundleImports = validateBundleImports;
        this._ruleType.add(RuleType.ManifestRule);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.manifests.clear();
        this.includePackageForClass.clear();
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> tempResults = super.getResults(store);
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        for (DetailResult nextResult : tempResults) {
            String packageName = nextResult.getCriteria();
            String className = nextResult.getFileName();
            String classNameWithContext = (String)this.classNameToNameWithContext.get(className);
            if (!this.includePackageInResults(classNameWithContext, packageName) || !this.flag(className)) continue;
            if (this.flagOnce) {
                nextResult.setNumberOfOccurrences(1);
            }
            finalResults.add(nextResult);
        }
        return finalResults;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        Set<String> keys = store.getManifestKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                String value;
                Manifest mf = store.getManifest(key);
                Attributes manifestMap = mf.getMainAttributes();
                String string = value = manifestMap != null ? manifestMap.getValue("Bundle-SymbolicName") : null;
                if (value != null) {
                    this.manifests.put(key, mf);
                    continue;
                }
                this.manifests.put(key, null);
            }
        } else {
            super.analyze(store, detectOnce);
        }
    }

    protected boolean includePackageInResults(String classNameWithContext, String packageName) {
        boolean flag = false;
        if (!this.validateBundleImports) {
            flag = true;
        } else {
            String cachedClassNameWithContext = this.includePackageForClass.get(packageName);
            if (cachedClassNameWithContext != null && cachedClassNameWithContext.equals(classNameWithContext)) {
                flag = true;
            } else if (this.validateBundleImports && !this.bundleImportsValid(classNameWithContext, packageName)) {
                flag = true;
                this.includePackageForClass.put(packageName, classNameWithContext);
            }
        }
        return flag;
    }

    protected String getManifestKey(String className, Set<String> mfKeys) {
        String key = null;
        String[] pathParts = className.split("/");
        int size = pathParts.length;
        boolean archiveFound = false;
        int i = size - 1;
        while (i >= 0) {
            String nextPart = pathParts[i];
            if (Constants.BUNDLE_ARCHIVE_REGEX.matcher(nextPart).matches()) {
                archiveFound = true;
                int j = 0;
                while (j <= i) {
                    key = key == null ? pathParts[j] : String.valueOf(key) + "/" + pathParts[j];
                    if (j == i) {
                        key = nextPart.endsWith(".cba") ? String.valueOf(key) + "/" + "META-INF/COMPOSITEBUNDLE.MF" : String.valueOf(key) + "/" + "META-INF/MANIFEST.MF";
                    }
                    ++j;
                }
                break;
            }
            if (nextPart.endsWith(".eba") || nextPart.endsWith(".ear") || nextPart.endsWith(".rar") || nextPart.endsWith(".zip")) {
                archiveFound = true;
                break;
            }
            --i;
        }
        if (key == null && !archiveFound) {
            int index = className.lastIndexOf(47);
            String path = className;
            while (index > -1) {
                if (mfKeys.contains(String.valueOf(path = path.substring(0, index)) + "/" + "META-INF/MANIFEST.MF")) {
                    key = String.valueOf(path) + "/" + "META-INF/MANIFEST.MF";
                    break;
                }
                if (mfKeys.contains(String.valueOf(path) + "/" + "META-INF/COMPOSITEBUNDLE.MF")) {
                    key = String.valueOf(path) + "/" + "META-INF/COMPOSITEBUNDLE.MF";
                    break;
                }
                index = path.lastIndexOf(47);
            }
            if (key == null) {
                if (mfKeys.contains("META-INF/MANIFEST.MF")) {
                    key = "META-INF/MANIFEST.MF";
                } else if (mfKeys.contains("META-INF/COMPOSITEBUNDLE.MF")) {
                    key = "META-INF/COMPOSITEBUNDLE.MF";
                }
            }
        }
        return key;
    }

    protected boolean bundleImportsValid(String className, String packageName) {
        String importPackage;
        Attributes manifestMap;
        Manifest mf;
        boolean flag = true;
        String matchPackage = packageName.replace(".", "\\.");
        String regexExpr = "(^|.+,)" + matchPackage + "($|,.+|;.+)";
        String manifestKey = this.getManifestKey(className, this.manifests.keySet());
        if (!(manifestKey == null || (mf = this.manifests.get(manifestKey)) == null || (manifestMap = mf.getMainAttributes()) == null || (importPackage = manifestMap.getValue("Import-Package")) != null && importPackage.matches(regexExpr))) {
            flag = false;
        }
        return flag;
    }
}

