/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.MethodDetails;
import com.ibm.ws.report.binary.asm.utilities.MethodInfo;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.asm.utilities.StackDetails;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.ArgumentDetail;
import com.ibm.ws.report.binary.utilities.RuleHelper;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.objectweb.asm.Type;

public class DetectMethod
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule);
    protected String[] methodNames = null;
    protected String[] owners = null;
    protected String returnType = null;
    protected String args = null;
    protected String[] argumentTypes = null;
    protected String[] flagCatchExceptions = null;
    protected String[] flagUnhandledExceptions = null;
    protected String[] matchForStringLiteral = null;
    protected String[] excludePackageNames = null;
    protected boolean mapKeysAndValuesOneToOne = false;
    protected Pattern containsNonNumbersPattern = Pattern.compile("[^0-9]");
    protected List<List<ArgumentDetail>> flagArguments = null;
    protected boolean handleEllipses = false;
    protected boolean handleEllipsesAtLastArgument = false;
    protected boolean handleEllipsesAtFirstArgument = false;
    protected boolean constructorOnly = false;
    protected boolean requireStackDetails = false;
    protected boolean matchFoundForStringLiteralOrVariable = false;
    protected Map<String, Map<String, MethodDetails>> classToMethodDetails = new HashMap<String, Map<String, MethodDetails>>();
    protected Map<String, Map<String, List<MethodDetails>>> implementedMethodsOnOwnerThatExtends = new HashMap<String, Map<String, List<MethodDetails>>>();
    protected Map<String, Map<String, List<MethodDetails>>> implementedMethodsOnOwnerThatImplements = new HashMap<String, Map<String, List<MethodDetails>>>();
    protected Map<String, Set<String>> additionalTypes = new HashMap<String, Set<String>>();
    protected Map<String, List<DetailResult>> tempTypeResults = new HashMap<String, List<DetailResult>>();

    public DetectMethod(String ruleName, String desc, boolean flagOnce) {
        super(ruleName, desc, flagOnce);
    }

    public DetectMethod(String ruleName, String desc, String[] methodNames, String[] owners, String returnType, String args, String[] excludePackageNames, boolean flagOnce, List<ArgumentDetail> argDetails, String[] flagCatchExceptions, String[] flagUnhandledExceptions) {
        this(ruleName, desc, methodNames, owners, returnType, args, excludePackageNames, flagOnce, argDetails, flagCatchExceptions, flagUnhandledExceptions, false);
    }

    public DetectMethod(String ruleName, String desc, String[] methodNames, String[] owners, String returnType, String args, String[] excludePackageNames, boolean flagOnce, List<ArgumentDetail> argDetails, String[] flagCatchExceptions, String[] flagUnhandledExceptions, boolean mapKeysAndValuesOneToOne) {
        this(ruleName, desc, methodNames, owners, returnType, args, excludePackageNames, flagOnce ? DetectRule.FlagOnce.ARCHIVE : DetectRule.FlagOnce.NONE, false, argDetails, flagCatchExceptions, flagUnhandledExceptions, mapKeysAndValuesOneToOne);
    }

    public DetectMethod(String ruleName, String desc, String[] methodNames, String[] owners, String returnType, String args, String[] excludePackageNames, DetectRule.FlagOnce flagOnceType, boolean hideResult, List<ArgumentDetail> argDetails, String[] flagCatchExceptions, String[] flagUnhandledExceptions, boolean mapKeysAndValuesOneToOne) {
        super(ruleName, desc, flagOnceType, hideResult);
        this.methodNames = methodNames;
        this.owners = owners;
        this.returnType = returnType;
        this.args = args;
        this.argumentTypes = RuleHelper.splitArgs(args);
        this.flagCatchExceptions = flagCatchExceptions;
        this.flagUnhandledExceptions = flagUnhandledExceptions;
        this.mapKeysAndValuesOneToOne = mapKeysAndValuesOneToOne;
        this.excludePackageNames = excludePackageNames;
        if (this.excludePackageNames != null) {
            int i = 0;
            while (i < this.excludePackageNames.length) {
                String packageName = this.excludePackageNames[i];
                if (packageName.endsWith(".*")) {
                    this.excludePackageNames[i] = String.valueOf(packageName.substring(0, packageName.lastIndexOf(46))) + "*";
                } else if (packageName.endsWith(".")) {
                    this.excludePackageNames[i] = packageName.substring(0, packageName.lastIndexOf(46));
                }
                ++i;
            }
        }
        boolean bl = this.constructorOnly = methodNames.length == 1 && methodNames[0].equals("<init>");
        if (this.argumentTypes != null && argDetails != null && !argDetails.isEmpty()) {
            int argSize;
            this.flagArguments = new ArrayList<List<ArgumentDetail>>();
            List<Object> currentArgDetails = null;
            int argDetailsSize = argDetails.size();
            if ("*".equals(args)) {
                this.argumentTypes = null;
                argSize = argDetailsSize;
            } else {
                argSize = this.argumentTypes.length;
            }
            int i = 0;
            while (i < argSize) {
                currentArgDetails = new ArrayList();
                this.flagArguments.add(currentArgDetails);
                ++i;
            }
            i = 0;
            while (i < argDetailsSize) {
                ArgumentDetail argDetail = argDetails.get(i);
                int position = argDetail.getPosition();
                if (position >= 0 && position < argSize) {
                    currentArgDetails = this.flagArguments.get(position);
                    currentArgDetails.add(argDetail);
                }
                ++i;
            }
        }
        this.requireStackDetails = this.flagArguments != null && this.flagArguments.size() > 0;
        this.initializeVariables();
    }

    protected void initializeVariables() {
        if (this.argumentTypes != null) {
            if (this.argumentTypes.length == 1) {
                if (this.argumentTypes[0].endsWith("...")) {
                    this.handleEllipsesAtFirstArgument = true;
                    this.handleEllipses = true;
                }
            } else if (this.argumentTypes.length > 1 && this.argumentTypes[this.argumentTypes.length - 1].endsWith("...")) {
                this.handleEllipsesAtLastArgument = true;
                this.handleEllipses = true;
            }
        }
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getMethodNames() {
        return this.methodNames;
    }

    public boolean requireStackDetails() {
        return this.requireStackDetails;
    }

    public String[] getOwners() {
        return this.owners;
    }

    protected boolean doesOwnerImplementMethod(String methodName, String ownerName) {
        boolean flag = false;
        Map<String, List<MethodDetails>> allImplMethods = null;
        allImplMethods = this.implementedMethodsOnOwnerThatExtends.containsKey(ownerName) ? this.implementedMethodsOnOwnerThatExtends.get(ownerName) : this.implementedMethodsOnOwnerThatImplements.get(ownerName);
        List<MethodDetails> implMethods = allImplMethods.get(methodName);
        if (implMethods != null) {
            for (MethodDetails implMd : implMethods) {
                Set<MethodInfo> implMIs = implMd.getMethodInfo(ownerName);
                if (implMIs == null) continue;
                for (MethodInfo implMI : implMIs) {
                    if (!implMI.matches(this.returnType, this.argumentTypes)) continue;
                    return true;
                }
            }
        }
        return flag;
    }

    protected List<DetailResult> processClass(String classFileName, Map<String, MethodDetails> mds, String[] methodOwners, boolean detectOnce, boolean checkIfOwnerImplementsMethod) {
        ArrayList<DetailResult> detailResults = new ArrayList<DetailResult>();
        String[] stringArray = this.methodNames;
        int n = this.methodNames.length;
        int n2 = 0;
        while (n2 < n) {
            block16: {
                String methodName = stringArray[n2];
                MethodDetails md = mds.get(methodName);
                if (md == null) break block16;
                String[] stringArray2 = methodOwners;
                int n3 = methodOwners.length;
                int n4 = 0;
                while (n4 < n3) {
                    block17: {
                        String ownerName = stringArray2[n4];
                        String criteria = null;
                        String argStr = this.argumentTypes == null ? "*" : this.args;
                        criteria = methodName.equals("<init>") ? String.valueOf(ownerName) + "(" + argStr + ")" : String.valueOf(ownerName) + "." + methodName + "(" + argStr + ")";
                        Set<MethodInfo> mis = md.getMethodInfo(ownerName);
                        if (mis == null) break block17;
                        for (MethodInfo mi : mis) {
                            if (!mi.matches(this.returnType, this.argumentTypes)) continue;
                            boolean includeMethodResults = true;
                            if (checkIfOwnerImplementsMethod && this.doesOwnerImplementMethod(methodName, ownerName)) {
                                includeMethodResults = false;
                            }
                            if (!includeMethodResults) continue;
                            Map<String, List<Integer>> info = mi.getMethodAndLineInfo();
                            Map<String, List<Integer>> methodNumberInfo = mi.getMethodAndMethodNumber();
                            Map<String, List<ArrayDeque<StackDetails>>> stackInfo = mi.getMethodAndStackInfo();
                            Map<String, List<List<String>>> catchExceptionInfo = mi.getCatchExceptionInfo();
                            Map<String, List<List<String>>> throwsExceptionInfo = mi.getThrowsExceptionInfo();
                            Set<String> methodKeys = info.keySet();
                            for (String methodKey : methodKeys) {
                                List<Integer> lineNumbers = info.get(methodKey);
                                List<Integer> methodNumbers = methodNumberInfo.get(methodKey);
                                List<ArrayDeque<StackDetails>> stackDetails = stackInfo.get(methodKey);
                                List<List<String>> catchExceptionDetails = catchExceptionInfo.get(methodKey);
                                List<List<String>> throwsExceptionDetails = throwsExceptionInfo.get(methodKey);
                                String reference = methodKey;
                                if (methodKey.contains("<init>")) {
                                    reference = Messages.getString("Report_Reference_Constructor");
                                } else if (methodKey.contains("<clinit>")) {
                                    reference = Messages.getString("Report_Reference_Static_Initializer");
                                }
                                int numLines = lineNumbers.size();
                                int index = 0;
                                while (index < numLines) {
                                    block20: {
                                        ArrayDeque<StackDetails> sdd;
                                        Integer methodNumber;
                                        Integer lineNumber;
                                        block18: {
                                            int stackSize;
                                            List<StackDetails> methodArguments;
                                            int size;
                                            block19: {
                                                ArgumentDetail argDetail;
                                                lineNumber = lineNumbers.get(index);
                                                methodNumber = methodNumbers.get(index);
                                                sdd = stackDetails.get(index);
                                                includeMethodResults = true;
                                                if (this.flagArguments == null || this.flagArguments.isEmpty()) break block18;
                                                Object copySdd = sdd.clone();
                                                includeMethodResults = false;
                                                size = this.flagArguments.size();
                                                methodArguments = this.getMethodArguments(ownerName, (ArrayDeque<StackDetails>)copySdd, lineNumber, this.handleEllipsesAtFirstArgument);
                                                stackSize = methodArguments.size();
                                                if (stackSize >= size) break block19;
                                                List<ArgumentDetail> argDetails = this.flagArguments.get(0);
                                                ArgumentDetail argumentDetail = argDetail = argDetails.size() > 0 ? argDetails.get(0) : null;
                                                if (size == 1 && this.argumentTypes != null && this.argumentTypes[0].endsWith("...") && argDetail != null && argDetail.getFlagVar() && argDetail.getFlagType() != null) break block20;
                                                includeMethodResults = true;
                                                break block18;
                                            }
                                            includeMethodResults = this.flagMethod(methodArguments, stackSize == size, this.handleEllipses, classFileName, criteria, reference, lineNumber, methodNumber);
                                        }
                                        if (includeMethodResults && this.flagCatchExceptions != null && this.flagCatchExceptions.length > 0) {
                                            includeMethodResults = this.isExceptionHandled(catchExceptionDetails.get(index), this.flagCatchExceptions);
                                        } else if (includeMethodResults && this.flagUnhandledExceptions != null && this.flagUnhandledExceptions.length > 0) {
                                            boolean isThrown;
                                            includeMethodResults = false;
                                            boolean isCaught = this.isExceptionHandled(catchExceptionDetails.get(index), this.flagUnhandledExceptions);
                                            if (!isCaught && !(isThrown = this.isExceptionHandled(throwsExceptionDetails.get(index), this.flagUnhandledExceptions))) {
                                                includeMethodResults = true;
                                            }
                                        }
                                        if (this.matchFoundForStringLiteralOrVariable) {
                                            String newArgList = this.splitArgStringAndReplaceIndex(argStr);
                                            criteria = methodName.equals("<init>") ? String.valueOf(ownerName) + "(" + newArgList + ")" : String.valueOf(ownerName) + "." + methodName + "(" + newArgList + ")";
                                        }
                                        if (includeMethodResults && this.includeInResults(md, mi, sdd, classFileName)) {
                                            detailResults.add(new DetailResult(this.ruleName, classFileName, this.ruleDescription, criteria, 1, reference, lineNumber, methodNumber));
                                            if (detectOnce || this.flagOnce) {
                                                return detailResults;
                                            }
                                        }
                                    }
                                    ++index;
                                }
                            }
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return detailResults;
    }

    private String splitArgStringAndReplaceIndex(String argStr) {
        ArrayList<String> argList = new ArrayList<String>();
        String[] stringArray = argStr.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            argList.add(arg);
            ++n2;
        }
        int i = 0;
        while (i < this.matchForStringLiteral.length) {
            String currentMatch = this.matchForStringLiteral[i];
            if (currentMatch != null) {
                argList.set(i, String.valueOf('\"') + currentMatch + '\"');
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        int j = 0;
        for (String arg : argList) {
            sb.append(arg);
            if (++j >= argList.size()) continue;
            sb.append(',');
        }
        String newArgString = sb.toString();
        return newArgString;
    }

    protected boolean flagMethod(List<StackDetails> methodArguments, boolean stackMatches, boolean handleEllipses, String classFileName, String criteria, String reference, int lineNumber, int methodNumber) {
        boolean finalFlag = false;
        this.matchForStringLiteral = new String[this.flagArguments.size()];
        this.matchFoundForStringLiteralOrVariable = false;
        int size = this.flagArguments == null ? 0 : this.flagArguments.size();
        int i = 0;
        while (i < size) {
            boolean flag = false;
            boolean nothingToCheckForPosition = false;
            List<ArgumentDetail> argDetails = this.flagArguments.get(i);
            int numArgDetailsToCheckForCurrentPosition = argDetails.size();
            int j = 0;
            while (j < numArgDetailsToCheckForCurrentPosition) {
                block54: {
                    block55: {
                        block74: {
                            Object value;
                            String previousTypeName;
                            Object value2;
                            StackDetails.StackType previousST;
                            StackDetails previousSD;
                            String thisMethodName;
                            String typeName;
                            int currentStackIndex;
                            StackDetails sd;
                            String flagType;
                            String flagVarValue;
                            block76: {
                                block75: {
                                    StackDetails.StackType st;
                                    boolean flagVar;
                                    block70: {
                                        block72: {
                                            List<Object> theResults;
                                            String ellipsesObjectType;
                                            block73: {
                                                block71: {
                                                    Object value3;
                                                    String flagValue;
                                                    block66: {
                                                        block69: {
                                                            boolean flagTypeLiteral;
                                                            block68: {
                                                                block67: {
                                                                    String typeName2;
                                                                    block64: {
                                                                        block65: {
                                                                            String valueStr;
                                                                            block57: {
                                                                                block63: {
                                                                                    block58: {
                                                                                        block61: {
                                                                                            block62: {
                                                                                                Object value4;
                                                                                                block59: {
                                                                                                    block60: {
                                                                                                        block56: {
                                                                                                            ArgumentDetail argDetail;
                                                                                                            block53: {
                                                                                                                argDetail = argDetails.get(j);
                                                                                                                flagVar = argDetail.getFlagVar();
                                                                                                                flagValue = argDetail.getFlagValue();
                                                                                                                flagVarValue = argDetail.getFlagVarValue();
                                                                                                                flagType = argDetail.getFlagType();
                                                                                                                flagTypeLiteral = argDetail.getFlagTypeLiteral();
                                                                                                                if (flagVar || flagTypeLiteral || flagValue != null || flagType != null) break block53;
                                                                                                                if (numArgDetailsToCheckForCurrentPosition == 1) {
                                                                                                                    nothingToCheckForPosition = true;
                                                                                                                    break;
                                                                                                                }
                                                                                                                break block54;
                                                                                                            }
                                                                                                            if (!stackMatches && i != 0 && i != size - 1) break block55;
                                                                                                            sd = null;
                                                                                                            currentStackIndex = i;
                                                                                                            if (stackMatches) {
                                                                                                                sd = methodArguments.get(i);
                                                                                                            } else if (this.args.equals("*")) {
                                                                                                                sd = methodArguments.get(argDetail.getPosition() + 1);
                                                                                                            } else if (i == 0) {
                                                                                                                if (size == 1 && !handleEllipses) {
                                                                                                                    currentStackIndex = methodArguments.size() - 1;
                                                                                                                    sd = methodArguments.get(currentStackIndex);
                                                                                                                } else {
                                                                                                                    sd = methodArguments.get(i);
                                                                                                                }
                                                                                                            } else {
                                                                                                                currentStackIndex = methodArguments.size() - 1;
                                                                                                                sd = methodArguments.get(currentStackIndex);
                                                                                                            }
                                                                                                            st = sd.getType();
                                                                                                            if (!st.equals((Object)StackDetails.StackType.CONSTANT_NULL)) break block56;
                                                                                                            if ("null".equals(flagType)) {
                                                                                                                flag = true;
                                                                                                            }
                                                                                                            break block54;
                                                                                                        }
                                                                                                        if (!st.equals((Object)StackDetails.StackType.VARIABLE)) break block57;
                                                                                                        if (!flagVar) break block54;
                                                                                                        if (flagValue == null && flagVarValue == null) break block58;
                                                                                                        typeName = sd.getTypeClassName();
                                                                                                        if (!"java.lang.String".equals(typeName)) break block59;
                                                                                                        String valueToFlag = flagVarValue;
                                                                                                        if (valueToFlag == null) {
                                                                                                            valueToFlag = flagValue;
                                                                                                        }
                                                                                                        if ((value4 = sd.getValue()) == null || !(value4 instanceof String)) break block60;
                                                                                                        String valueStr2 = (String)value4;
                                                                                                        if (valueStr2.matches(valueToFlag)) {
                                                                                                            flag = true;
                                                                                                            this.matchFoundForStringLiteralOrVariable = true;
                                                                                                            this.matchForStringLiteral[i] = valueStr2;
                                                                                                            break;
                                                                                                        }
                                                                                                        break block54;
                                                                                                    }
                                                                                                    flag = true;
                                                                                                    break;
                                                                                                }
                                                                                                if (!"int".equals(typeName) && !"java.lang.Object".equals(typeName) && !"java.lang.Boolean".equals(typeName)) break block61;
                                                                                                String valueToFlag = flagVarValue;
                                                                                                if (valueToFlag == null) {
                                                                                                    valueToFlag = flagValue;
                                                                                                }
                                                                                                if ((value4 = sd.getValue()) == null) break block62;
                                                                                                String compareValue = value4.toString();
                                                                                                if (valueToFlag.equals(compareValue)) {
                                                                                                    flag = true;
                                                                                                    break;
                                                                                                }
                                                                                                if (this.containsNonNumbersPattern.matcher(valueToFlag).find()) {
                                                                                                    flag = compareValue.matches(valueToFlag);
                                                                                                    break;
                                                                                                }
                                                                                                if (flagType != null && flagType.equals("java.lang.Boolean")) {
                                                                                                    if (valueToFlag.equalsIgnoreCase("TRUE")) {
                                                                                                        valueToFlag = "1";
                                                                                                    } else if (valueToFlag.equalsIgnoreCase("FALSE")) {
                                                                                                        valueToFlag = "0";
                                                                                                    }
                                                                                                }
                                                                                                if (valueToFlag.equals(compareValue)) {
                                                                                                    flag = true;
                                                                                                    break;
                                                                                                }
                                                                                                break block54;
                                                                                            }
                                                                                            flag = true;
                                                                                            break;
                                                                                        }
                                                                                        flag = true;
                                                                                        break;
                                                                                    }
                                                                                    if (flagType == null) break block63;
                                                                                    typeName = sd.getTypeClassName();
                                                                                    if (flagType.equals(typeName)) {
                                                                                        flag = true;
                                                                                        break;
                                                                                    }
                                                                                    if (!stackMatches && i == 0 && this.doesFirstMethodMatchReturnType(flagType, methodArguments, i + 1)) {
                                                                                        flag = true;
                                                                                        break;
                                                                                    }
                                                                                    if (flagType.equals("null") && sd.getValue() == null) {
                                                                                        flag = true;
                                                                                        break;
                                                                                    }
                                                                                    break block54;
                                                                                }
                                                                                flag = true;
                                                                                break;
                                                                            }
                                                                            if (!st.equals((Object)StackDetails.StackType.CONSTANT_STRING_LITERAL)) break block64;
                                                                            if (flagValue == null) break block65;
                                                                            value3 = sd.getValue();
                                                                            if (value3 instanceof String && (valueStr = (String)value3).matches(flagValue)) {
                                                                                flag = true;
                                                                                this.matchFoundForStringLiteralOrVariable = true;
                                                                                this.matchForStringLiteral[i] = valueStr;
                                                                                break;
                                                                            }
                                                                            break block54;
                                                                        }
                                                                        if (flagType == null) break block54;
                                                                        typeName = sd.getTypeClassName();
                                                                        if (flagType.equals(typeName)) {
                                                                            flag = true;
                                                                            break;
                                                                        }
                                                                        if (!stackMatches && i == 0 && this.doesFirstMethodMatchReturnType(flagType, methodArguments, i + 1)) {
                                                                            flag = true;
                                                                            break;
                                                                        }
                                                                        break block54;
                                                                    }
                                                                    if (!st.equals((Object)StackDetails.StackType.CONSTANT_TYPE_LITERAL)) break block66;
                                                                    if (flagValue == null) break block67;
                                                                    value3 = sd.getValue();
                                                                    if (value3 instanceof Type && flagValue.equals(typeName2 = sd.getTypeClassName())) {
                                                                        flag = true;
                                                                        break;
                                                                    }
                                                                    break block54;
                                                                }
                                                                if (flagType == null) break block68;
                                                                typeName = sd.getTypeClassName();
                                                                if (flagType.equals(typeName)) {
                                                                    flag = true;
                                                                    break;
                                                                }
                                                                break block54;
                                                            }
                                                            if (!flagTypeLiteral) break block54;
                                                            if (!handleEllipses) break block69;
                                                            if ((i == size - 1 || i == 0) && this.verifyEllipsesObjectTypeLiteral(methodArguments, i == 0)) {
                                                                flag = true;
                                                                break;
                                                            }
                                                            break block54;
                                                        }
                                                        flag = true;
                                                        break;
                                                    }
                                                    if (!st.equals((Object)StackDetails.StackType.CONSTANT_PRIMITIVE)) break block70;
                                                    if (flagValue == null) break block71;
                                                    value3 = sd.getValue();
                                                    if (value3 != null) {
                                                        if (flagValue.equals(value3.toString())) {
                                                            flag = true;
                                                            break;
                                                        }
                                                        if (this.containsNonNumbersPattern.matcher(flagValue).find()) {
                                                            flag = value3.toString().matches(flagValue);
                                                            break;
                                                        }
                                                    }
                                                    break block54;
                                                }
                                                if (flagType == null) break block54;
                                                typeName = sd.getTypeClassName();
                                                if (!handleEllipses || i != 0) break block72;
                                                if (!"int".equals(typeName)) break block54;
                                                int numObjects = 0;
                                                Object sdValue = sd.getValue();
                                                if (sdValue != null) {
                                                    numObjects = sdValue instanceof Integer ? (Integer)sdValue : Integer.parseInt(sdValue.toString());
                                                }
                                                if (numObjects != 1) break block54;
                                                ellipsesObjectType = this.getEllipsesObjectTypeClassName(methodArguments);
                                                if (!flagType.equals(ellipsesObjectType)) break block73;
                                                flag = true;
                                                break block54;
                                            }
                                            if (ellipsesObjectType == null) break block54;
                                            DetailResult tempResult = new DetailResult(this.ruleName, classFileName, this.ruleDescription, criteria, 1, reference, lineNumber, methodNumber);
                                            if (this.tempTypeResults.containsKey(ellipsesObjectType)) {
                                                theResults = this.tempTypeResults.get(ellipsesObjectType);
                                                theResults.add(tempResult);
                                            } else {
                                                theResults = new ArrayList<DetailResult>();
                                                theResults.add(tempResult);
                                                this.tempTypeResults.put(ellipsesObjectType, theResults);
                                            }
                                            break block54;
                                        }
                                        if (flagType.equals(typeName)) {
                                            flag = true;
                                        } else if (!stackMatches && i == 0 && this.doesFirstMethodMatchReturnType(flagType, methodArguments, i + 1)) {
                                            flag = true;
                                            break;
                                        }
                                        break block54;
                                    }
                                    if (!st.equals((Object)StackDetails.StackType.METHOD_CALL) || !flagVar) break block54;
                                    if (flagType == null) break block74;
                                    typeName = sd.getTypeClassName();
                                    if (flagVarValue != null) break block75;
                                    if (flagType.equals(typeName)) {
                                        flag = true;
                                        break;
                                    }
                                    break block54;
                                }
                                if (!flagType.equals("boolean") || !typeName.equals("java.lang.Boolean") || currentStackIndex <= 0) break block76;
                                String thisMethodOwner = sd.getOwner();
                                thisMethodName = sd.getName();
                                if (thisMethodOwner != null && thisMethodName != null && thisMethodOwner.equals("java.lang.Boolean") && (thisMethodName.equals("valueOf") || thisMethodName.equals("<init>"))) {
                                    previousSD = methodArguments.get(currentStackIndex - 1);
                                    previousST = previousSD.getType();
                                    if (previousST.equals((Object)StackDetails.StackType.CONSTANT_PRIMITIVE)) {
                                        value2 = previousSD.getValue();
                                        if (value2 != null && flagVarValue.equals(value2.toString())) {
                                            flag = true;
                                            break;
                                        }
                                    } else if (previousST.equals((Object)StackDetails.StackType.VARIABLE) && ("int".equals(previousTypeName = previousSD.getTypeClassName()) || "java.lang.Object".equals(previousTypeName)) && (value = previousSD.getValue()) != null && flagVarValue.equals(value.toString())) {
                                        flag = true;
                                        break;
                                    }
                                }
                                break block54;
                            }
                            if (!flagType.equals("java.lang.Boolean") || !typeName.equals("boolean") || currentStackIndex <= 0) break block54;
                            String thisMethodOwner = sd.getOwner();
                            thisMethodName = sd.getName();
                            if (thisMethodOwner == null || thisMethodName == null || !thisMethodOwner.equals("java.lang.Boolean") || !thisMethodName.equals("booleanValue")) break block54;
                            previousSD = methodArguments.get(currentStackIndex - 1);
                            previousST = previousSD.getType();
                            if (previousST.equals((Object)StackDetails.StackType.CONSTANT_PRIMITIVE)) {
                                value2 = previousSD.getValue();
                                if (value2 != null && flagVarValue.equals(value2.toString())) {
                                    flag = true;
                                    break;
                                }
                            } else if (previousST.equals((Object)StackDetails.StackType.VARIABLE) && "java.lang.Boolean".equals(previousTypeName = previousSD.getTypeClassName()) && (value = previousSD.getValue()) != null && flagVarValue.equals(value.toString())) {
                                flag = true;
                                break;
                            }
                            break block54;
                        }
                        flag = true;
                        break;
                    }
                    flag = true;
                    break;
                }
                ++j;
            }
            if (flag) {
                finalFlag = true;
            } else if (!nothingToCheckForPosition && numArgDetailsToCheckForCurrentPosition != 0) {
                finalFlag = false;
                break;
            }
            ++i;
        }
        return finalFlag;
    }

    protected boolean verifyEllipsesObjectTypeLiteral(List<StackDetails> args, boolean firstArgument) {
        boolean flag = false;
        int numObjects = 0;
        int size = args.size();
        if (firstArgument) {
            int i = 0;
            while (i < size - 1) {
                StackDetails thisSD = args.get(i);
                StackDetails.StackType st = thisSD.getType();
                if (!st.equals((Object)StackDetails.StackType.CONSTANT_PRIMITIVE) || !"int".equals(thisSD.getTypeClassName())) break;
                if (i == 0) {
                    Object sdValue = thisSD.getValue();
                    if (sdValue != null) {
                        numObjects = sdValue instanceof Integer ? (Integer)sdValue : Integer.parseInt(sdValue.toString());
                    }
                } else {
                    StackDetails nextSD;
                    StackDetails.StackType nextST;
                    int index = -1;
                    Object sdValue = thisSD.getValue();
                    if (sdValue != null) {
                        index = sdValue instanceof Integer ? (Integer)sdValue : Integer.parseInt(sdValue.toString());
                    }
                    if (index < 0 || index >= numObjects || !(nextST = (nextSD = args.get(++i)).getType()).equals((Object)StackDetails.StackType.CONSTANT_TYPE_LITERAL)) break;
                    if (index == numObjects - 1) {
                        flag = true;
                        break;
                    }
                }
                ++i;
            }
        } else {
            int i = size;
            while (i >= 3) {
                Object sdValue;
                StackDetails previousSD;
                StackDetails.StackType previousST;
                StackDetails thisSD = args.get(i - 1);
                StackDetails.StackType st = thisSD.getType();
                if (!st.equals((Object)StackDetails.StackType.CONSTANT_TYPE_LITERAL) || !(previousST = (previousSD = args.get(i - 2)).getType()).equals((Object)StackDetails.StackType.CONSTANT_PRIMITIVE) || !"int".equals(previousSD.getTypeClassName())) break;
                int indexValue = -1;
                if (i == size && (sdValue = previousSD.getValue()) != null) {
                    if (sdValue instanceof Integer) {
                        indexValue = (Integer)sdValue;
                        numObjects = indexValue + 1;
                    } else {
                        indexValue = Integer.parseInt(sdValue.toString());
                        numObjects = indexValue + 1;
                    }
                }
                if (indexValue == 0) {
                    StackDetails firstSD = args.get(i - 3);
                    StackDetails.StackType firstST = firstSD.getType();
                    if (!firstST.equals((Object)StackDetails.StackType.CONSTANT_PRIMITIVE) || !"int".equals(firstSD.getTypeClassName())) break;
                    Object sdValue2 = firstSD.getValue();
                    if (sdValue2 != null) {
                        int actualNumObjects = -1;
                        actualNumObjects = sdValue2 instanceof Integer ? (Integer)sdValue2 : Integer.parseInt(sdValue2.toString());
                        if (actualNumObjects != numObjects) break;
                        flag = true;
                        break;
                    }
                }
                i -= 2;
            }
        }
        return flag;
    }

    protected String getEllipsesObjectTypeClassName(List<StackDetails> args) {
        StackDetails sd;
        StackDetails.StackType type;
        String className = null;
        int numArgs = args.size();
        if (numArgs >= 3 && ((type = (sd = args.get(numArgs - 1)).getType()).equals((Object)StackDetails.StackType.VARIABLE) || type.equals((Object)StackDetails.StackType.METHOD_CALL))) {
            return sd.getTypeClassName();
        }
        return className;
    }

    protected boolean isExceptionHandled(List<String> handledExceptions, String[] compareExceptions) {
        boolean flag = false;
        String[] stringArray = compareExceptions;
        int n = compareExceptions.length;
        int n2 = 0;
        while (n2 < n) {
            String flagException = stringArray[n2];
            if (handledExceptions.contains(flagException)) {
                flag = true;
                break;
            }
            ++n2;
        }
        return flag;
    }

    protected boolean doesFirstMethodMatchReturnType(String typeName, List<StackDetails> arguments, int index) {
        boolean flag = false;
        int stackSize = arguments.size();
        if (index < stackSize) {
            int i = index;
            while (i < stackSize) {
                StackDetails sd = arguments.get(index);
                StackDetails.StackType st = sd.getType();
                if (st.equals((Object)StackDetails.StackType.METHOD_CALL)) {
                    String typeClassName = sd.getTypeClassName();
                    if (!typeName.equals(typeClassName)) break;
                    flag = true;
                    break;
                }
                ++i;
            }
        }
        return flag;
    }

    protected List<StackDetails> getMethodArguments(String owner, ArrayDeque<StackDetails> copySdd, int lineNumber, boolean includeFirstArgArrayDimensions) {
        ArrayList<StackDetails> sdList = new ArrayList<StackDetails>();
        if (copySdd != null) {
            Object type;
            StackDetails sd;
            for (StackDetails sd2 : copySdd) {
                if (sd2.getType() == StackDetails.StackType.CAST_ON_RETURN) {
                    copySdd.remove(sd2);
                    continue;
                }
                if (sd2.getType() != StackDetails.StackType.METHOD_CALL) continue;
                copySdd.remove(sd2);
                break;
            }
            while (!copySdd.isEmpty()) {
                sdList.add(0, copySdd.pop());
            }
            boolean foundOwnerInStack = false;
            int index = 0;
            int size = sdList.size();
            while (index < size) {
                sd = (StackDetails)sdList.get(index);
                type = sd.getType();
                if (type.equals((Object)StackDetails.StackType.VARIABLE) || type.equals((Object)StackDetails.StackType.METHOD_CALL)) {
                    if (owner.equals(sd.getTypeClassName())) {
                        foundOwnerInStack = true;
                        break;
                    }
                    if ((String.valueOf(owner) + "[]").equals(sd.getTypeClassName())) {
                        foundOwnerInStack = true;
                        ++index;
                        break;
                    }
                }
                ++index;
            }
            if (foundOwnerInStack) {
                int currentIndex = 0;
                while (currentIndex <= index) {
                    sdList.remove(0);
                    ++currentIndex;
                }
            } else if (!copySdd.isEmpty()) {
                String type2;
                StackDetails sdNext;
                sd = copySdd.pop();
                if (includeFirstArgArrayDimensions && sd.getType().equals((Object)StackDetails.StackType.CONSTANT_PRIMITIVE) && sd.getLineNumber() < lineNumber && !copySdd.isEmpty() && (type = sd.getTypeClassName()) != null && ((String)type).equals("int") && (sdNext = copySdd.pop()).getType().equals((Object)StackDetails.StackType.CONSTANT_PRIMITIVE) && sdNext.getLineNumber() == sd.getLineNumber() && (type2 = sdNext.getTypeClassName()) != null && type2.equals("int")) {
                    sdList.add(0, sd);
                    sdList.add(0, sdNext);
                }
            }
        }
        return sdList;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.classToMethodDetails.clear();
        this.implementedMethodsOnOwnerThatExtends.clear();
        this.implementedMethodsOnOwnerThatImplements.clear();
        this.additionalTypes.clear();
        this.tempTypeResults.clear();
    }

    protected void processAdditionalOwners(Set<String> ownerNames, boolean checkIfOwnerImplementsMethod) {
        int size = ownerNames.size();
        String[] moreOwners = new String[size];
        moreOwners = ownerNames.toArray(moreOwners);
        Set<String> keys = this.classToMethodDetails.keySet();
        for (String key : keys) {
            Map<String, MethodDetails> mds = this.classToMethodDetails.get(key);
            List<DetailResult> results = this.processClass(key, mds, moreOwners, false, checkIfOwnerImplementsMethod);
            if (this.flagOnce) {
                for (DetailResult result : results) {
                    if (!this.flag(result.getFileName())) continue;
                    this.detailResults.add(result);
                }
                continue;
            }
            this.detailResults.addAll(results);
        }
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        if (this.flagOnce) {
            ReportUtility.sortDetailResults(this.detailResults);
            Iterator it = this.detailResults.iterator();
            while (it.hasNext()) {
                DetailResult result = (DetailResult)it.next();
                if (this.flag(result.getFileName())) continue;
                it.remove();
            }
        }
        if (!this.implementedMethodsOnOwnerThatExtends.isEmpty()) {
            this.processAdditionalOwners(this.implementedMethodsOnOwnerThatExtends.keySet(), true);
        }
        if (!this.implementedMethodsOnOwnerThatImplements.isEmpty()) {
            this.processAdditionalOwners(this.implementedMethodsOnOwnerThatImplements.keySet(), false);
        }
        if (!this.additionalTypes.isEmpty()) {
            Set<String> typeNames = this.additionalTypes.keySet();
            for (String thisType : typeNames) {
                Set<String> classesThatImplementOrExtendType = this.additionalTypes.get(thisType);
                for (String className : classesThatImplementOrExtendType) {
                    if (!this.tempTypeResults.containsKey(className)) continue;
                    List<DetailResult> results = this.tempTypeResults.get(className);
                    if (this.flagOnce) {
                        for (DetailResult result : results) {
                            if (!this.flag(result.getFileName())) continue;
                            this.detailResults.add(result);
                        }
                        continue;
                    }
                    this.detailResults.addAll(results);
                }
            }
        }
        return this.detailResults;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        if (detectOnce && !this.detailResults.isEmpty()) {
            return;
        }
        Set<String> keys = store.getClassDataStoreKeys();
        for (String key : keys) {
            ClassDataStore data = store.getClassDataStore(key);
            if (this.inExcludedPackage(data.getClassName())) continue;
            if (!this.constructorOnly) {
                boolean classExtends = this.doesClassExtend(data);
                boolean classImplements = this.doesClassImplement(data);
                if (classExtends || classImplements) {
                    HashMap<String, List<MethodDetails>> implMds = new HashMap<String, List<MethodDetails>>();
                    String[] stringArray = this.methodNames;
                    int n = this.methodNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String methodName = stringArray[n2];
                        List<MethodDetails> mds = data.getImplementedMethodDetails(methodName);
                        if (!mds.isEmpty()) {
                            implMds.put(methodName, mds);
                        }
                        ++n2;
                    }
                    if (classExtends) {
                        this.implementedMethodsOnOwnerThatExtends.put(data.getClassName(), implMds);
                    } else {
                        this.implementedMethodsOnOwnerThatImplements.put(data.getClassName(), implMds);
                    }
                }
            }
            this.analyzeExtendOrImplementType(data);
            Map<String, MethodDetails> mds = data.getMethodDetails(this.methodNames);
            if (!mds.isEmpty() && !this.constructorOnly) {
                this.classToMethodDetails.put(key, mds);
            }
            List<DetailResult> results = this.processClass(key, mds, this.owners, detectOnce, false);
            this.detailResults.addAll(results);
        }
    }

    private boolean inExcludedPackage(String className) {
        if (this.excludePackageNames != null) {
            String[] stringArray = this.excludePackageNames;
            int n = this.excludePackageNames.length;
            int n2 = 0;
            while (n2 < n) {
                String classPackage;
                String tmpPackageName;
                String packageName = stringArray[n2];
                if (packageName.endsWith("*") ? className.startsWith(tmpPackageName = packageName.replace('*', '.')) : packageName.equals(classPackage = className.substring(0, className.lastIndexOf(46)))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean getMapKeysAndValuesOneToOne() {
        return this.mapKeysAndValuesOneToOne;
    }

    protected boolean doesClassExtend(ClassDataStore cd) {
        String[] stringArray = this.owners;
        int n = this.owners.length;
        int n2 = 0;
        while (n2 < n) {
            String owner = stringArray[n2];
            if (cd.doesClassExtend(owner)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean doesClassImplement(ClassDataStore cd) {
        String[] stringArray = this.owners;
        int n = this.owners.length;
        int n2 = 0;
        while (n2 < n) {
            String owner = stringArray[n2];
            if (cd.doesClassImplement(owner)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean includeInResults(MethodDetails md, MethodInfo mi, ArrayDeque<StackDetails> sdd, String filename) {
        return true;
    }

    protected boolean analyzeExtendOrImplementType(ClassDataStore cd) {
        boolean flag = false;
        if (this.flagArguments != null) {
            for (List<ArgumentDetail> argDetails : this.flagArguments) {
                for (ArgumentDetail argDetail : argDetails) {
                    Set<Object> classNames;
                    boolean result;
                    String type = argDetail.getFlagType();
                    if (type == null) continue;
                    boolean bl = result = cd.doesClassExtend(type) || cd.doesClassImplement(type);
                    if (!result) continue;
                    flag = result;
                    if (this.additionalTypes.containsKey(type)) {
                        classNames = this.additionalTypes.get(type);
                        classNames.add(cd.getClassName());
                        continue;
                    }
                    classNames = new HashSet<String>();
                    classNames.add(cd.getClassName());
                    this.additionalTypes.put(type, classNames);
                }
            }
        }
        return flag;
    }
}

