/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.FieldDetails;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class DetectEnumOrField
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule);
    protected String type = null;
    protected String[] values = null;

    public DetectEnumOrField(String ruleName, String desc, String type, String[] values, boolean flagOnce) {
        this(ruleName, desc, type, values, flagOnce ? DetectRule.FlagOnce.ARCHIVE : DetectRule.FlagOnce.NONE, false);
    }

    public DetectEnumOrField(String ruleName, String desc, String type, String[] values, DetectRule.FlagOnce flagOnceType, boolean hideResult) {
        super(ruleName, desc, flagOnceType, hideResult);
        this.type = type;
        this.values = values;
    }

    @Override
    public String getEnum() {
        return this.type;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        if (detectOnce && !this.detailResults.isEmpty()) {
            return;
        }
        Set<String> keys = store.getClassDataStoreKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                ClassDataStore data;
                List<FieldDetails> fds;
                if (!this.shouldFlag(key) || (fds = (data = store.getClassDataStore(key)).getFieldDetails(this.type)) == null) continue;
                for (FieldDetails fd : fds) {
                    String[] stringArray = this.values;
                    int n = this.values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String value = stringArray[n2];
                        if (value.equals(fd.getName())) {
                            if (this.flag(key)) {
                                this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, String.valueOf(this.type) + "." + value, 1, fd.getReference(), fd.getLineNumber()));
                            }
                            if (detectOnce || this.flagOnce) {
                                return;
                            }
                        }
                        ++n2;
                    }
                }
            }
        }
    }
}

