/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DetectAttribute
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.XmlRule);
    protected String namespace = "*";
    protected String[] tags = null;
    protected String[] xmlFiles = null;
    protected String attributeNamespace = "*";
    protected String attributeName = null;
    protected String attributeValue = null;
    protected boolean flagIfAttributeMissing = false;
    protected String documentNamespaceToValidate = null;
    protected String documentNamespace = null;
    protected DetectRule.XMLFileType xmlFileType = null;

    public DetectAttribute(String ruleName, String desc, String[] tags, String[] fileNames, String namespace, String attributeName, String regexAttributeValue, String attributeNamespace, boolean flagOnce, String validateNamespace, String documentNamespace) {
        this(ruleName, desc, tags, fileNames, namespace, attributeName, regexAttributeValue, attributeNamespace, flagOnce ? DetectRule.FlagOnce.ARCHIVE : DetectRule.FlagOnce.NONE, validateNamespace, documentNamespace);
    }

    public DetectAttribute(String ruleName, String desc, String[] tags, String[] fileNames, String namespace, String attributeName, String regexAttributeValue, String attributeNamespace, DetectRule.FlagOnce flagOnceType, String validateNamespace, String documentNamespace) {
        this(ruleName, desc, tags, fileNames, DetectRule.XMLFileType.ALL, namespace, attributeName, regexAttributeValue, attributeNamespace, flagOnceType, false, validateNamespace, documentNamespace, false);
    }

    public DetectAttribute(String ruleName, String desc, String[] tags, String[] fileNames, DetectRule.XMLFileType xmlFileType, String namespace, String attributeName, String regexAttributeValue, String attributeNamespace, DetectRule.FlagOnce flagOnceType, boolean hideResult, String validateNamespace, String documentNamespace) {
        this(ruleName, desc, tags, fileNames, xmlFileType, namespace, attributeName, regexAttributeValue, attributeNamespace, flagOnceType, hideResult, validateNamespace, documentNamespace, false);
    }

    public DetectAttribute(String ruleName, String desc, String[] tags, String[] fileNames, DetectRule.XMLFileType xmlFileType, String namespace, String attributeName, String regexAttributeValue, String attributeNamespace, DetectRule.FlagOnce flagOnceType, boolean hideResult, String validateNamespace, String documentNamespace, boolean flagIfAttributeMissing) {
        super(ruleName, desc, flagOnceType, hideResult);
        this.tags = tags;
        this.xmlFiles = fileNames;
        this.attributeName = attributeName;
        this.attributeValue = regexAttributeValue;
        if (namespace != null) {
            this.namespace = namespace;
        }
        if (attributeNamespace != null) {
            this.attributeNamespace = attributeNamespace;
        }
        this.documentNamespaceToValidate = validateNamespace;
        this.documentNamespace = documentNamespace;
        this.flagIfAttributeMissing = flagIfAttributeMissing;
        this.xmlFileType = xmlFileType;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        if (this.xmlFiles == null) {
            return new String[0];
        }
        return this.xmlFiles;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        if (detectOnce && !this.detailResults.isEmpty()) {
            return;
        }
        Set<String> keys = store.getDocumentKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                boolean includeResults;
                List<Node> results;
                XMLResource resource = store.getDocument(key);
                Document doc = resource.getDocument();
                boolean validFile = true;
                validFile = XMLRuleUtil.validateXMLFile(doc, this.xmlFileType);
                if (!validFile || !this.shouldFlag(key)) continue;
                if (this.attributeName != null) {
                    List<DetailResult> ruleResults;
                    String docNamespace;
                    if (!this.flagIfAttributeMissing) {
                        results = XMLRuleUtil.getTagDeclarationsByAttributeValue(doc, key, this.xmlFiles, this.namespace, this.tags, this.attributeNamespace, this.attributeName, this.attributeValue);
                        if (results.isEmpty() || !(includeResults = this.documentNamespaceValidates(doc, this.documentNamespace, this.documentNamespaceToValidate))) continue;
                        docNamespace = this.getDocumentNamespaceIfNeeded(doc, this.documentNamespace, this.documentNamespaceToValidate);
                        ruleResults = this.flagMatches(results, resource, key, docNamespace, detectOnce);
                        this.detailResults.addAll(ruleResults);
                        continue;
                    }
                    results = XMLRuleUtil.getTagDeclarations(doc, key, this.xmlFiles, this.namespace, this.tags);
                    if (results.isEmpty() || !(includeResults = this.documentNamespaceValidates(doc, this.documentNamespace, this.documentNamespaceToValidate))) continue;
                    docNamespace = this.getDocumentNamespaceIfNeeded(doc, this.documentNamespace, this.documentNamespaceToValidate);
                    ruleResults = this.flagMatches(results, resource, key, docNamespace, detectOnce);
                    this.detailResults.addAll(ruleResults);
                    continue;
                }
                results = XMLRuleUtil.getTagDeclarations(doc, key, this.xmlFiles, this.namespace, this.tags);
                if (results.isEmpty() || !(includeResults = this.documentNamespaceValidates(doc, this.documentNamespace, this.documentNamespaceToValidate))) continue;
                List<DetailResult> ruleResults = this.flagMatches(results, resource, key, "", detectOnce);
                this.detailResults.addAll(ruleResults);
            }
        }
    }

    protected String getDocumentRootNamespace(Document doc) {
        Element docElement = doc.getDocumentElement();
        String docNamespace = docElement.getNamespaceURI();
        return docNamespace;
    }

    private boolean documentNamespaceValidates(Document doc, String documentNamespace, String documentNamespaceToValidate) {
        boolean includeResults = true;
        String docNamespace = null;
        if (documentNamespaceToValidate != null) {
            docNamespace = this.getDocumentRootNamespace(doc);
            if (docNamespace != null && docNamespace.matches(documentNamespaceToValidate)) {
                includeResults = false;
            }
        } else if (!(documentNamespace == null || (docNamespace = this.getDocumentRootNamespace(doc)) != null && docNamespace.matches(documentNamespace))) {
            includeResults = false;
        }
        return includeResults;
    }

    private String getDocumentNamespaceIfNeeded(Document doc, String documentNamespace, String documentNamespaceToValidate) {
        return documentNamespace != null || documentNamespaceToValidate != null ? this.getDocumentRootNamespace(doc) : null;
    }

    private List<DetailResult> flagMatches(List<Node> results, XMLResource resource, String key, String docNamespace, boolean detectOnce) {
        ArrayList<DetailResult> ruleResults = new ArrayList<DetailResult>();
        for (Node node : results) {
            String matchCriteria = this.getMatchCriteria(docNamespace, node);
            if (this.includeInResults(key, node)) {
                if (node instanceof Element && this.flag(key) && this.flagIfAttributeMissing) {
                    Node attribute = node.getAttributes().getNamedItemNS(this.attributeNamespace.equals("*") ? null : this.attributeNamespace, this.attributeName);
                    if (attribute == null) {
                        ruleResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, matchCriteria, 1, null, resource.getNodeLineNumber(node)));
                    }
                } else if (node instanceof Element && this.flag(key)) {
                    ruleResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, matchCriteria, 1, null, resource.getNodeLineNumber(node)));
                } else if (node instanceof Attr && this.flag(key)) {
                    ruleResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, matchCriteria, 1, null, resource.getNodeLineNumber(node)));
                }
            }
            if (!detectOnce && !this.flagOnce) continue;
            return ruleResults;
        }
        return ruleResults;
    }

    private String getMatchCriteria(String docNamespace, Node node) {
        String matchCriteria = "";
        if (node instanceof Element) {
            matchCriteria = node.getLocalName();
            if (this.flagIfAttributeMissing) {
                matchCriteria = String.valueOf(matchCriteria) + "." + this.attributeName + "=null" + (docNamespace != null ? ": namespace=" + docNamespace : "");
            }
        } else if (node instanceof Attr) {
            String attrValue = this.attributeValue != null ? "=" + this.attributeValue : "";
            String value = node.getNodeValue();
            if (value != null) {
                attrValue = "=" + value;
            }
            matchCriteria = String.valueOf(((Attr)node).getOwnerElement().getLocalName()) + "." + node.getLocalName() + attrValue + (docNamespace != null ? ": namespace=" + docNamespace : "");
        }
        return matchCriteria;
    }

    protected boolean includeInResults(String fileName, Node node) {
        return true;
    }
}

