/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.reader;

import com.ibm.ws.report.analyze.IdentifierObject;
import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.ReportInputData;
import com.ibm.ws.report.binary.asm.ClassLink;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.recorder.ContainerState;
import com.ibm.ws.report.binary.rules.DetectFeature;
import com.ibm.ws.report.binary.rules.DetectMethod;
import com.ibm.ws.report.binary.rules.DetectMultipleCriteria;
import com.ibm.ws.report.binary.rules.Rule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.rules.custom.inventory.JavaEEImplementationsAlreadyProvided;
import com.ibm.ws.report.binary.rules.custom.inventory.WebSphereImplementation;
import com.ibm.ws.report.binary.utilities.Constants;
import com.ibm.ws.report.binary.utilities.JSPResource;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.inventory.Archive;
import com.ibm.ws.report.reader.AbstractReportReader;
import com.ibm.ws.report.technology.AbstractTechnology;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.technology.TechSummary;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;

public class BinaryReportReader
implements AbstractReportReader {
    private static boolean DEBUG = false;
    private boolean PRINT_STATUS = true;
    private static List<Pattern> _packagesToExcludeForInventory = new ArrayList<Pattern>();
    private ContainerState container = null;
    private boolean _collectReferencedPackages = false;
    private boolean _collectReferencedClasses = false;
    private boolean _skipXmlOptimization = false;
    private boolean _cacheGetterAndSetterMethods = false;
    public Map<ReportInputData.ReportType, Collection<Rule>> _rulesToLookForByReportType = new HashMap<ReportInputData.ReportType, Collection<Rule>>();
    private final Map<String, List<String>> _projectsToRulesFound = new HashMap<String, List<String>>();
    private final Set<String> _rulesFlagged = new HashSet<String>();
    private final Set<String> _configRulesFlagged = new HashSet<String>();
    private Map<String, List<DetailResult>> _projectsToDetailResults = new HashMap<String, List<DetailResult>>();
    private final Map<ReportInputData.ReportType, Map<String, List<DetailResult>>> _reportTypeToDetailResults = new HashMap<ReportInputData.ReportType, Map<String, List<DetailResult>>>();
    private List<AbstractTechnology> _techs = new ArrayList<AbstractTechnology>();
    List<Rule> _configRules = new ArrayList<Rule>();
    private ReportInputData _data = null;
    private final List<String> _projectNames = new ArrayList<String>();
    public Map<String, Rule> _rules = new HashMap<String, Rule>();
    public List<Rule> _nonTechRules = new ArrayList<Rule>();
    public Map<String, Set<String>> _descriptionsForNonTechRulesFlagged = new HashMap<String, Set<String>>();
    private List<String> _sharedLibraryArchiveNames = new ArrayList<String>();
    private final Set<String> _annotations = new HashSet<String>();
    private final Set<String> _classNames = new HashSet<String>();
    private final Set<String> _methodNames = new HashSet<String>();
    private final Set<String> _methodNamesRequireStackDetails = new HashSet<String>();
    private final Set<String> _constructorOwners = new HashSet<String>();
    private final Set<String> _enums = new HashSet<String>();
    private final Set<String> _xmlFilePatterns = new HashSet<String>();
    private String[] _filePatternsForXml = null;
    private Pattern _includePackagesRegex = null;
    private Pattern _excludePackagesRegex = null;
    private boolean _checkIncludePackages = false;
    private boolean _checkExcludePackages = false;
    private boolean _checkDefaultExcludePackages = false;
    private Pattern _excludePackagesDefaultRegex = null;
    private boolean _checkSharedLibraries = false;
    private boolean _nonInventoryRuleSetsProvided = false;
    private Map<String, Map<String, IdentifierObject>> possibleIdentifierNames = null;
    private final Map<String, String> filesToChecksum = new HashMap<String, String>();
    private Set<String> appsUsingSessions = null;
    private final Map<String, Set<String>> foundIdentifierNames = new HashMap<String, Set<String>>();
    private final Stack<MessageDigest> mdStack = new Stack();
    private SimpleDataStore _store = null;
    private final long MAX_XML_FILE_SIZE_MEGA_BYTES = 10L;
    private final long BYTES_MEGABYTE_FACTOR = 0x100000L;
    private final long MAX_XML_FILE_SIZE_BYTES = 0xA00000L;
    private final String SHA = "SHA-256";
    private int _ptr = 0;

    static {
        _packagesToExcludeForInventory.addAll(WebSphereImplementation.getWSPackages());
        _packagesToExcludeForInventory.addAll(JavaEEImplementationsAlreadyProvided.getJavaEESEPackages());
    }

    private void filterConfigRulesFlaggedForGenerateConfig(List<Rule> configRules, Set<String> configRulesFlagged, ContainerState container) {
        configRulesFlagged.addAll(container.getRulesFired(ReportInputData.ReportType.GENERATE_CONFIG));
        HashSet<String> ruleNames = new HashSet<String>();
        for (Rule rule : configRules) {
            ruleNames.add(rule.getRuleName());
        }
        HashSet<String> configRulesMatched = new HashSet<String>();
        HashSet<String> analysisRules = new HashSet<String>();
        for (String ruleName : configRulesFlagged) {
            if (ruleNames.contains(ruleName)) {
                configRulesMatched.add(ruleName);
                continue;
            }
            analysisRules.add(ruleName);
        }
        configRulesFlagged.clear();
        configRulesFlagged.addAll(configRulesMatched);
    }

    public BinaryReportReader(Set<String> projectNames, List<File> projectFiles, Set<Rule> rules) {
        ReportUtility.initiateLogger(false, false);
        ReportUtility.logger.get().setLevel(Level.OFF);
        this._rulesToLookForByReportType.put(ReportInputData.ReportType.ANALYZE, rules);
        this._nonInventoryRuleSetsProvided = true;
        ArrayList<String> listOfProjectNames = new ArrayList<String>();
        listOfProjectNames.addAll(projectNames);
        this._data = new ReportInputData(projectFiles, listOfProjectNames, ReportInputData.ReportType.ANALYZE);
        this.PRINT_STATUS = false;
    }

    public BinaryReportReader(ReportInputData data, Map<ReportInputData.ReportType, Collection<Rule>> rules) {
        this(data, rules, (List<Rule>)null, (Map<String, Map<String, IdentifierObject>>)null, (Set<String>)null);
    }

    public BinaryReportReader(ReportInputData data, Map<ReportInputData.ReportType, Collection<Rule>> rules, List<Rule> configRules, Map<String, Map<String, IdentifierObject>> possibleIdentifierNames) {
        this(data, rules, configRules, possibleIdentifierNames, null);
    }

    public BinaryReportReader(ReportInputData data, Map<ReportInputData.ReportType, Collection<Rule>> rules, List<Rule> configRules, Map<String, Map<String, IdentifierObject>> possibleIdentifierNames, Set<String> appsUsingSessions) {
        this(data, rules, configRules, possibleIdentifierNames, appsUsingSessions, true);
    }

    public BinaryReportReader(ReportInputData data, Map<ReportInputData.ReportType, Collection<Rule>> rules, List<Rule> configRules, Map<String, Map<String, IdentifierObject>> possibleIdentifierNames, Set<String> appsUsingSessions, boolean printStatus) {
        this.PRINT_STATUS = printStatus;
        this.appsUsingSessions = appsUsingSessions;
        this.possibleIdentifierNames = possibleIdentifierNames;
        this._configRules = configRules;
        this._rulesToLookForByReportType = rules;
        Set<ReportInputData.ReportType> keys = rules.keySet();
        if (keys.size() > 1 || !keys.contains((Object)ReportInputData.ReportType.INVENTORY)) {
            this._nonInventoryRuleSetsProvided = true;
        }
        this._data = data;
        this._sharedLibraryArchiveNames = new ArrayList<String>();
        for (File file : data.getSharedLibraryFiles()) {
            this._sharedLibraryArchiveNames.add(this.getFileName(file));
        }
        this.handleIncludeExcludePackages();
    }

    public BinaryReportReader(ReportInputData data, Map<String, Rule> rules, List<AbstractTechnology> techs, List<Rule> nonTechRules) {
        this._techs = techs;
        this._rules = rules;
        this._nonInventoryRuleSetsProvided = true;
        this._data = data;
        this._nonTechRules = nonTechRules;
        this.handleIncludeExcludePackages();
    }

    public BinaryReportReader(ReportInputData data, Map<String, Rule> rules, List<AbstractTechnology> techs, List<Rule> nonTechRules, Map<ReportInputData.ReportType, Collection<Rule>> allOtherRules) {
        this(data, rules, techs, nonTechRules, allOtherRules, null, null, null);
    }

    public BinaryReportReader(ReportInputData data, Map<String, Rule> rules, List<AbstractTechnology> techs, List<Rule> nonTechRules, Map<ReportInputData.ReportType, Collection<Rule>> allOtherRules, List<Rule> configRules, Map<String, Map<String, IdentifierObject>> possibleIdentifierNames, Set<String> appsUsingSessions) {
        this.appsUsingSessions = appsUsingSessions;
        this.possibleIdentifierNames = possibleIdentifierNames;
        this._rulesToLookForByReportType = allOtherRules;
        this._configRules = configRules;
        this._nonInventoryRuleSetsProvided = true;
        this._techs = techs;
        this._rules = rules;
        this._data = data;
        this._nonTechRules = nonTechRules;
        this._sharedLibraryArchiveNames = new ArrayList<String>();
        for (File file : data.getSharedLibraryFiles()) {
            this._sharedLibraryArchiveNames.add(this.getFileName(file));
        }
        this.handleIncludeExcludePackages();
    }

    private void handleIncludeExcludePackages() {
        String defaultPackages;
        String excludePackageReg = this._data.getExcludePackages();
        String includePackageReg = this._data.getIncludePackages();
        this._checkExcludePackages = excludePackageReg != null && excludePackageReg.length() > 0;
        boolean bl = this._checkIncludePackages = includePackageReg != null && includePackageReg.length() > 0;
        if (this._checkExcludePackages) {
            this._excludePackagesRegex = Pattern.compile(excludePackageReg);
        }
        if (this._checkIncludePackages) {
            this._includePackagesRegex = Pattern.compile(includePackageReg);
        }
        if (!this._checkIncludePackages && !this._checkExcludePackages && (defaultPackages = this._data.getDefaultExcludePackagesRegex()) != null && (this._data.isEvaluationReport() || this._data.isAnalysisReport() || this._data.isGenerateConfigReport())) {
            this._excludePackagesDefaultRegex = Pattern.compile(defaultPackages);
            this._checkDefaultExcludePackages = true;
            ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_Default_Exclude_Packages"), this._data.getDefaultExcludePackages()));
        }
        ReportUtility.loadExcludeIncludeDetails(this._checkDefaultExcludePackages, this._excludePackagesDefaultRegex, this._checkExcludePackages, this._excludePackagesRegex, this._checkIncludePackages, this._includePackagesRegex);
    }

    private void initializeClassData() {
        ReportInputData.AppServer source = this._data.getSourceAppServer();
        if (this._data.isAnalysisReport() && source != null) {
            if (source.isCompetitiveAppServer()) {
                this._cacheGetterAndSetterMethods = true;
            } else if (source == ReportInputData.AppServer.WAS70 || source == ReportInputData.AppServer.WAS61) {
                this._skipXmlOptimization = true;
            }
        }
        if (this._data.isInventoryReport()) {
            this._skipXmlOptimization = true;
            this._checkSharedLibraries = this._data.hasSharedLibraries();
            this._collectReferencedClasses = true;
        }
        if (this._data.isGenerateConfigReport()) {
            this._collectReferencedPackages = true;
            this._checkSharedLibraries = this._data.hasSharedLibraries();
            for (Rule nextRule : ReportUtility.nullGuard(this._configRules)) {
                this.processRule(nextRule);
            }
        }
        for (Collection<Rule> rulesForReportType : this._rulesToLookForByReportType.values()) {
            for (Rule thisRule : rulesForReportType) {
                if (thisRule instanceof DetectMultipleCriteria) {
                    DetectMultipleCriteria rule = (DetectMultipleCriteria)thisRule;
                    List<Rule> rules = rule.getRules();
                    for (Rule nextRule : rules) {
                        this.processRule(nextRule);
                    }
                    continue;
                }
                this.processRule(thisRule);
            }
        }
        if (!this._skipXmlOptimization) {
            this._filePatternsForXml = new String[this._xmlFilePatterns.size()];
            this._filePatternsForXml = this._xmlFilePatterns.toArray(this._filePatternsForXml);
        }
    }

    private void processRule(Rule thisRule) {
        String name2;
        EnumSet<RuleType> types = thisRule.getRuleTypes();
        if (types.contains((Object)RuleType.JavaRule)) {
            String[] annotations;
            String[] classNames;
            String[] stringArray = classNames = thisRule.getClassNames();
            int n = classNames.length;
            int n2 = 0;
            while (n2 < n) {
                name2 = stringArray[n2];
                this._classNames.add(name2);
                ++n2;
            }
            String[] stringArray2 = annotations = thisRule.getAnnotations();
            int n3 = annotations.length;
            n = 0;
            while (n < n3) {
                String name3 = stringArray2[n];
                this._annotations.add(name3);
                ++n;
            }
            String name4 = thisRule.getEnum();
            if (name4 != null) {
                this._enums.add(name4);
            }
            if (thisRule instanceof DetectMethod) {
                this.addMethodsNames((DetectMethod)thisRule);
            } else if (thisRule instanceof DetectFeature) {
                DetectFeature featureRule = (DetectFeature)thisRule;
                Map<String, List<Rule>> usageRules = featureRule.getUsageRules();
                if (usageRules != null) {
                    for (List<Rule> rules : usageRules.values()) {
                        for (Rule rule : rules) {
                            if (!(rule instanceof DetectMethod)) continue;
                            this.addMethodsNames((DetectMethod)rule);
                        }
                    }
                }
            } else {
                String[] methodNames;
                String[] stringArray3 = methodNames = thisRule.getMethodNames();
                int n4 = methodNames.length;
                int n5 = 0;
                while (n5 < n4) {
                    String methodName = stringArray3[n5];
                    this._methodNames.add(methodName);
                    ++n5;
                }
            }
        }
        if (!this._skipXmlOptimization && types.contains((Object)RuleType.XmlRule)) {
            String[] filePatterns;
            String[] stringArray = filePatterns = thisRule.getFileNames();
            int n = filePatterns.length;
            int n6 = 0;
            while (n6 < n) {
                name2 = stringArray[n6];
                this._xmlFilePatterns.add(name2);
                ++n6;
            }
        }
    }

    private void addMethodsNames(DetectMethod dm) {
        boolean requireStackDetails = dm.requireStackDetails();
        String[] methodNames = dm.getMethodNames();
        int size = methodNames.length;
        int i = 0;
        while (i < size) {
            this._methodNames.add(methodNames[i]);
            if (requireStackDetails) {
                this._methodNamesRequireStackDetails.add(methodNames[i]);
            }
            if (methodNames[i].equals("<init>")) {
                String[] owners = dm.getOwners();
                if (dm.getMapKeysAndValuesOneToOne() && i < owners.length) {
                    this._constructorOwners.add(owners[i]);
                } else {
                    String[] stringArray = owners;
                    int n = owners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String owner = stringArray[n2];
                        this._constructorOwners.add(owner);
                        ++n2;
                    }
                }
            }
            ++i;
        }
    }

    public Map<String, List<String>> getProjectsToRulesFound() {
        return this._projectsToRulesFound;
    }

    public Map<String, String> getChecksumMap() {
        return this.filesToChecksum;
    }

    public Map<String, List<DetailResult>> getProjectsToDetailResults(ReportInputData.ReportType type) {
        return this._reportTypeToDetailResults.get((Object)type);
    }

    public void printStatusMessage(String message) {
        if (this.PRINT_STATUS && (!ReportUtility.isTAScan() || ReportUtility.getNoProgressIndicator())) {
            System.out.print(message);
        }
    }

    public void printBlankLine() {
        if (this.PRINT_STATUS && !ReportUtility.isTAScan() && !ReportUtility.getNoProgressIndicator()) {
            System.out.println();
        }
    }

    public void printlnErrorMessage(String message) {
        ReportUtility.logger.get().log(Level.SEVERE, message);
    }

    public void printlnDebugMessage(String message) {
        ReportUtility.logger.get().log(Level.FINE, message);
    }

    public void printlnMessage(Level level, String message, String debugMessage, Exception e, String ... messageReplacementVars) {
        if (ReportUtility.shouldExceptionsBeLogged()) {
            if (messageReplacementVars != null) {
                ReportUtility.logger.get().log(level, Messages.getFormattedMessage(Messages.getString(debugMessage), messageReplacementVars), e);
            } else {
                ReportUtility.logger.get().log(level, Messages.getString(debugMessage), e);
            }
        } else if (messageReplacementVars != null) {
            int size = messageReplacementVars.length;
            Object[] variables = Arrays.copyOf(messageReplacementVars, size + 1);
            variables[size] = e.toString();
            ReportUtility.logger.get().log(level, Messages.getFormattedMessage(Messages.getString(message), variables));
        } else {
            ReportUtility.logger.get().log(level, Messages.getFormattedMessage(Messages.getString(message), e.toString()));
        }
    }

    public void printlnErrorMessage(String message, String debugMessage, Exception e, String ... messageReplacementVars) {
        this.printlnMessage(Level.SEVERE, message, debugMessage, e, messageReplacementVars);
    }

    public void printlnWarningMessage(String message, String debugMessage, Exception e, String ... messageReplacementVars) {
        this.printlnMessage(Level.WARNING, message, debugMessage, e, messageReplacementVars);
    }

    @Override
    public void openFile() {
        this.printStatusMessage(Messages.getString("BinaryReportReader_Scanning_Files"));
        this._descriptionsForNonTechRulesFlagged.clear();
        this._rulesFlagged.clear();
        this._ptr = 0;
        if (this._data.isEvaluationReport()) {
            HashSet<Rule> evaluateRules = new HashSet<Rule>();
            for (AbstractTechnology tech : this._techs) {
                String[] rulesToTrigger = tech.getRulesToTrigger();
                if (rulesToTrigger == null) continue;
                String[] stringArray = rulesToTrigger;
                int n = rulesToTrigger.length;
                int n2 = 0;
                while (n2 < n) {
                    String rule = stringArray[n2];
                    Rule nextRule = this._rules.get(rule);
                    if (nextRule != null) {
                        evaluateRules.add(nextRule);
                        ReportUtility.logger.get().log(Level.FINE, "Adding rule for tech: " + tech.getId() + " to rulesToLookFor with ruleName: " + nextRule.getRuleName() + " and desc: " + nextRule.getRuleDescription());
                    }
                    ++n2;
                }
            }
            evaluateRules.addAll(this._nonTechRules);
            this._rulesToLookForByReportType.put(ReportInputData.ReportType.EVALUATE, evaluateRules);
        }
        this.initializeClassData();
        try {
            this._store = new SimpleDataStore();
            this._store.setPossibleIdentifierNames(this.possibleIdentifierNames);
            this._store.setAppsUsingSessions(this.appsUsingSessions);
            this._store.setChecksums(this.filesToChecksum);
            HashMap<String, Set<String>> possibleFoundIdentifierNamesStringValues = new HashMap<String, Set<String>>();
            if (this.possibleIdentifierNames != null) {
                for (String appName : this.possibleIdentifierNames.keySet()) {
                    this.foundIdentifierNames.put(appName, new HashSet());
                    possibleFoundIdentifierNamesStringValues.put(appName, this.possibleIdentifierNames.get(appName).keySet());
                }
            }
            this._store.setFoundIdentifierNames(this._data.getMigrateAllConfig() ? possibleFoundIdentifierNamesStringValues : this.foundIdentifierNames);
            this._store.setHiddenJunitFlag(this._data.isJunit());
            if (this._data.isInventoryReport()) {
                this._store.addSharedLibraries(this._data.getSharedLibraryFiles());
            }
            List<String> projectNames = this._data.getProjectNames();
            List<File> projectFiles = this._data.getProjectFiles();
            this._store.addProjectFiles(projectFiles);
            if (projectNames.size() == 1 && projectFiles.size() > 1 || this._checkSharedLibraries) {
                Iterator<String> it = projectNames.iterator();
                this._projectNames.add(ReportUtility.filterUppercaseFileExtension(it.next()));
                this.container = new ContainerState(this._projectNames.get(0), this._rulesToLookForByReportType, this._configRules);
                for (File thisBinaryFile : projectFiles) {
                    String thisBinaryFilePath = thisBinaryFile.getAbsolutePath().replace("\\", "/");
                    this._store.setRootAppPath(thisBinaryFilePath);
                    if (!projectNames.contains(thisBinaryFilePath)) {
                        this._store.setCurrentAppBeingProcessed("sharedLibraries");
                    } else {
                        this._store.setCurrentAppBeingProcessed(ReportUtility.getFileName(thisBinaryFilePath));
                    }
                    try {
                        this.processBinaryFile(thisBinaryFile, this._store);
                    }
                    catch (Exception e) {
                        this.printBlankLine();
                        ReportUtility.addFileWithParsingError(this._projectNames.get(0), e);
                    }
                }
                if (!this._nonInventoryRuleSetsProvided && this._checkSharedLibraries) {
                    this._store.setCurrentAppBeingProcessed("sharedLibraries");
                    for (File sharedLib : this._data.getSharedLibraryFiles()) {
                        try {
                            this.processBinaryFile(sharedLib, this._store);
                        }
                        catch (Exception e) {
                            this.printBlankLine();
                            ReportUtility.addFileWithParsingError(this._projectNames.get(0), e);
                        }
                    }
                }
                if (this._nonInventoryRuleSetsProvided && this._checkSharedLibraries) {
                    this.container.analyzeDetailResults(this._store, RuleType.FileRule, ReportInputData.ReportType.getNonInventoryReportTypes());
                    if (this._data.isEvaluationReport()) {
                        this.handleUpdatesForEvaluate();
                    }
                    EnumSet<ReportInputData.ReportType> nonEvaluateNonInventory = EnumSet.of(ReportInputData.ReportType.ANALYZE, ReportInputData.ReportType.GENERATE_CONFIG);
                    this.container.updateDetailResults(this._store, nonEvaluateNonInventory);
                    Set<ReportInputData.ReportType> inventoryReportTypes = ReportInputData.ReportType.getInventoryReportTypes();
                    this.container.setActiveReportTypes(inventoryReportTypes);
                    this._store.setCurrentAppBeingProcessed("sharedLibraries");
                    for (File sharedLib : this._data.getSharedLibraryFiles()) {
                        try {
                            this.processBinaryFile(sharedLib, this._store);
                        }
                        catch (Exception e) {
                            this.printBlankLine();
                            ReportUtility.addFileWithParsingError(this._projectNames.get(0), e);
                        }
                    }
                    this.container.analyzeDetailResults(this._store, RuleType.FileRule, inventoryReportTypes);
                    this.container.updateDetailResults(this._store, inventoryReportTypes);
                } else {
                    this.container.analyzeDetailResults(this._store, RuleType.FileRule);
                    if (this._data.isEvaluationReport()) {
                        this.handleUpdatesForEvaluate();
                    }
                    this.container.updateDetailResults(this._store, ReportInputData.ReportType.getNonEvaluateReportTypes());
                }
                this._store.clear();
                if (this._data.isAnalysisReport()) {
                    this._rulesFlagged.addAll(this.container.getRulesFired(ReportInputData.ReportType.ANALYZE));
                }
                if (this._data.isEvaluationReport()) {
                    this._projectsToRulesFound.put(this.container.getContainerName(), this.container.getRulesFired(ReportInputData.ReportType.EVALUATE));
                }
                if (this._data.isGenerateConfigReport() && this._configRules != null && !this._configRules.isEmpty()) {
                    this._configRulesFlagged.addAll(this.container.getRulesFired(ReportInputData.ReportType.GENERATE_CONFIG));
                    this.filterConfigRulesFlaggedForGenerateConfig(this._configRules, this._configRulesFlagged, this.container);
                }
                for (ReportInputData.ReportType reportType : this._rulesToLookForByReportType.keySet()) {
                    if (reportType == ReportInputData.ReportType.EVALUATE) continue;
                    if (this._reportTypeToDetailResults.containsKey((Object)reportType)) {
                        this._reportTypeToDetailResults.get((Object)reportType).put(this.container.getContainerName(), this.container.getDetailResults(reportType));
                        continue;
                    }
                    this._projectsToDetailResults = new HashMap<String, List<DetailResult>>();
                    this._projectsToDetailResults.put(this.container.getContainerName(), this.container.getDetailResults(reportType));
                    this._reportTypeToDetailResults.put(reportType, this._projectsToDetailResults);
                }
            } else {
                InputStream appInputStream = this._data.getProjectInputStream();
                if (appInputStream != null) {
                    String projectName = this._data.getProjectNames().get(0);
                    this.addFileNameProcessed(this._data.getProjectNames().get(0), this._store);
                    this._store.setRootAppPath(projectName);
                    this._store.setCurrentAppBeingProcessed(ReportUtility.getFileName(projectName));
                    this.processBinary(null, appInputStream, this._data.getProjectInputStreamType(), projectName);
                } else {
                    for (File thisBinaryFile : projectFiles) {
                        String thisBinaryFilePath = this.getFileName(thisBinaryFile);
                        this._store.setRootAppPath(thisBinaryFilePath);
                        String projectName = ReportUtility.filterUppercaseFileExtension(thisBinaryFilePath);
                        this._store.setCurrentAppBeingProcessed(ReportUtility.getFileName(projectName));
                        this.processBinary(thisBinaryFile, null, null, projectName);
                    }
                }
            }
            this.printBlankLine();
        }
        catch (Exception e) {
            this.printBlankLine();
            this.printlnErrorMessage("BinaryReportReader_Error_Scanning_Projects", "BinaryReportReader_Error_Scanning_Projects_Log", e, null);
        }
    }

    public Set<String> getFoundIdentifierNames(String appName) {
        return this._store.getFoundIdentifierNames(appName);
    }

    private void processBinary(File appFile, InputStream appIS, BinaryType type, String projectName) throws Exception {
        this._projectNames.add(ReportUtility.filterUppercaseFileExtension(projectName));
        this.container = new ContainerState(projectName, this._rulesToLookForByReportType, this._configRules);
        try {
            if (appFile != null) {
                this.processBinaryFile(appFile, this._store);
            } else if (type == BinaryType.WAR) {
                this.processWarFile(appIS, this._store, ReportUtility.getLastArchiveFileName(projectName), projectName);
            } else if (type == BinaryType.EAR) {
                this.processEarFile(appIS, this._store, ReportUtility.getLastArchiveFileName(projectName), projectName);
            }
        }
        catch (Exception e) {
            this.printBlankLine();
            ReportUtility.addFileWithParsingError(projectName, e);
        }
        this.container.analyzeDetailResults(this._store, RuleType.FileRule);
        if (this._data.isEvaluationReport()) {
            this.handleUpdatesForEvaluate();
        }
        this.container.updateDetailResults(this._store, ReportInputData.ReportType.getNonEvaluateReportTypes());
        if (!this._data.isGenerateConfigReport()) {
            this._store.clear();
        } else {
            this._store.clearType(RuleType.FileRule);
        }
        if (this._data.isAnalysisReport()) {
            this._rulesFlagged.addAll(this.container.getRulesFired(ReportInputData.ReportType.ANALYZE));
        }
        if (this._data.isEvaluationReport()) {
            this._projectsToRulesFound.put(this.container.getContainerName(), this.container.getRulesFired(ReportInputData.ReportType.EVALUATE));
        }
        if (this._data.isGenerateConfigReport() && this._configRules != null && !this._configRules.isEmpty()) {
            this._configRulesFlagged.addAll(this.container.getRulesFired(ReportInputData.ReportType.GENERATE_CONFIG));
            this.filterConfigRulesFlaggedForGenerateConfig(this._configRules, this._configRulesFlagged, this.container);
        }
        for (ReportInputData.ReportType reportType : this._rulesToLookForByReportType.keySet()) {
            if (reportType == ReportInputData.ReportType.EVALUATE) continue;
            if (this._reportTypeToDetailResults.containsKey((Object)reportType)) {
                this._reportTypeToDetailResults.get((Object)reportType).put(this.container.getContainerName(), this.container.getDetailResults(reportType));
                continue;
            }
            this._projectsToDetailResults = new HashMap<String, List<DetailResult>>();
            this._projectsToDetailResults.put(this.container.getContainerName(), this.container.getDetailResults(reportType));
            this._reportTypeToDetailResults.put(reportType, this._projectsToDetailResults);
        }
    }

    public void handleUpdatesForEvaluate() {
        this.container.updateRulesFired(this._store, ReportInputData.ReportType.EVALUATE);
        for (Rule nextRule : this._nonTechRules) {
            if (!this.container.wasRuleFired(nextRule, ReportInputData.ReportType.EVALUATE)) continue;
            String appName = this.container.getContainerName().replaceFirst(".*/", "");
            Set<Object> descriptions = null;
            if (this._descriptionsForNonTechRulesFlagged.containsKey(appName)) {
                descriptions = this._descriptionsForNonTechRulesFlagged.get(appName);
            } else {
                descriptions = new HashSet();
                this._descriptionsForNonTechRulesFlagged.put(appName, descriptions);
            }
            descriptions.add(nextRule.getRuleDescription());
        }
    }

    public Set<String> getRulesFlagged() {
        return this._rulesFlagged;
    }

    public Set<String> getConfigRulesFlagged() {
        return this._configRulesFlagged;
    }

    protected void processBinaryFile(File thisBinaryFile, SimpleDataStore store) throws IOException {
        String name2 = thisBinaryFile.getName().toLowerCase();
        if (thisBinaryFile.length() == 0L) {
            this.addFileNameProcessed(thisBinaryFile, store);
            this.printlnDebugMessage(Messages.getFormattedMessage(Messages.getString("BinaryReportReader_Error_Processing_Empty_File"), name2));
            return;
        }
        String path = this.getFileName(thisBinaryFile);
        if (path != null && path.contains("__MACOSX")) {
            this.printlnDebugMessage("Skipping " + path + " file since it contains __MACOSX in the path");
            return;
        }
        BinaryType bt = BinaryType.getBinaryType(name2);
        switch (bt) {
            case EAR: 
            case JAR: 
            case RAR: 
            case WAR: {
                this.processJarFile(thisBinaryFile, store);
                break;
            }
            case ZIP: {
                this.processZipFile(thisBinaryFile, store);
                break;
            }
            case EBA: {
                this.processEbaFile(thisBinaryFile, store);
                break;
            }
            case CBA: {
                this.processCbaFile(thisBinaryFile, store);
                break;
            }
            case CLASS: {
                this.processClassFile(thisBinaryFile, store);
                break;
            }
            case XML: {
                this.processXmlFile(thisBinaryFile, store);
                break;
            }
            case JSP: {
                this.processJspFile(thisBinaryFile, store);
                break;
            }
            case PROPERTIES: {
                this.processPropertyFile(thisBinaryFile, store);
                break;
            }
            case COMPOSITEMF: 
            case MANIFESTMF: 
            case MF: {
                this.processManifestFile(thisBinaryFile, store);
                break;
            }
            case UNKNOWN: {
                this.addFileNameProcessed(thisBinaryFile, store);
            }
        }
    }

    private void digestTopChecksumOfStack(String fileName) {
        fileName = fileName.replace("\\", "/");
        byte[] bytes = this.mdStack.peek().digest();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        this.filesToChecksum.put(fileName, sb.toString());
        this.mdStack.pop();
    }

    private void addMessageDigestToStack() {
        try {
            this.mdStack.add(MessageDigest.getInstance("SHA-256"));
        }
        catch (NoSuchAlgorithmException e) {
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("SHA_Hashing_Algorithm_Unavailable"), e.getMessage()));
        }
    }

    protected String getFileName(File fileProcessed) {
        String fileName = null;
        try {
            fileName = fileProcessed.getCanonicalPath();
        }
        catch (IOException iOException) {
            fileName = fileProcessed.getAbsolutePath();
        }
        fileName = fileName.replace("\\", "/");
        return fileName;
    }

    protected String addFileNameProcessed(File fileProcessed, SimpleDataStore store) {
        return this.addFileNameProcessed(this.getFileName(fileProcessed), store);
    }

    protected String addFileNameProcessed(ZipFile fileProcessed, SimpleDataStore store) {
        return this.addFileNameProcessed(fileProcessed.getName(), store);
    }

    protected String addFileNameProcessed(String fileName, SimpleDataStore store) {
        fileName = fileName.replace("\\", "/");
        String prefix = null;
        if (this._data.isGenerateTA()) {
            String appName = store.getCurrentAppBeingProcessed();
            int index = fileName.lastIndexOf(appName);
            if (index > 0) {
                prefix = fileName.substring(0, index - 1);
            }
        } else {
            prefix = this._data.getProjectDirPathNormalized(fileName);
        }
        fileName = this.getFileNameToProcess(prefix, fileName);
        store.addFileName(fileName);
        return fileName;
    }

    protected boolean isEmpty(ZipEntry entry, String entryName) {
        if (entry.getSize() == 0L) {
            this.printEmptyFileMessage(entryName);
            return true;
        }
        return false;
    }

    protected boolean isNull(InputStream is, String entryName) {
        if (is == null) {
            this.printEmptyFileMessage(entryName);
            return true;
        }
        return false;
    }

    protected void printEmptyFileMessage(String name2) {
        this.printlnDebugMessage(Messages.getFormattedMessage(Messages.getString("BinaryReportReader_Error_Processing_Empty_File"), name2));
    }

    protected void processJarFile(File thisBinaryFile, SimpleDataStore store) throws IOException {
        block20: {
            JarFile fileToProcess = new JarFile(thisBinaryFile.getAbsoluteFile(), false);
            String fileName = this.addFileNameProcessed(fileToProcess, store);
            if (this.shouldProcessFile(fileName)) {
                try {
                    try {
                        Manifest mf = null;
                        try {
                            mf = fileToProcess.getManifest();
                        }
                        catch (IOException e) {
                            this.printBlankLine();
                            ReportUtility.addFileWithParsingError(String.valueOf(fileName) + "/" + "META-INF/MANIFEST.MF", e);
                        }
                        try {
                            this.addMessageDigestToStack();
                            if (mf != null) {
                                ReportUtility.logger.get().log(Level.FINE, "Processing jar entry manifest: META-INF/MANIFEST.MF");
                                String entryNameWithContext = String.valueOf(fileName) + "/" + "META-INF/MANIFEST.MF";
                                this.processManifestFile(mf, entryNameWithContext, store);
                            }
                            Enumeration<JarEntry> entries = fileToProcess.entries();
                            while (entries.hasMoreElements()) {
                                JarEntry entry = entries.nextElement();
                                this.processJarEntry(fileToProcess, entry, store, fileName);
                            }
                        }
                        finally {
                            this.digestTopChecksumOfStack(thisBinaryFile.getAbsolutePath());
                        }
                    }
                    catch (Exception e) {
                        this.printBlankLine();
                        ReportUtility.addFileWithParsingError(fileName, e);
                        try {
                            fileToProcess.close();
                        }
                        catch (IOException e2) {
                            this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e2, fileName));
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        fileToProcess.close();
                    }
                    catch (IOException e) {
                        this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
                    }
                    throw throwable;
                }
                try {
                    fileToProcess.close();
                }
                catch (IOException e) {
                    this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
                }
            } else {
                ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_File_Excluded"), fileName));
            }
        }
    }

    protected void processJarEntry(JarFile fileToProcess, JarEntry entry, SimpleDataStore store, String fileName) {
        InputStream is = null;
        String entryName = entry.getName();
        ReportUtility.logger.get().log(Level.FINE, "Processing jar entry: " + entryName);
        this.printStatusMessage(".");
        String lowerEntryName = entryName.toLowerCase();
        if (!entry.isDirectory()) {
            String entryNameWithContext = String.valueOf(fileName) + "/" + entryName;
            String entryNameWithFullpath = String.valueOf(fileToProcess.getName()) + "/" + entryName;
            if (this.shouldProcessFile(entryNameWithContext)) {
                store.addFileName(entryNameWithContext);
                try {
                    BinaryType bt = BinaryType.getBinaryType(lowerEntryName);
                    if (bt.processTypeForJar() && (!this.isEmpty(entry, entryNameWithContext) || bt.equals((Object)BinaryType.XML))) {
                        is = fileToProcess.getInputStream(entry);
                        switch (bt) {
                            case CLASS: {
                                ClassDataStore cds = new ClassDataStore(entryNameWithContext, store);
                                this.processClassFile(entryNameWithFullpath, is, this.getWebInfClassName(entryName), store, cds);
                                break;
                            }
                            case XML: {
                                this.processXmlFile(entryNameWithFullpath, is, entryNameWithContext, store, entry.getSize());
                                break;
                            }
                            case JSP: {
                                this.processJspFile(entryNameWithFullpath, is, entryNameWithContext, store);
                                break;
                            }
                            case WAR: {
                                this.processWarFile(is, store, entryNameWithContext, entryNameWithFullpath);
                                break;
                            }
                            case JAR: {
                                this.processJarFile(is, store, entryNameWithContext, entryNameWithFullpath);
                                break;
                            }
                            case CBA: {
                                this.processCbaFile(is, store, entryNameWithContext, entryNameWithFullpath);
                                break;
                            }
                            case RAR: {
                                this.processRarFile(is, store, entryNameWithContext, entryNameWithFullpath);
                                break;
                            }
                            case PROPERTIES: {
                                this.processPropertyFile(entryNameWithFullpath, is, entryNameWithContext, store);
                                break;
                            }
                            case COMPOSITEMF: {
                                this.processManifestFile(entryNameWithFullpath, is, entryNameWithContext, store);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    this.printBlankLine();
                    ReportUtility.addFileWithParsingError(entryNameWithFullpath, e);
                }
            } else {
                ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_File_Excluded"), entryNameWithContext));
            }
        }
    }

    protected void processEbaFile(File thisBinaryFile, SimpleDataStore store) throws IOException {
        block12: {
            JarFile fileToProcess = new JarFile(thisBinaryFile.getAbsoluteFile(), false);
            String fileName = this.addFileNameProcessed(fileToProcess, store);
            try {
                try {
                    Enumeration<JarEntry> entries = fileToProcess.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        this.processJarEntry(fileToProcess, entry, store, fileName);
                    }
                }
                catch (Exception e) {
                    this.printBlankLine();
                    ReportUtility.addFileWithParsingError(fileName, e);
                    try {
                        fileToProcess.close();
                    }
                    catch (IOException e2) {
                        this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e2, fileName));
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    fileToProcess.close();
                }
                catch (IOException e) {
                    this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
                }
                throw throwable;
            }
            try {
                fileToProcess.close();
            }
            catch (IOException e) {
                this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
            }
        }
    }

    protected void processCbaFile(File thisBinaryFile, SimpleDataStore store) throws IOException {
        block12: {
            JarFile fileToProcess = new JarFile(thisBinaryFile.getAbsoluteFile(), false);
            String fileName = this.addFileNameProcessed(fileToProcess, store);
            try {
                try {
                    Enumeration<JarEntry> entries = fileToProcess.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        this.processJarEntry(fileToProcess, entry, store, fileName);
                    }
                }
                catch (Exception e) {
                    this.printBlankLine();
                    ReportUtility.addFileWithParsingError(fileName, e);
                    try {
                        fileToProcess.close();
                    }
                    catch (IOException e2) {
                        this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e2, fileName));
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    fileToProcess.close();
                }
                catch (IOException e) {
                    this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
                }
                throw throwable;
            }
            try {
                fileToProcess.close();
            }
            catch (IOException e) {
                this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
            }
        }
    }

    protected void processZipFile(File thisBinaryFile, SimpleDataStore store) throws IOException {
        block12: {
            ZipFile fileToProcess = new ZipFile(thisBinaryFile.getAbsoluteFile());
            String fileName = this.addFileNameProcessed(fileToProcess, store);
            try {
                try {
                    Enumeration<? extends ZipEntry> entries = fileToProcess.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        this.processZipEntry(fileToProcess, entry, store, fileName);
                    }
                }
                catch (Exception e) {
                    this.printBlankLine();
                    ReportUtility.addFileWithParsingError(fileName, e);
                    try {
                        fileToProcess.close();
                    }
                    catch (IOException e2) {
                        this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e2, fileName));
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    fileToProcess.close();
                }
                catch (IOException e) {
                    this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
                }
                throw throwable;
            }
            try {
                fileToProcess.close();
            }
            catch (IOException e) {
                this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
            }
        }
    }

    protected void processZipEntry(ZipFile fileToProcess, ZipEntry entry, SimpleDataStore store, String fileName) {
        InputStream is = null;
        String entryName = entry.getName();
        ReportUtility.logger.get().log(Level.FINE, "Processing zip entry: " + entryName);
        this.printStatusMessage(".");
        String lowerEntryName = entryName.toLowerCase();
        if (!entry.isDirectory()) {
            String entryNameWithContext = String.valueOf(fileName) + "/" + entryName;
            String entryNameWithFullpath = String.valueOf(fileToProcess.getName()) + "/" + entryName;
            store.addFileName(entryNameWithContext);
            try {
                BinaryType bt = BinaryType.getBinaryType(lowerEntryName);
                if (bt.processTypeForZip() && !this.isEmpty(entry, entryNameWithContext)) {
                    is = fileToProcess.getInputStream(entry);
                    switch (bt) {
                        case CLASS: {
                            ClassDataStore cds = new ClassDataStore(entryNameWithContext, store);
                            this.processClassFile(entryNameWithFullpath, is, this.getWebInfClassName(entryName), store, cds);
                            break;
                        }
                        case XML: {
                            this.processXmlFile(entryNameWithFullpath, is, entryNameWithContext, store, entry.getSize());
                            break;
                        }
                        case JSP: {
                            this.processJspFile(entryNameWithFullpath, is, entryNameWithContext, store);
                            break;
                        }
                        case WAR: {
                            this.processWarFile(is, store, entryNameWithContext, entryNameWithFullpath);
                            break;
                        }
                        case JAR: {
                            this.processJarFile(is, store, entryNameWithContext, entryNameWithFullpath);
                            break;
                        }
                        case EAR: {
                            this.processEarFile(is, store, entryNameWithContext, entryNameWithFullpath);
                            break;
                        }
                        case EBA: {
                            this.processEbaFile(is, store, entryNameWithContext, entryNameWithFullpath);
                            break;
                        }
                        case RAR: {
                            this.processRarFile(is, store, entryNameWithContext, entryNameWithFullpath);
                            break;
                        }
                        case PROPERTIES: {
                            this.processPropertyFile(entryNameWithFullpath, is, entryNameWithContext, store);
                            break;
                        }
                        case COMPOSITEMF: 
                        case MANIFESTMF: {
                            this.processManifestFile(entryNameWithFullpath, is, entryNameWithContext, store);
                        }
                        default: {
                            break;
                        }
                    }
                }
            }
            catch (IOException e) {
                this.printBlankLine();
                ReportUtility.addFileWithParsingError(entryNameWithFullpath, e);
            }
        }
    }

    protected void processRarFile(InputStream is, SimpleDataStore store, String fileName, String fullpath) throws IOException {
        InputStream jeis = null;
        try {
            JarInputStream jis = new JarInputStream(is, false);
            try {
                this.addMessageDigestToStack();
                Manifest mf = jis.getManifest();
                if (mf != null) {
                    ReportUtility.logger.get().log(Level.FINE, "Processing rar entry manifest: META-INF/MANIFEST.MF");
                    String entryNameWithContext = String.valueOf(fileName) + "/" + "META-INF/MANIFEST.MF";
                    this.processManifestFile(mf, entryNameWithContext, store);
                }
                JarEntry je = null;
                while ((je = jis.getNextJarEntry()) != null) {
                    block28: {
                        String entryName = je.getName();
                        ReportUtility.logger.get().log(Level.FINE, "Processing rar entry: " + entryName);
                        String lowerEntryName = entryName.toLowerCase();
                        if (!je.isDirectory()) {
                            String entryNameWithContext = String.valueOf(fileName) + "/" + entryName;
                            String entryNameWithFullpath = String.valueOf(fullpath) + "/" + entryName;
                            if (this.shouldProcessFile(entryNameWithContext)) {
                                store.addFileName(entryNameWithContext);
                                try {
                                    try {
                                        BinaryType bt = BinaryType.getBinaryType(lowerEntryName);
                                        if (bt.processTypeForRar() && !this.isNull(jeis = this.readInputStream(jis), entryNameWithContext)) {
                                            switch (bt) {
                                                case CLASS: {
                                                    ClassDataStore cds = new ClassDataStore(entryNameWithContext, store);
                                                    this.processClassFile(entryNameWithFullpath, jeis, this.getWebInfClassName(entryName), store, cds);
                                                    break;
                                                }
                                                case XML: {
                                                    this.processXmlFile(entryNameWithFullpath, jeis, entryNameWithContext, store, je.getSize());
                                                    break;
                                                }
                                                case JSP: {
                                                    this.processJspFile(entryNameWithFullpath, jeis, entryNameWithContext, store);
                                                    break;
                                                }
                                                case JAR: {
                                                    this.processJarFile(jeis, store, entryNameWithContext, entryNameWithFullpath);
                                                    break;
                                                }
                                                case PROPERTIES: {
                                                    this.processPropertyFile(entryNameWithFullpath, jeis, entryNameWithContext, store);
                                                }
                                                default: {
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                    catch (IOException e) {
                                        this.printBlankLine();
                                        ReportUtility.addFileWithParsingError(entryNameWithFullpath, e);
                                        if (jeis != null) {
                                            jeis.close();
                                            jeis = null;
                                        }
                                        break block28;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (jeis != null) {
                                        jeis.close();
                                        jeis = null;
                                    }
                                    throw throwable;
                                }
                                if (jeis != null) {
                                    jeis.close();
                                    jeis = null;
                                }
                            } else {
                                ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_File_Excluded"), entryNameWithContext));
                            }
                        }
                    }
                    jis.closeEntry();
                }
            }
            finally {
                this.digestTopChecksumOfStack(fullpath);
            }
        }
        finally {
            if (jeis != null) {
                jeis.close();
            }
        }
    }

    protected void processWarFile(InputStream is, SimpleDataStore store, String fileName, String fullpath) throws IOException {
        InputStream jeis = null;
        try {
            JarInputStream jis = new JarInputStream(is, false);
            try {
                this.addMessageDigestToStack();
                Manifest mf = jis.getManifest();
                if (mf != null) {
                    ReportUtility.logger.get().log(Level.FINE, "Processing war entry manifest: META-INF/MANIFEST.MF");
                    String entryNameWithContext = String.valueOf(this.addFileNameProcessed(fileName, store)) + "/" + "META-INF/MANIFEST.MF";
                    this.processManifestFile(mf, entryNameWithContext, store);
                }
                JarEntry je = null;
                while ((je = jis.getNextJarEntry()) != null) {
                    block28: {
                        String entryName = je.getName();
                        ReportUtility.logger.get().log(Level.FINE, "Processing war entry: " + entryName);
                        String lowerEntryName = entryName.toLowerCase();
                        if (!je.isDirectory()) {
                            String entryNameWithContext = String.valueOf(this.addFileNameProcessed(fileName, store)) + "/" + entryName;
                            String entryNameWithFullpath = String.valueOf(fullpath) + "/" + entryName;
                            if (this.shouldProcessFile(entryNameWithContext)) {
                                store.addFileName(entryNameWithContext);
                                try {
                                    try {
                                        BinaryType bt = BinaryType.getBinaryType(lowerEntryName);
                                        if (bt.processTypeForWar() && !this.isNull(jeis = this.readInputStream(jis), entryNameWithContext)) {
                                            switch (bt) {
                                                case CLASS: {
                                                    ClassDataStore cds = new ClassDataStore(entryNameWithContext, store);
                                                    this.processClassFile(entryNameWithFullpath, jeis, this.getWebInfClassName(entryName), store, cds);
                                                    break;
                                                }
                                                case XML: {
                                                    this.processXmlFile(entryNameWithFullpath, jeis, entryNameWithContext, store, je.getSize());
                                                    break;
                                                }
                                                case JSP: {
                                                    this.processJspFile(entryNameWithFullpath, jeis, entryNameWithContext, store);
                                                    break;
                                                }
                                                case JAR: {
                                                    this.processJarFile(jeis, store, entryNameWithContext, entryNameWithFullpath);
                                                    break;
                                                }
                                                case PROPERTIES: {
                                                    this.processPropertyFile(entryNameWithFullpath, jeis, entryNameWithContext, store);
                                                }
                                                default: {
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                    catch (IOException e) {
                                        this.printBlankLine();
                                        ReportUtility.addFileWithParsingError(entryNameWithFullpath, e);
                                        if (jeis != null) {
                                            jeis.close();
                                            jeis = null;
                                        }
                                        break block28;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (jeis != null) {
                                        jeis.close();
                                        jeis = null;
                                    }
                                    throw throwable;
                                }
                                if (jeis != null) {
                                    jeis.close();
                                    jeis = null;
                                }
                            } else {
                                ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_File_Excluded"), entryNameWithContext));
                            }
                        }
                    }
                    jis.closeEntry();
                }
            }
            finally {
                this.digestTopChecksumOfStack(fullpath);
            }
        }
        finally {
            if (jeis != null) {
                jeis.close();
            }
        }
    }

    protected String getWebInfClassName(String name2) {
        String className = name2;
        if (name2.startsWith("WEB-INF/classes/")) {
            className = name2.substring("WEB-INF/classes/".length());
        } else if (name2.startsWith("WEB-INF/lib/")) {
            className = name2.substring("WEB-INF/lib/".length());
        }
        return className;
    }

    protected void processEarFile(InputStream is, SimpleDataStore store, String fileName, String fullpath) throws IOException {
        InputStream jeis = null;
        try {
            JarInputStream jis = new JarInputStream(is, false);
            try {
                this.addMessageDigestToStack();
                Manifest mf = jis.getManifest();
                if (mf != null) {
                    ReportUtility.logger.get().log(Level.FINE, "Processing ear entry manifest: META-INF/MANIFEST.MF");
                    String entryNameWithContext = String.valueOf(this.addFileNameProcessed(fileName, store)) + "/" + "META-INF/MANIFEST.MF";
                    this.processManifestFile(mf, entryNameWithContext, store);
                }
                JarEntry je = null;
                while ((je = jis.getNextJarEntry()) != null) {
                    block29: {
                        String entryName = je.getName();
                        ReportUtility.logger.get().log(Level.FINE, "Processing ear entry: " + entryName);
                        String lowerEntryName = entryName.toLowerCase();
                        if (!je.isDirectory()) {
                            String entryNameWithContext = String.valueOf(this.addFileNameProcessed(fileName, store)) + "/" + entryName;
                            String entryNameWithFullpath = String.valueOf(fullpath) + "/" + entryName;
                            if (this.shouldProcessFile(entryNameWithContext)) {
                                store.addFileName(entryNameWithContext);
                                try {
                                    try {
                                        BinaryType bt = BinaryType.getBinaryType(lowerEntryName);
                                        if (bt.processTypeForEar() && !this.isNull(jeis = this.readInputStream(jis), entryNameWithContext)) {
                                            switch (bt) {
                                                case WAR: {
                                                    this.processWarFile(jeis, store, entryNameWithContext, entryNameWithFullpath);
                                                    break;
                                                }
                                                case JAR: {
                                                    this.processJarFile(jeis, store, entryNameWithContext, entryNameWithFullpath);
                                                    break;
                                                }
                                                case CLASS: {
                                                    ClassDataStore cds = new ClassDataStore(entryNameWithContext, store);
                                                    this.processClassFile(entryNameWithFullpath, jeis, this.getWebInfClassName(entryName), store, cds);
                                                    break;
                                                }
                                                case XML: {
                                                    this.processXmlFile(entryNameWithFullpath, jeis, entryNameWithContext, store, je.getSize());
                                                    break;
                                                }
                                                case JSP: {
                                                    this.processJspFile(entryNameWithFullpath, jeis, entryNameWithContext, store);
                                                    break;
                                                }
                                                case PROPERTIES: {
                                                    this.processPropertyFile(entryNameWithFullpath, jeis, entryNameWithContext, store);
                                                }
                                                default: {
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                    catch (IOException e) {
                                        this.printBlankLine();
                                        ReportUtility.addFileWithParsingError(entryNameWithFullpath, e);
                                        if (jeis != null) {
                                            jeis.close();
                                            jeis = null;
                                        }
                                        break block29;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (jeis != null) {
                                        jeis.close();
                                        jeis = null;
                                    }
                                    throw throwable;
                                }
                                if (jeis != null) {
                                    jeis.close();
                                    jeis = null;
                                }
                            } else {
                                ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_File_Excluded"), entryNameWithContext));
                            }
                        }
                    }
                    jis.closeEntry();
                }
            }
            finally {
                this.digestTopChecksumOfStack(fullpath);
            }
        }
        finally {
            if (jeis != null) {
                jeis.close();
            }
        }
    }

    protected void processEbaFile(InputStream is, SimpleDataStore store, String fileName, String fullpath) throws IOException {
        InputStream jeis = null;
        try {
            JarInputStream jis = new JarInputStream(is, false);
            JarEntry je = null;
            while ((je = jis.getNextJarEntry()) != null) {
                block23: {
                    String entryName = je.getName();
                    ReportUtility.logger.get().log(Level.FINE, "Processing eba entry: " + entryName);
                    String lowerEntryName = entryName.toLowerCase();
                    if (!je.isDirectory()) {
                        String entryNameWithContext = String.valueOf(fileName) + "/" + entryName;
                        String entryNameWithFullpath = String.valueOf(fullpath) + "/" + entryName;
                        if (this.shouldProcessFile(entryNameWithContext)) {
                            store.addFileName(entryNameWithContext);
                            try {
                                try {
                                    BinaryType bt = BinaryType.getBinaryType(lowerEntryName);
                                    if (bt.processTypeForEba() && !this.isNull(jeis = this.readInputStream(jis), entryNameWithContext)) {
                                        switch (bt) {
                                            case WAR: {
                                                this.processWarFile(jeis, store, entryNameWithContext, entryNameWithFullpath);
                                                break;
                                            }
                                            case CBA: {
                                                this.processCbaFile(jeis, store, entryNameWithContext, entryNameWithFullpath);
                                                break;
                                            }
                                            case JAR: {
                                                this.processJarFile(jeis, store, entryNameWithContext, entryNameWithFullpath);
                                                break;
                                            }
                                            case PROPERTIES: {
                                                this.processPropertyFile(entryNameWithFullpath, jeis, entryNameWithContext, store);
                                            }
                                            default: {
                                                break;
                                            }
                                        }
                                    }
                                }
                                catch (IOException e) {
                                    this.printBlankLine();
                                    ReportUtility.addFileWithParsingError(entryNameWithFullpath, e);
                                    if (jeis != null) {
                                        jeis.close();
                                        jeis = null;
                                    }
                                    break block23;
                                }
                            }
                            catch (Throwable throwable) {
                                if (jeis != null) {
                                    jeis.close();
                                    jeis = null;
                                }
                                throw throwable;
                            }
                            if (jeis != null) {
                                jeis.close();
                                jeis = null;
                            }
                        } else {
                            ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_File_Excluded"), entryNameWithContext));
                        }
                    }
                }
                jis.closeEntry();
            }
        }
        finally {
            if (jeis != null) {
                jeis.close();
            }
        }
    }

    protected void processCbaFile(InputStream is, SimpleDataStore store, String fileName, String fullpath) throws IOException {
        InputStream jeis = null;
        try {
            JarInputStream jis = new JarInputStream(is, false);
            JarEntry je = null;
            while ((je = jis.getNextJarEntry()) != null) {
                block22: {
                    String entryName = je.getName();
                    ReportUtility.logger.get().log(Level.FINE, "Processing cba entry: " + entryName);
                    String lowerEntryName = entryName.toLowerCase();
                    if (!je.isDirectory()) {
                        String entryNameWithContext = String.valueOf(fileName) + "/" + entryName;
                        String entryNameWithFullpath = String.valueOf(fullpath) + "/" + entryName;
                        if (this.shouldProcessFile(entryNameWithContext)) {
                            store.addFileName(entryNameWithContext);
                            try {
                                try {
                                    BinaryType bt = BinaryType.getBinaryType(lowerEntryName);
                                    if (bt.processTypeForCba() && !this.isNull(jeis = this.readInputStream(jis), entryNameWithContext)) {
                                        switch (bt) {
                                            case JAR: {
                                                this.processJarFile(jeis, store, entryNameWithContext, entryNameWithFullpath);
                                                break;
                                            }
                                            case PROPERTIES: {
                                                this.processPropertyFile(entryNameWithFullpath, jeis, entryNameWithContext, store);
                                                break;
                                            }
                                            case COMPOSITEMF: {
                                                this.processManifestFile(entryNameWithFullpath, jeis, entryNameWithContext, store);
                                            }
                                            default: {
                                                break;
                                            }
                                        }
                                    }
                                }
                                catch (IOException e) {
                                    this.printBlankLine();
                                    ReportUtility.addFileWithParsingError(entryNameWithFullpath, e);
                                    if (jeis != null) {
                                        jeis.close();
                                        jeis = null;
                                    }
                                    break block22;
                                }
                            }
                            catch (Throwable throwable) {
                                if (jeis != null) {
                                    jeis.close();
                                    jeis = null;
                                }
                                throw throwable;
                            }
                            if (jeis != null) {
                                jeis.close();
                                jeis = null;
                            }
                        } else {
                            ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_File_Excluded"), entryNameWithContext));
                        }
                    }
                }
                jis.closeEntry();
            }
        }
        finally {
            if (jeis != null) {
                jeis.close();
            }
        }
    }

    protected void processJarFile(InputStream is, SimpleDataStore store, String fileName, String fullpath) throws IOException {
        InputStream jeis = null;
        try {
            JarInputStream jis = new JarInputStream(is, false);
            JarEntry je = null;
            try {
                this.addMessageDigestToStack();
                Manifest mf = jis.getManifest();
                if (mf != null) {
                    ReportUtility.logger.get().log(Level.FINE, "Processing jar entry manifest: META-INF/MANIFEST.MF");
                    String entryNameWithContext = String.valueOf(fileName) + "/" + "META-INF/MANIFEST.MF";
                    this.processManifestFile(mf, entryNameWithContext, store);
                }
                while ((je = jis.getNextJarEntry()) != null) {
                    block28: {
                        String entryName = je.getName();
                        ReportUtility.logger.get().log(Level.FINE, "Processing jar entry: " + entryName);
                        String lowerEntryName = entryName.toLowerCase();
                        if (!je.isDirectory()) {
                            String entryNameWithContext = String.valueOf(fileName) + "/" + entryName;
                            String entryNameWithFullpath = String.valueOf(fullpath) + "/" + entryName;
                            if (this.shouldProcessFile(entryNameWithContext)) {
                                store.addFileName(entryNameWithContext);
                                try {
                                    try {
                                        BinaryType bt = BinaryType.getBinaryType(lowerEntryName);
                                        if (bt.processTypeForJarInJar() && !this.isNull(jeis = this.readInputStream(jis), entryNameWithContext)) {
                                            switch (bt) {
                                                case JAR: {
                                                    this.processJarFile(jeis, store, entryNameWithContext, entryNameWithFullpath);
                                                    break;
                                                }
                                                case CLASS: {
                                                    ClassDataStore cds = new ClassDataStore(entryNameWithContext, store);
                                                    this.processClassFile(entryNameWithFullpath, jeis, this.getWebInfClassName(entryName), store, cds);
                                                    break;
                                                }
                                                case XML: {
                                                    this.processXmlFile(entryNameWithFullpath, jeis, entryNameWithContext, store, je.getSize());
                                                    break;
                                                }
                                                case JSP: {
                                                    this.processJspFile(entryNameWithFullpath, jeis, entryNameWithContext, store);
                                                    break;
                                                }
                                                case PROPERTIES: {
                                                    this.processPropertyFile(entryNameWithFullpath, jeis, entryNameWithContext, store);
                                                }
                                                default: {
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                    catch (IOException e) {
                                        this.printBlankLine();
                                        ReportUtility.addFileWithParsingError(entryNameWithFullpath, e);
                                        if (jeis != null) {
                                            jeis.close();
                                            jeis = null;
                                        }
                                        break block28;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (jeis != null) {
                                        jeis.close();
                                        jeis = null;
                                    }
                                    throw throwable;
                                }
                                if (jeis != null) {
                                    jeis.close();
                                    jeis = null;
                                }
                            } else {
                                ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_File_Excluded"), entryNameWithContext));
                            }
                        }
                    }
                    jis.closeEntry();
                }
            }
            finally {
                this.digestTopChecksumOfStack(fullpath);
            }
        }
        finally {
            if (jeis != null) {
                jeis.close();
            }
        }
    }

    protected InputStream readInputStream(InputStream is) throws IOException {
        return this.readInputStream(is, false);
    }

    protected InputStream readInputStream(InputStream is, boolean updateDigest) throws IOException {
        byte[] contents = null;
        ByteArrayInputStream bais = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int nextByte;
            while ((nextByte = is.read()) != -1) {
                baos.write(nextByte);
            }
            contents = baos.toByteArray();
            if (contents.length != 0) {
                for (MessageDigest md : this.mdStack) {
                    if (md == null || !updateDigest) continue;
                    md.update(contents);
                }
                bais = new ByteArrayInputStream(contents);
            }
        }
        finally {
            if (baos != null) {
                baos.close();
            }
        }
        return bais;
    }

    protected void processClassFile(File fileToProcess, SimpleDataStore store) {
        block14: {
            FileInputStream fis = null;
            String fileName = this.addFileNameProcessed(fileToProcess, store);
            try {
                try {
                    this.printStatusMessage(".");
                    fis = new FileInputStream(fileToProcess);
                    ClassDataStore cds = new ClassDataStore(fileName, store);
                    this.processClassFile(fileName, fis, null, store, cds);
                }
                catch (Exception e1) {
                    this.printBlankLine();
                    ReportUtility.addFileWithParsingError(fileName, e1);
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        break block14;
                    }
                    catch (IOException e) {
                        this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
                }
                throw throwable;
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
            }
        }
    }

    private boolean shouldScanClassFile(String className) {
        if (className == null) {
            return true;
        }
        if (this._checkDefaultExcludePackages) {
            if (this._excludePackagesDefaultRegex.matcher(className).matches()) {
                return false;
            }
        } else {
            if (this._checkExcludePackages && this._excludePackagesRegex.matcher(className).matches()) {
                return false;
            }
            if (this._checkIncludePackages) {
                return this._includePackagesRegex.matcher(className).matches();
            }
        }
        return true;
    }

    protected void processClassFile(String fileFullPath, InputStream fileToProcessStream, String className, SimpleDataStore store, ClassDataStore classData) {
        block12: {
            try {
                try {
                    boolean scanClassFileForNonInventoryRules = this.shouldScanClassFile(className);
                    if (this._data.isInventoryReport() || scanClassFileForNonInventoryRules && this._nonInventoryRuleSetsProvided) {
                        InputStream fileToProcessDup = this.readInputStream(fileToProcessStream, true);
                        classData.initializeClassData(this._classNames, this._methodNames, this._methodNamesRequireStackDetails, this._constructorOwners, this._annotations, this._enums, this._collectReferencedPackages, this._collectReferencedClasses, _packagesToExcludeForInventory, this._sharedLibraryArchiveNames, this._cacheGetterAndSetterMethods, scanClassFileForNonInventoryRules);
                        ClassLink link = new ClassLink(classData);
                        ClassReader cr = new ClassReader(fileToProcessDup);
                        cr.accept(link, 0);
                        Set<String> annoSet = classData.getClassAnnotations();
                        if (this._data.isInventoryReport() && annoSet != null) {
                            EnumSet<Archive.AnnotationType> annotationTypeSet = EnumSet.noneOf(Archive.AnnotationType.class);
                            for (String anno : annoSet) {
                                Archive.AnnotationType annoType = Archive.AnnotationType.getAnnotationType(anno);
                                if (annoType == Archive.AnnotationType.UNKNOWN) continue;
                                annotationTypeSet.add(annoType);
                            }
                            if (!annotationTypeSet.isEmpty()) {
                                String fileName = classData.getClassNameWithContext();
                                String archiveName = ReportUtility.getLastArchiveFileName(fileName);
                                store.addToArchiveToAnnoTypeMap(archiveName, annotationTypeSet);
                            }
                        }
                        if (this._data.isGenerateConfigReport()) {
                            this.container.analyzeConfig(store, RuleType.JavaRule);
                        }
                        if (scanClassFileForNonInventoryRules && this._nonInventoryRuleSetsProvided) {
                            this.container.analyzeDetailResults(store, RuleType.JavaRule, ReportInputData.ReportType.getNonInventoryReportTypes());
                        }
                        if (this._data.isInventoryReport()) {
                            this.container.analyzeDetailResults(store, RuleType.JavaRule, ReportInputData.ReportType.getInventoryReportTypes());
                        }
                        break block12;
                    }
                    String implementedClassName = className.replace("/", ".");
                    store.addImplementedClassName(implementedClassName.substring(0, implementedClassName.length() - 6));
                }
                catch (Exception e) {
                    this.printBlankLine();
                    ReportUtility.addFileWithParsingError(fileFullPath, e);
                    store.clearType(RuleType.JavaRule);
                }
            }
            finally {
                store.clearType(RuleType.JavaRule);
            }
        }
    }

    protected boolean shouldProcessFile(String fileName) {
        boolean shouldProcessFile = true;
        Pattern excludeFilesPattern = this._data.getExcludeFilesPattern();
        if (!fileName.endsWith(".class") && excludeFilesPattern != null) {
            shouldProcessFile = !excludeFilesPattern.matcher(fileName).matches();
        }
        return shouldProcessFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processXmlFile(String fileFullPath, InputStream fileToProcess, String fileName, SimpleDataStore store, long size) {
        if (size > 0xA00000L) {
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_BIG_XML_FILE"), fileName, size / 0x100000L, 10L));
            return;
        }
        if (!this._skipXmlOptimization && !XMLRuleUtil.isMatchingFile(fileName, this._filePatternsForXml)) return;
        BufferedInputStream bis = null;
        ReportUtility.logger.get().log(Level.FINE, "Processing xml file " + fileName + " with size " + size + " bytes.");
        try {
            bis = new BufferedInputStream(fileToProcess);
            XMLResource resource = new XMLResource(bis, fileName);
            store.addDocument(resource, fileName);
            if (this._data.isGenerateConfigReport()) {
                this.container.analyzeConfig(store, RuleType.XmlRule);
            }
            this.container.analyzeDetailResults(store, RuleType.XmlRule);
        }
        catch (XMLResource.EmptyDocumentException e) {
            ReportUtility.logger.get().log(Level.FINE, e.getMessage());
            store.addEmptyXMLFile(fileName);
            this.container.analyzeDetailResults(store, RuleType.XmlRule);
            store.clearType(RuleType.XmlRule);
            if (bis == null) return;
            try {
                bis.close();
                return;
            }
            catch (IOException e2) {
                this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e2, fileName));
            }
            return;
        }
        catch (Exception e) {
            try {
                this.printBlankLine();
                ReportUtility.addFileWithParsingError(fileFullPath, e);
                store.clearType(RuleType.XmlRule);
                if (bis == null) return;
            }
            catch (Throwable throwable) {
                store.clearType(RuleType.XmlRule);
                if (bis == null) throw throwable;
                try {
                    bis.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e3, fileName));
                }
                throw throwable;
            }
            try {
                bis.close();
                return;
            }
            catch (IOException e4) {
                this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e4, fileName));
            }
            return;
        }
        store.clearType(RuleType.XmlRule);
        if (bis == null) return;
        try {
            bis.close();
            return;
        }
        catch (IOException e) {
            this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
        }
    }

    protected void processXmlFile(File fileToProcess, SimpleDataStore store) {
        block14: {
            String fileName = this.addFileNameProcessed(fileToProcess, store);
            FileInputStream fis = null;
            try {
                try {
                    this.printStatusMessage(".");
                    fis = new FileInputStream(fileToProcess);
                    this.processXmlFile(this.getFileName(fileToProcess), fis, fileName, store, fileToProcess.length());
                }
                catch (FileNotFoundException e1) {
                    this.printBlankLine();
                    ReportUtility.addFileWithParsingError(fileName, e1);
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        break block14;
                    }
                    catch (IOException e) {
                        this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
                }
                throw throwable;
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
            }
        }
    }

    public static String readJsp(InputStream is) throws IOException {
        int length;
        StringBuilder sb = new StringBuilder();
        byte[] buffer = new byte[2048];
        while ((length = is.read(buffer)) != -1) {
            sb.append(new String(buffer, 0, length));
        }
        return sb.toString();
    }

    protected void processJspFile(String fileFullPath, InputStream fileToProcess, String fileName, SimpleDataStore store) {
        ReportUtility.logger.get().log(Level.FINE, "Processing jsp file: " + fileName);
        try {
            try {
                JSPResource jspData = new JSPResource(fileToProcess, fileName);
                store.addJsp(jspData, fileName);
                this.container.analyzeDetailResults(store, RuleType.JspRule);
            }
            catch (Exception e) {
                this.printBlankLine();
                ReportUtility.addFileWithParsingError(fileFullPath, e);
                store.clearType(RuleType.JspRule);
            }
        }
        finally {
            store.clearType(RuleType.JspRule);
        }
    }

    protected void processJspFile(File fileToProcess, SimpleDataStore store) {
        block14: {
            String fileName = this.addFileNameProcessed(fileToProcess, store);
            FileInputStream fis = null;
            try {
                try {
                    this.printStatusMessage(".");
                    fis = new FileInputStream(fileToProcess);
                    this.processJspFile(fileName, fis, fileName, store);
                }
                catch (FileNotFoundException e1) {
                    this.printBlankLine();
                    ReportUtility.addFileWithParsingError(fileName, e1);
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        break block14;
                    }
                    catch (IOException e) {
                        this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
                }
                throw throwable;
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
            }
        }
    }

    public static Properties readProps(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        return props;
    }

    protected void processPropertyFile(String fileFullPath, InputStream fileToProcess, String fileName, SimpleDataStore store) {
        ReportUtility.logger.get().log(Level.FINE, "Processing property file: " + fileName);
        try {
            try {
                Properties props = BinaryReportReader.readProps(fileToProcess);
                store.addPropertyFile(props, fileName);
                if (this._data.isGenerateConfigReport()) {
                    this.container.analyzeConfig(store, RuleType.PropertyRule);
                }
                this.container.analyzeDetailResults(store, RuleType.PropertyRule);
            }
            catch (Exception e) {
                this.printBlankLine();
                ReportUtility.addFileWithParsingError(fileFullPath, e);
                store.clearType(RuleType.PropertyRule);
            }
        }
        finally {
            store.clearType(RuleType.PropertyRule);
        }
    }

    protected void processPropertyFile(File fileToProcess, SimpleDataStore store) {
        block14: {
            String fileName = this.addFileNameProcessed(fileToProcess, store);
            FileInputStream fis = null;
            try {
                try {
                    this.printStatusMessage(".");
                    fis = new FileInputStream(fileToProcess);
                    this.processPropertyFile(fileName, fis, fileName, store);
                }
                catch (FileNotFoundException e1) {
                    this.printBlankLine();
                    ReportUtility.addFileWithParsingError(fileName, e1);
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        break block14;
                    }
                    catch (IOException e) {
                        this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
                }
                throw throwable;
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
            }
        }
    }

    protected void processManifestFile(String fileFullPath, InputStream fileToProcess, String fileName, SimpleDataStore store) {
        ReportUtility.logger.get().log(Level.FINE, "Processing manifest file: " + fileName);
        try {
            Manifest mf = new Manifest(fileToProcess);
            this.processManifestFile(mf, fileName, store);
        }
        catch (Exception e) {
            this.printBlankLine();
            ReportUtility.addFileWithParsingError(fileName, e);
        }
    }

    protected void processManifestFile(Manifest mf, String fileName, SimpleDataStore store) {
        store.addManifest(mf, fileName);
        this.container.analyzeDetailResults(store, RuleType.ManifestRule);
        store.clearType(RuleType.ManifestRule);
    }

    protected boolean startsWithPrefixIgnoreCase(String prefix, String fileName) {
        String lowerCasePrefix = prefix.toLowerCase();
        String lowerCaseFileName = fileName.toLowerCase();
        return lowerCaseFileName.startsWith(lowerCasePrefix);
    }

    protected String getFileNameToProcess(String prefix, String fileName) {
        String fileNameToProcess = fileName = ReportUtility.filterUppercaseFileExtension(fileName.replace("\\", "/"));
        if (prefix != null) {
            if (fileName.startsWith(prefix) || this.startsWithPrefixIgnoreCase(prefix, fileName)) {
                int startIndex = prefix.length() + 1;
                if (prefix.endsWith("META-INF")) {
                    startIndex = startIndex - "META-INF".length() - 1;
                } else if (prefix.endsWith("WEB-INF")) {
                    startIndex = startIndex - "WEB-INF".length() - 1;
                } else if (prefix.endsWith("OSGI-INF")) {
                    startIndex = startIndex - "OSGI-INF".length() - 1;
                } else if (prefix.endsWith("OSGI-INF/blueprint")) {
                    startIndex = startIndex - "OSGI-INF/blueprint".length() - 1;
                } else if (prefix.endsWith("META-INF/sca-deployables")) {
                    startIndex = startIndex - "META-INF/sca-deployables".length() - 1;
                }
                if (!this._sharedLibraryArchiveNames.contains(fileName)) {
                    fileNameToProcess = fileName.substring(startIndex);
                }
                ReportUtility.logger.get().log(Level.FINE, "Old fileName: " + fileName + " new fileName: " + fileNameToProcess);
            } else {
                ReportUtility.logger.get().log(Level.FINE, "Using fileName: " + fileName + " since it does not start with the prefix: " + prefix);
            }
        }
        return fileNameToProcess;
    }

    protected void processManifestFile(File fileToProcess, SimpleDataStore store) {
        block14: {
            String fileName = this.addFileNameProcessed(fileToProcess, store);
            FileInputStream fis = null;
            try {
                try {
                    this.printStatusMessage(".");
                    fis = new FileInputStream(fileToProcess);
                    this.processManifestFile(fileName, fis, fileName, store);
                }
                catch (Exception e1) {
                    this.printBlankLine();
                    ReportUtility.addFileWithParsingError(fileName, e1);
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        break block14;
                    }
                    catch (IOException e) {
                        this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
                }
                throw throwable;
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                this.printlnDebugMessage(Messages.getFormattedMessage("BinaryReportReader_Error_Closing_File_Log", e, fileName));
            }
        }
    }

    protected void addImplementedClassAndPackageName(String className, SimpleDataStore store) {
        className = className.substring(0, className.length() - 6);
        className = className.replace("/", ".");
        store.addImplementedClassName(className);
        ReportUtility.logger.get().log(Level.FINE, "Stored implemented class name: " + className);
        if (className.lastIndexOf(46) > 0) {
            String packageName = className.substring(0, className.lastIndexOf(46));
            store.addImplementedPackageName(packageName);
            store.addImplementedPackageName(String.valueOf(packageName) + "*");
        }
    }

    @Override
    public void closeFile() {
        this._projectNames.clear();
        this._nonTechRules.clear();
        this._projectsToRulesFound.clear();
        this._classNames.clear();
        this._methodNames.clear();
        this._methodNamesRequireStackDetails.clear();
        this._constructorOwners.clear();
        this._xmlFilePatterns.clear();
        this._annotations.clear();
        this._enums.clear();
        this._ptr = 0;
        this._store.clear();
    }

    public SimpleDataStore getDataStore() {
        return this._store;
    }

    @Override
    public boolean hasMore() {
        return this._ptr < this._techs.size();
    }

    @Override
    public void clearPtr() {
        this._ptr = 0;
    }

    @Override
    public int getPtr() {
        return this._ptr;
    }

    @Override
    public List<String> getProjects() {
        return this._projectNames;
    }

    @Override
    public AbstractTechnology next() {
        AbstractTechnology currentTech = null;
        boolean hasAny = false;
        do {
            currentTech = this._techs.get(this._ptr);
            if (this._data.isEvaluationReport()) {
                for (String project : this._projectNames) {
                    if (hasAny) continue;
                    hasAny = currentTech.trigger(this._projectsToRulesFound.get(project));
                }
            } else {
                List<DetailResult> results = currentTech.calculateDetailResults(this._projectsToRulesFound, this._projectsToDetailResults);
                if (results == null || !results.isEmpty()) {
                    hasAny = true;
                }
            }
            ++this._ptr;
        } while (this.hasMore() && !hasAny);
        if (hasAny) {
            return currentTech;
        }
        return null;
    }

    @Override
    public AbstractTechnology nextForEval(String project) {
        AbstractTechnology currentTech = null;
        boolean hasAny = this._data.loadAllRules();
        do {
            currentTech = this._techs.get(this._ptr);
            if (!hasAny) {
                hasAny = currentTech.trigger(this._projectsToRulesFound.get(project));
            }
            ++this._ptr;
        } while (this.hasMore() && !hasAny);
        if (hasAny) {
            return currentTech;
        }
        return null;
    }

    @Override
    public SortedMap<String, TechSummary> buildTechResults() {
        TreeMap<String, TechSummary> techSummariesByProject = new TreeMap<String, TechSummary>();
        for (String project : this.getProjects()) {
            TechSummary techSummary = new TechSummary(false);
            this.clearPtr();
            techSummary.addProjectName(ReportUtility.getArchiveNamePath(project, true));
            while (this.hasMore()) {
                AbstractTechnology tech = this.nextForEval(project);
                if (tech == null) continue;
                techSummary.addTechnology(this.getPtr(), tech);
            }
            techSummariesByProject.put(project, techSummary);
        }
        return techSummariesByProject;
    }

    public static enum BinaryType {
        CBA,
        CLASS,
        COMPOSITEMF,
        EAR,
        EBA,
        JAR,
        JSP,
        MANIFESTMF,
        MF,
        PROPERTIES,
        RAR,
        WAR,
        XML,
        ZIP,
        UNKNOWN;

        private static EnumSet<BinaryType> cbaEntries;
        private static EnumSet<BinaryType> earEntries;
        private static EnumSet<BinaryType> ebaEntries;
        private static EnumSet<BinaryType> jarEntries;
        private static EnumSet<BinaryType> jarInJarEntries;
        private static EnumSet<BinaryType> zipEntries;

        static {
            cbaEntries = EnumSet.of(COMPOSITEMF, JAR, PROPERTIES);
            earEntries = EnumSet.of(CLASS, new BinaryType[]{JAR, JSP, PROPERTIES, WAR, XML});
            ebaEntries = EnumSet.of(CBA, JAR, PROPERTIES, WAR);
            jarEntries = EnumSet.of(CBA, new BinaryType[]{CLASS, COMPOSITEMF, JAR, JSP, PROPERTIES, RAR, WAR, XML});
            jarInJarEntries = EnumSet.of(CLASS, JAR, JSP, PROPERTIES, XML);
            zipEntries = EnumSet.of(CLASS, new BinaryType[]{COMPOSITEMF, EBA, EAR, JAR, JSP, MANIFESTMF, PROPERTIES, RAR, WAR, XML});
        }

        public boolean processTypeForCba() {
            return cbaEntries.contains((Object)this);
        }

        public boolean processTypeForEar() {
            return earEntries.contains((Object)this);
        }

        public boolean processTypeForEba() {
            return ebaEntries.contains((Object)this);
        }

        public boolean processTypeForJar() {
            return jarEntries.contains((Object)this);
        }

        public boolean processTypeForJarInJar() {
            return jarInJarEntries.contains((Object)this);
        }

        public boolean processTypeForRar() {
            return jarEntries.contains((Object)this);
        }

        public boolean processTypeForWar() {
            return jarEntries.contains((Object)this);
        }

        public boolean processTypeForZip() {
            return zipEntries.contains((Object)this);
        }

        public static BinaryType getBinaryType(String name2) {
            if (name2.endsWith(".jar")) {
                return JAR;
            }
            if (name2.endsWith(".war")) {
                return WAR;
            }
            if (name2.endsWith(".ear")) {
                return EAR;
            }
            if (name2.endsWith(".rar")) {
                return RAR;
            }
            if (name2.endsWith(".zip")) {
                return ZIP;
            }
            if (name2.endsWith(".eba")) {
                return EBA;
            }
            if (name2.endsWith(".cba")) {
                return CBA;
            }
            if (name2.endsWith(".class")) {
                return CLASS;
            }
            if (Constants.XML_EXTENSION_REGEX.matcher(name2).matches()) {
                return XML;
            }
            if (Constants.JSP_EXTENSION_REGEX.matcher(name2).matches()) {
                return JSP;
            }
            if (name2.endsWith(".properties") || name2.endsWith(".props")) {
                return PROPERTIES;
            }
            if (name2.equalsIgnoreCase("MANIFEST.MF") || name2.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                return MANIFESTMF;
            }
            if (name2.equalsIgnoreCase("COMPOSITEBUNDLE.MF") || name2.equalsIgnoreCase("META-INF/COMPOSITEBUNDLE.MF")) {
                return COMPOSITEMF;
            }
            if (name2.endsWith(".mf")) {
                return MF;
            }
            return UNKNOWN;
        }
    }
}

