/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.twas;

import com.ibm.ws.report.analyze.IdentifierObject;
import com.ibm.ws.report.binary.configutility.FileUtilities;
import com.ibm.ws.report.binary.configutility.JeeProviders;
import com.ibm.ws.report.binary.configutility.Messages;
import com.ibm.ws.report.binary.configutility.security.DomainSecurity;
import com.ibm.ws.report.binary.configutility.twas.Apps;
import com.ibm.ws.report.binary.configutility.twas.Cell;
import com.ibm.ws.report.binary.configutility.twas.Clusters;
import com.ibm.ws.report.binary.configutility.twas.Nodes;
import com.ibm.ws.report.binary.configutility.twas.Servers;
import com.ibm.ws.report.binary.configutility.twas.TwasXmlUtilities;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigManager {
    private Cell _cell;
    private final Nodes _nodes;
    private final Servers _servers;
    private final Clusters _clusters;
    private final Apps _apps;
    private final File _profileDir;

    public ConfigManager(File profileDir) throws Exception {
        ReportUtility.logger.get().log(Level.FINE, "Creating Config Manager for config directory: " + profileDir);
        this._profileDir = profileDir;
        File configDir = null;
        try {
            configDir = new File(profileDir, "config");
            this._cell = new Cell(configDir);
        }
        catch (Exception e) {
            ReportUtility.logger.get().log(Level.FINE, "Caught exception processing cell", e);
            throw new Exception(Messages.getFormattedMessage(Messages.getString("Invalid_Config_Directory"), profileDir == null ? null : profileDir.getPath() + "/config"));
        }
        this._nodes = new Nodes(this._cell);
        this._servers = new Servers();
        for (Nodes.Node nd : this._nodes.getNodes()) {
            this._servers.addServersFromNode(nd);
        }
        this._cell.setCellAdminInfo(this._nodes);
        this._clusters = new Clusters(this._cell, this._servers);
        this._cell.setClusters(this._clusters);
        this._apps = new Apps(this._cell, this._clusters, this._servers);
        this._cell.loadScopedData();
        this._nodes.loadScopedData();
        this._clusters.loadScopedData();
        this._servers.loadScopedData();
        this._apps.loadScopedData();
        Map<Object, DomainSecurity> domains = this.getSecurityDomainsForCell(this._cell);
        this.populateDomainSecurityInTopology(domains);
        for (Clusters.Cluster cd : this._clusters.getClusters()) {
            JeeProviders clusterProviders = cd.getJeeProviders();
            for (Servers.Server sd : cd.getServers()) {
                sd.getJeeProviders().setEmptyProviders(clusterProviders);
            }
        }
        for (Nodes.Node nd : this._nodes.getNodes()) {
            JeeProviders nodeProviders = JeeProviders.fromProductVersion(nd.getProductVersion());
            if (nodeProviders == null) {
                ReportUtility.logger.get().log(Level.FINEST, "Node " + nd.getNodeName() + " has unknown tWAS version, cannot set library provider defaults to its servers: " + nd.getProductVersion());
                continue;
            }
            for (Servers.Server sd : nd.getServers()) {
                sd.getJeeProviders().setEmptyProviders(nodeProviders);
            }
        }
        ReportUtility.logger.get().log(Level.FINE, "Created Config Manager: " + this);
    }

    public Cell getCell() {
        return this._cell;
    }

    public Nodes getNodes() {
        return this._nodes;
    }

    public Clusters getClusters() {
        return this._clusters;
    }

    public Servers getServers() {
        return this._servers;
    }

    public Apps getApps() {
        return this._apps;
    }

    public File getProfileDir() {
        return this._profileDir;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String nl = System.getProperty("line.separator");
        sb.append(nl + this._cell.toString());
        sb.append(nl + nl + "Nodes" + nl);
        sb.append("--------" + nl);
        sb.append(this._nodes.toString());
        sb.append(nl + nl + "Servers" + nl);
        sb.append("--------" + nl);
        sb.append(this._servers.toString());
        sb.append(nl + nl + "Clusters" + nl);
        sb.append("--------" + nl);
        sb.append(this._clusters.toString());
        sb.append(nl + nl + "Applications" + nl);
        sb.append("--------" + nl);
        sb.append(this._apps.toString());
        return sb.toString();
    }

    public Map<String, IdentifierObject> getPossibleIdentifierNames() {
        HashMap<String, IdentifierObject> identifierNames = new HashMap<String, IdentifierObject>();
        for (Apps.App app : this._apps.getApps()) {
            identifierNames.putAll(app.getUnknownIdentifierNames());
        }
        return identifierNames;
    }

    public boolean isAppDeployedToCluster(String appName, String clusterName) {
        Apps.App app = this._apps.getApp(appName);
        if (app == null) {
            return false;
        }
        if ("*".equals(clusterName)) {
            return app.getClusterTargetCount() != 0;
        }
        return app.getClusterTarget(clusterName) != null;
    }

    public boolean doesNodeHaveMemberInCluster(String nodeName, String clusterName) {
        Clusters.Cluster cluster = this._clusters.getCluster(clusterName);
        if (cluster == null) {
            return false;
        }
        String nodePrefix = nodeName + "/";
        for (Servers.Server sd : cluster.getServers()) {
            if (!sd.getServerName().startsWith(nodePrefix)) continue;
            return true;
        }
        return false;
    }

    public List<String> getServersForNode(String nodeName) {
        Nodes.Node node = this._nodes.getNode(nodeName);
        ArrayList<String> servers = new ArrayList<String>();
        if (node != null) {
            for (Servers.Server sd : node.getServers()) {
                servers.add(sd.getServerName());
            }
        }
        return servers;
    }

    public List<String> getAppsDeployedUnderNode(String nodeName) {
        Nodes.Node node = this._nodes.getNode(nodeName);
        if (node != null) {
            HashSet<String> apps = new HashSet<String>();
            for (Servers.Server server : node.getServers()) {
                for (Apps.App app : server.getApps()) {
                    apps.add(app.getAppName());
                }
            }
            return new ArrayList<String>(apps);
        }
        return new ArrayList<String>();
    }

    public String getClusterNameForNodeServer(String nodeName, String simpleServerName) {
        String serverName = nodeName + "/" + simpleServerName;
        Servers.Server server = this._servers.getServer(serverName);
        if (server == null) {
            return null;
        }
        if (server.getOwningCluster() == null) {
            return null;
        }
        return server.getOwningCluster().getClusterName();
    }

    public boolean isNodeServerMemberOfCluster(String nodeName, String simpleServerName, String clusterName) {
        Clusters.Cluster cluster = this._clusters.getCluster(clusterName);
        if (cluster == null) {
            return false;
        }
        String serverName = nodeName + "/" + simpleServerName;
        return cluster.getServer(serverName) != null;
    }

    public boolean doesAppExist(String appName) {
        return this._apps.getApp(appName) != null;
    }

    public Map<Object, DomainSecurity> getSecurityDomainsForCell(Cell cell) {
        File[] domainDirs;
        File config = cell.getCellPath().getParentFile().getParentFile();
        HashMap<Object, DomainSecurity> domains = new HashMap<Object, DomainSecurity>();
        if (config == null || !config.isDirectory() || !config.canRead()) {
            ReportUtility.logger.get().log(Level.FINE, "Config directory \"" + config.getAbsolutePath() + "\" is not valid. Skipping security domains.");
            return domains;
        }
        File domainsDirectory = new File(config, "waspolicies/default/securitydomains");
        if (domainsDirectory == null || !domainsDirectory.isDirectory() || !domainsDirectory.canRead()) {
            ReportUtility.logger.get().log(Level.FINE, "Security domains directory \"" + domainsDirectory.getAbsolutePath() + "\" is not valid. Skipping security domains.");
            return domains;
        }
        for (File domainDir : domainDirs = domainsDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname != null && pathname.isDirectory() && pathname.canRead();
            }
        })) {
            File domainSecurity = new File(domainDir, "domain-security.xml");
            File domainSecurityMap = new File(domainDir, "domain-security-map.xml");
            File domainSecurityWIM = new File(domainDir, "wim/config/wimconfig.xml");
            Document domainSecurityDoc = null;
            Document domainSecurityMapDoc = null;
            Document domainSecurityWIMDoc = null;
            try {
                domainSecurityDoc = FileUtilities.getDocument(domainSecurity);
                domainSecurityMapDoc = FileUtilities.getDocument(domainSecurityMap);
                domainSecurityWIMDoc = FileUtilities.getDocument(domainSecurityWIM);
            }
            catch (Exception e) {
                ReportUtility.logger.get().log(Level.FINE, "Security domain directory \"" + domainDir.getAbsolutePath() + "\" is not valid. Skipping security domain " + domainDir.getName() + ".");
                ReportUtility.logger.get().log(Level.FINEST, "Exception details:", e);
                continue;
            }
            if (domainSecurityDoc == null || domainSecurityMapDoc == null) {
                ReportUtility.logger.get().log(Level.FINE, "Security domain directory \"" + domainDir.getAbsolutePath() + "\" is not valid. Skipping security domain " + domainDir.getName() + ".");
                continue;
            }
            Element domainMap = (Element)domainSecurityMapDoc.getFirstChild();
            String name2 = domainDir.getName();
            if (domainMap != null) {
                name2 = domainMap.getAttribute("name");
            }
            DomainSecurity domain = TwasXmlUtilities.loadDomainSecurity(domainSecurityDoc, domainSecurityWIMDoc, name2, cell.getCellName());
            NodeList members = domainMap.getElementsByTagName("members");
            for (int i = 0; i < members.getLength(); ++i) {
                Element member = (Element)members.item(i);
                String type = member.getAttribute("resourceType");
                try {
                    String resourceName;
                    if (type.equals("Cell")) {
                        domains.put(this._cell, domain);
                        continue;
                    }
                    if (type.equals("ServerCluster")) {
                        resourceName = member.getAttribute("resourceName");
                        String clusterName = resourceName.split("clusters/")[1];
                        Clusters.Cluster matchingCluster = this._clusters.getCluster(clusterName);
                        if (matchingCluster != null) {
                            domains.put(matchingCluster, domain);
                            continue;
                        }
                        ReportUtility.logger.get().log(Level.FINE, "Security domain \"" + domainDir.getName() + "\" was mapped to a cluster named \"" + clusterName + "\" but no cluster by that name was found. This domain will not be included in the exported configuration.");
                        continue;
                    }
                    if (type.equals("Server")) {
                        resourceName = member.getAttribute("resourceName");
                        String nodeName = resourceName.split("nodes/")[1].split("/servers")[0];
                        String serverName = resourceName.split("servers/")[1];
                        Nodes.Node matchingNode = this._cell.getNodes().getNode(nodeName);
                        if (matchingNode != null) {
                            Servers.Server matchingServer = matchingNode.getServer(nodeName + "/" + serverName);
                            if (matchingServer != null) {
                                domains.put(matchingServer, domain);
                                continue;
                            }
                            ReportUtility.logger.get().log(Level.FINE, "Security domain \"" + domainDir.getName() + "\" was mapped to a server named \"" + serverName + "\" in a node named \"" + nodeName + "\" but no server by that name was found in that node. This domain will not be included in the exported configuration.");
                            continue;
                        }
                        ReportUtility.logger.get().log(Level.FINE, "Security domain \"" + domainDir.getName() + "\" was mapped to a server named \"" + serverName + "\" in a node named \"" + nodeName + "\" but no node by that name was found in the cell. This domain will not be included in the exported configuration.");
                        continue;
                    }
                    ReportUtility.logger.get().log(Level.FINE, "Security domain \"" + domainDir.getName() + "\" was not mapped to a valid member type (" + type + "). This domain will not be included in the exported configuration.");
                    continue;
                }
                catch (Exception e) {
                    ReportUtility.logger.get().log(Level.FINE, "Error determining mapping of domain \"" + domainDir.getName() + "\". This domain will not be included in the exported configuration.");
                    ReportUtility.logger.get().log(Level.FINEST, "Exception details:", e);
                }
            }
        }
        return domains;
    }

    public void populateDomainSecurityInTopology(Map<Object, DomainSecurity> domains) {
        for (Map.Entry<Object, DomainSecurity> domainEntry : domains.entrySet()) {
            Object topologyObject = domainEntry.getKey();
            if (topologyObject instanceof Cell) {
                ((Cell)topologyObject).setDomainSecurity(domainEntry.getValue());
                continue;
            }
            if (topologyObject instanceof Clusters.Cluster) {
                ((Clusters.Cluster)topologyObject).setDomainSecurity(domainEntry.getValue());
                continue;
            }
            if (topologyObject instanceof Servers.Server) {
                ((Servers.Server)topologyObject).setDomainSecurity(domainEntry.getValue());
                continue;
            }
            ReportUtility.logger.get().log(Level.FINE, "Topology object with unexpected class " + topologyObject.getClass().getCanonicalName() + " found; unable to associate with domain " + domainEntry.getValue().getName() + ". Domain not added to configuration.");
            ReportUtility.logger.get().log(Level.FINEST, domains.toString());
        }
    }
}

