/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.server;

import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedObject;
import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.binary.configutility.server.Cookie;
import com.ibm.ws.report.binary.configutility.server.DRSSettings;
import com.ibm.ws.report.binary.configutility.server.Property;
import com.ibm.ws.report.binary.configutility.server.SessionDatabasePersistence;
import com.ibm.ws.report.binary.configutility.server.TuningParams;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.List;
import java.util.logging.Level;

public class SessionManager
implements ScopedObject {
    private final Scope _scope;
    private final String _enable;
    private final String _enableUrlRewriting;
    private final String _enableCookies;
    private final String _enableSSLTracking;
    private final String _enableProtocolSwitchRewriting;
    private final String _sessionPersistenceMode;
    private final String _enableSecurityIntegration;
    private final String _allowSerializedSessionAccess;
    private final String _maxWaitTime;
    private final String _accessSessionOnTimeout;
    private final Cookie _defaultCookieSettings;
    private final SessionDatabasePersistence _sessionDatabasePersistence;
    private final TuningParams _tuningParams;
    private final DRSSettings _sessionDRSPersistence;
    private final List<Property> _properties;

    public SessionManager(Scope scope, String enable, String enableUrlRewriting, String enableCookies, String enableSSLTracking, String enableProtocolSwitchRewriting, String sessionPersistenceMode, String enableSecurityIntegration, String allowSerializedSessionAccess, String maxWaitTime, String accessSessionOnTimeout, Cookie defaultCookieSettings, SessionDatabasePersistence sessionDatabasePersistence, TuningParams tuningParams, DRSSettings sessionDRSPersistence, List<Property> properties) {
        this._scope = scope;
        this._enable = enable;
        this._enableUrlRewriting = enableUrlRewriting;
        this._enableCookies = enableCookies;
        this._enableSSLTracking = enableSSLTracking;
        this._enableProtocolSwitchRewriting = enableProtocolSwitchRewriting;
        this._sessionPersistenceMode = sessionPersistenceMode;
        this._enableSecurityIntegration = enableSecurityIntegration;
        this._allowSerializedSessionAccess = allowSerializedSessionAccess;
        this._maxWaitTime = maxWaitTime;
        this._accessSessionOnTimeout = accessSessionOnTimeout;
        this._defaultCookieSettings = defaultCookieSettings;
        this._sessionDatabasePersistence = sessionDatabasePersistence;
        this._tuningParams = tuningParams;
        this._sessionDRSPersistence = sessionDRSPersistence;
        this._properties = properties;
        ReportUtility.logger.get().log(Level.FINEST, "Created SessionManager: " + System.getProperty("line.separator") + this);
    }

    @Override
    public Scope getScope() {
        return this._scope;
    }

    public String getEnable() {
        return this._enable;
    }

    public String getEnableUrlRewriting() {
        return this._enableUrlRewriting;
    }

    public String getEnableCookies() {
        return this._enableCookies;
    }

    public String getEnableSSLTracking() {
        return this._enableSSLTracking;
    }

    public String getEnableProtocolSwitchRewriting() {
        return this._enableProtocolSwitchRewriting;
    }

    public String getSessionPersistenceMode() {
        return this._sessionPersistenceMode;
    }

    public String getEnableSecurityIntegration() {
        return this._enableSecurityIntegration;
    }

    public String getAllowSerializedSessionAccess() {
        return this._allowSerializedSessionAccess;
    }

    public String getMaxWaitTime() {
        return this._maxWaitTime;
    }

    public String getAccessSessionOnTimeout() {
        return this._accessSessionOnTimeout;
    }

    public Cookie getDefaultCookieSettings() {
        return this._defaultCookieSettings;
    }

    public SessionDatabasePersistence getSessionDatabasePersistence() {
        return this._sessionDatabasePersistence;
    }

    public TuningParams getTuningParams() {
        return this._tuningParams;
    }

    public DRSSettings getSessionDRSPersistence() {
        return this._sessionDRSPersistence;
    }

    public List<Property> getProperties() {
        return this._properties;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("SessionManager: " + nl);
        sb.append("scope " + this._scope + "\"" + nl);
        sb.append("enable " + this._enable + "\"" + nl);
        sb.append("enableUrlRewriting=\"" + this._enableUrlRewriting + "\"" + nl);
        sb.append("enableCookies=\"" + this._enableCookies + "\"" + nl);
        sb.append("enableSSLTracking=\"" + this._enableSSLTracking + "\"" + nl);
        sb.append("enableProtocolSwitchRewriting=\"" + this._enableProtocolSwitchRewriting + "\"" + nl);
        sb.append("sessionPersistenceMode=\"" + this._sessionPersistenceMode + "\"" + nl);
        sb.append("enableSecurityIntegration=\"" + this._enableSecurityIntegration + "\"" + nl);
        sb.append("allowSerializedSessionAccess=\"" + this._allowSerializedSessionAccess + "\"" + nl);
        sb.append("maxWaitTime=\"" + this._maxWaitTime + "\"" + nl);
        sb.append("accessSessionOnTimeout=\"" + this._accessSessionOnTimeout + "\"" + nl);
        sb.append("defaultCookieSettings=\"" + this._defaultCookieSettings + "\"" + nl);
        sb.append("sessionDatabasePersistence=\"" + this._sessionDatabasePersistence + "\"" + nl);
        sb.append("tuningParams=\"" + this._tuningParams + "\"" + nl);
        sb.append("sessionDRSPersistence=\"" + this._sessionDRSPersistence + "\"" + nl);
        if (this._properties != null) {
            for (Property prop : this._properties) {
                sb.append(prop + nl);
            }
        }
        return sb.toString();
    }

    @Override
    public boolean equalsAllowDifferentScopes(ScopedObject entry) {
        boolean returnValue;
        if (entry == null) {
            return false;
        }
        if (entry == this) {
            return true;
        }
        if (!(entry instanceof SessionManager)) {
            return false;
        }
        SessionManager sm = (SessionManager)entry;
        boolean bl = returnValue = CommonUtilities.equals(this._enable, sm.getEnable()) && CommonUtilities.equals(this._enableUrlRewriting, sm.getEnableUrlRewriting()) && CommonUtilities.equals(this._enableCookies, sm.getEnableCookies()) && CommonUtilities.equals(this._enableSSLTracking, sm.getEnableSSLTracking()) && CommonUtilities.equals(this._enableProtocolSwitchRewriting, sm._enableProtocolSwitchRewriting) && CommonUtilities.equals(this._enableSecurityIntegration, sm.getEnableSecurityIntegration()) && CommonUtilities.equals(this._allowSerializedSessionAccess, sm.getAllowSerializedSessionAccess()) && CommonUtilities.equals(this._maxWaitTime, sm.getMaxWaitTime()) && CommonUtilities.equals(this._accessSessionOnTimeout, sm.getAccessSessionOnTimeout()) && CommonUtilities.equals(this._defaultCookieSettings, sm.getDefaultCookieSettings()) && CommonUtilities.equals(this._sessionDatabasePersistence, sm.getSessionDatabasePersistence()) && CommonUtilities.equals(this._tuningParams, sm.getTuningParams()) && CommonUtilities.equals(this._properties, sm.getProperties());
        if (!CommonUtilities.equals(this._sessionPersistenceMode, sm.getSessionPersistenceMode()) && ("DATABASE".equals(this._sessionPersistenceMode) || "DATABASE".equals(sm.getSessionPersistenceMode()))) {
            returnValue = false;
        }
        return returnValue;
    }

    @Override
    public String getUniqueIdentifierName() {
        return "SessionManager";
    }
}

