/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.security.wim;

import com.ibm.ws.report.binary.configutility.security.wim.Realm;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.List;
import java.util.logging.Level;

public class RealmConfiguration {
    private final String _defaultRealmName;
    private final List<Realm> _realms;

    public RealmConfiguration(String defaultRealmName, List<Realm> realms) {
        this._defaultRealmName = defaultRealmName;
        this._realms = realms;
    }

    public String getDefaultRealmName() {
        return this._defaultRealmName;
    }

    public List<Realm> getRealms() {
        return this._realms;
    }

    public Realm getDefaultRealm() {
        Realm defaultRealm = null;
        for (Realm r : this._realms) {
            if (!r.getName().equals(this._defaultRealmName)) continue;
            defaultRealm = r;
            break;
        }
        if (defaultRealm == null) {
            ReportUtility.logger.get().log(Level.FINE, "Unable to find Realm with name matching defaultRealm.");
            if (this._realms.size() > 0) {
                defaultRealm = this._realms.get(0);
                ReportUtility.logger.get().log(Level.FINE, "Using realm " + defaultRealm.getName() + " as defaultRealm");
            } else {
                ReportUtility.logger.get().log(Level.FINE, "No realms found, but default realm name " + defaultRealm + " was specified. Default realm will be null");
            }
        }
        return defaultRealm;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("RealmConfiguration: " + nl);
        sb.append("defaultRealmName=\"" + this._defaultRealmName + "\"" + nl);
        sb.append("realms=\"" + this._realms + "\"" + nl);
        return sb.toString();
    }
}

