/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.security.wim;

import com.ibm.ws.report.binary.configutility.mutableconfig.SensitiveData;
import com.ibm.ws.report.binary.configutility.security.wim.Connection;
import java.util.List;

public class LdapServer {
    private final String _authentication;
    private final SensitiveData _bindDN;
    private final SensitiveData _bindPassword;
    private final String _connectionPool;
    private final String _connectTimeout;
    private final String _derefAliases;
    private final String _referal;
    private final String _sslEnabled;
    private final List<Connection> _connections;

    public LdapServer(String authentication, String bindDN, String bindPassword, String connectionPool, String connectTimeout, String derefAliases, String referal, String sslEnabled, List<Connection> connections, String parentLibertyId) {
        this._authentication = authentication;
        this._bindDN = "".equals(bindDN) ? null : new SensitiveData(parentLibertyId + "_ldapRegistry_bindDN", bindDN);
        this._bindPassword = "".equals(bindPassword) ? null : new SensitiveData(parentLibertyId + "_ldapRegistry_bindPassword", bindPassword);
        this._connectionPool = connectionPool;
        this._connectTimeout = connectTimeout;
        this._derefAliases = derefAliases;
        this._referal = referal;
        this._sslEnabled = sslEnabled;
        this._connections = connections;
    }

    public String getAuthentication() {
        return this._authentication;
    }

    public SensitiveData getBindDN() {
        return this._bindDN;
    }

    public SensitiveData getBindPassword() {
        return this._bindPassword;
    }

    public String getConnectionPool() {
        return this._connectionPool;
    }

    public String getConnectTimeout() {
        return this._connectTimeout;
    }

    public String getDerefAliases() {
        return this._derefAliases;
    }

    public String getReferal() {
        return this._referal;
    }

    public String getSslEnabled() {
        return this._sslEnabled;
    }

    public List<Connection> getConnections() {
        return this._connections;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("LdapServer: " + nl);
        sb.append("authentication=\"" + this._authentication + "\"" + nl);
        sb.append("bindDN=\"*******\"" + nl);
        sb.append("bindPassword=\"*******\"" + nl);
        sb.append("connectionPool=\"" + this._connectionPool + "\"" + nl);
        sb.append("connectTimeout=\"" + this._connectTimeout + "\"" + nl);
        sb.append("derefAliases=\"" + this._derefAliases + "\"" + nl);
        sb.append("referal=\"" + this._referal + "\"" + nl);
        sb.append("sslEnabled=\"" + this._sslEnabled + "\"" + nl);
        sb.append("connections=\"" + this._connections + "\"" + nl);
        return sb.toString();
    }
}

