/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.resource;

import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.logging.Level;

public class SIBDestination {
    private final Type _type;
    private final String _identifier;

    public SIBDestination(Type type, String identifier) {
        this._type = type;
        this._identifier = identifier;
        ReportUtility.logger.get().log(Level.FINEST, "Created SIBDestination: " + System.getProperty("line.separator") + this);
    }

    public Type getType() {
        return this._type;
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._identifier == null ? 0 : this._identifier.hashCode());
        result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
        return result;
    }

    public boolean equals(Object entry) {
        if (entry == null) {
            return false;
        }
        if (entry == this) {
            return true;
        }
        if (!(entry instanceof SIBDestination)) {
            return false;
        }
        SIBDestination dest = (SIBDestination)entry;
        return CommonUtilities.equals(this._identifier, dest.getIdentifier()) && CommonUtilities.equals((Object)this._type, (Object)dest.getType());
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("SIBDestination: " + nl);
        sb.append("type=\"" + (Object)((Object)this._type) + "\"" + nl);
        sb.append("identifier=\"" + this._identifier + "\"" + nl);
        return sb.toString();
    }

    public static enum Type {
        QUEUE("Queue"),
        TOPIC_SPACE("TopicSpace");

        private final String _stringValue;

        private Type(String stringValue) {
            this._stringValue = stringValue;
        }

        public String toString() {
            return this._stringValue;
        }
    }
}

