/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.resource;

import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedObject;
import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.binary.configutility.resource.ActivationSpec;
import com.ibm.ws.report.binary.configutility.resource.J2EEResourceFactory;
import com.ibm.ws.report.binary.configutility.resource.J2EEResourceProperty;
import com.ibm.ws.report.binary.configutility.twas.Reference;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.logging.Level;

public class J2CActivationSpec
implements ScopedObject {
    static final List<String> activationSpecSensitiveProperties = Arrays.asList(new String[0]);
    static final List<String> activationSpecMappedProperties = Arrays.asList(new String[0]);
    private final Scope _scope;
    private final String _name;
    private final String _jndiName;
    private final String _description;
    private final String _authenticationAlias;
    private final String _destinationJndiName;
    private final Reference<ActivationSpec> _activationSpec;
    private final SortedMap<String, J2EEResourceProperty> _resourceProperties;
    private String _resourceAdapterId;

    public J2CActivationSpec(Scope scope, String name2, String jndiName, String description, String authenticationAlias, String destinationJndiName, Reference<ActivationSpec> activationSpec, SortedMap<String, J2EEResourceProperty> resourceProperties) {
        this._scope = scope;
        this._name = name2;
        this._jndiName = jndiName;
        this._description = description;
        this._authenticationAlias = authenticationAlias;
        this._destinationJndiName = destinationJndiName;
        this._activationSpec = activationSpec;
        this._resourceProperties = resourceProperties;
        ReportUtility.logger.get().log(Level.FINEST, "Created J2CActivationSpec: " + System.getProperty("line.separator") + this);
    }

    public String getName() {
        return this._name;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public String getDescription() {
        return this._description;
    }

    public String getAuthenticationAlias() {
        return this._authenticationAlias;
    }

    public String getDestinationJndiName() {
        return this._destinationJndiName;
    }

    public SortedMap<String, J2EEResourceProperty> getResourceProperties() {
        return this._resourceProperties;
    }

    public Reference<ActivationSpec> getActivationSpec() {
        return this._activationSpec;
    }

    @Override
    public Scope getScope() {
        return this._scope;
    }

    public void setResourceAdapterId(String raID) {
        this._resourceAdapterId = raID;
    }

    public String getResourceAdapterId() {
        return this._resourceAdapterId;
    }

    @Override
    public String getUniqueIdentifierName() {
        return this._jndiName;
    }

    @Override
    public boolean equalsAllowDifferentScopes(ScopedObject entry) {
        if (entry == null) {
            return false;
        }
        if (entry == this) {
            return true;
        }
        if (!(entry instanceof J2CActivationSpec)) {
            return false;
        }
        J2CActivationSpec actSpec = (J2CActivationSpec)entry;
        return CommonUtilities.equals(this._name, actSpec.getName()) && CommonUtilities.equals(this._jndiName, actSpec.getJndiName()) && CommonUtilities.equals(this._description, actSpec.getDescription()) && CommonUtilities.equals(this._authenticationAlias, actSpec.getAuthenticationAlias()) && CommonUtilities.equals(this._destinationJndiName, actSpec.getDestinationJndiName()) && CommonUtilities.equals(this._activationSpec, actSpec.getActivationSpec()) && CommonUtilities.equals(this._resourceProperties, actSpec.getResourceProperties());
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("J2CActivationSpec: name=\"" + this._name + "\"" + nl);
        sb.append("jndiName=\"" + this._jndiName + "\"" + nl);
        sb.append("description=\"" + this._description + "\"" + nl);
        sb.append("authenticationAlias=\"" + this._authenticationAlias + "\"" + nl);
        sb.append("destinationJndiName=\"" + this._destinationJndiName + "\"" + nl);
        sb.append("activationSpec=\"" + this._activationSpec + "\"" + nl);
        sb.append("scope=\"" + this._scope + "\"" + nl);
        sb.append("properties: " + nl);
        if (this._resourceProperties != null) {
            for (J2EEResourceProperty prop : this._resourceProperties.values()) {
                sb.append(prop + nl);
            }
        }
        return sb.toString();
    }

    public String getUsedDestinationName() {
        J2EEResourceProperty destLookup;
        String result = "";
        if (this._resourceProperties.containsKey("destinationLookup") && !(result = (destLookup = (J2EEResourceProperty)this._resourceProperties.get("destinationLookup")).getValue()).equals("")) {
            return result;
        }
        if (this._resourceProperties.containsKey("destination")) {
            J2EEResourceProperty destination = (J2EEResourceProperty)this._resourceProperties.get("destination");
            String type = destination.getType();
            result = type != null && !type.equals("java.lang.String") ? this._destinationJndiName : destination.getValue();
            return result;
        }
        if (result.equals("") && !this._destinationJndiName.equals("")) {
            ReportUtility.logger.get().log(Level.FINEST, "ActivationSpec " + this._jndiName + " had destinationJndiName but no destinationLookup or destination properties. destinationJndiName will provide the destination for this activation spec.");
            return this._destinationJndiName;
        }
        ReportUtility.logger.get().log(Level.FINEST, "ActivationSpec " + this._jndiName + " did not specify a destination JNDI name in any field. A blank destination will be set in the target environment.");
        return result;
    }

    static {
        String jeeResourceType = J2CActivationSpec.class.getCanonicalName();
        J2EEResourceFactory.registerPropertiesForJEEResourceType(jeeResourceType, activationSpecSensitiveProperties, activationSpecMappedProperties);
    }
}

