/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.generator;

import com.ibm.ws.report.binary.configutility.Application;
import com.ibm.ws.report.binary.configutility.ConfigManagerFactory;
import com.ibm.ws.report.binary.configutility.Messages;
import com.ibm.ws.report.binary.configutility.Variable;
import com.ibm.ws.report.binary.configutility.appmodules.AppModule;
import com.ibm.ws.report.binary.configutility.appmodules.EjbJarBnd;
import com.ibm.ws.report.binary.configutility.appmodules.JcaAdapter;
import com.ibm.ws.report.binary.configutility.appmodules.MessageDriven;
import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.binary.configutility.generator.ConfigGeneratorConstants;
import com.ibm.ws.report.binary.configutility.generator.ConfigurationGenerator;
import com.ibm.ws.report.binary.configutility.generator.TwasCommandBuilderUtilities;
import com.ibm.ws.report.binary.configutility.mutableconfig.MappedData;
import com.ibm.ws.report.binary.configutility.mutableconfig.SensitiveData;
import com.ibm.ws.report.binary.configutility.mutableconfig.SensitiveDataHelper;
import com.ibm.ws.report.binary.configutility.resource.ActivationSpec;
import com.ibm.ws.report.binary.configutility.resource.ConnectionPool;
import com.ibm.ws.report.binary.configutility.resource.DataSource;
import com.ibm.ws.report.binary.configutility.resource.EnvironmentVariable;
import com.ibm.ws.report.binary.configutility.resource.J2CActivationSpec;
import com.ibm.ws.report.binary.configutility.resource.J2CAdminObject;
import com.ibm.ws.report.binary.configutility.resource.J2CConnectionFactory;
import com.ibm.ws.report.binary.configutility.resource.J2EEResourceProperty;
import com.ibm.ws.report.binary.configutility.resource.JNDIBinding;
import com.ibm.ws.report.binary.configutility.resource.JNDIObjectFactory;
import com.ibm.ws.report.binary.configutility.resource.JNDIReferenceBinding;
import com.ibm.ws.report.binary.configutility.resource.JNDIURLBinding;
import com.ibm.ws.report.binary.configutility.resource.JdbcProvider;
import com.ibm.ws.report.binary.configutility.resource.MailSession;
import com.ibm.ws.report.binary.configutility.resource.MimeType;
import com.ibm.ws.report.binary.configutility.resource.MqConnectionFactory;
import com.ibm.ws.report.binary.configutility.resource.MqQueue;
import com.ibm.ws.report.binary.configutility.resource.MqQueueConnectionFactory;
import com.ibm.ws.report.binary.configutility.resource.MqTopic;
import com.ibm.ws.report.binary.configutility.resource.MqTopicConnectionFactory;
import com.ibm.ws.report.binary.configutility.resource.Ports;
import com.ibm.ws.report.binary.configutility.resource.SIBDestination;
import com.ibm.ws.report.binary.configutility.resource.SIBus;
import com.ibm.ws.report.binary.configutility.resource.SimpleResourceAdapter;
import com.ibm.ws.report.binary.configutility.resource.VirtualHost;
import com.ibm.ws.report.binary.configutility.security.AuthDataEntry;
import com.ibm.ws.report.binary.configutility.security.AuthMechanisms;
import com.ibm.ws.report.binary.configutility.security.LDAPSearchFilter;
import com.ibm.ws.report.binary.configutility.security.LDAPUserRegistry;
import com.ibm.ws.report.binary.configutility.security.LTPAAuthMechanism;
import com.ibm.ws.report.binary.configutility.security.RunAs;
import com.ibm.ws.report.binary.configutility.security.SSLConfigGroup;
import com.ibm.ws.report.binary.configutility.security.Security;
import com.ibm.ws.report.binary.configutility.security.SecurityRole;
import com.ibm.ws.report.binary.configutility.security.UserOrGroup;
import com.ibm.ws.report.binary.configutility.security.WIMUserRegistry;
import com.ibm.ws.report.binary.configutility.security.tls.DynamicSSLConfigSelection;
import com.ibm.ws.report.binary.configutility.security.tls.SSLConfig;
import com.ibm.ws.report.binary.configutility.security.wim.Attribute;
import com.ibm.ws.report.binary.configutility.security.wim.AttributeConfiguration;
import com.ibm.ws.report.binary.configutility.security.wim.AttributesCache;
import com.ibm.ws.report.binary.configutility.security.wim.BaseEntry;
import com.ibm.ws.report.binary.configutility.security.wim.CacheConfiguration;
import com.ibm.ws.report.binary.configutility.security.wim.Connection;
import com.ibm.ws.report.binary.configutility.security.wim.ContextPool;
import com.ibm.ws.report.binary.configutility.security.wim.GroupConfiguration;
import com.ibm.ws.report.binary.configutility.security.wim.LdapEntityType;
import com.ibm.ws.report.binary.configutility.security.wim.LdapRepository;
import com.ibm.ws.report.binary.configutility.security.wim.LdapServer;
import com.ibm.ws.report.binary.configutility.security.wim.LdapServerConfiguration;
import com.ibm.ws.report.binary.configutility.security.wim.MemberAttribute;
import com.ibm.ws.report.binary.configutility.security.wim.MembershipAttribute;
import com.ibm.ws.report.binary.configutility.security.wim.PropertyMapping;
import com.ibm.ws.report.binary.configutility.security.wim.RdnAttribute;
import com.ibm.ws.report.binary.configutility.security.wim.Realm;
import com.ibm.ws.report.binary.configutility.security.wim.RealmConfiguration;
import com.ibm.ws.report.binary.configutility.security.wim.SearchResultsCache;
import com.ibm.ws.report.binary.configutility.security.wim.WimConfig;
import com.ibm.ws.report.binary.configutility.server.Cookie;
import com.ibm.ws.report.binary.configutility.server.EndPoint;
import com.ibm.ws.report.binary.configutility.server.JpaService;
import com.ibm.ws.report.binary.configutility.server.JvmEntry;
import com.ibm.ws.report.binary.configutility.server.ProcessDefinition;
import com.ibm.ws.report.binary.configutility.server.Property;
import com.ibm.ws.report.binary.configutility.server.SessionManager;
import com.ibm.ws.report.binary.configutility.server.TraceService;
import com.ibm.ws.report.binary.configutility.server.TransactionService;
import com.ibm.ws.report.binary.configutility.server.TuningParams;
import com.ibm.ws.report.binary.configutility.server.WebContainer;
import com.ibm.ws.report.binary.configutility.twas.Apps;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;

public class TwasCommandBuilder
implements ConfigurationGenerator {
    private final StringBuilder _jdbcProviderBuffer = new StringBuilder();
    private final StringBuilder _authDataBuffer = new StringBuilder();
    private final StringBuilder _siBusBuffer = new StringBuilder();
    private final StringBuilder _jmsQueueBuffer = new StringBuilder();
    private final StringBuilder _jmsTopicBuffer = new StringBuilder();
    private final StringBuilder _jndiBindingBuffer = new StringBuilder();
    private final StringBuilder _connectionFactoryBuffer = new StringBuilder();
    private final StringBuilder _activationSpecBuffer = new StringBuilder();
    private final StringBuilder _processDefinitionBuffer = new StringBuilder();
    private final StringBuilder _appInstallBuffer = new StringBuilder();
    private final StringBuilder _sessionManagementBuffer = new StringBuilder();
    private final StringBuilder _ldapSecurityBuffer = new StringBuilder();
    private final StringBuilder _federatedSecurityBuffer = new StringBuilder();
    private boolean _usesSingleAndDoubleQuotes = false;
    private boolean _warnAboutSecurityConfigNotMigrated = false;
    private SortedMap<String, List<String>> _scopeConflicts = null;
    private List<String> _modulesWithSessionManagerConfig = null;
    private final Map<String, Variable> _variables = new HashMap<String, Variable>();
    private final SortedSet<String> _usedVariables = new TreeSet<String>();
    private final Set<String> _usedSiBusNames = new HashSet<String>();
    private final Set<String> _usedSiBusIdentifiers = new HashSet<String>();
    private final File _profileDir;
    private static final List<String> validDSResourceProperties_DB2 = Arrays.asList("databaseName", "driverType", "serverName", "portNumber");
    private static final List<String> validDSResourceProperties_Oracle = Arrays.asList("URL");
    private static final List<String> validDSResourceProperties_Derby = Arrays.asList("databaseName");
    private static final List<String> validDSResourceProperties_SQLServer = Arrays.asList("databaseName", "serverName", "portNumber");
    int commandCounter = 0;
    private static final List<String> standardDefaultLDAPAttributesTypes = Arrays.asList("IDS", "ZOSDS", "DOMINO", "NDS", "SUNONE");
    private static final List<Attribute> standardDefaultLDAPAttributes = Arrays.asList(new Attribute("userPassword", "password", Arrays.asList("PersonAccount"), "", "", ""), new Attribute("krbPrincipalName", "kerberosId", Arrays.asList("PersonAccount"), "", "", ""));
    private static final List<String> adDefaultLDAPAttributesTypes = Arrays.asList("AD");
    private static final List<Attribute> adDefaultLDAPAttributes = Arrays.asList(new Attribute("userAccountControl", "", Arrays.asList("PersonAccount"), "544", "", ""), new Attribute("samAccountName", "uid", Arrays.asList("PersonAccount"), "", "", ""), new Attribute("samAccountName", "", Arrays.asList("Group"), "", "cn", ""), new Attribute("groupType", "", Arrays.asList("Group"), "8", "", ""), new Attribute("unicodePwd", "password", new ArrayList<String>(), "", "", "unicodePwd"), new Attribute("userprincipalname", "kerberosId", Arrays.asList("PersonAccount"), "", "", ""));
    private static final List<String> adamDefaultLDAPAttributesTypes = Arrays.asList("ADAM");
    private static final List<Attribute> adamDefaultLDAPAttributes = Arrays.asList(new Attribute("cn", "", Arrays.asList("Group"), "", "cn", ""), new Attribute("groupType", "", Arrays.asList("Group"), "8", "", ""), new Attribute("unicodePwd", "password", new ArrayList<String>(), "", "", "unicodePwd"), new Attribute("userprincipalname", "kerberosId", Arrays.asList("PersonAccount"), "", "", ""));
    private static final List<String> standardDefaultLDAPEntitiesTypes = Arrays.asList("IDS", "ZOSDS", "DOMINO", "NDS");
    private static final List<LdapEntityType> standardDefaultLDAPEntityTypes = Arrays.asList(new LdapEntityType("Group", "", Arrays.asList("groupOfNames"), new ArrayList<RdnAttribute>(), new ArrayList<String>(), new ArrayList<String>()), new LdapEntityType("OrgContainer", "", Arrays.asList("organization", "organizationalUnit", "domain", "container"), Arrays.asList(new RdnAttribute("o", "organization"), new RdnAttribute("ou", "organizationalUnit"), new RdnAttribute("dc", "domain"), new RdnAttribute("cn", "container")), new ArrayList<String>(), new ArrayList<String>()), new LdapEntityType("PersonAccount", "", Arrays.asList("inetOrgPerson"), new ArrayList<RdnAttribute>(), new ArrayList<String>(), new ArrayList<String>()));
    private static final List<String> sunOneDefaultLDAPEntitiesTypes = Arrays.asList("SUNONE");
    private static final List<LdapEntityType> sunOneDefaultLDAPEntityTypes = Arrays.asList(new LdapEntityType("Group", "", Arrays.asList("groupOfUniqueNames"), new ArrayList<RdnAttribute>(), new ArrayList<String>(), new ArrayList<String>()), new LdapEntityType("OrgContainer", "", Arrays.asList("organization", "organizationalUnit", "domain", "container"), Arrays.asList(new RdnAttribute("o", "organization"), new RdnAttribute("ou", "organizationalUnit"), new RdnAttribute("dc", "domain"), new RdnAttribute("cn", "container")), new ArrayList<String>(), new ArrayList<String>()), new LdapEntityType("PersonAccount", "", Arrays.asList("inetOrgPerson"), new ArrayList<RdnAttribute>(), new ArrayList<String>(), new ArrayList<String>()));
    private static final List<String> adDefaultLDAPEntitiesTypes = Arrays.asList("AD", "ADAM");
    private static final List<LdapEntityType> adDefaultLDAPEntityTypes = Arrays.asList(new LdapEntityType("Group", "(ObjectCategory=Group)", Arrays.asList("group"), new ArrayList<RdnAttribute>(), new ArrayList<String>(), new ArrayList<String>()), new LdapEntityType("OrgContainer", "", Arrays.asList("organization", "organizationalUnit", "domain", "container"), Arrays.asList(new RdnAttribute("o", "organization"), new RdnAttribute("ou", "organizationalUnit"), new RdnAttribute("dc", "domain"), new RdnAttribute("cn", "container")), new ArrayList<String>(), new ArrayList<String>()), new LdapEntityType("PersonAccount", "(ObjectCategory=User)", Arrays.asList("user"), new ArrayList<RdnAttribute>(), new ArrayList<String>(), new ArrayList<String>()));
    private static final List<String> standardDefaultLDAPGroupMemberAttributesTypes = Arrays.asList("IDS", "ZOSDS", "DOMINO", "AD", "ADAM");
    private static final List<MemberAttribute> standardDefaultLDAPGroupMemberAttributes = Arrays.asList(new MemberAttribute("uid=dummy", "member", "groupOfNames", "direct"));
    private static final List<String> ndsDefaultLDAPGroupMemberAttributesTypes = Arrays.asList("NDS");
    private static final List<MemberAttribute> ndsDefaultLDAPGroupMemberAttributes = Arrays.asList(new MemberAttribute("", "member", "groupOfNames", "direct"));
    private static final List<String> sunOneDefaultLDAPGroupMemberAttributesTypes = Arrays.asList("SUNONE");
    private static final List<MemberAttribute> sunOneDefaultLDAPGroupMemberAttributes = Arrays.asList(new MemberAttribute("", "member", "groupOfUniqueNames", "direct"));

    public TwasCommandBuilder(File profileDir) {
        this._profileDir = profileDir;
    }

    @Override
    public void addJdbcProvidersAndDataSources(JdbcProvider provider, List<DataSource> usedDataSources, boolean isTwasSourceAppServer) {
        ReportUtility.logger.get().log(Level.FINEST, "Adding JdbcProvider to TwasCommandBuilder: " + provider.getName());
        String providerVariable = "AdminConfigVar_" + this.commandCounter++;
        this._jdbcProviderBuffer.append(providerVariable + "=");
        TreeMap<String, String> parameterMap = new TreeMap<String, String>();
        parameterMap.put("name", provider.getName());
        parameterMap.put("implementationClassName", provider.getImplementationClassName());
        parameterMap.put("providerType", provider.getProviderType());
        parameterMap.put("description", provider.getDescription());
        StringBuilder classpath = new StringBuilder();
        Iterator<String> it = provider.getClasspath().iterator();
        while (it.hasNext()) {
            classpath.append(it.next());
            if (!it.hasNext()) continue;
            classpath.append(";");
        }
        parameterMap.put("classpath", classpath.toString());
        parameterMap.put("xa", String.valueOf(provider.getXa()));
        this._jdbcProviderBuffer.append(TwasCommandBuilderUtilities.buildAdminConfigCreateCommand("JDBCProvider", "Node", parameterMap, null, this));
        if (usedDataSources != null) {
            for (DataSource ds : usedDataSources) {
                if (ds.getProvider() != provider) continue;
                this.generateDataSourceJython(ds, providerVariable);
            }
        }
    }

    @Override
    public void addJmsQueue(J2CAdminObject object) {
        J2EEResourceProperty deliveryMode;
        J2EEResourceProperty priority;
        J2EEResourceProperty timeToLive;
        J2EEResourceProperty queueName;
        ReportUtility.logger.get().log(Level.FINEST, "Adding JMS Queue to TwasCommandBuilder: " + object.getName());
        this._jmsQueueBuffer.append("AdminTask.createSIBJMSQueue(");
        this._jmsQueueBuffer.append("Node, [");
        SortedMap<String, J2EEResourceProperty> props = object.getPropertySet();
        this._jmsQueueBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", object.getName()));
        this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("jndiName", object.getJndiName()));
        J2EEResourceProperty busName = (J2EEResourceProperty)props.get("BusName");
        if (busName != null && !"".equals(busName.getValue())) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("busName", busName.getValue()));
            this._usedSiBusNames.add(busName.getValue());
        }
        if ((queueName = (J2EEResourceProperty)props.get("QueueName")) != null && !"".equals(queueName.getValue())) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("queueName", queueName.getValue()));
            this._usedSiBusIdentifiers.add(queueName.getValue());
        } else {
            ReportUtility.logger.get().warning(Messages.getFormattedMessage(Messages.getString("Missing_Required_Property_Scripts"), "queueName", object.getName()));
        }
        J2EEResourceProperty readAhead = (J2EEResourceProperty)props.get("ReadAhead");
        if (readAhead != null && !"".equals(readAhead.getValue()) && !"AsConnection".equals(readAhead.getValue())) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("readAhead", readAhead.getValue()));
        }
        if ((timeToLive = (J2EEResourceProperty)props.get("TimeToLive")) != null && !"".equals(timeToLive.getValue())) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("timeToLive", timeToLive.getValue()));
        }
        if ((priority = (J2EEResourceProperty)props.get("Priority")) != null && !"".equals(priority.getValue())) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("priority", priority.getValue()));
        }
        if ((deliveryMode = (J2EEResourceProperty)props.get("DeliveryMode")) != null && !"".equals(deliveryMode.getValue())) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("deliveryMode", deliveryMode.getValue()));
        }
        this._jmsQueueBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
    }

    @Override
    public void addJmsTopic(J2CAdminObject object) {
        J2EEResourceProperty deliveryMode;
        J2EEResourceProperty priority;
        J2EEResourceProperty timeToLive;
        J2EEResourceProperty readAhead;
        J2EEResourceProperty topicSpace;
        J2EEResourceProperty topicName;
        ReportUtility.logger.get().log(Level.FINEST, "Adding JMS Topic to TwasCommandBuilder: " + object.getName());
        this._jmsTopicBuffer.append("AdminTask.createSIBJMSTopic(");
        this._jmsTopicBuffer.append("Node, [");
        SortedMap<String, J2EEResourceProperty> props = object.getPropertySet();
        this._jmsTopicBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", object.getName()));
        this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("jndiName", object.getJndiName()));
        J2EEResourceProperty busName = (J2EEResourceProperty)props.get("BusName");
        if (busName != null && !"".equals(busName.getValue())) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("busName", busName.getValue()));
            this._usedSiBusNames.add(busName.getValue());
        }
        if ((topicName = (J2EEResourceProperty)props.get("TopicName")) != null && !"".equals(topicName.getValue())) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("topicName", topicName.getValue()));
        }
        if ((topicSpace = (J2EEResourceProperty)props.get("TopicSpace")) != null && !"".equals(topicSpace.getValue())) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("topicSpace", topicSpace.getValue()));
            this._usedSiBusIdentifiers.add(topicSpace.getValue());
        }
        if ((readAhead = (J2EEResourceProperty)props.get("ReadAhead")) != null && !"".equals(readAhead.getValue()) && !"AsConnection".equals(readAhead.getValue())) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("readAhead", readAhead.getValue()));
        }
        if ((timeToLive = (J2EEResourceProperty)props.get("TimeToLive")) != null && !"".equals(timeToLive.getValue())) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("timeToLive", timeToLive.getValue()));
        }
        if ((priority = (J2EEResourceProperty)props.get("Priority")) != null && !"".equals(priority.getValue())) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("priority", priority.getValue()));
        }
        if ((deliveryMode = (J2EEResourceProperty)props.get("DeliveryMode")) != null && !"".equals(deliveryMode.getValue())) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("deliveryMode", deliveryMode.getValue()));
        }
        this._jmsTopicBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
    }

    @Override
    public void addSIBuses(List<SIBus> allServiceIntegrationBuses) {
        for (SIBus bus : allServiceIntegrationBuses) {
            boolean busNameUsed = this._usedSiBusNames.contains(bus.getName()) || ConfigManagerFactory.isMigrateAllConfig();
            boolean usedIdentifier = false;
            StringBuffer destinationBuffer = new StringBuffer();
            for (SIBDestination dest : bus.getDestinationIdentifiers()) {
                if (!this._usedSiBusIdentifiers.contains(dest.getIdentifier()) && !ConfigManagerFactory.isMigrateAllConfig()) continue;
                usedIdentifier = true;
                ReportUtility.logger.get().log(Level.FINEST, "Adding Destination to TwasCommandBuilder: " + dest.getIdentifier());
                destinationBuffer.append("AdminTask.createSIBDestination([");
                destinationBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("bus", bus.getName()));
                destinationBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", dest.getIdentifier()));
                destinationBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("type", dest.getType().toString()));
                destinationBuffer.append(", \"-node\", NodeName");
                destinationBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("server", "server1"));
                destinationBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
            }
            if (!busNameUsed && !usedIdentifier) continue;
            ReportUtility.logger.get().log(Level.FINEST, "Adding Bus to TwasCommandBuilder: " + bus.getName());
            this._siBusBuffer.append("AdminTask.createSIBus([");
            this._siBusBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("bus", bus.getName()));
            this._siBusBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("busSecurity", bus.getSecure()));
            this._siBusBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
            this._siBusBuffer.append("AdminTask.addSIBusMember([");
            this._siBusBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("fileStore", ""));
            this._siBusBuffer.append(", \"-node\", NodeName");
            this._siBusBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("bus", bus.getName()));
            this._siBusBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("server", "server1"));
            this._siBusBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
            this._siBusBuffer.append(destinationBuffer.toString());
        }
    }

    @Override
    public void addAuthData(AuthDataEntry entry) {
        ReportUtility.logger.get().log(Level.FINEST, "Adding authData to TwasCommandBuilder: " + entry.getAlias());
        TreeMap<String, String> parameterMap = new TreeMap<String, String>();
        TreeMap<String, String> variabilzedParameterMap = new TreeMap<String, String>();
        if (entry.getUserId() == null) {
            parameterMap.put("userId", "?");
        } else {
            variabilzedParameterMap.put("userId", entry.getUserId().getVarName());
        }
        parameterMap.put("description", entry.getDescription());
        if (entry.getPassword() == null) {
            parameterMap.put("password", "?");
        } else {
            variabilzedParameterMap.put("password", entry.getPassword().getVarName());
        }
        parameterMap.put("alias", entry.getAlias());
        this._authDataBuffer.append(TwasCommandBuilderUtilities.buildAdminConfigCreateCommand("JAASAuthData", "GlobalSecurityVar", parameterMap, variabilzedParameterMap, this));
    }

    @Override
    public void addVariable(Variable variable) {
        ReportUtility.logger.get().log(Level.FINEST, "Adding Variable to Variable List: " + variable.getSymbolicName());
        if (!"".equals(variable.getValue())) {
            this._variables.put(variable.getSymbolicName(), variable);
        }
    }

    @Override
    public void addVariable(String key, String value, boolean ... isSensitiveData) {
    }

    @Override
    public void addHttpEndpoint(List<Ports> ports) {
    }

    @Override
    public void addIIOPElement(List<Ports> ports) {
    }

    @Override
    public void addJNDIBinding(JNDIBinding jndiBinding, boolean isTwasSourceAppServer) {
        ReportUtility.logger.get().log(Level.FINEST, "Adding JNDIBinding to TwasCommandBuilder from scope: " + jndiBinding.getScope());
        TreeMap<String, String> parameterMap = new TreeMap<String, String>();
        parameterMap.put("name", jndiBinding.getId());
        parameterMap.put("nameInNameSpace", jndiBinding.getJndiName());
        parameterMap.put("stringToBind", jndiBinding.getValue());
        this._jndiBindingBuffer.append(TwasCommandBuilderUtilities.buildAdminConfigCreateCommand("StringNameSpaceBinding", "Server", parameterMap, null, this));
    }

    @Override
    public void addSessionManager(SessionManager sessionMgr, List<DataSource> datasources) {
        List<Property> customProps;
        TuningParams tuningParams;
        Cookie cookie;
        ReportUtility.logger.get().log(Level.FINEST, "Adding SessionManager to TwasCommandBuilder from scope: " + sessionMgr.getScope());
        boolean addedGetSessionManager = false;
        Properties sessionMgrDeaults = CommonUtilities.getSessionManagerDefaults();
        StringBuilder sessionAttributesBuilder = new StringBuilder();
        this.addNoCommaPairIfNotEmptyOrDefault(sessionAttributesBuilder, sessionMgrDeaults, "enableUrlRewriting", sessionMgr.getEnableUrlRewriting());
        this.addNoCommaPairIfNotEmptyOrDefault(sessionAttributesBuilder, sessionMgrDeaults, "enableCookies", sessionMgr.getEnableCookies());
        this.addNoCommaPairIfNotEmptyOrDefault(sessionAttributesBuilder, sessionMgrDeaults, "enableSSLTracking", sessionMgr.getEnableSSLTracking());
        this.addNoCommaPairIfNotEmptyOrDefault(sessionAttributesBuilder, sessionMgrDeaults, "enableProtocolSwitchRewriting", sessionMgr.getEnableProtocolSwitchRewriting());
        this.addNoCommaPairIfNotEmptyOrDefault(sessionAttributesBuilder, sessionMgrDeaults, "enableSecurityIntegration", sessionMgr.getEnableSecurityIntegration());
        this.addNoCommaPairIfNotEmptyOrDefault(sessionAttributesBuilder, sessionMgrDeaults, "allowSerializedSessionAccess", sessionMgr.getAllowSerializedSessionAccess());
        this.addNoCommaPairIfNotEmptyOrDefault(sessionAttributesBuilder, sessionMgrDeaults, "maxWaitTime", sessionMgr.getMaxWaitTime());
        this.addNoCommaPairIfNotEmptyOrDefault(sessionAttributesBuilder, sessionMgrDeaults, "accessSessionOnTimeout", sessionMgr.getAccessSessionOnTimeout());
        if (sessionAttributesBuilder.length() > 0) {
            if (!addedGetSessionManager) {
                this._sessionManagementBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_GET_SESSION_MANAGER);
                addedGetSessionManager = true;
            }
            sessionAttributesBuilder.deleteCharAt(sessionAttributesBuilder.length() - 1);
            this._sessionManagementBuffer.append("AdminConfig.modify(sessionManager, '[" + sessionAttributesBuilder.toString() + ConfigGeneratorConstants.ADMIN_CONFIG_STRING_END);
        }
        if ((cookie = sessionMgr.getDefaultCookieSettings()) != null) {
            StringBuilder cookieAttributesBuilder = new StringBuilder();
            this.addNoCommaPairIfNotEmptyOrDefault(cookieAttributesBuilder, sessionMgrDeaults, "name", cookie.getName());
            this.addNoCommaPairIfNotEmptyOrDefault(cookieAttributesBuilder, sessionMgrDeaults, "domain", cookie.getDomain());
            this.addNoCommaPairIfNotEmptyOrDefault(cookieAttributesBuilder, sessionMgrDeaults, "maximumAge", cookie.getMaximumAge());
            this.addNoCommaPairIfNotEmptyOrDefault(cookieAttributesBuilder, sessionMgrDeaults, "path", cookie.getPath());
            this.addNoCommaPairIfNotEmptyOrDefault(cookieAttributesBuilder, sessionMgrDeaults, "secure", cookie.getSecure());
            this.addNoCommaPairIfNotEmptyOrDefault(cookieAttributesBuilder, sessionMgrDeaults, "httpOnly", cookie.getHttpOnly());
            this.addNoCommaPairIfNotEmptyOrDefault(cookieAttributesBuilder, sessionMgrDeaults, "useContextRootAsPath", cookie.getUseContextRootAsPath());
            if (cookieAttributesBuilder.length() > 0) {
                if (!addedGetSessionManager) {
                    this._sessionManagementBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_GET_SESSION_MANAGER);
                    addedGetSessionManager = true;
                }
                cookieAttributesBuilder.deleteCharAt(cookieAttributesBuilder.length() - 1);
                this._sessionManagementBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_GET_COOKIE);
                this._sessionManagementBuffer.append("AdminConfig.modify(sessionCookie, '[" + cookieAttributesBuilder.toString() + ConfigGeneratorConstants.ADMIN_CONFIG_STRING_END);
            }
        }
        if ((tuningParams = sessionMgr.getTuningParams()) != null) {
            StringBuilder tuningParamsBuilder = new StringBuilder();
            this.addNoCommaPairIfNotEmptyOrDefault(tuningParamsBuilder, sessionMgrDeaults, "maxInMemorySessionCount", tuningParams.getMaxInMemorySessionCount());
            this.addNoCommaPairIfNotEmptyOrDefault(tuningParamsBuilder, sessionMgrDeaults, "allowOverflow", tuningParams.getAllowOverflow());
            this.addNoCommaPairIfNotEmptyOrDefault(tuningParamsBuilder, sessionMgrDeaults, "invalidationTimeout", tuningParams.getInvalidationTimeout());
            if (tuningParamsBuilder.length() > 0) {
                if (!addedGetSessionManager) {
                    this._sessionManagementBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_GET_SESSION_MANAGER);
                    addedGetSessionManager = true;
                }
                tuningParamsBuilder.deleteCharAt(tuningParamsBuilder.length() - 1);
                this._sessionManagementBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_GET_TUNING_PARAMS);
                this._sessionManagementBuffer.append("AdminConfig.modify(sessionTuningParams, '[" + tuningParamsBuilder.toString() + ConfigGeneratorConstants.ADMIN_CONFIG_STRING_END);
            }
        }
        if ((customProps = sessionMgr.getProperties()).size() > 0) {
            for (Property prop : customProps) {
                String name2 = prop.getName();
                String value = prop.getValue();
                if ("".equals(name2) || "".equals(value)) continue;
                if (!addedGetSessionManager) {
                    this._sessionManagementBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_GET_SESSION_MANAGER);
                    addedGetSessionManager = true;
                }
                this._sessionManagementBuffer.append("AdminConfig.create('Property', sessionManager, '[");
                this._sessionManagementBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfigNoComma("name", name2) + " ");
                this._sessionManagementBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfigNoComma("value", value));
                this._sessionManagementBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_STRING_END);
            }
        }
    }

    @Override
    public void setModulesWithSessionManagerConfig(List<String> modulesWithSessionManagerConfig) {
        this._modulesWithSessionManagerConfig = modulesWithSessionManagerConfig;
    }

    @Override
    public void addWebContainerAndJspEngine(WebContainer web) {
    }

    @Override
    public void addApplication(Apps.App app) {
        this._appInstallBuffer.append("AdminApp.install(");
        this._appInstallBuffer.append("'").append("/path/to/").append(app.getAppBinaryName()).append("'").append(", [");
        this._appInstallBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("node", "NodeName", false));
        this._appInstallBuffer.append(", ").append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("server", "server1"));
        this._appInstallBuffer.append(", ").append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("appname", app.getAppBinaryName()));
        if (app.getApplicationType().equals((Object)Application.ApplicationType.EAR)) {
            ReportUtility.logger.get().log(Level.FINEST, "Adding enterprise application to TwasCommandBuilder: " + app.getAppBinaryName());
            List<AppModule> modules = app.getAppModuleData();
            StringBuilder moduleContextRootBuffer = new StringBuilder();
            ArrayList<String> messageBindings = new ArrayList<String>();
            for (AppModule module : modules) {
                String contextRoot;
                EjbJarBnd bnd = module.getEjbJarBndInfo();
                if (bnd != null) {
                    List<String> messageBindingsForModule = this.getMessageBindingsForModule(module.getModuleName(true), module.getModulePath(), module.getModuleType(), bnd);
                    messageBindings.addAll(messageBindingsForModule);
                }
                if ("".equals(contextRoot = module.getContextRoot())) continue;
                if (moduleContextRootBuffer.length() > 0) {
                    moduleContextRootBuffer.append(", ");
                } else {
                    moduleContextRootBuffer.append("[");
                }
                moduleContextRootBuffer.append(this.createCtxRootForMod(module.getModuleName(true), module.getModulePath(), contextRoot));
            }
            if (messageBindings.size() > 0) {
                String ejbMessageBinding = this.createBindJndiForEjbMessageBindingsParameter(messageBindings);
                this._appInstallBuffer.append(", ").append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("BindJndiForEJBMessageBinding", ejbMessageBinding, false));
            }
            if (moduleContextRootBuffer.length() > 0) {
                moduleContextRootBuffer.append("]");
                this._appInstallBuffer.append(", ").append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("CtxRootForWebMod", moduleContextRootBuffer.toString(), false));
            }
            Security security = app.getResolvedSecurity();
            if (!app.getSecurityRoles().isEmpty() && "true".equals(security.getEnabled()) && "true".equals(security.getAppEnabled())) {
                this._appInstallBuffer.append(", ").append(this.getAppSecurityBindings(app));
            }
        } else if (app.getApplicationType().equals((Object)Application.ApplicationType.WAR)) {
            AppModule module;
            EjbJarBnd bnd;
            ReportUtility.logger.get().log(Level.FINEST, "Adding web application to TwasCommandBuilder: " + app.getAppBinaryName());
            List<AppModule> appWebModuleData = app.getAppModuleData();
            if (appWebModuleData.size() == 1) {
                AppModule module2 = appWebModuleData.get(0);
                String contextRoot = module2.getContextRoot();
                this._appInstallBuffer.append(", ").append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("contextroot", contextRoot));
                StringBuilder moduleContextRootBuffer = new StringBuilder();
                moduleContextRootBuffer.append("[");
                moduleContextRootBuffer.append(this.createCtxRootForMod(module2.getModuleName(true), module2.getModulePath(), contextRoot));
                moduleContextRootBuffer.append("]");
                this._appInstallBuffer.append(", ").append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("CtxRootForWebMod", moduleContextRootBuffer.toString(), false));
            } else {
                ReportUtility.logger.get().log(Level.FINE, "There should be 1 web module in a war application, found: " + appWebModuleData.size() + ". No context root added.");
            }
            List<AppModule> modules = app.getAppModuleData();
            ArrayList<String> messageBindings = new ArrayList<String>();
            if (modules.size() > 0 && (bnd = (module = modules.get(0)).getEjbJarBndInfo()) != null) {
                List<String> messageBindingsForModule = this.getMessageBindingsForModule(module.getModuleName(true), module.getModulePath(), module.getModuleType(), bnd);
                messageBindings.addAll(messageBindingsForModule);
            }
            if (messageBindings.size() > 0) {
                String ejbMessageBinding = this.createBindJndiForEjbMessageBindingsParameter(messageBindings);
                this._appInstallBuffer.append(", ").append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("BindJndiForEJBMessageBinding", ejbMessageBinding, false));
            }
            Security security = app.getResolvedSecurity();
            if (!app.getSecurityRoles().isEmpty() && "true".equals(security.getEnabled()) && "true".equals(security.getAppEnabled())) {
                this._appInstallBuffer.append(", ").append(this.getAppSecurityBindings(app));
            }
        }
        this._appInstallBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
    }

    private String getAppSecurityBindings(Apps.App app) {
        StringBuilder mapRolesToUsersBuilder = new StringBuilder();
        mapRolesToUsersBuilder.append("[");
        StringBuilder mapRunAsRolesToUsersBuilder = new StringBuilder();
        mapRunAsRolesToUsersBuilder.append("[");
        for (SecurityRole securityRole : app.getSecurityRoles()) {
            mapRolesToUsersBuilder.append("[").append(TwasCommandBuilder.quoteValue(securityRole.getName(), true)).append(", ");
            List<String> specialSubjects = securityRole.getSpecialSubjects();
            if (specialSubjects == null || specialSubjects.isEmpty()) {
                mapRolesToUsersBuilder.append(TwasCommandBuilder.quoteValue("No", true)).append(", ");
                mapRolesToUsersBuilder.append(TwasCommandBuilder.quoteValue("No", true)).append(", ");
            } else {
                mapRolesToUsersBuilder.append(this.getAppSecSpecialSubjects(specialSubjects, "EVERYONE")).append(", ");
                mapRolesToUsersBuilder.append(this.getAppSecSpecialSubjects(specialSubjects, "ALL_AUTHENTICATED_USERS")).append(", ");
            }
            mapRolesToUsersBuilder.append(this.getAppSecListString(securityRole.getUsers(), true)).append(", ");
            mapRolesToUsersBuilder.append(this.getAppSecListString(securityRole.getGroups(), true)).append(", ");
            mapRolesToUsersBuilder.append(this.getAppSecSpecialSubjects(specialSubjects, "ALL_AUTHENTICATED_IN_TRUSTED_REALMS")).append(", ");
            mapRolesToUsersBuilder.append(this.getAppSecListString(securityRole.getUsers(), false)).append(", ");
            mapRolesToUsersBuilder.append(this.getAppSecListString(securityRole.getGroups(), false)).append("]").append(", ");
            RunAs runAs = securityRole.getRunAs();
            if (runAs == null) continue;
            mapRunAsRolesToUsersBuilder.append(this.getRunAsString(securityRole.getName(), runAs));
        }
        String mapRolesToUsersStr = mapRolesToUsersBuilder.toString();
        String mapRunAsRolesToUsersStr = mapRunAsRolesToUsersBuilder.toString();
        StringBuilder appSecurityBindingsBuilder = new StringBuilder();
        if (!mapRolesToUsersStr.equals("[")) {
            mapRolesToUsersStr = mapRolesToUsersStr.substring(0, mapRolesToUsersStr.length() - 2).concat("]");
            appSecurityBindingsBuilder.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("MapRolesToUsers", mapRolesToUsersStr, false));
        }
        if (!mapRunAsRolesToUsersStr.equals("[")) {
            mapRunAsRolesToUsersStr = mapRunAsRolesToUsersStr.substring(0, mapRunAsRolesToUsersStr.length() - 2).concat("]");
            appSecurityBindingsBuilder.append(", ").append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("MapRunAsRolesToUsers", mapRunAsRolesToUsersStr, false));
        }
        String appSecurityBindingsStr = appSecurityBindingsBuilder.toString();
        return appSecurityBindingsStr;
    }

    private String getRunAsString(String name2, RunAs runAs) {
        StringBuilder runAsBuilder = new StringBuilder();
        SensitiveData userId = runAs.getUserid();
        SensitiveData pass = runAs.getPassword();
        if (userId != null && pass != null) {
            runAsBuilder.append("[").append(TwasCommandBuilder.quoteValue(name2, true)).append(", ");
            runAsBuilder.append(userId.getVarName()).append(", ").append(pass.getVarName());
            runAsBuilder.append("]").append(", ");
        }
        return runAsBuilder.toString();
    }

    private String getAppSecListString(List<UserOrGroup> userOrGroupList, boolean getName) {
        StringBuilder userOrGroup = new StringBuilder();
        for (UserOrGroup uog : userOrGroupList) {
            if (uog == null || uog.getName() == null || uog.getName().isEmpty()) continue;
            if (getName) {
                userOrGroup.append(uog.getName()).append("|");
                continue;
            }
            userOrGroup.append(uog.getAccessId()).append("|");
        }
        String userOrGroupStr = TwasCommandBuilder.quoteValue(userOrGroup.toString(), true);
        if (userOrGroupStr != null && userOrGroupStr.length() > 2) {
            userOrGroupStr = userOrGroupStr.substring(0, userOrGroupStr.length() - 2).concat("\"");
        }
        return userOrGroupStr;
    }

    private String getAppSecSpecialSubjects(List<String> specialSubjects, String specialSubjectToCheck) {
        for (String role : specialSubjects) {
            if (!role.contains(specialSubjectToCheck)) continue;
            return TwasCommandBuilder.quoteValue("Yes", true);
        }
        return TwasCommandBuilder.quoteValue("No", true);
    }

    private String createCtxRootForMod(String moduleName, String moduleFilename, String contextRoot) {
        return "[" + TwasCommandBuilder.quoteValue(moduleName, true) + ", " + TwasCommandBuilder.quoteValue(moduleFilename + ",WEB-INF/web.xml", true) + ", " + TwasCommandBuilder.quoteValue(contextRoot, true) + "]";
    }

    private List<String> getMessageBindingsForModule(String moduleName, String moduleFilename, AppModule.ModuleType moduleType, EjbJarBnd bnd) {
        ArrayList<String> messageBindingsForModule = new ArrayList<String>();
        for (MessageDriven md : bnd.getMessageDrivens()) {
            for (JcaAdapter jca : md.getJcaAdapters()) {
                messageBindingsForModule.add(this.createBindJndiForEjbMessageBindingEntry(moduleName, md.getName(), moduleFilename, moduleType == AppModule.ModuleType.WEB, "", jca.getActivationSpecBindingName(), jca.getDestinationBindingName(), jca.getActivationSpecAuthAlias()));
            }
        }
        return messageBindingsForModule;
    }

    private String createBindJndiForEjbMessageBindingEntry(String moduleName, String beanName, String moduleFilename, boolean isWebMod, String listenerPort, String bindingName, String destinationName, String authAlias) {
        String xmlLocation = isWebMod ? ",WEB-INF/ejb-jar.xml" : ",META-INF/ejb-jar.xml";
        return "[" + TwasCommandBuilder.quoteValue(moduleName, true) + ", " + TwasCommandBuilder.quoteValue(beanName, true) + ", " + TwasCommandBuilder.quoteValue(moduleFilename + xmlLocation, true) + ", " + TwasCommandBuilder.quoteValue(listenerPort, true) + ", " + TwasCommandBuilder.quoteValue(bindingName, true) + ", " + TwasCommandBuilder.quoteValue(destinationName, true) + ", " + TwasCommandBuilder.quoteValue(authAlias, true) + "]";
    }

    private String createBindJndiForEjbMessageBindingsParameter(List<String> messageBindings) {
        StringBuilder ejbMessageBindingBuilder = new StringBuilder();
        ejbMessageBindingBuilder.append("[");
        for (String binding : messageBindings) {
            ejbMessageBindingBuilder.append(binding).append(", ");
        }
        String ejbMessageBinding = ejbMessageBindingBuilder.toString();
        ejbMessageBinding = ejbMessageBinding.substring(0, ejbMessageBinding.length() - 2).concat("]");
        return ejbMessageBinding;
    }

    @Override
    public void addJmsQueueConnectionFactory(J2CConnectionFactory qcf, boolean isTwasSourceAppServer) {
        this.addJmsConnectionFactoryCommon(qcf, ConnectionFactoryType.Queue);
    }

    @Override
    public void addJmsTopicConnectionFactory(J2CConnectionFactory tcf, boolean isTwasSourceAppServer) {
        this.addJmsConnectionFactoryCommon(tcf, ConnectionFactoryType.Topic);
    }

    @Override
    public void addJmsConnectionFactory(J2CConnectionFactory cf, boolean isTwasSourceAppServer) {
        this.addJmsConnectionFactoryCommon(cf, ConnectionFactoryType.Generic);
    }

    private void addJmsConnectionFactoryCommon(J2CConnectionFactory cf, ConnectionFactoryType type) {
        J2EEResourceProperty readAhead;
        J2EEResourceProperty clientID;
        J2EEResourceProperty durableSubscriptionHome;
        J2EEResourceProperty providerEndpoints;
        J2EEResourceProperty targetTransportChain;
        String category;
        J2EEResourceProperty target;
        String xaRecoveryAlias;
        ReportUtility.logger.get().log(Level.FINEST, "Adding JmsConnectionFactory to TwasCommandBuilder: " + cf.getName());
        String cfVariable = "AdminConfigVar_" + this.commandCounter++;
        this._connectionFactoryBuffer.append(cfVariable + "=AdminTask.createSIBJMSConnectionFactory(");
        this._connectionFactoryBuffer.append("Node, [");
        SortedMap<String, J2EEResourceProperty> props = cf.getPropertySet();
        this._connectionFactoryBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", cf.getName()));
        this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("jndiName", cf.getJndiName()));
        J2EEResourceProperty busName = (J2EEResourceProperty)props.get("BusName");
        if (busName != null && !"".equals(busName.getValue())) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("busName", busName.getValue()));
            this._usedSiBusNames.add(busName.getValue());
        }
        if (type.equals((Object)ConnectionFactoryType.Queue)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("type", "queue"));
        } else if (type.equals((Object)ConnectionFactoryType.Topic)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("type", "topic"));
        }
        String componentAuthAlias = cf.getComponentAuthDataAlias();
        if (componentAuthAlias != null && !"".equals(componentAuthAlias)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("authDataAlias", componentAuthAlias));
        }
        if ((xaRecoveryAlias = cf.getXaRecoveryAuthAlias()) != null && !"".equals(xaRecoveryAlias)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("xaRecoveryAuthAlias", xaRecoveryAlias));
        }
        if ((target = (J2EEResourceProperty)props.get("Target")) != null && !"".equals(target.getValue())) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("target", target.getValue()));
        }
        if ((category = cf.getCategory()) != null && !"".equals(category)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("category", category));
        }
        if ((targetTransportChain = (J2EEResourceProperty)props.get("TargetTransportChain")) != null && !"".equals(targetTransportChain.getValue())) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("targetTransportChain", targetTransportChain.getValue()));
        }
        if ((providerEndpoints = (J2EEResourceProperty)props.get("ProviderEndpoints")) != null && !"".equals(providerEndpoints.getValue())) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("providerEndPoints", providerEndpoints.getValue()));
        }
        if ((durableSubscriptionHome = (J2EEResourceProperty)props.get("DurableSubscriptionHome")) != null && !"".equals(durableSubscriptionHome.getValue())) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("durableSubscriptionHome", durableSubscriptionHome.getValue()));
        }
        if ((clientID = (J2EEResourceProperty)props.get("ClientID")) != null && !"".equals(clientID.getValue())) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("clientID", clientID.getValue()));
        }
        if ((readAhead = (J2EEResourceProperty)props.get("ReadAhead")) != null && !"".equals(readAhead.getValue()) && !"Default".equals(readAhead.getValue())) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("readAhead", readAhead.getValue()));
        }
        this._connectionFactoryBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        this.generateAuthMappingJython(cf.getMappingConfigAlias(), cf.getContainerAuthDataAlias(), cfVariable, this._connectionFactoryBuffer);
        this.generateConnectionPoolJython(cf.getConnectionPool(), cf.getName(), cfVariable, this._connectionFactoryBuffer);
    }

    @Override
    public void addJmsActivationSpec(J2CActivationSpec spec, String destinationRef, Security security) {
        ActivationSpec specInterface = spec.getActivationSpec().getValue();
        if ("com.ibm.ws.sib.api.jmsra.impl.JmsJcaActivationSpecImpl".equals(specInterface.getActivationSpecClass())) {
            J2EEResourceProperty busName;
            J2EEResourceProperty readAhead;
            SortedMap<String, J2EEResourceProperty> props;
            J2EEResourceProperty destinationType;
            String authAlias;
            ReportUtility.logger.get().log(Level.FINEST, "Adding JmsActivationSpec to TwasCommandBuilder: " + spec.getName());
            this._activationSpecBuffer.append("AdminTask.createSIBJMSActivationSpec(");
            this._activationSpecBuffer.append("Node, [");
            this._activationSpecBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", spec.getName()));
            this._activationSpecBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("jndiName", spec.getJndiName()));
            this._activationSpecBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("destinationJndiName", destinationRef));
            String description = spec.getDescription();
            if (description != null && !"".equals(description)) {
                this._activationSpecBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("description", description));
            }
            if ((authAlias = spec.getAuthenticationAlias()) != null && !"".equals(authAlias)) {
                this._activationSpecBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("authenticationAlias", authAlias));
            }
            if ((destinationType = (J2EEResourceProperty)(props = spec.getResourceProperties()).get("destinationType")) != null && !"".equals(destinationType.getValue())) {
                this._activationSpecBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("destinationType", destinationType.getValue()));
            }
            if ((readAhead = (J2EEResourceProperty)props.get("readAhead")) != null && !"".equals(readAhead.getValue()) && !"Default".equals(readAhead.getValue())) {
                this._activationSpecBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("readAhead", readAhead.getValue()));
            }
            if ((busName = (J2EEResourceProperty)props.get("busName")) != null && !"".equals(busName.getValue())) {
                this._activationSpecBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("busName", busName.getValue()));
                this._usedSiBusNames.add(busName.getValue());
            }
            this._activationSpecBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        } else if ("com.ibm.mq.connector.inbound.ActivationSpecImpl".equals(specInterface.getActivationSpecClass())) {
            J2EEResourceProperty wmqTransportTypeProperty;
            J2EEResourceProperty qmgrSvrconnChannelProperty;
            J2EEResourceProperty qmgrPortNumberProperty;
            J2EEResourceProperty qmgrNameProperty;
            J2EEResourceProperty qmgrHostnameProperty;
            String description;
            J2EEResourceProperty destinationProperty;
            ReportUtility.logger.get().log(Level.FINEST, "Adding JmsActivationSpec to TwasCommandBuilder: " + spec.getName());
            this._activationSpecBuffer.append("AdminTask.createWMQActivationSpec(");
            this._activationSpecBuffer.append("Node, [");
            this._activationSpecBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", spec.getName()));
            this._activationSpecBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("jndiName", spec.getJndiName()));
            String authAlias = spec.getAuthenticationAlias();
            if (authAlias != null && !"".equals(authAlias)) {
                this._activationSpecBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("authAlias", authAlias));
            }
            if ((destinationProperty = (J2EEResourceProperty)spec.getResourceProperties().get("destination")) != null && !"".equals(destinationProperty.getValue())) {
                String destination = destinationProperty.getValue();
                this._activationSpecBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("destinationJndiName", destination));
            }
            J2EEResourceProperty destinationTypeProperty = (J2EEResourceProperty)spec.getResourceProperties().get("destinationType");
            if (destinationProperty != null && !"".equals(destinationTypeProperty.getValue())) {
                String destinationType = destinationTypeProperty.getValue();
                this._activationSpecBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("destinationType", destinationType));
            }
            if ((description = spec.getDescription()) != null && !"".equals(description)) {
                this._activationSpecBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("description", description));
            }
            if ((qmgrHostnameProperty = (J2EEResourceProperty)spec.getResourceProperties().get("hostName")) != null && !"".equals(qmgrHostnameProperty.getValue())) {
                String qmgrHostname = qmgrHostnameProperty.getValue();
                this._activationSpecBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("qmgrHostname", qmgrHostname));
            }
            if ((qmgrNameProperty = (J2EEResourceProperty)spec.getResourceProperties().get("queueManager")) != null && !"".equals(qmgrNameProperty.getValue())) {
                String qmgrName = qmgrNameProperty.getValue();
                this._activationSpecBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("qmgrName", qmgrName));
            }
            if ((qmgrPortNumberProperty = (J2EEResourceProperty)spec.getResourceProperties().get("port")) != null && !"".equals(qmgrPortNumberProperty.getValue())) {
                String qmgrPortNumber = qmgrPortNumberProperty.getValue();
                this._activationSpecBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("qmgrPortNumber", qmgrPortNumber));
            }
            if ((qmgrSvrconnChannelProperty = (J2EEResourceProperty)spec.getResourceProperties().get("channel")) != null && !"".equals(qmgrSvrconnChannelProperty.getValue())) {
                String qmgrSvrconnChannel = qmgrSvrconnChannelProperty.getValue();
                this._activationSpecBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("qmgrSvrconnChannel", qmgrSvrconnChannel));
            }
            if ((wmqTransportTypeProperty = (J2EEResourceProperty)spec.getResourceProperties().get("transportType")) != null && !"".equals(wmqTransportTypeProperty.getValue())) {
                String wmqTransportType = wmqTransportTypeProperty.getValue();
                this._activationSpecBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("wmqTransportType", wmqTransportType));
            }
            this._activationSpecBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        }
    }

    private void generateDataSourceJython(DataSource ds, String providerVariable) {
        ReportUtility.logger.get().log(Level.FINEST, "Adding DataSource to TwasCommandBuilder: " + ds.getName());
        String dataSourceVariable = "AdminConfigVar_" + this.commandCounter++;
        this._jdbcProviderBuffer.append(dataSourceVariable + "=AdminTask.createDatasource(" + providerVariable + ", [");
        if (ds.getName() != null) {
            this._jdbcProviderBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", ds.getName()) + ", ");
        }
        if (ds.getJndiName() != null) {
            this._jdbcProviderBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("jndiName", ds.getJndiName()) + ", ");
        }
        if (ds.getDataSourceHelperClassname() != null) {
            this._jdbcProviderBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("dataStoreHelperClassName", ds.getDataSourceHelperClassname()) + ", ");
        }
        if (ds.getComponentAuthDataAlias() != null && !"".equals(ds.getComponentAuthDataAlias())) {
            this._jdbcProviderBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("componentManagedAuthenticationAlias", ds.getComponentAuthDataAlias()) + ", ");
        }
        if (ds.getXaRecoveryAuthAlias() != null && !"".equals(ds.getXaRecoveryAuthAlias())) {
            this._jdbcProviderBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("xaRecoveryAuthAlias", ds.getXaRecoveryAuthAlias()) + ", ");
        }
        TreeMap<String, J2EEResourceProperty> props = new TreeMap<String, J2EEResourceProperty>();
        props.putAll(ds.getPropertySet());
        String providerType = ds.getProviderType();
        if ("".equals(providerType)) {
            providerType = ds.getProvider().getProviderType();
        }
        StringBuilder resourcePropStringValue = new StringBuilder();
        if (providerType.startsWith("Derby")) {
            this.generateDataSourceResourceProperties(resourcePropStringValue, validDSResourceProperties_Derby, props);
        } else if (providerType.startsWith("DB2")) {
            this.generateDataSourceResourceProperties(resourcePropStringValue, validDSResourceProperties_DB2, props);
        } else if (providerType.startsWith("Microsoft SQL Server JDBC Driver")) {
            this.generateDataSourceResourceProperties(resourcePropStringValue, validDSResourceProperties_SQLServer, props);
        } else if (providerType.startsWith("Oracle JDBC Driver")) {
            this.generateDataSourceResourceProperties(resourcePropStringValue, validDSResourceProperties_Oracle, props);
        } else {
            resourcePropStringValue.append("[]");
        }
        this._jdbcProviderBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("configureResourceProperties", resourcePropStringValue.toString()));
        this._jdbcProviderBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        String propertySetVariable = "AdminConfigVar_" + this.commandCounter++;
        this._jdbcProviderBuffer.append(propertySetVariable + "=AdminConfig.showAttribute(" + dataSourceVariable + ConfigGeneratorConstants.ADMIN_CONFIG_SHOW_ATTRIBUTE_END_PROPERTY_SET);
        if (!props.containsKey("name")) {
            props.put("name", new J2EEResourceProperty("name", "java.lang.String", ds.getName(), "", "false", "false", "false", "false"));
        }
        String dataType = ds.getClass().getCanonicalName();
        for (Map.Entry entry : props.entrySet()) {
            String key = (String)entry.getKey();
            J2EEResourceProperty dsProp = (J2EEResourceProperty)entry.getValue();
            String value = dsProp.getValue();
            boolean quoteValue = true;
            if (value == null) {
                value = "";
            } else if (SensitiveDataHelper.checkIfSensitiveProperty(dataType, key)) {
                SensitiveData sd = new SensitiveData(ds.getName() + "_" + key, value);
                value = sd.getVarName();
                quoteValue = false;
            }
            if (value.length() <= 0 && !"driverType".equals(key) && !"portNumber".equals(key)) continue;
            String type = dsProp.getType();
            this._jdbcProviderBuffer.append("AdminConfig.create('J2EEResourceProperty', " + propertySetVariable + ", [" + TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("name", key) + ", " + TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("type", type) + ", " + TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("value", value, quoteValue, false) + ConfigGeneratorConstants.ADMIN_CONFIG_END);
        }
        this.generateConnectionPoolJython(ds.getConnectionPool(), ds.getName(), dataSourceVariable, this._jdbcProviderBuffer);
        this.generateAuthMappingJython(ds.getMappingConfigAlias(), ds.getContainerAuthDataAlias(), dataSourceVariable, this._jdbcProviderBuffer);
    }

    private void generateConnectionPoolJython(ConnectionPool cp, String resourceName, String resourceVariable, StringBuilder resourceBuffer) {
        String connPoolVariable = "AdminConfigVar_" + this.commandCounter++;
        resourceBuffer.append(connPoolVariable + "=AdminConfig.showAttribute(" + resourceVariable + ConfigGeneratorConstants.ADMIN_CONFIG_SHOW_ATTRIBUTE_END_CONNECTION_POOL);
        boolean propsEmpty = cp.getProperties().isEmpty();
        StringBuilder connPoolCmd = new StringBuilder();
        String connPoolModifyVariable = "";
        if (!propsEmpty) {
            connPoolModifyVariable = "AdminConfigVar_" + this.commandCounter++;
            connPoolCmd.append(connPoolModifyVariable + "=");
        }
        boolean addedProperty = false;
        connPoolCmd.append("AdminConfig.modify(" + connPoolVariable + ", [");
        if (!"".equals(cp.getStuckThreshold())) {
            connPoolCmd.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("stuckThreshold", cp.getStuckThreshold()));
            addedProperty = true;
        }
        if (!"".equals(cp.getReapTime())) {
            if (addedProperty) {
                connPoolCmd.append(", ");
            }
            connPoolCmd.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("reapTime", cp.getReapTime()));
            addedProperty = true;
        }
        if (!"".equals(cp.getTestConnectionInterval())) {
            if (addedProperty) {
                connPoolCmd.append(", ");
            }
            connPoolCmd.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("testConnectionInterval", cp.getTestConnectionInterval()));
            addedProperty = true;
        }
        if (!"".equals(cp.getConnectionTimeout())) {
            if (addedProperty) {
                connPoolCmd.append(", ");
            }
            connPoolCmd.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("connectionTimeout", cp.getConnectionTimeout()));
            addedProperty = true;
        }
        if (!"".equals(cp.getSurgeCreationInterval())) {
            if (addedProperty) {
                connPoolCmd.append(", ");
            }
            connPoolCmd.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("surgeCreationInterval", cp.getSurgeCreationInterval()));
            addedProperty = true;
        }
        if (!"".equals(cp.getSurgeThreshold())) {
            if (addedProperty) {
                connPoolCmd.append(", ");
            }
            connPoolCmd.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("surgeThreshold", cp.getSurgeThreshold()));
            addedProperty = true;
        }
        if (!"".equals(cp.getStuckTimerTime())) {
            if (addedProperty) {
                connPoolCmd.append(", ");
            }
            connPoolCmd.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("stuckTimerTime", cp.getStuckTimerTime()));
            addedProperty = true;
        }
        if (!"".equals(cp.getNumberOfFreePoolPartitions())) {
            if (addedProperty) {
                connPoolCmd.append(", ");
            }
            connPoolCmd.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("numberOfFreePoolPartitions", cp.getNumberOfFreePoolPartitions()));
            addedProperty = true;
        }
        if (!"".equals(cp.getMinConnections())) {
            if (addedProperty) {
                connPoolCmd.append(", ");
            }
            connPoolCmd.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("minConnections", cp.getMinConnections()));
            addedProperty = true;
        }
        if (!"".equals(cp.getUnusedTimeout())) {
            if (addedProperty) {
                connPoolCmd.append(", ");
            }
            connPoolCmd.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("unusedTimeout", cp.getUnusedTimeout()));
            addedProperty = true;
        }
        if (!"".equals(cp.getAgedTimeout())) {
            if (addedProperty) {
                connPoolCmd.append(", ");
            }
            connPoolCmd.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("agedTimeout", cp.getAgedTimeout()));
            addedProperty = true;
        }
        if (!"".equals(cp.getNumberOfSharedPoolPartitions())) {
            if (addedProperty) {
                connPoolCmd.append(", ");
            }
            connPoolCmd.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("numberOfSharedPoolPartitions", cp.getNumberOfSharedPoolPartitions()));
            addedProperty = true;
        }
        if (!"".equals(cp.getPurgePolicy())) {
            if (addedProperty) {
                connPoolCmd.append(", ");
            }
            connPoolCmd.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("purgePolicy", cp.getPurgePolicy()));
            addedProperty = true;
        }
        if (!"".equals(cp.getMaxConnections())) {
            if (addedProperty) {
                connPoolCmd.append(", ");
            }
            connPoolCmd.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("maxConnections", cp.getMaxConnections()));
            addedProperty = true;
        }
        if (!"".equals(cp.getFreePoolDistributionTableSize())) {
            if (addedProperty) {
                connPoolCmd.append(", ");
            }
            connPoolCmd.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("freePoolDistributionTableSize", cp.getFreePoolDistributionTableSize()));
            addedProperty = true;
        }
        if (!"".equals(cp.getStuckTime())) {
            if (addedProperty) {
                connPoolCmd.append(", ");
            }
            connPoolCmd.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("stuckTime", cp.getStuckTime()));
            addedProperty = true;
        }
        if (!"".equals(cp.getTestConnection())) {
            if (addedProperty) {
                connPoolCmd.append(", ");
            }
            connPoolCmd.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("testConnection", cp.getTestConnection()));
            addedProperty = true;
        }
        if (!"".equals(cp.getNumberOfUnsharedPoolPartitions())) {
            if (addedProperty) {
                connPoolCmd.append(", ");
            }
            connPoolCmd.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("numberOfUnsharedPoolPartitions", cp.getNumberOfUnsharedPoolPartitions()));
            addedProperty = true;
        }
        connPoolCmd.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        if (addedProperty) {
            resourceBuffer.append(connPoolCmd.toString());
        } else {
            ReportUtility.logger.get().log(Level.FINEST, "Did not add connection pool to " + resourceName + " because no properties had a value set");
        }
        if (!propsEmpty) {
            String connPoolPropVariable = "AdminConfigVar_" + this.commandCounter++;
            resourceBuffer.append(connPoolPropVariable + "=AdminConfig.showAttribute(" + connPoolModifyVariable + ConfigGeneratorConstants.ADMIN_CONFIG_SHOW_ATTRIBUTE_END_PROPERTY_SET);
            for (Map.Entry<String, String> prop : cp.getProperties().entrySet()) {
                resourceBuffer.append("AdminConfig.create('J2EEResourceProperty', " + connPoolPropVariable + ", [" + TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("type", "java.lang.String") + ", " + TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("name", prop.getKey()) + ", " + TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("value", prop.getValue()) + ConfigGeneratorConstants.ADMIN_CONFIG_END);
            }
        }
    }

    private void generateAuthMappingJython(String mappingConfigAlias, String containerAuthDataAlias, String resourceProviderVariable, StringBuilder buffer) {
        if (!"".equals(mappingConfigAlias) || !"".equals(containerAuthDataAlias)) {
            buffer.append("AdminConfig.create('MappingModule', " + resourceProviderVariable + ", [");
            boolean addedFirstProp = false;
            if (!"".equals(mappingConfigAlias)) {
                buffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("mappingConfigAlias", mappingConfigAlias));
                addedFirstProp = true;
            }
            if (!"".equals(containerAuthDataAlias)) {
                if (addedFirstProp) {
                    buffer.append(", ");
                }
                buffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfig("authDataAlias", containerAuthDataAlias));
            }
            buffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        }
    }

    private void generateDataSourceResourceProperties(StringBuilder sb, List<String> validResourceProps, SortedMap<String, J2EEResourceProperty> dsPropSet) {
        sb.append("[");
        for (String prop : validResourceProps) {
            J2EEResourceProperty dsProp = (J2EEResourceProperty)dsPropSet.remove(prop);
            if (dsProp != null) {
                sb.append("[" + dsProp.getName() + " " + dsProp.getType() + " " + dsProp.getValue() + "] ");
                continue;
            }
            ReportUtility.logger.get().log(Level.FINE, "Resource property " + prop + " not found. It will not be added to -configureResourceProperties");
        }
        sb.append("]");
    }

    static String createAttributeKeyValuePairAdminConfigNoComma(String key, String value) {
        return "[" + key + " " + TwasCommandBuilder.quoteValue(value, true) + "]";
    }

    static String createAttributeKeyValuePairAdminConfig(String key, String value) {
        return TwasCommandBuilder.createAttributeKeyValuePairAdminConfig(key, value, true, false);
    }

    static String createAttributeKeyValuePairAdminTask(String key, String value, boolean quoteValue) {
        return TwasCommandBuilder.createAttributeKeyValuePairAdminTask(key, value, quoteValue, true);
    }

    static String createAttributeKeyValuePairAdminTask(String key, String value, boolean quoteValue, boolean doubleQuote) {
        value = quoteValue ? TwasCommandBuilder.quoteValue(value, doubleQuote) : value;
        String quote = doubleQuote ? "\"" : "'";
        return quote + "-" + key + quote + ", " + value;
    }

    static String createAttributeKeyValuePairAdminTask(String key, String value) {
        return TwasCommandBuilder.createAttributeKeyValuePairAdminTask(key, value, true);
    }

    static String quoteValue(String value, boolean doubleQuote) {
        if (doubleQuote) {
            return "\"" + value.replace("'", "\\'") + "\"";
        }
        return "'" + value.replace("'", "\\'") + "'";
    }

    static String createAttributeKeyValuePairAdminConfig(String key, String value, boolean quoteValue, boolean doubleQuote) {
        value = quoteValue ? TwasCommandBuilder.quoteValue(value, doubleQuote) : value;
        return "['" + key + "', " + value + "]";
    }

    private void addNoCommaPairIfNotEmptyOrDefault(StringBuilder sb, Properties defaultValues, String propertyName, String propertyValue) {
        String value = CommonUtilities.getIfNotDefaultOrEmpty(defaultValues, propertyName, propertyValue);
        if (value != null) {
            sb.append(TwasCommandBuilder.createAttributeKeyValuePairAdminConfigNoComma(propertyName, propertyValue) + " ");
        }
    }

    @Override
    public String export() throws Exception {
        StringWriter writer = new StringWriter();
        String jdbc = this._jdbcProviderBuffer.toString();
        String auth = this._authDataBuffer.toString();
        String sib = this._siBusBuffer.toString();
        String topic = this._jmsTopicBuffer.toString();
        String queue = this._jmsQueueBuffer.toString();
        String cf = this._connectionFactoryBuffer.toString();
        String actSpecs = this._activationSpecBuffer.toString();
        String processDefs = this._processDefinitionBuffer.toString();
        String appInstall = this._appInstallBuffer.toString();
        String sessions = this._sessionManagementBuffer.toString();
        String jndi = this._jndiBindingBuffer.toString();
        String ldapSecurity = this._ldapSecurityBuffer.toString();
        String federatedSecurity = this._federatedSecurityBuffer.toString();
        writer.write("# " + Messages.getString("Generated_Scripts_Message") + ConfigGeneratorConstants.NEW_LINE);
        if (this._profileDir != null) {
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            DateFormat df = DateFormat.getDateInstance(3, ReportUtility.getLocale());
            DateFormat tf = DateFormat.getTimeInstance(2, ReportUtility.getLocale());
            String formattedDate = df.format(timestamp);
            String formattedTime = tf.format(timestamp);
            writer.write("# " + Messages.getFormattedMessage(Messages.getString("Config_Location_Used_Message"), formattedDate, formattedTime, this._profileDir.getAbsolutePath()) + ConfigGeneratorConstants.NEW_LINE);
        }
        writer.write("# " + Messages.getString("Not_All_Config_Migrated_Message") + ConfigGeneratorConstants.NEW_LINE);
        if (this._modulesWithSessionManagerConfig != null && this._modulesWithSessionManagerConfig.size() > 0) {
            writer.write("# " + Messages.getFormattedMessage(Messages.getString("Application_Module_Sessions_Not_Migrated"), this._modulesWithSessionManagerConfig) + ConfigGeneratorConstants.NEW_LINE);
        }
        if (this._warnAboutSecurityConfigNotMigrated) {
            writer.write("# " + Messages.getString("Security_Config_Not_Migrated") + ConfigGeneratorConstants.NEW_LINE);
        }
        if (this._usesSingleAndDoubleQuotes) {
            writer.write("print '" + Messages.getString("Invalid_Admin_Script_Single_And_Double_Quotes") + ConfigGeneratorConstants.MESSAGE_END_PRINT);
        }
        writer.write(ConfigGeneratorConstants.NEW_LINE);
        writer.write(ConfigGeneratorConstants.ADMIN_CONFIG_DECLARE_CELL);
        writer.write(ConfigGeneratorConstants.ADMIN_CONFIG_DECLARE_NODE);
        writer.write(ConfigGeneratorConstants.ADMIN_CONFIG_DECLARE_SERVER);
        writer.write(ConfigGeneratorConstants.ADMIN_CONFIG_DECLARE_NODE_NAME);
        if (!SensitiveDataHelper.getRegisteredVarKeys().isEmpty()) {
            writer.write(ConfigGeneratorConstants.NEW_LINE);
            writer.write("# " + Messages.getString("Sensitive_Data_Replacement_Vars_Twas") + ConfigGeneratorConstants.NEW_LINE);
            if (!SensitiveDataHelper.getWarnAboutEncryptedDataAlgorithms().equals("")) {
                writer.write("# " + Messages.getFormattedMessage(Messages.getString("Sensitive_Data_Encryption_Warning"), SensitiveDataHelper.getWarnAboutEncryptedDataAlgorithms()) + ConfigGeneratorConstants.NEW_LINE);
            }
            if (!SensitiveDataHelper.isIncludeSensitiveData()) {
                writer.write("# " + Messages.getString("Sensitive_Data_Values_Not_Collected") + ConfigGeneratorConstants.NEW_LINE);
            }
            writer.write(ConfigGeneratorConstants.ADMIN_CONFIG_SECTION_DELIMITER);
            for (String varName : SensitiveDataHelper.getRegisteredVarKeys()) {
                writer.write(varName + "='" + SensitiveDataHelper.getValueForRegisteredVar(varName) + "'" + ConfigGeneratorConstants.NEW_LINE);
            }
            writer.write(ConfigGeneratorConstants.ADMIN_CONFIG_SECTION_DELIMITER);
        }
        writer.write(ConfigGeneratorConstants.NEW_LINE);
        writer.write("print '" + Messages.getString("JVM_Props_Script_Message") + ConfigGeneratorConstants.MESSAGE_END_PRINT);
        writer.write(processDefs);
        writer.write(ConfigGeneratorConstants.NEW_LINE);
        if (!sessions.isEmpty()) {
            writer.write("print '" + Messages.getString("Session_Manager_Script_Message") + ConfigGeneratorConstants.MESSAGE_END_PRINT);
            writer.write(sessions);
            writer.write(ConfigGeneratorConstants.NEW_LINE);
        }
        if (!ldapSecurity.isEmpty()) {
            writer.write("print '" + Messages.getString("Ldap_Security_Message") + ConfigGeneratorConstants.MESSAGE_END_PRINT);
            writer.write(ldapSecurity);
            writer.write(ConfigGeneratorConstants.NEW_LINE);
        }
        if (!federatedSecurity.isEmpty()) {
            writer.write("print '" + Messages.getString("Ldap_Security_Message") + ConfigGeneratorConstants.MESSAGE_END_PRINT);
            writer.write(federatedSecurity);
            writer.write(ConfigGeneratorConstants.NEW_LINE);
        }
        writer.write("print '" + Messages.getString("Auth_Alias_Script_Message") + ConfigGeneratorConstants.MESSAGE_END_PRINT);
        if (!auth.isEmpty()) {
            writer.write(ConfigGeneratorConstants.ADMIN_CONFIG_ASSIGN_GLOBAL_SECURITY_VAR);
        }
        writer.write(auth);
        writer.write(ConfigGeneratorConstants.NEW_LINE);
        if (!jndi.isEmpty()) {
            writer.write("print '" + Messages.getString("JNDI_Binding_Script_Message") + ConfigGeneratorConstants.MESSAGE_END_PRINT);
            writer.write(jndi);
            writer.write(ConfigGeneratorConstants.NEW_LINE);
        }
        writer.write("print '" + Messages.getString("Queue_Script_Message") + ConfigGeneratorConstants.MESSAGE_END_PRINT);
        writer.write(sib);
        writer.write(queue);
        writer.write(ConfigGeneratorConstants.NEW_LINE);
        writer.write("print '" + Messages.getString("Topic_Script_Message") + ConfigGeneratorConstants.MESSAGE_END_PRINT);
        writer.write(topic);
        writer.write(ConfigGeneratorConstants.NEW_LINE);
        writer.write("print '" + Messages.getString("Activation_Spec_Script_Message") + ConfigGeneratorConstants.MESSAGE_END_PRINT);
        writer.write(actSpecs);
        writer.write(ConfigGeneratorConstants.NEW_LINE);
        writer.write("print '" + Messages.getString("Connection_Factory_Script_Message") + ConfigGeneratorConstants.MESSAGE_END_PRINT);
        writer.write(cf);
        writer.write(ConfigGeneratorConstants.NEW_LINE);
        writer.write("print '" + Messages.getString("JDBC_Provider_Script_Message") + ConfigGeneratorConstants.MESSAGE_END_PRINT);
        writer.write(jdbc);
        writer.write(ConfigGeneratorConstants.NEW_LINE);
        writer.write("print '" + Messages.getString("Variable_Script_Message") + ConfigGeneratorConstants.MESSAGE_END_PRINT);
        String currentString = writer.toString();
        HashMap<String, Variable> allVariables = new HashMap<String, Variable>(this._variables);
        CommonUtilities.filterVariables(this._variables);
        if (ConfigManagerFactory.isMigrateAllConfig()) {
            this._usedVariables.addAll(this._variables.keySet());
        }
        CommonUtilities.getUsedVariablesFromString(this._usedVariables, currentString);
        this.findReferencedVariablesInValues();
        if (this._usedVariables.size() > 0) {
            StringBuilder buffer = new StringBuilder();
            for (String name2 : this._usedVariables) {
                Variable variable = this._variables.get(name2);
                if (variable != null) {
                    ReportUtility.logger.get().log(Level.FINEST, "Adding Variable to scripts: [" + variable.getSymbolicName() + ", " + variable.getValue() + "]");
                    buffer.append("AdminTask.setVariable(['-scope', 'Node=' + NodeName, '-variableName', '" + variable.getSymbolicName());
                    buffer.append("', '-variableValue', '" + variable.getValue());
                    buffer.append(ConfigGeneratorConstants.ADMIN_TASK_SET_VARIABLE_END);
                    continue;
                }
                if (allVariables.containsKey(name2) || !CommonUtilities.shouldWarnAboutMissingVar(name2)) {
                    ReportUtility.logger.get().log(Level.FINEST, "Variable: " + name2 + " is not being migrated.");
                    continue;
                }
                if (SensitiveDataHelper.getRegisteredVarKeys().contains(name2)) {
                    ReportUtility.logger.get().log(Level.FINEST, "Variable: " + name2 + " was created to replace sensitive data.");
                    continue;
                }
                ReportUtility.logger.get().warning(Messages.getFormattedMessage(Messages.getString("Unrecognized_Variable"), name2));
            }
            writer.write(buffer.toString());
        }
        writer.write(ConfigGeneratorConstants.NEW_LINE);
        if (this._scopeConflicts != null && !this._scopeConflicts.isEmpty()) {
            for (Variable var : allVariables.values()) {
                if (this._usedVariables.contains(var.getSymbolicName())) continue;
                ReportUtility.logger.get().log(Level.FINEST, "Removing unused variable from conflict list " + var.getSymbolicName());
                this._scopeConflicts.remove(var.getSymbolicName());
            }
            StringBuilder conflictMessage = new StringBuilder();
            for (String key : this._scopeConflicts.keySet()) {
                List conflictList = (List)this._scopeConflicts.get(key);
                CommonUtilities.logConflict(key, conflictList);
                conflictMessage.append("print '" + Messages.getFormattedMessage(Messages.getString("Conflict_Info_Message"), key, conflictList, conflictList.get(conflictList.size() - 1)) + ConfigGeneratorConstants.MESSAGE_END_PRINT);
            }
            if (conflictMessage.length() != 0) {
                writer.write(conflictMessage.toString());
                writer.write(ConfigGeneratorConstants.NEW_LINE);
            }
        }
        writer.write("print '" + Messages.getFormattedMessage(Messages.getString("Saving_Config_Script_Message"), new Object[0]) + ConfigGeneratorConstants.MESSAGE_END_PRINT);
        writer.write(ConfigGeneratorConstants.ADMIN_CONFIG_SAVE);
        writer.write("print '" + Messages.getFormattedMessage(Messages.getString("Application_Install_Script_Message"), new Object[0]) + ConfigGeneratorConstants.MESSAGE_END_PRINT);
        writer.write(appInstall);
        writer.write(ConfigGeneratorConstants.ADMIN_CONFIG_SAVE);
        return writer.toString();
    }

    @Override
    public String exportSensitiveData() throws Exception {
        return null;
    }

    @Override
    public String exportJvmOptions() {
        return null;
    }

    @Override
    public String exportMimeTypesData() throws Exception {
        return null;
    }

    private void findReferencedVariablesInValues() {
        HashSet<String> newVariables = new HashSet<String>();
        HashSet<String> lastVariables = new HashSet<String>();
        HashSet<String> toAdd = new HashSet<String>();
        lastVariables.addAll(this._usedVariables);
        do {
            for (String name2 : lastVariables) {
                Variable variable = this._variables.get(name2);
                if (variable == null) continue;
                CommonUtilities.getUsedVariablesFromString(toAdd, variable.getValue());
            }
            for (String add : toAdd) {
                if (this._usedVariables.contains(add)) continue;
                this._usedVariables.add(add);
                newVariables.add(add);
            }
            toAdd.clear();
            lastVariables = newVariables;
            newVariables = new HashSet();
        } while (lastVariables.size() > 0);
    }

    @Override
    public void setScopeConflicts(SortedMap<String, List<String>> conflicts) {
        this._scopeConflicts = conflicts;
    }

    @Override
    public void addMqQueueConnectionFactory(MqQueueConnectionFactory qcf, boolean isTwasSourceAppServer) {
        String wmqTransportType;
        String qmgrSvrconnChannel;
        String qmgrPortNumber;
        String qmgrHostName;
        String qmgrName;
        String clientId;
        String xaRecoveryAlias;
        String containerAuthDataAlias;
        String mappingConfigAlias;
        ReportUtility.logger.get().log(Level.FINEST, "Adding MqQueueConnectionFactory to TwasCommandBuilder: " + qcf.getName());
        String qcfVariable = "AdminConfigVar_" + this.commandCounter++;
        this._connectionFactoryBuffer.append(qcfVariable + "=AdminTask.createWMQConnectionFactory(");
        this._connectionFactoryBuffer.append("Node, [");
        this._connectionFactoryBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", qcf.getName()));
        this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("jndiName", qcf.getJndiName()));
        this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("type", "QCF"));
        String componentAuthAlias = qcf.getComponentAuthDataAlias();
        if (componentAuthAlias != null && !"".equals(componentAuthAlias)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("componentAuthAlias", componentAuthAlias));
        }
        if ((mappingConfigAlias = qcf.getMappingConfigAlias()) != null && !"".equals(mappingConfigAlias)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("mappingAlias", mappingConfigAlias));
        }
        if ((containerAuthDataAlias = qcf.getContainerAuthDataAlias()) != null && !"".equals(containerAuthDataAlias)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("containerAuthAlias", containerAuthDataAlias));
        }
        if ((xaRecoveryAlias = qcf.getXaRecoveryAuthAlias()) != null && !"".equals(xaRecoveryAlias)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("xaRecoveryAuthAlias", xaRecoveryAlias));
        }
        String string = clientId = qcf.getClientID() == null ? null : qcf.getClientID().getValue();
        if (clientId != null && !"".equals(clientId)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("clientId", clientId));
        }
        String string2 = qmgrName = qcf.getQueueManager() == null ? null : qcf.getQueueManager().getValue();
        if (qmgrName != null && !"".equals(qmgrName)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("qmgrName", qmgrName));
        }
        String string3 = qmgrHostName = qcf.getHost() == null ? null : qcf.getHost().getValue();
        if (qmgrHostName != null && !"".equals(qmgrHostName)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("qmgrHostname", qmgrHostName));
        }
        String string4 = qmgrPortNumber = qcf.getPort() == null ? null : qcf.getPort().getValue();
        if (qmgrPortNumber != null && !"".equals(qmgrPortNumber)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("qmgrPortNumber", qmgrPortNumber));
        }
        String string5 = qmgrSvrconnChannel = qcf.getChannel() == null ? null : qcf.getChannel().getValue();
        if (qmgrSvrconnChannel != null && !"".equals(qmgrSvrconnChannel)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("qmgrSvrconnChannel", qmgrSvrconnChannel));
        }
        if ((wmqTransportType = qcf.getTransportType()) != null && !"".equals(wmqTransportType)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("wmqTransportType", wmqTransportType));
        }
        this._connectionFactoryBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        this.generateConnectionPoolJython(qcf.getConnectionPool(), qcf.getName(), qcfVariable, this._connectionFactoryBuffer);
    }

    @Override
    public void addMqTopicConnectionFactory(MqTopicConnectionFactory tcf, boolean isTwasSourceAppServer) {
        String wmqTransportType;
        String qmgrSvrconnChannel;
        String qmgrPortNumber;
        String qmgrHostName;
        String qmgrName;
        String clientId;
        String xaRecoveryAlias;
        String containerAuthDataAlias;
        String mappingConfigAlias;
        ReportUtility.logger.get().log(Level.FINEST, "Adding MqTopicConnectionFactory to TwasCommandBuilder: " + tcf.getName());
        String tcfVariable = "AdminConfigVar_" + this.commandCounter++;
        this._connectionFactoryBuffer.append(tcfVariable + "=AdminTask.createWMQConnectionFactory(");
        this._connectionFactoryBuffer.append("Node, [");
        this._connectionFactoryBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", tcf.getName()));
        this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("jndiName", tcf.getJndiName()));
        this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("type", "TCF"));
        String componentAuthAlias = tcf.getComponentAuthDataAlias();
        if (componentAuthAlias != null && !"".equals(componentAuthAlias)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("componentAuthAlias", componentAuthAlias));
        }
        if ((mappingConfigAlias = tcf.getMappingConfigAlias()) != null && !"".equals(mappingConfigAlias)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("mappingAlias", mappingConfigAlias));
        }
        if ((containerAuthDataAlias = tcf.getContainerAuthDataAlias()) != null && !"".equals(containerAuthDataAlias)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("containerAuthAlias", containerAuthDataAlias));
        }
        if ((xaRecoveryAlias = tcf.getXaRecoveryAuthAlias()) != null && !"".equals(xaRecoveryAlias)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("xaRecoveryAuthAlias", xaRecoveryAlias));
        }
        String string = clientId = tcf.getClientID() == null ? null : tcf.getClientID().getValue();
        if (clientId != null && !"".equals(clientId)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("clientId", clientId));
        }
        String string2 = qmgrName = tcf.getQueueManager() == null ? null : tcf.getQueueManager().getValue();
        if (qmgrName != null && !"".equals(qmgrName)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("qmgrName", qmgrName));
        }
        String string3 = qmgrHostName = tcf.getHost() == null ? null : tcf.getHost().getValue();
        if (qmgrHostName != null && !"".equals(qmgrHostName)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("qmgrHostname", qmgrHostName));
        }
        String string4 = qmgrPortNumber = tcf.getPort() == null ? null : tcf.getPort().getValue();
        if (qmgrPortNumber != null && !"".equals(qmgrPortNumber)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("qmgrPortNumber", qmgrPortNumber));
        }
        String string5 = qmgrSvrconnChannel = tcf.getChannel() == null ? null : tcf.getChannel().getValue();
        if (qmgrSvrconnChannel != null && !"".equals(qmgrSvrconnChannel)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("qmgrSvrconnChannel", qmgrSvrconnChannel));
        }
        if ((wmqTransportType = tcf.getTransportType()) != null && !"".equals(wmqTransportType)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("wmqTransportType", wmqTransportType));
        }
        this._connectionFactoryBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        this.generateConnectionPoolJython(tcf.getConnectionPool(), tcf.getName(), tcfVariable, this._connectionFactoryBuffer);
    }

    @Override
    public void addMqConnectionFactory(MqConnectionFactory cf, boolean isTwasSourceAppServer) {
        String wmqTransportType;
        String qmgrSvrconnChannel;
        String qmgrPortNumber;
        String qmgrHostName;
        String qmgrName;
        String clientId;
        String xaRecoveryAlias;
        String containerAuthDataAlias;
        String mappingConfigAlias;
        ReportUtility.logger.get().log(Level.FINEST, "Adding MqConnectionFactory to TwasCommandBuilder: " + cf.getName());
        String cfVariable = "AdminConfigVar_" + this.commandCounter++;
        this._connectionFactoryBuffer.append(cfVariable + "=AdminTask.createWMQConnectionFactory(");
        this._connectionFactoryBuffer.append("Node, [");
        this._connectionFactoryBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", cf.getName()));
        this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("jndiName", cf.getJndiName()));
        this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("type", "CF"));
        String componentAuthAlias = cf.getComponentAuthDataAlias();
        if (componentAuthAlias != null && !"".equals(componentAuthAlias)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("componentAuthAlias", componentAuthAlias));
        }
        if ((mappingConfigAlias = cf.getMappingConfigAlias()) != null && !"".equals(mappingConfigAlias)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("mappingAlias", mappingConfigAlias));
        }
        if ((containerAuthDataAlias = cf.getContainerAuthDataAlias()) != null && !"".equals(containerAuthDataAlias)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("containerAuthAlias", containerAuthDataAlias));
        }
        if ((xaRecoveryAlias = cf.getXaRecoveryAuthAlias()) != null && !"".equals(xaRecoveryAlias)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("xaRecoveryAuthAlias", xaRecoveryAlias));
        }
        String string = clientId = cf.getClientID() == null ? null : cf.getClientID().getValue();
        if (clientId != null && !"".equals(clientId)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("clientId", clientId));
        }
        String string2 = qmgrName = cf.getQueueManager() == null ? null : cf.getQueueManager().getValue();
        if (qmgrName != null && !"".equals(qmgrName)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("qmgrName", qmgrName));
        }
        String string3 = qmgrHostName = cf.getHost() == null ? null : cf.getHost().getValue();
        if (qmgrHostName != null && !"".equals(qmgrHostName)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("qmgrHostname", qmgrHostName));
        }
        String string4 = qmgrPortNumber = cf.getPort() == null ? null : cf.getPort().getValue();
        if (qmgrPortNumber != null && !"".equals(qmgrPortNumber)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("qmgrPortNumber", qmgrPortNumber));
        }
        String string5 = qmgrSvrconnChannel = cf.getChannel() == null ? null : cf.getChannel().getValue();
        if (qmgrSvrconnChannel != null && !"".equals(qmgrSvrconnChannel)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("qmgrSvrconnChannel", qmgrSvrconnChannel));
        }
        if ((wmqTransportType = cf.getTransportType()) != null && !"".equals(wmqTransportType)) {
            this._connectionFactoryBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("wmqTransportType", wmqTransportType));
        }
        this._connectionFactoryBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        this.generateConnectionPoolJython(cf.getConnectionPool(), cf.getName(), cfVariable, this._connectionFactoryBuffer);
    }

    @Override
    public void addMqQueue(MqQueue queue) {
        String readAheadClose;
        String floatingPointEncoding;
        String useNativeEncoding;
        String description;
        String CCSID;
        String priority;
        String integerEncoding;
        String sendAsync;
        String decimalEncoding;
        String expiry;
        String readAhead;
        String useRFH2;
        String qmgr;
        String baseQueue;
        ReportUtility.logger.get().log(Level.FINEST, "Adding MqQueue to TwasCommandBuilder: " + queue.getName());
        this._jmsQueueBuffer.append("AdminTask.createWMQQueue(");
        this._jmsQueueBuffer.append("Node, [");
        this._jmsQueueBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", queue.getName()));
        this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("jndiName", queue.getJndiName()));
        String string = baseQueue = queue.getBaseQueueName() == null ? null : queue.getBaseQueueName().getValue();
        if (baseQueue != null && !"".equals(baseQueue)) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("queueName", baseQueue));
        }
        if ((qmgr = queue.getBaseQueueManagerName()) != null && !"".equals(qmgr)) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("qmgr", qmgr));
        }
        if ((useRFH2 = this.getWsadminValueForUseRFH2Twas(queue.getTargetClient())) != null && !"".equals(useRFH2)) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("useRFH2", useRFH2));
        }
        if ((readAhead = this.getWsadminValueForSendAsyncReadAheadTwas(queue.getReadAhead(), false)) != null && !"".equals(readAhead)) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("readAhead", readAhead));
        }
        if ((expiry = this.getWsadminValueForExpiryTwas(queue.getExpiry(), queue.getSpecifiedExpiry())) != null && !"".equals(expiry)) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("expiry", expiry));
        }
        if ((decimalEncoding = queue.getDecimalEncoding()) != null && !"".equals(decimalEncoding)) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("decimalEncoding", decimalEncoding));
        }
        if ((sendAsync = this.getWsadminValueForSendAsyncReadAheadTwas(queue.getSendAsync(), false)) != null && !"".equals(sendAsync)) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("sendAsync", sendAsync));
        }
        if ((integerEncoding = queue.getIntegerEncoding()) != null && !"".equals(integerEncoding)) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("integerEncoding", integerEncoding));
        }
        if ((priority = this.getWsadminValueForPriorityTwas(queue.getPriority(), queue.getSpecifiedPriority())) != null && !"".equals(priority)) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("priority", priority));
        }
        if ((CCSID = queue.getCCSID()) != null && !"".equals(CCSID)) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("ccsid", CCSID));
        }
        if ((description = queue.getDescription()) != null && !"".equals(description)) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("description", description));
        }
        if ((useNativeEncoding = queue.getUseNativeEncoding()) != null && !"".equals(useNativeEncoding)) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("useNativeEncoding", useNativeEncoding));
        }
        if ((floatingPointEncoding = this.getWsadminValueForFloatingPointEncodingTwas(queue.getFloatingPointEncoding())) != null && !"".equals(floatingPointEncoding)) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("floatingPointEncoding", floatingPointEncoding));
        }
        if ((readAheadClose = this.getWsadminValueForReadAheadCloseTwas(queue.getReadAheadClose())) != null && !"".equals(readAheadClose)) {
            this._jmsQueueBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("readAheadClose", readAheadClose));
        }
        this._jmsQueueBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
    }

    @Override
    public void addMqTopic(MqTopic topic) {
        String wildcardFormat;
        String useRFH2;
        String useNativeEncoding;
        String sendAsync;
        String readAheadClose;
        String readAhead;
        String priority;
        String persistence;
        String integerEncoding;
        String floatingPointEncoding;
        String expiry;
        String description;
        String decimalEncoding;
        String CCSID;
        String brokerVersion;
        String brokerPubQmgr;
        String brokerPubQueue;
        String brokerCCDurSubQueue;
        String brokerDurSubQueue;
        String baseTopic;
        ReportUtility.logger.get().log(Level.FINEST, "Adding MqTopic to TwasCommandBuilder: " + topic.getName());
        this._jmsTopicBuffer.append("AdminTask.createWMQTopic(");
        this._jmsTopicBuffer.append("Node, [");
        this._jmsTopicBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", topic.getName()));
        this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("jndiName", topic.getJndiName()));
        String string = baseTopic = topic.getBaseTopicName() == null ? null : topic.getBaseTopicName().getValue();
        if (baseTopic != null && !"".equals(baseTopic)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("topicName", baseTopic));
        }
        if ((brokerDurSubQueue = topic.getBrokerDurSubQueue()) != null && !"".equals(brokerDurSubQueue)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("brokerDurSubQueue", brokerDurSubQueue));
        }
        if ((brokerCCDurSubQueue = topic.getBrokerCCDurSubQueue()) != null && !"".equals(brokerCCDurSubQueue)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("brokerCCDurSubQueue", brokerCCDurSubQueue));
        }
        if ((brokerPubQueue = topic.getBrokerPubQueue()) != null && !"".equals(brokerPubQueue)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("brokerPubQueue", brokerPubQueue));
        }
        if ((brokerPubQmgr = topic.getBrokerPubQmgr()) != null && !"".equals(brokerPubQmgr)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("brokerPubQmgr", brokerPubQmgr));
        }
        if ((brokerVersion = topic.getBrokerVersion()) != null && !"".equals(brokerVersion)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("brokerVersion", brokerVersion));
        }
        if ((CCSID = topic.getCCSID()) != null && !"".equals(CCSID)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("ccsid", CCSID));
        }
        if ((decimalEncoding = topic.getDecimalEncoding()) != null && !"".equals(decimalEncoding)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("decimalEncoding", decimalEncoding));
        }
        if ((description = topic.getDescription()) != null && !"".equals(description)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("description", description));
        }
        if ((expiry = this.getWsadminValueForExpiryTwas(topic.getExpiry(), topic.getSpecifiedExpiry())) != null && !"".equals(expiry)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("expiry", expiry));
        }
        if ((floatingPointEncoding = this.getWsadminValueForFloatingPointEncodingTwas(topic.getFloatingPointEncoding())) != null && !"".equals(floatingPointEncoding)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("floatingPointEncoding", floatingPointEncoding));
        }
        if ((integerEncoding = topic.getIntegerEncoding()) != null && !"".equals(integerEncoding)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("integerEncoding", integerEncoding));
        }
        if ((persistence = this.getWsadminValueForPersistenceTwas(topic.getPersistence(), true)) != null && !"".equals(persistence)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("persistence", persistence));
        }
        if ((priority = this.getWsadminValueForPriorityTwas(topic.getPriority(), topic.getSpecifiedPriority())) != null && !"".equals(priority)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("priority", priority));
        }
        if ((readAhead = this.getWsadminValueForSendAsyncReadAheadTwas(topic.getReadAhead(), true)) != null && !"".equals(readAhead)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("readAhead", readAhead));
        }
        if ((readAheadClose = this.getWsadminValueForReadAheadCloseTwas(topic.getReadAheadClose())) != null && !"".equals(readAheadClose)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("readAheadClose", readAheadClose));
        }
        if ((sendAsync = this.getWsadminValueForSendAsyncReadAheadTwas(topic.getSendAsync(), true)) != null && !"".equals(sendAsync)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("sendAsync", sendAsync));
        }
        if ((useNativeEncoding = topic.getUseNativeEncoding()) != null && !"".equals(useNativeEncoding)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("useNativeEncoding", useNativeEncoding));
        }
        if ((useRFH2 = this.getWsadminValueForUseRFH2Twas(topic.getTargetClient())) != null && !"".equals(useRFH2)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("useRFH2", useRFH2));
        }
        if ((wildcardFormat = this.getWsadminValueForWildcardFormatTwas(topic.getWildcardFormat())) != null && !"".equals(wildcardFormat)) {
            this._jmsTopicBuffer.append(", " + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("wildcardFormat", wildcardFormat));
        }
        this._jmsTopicBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
    }

    private String getWsadminValueForPersistenceTwas(String tWasValue, boolean isTopic) {
        if (tWasValue == null) {
            return tWasValue;
        }
        if (tWasValue.equals("APPLICATION_DEFINED")) {
            return "APP";
        }
        if (tWasValue.equals("PERSISTENT")) {
            return "PERS";
        }
        if (tWasValue.equals("NONPERSISTENT")) {
            return "NON";
        }
        if (tWasValue.equals("QUEUE_DEFINED")) {
            if (isTopic) {
                return "TDEF";
            }
            return "QDEF";
        }
        return tWasValue;
    }

    private String getWsadminValueForPriorityTwas(String tWasValue, String tWasSpecifiedValue) {
        if (tWasValue == null) {
            return tWasValue;
        }
        if (tWasValue.equals("APPLICATION_DEFINED")) {
            return "APP";
        }
        if (tWasValue.equals("QUEUE_DEFINED")) {
            return "QDEF";
        }
        if (tWasValue.equals("SPECIFIED")) {
            return tWasSpecifiedValue;
        }
        return tWasValue;
    }

    private String getWsadminValueForExpiryTwas(String tWasValue, String tWasSpecifiedValue) {
        if (tWasValue == null) {
            return tWasValue;
        }
        if (tWasValue.equals("APPLICATION_DEFINED")) {
            return "APP";
        }
        if (tWasValue.equals("UNLIMITED")) {
            return "UNLIM";
        }
        if (tWasValue.equals("SPECIFIED")) {
            return tWasSpecifiedValue;
        }
        return tWasValue;
    }

    private String getWsadminValueForUseRFH2Twas(String targetClientValue) {
        if (targetClientValue == null) {
            return targetClientValue;
        }
        if (targetClientValue.equals("MQ")) {
            return "false";
        }
        return "true";
    }

    private String getWsadminValueForFloatingPointEncodingTwas(String tWasValue) {
        if (tWasValue == null) {
            return tWasValue;
        }
        if (tWasValue.equals("S390")) {
            return "z/OS";
        }
        return tWasValue;
    }

    private String getWsadminValueForSendAsyncReadAheadTwas(String tWasValue, boolean isTopic) {
        if (tWasValue == null) {
            return tWasValue;
        }
        if (tWasValue.equals("QUEUE_DEFINED")) {
            if (isTopic) {
                return "TDEF";
            }
            return "QDEF";
        }
        return tWasValue;
    }

    private String getWsadminValueForReadAheadCloseTwas(String tWasValue) {
        if (tWasValue == null) {
            return tWasValue;
        }
        if (tWasValue.equals("DELIVERALL")) {
            return "deliverAll";
        }
        if (tWasValue.equals("DELIVERCURRENT")) {
            return "deliverCurrent";
        }
        return tWasValue;
    }

    private String getWsadminValueForWildcardFormatTwas(String tWasValue) {
        if (tWasValue == null) {
            return tWasValue;
        }
        if (tWasValue.equals("characterWildcards")) {
            return "Char";
        }
        if (tWasValue.equals("topicWildcards")) {
            return "Topic";
        }
        return tWasValue;
    }

    @Override
    public void addMqResourceAdapter() {
    }

    @Override
    public void addResourceAdapter(SimpleResourceAdapter resourceAdapter) {
    }

    @Override
    public void addProcessDefinition(ProcessDefinition processDef) {
        List<Property> props;
        String genericJvmArguments;
        String maximumHeapSize;
        ReportUtility.logger.get().log(Level.FINEST, "Adding ProcessDefinition to server");
        if (this._processDefinitionBuffer.length() == 0) {
            this._processDefinitionBuffer.append("# " + Messages.getFormattedMessage(Messages.getString("JVM_Props_Source_Server_Message"), processDef.serverName) + ConfigGeneratorConstants.NEW_LINE);
        }
        StringBuilder jvmPropertiesBuilder = new StringBuilder();
        JvmEntry entry = processDef.getJvmEntries().get(0);
        jvmPropertiesBuilder.append("AdminTask.setJVMProperties(");
        jvmPropertiesBuilder.append("Server");
        jvmPropertiesBuilder.append(", [");
        String separator = "";
        String initialHeapSize = entry.getInitialHeapSize();
        if (initialHeapSize != null && !initialHeapSize.equals("")) {
            jvmPropertiesBuilder.append(separator + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("initialHeapSize", initialHeapSize));
            separator = ", ";
        }
        if ((maximumHeapSize = entry.getMaximumHeapSize()) != null && !maximumHeapSize.equals("")) {
            jvmPropertiesBuilder.append(separator + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("maximumHeapSize", maximumHeapSize));
            separator = ", ";
        }
        if (entry.getClasspath() != null && entry.getClasspath().size() > 0) {
            StringBuilder classpath = new StringBuilder();
            Iterator<String> it = entry.getClasspath().iterator();
            while (it.hasNext()) {
                classpath.append(it.next());
                if (!it.hasNext()) continue;
                classpath.append("\" \"");
            }
            jvmPropertiesBuilder.append(separator + TwasCommandBuilder.createAttributeKeyValuePairAdminTask("classpath", "'[\"" + classpath.toString() + "\"]'", false));
            separator = ", ";
        }
        jvmPropertiesBuilder.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        if (!separator.equals("")) {
            this._processDefinitionBuffer.append((CharSequence)jvmPropertiesBuilder);
        }
        if ((genericJvmArguments = entry.getGenericJvmArguments()) != null && !genericJvmArguments.equals("")) {
            jvmPropertiesBuilder = new StringBuilder();
            jvmPropertiesBuilder.append("AdminTask.setGenericJVMArguments(");
            jvmPropertiesBuilder.append("'[");
            jvmPropertiesBuilder.append("-nodeName ' + NodeName + ' -serverName server1 ");
            jvmPropertiesBuilder.append("-");
            jvmPropertiesBuilder.append("genericJvmArguments");
            jvmPropertiesBuilder.append(" \"");
            jvmPropertiesBuilder.append(genericJvmArguments);
            jvmPropertiesBuilder.append("\"");
            jvmPropertiesBuilder.append(ConfigGeneratorConstants.ADMIN_CONFIG_STRING_END);
            this._processDefinitionBuffer.append((CharSequence)jvmPropertiesBuilder);
        }
        if ((props = entry.getSystemProperties()) != null && props.size() > 0) {
            for (Property prop : props) {
                if (CommonUtilities.getJvmPropertyKeysIgnoreList().contains(prop.getName()) || CommonUtilities.getJvmPropertyKeysIgnoreIfOffList().contains(prop.getName()) && "off".equals(prop.getValue())) continue;
                this._processDefinitionBuffer.append("AdminTask.setJVMSystemProperties([");
                this._processDefinitionBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("propertyName", prop.getName()) + ", ");
                this._processDefinitionBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("propertyValue", prop.getValue()));
                this._processDefinitionBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
            }
        }
    }

    @Override
    public void addStandaloneLDAPUserRegistry(LDAPUserRegistry activeUserRegistry) {
        String ignoreCase;
        String sslEnabled;
        LDAPSearchFilter ldapSearchFilter;
        String reuseConnection;
        String searchTimeout;
        SensitiveData bindPassword;
        SensitiveData bindDN;
        String baseDN;
        SensitiveData primaryAdminId;
        SensitiveData serverIdPassword;
        String serverId;
        ReportUtility.logger.get().log(Level.FINEST, "Adding Standalone LDAP User Registry to script");
        if ("true".equals(activeUserRegistry.getSslEnabled())) {
            this._ldapSecurityBuffer.append("# " + Messages.getString("LDAP_Configured_With_SSL_Message") + ConfigGeneratorConstants.NEW_LINE);
        }
        this._ldapSecurityBuffer.append("AdminTask.configureAdminLDAPUserRegistry([");
        this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("verifyRegistry", "false", true, false));
        String ldapServerType = activeUserRegistry.getType();
        if (!"".equals(ldapServerType)) {
            this._ldapSecurityBuffer.append(", ");
            this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("ldapServerType", ldapServerType, true, false));
        }
        String useRegistryServerId = activeUserRegistry.getUseRegistryServerId();
        String autoGenerateServerId = "";
        if ("true".equals(useRegistryServerId.toLowerCase())) {
            autoGenerateServerId = "false";
        } else if ("false".equals(useRegistryServerId.toLowerCase())) {
            autoGenerateServerId = "true";
        }
        if (!"".equals(autoGenerateServerId)) {
            this._ldapSecurityBuffer.append(", ");
            this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("autoGenerateServerId", autoGenerateServerId, true, false));
        }
        if (!"".equals(serverId = activeUserRegistry.getServerId())) {
            this._ldapSecurityBuffer.append(", ");
            this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("serverId", serverId, true, false));
        }
        if ((serverIdPassword = activeUserRegistry.getServerPassword()) != null) {
            this._ldapSecurityBuffer.append(", ");
            this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("serverIdPassword", serverIdPassword.getVarName(), false, false));
        }
        if ((primaryAdminId = activeUserRegistry.getPrimaryAdminId()) != null) {
            this._ldapSecurityBuffer.append(", ");
            this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("primaryAdminId", primaryAdminId.getVarName(), false, false));
        }
        StringBuilder hosts = new StringBuilder();
        StringBuilder ports = new StringBuilder();
        for (EndPoint endpoint : activeUserRegistry.getHosts()) {
            if ("".equals(endpoint.getHost()) || "".equals(endpoint.getPort())) continue;
            if (hosts.length() > 0) {
                hosts.append(",");
                ports.append(",");
            }
            hosts.append(endpoint.getHost());
            ports.append(endpoint.getPort());
        }
        if (hosts.length() > 0) {
            this._ldapSecurityBuffer.append(", ");
            this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("ldapHost", hosts.toString(), true, false));
            this._ldapSecurityBuffer.append(", ");
            this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("ldapPort", ports.toString(), true, false));
        }
        if (!"".equals(baseDN = activeUserRegistry.getBaseDN())) {
            this._ldapSecurityBuffer.append(", ");
            this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("baseDN", baseDN, true, false));
        }
        if ((bindDN = activeUserRegistry.getBindDN()) != null) {
            this._ldapSecurityBuffer.append(", ");
            this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("bindDN", bindDN.getVarName(), false, false));
        }
        if ((bindPassword = activeUserRegistry.getBindPassword()) != null) {
            this._ldapSecurityBuffer.append(", ");
            this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("bindPassword", bindPassword.getVarName(), false, false));
        }
        if (!"".equals(searchTimeout = activeUserRegistry.getSearchTimeout())) {
            this._ldapSecurityBuffer.append(", ");
            this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("searchTimeout", searchTimeout, true, false));
        }
        if (!"".equals(reuseConnection = activeUserRegistry.getReuseConnection())) {
            this._ldapSecurityBuffer.append(", ");
            this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("reuseConnection", reuseConnection, true, false));
        }
        if ((ldapSearchFilter = activeUserRegistry.getSearchFilter()) != null) {
            String krbUserFilter;
            String certificateFilter;
            String certificateMapMode;
            String groupMemberIdMap;
            Object groupIdMap;
            String userIdMap;
            String groupFilter;
            String userFilter = ldapSearchFilter.getUserFilter();
            if (!"".equals(userFilter)) {
                this._ldapSecurityBuffer.append(", ");
                this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("userFilter", userFilter, true, false));
            }
            if (!"".equals(groupFilter = ldapSearchFilter.getGroupFilter())) {
                this._ldapSecurityBuffer.append(", ");
                this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("groupFilter", groupFilter, true, false));
            }
            if (!"".equals(userIdMap = ldapSearchFilter.getUserIdMap())) {
                this._ldapSecurityBuffer.append(", ");
                this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("userIdMap", userIdMap, true, false));
            }
            if (!"".equals(groupIdMap = ldapSearchFilter.getGroupIdMap())) {
                this._ldapSecurityBuffer.append(", ");
                this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("groupIdMap", (String)groupIdMap, true, false));
            }
            if (!"".equals(groupMemberIdMap = ldapSearchFilter.getGroupMemberIdMap())) {
                this._ldapSecurityBuffer.append(", ");
                this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("groupMemberIdMap", groupMemberIdMap, true, false));
            }
            if (!"".equals(certificateMapMode = ldapSearchFilter.getCertificateMapMode())) {
                this._ldapSecurityBuffer.append(", ");
                this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("certificateMapMode", certificateMapMode, true, false));
            }
            if (!"".equals(certificateFilter = ldapSearchFilter.getCertificateFilter())) {
                this._ldapSecurityBuffer.append(", ");
                this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("certificateFilter", certificateFilter, true, false));
            }
            if (!"".equals(krbUserFilter = ldapSearchFilter.getKrbUserFilter())) {
                this._ldapSecurityBuffer.append(", ");
                this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("krbUserFilter", krbUserFilter, true, false));
            }
        }
        if (!"".equals(sslEnabled = activeUserRegistry.getSslEnabled())) {
            this._ldapSecurityBuffer.append(", ");
            this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("sslEnabled", sslEnabled, true, false));
        }
        StringBuilder customPropsStringBuilder = new StringBuilder();
        List<Property> customProperties = activeUserRegistry.getProperties();
        if (customProperties != null && customProperties.size() > 0) {
            for (Property prop : customProperties) {
                if (customPropsStringBuilder.length() == 0) {
                    customPropsStringBuilder.append("[\"");
                } else {
                    customPropsStringBuilder.append("\",\"");
                }
                String name2 = prop.getName();
                String value = prop.getValue();
                customPropsStringBuilder.append(name2 + "=" + value);
            }
            customPropsStringBuilder.append("\"]");
            this._ldapSecurityBuffer.append(", ");
            this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("customProperties", customPropsStringBuilder.toString(), true, false));
        }
        if (!"".equals(ignoreCase = activeUserRegistry.getIgnoreCase())) {
            this._ldapSecurityBuffer.append(", ");
            this._ldapSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("ignoreCase", ignoreCase, true, false));
        }
        this._ldapSecurityBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        this.addSecurityEnabled(this._ldapSecurityBuffer, "LDAPUserRegistry");
    }

    @Override
    public void addFederatedUserRegistries(WIMUserRegistry activeUserRegistry) {
        SensitiveData primaryAdminId;
        SensitiveData serverIdPassword;
        String serverId;
        if (this.isAnySslConfigured(activeUserRegistry)) {
            this._federatedSecurityBuffer.append("# " + Messages.getString("LDAP_Configured_With_SSL_Message") + ConfigGeneratorConstants.NEW_LINE);
        }
        WimConfig activeWimConfig = activeUserRegistry.getWimConfig();
        List<LdapRepository> repos = activeWimConfig.getRepositories();
        boolean addSecurityEnabled = false;
        ArrayList<MappedData> supportedBaseEntries = new ArrayList<MappedData>();
        if (repos != null) {
            Realm defaultRealm;
            for (LdapRepository repo : repos) {
                ContextPool contextPool;
                CacheConfiguration cacheConfiguration;
                List<LdapEntityType> entityTypes;
                AttributeConfiguration attributeConfiguration;
                List<BaseEntry> baseEntries;
                Object bindPassword;
                String returnToPrimaryServer;
                LdapServerConfiguration repoConfig;
                String primaryServerQueryTimeInterval;
                List<String> loginProperties;
                String certificateMapMode;
                String ldapServerType;
                if (repo == null) continue;
                this._federatedSecurityBuffer.append("AdminTask.createIdMgrLDAPRepository([");
                String id = repo.getId();
                if (!"".equals(id)) {
                    this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
                }
                if ((ldapServerType = repo.getLdapServerType()) != null && !"".equals(ldapServerType) && !"IDS51".equals(ldapServerType)) {
                    this._federatedSecurityBuffer.append(", ");
                    this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("ldapServerType", ldapServerType, true, false));
                }
                if ((certificateMapMode = repo.getCertificateMapMode()) != null && !"".equals(certificateMapMode) && !"exactdn".equals(certificateMapMode)) {
                    String certificateFilter;
                    this._federatedSecurityBuffer.append(", ");
                    this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("certificateMapMode", certificateMapMode, true, false));
                    if ("certificateFilter".equals(certificateMapMode) && (certificateFilter = repo.getCertificateFilter()) != null && "" != certificateFilter) {
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("certificateFilter", certificateFilter, true, false));
                    }
                }
                if ((loginProperties = repo.getLoginProperties()) != null && !loginProperties.isEmpty()) {
                    String loginPropertiesString = CommonUtilities.joinStrings((CharSequence)";", loginProperties);
                    this._federatedSecurityBuffer.append(", ");
                    this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("loginProperties", loginPropertiesString, true, false));
                }
                if ((primaryServerQueryTimeInterval = (repoConfig = repo.getLdapServerConfiguration()).getPrimaryServerQueryTimeInterval()) != null && !"".equals(primaryServerQueryTimeInterval)) {
                    this._federatedSecurityBuffer.append(", ");
                    this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("primaryServerQueryTimeInterval", primaryServerQueryTimeInterval, true, false));
                }
                if ((returnToPrimaryServer = repoConfig.getReturnToPrimaryServer()) != null && !"".equals(returnToPrimaryServer)) {
                    this._federatedSecurityBuffer.append(", ");
                    this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("returnToPrimaryServer", returnToPrimaryServer, true, false));
                }
                this._federatedSecurityBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
                List<LdapServer> servers = repoConfig.getLdapServers();
                if (servers != null && !servers.isEmpty()) {
                    for (LdapServer ldapServer : servers) {
                        String sslEnabled;
                        String referal;
                        String derefAliases;
                        String connectTimeout;
                        SensitiveData bindDN;
                        String primaryHost = null;
                        this._federatedSecurityBuffer.append("AdminTask.addIdMgrLDAPServer([");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
                        List<Connection> connections = ldapServer.getConnections();
                        if (connections != null && !connections.isEmpty()) {
                            Connection primary = connections.get(0);
                            MappedData host = primary.getHost();
                            String hostString = "";
                            if (host != null) {
                                primaryHost = hostString = host.getValue();
                            }
                            MappedData port = primary.getPort();
                            String portString = "";
                            if (port != null) {
                                portString = port.getValue();
                            }
                            this._federatedSecurityBuffer.append(", ");
                            this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("host", hostString, true, false));
                            if (!portString.equals("")) {
                                this._federatedSecurityBuffer.append(", ");
                                this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("port", portString, true, false));
                            }
                        }
                        if ((bindDN = ldapServer.getBindDN()) != null) {
                            this._federatedSecurityBuffer.append(", ");
                            this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("bindDN", bindDN.getVarName(), false, false));
                        }
                        if ((bindPassword = ldapServer.getBindPassword()) != null) {
                            this._federatedSecurityBuffer.append(", ");
                            this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("bindPassword", ((SensitiveData)bindPassword).getVarName(), false, false));
                        }
                        if ((connectTimeout = ldapServer.getConnectTimeout()) != null && !connectTimeout.equals("") && !connectTimeout.equals("20")) {
                            this._federatedSecurityBuffer.append(", ");
                            this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("connectTimeout", connectTimeout, true, false));
                        }
                        if ((derefAliases = ldapServer.getDerefAliases()) != null && !derefAliases.equals("") && !derefAliases.equals("always")) {
                            this._federatedSecurityBuffer.append(", ");
                            this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("derefAliases", derefAliases, true, false));
                        }
                        if ((referal = ldapServer.getReferal()) != null && !referal.equals("") && !referal.equals("ignore")) {
                            this._federatedSecurityBuffer.append(", ");
                            this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("referal", referal, true, false));
                        }
                        if ((sslEnabled = ldapServer.getSslEnabled()) != null && !sslEnabled.equals("") && !sslEnabled.toLowerCase().equals("false")) {
                            this._federatedSecurityBuffer.append(", ");
                            this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("sslEnabled", sslEnabled, true, false));
                        }
                        this._federatedSecurityBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
                        if (connections == null || connections.size() <= 1) continue;
                        for (Connection conn : connections.subList(1, connections.size())) {
                            if (conn == null) continue;
                            MappedData host = conn.getHost();
                            String hostString = "";
                            if (host != null) {
                                hostString = host.getValue();
                            }
                            MappedData port = conn.getPort();
                            String portString = "";
                            if (port != null) {
                                portString = port.getValue();
                            }
                            if (!hostString.equals("")) {
                                this._federatedSecurityBuffer.append("AdminTask.addIdMgrLDAPBackupServer([");
                                this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
                                this._federatedSecurityBuffer.append(", ");
                                this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("primary_host", primaryHost, true, false));
                                this._federatedSecurityBuffer.append(", ");
                                this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("host", hostString, true, false));
                                if (!portString.equals("")) {
                                    this._federatedSecurityBuffer.append(", ");
                                    this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("port", portString, true, false));
                                }
                            }
                            this._federatedSecurityBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
                        }
                    }
                }
                if ((baseEntries = repo.getBaseEntries()) != null) {
                    for (BaseEntry baseEntry : baseEntries) {
                        String nameInRepository;
                        if (baseEntry == null) continue;
                        this._federatedSecurityBuffer.append("AdminTask.addIdMgrRepositoryBaseEntry([");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
                        MappedData name2 = baseEntry.getName();
                        if (name2 != null && !"".equals(name2.getValue())) {
                            this._federatedSecurityBuffer.append(", ");
                            this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", name2.getValue(), true, false));
                        }
                        if ((nameInRepository = baseEntry.getNameInRepository()) != null && !"".equals(nameInRepository)) {
                            this._federatedSecurityBuffer.append(", ");
                            this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("nameInRepository", nameInRepository, true, false));
                        }
                        this._federatedSecurityBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
                        supportedBaseEntries.add(baseEntry.getName());
                    }
                }
                if ((attributeConfiguration = repo.getAttributeConfiguration()) != null) {
                    List<Attribute> attributes = attributeConfiguration.getAttributes();
                    if (attributes != null) {
                        for (Attribute attribute : attributes) {
                            if (attribute == null) continue;
                            this._federatedSecurityBuffer.append(this.getCommandsToSetFederatedLdapAttribute(attribute, id, ldapServerType));
                        }
                    }
                    this._federatedSecurityBuffer.append(this.getCommandsToRemoveUnusedFederatedLdapAttributes(attributes, id, ldapServerType));
                }
                if ((entityTypes = repo.getLdapEntityTypes()) != null) {
                    for (LdapEntityType entityType : entityTypes) {
                        if (entityType == null) continue;
                        this._federatedSecurityBuffer.append(this.getCommandsToSetFederatedLdapEntityTypes(entityType, id, ldapServerType));
                    }
                }
                this._federatedSecurityBuffer.append(this.getCommandsToRemoveUnusedFederatedLdapEntityTypes(entityTypes, id, ldapServerType));
                GroupConfiguration groupConfiguration = repo.getGroupConfiguration();
                if (groupConfiguration != null) {
                    List<MemberAttribute> memberAttributes = groupConfiguration.getMemberAttributes();
                    if (memberAttributes != null) {
                        bindPassword = memberAttributes.iterator();
                        while (bindPassword.hasNext()) {
                            MemberAttribute memberAttribute = bindPassword.next();
                            if (memberAttribute == null) continue;
                            this._federatedSecurityBuffer.append(this.getCommandsToSetFederatedLdapGroupMemberAttribute(memberAttribute, id, ldapServerType));
                        }
                    }
                    this._federatedSecurityBuffer.append(this.getCommandsToRemoveUnusedFederatedLdapGroupMemberAttribute(memberAttributes, id, ldapServerType));
                    List<MembershipAttribute> membershipAttributes = groupConfiguration.getMembershipAttribute();
                    String name3 = "";
                    String scope = "direct";
                    if (membershipAttributes != null && !membershipAttributes.isEmpty()) {
                        MembershipAttribute attr = membershipAttributes.get(0);
                        if (name3 != null) {
                            name3 = attr.getName();
                        }
                        if (scope != null) {
                            scope = attr.getScope();
                        }
                    }
                    if (ldapServerType.equals("AD") || ldapServerType.equals("ADAM")) {
                        if (!name3.equals("memberof") || !scope.equals("direct")) {
                            this._federatedSecurityBuffer.append("AdminTask.setIdMgrLDAPGroupConfig([");
                            this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
                            if (!name3.equals("memberof")) {
                                this._federatedSecurityBuffer.append(", ");
                                this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", name3, true, false));
                            }
                            if (!scope.equals("direct")) {
                                this._federatedSecurityBuffer.append(", ");
                                this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("scope", scope, true, false));
                            }
                            this._federatedSecurityBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
                        }
                    } else if (!name3.equals("") || !scope.equals("direct")) {
                        this._federatedSecurityBuffer.append("AdminTask.setIdMgrLDAPGroupConfig([");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
                        if (!name3.equals("")) {
                            this._federatedSecurityBuffer.append(", ");
                            this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", name3, true, false));
                        }
                        if (!scope.equals("direct")) {
                            this._federatedSecurityBuffer.append(", ");
                            this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("scope", scope, true, false));
                        }
                        this._federatedSecurityBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
                    }
                }
                if ((cacheConfiguration = repo.getCacheConfiguration()) != null) {
                    SearchResultsCache searchResultsCache;
                    String enabled;
                    String cacheTimeOut;
                    String cacheSize;
                    AttributesCache attributesCache = cacheConfiguration.getAttributesCache();
                    if (attributesCache != null) {
                        boolean nonDefault = false;
                        StringBuilder attributesCacheBuffer = new StringBuilder();
                        attributesCacheBuffer.append("AdminTask.setIdMgrLDAPAttrCache([");
                        attributesCacheBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
                        String attributeSizeLimit = attributesCache.getAttributeSizeLimit();
                        if (attributeSizeLimit != null && !"".equals(attributeSizeLimit) && !"2000".equals(attributeSizeLimit)) {
                            attributesCacheBuffer.append(", ");
                            attributesCacheBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("attributeSizeLimit", attributeSizeLimit, true, false));
                            nonDefault = true;
                        }
                        if ((cacheSize = attributesCache.getCacheSize()) != null && !"".equals(cacheSize) && !"4000".equals(cacheSize)) {
                            attributesCacheBuffer.append(", ");
                            attributesCacheBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("cacheSize", cacheSize, true, false));
                            nonDefault = true;
                        }
                        if ((cacheTimeOut = attributesCache.getCacheTimeOut()) != null && !"".equals(cacheTimeOut) && !"1200".equals(cacheTimeOut)) {
                            attributesCacheBuffer.append(", ");
                            attributesCacheBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("cacheTimeOut", cacheTimeOut, true, false));
                            nonDefault = true;
                        }
                        if ((enabled = attributesCache.getEnabled()) != null && !"".equals(enabled) && !"true".equals(enabled.toLowerCase())) {
                            attributesCacheBuffer.append(", ");
                            attributesCacheBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("enabled", enabled, true, false));
                            nonDefault = true;
                        }
                        attributesCacheBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
                        if (nonDefault) {
                            this._federatedSecurityBuffer.append((CharSequence)attributesCacheBuffer);
                        }
                    }
                    if ((searchResultsCache = cacheConfiguration.getSearchResultsCache()) != null) {
                        String searchResultSizeLimit;
                        boolean nonDefault = false;
                        StringBuilder searchResultsCacheBuffer = new StringBuilder();
                        searchResultsCacheBuffer.append("AdminTask.setIdMgrLDAPSearchResultsCache([");
                        searchResultsCacheBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
                        cacheSize = searchResultsCache.getCacheSize();
                        if (cacheSize != null && !"".equals(cacheSize) && !"2000".equals(cacheSize)) {
                            searchResultsCacheBuffer.append(", ");
                            searchResultsCacheBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("cacheSize", cacheSize, true, false));
                            nonDefault = true;
                        }
                        if ((cacheTimeOut = searchResultsCache.getCacheTimeOut()) != null && !"".equals(cacheTimeOut) && !"600".equals(cacheTimeOut)) {
                            searchResultsCacheBuffer.append(", ");
                            searchResultsCacheBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("cacheTimeOut", cacheTimeOut, true, false));
                            nonDefault = true;
                        }
                        if ((enabled = searchResultsCache.getEnabled()) != null && !"".equals(enabled) && !"true".equals(enabled.toLowerCase())) {
                            searchResultsCacheBuffer.append(", ");
                            searchResultsCacheBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("enabled", enabled, true, false));
                            nonDefault = true;
                        }
                        if ((searchResultSizeLimit = searchResultsCache.getSearchResultSizeLimit()) != null && !"".equals(searchResultSizeLimit) && !"1000".equals(searchResultSizeLimit)) {
                            searchResultsCacheBuffer.append(", ");
                            searchResultsCacheBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("searchResultSizeLimit", searchResultSizeLimit, true, false));
                            nonDefault = true;
                        }
                        searchResultsCacheBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
                        if (nonDefault) {
                            this._federatedSecurityBuffer.append((CharSequence)searchResultsCacheBuffer);
                        }
                    }
                }
                if ((contextPool = repo.getContextPool()) != null) {
                    String poolWaitTime;
                    String poolTimeOut;
                    String prefPoolSize;
                    String maxPoolSize;
                    String initPoolSize;
                    boolean nonDefault = false;
                    StringBuilder contextPoolBuffer = new StringBuilder();
                    contextPoolBuffer.append("AdminTask.setIdMgrLDAPContextPool([");
                    contextPoolBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
                    String poolEnabled = contextPool.getEnabled();
                    if (poolEnabled != null && !"".equals(poolEnabled) && !"true".equals(poolEnabled.toLowerCase())) {
                        contextPoolBuffer.append(", ");
                        contextPoolBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("enabled", poolEnabled, true, false));
                        nonDefault = true;
                    }
                    if ((initPoolSize = contextPool.getInitPoolSize()) != null && !"".equals(initPoolSize) && !"1".equals(initPoolSize)) {
                        contextPoolBuffer.append(", ");
                        contextPoolBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("initPoolSize", initPoolSize, true, false));
                        nonDefault = true;
                    }
                    if ((maxPoolSize = contextPool.getMaxPoolSize()) != null && !"".equals(maxPoolSize) && !"0".equals(maxPoolSize)) {
                        contextPoolBuffer.append(", ");
                        contextPoolBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("maxPoolSize", maxPoolSize, true, false));
                        nonDefault = true;
                    }
                    if ((prefPoolSize = contextPool.getPrefPoolSize()) != null && !"".equals(prefPoolSize) && !"3".equals(prefPoolSize)) {
                        contextPoolBuffer.append(", ");
                        contextPoolBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("prefPoolSize", prefPoolSize, true, false));
                        nonDefault = true;
                    }
                    if ((poolTimeOut = contextPool.getPoolTimeOut()) != null && !"".equals(poolTimeOut) && !"0".equals(poolTimeOut)) {
                        contextPoolBuffer.append(", ");
                        contextPoolBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("poolTimeOut", poolTimeOut, true, false));
                        nonDefault = true;
                    }
                    if ((poolWaitTime = contextPool.getPoolWaitTime()) != null && !"".equals(poolWaitTime) && !"3000".equals(poolWaitTime)) {
                        contextPoolBuffer.append(", ");
                        contextPoolBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("poolWaitTime", poolWaitTime, true, false));
                        nonDefault = true;
                    }
                    contextPoolBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
                    if (nonDefault) {
                        this._federatedSecurityBuffer.append((CharSequence)contextPoolBuffer);
                    }
                }
                this._federatedSecurityBuffer.append(ConfigGeneratorConstants.NEW_LINE);
                addSecurityEnabled = true;
            }
            for (MappedData baseEntry : supportedBaseEntries) {
                if (baseEntry == null) continue;
                this._federatedSecurityBuffer.append("AdminTask.addIdMgrRealmBaseEntry([");
                this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", "defaultWIMFileBasedRealm", true, false));
                this._federatedSecurityBuffer.append(", ");
                this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("baseEntry", baseEntry.getValue(), true, false));
                this._federatedSecurityBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
            }
            RealmConfiguration realmConfig = activeWimConfig.getRealmConfiguration();
            if (realmConfig != null && (defaultRealm = realmConfig.getDefaultRealm()) != null) {
                PropertyMapping propertyMapping;
                PropertyMapping groupSecurityName;
                PropertyMapping uniqueGroupId;
                PropertyMapping userDisplayName;
                PropertyMapping userSecurityName;
                PropertyMapping uniqueUserId;
                boolean changeDelimiter = false;
                String delimiter = defaultRealm.getDelimiter();
                if (delimiter != null && !"".equals(delimiter) && !delimiter.equals("/")) {
                    changeDelimiter = true;
                }
                boolean changeRepoDown = false;
                String allowOperationIfReposDown = defaultRealm.getAllowOpIfRepoDown();
                if (allowOperationIfReposDown != null && !"".equals(allowOperationIfReposDown) && !"false".equals(allowOperationIfReposDown.toLowerCase())) {
                    changeRepoDown = true;
                }
                if (changeDelimiter || changeRepoDown) {
                    this._federatedSecurityBuffer.append("AdminTask.updateIdMgrRealm([");
                    this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", "defaultWIMFileBasedRealm", true, false));
                    if (changeDelimiter) {
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("delimiter", delimiter, true, false));
                    }
                    if (changeRepoDown) {
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("allowOperationIfReposDown", allowOperationIfReposDown, true, false));
                    }
                    this._federatedSecurityBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
                }
                if ((uniqueUserId = defaultRealm.getUniqueUserIdMapping()) != null) {
                    String propertyForOutput;
                    boolean changeMapping = false;
                    String propertyForInput = uniqueUserId.getPropertyForInput();
                    if (propertyForInput != null && !"".equals(propertyForInput) && !propertyForInput.equals("uniqueName")) {
                        changeMapping = true;
                    }
                    if ((propertyForOutput = uniqueUserId.getPropertyForOutput()) != null && !"".equals(propertyForOutput) && !propertyForOutput.equals("uniqueName")) {
                        changeMapping = true;
                    }
                    if (changeMapping) {
                        this._federatedSecurityBuffer.append("AdminTask.setIdMgrRealmURAttrMapping([");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", "defaultWIMFileBasedRealm", true, false));
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("URAttrName", "uniqueUserId", true, false));
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("propertyForInput", propertyForInput, true, false));
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("propertyForOutput", propertyForOutput, true, false));
                        this._federatedSecurityBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
                    }
                }
                if ((userSecurityName = defaultRealm.getUserSecurityNameMapping()) != null) {
                    String propertyForOutput;
                    boolean changeMapping = false;
                    String propertyForInput = userSecurityName.getPropertyForInput();
                    if (propertyForInput != null && !"".equals(propertyForInput) && !propertyForInput.equals("principalName")) {
                        changeMapping = true;
                    }
                    if ((propertyForOutput = userSecurityName.getPropertyForOutput()) != null && !"".equals(propertyForOutput) && !propertyForOutput.equals("principalName")) {
                        changeMapping = true;
                    }
                    if (changeMapping) {
                        this._federatedSecurityBuffer.append("AdminTask.setIdMgrRealmURAttrMapping([");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", "defaultWIMFileBasedRealm", true, false));
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("URAttrName", "userSecurityName", true, false));
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("propertyForInput", propertyForInput, true, false));
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("propertyForOutput", propertyForOutput, true, false));
                        this._federatedSecurityBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
                    }
                }
                if ((userDisplayName = defaultRealm.getUserDisplayNameMapping()) != null) {
                    String string;
                    boolean changeMapping = false;
                    String propertyForInput = userDisplayName.getPropertyForInput();
                    if (propertyForInput != null && !"".equals(propertyForInput) && !propertyForInput.equals("principalName")) {
                        changeMapping = true;
                    }
                    if ((string = userDisplayName.getPropertyForOutput()) != null && !"".equals(string) && !string.equals("principalName")) {
                        changeMapping = true;
                    }
                    if (changeMapping) {
                        this._federatedSecurityBuffer.append("AdminTask.setIdMgrRealmURAttrMapping([");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", "defaultWIMFileBasedRealm", true, false));
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("URAttrName", "userDisplayName", true, false));
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("propertyForInput", propertyForInput, true, false));
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("propertyForOutput", string, true, false));
                        this._federatedSecurityBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
                    }
                }
                if ((uniqueGroupId = defaultRealm.getUniqueGroupIdMapping()) != null) {
                    String propertyForOutput;
                    boolean changeMapping = false;
                    String string = uniqueGroupId.getPropertyForInput();
                    if (string != null && !"".equals(string) && !string.equals("uniqueName")) {
                        changeMapping = true;
                    }
                    if ((propertyForOutput = uniqueGroupId.getPropertyForOutput()) != null && !"".equals(propertyForOutput) && !propertyForOutput.equals("uniqueName")) {
                        changeMapping = true;
                    }
                    if (changeMapping) {
                        this._federatedSecurityBuffer.append("AdminTask.setIdMgrRealmURAttrMapping([");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", "defaultWIMFileBasedRealm", true, false));
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("URAttrName", "uniqueGroupId", true, false));
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("propertyForInput", string, true, false));
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("propertyForOutput", propertyForOutput, true, false));
                        this._federatedSecurityBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
                    }
                }
                if ((groupSecurityName = defaultRealm.getGroupSecurityNameMapping()) != null) {
                    boolean bl;
                    String propertyForOutput;
                    boolean bl2 = false;
                    String propertyForInput = groupSecurityName.getPropertyForInput();
                    if (propertyForInput != null && !"".equals(propertyForInput) && !propertyForInput.equals("cn")) {
                        boolean bl3 = true;
                    }
                    if ((propertyForOutput = groupSecurityName.getPropertyForOutput()) != null && !"".equals(propertyForOutput) && !propertyForOutput.equals("cn")) {
                        bl = true;
                    }
                    if (bl) {
                        this._federatedSecurityBuffer.append("AdminTask.setIdMgrRealmURAttrMapping([");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", "defaultWIMFileBasedRealm", true, false));
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("URAttrName", "groupSecurityName", true, false));
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("propertyForInput", propertyForInput, true, false));
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("propertyForOutput", propertyForOutput, true, false));
                        this._federatedSecurityBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
                    }
                }
                if ((propertyMapping = defaultRealm.getGroupDisplayNameMapping()) != null) {
                    String propertyForOutput;
                    boolean changeMapping = false;
                    String propertyForInput = propertyMapping.getPropertyForInput();
                    if (propertyForInput != null && !"".equals(propertyForInput) && !propertyForInput.equals("cn")) {
                        changeMapping = true;
                    }
                    if ((propertyForOutput = propertyMapping.getPropertyForOutput()) != null && !"".equals(propertyForOutput) && !propertyForOutput.equals("cn")) {
                        changeMapping = true;
                    }
                    if (changeMapping) {
                        this._federatedSecurityBuffer.append("AdminTask.setIdMgrRealmURAttrMapping([");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", "defaultWIMFileBasedRealm", true, false));
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("URAttrName", "groupDisplayName", true, false));
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("propertyForInput", propertyForInput, true, false));
                        this._federatedSecurityBuffer.append(", ");
                        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("propertyForOutput", propertyForOutput, true, false));
                        this._federatedSecurityBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
                    }
                }
            }
        }
        this._federatedSecurityBuffer.append("AdminTask.configureAdminWIMUserRegistry([");
        this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("verifyRegistry", "false", true, false));
        String useRegistryServerId = activeUserRegistry.getUseRegistryServerId();
        String autoGenerateServerId = "";
        if ("true".equals(useRegistryServerId.toLowerCase())) {
            autoGenerateServerId = "false";
        } else if ("false".equals(useRegistryServerId.toLowerCase())) {
            autoGenerateServerId = "true";
        }
        if (!"".equals(autoGenerateServerId)) {
            this._federatedSecurityBuffer.append(", ");
            this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("autoGenerateServerId", autoGenerateServerId, true, false));
        }
        if (!"".equals(serverId = activeUserRegistry.getServerId())) {
            this._federatedSecurityBuffer.append(", ");
            this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("serverId", serverId, true, false));
        }
        if ((serverIdPassword = activeUserRegistry.getServerPassword()) != null) {
            this._federatedSecurityBuffer.append(", ");
            this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("serverIdPassword", serverIdPassword.getVarName(), false, false));
        }
        if ((primaryAdminId = activeUserRegistry.getPrimaryAdminId()) != null) {
            this._federatedSecurityBuffer.append(", ");
            this._federatedSecurityBuffer.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("primaryAdminId", primaryAdminId.getVarName(), false, false));
        }
        this._federatedSecurityBuffer.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        if (addSecurityEnabled) {
            this.addSecurityEnabled(this._federatedSecurityBuffer, "WIMUserRegistry");
        }
    }

    private void addSecurityEnabled(StringBuilder securityStringBuilder, String activeUserRegistry) {
        securityStringBuilder.append("AdminTask.setAdminActiveSecuritySettings([");
        securityStringBuilder.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("enableGlobalSecurity", "true", true, false));
        securityStringBuilder.append(", ");
        securityStringBuilder.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("appSecurityEnabled", "true", true, false));
        securityStringBuilder.append(", ");
        securityStringBuilder.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("activeUserRegistry", activeUserRegistry, true, false));
        securityStringBuilder.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
    }

    public boolean isAnySslConfigured(WIMUserRegistry activeUserRegistry) {
        try {
            WimConfig wimConfig = activeUserRegistry.getWimConfig();
            List<LdapRepository> repositories = wimConfig.getRepositories();
            for (LdapRepository repo : repositories) {
                try {
                    LdapServerConfiguration ldapConfig = repo.getLdapServerConfiguration();
                    List<LdapServer> servers = ldapConfig.getLdapServers();
                    for (LdapServer server : servers) {
                        try {
                            if (!"true".equals(server.getSslEnabled().toLowerCase())) continue;
                            return true;
                        }
                        catch (NullPointerException e) {
                            ReportUtility.logger.get().log(Level.FINEST, "Exception details:", e);
                        }
                    }
                }
                catch (NullPointerException e) {
                    ReportUtility.logger.get().log(Level.FINEST, "Exception details:", e);
                }
            }
        }
        catch (NullPointerException e) {
            ReportUtility.logger.get().log(Level.FINE, "Could not determine if active WIMUserRegistry has SSL configured.");
            ReportUtility.logger.get().log(Level.FINEST, "Exception details:", e);
        }
        return false;
    }

    private String getCommandsToSetFederatedLdapAttribute(Attribute attr, String id, String ldapType) {
        List<String> entityTypes;
        String propertyName;
        String name2;
        StringBuilder attrCommands = new StringBuilder();
        boolean deleteExisting = false;
        boolean addAttribute = false;
        Attribute conflictingDefault = null;
        if (standardDefaultLDAPAttributesTypes.contains(ldapType)) {
            conflictingDefault = this.conflictingAttribute(attr, standardDefaultLDAPAttributes);
            if (null != conflictingDefault && !this.isAttributeDefault(attr, standardDefaultLDAPAttributes)) {
                deleteExisting = true;
                addAttribute = true;
            } else if (null == conflictingDefault) {
                deleteExisting = false;
                addAttribute = true;
            }
        } else if (adDefaultLDAPAttributesTypes.contains(ldapType)) {
            conflictingDefault = this.conflictingAttribute(attr, adDefaultLDAPAttributes);
            if (null != conflictingDefault && !this.isAttributeDefault(attr, adDefaultLDAPAttributes)) {
                deleteExisting = true;
                addAttribute = true;
            } else if (null == conflictingDefault) {
                deleteExisting = false;
                addAttribute = true;
            }
        } else if (adamDefaultLDAPAttributesTypes.contains(ldapType)) {
            conflictingDefault = this.conflictingAttribute(attr, adamDefaultLDAPAttributes);
            if (null != conflictingDefault && !this.isAttributeDefault(attr, adamDefaultLDAPAttributes)) {
                deleteExisting = true;
                addAttribute = true;
            } else if (null == conflictingDefault) {
                deleteExisting = false;
                addAttribute = true;
            }
        } else {
            deleteExisting = false;
            addAttribute = true;
        }
        if (deleteExisting) {
            attrCommands.append("AdminTask.deleteIdMgrLDAPAttr([");
            attrCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
            name2 = conflictingDefault.getName();
            propertyName = conflictingDefault.getPropertyName();
            if (name2 != null && !"".equals(name2) && name2.equals(attr.getName())) {
                attrCommands.append(", ");
                attrCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", name2, true, false));
            } else if (propertyName != null && !"".equals(propertyName) && propertyName.equals(attr.getPropertyName())) {
                attrCommands.append(", ");
                attrCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("propertyName", propertyName, true, false));
            }
            entityTypes = conflictingDefault.getEntityTypes();
            if (entityTypes != null && !entityTypes.isEmpty()) {
                attrCommands.append(", ");
                attrCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("entityTypes", CommonUtilities.joinStrings((CharSequence)";", entityTypes), true, false));
            }
            attrCommands.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        }
        if (addAttribute) {
            String syntax;
            String defaultAttribute;
            String defaultValue;
            attrCommands.append("AdminTask.addIdMgrLDAPAttr([");
            attrCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
            name2 = attr.getName();
            if (name2 != null && !"".equals(name2)) {
                attrCommands.append(", ");
                attrCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", name2, true, false));
            }
            if ((propertyName = attr.getPropertyName()) != null && !"".equals(propertyName)) {
                attrCommands.append(", ");
                attrCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("propertyName", propertyName, true, false));
            }
            if ((entityTypes = attr.getEntityTypes()) != null && !entityTypes.isEmpty()) {
                attrCommands.append(", ");
                attrCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("entityTypes", CommonUtilities.joinStrings((CharSequence)";", entityTypes), true, false));
            }
            if ((defaultValue = attr.getDefaultValue()) != null && !"".equals(defaultValue)) {
                attrCommands.append(", ");
                attrCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("defaultValue", defaultValue, true, false));
            }
            if ((defaultAttribute = attr.getDefaultAttribute()) != null && !"".equals(defaultAttribute)) {
                attrCommands.append(", ");
                attrCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("defaultAttribute", defaultAttribute, true, false));
            }
            if ((syntax = attr.getSyntax()) != null && !"".equals(syntax)) {
                attrCommands.append(", ");
                attrCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("syntax", syntax, true, false));
            }
            attrCommands.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        }
        return attrCommands.toString();
    }

    private String getCommandsToRemoveUnusedFederatedLdapAttributes(List<Attribute> attrs, String id, String ldapType) {
        if (ldapType == null) {
            return "";
        }
        List<Attribute> defaultAttrs = null;
        if (standardDefaultLDAPAttributesTypes.contains(ldapType)) {
            defaultAttrs = standardDefaultLDAPAttributes;
        } else if (adDefaultLDAPAttributesTypes.contains(ldapType)) {
            defaultAttrs = adDefaultLDAPAttributes;
        } else if (adamDefaultLDAPAttributesTypes.contains(ldapType)) {
            defaultAttrs = adamDefaultLDAPAttributes;
        }
        if (defaultAttrs == null || defaultAttrs.isEmpty()) {
            return "";
        }
        ArrayList<Attribute> toRemove = new ArrayList<Attribute>();
        if (attrs == null || attrs.isEmpty()) {
            toRemove.addAll(defaultAttrs);
        } else {
            for (Attribute defaultAttr : defaultAttrs) {
                if (this.conflictingAttribute(defaultAttr, attrs) != null) continue;
                toRemove.add(defaultAttr);
            }
        }
        StringBuilder attrCommands = new StringBuilder();
        for (Attribute remove : toRemove) {
            attrCommands.append("AdminTask.deleteIdMgrLDAPAttr([");
            attrCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
            String name2 = remove.getName();
            attrCommands.append(", ");
            attrCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", name2, true, false));
            List<String> entityTypes = remove.getEntityTypes();
            if (entityTypes != null && !entityTypes.isEmpty()) {
                attrCommands.append(", ");
                attrCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("entityTypes", CommonUtilities.joinStrings((CharSequence)";", entityTypes), true, false));
            }
            attrCommands.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        }
        return attrCommands.toString();
    }

    private String getCommandsToSetFederatedLdapEntityTypes(LdapEntityType entity, String id, String ldapType) {
        StringBuilder entityCommands = new StringBuilder();
        boolean deleteExisting = false;
        boolean addEntity = false;
        LdapEntityType conflictingDefault = null;
        if (standardDefaultLDAPEntitiesTypes.contains(ldapType)) {
            conflictingDefault = this.conflictingEntityType(entity, standardDefaultLDAPEntityTypes);
            if (null != conflictingDefault && !this.isLdapEntityTypeDefault(entity, standardDefaultLDAPEntityTypes)) {
                deleteExisting = true;
                addEntity = true;
            } else if (null == conflictingDefault) {
                deleteExisting = false;
                addEntity = true;
            }
        } else if (sunOneDefaultLDAPEntitiesTypes.contains(ldapType)) {
            conflictingDefault = this.conflictingEntityType(entity, sunOneDefaultLDAPEntityTypes);
            if (null != conflictingDefault && !this.isLdapEntityTypeDefault(entity, sunOneDefaultLDAPEntityTypes)) {
                deleteExisting = true;
                addEntity = true;
            } else if (null == conflictingDefault) {
                deleteExisting = false;
                addEntity = true;
            }
        } else if (adDefaultLDAPEntitiesTypes.contains(ldapType)) {
            conflictingDefault = this.conflictingEntityType(entity, adDefaultLDAPEntityTypes);
            if (null != conflictingDefault && !this.isLdapEntityTypeDefault(entity, adDefaultLDAPEntityTypes)) {
                deleteExisting = true;
                addEntity = true;
            } else if (null == conflictingDefault) {
                deleteExisting = false;
                addEntity = true;
            }
        } else {
            deleteExisting = false;
            addEntity = true;
        }
        if (deleteExisting) {
            entityCommands.append("AdminTask.deleteIdMgrLDAPEntityType([");
            entityCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
            entityCommands.append(", ");
            entityCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", conflictingDefault.getName(), true, false));
            entityCommands.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        }
        if (addEntity) {
            List<String> searchBases;
            List<String> objectClassesForCreate;
            String searchFilter;
            List<String> objectClasses;
            entityCommands.append("AdminTask.addIdMgrLDAPEntityType([");
            entityCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
            String name2 = entity.getName();
            if (name2 != null && !"".equals(name2)) {
                entityCommands.append(", ");
                entityCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", name2, true, false));
            }
            if ((objectClasses = entity.getObjectClasses()) != null && !objectClasses.isEmpty()) {
                entityCommands.append(", ");
                entityCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("objectClasses", CommonUtilities.joinStrings((CharSequence)";", objectClasses), true, false));
            }
            if ((searchFilter = entity.getSearchFilter()) != null && !"".equals(searchFilter)) {
                entityCommands.append(", ");
                entityCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("searchFilter", searchFilter, true, false));
            }
            if ((objectClassesForCreate = entity.getObjectClassesForCreate()) != null && !objectClassesForCreate.isEmpty()) {
                entityCommands.append(", ");
                entityCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("objectClassesForCreate", CommonUtilities.joinStrings((CharSequence)";", objectClassesForCreate), true, false));
            }
            if ((searchBases = entity.getSearchBases()) != null && !searchBases.isEmpty()) {
                entityCommands.append(", ");
                entityCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("searchBases", CommonUtilities.joinStrings((CharSequence)";", searchBases), true, false));
            }
            entityCommands.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
            List<RdnAttribute> rdnAttributes = entity.getRdnAttributes();
            if (rdnAttributes != null) {
                for (RdnAttribute rdnAttribute : rdnAttributes) {
                    String objectClass;
                    if (rdnAttribute == null) continue;
                    entityCommands.append("AdminTask.addIdMgrLDAPEntityTypeRDNAttr([");
                    entityCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
                    entityCommands.append(", ");
                    entityCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("entityTypeName", name2, true, false));
                    String rdnName = rdnAttribute.getName();
                    if (rdnName != null && !"".equals(rdnName)) {
                        entityCommands.append(", ");
                        entityCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", rdnName, true, false));
                    }
                    if ((objectClass = rdnAttribute.getObjectClass()) != null && !"".equals(objectClass)) {
                        entityCommands.append(", ");
                        entityCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("objectClass", objectClass, true, false));
                    }
                    entityCommands.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
                }
            }
        }
        return entityCommands.toString();
    }

    private String getCommandsToRemoveUnusedFederatedLdapEntityTypes(List<LdapEntityType> entities, String id, String ldapType) {
        if (ldapType == null) {
            return "";
        }
        List<LdapEntityType> defaultEntities = null;
        if (standardDefaultLDAPEntitiesTypes.contains(ldapType)) {
            defaultEntities = standardDefaultLDAPEntityTypes;
        } else if (sunOneDefaultLDAPEntitiesTypes.contains(ldapType)) {
            defaultEntities = sunOneDefaultLDAPEntityTypes;
        } else if (adDefaultLDAPEntitiesTypes.contains(ldapType)) {
            defaultEntities = adDefaultLDAPEntityTypes;
        }
        if (defaultEntities == null || defaultEntities.isEmpty()) {
            return "";
        }
        ArrayList<LdapEntityType> toRemove = new ArrayList<LdapEntityType>();
        if (entities == null || entities.isEmpty()) {
            toRemove.addAll(defaultEntities);
        } else {
            for (LdapEntityType defaultEntity : defaultEntities) {
                if (this.conflictingEntityType(defaultEntity, entities) != null) continue;
                toRemove.add(defaultEntity);
            }
        }
        StringBuilder entityCommands = new StringBuilder();
        for (LdapEntityType remove : toRemove) {
            entityCommands.append("AdminTask.deleteIdMgrLDAPEntityType([");
            entityCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
            String name2 = remove.getName();
            entityCommands.append(", ");
            entityCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", name2, true, false));
            entityCommands.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        }
        return entityCommands.toString();
    }

    private String getCommandsToSetFederatedLdapGroupMemberAttribute(MemberAttribute memberAttribute, String id, String ldapType) {
        StringBuilder groupMemberAttributeCommands = new StringBuilder();
        boolean deleteExisting = false;
        boolean addGroupMemberAttribute = false;
        MemberAttribute conflictingDefault = null;
        if (standardDefaultLDAPGroupMemberAttributesTypes.contains(ldapType)) {
            conflictingDefault = this.conflictingMemberAttribute(memberAttribute, standardDefaultLDAPGroupMemberAttributes);
            if (null != conflictingDefault && !this.isMemberAttributeDefault(memberAttribute, standardDefaultLDAPGroupMemberAttributes)) {
                deleteExisting = true;
                addGroupMemberAttribute = true;
            } else if (null == conflictingDefault) {
                deleteExisting = false;
                addGroupMemberAttribute = true;
            }
        } else if (ndsDefaultLDAPGroupMemberAttributesTypes.contains(ldapType)) {
            conflictingDefault = this.conflictingMemberAttribute(memberAttribute, ndsDefaultLDAPGroupMemberAttributes);
            if (null != conflictingDefault && !this.isMemberAttributeDefault(memberAttribute, ndsDefaultLDAPGroupMemberAttributes)) {
                deleteExisting = true;
                addGroupMemberAttribute = true;
            } else if (null == conflictingDefault) {
                deleteExisting = false;
                addGroupMemberAttribute = true;
            }
        } else if (sunOneDefaultLDAPGroupMemberAttributesTypes.contains(ldapType)) {
            conflictingDefault = this.conflictingMemberAttribute(memberAttribute, sunOneDefaultLDAPGroupMemberAttributes);
            if (null != conflictingDefault && !this.isMemberAttributeDefault(memberAttribute, sunOneDefaultLDAPGroupMemberAttributes)) {
                deleteExisting = true;
                addGroupMemberAttribute = true;
            } else if (null == conflictingDefault) {
                deleteExisting = false;
                addGroupMemberAttribute = true;
            }
        } else {
            deleteExisting = false;
            addGroupMemberAttribute = true;
        }
        if (deleteExisting) {
            groupMemberAttributeCommands.append("AdminTask.deleteIdMgrLDAPGroupMemberAttr([");
            groupMemberAttributeCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
            groupMemberAttributeCommands.append(", ");
            groupMemberAttributeCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", conflictingDefault.getName(), true, false));
            groupMemberAttributeCommands.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        }
        if (addGroupMemberAttribute) {
            String objectClass;
            String dummyMember;
            String scope;
            groupMemberAttributeCommands.append("AdminTask.addIdMgrLDAPGroupMemberAttr([");
            groupMemberAttributeCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
            String memberName = memberAttribute.getName();
            if (memberName != null && !"".equals(memberName)) {
                groupMemberAttributeCommands.append(", ");
                groupMemberAttributeCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", memberName, true, false));
            }
            if ((scope = memberAttribute.getScope()) != null && !"".equals(scope)) {
                groupMemberAttributeCommands.append(", ");
                groupMemberAttributeCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("scope", scope, true, false));
            }
            if ((dummyMember = memberAttribute.getDummyMember()) != null && !"".equals(dummyMember)) {
                groupMemberAttributeCommands.append(", ");
                groupMemberAttributeCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("dummyMember", dummyMember, true, false));
            }
            if ((objectClass = memberAttribute.getObjectClass()) != null && !"".equals(objectClass)) {
                groupMemberAttributeCommands.append(", ");
                groupMemberAttributeCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("objectClass", objectClass, true, false));
            }
            groupMemberAttributeCommands.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        }
        return groupMemberAttributeCommands.toString();
    }

    private String getCommandsToRemoveUnusedFederatedLdapGroupMemberAttribute(List<MemberAttribute> memberAttrs, String id, String ldapType) {
        if (ldapType == null) {
            return "";
        }
        List<MemberAttribute> defaultMemberAttrs = null;
        if (standardDefaultLDAPGroupMemberAttributesTypes.contains(ldapType)) {
            defaultMemberAttrs = standardDefaultLDAPGroupMemberAttributes;
        } else if (ndsDefaultLDAPGroupMemberAttributesTypes.contains(ldapType)) {
            defaultMemberAttrs = ndsDefaultLDAPGroupMemberAttributes;
        } else if (sunOneDefaultLDAPGroupMemberAttributesTypes.contains(ldapType)) {
            defaultMemberAttrs = sunOneDefaultLDAPGroupMemberAttributes;
        }
        if (defaultMemberAttrs == null || defaultMemberAttrs.isEmpty()) {
            return "";
        }
        ArrayList<MemberAttribute> toRemove = new ArrayList<MemberAttribute>();
        if (memberAttrs == null || memberAttrs.isEmpty()) {
            toRemove.addAll(defaultMemberAttrs);
        } else {
            for (MemberAttribute defaultMemberAttr : defaultMemberAttrs) {
                if (this.conflictingMemberAttribute(defaultMemberAttr, memberAttrs) != null) continue;
                toRemove.add(defaultMemberAttr);
            }
        }
        StringBuilder groupMemberAttributeCommands = new StringBuilder();
        for (MemberAttribute remove : toRemove) {
            groupMemberAttributeCommands.append("AdminTask.deleteIdMgrLDAPGroupMemberAttr([");
            groupMemberAttributeCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("id", id, true, false));
            String name2 = remove.getName();
            groupMemberAttributeCommands.append(", ");
            groupMemberAttributeCommands.append(TwasCommandBuilder.createAttributeKeyValuePairAdminTask("name", name2, true, false));
            groupMemberAttributeCommands.append(ConfigGeneratorConstants.ADMIN_CONFIG_END);
        }
        return groupMemberAttributeCommands.toString();
    }

    private boolean objectsEquals(Object o1, Object o2) {
        if (null == o1) {
            return null == o2;
        }
        return o1.equals(o2);
    }

    private Attribute conflictingAttribute(Attribute attr, List<Attribute> existingAttrs) {
        if (attr == null || existingAttrs == null || existingAttrs.isEmpty()) {
            return null;
        }
        for (Attribute existingAttr : existingAttrs) {
            if (existingAttr == null || !this.objectsEquals(attr.getName(), existingAttr.getName()) || Collections.disjoint(attr.getEntityTypes(), existingAttr.getEntityTypes()) && !attr.getEntityTypes().isEmpty() && !existingAttr.getEntityTypes().isEmpty()) continue;
            return existingAttr;
        }
        return null;
    }

    private boolean isAttributeDefault(Attribute attr, List<Attribute> defaultAttrs) {
        if (attr == null || defaultAttrs == null || defaultAttrs.isEmpty()) {
            return false;
        }
        for (Attribute defaultAttr : defaultAttrs) {
            if (defaultAttr == null || !this.objectsEquals(attr.getName(), defaultAttr.getName()) || !this.objectsEquals(attr.getPropertyName(), defaultAttr.getPropertyName()) || !this.isListContentsDefault(attr.getEntityTypes(), defaultAttr.getEntityTypes()) || !this.objectsEquals(attr.getDefaultValue(), defaultAttr.getDefaultValue()) || !this.objectsEquals(attr.getDefaultAttribute(), defaultAttr.getDefaultAttribute()) || !this.objectsEquals(attr.getSyntax(), defaultAttr.getSyntax())) continue;
            return true;
        }
        return false;
    }

    private LdapEntityType conflictingEntityType(LdapEntityType entity, List<LdapEntityType> existingEntityTypes) {
        if (entity == null || existingEntityTypes == null || existingEntityTypes.isEmpty()) {
            return null;
        }
        for (LdapEntityType existingEntity : existingEntityTypes) {
            if (existingEntity == null || !this.objectsEquals(entity.getName(), existingEntity.getName())) continue;
            return existingEntity;
        }
        return null;
    }

    private boolean isLdapEntityTypeDefault(LdapEntityType entity, List<LdapEntityType> defaultEntities) {
        if (entity == null || defaultEntities == null || defaultEntities.isEmpty()) {
            return false;
        }
        for (LdapEntityType defaultEntity : defaultEntities) {
            if (defaultEntity == null || !this.objectsEquals(entity.getName(), defaultEntity.getName()) || !this.objectsEquals(entity.getSearchFilter(), defaultEntity.getSearchFilter()) || !this.isListContentsDefault(entity.getObjectClasses(), defaultEntity.getObjectClasses()) || !this.isListContentsDefault(entity.getRdnAttributes(), defaultEntity.getRdnAttributes()) || !this.isListContentsDefault(entity.getObjectClassesForCreate(), defaultEntity.getObjectClassesForCreate()) || !this.isListContentsDefault(entity.getSearchBases(), defaultEntity.getSearchBases())) continue;
            return true;
        }
        return false;
    }

    private MemberAttribute conflictingMemberAttribute(MemberAttribute attr, List<MemberAttribute> existingMemberAttrs) {
        if (attr == null || existingMemberAttrs == null || existingMemberAttrs.isEmpty()) {
            return null;
        }
        for (MemberAttribute existingMemberAttr : existingMemberAttrs) {
            if (!this.objectsEquals(attr.getName(), existingMemberAttr.getName())) continue;
            return existingMemberAttr;
        }
        return null;
    }

    private boolean isMemberAttributeDefault(MemberAttribute attr, List<MemberAttribute> defaultMemberAttrs) {
        if (attr == null || defaultMemberAttrs == null || defaultMemberAttrs.isEmpty()) {
            return false;
        }
        for (MemberAttribute defaultMemberAttr : defaultMemberAttrs) {
            if (defaultMemberAttr == null || !this.objectsEquals(attr.getName(), defaultMemberAttr.getName()) || !this.objectsEquals(attr.getScope(), defaultMemberAttr.getScope()) || !this.objectsEquals(attr.getDummyMember(), defaultMemberAttr.getDummyMember()) || !this.objectsEquals(attr.getObjectClass(), defaultMemberAttr.getObjectClass())) continue;
            return true;
        }
        return false;
    }

    private <T> boolean isListContentsDefault(List<T> items, List<T> defaultItems) {
        if (items == null || items.isEmpty()) {
            return defaultItems == null || defaultItems.isEmpty();
        }
        if (defaultItems == null || defaultItems.isEmpty()) {
            return false;
        }
        if (items.size() != defaultItems.size()) {
            return false;
        }
        for (T item : items) {
            boolean found = false;
            for (T defaultItem : defaultItems) {
                if (item instanceof RdnAttribute && defaultItem instanceof RdnAttribute) {
                    RdnAttribute attr = (RdnAttribute)item;
                    RdnAttribute defaultAttr = (RdnAttribute)defaultItem;
                    if (!this.objectsEquals(attr.getName(), defaultAttr.getName()) || !this.objectsEquals(attr.getObjectClass(), defaultAttr.getObjectClass())) continue;
                    found = true;
                    break;
                }
                if (!this.objectsEquals(item, defaultItem)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public void warnAboutSecurityConfigNotMigrated() {
        this._warnAboutSecurityConfigNotMigrated = true;
    }

    public void setUsesSingleAndDoubleQuotes(boolean value) {
        this._usesSingleAndDoubleQuotes = true;
    }

    @Override
    public void addSSLConfig(SSLConfig sslConfig, Security security) {
    }

    @Override
    public void addDefaultSSLConfig(SSLConfigGroup inboundGroup, SSLConfigGroup outBoundGroup, Security security) {
    }

    @Override
    public void addDynamicSSLConfig(DynamicSSLConfigSelection dynamicSSLConfig, Security security) {
    }

    @Override
    public void addTransactionService(TransactionService transactionService, List<DataSource> datasources) {
    }

    @Override
    public void addJpaService(JpaService jpaService) {
    }

    @Override
    public void addCDIContainer(String enableImplicitBeanArchives, String emptyBeansXmlCDI3Compatibility) {
    }

    @Override
    public void addVirtualHosts(List<VirtualHost> virtualHosts) {
    }

    @Override
    public void addMimeTypes(List<MimeType> mimeTypes) {
    }

    @Override
    public void addTrace(TraceService traceService) {
    }

    @Override
    public void addLTPA(LTPAAuthMechanism ltpaAuthMechanism) {
    }

    @Override
    public void addJNDIReferenceBinding(JNDIReferenceBinding jndiReferenceBinding) {
    }

    @Override
    public void addJNDIURLBinding(JNDIURLBinding jndiURLBinding) {
    }

    @Override
    public void addJNDIObjectFactory(JNDIObjectFactory jndiObjectFactory) {
    }

    @Override
    public void addWebAppSecurity(Security security, AuthMechanisms activeAuthMechanism) {
    }

    @Override
    public void addMailSessions(List<MailSession> ms) {
    }

    @Override
    public String exportEnvironmentVariables() {
        return null;
    }

    @Override
    public void addEnvVar(EnvironmentVariable envVar) {
    }

    @Override
    public void addConnectionFactory(J2CConnectionFactory cf, boolean isTwasSourceAppServer) {
    }

    @Override
    public void addAdminObject(J2CAdminObject ao) {
    }

    @Override
    public void addActivationSpec(J2CActivationSpec spec) {
    }

    @Override
    public void addWmqJmsClient(SortedMap<String, ? extends J2EEResourceProperty> sortedMap) {
    }

    static enum ConnectionFactoryType {
        Queue,
        Topic,
        Generic;

    }
}

