/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility;

import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedObject;
import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;

public class Variable
implements ScopedObject {
    private final Scope _scope;
    private final String _xmiId;
    private final String _symbolicName;
    private final String _value;
    private final String _description;
    private String _resolvedValue = null;

    public Variable(Variable e) {
        this._scope = e._scope;
        this._xmiId = e._xmiId;
        this._symbolicName = e._symbolicName;
        this._value = e._value;
        this._description = e._description;
    }

    public Variable(Scope scope, String symbolicName, String xmiId, String value, String description) {
        this._scope = scope;
        this._xmiId = xmiId;
        this._symbolicName = symbolicName;
        this._value = value;
        this._description = description;
    }

    @Override
    public Scope getScope() {
        return this._scope;
    }

    public String getXmiId() {
        return this._xmiId;
    }

    public String getSymbolicName() {
        return this._symbolicName;
    }

    public String getValue() {
        return this._value;
    }

    public String getDescription() {
        return this._description;
    }

    public String getResolvedValue() {
        if (this._resolvedValue == null) {
            return this._value;
        }
        return this._resolvedValue;
    }

    public void setResolvedValue(String resolvedValue) {
        this._resolvedValue = resolvedValue;
    }

    @Override
    public String getUniqueIdentifierName() {
        return this._symbolicName;
    }

    public String toString() {
        return "Variable[" + this._symbolicName + "=\"" + this._value + "\", resolvedValue=\"" + this._resolvedValue + "\"]";
    }

    @Override
    public boolean equalsAllowDifferentScopes(ScopedObject entry) {
        if (entry == null) {
            return false;
        }
        if (entry == this) {
            return true;
        }
        if (!(entry instanceof Variable)) {
            return false;
        }
        Variable variable = (Variable)entry;
        return CommonUtilities.equals(this._xmiId, variable.getXmiId()) && CommonUtilities.equals(this._symbolicName, variable.getSymbolicName()) && CommonUtilities.equals(this._value, variable.getValue()) && CommonUtilities.equals(this._description, variable.getDescription());
    }
}

