/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.cmdline.utilities;

import com.ibm.json.java.JSONObject;
import com.ibm.ws.report.binary.ReportInputData;
import com.ibm.ws.report.binary.cmdline.Messages;
import com.ibm.ws.report.binary.utilities.BinaryReportBuilder;
import com.ibm.ws.report.binary.utilities.DataCollectionHelper;
import com.ibm.ws.report.processor.ReportBuilder;
import com.ibm.ws.report.utilities.Constants;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;

public class ReportBuilderHelper {
    public static final String RULEID_TO_HELP_FILE = "ruleIdToHelp.json";
    public static final String RULEID_TO_HELP_LOC = "/resources/ruleIdToHelp.json";

    public static BinaryReportBuilder loadInventoryRules() {
        BinaryReportBuilder inventory = new BinaryReportBuilder();
        inventory.loadList("/rules/inventory/InventoryList.xml", null, ReportBuilder.ListType.Inventory);
        return inventory;
    }

    public static BinaryReportBuilder loadConfigRules(boolean includeFeatureList) {
        BinaryReportBuilder configList = new BinaryReportBuilder();
        if (includeFeatureList) {
            configList.loadList("/rules/liberty/FeatureList_List.xml", null, ReportBuilder.ListType.FeatureList);
        }
        configList.loadList("/rules/common/Config_List.xml", null, ReportBuilder.ListType.Analysis);
        return configList;
    }

    public static void loadAllRules(BinaryReportBuilder analyze) {
        for (Field field : Constants.class.getFields()) {
            String fieldName = field.getName();
            if (!fieldName.endsWith("_LIST") || fieldName.contains("_INVENTORY_") || fieldName.contains("_FEATURE_LIST_") || fieldName.contains("_RULE_TECHNOLOGY_REPORT_")) continue;
            try {
                String value = (String)field.get(null);
                analyze.loadList(value, null, ReportBuilder.ListType.Analysis);
            }
            catch (IllegalAccessException e) {
                if (ReportUtility.isDebug()) {
                    ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Accessing_List_Log"), fieldName), e);
                } else {
                    ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Accessing_List"), fieldName, e.getMessage()));
                }
                analyze.setReturnCode(2);
            }
        }
    }

    public static boolean generateRuleIdToHelpMap(String fileLocation) {
        ReportUtility.initiateLogger(false, false);
        ReportUtility.setLocale(Locale.getDefault());
        BinaryReportBuilder analyze = new BinaryReportBuilder();
        analyze._loadAllRules = true;
        ReportBuilderHelper.loadAllRules(analyze);
        JSONObject jsonobject = new JSONObject();
        for (String ruleId : analyze._ruleIds) {
            String helpFileLoc = (String)analyze._helpIds.get(ruleId);
            jsonobject.put(ruleId, helpFileLoc);
        }
        String jsonFileLocation = fileLocation + RULEID_TO_HELP_LOC;
        try {
            String json = jsonobject.serialize(true);
            json = json.replace("\\/", "/");
            ReportUtility.writeOutStream(new File(jsonFileLocation), json);
        }
        catch (Exception e) {
            ReportUtility.logger.get().log(Level.SEVERE, "Error while creating " + jsonFileLocation, e);
            return false;
        }
        return true;
    }

    public static BinaryReportBuilder loadAnalyzeRules(ReportInputData data) {
        return ReportBuilderHelper.loadAnalyzeRules(data, false);
    }

    public static BinaryReportBuilder loadAnalyzeRules(ReportInputData data, boolean isTA) {
        BinaryReportBuilder analyze = new BinaryReportBuilder();
        boolean loadAllRules = data.loadAllRules();
        Set<String> excludeRules = data.getExcludedRules();
        analyze.setLoadAllRules(loadAllRules);
        analyze.setExcludedRuleList(excludeRules);
        File[] additionalRulesToRun = data.getRuleXmlFiles();
        if (additionalRulesToRun != null) {
            analyze.createCategorySet("userRules");
            for (File externalListFile : additionalRulesToRun) {
                analyze.loadList(externalListFile, null, null, ReportBuilder.ListType.Analysis);
            }
            if (analyze._foundInvalidRule) {
                return analyze;
            }
        }
        Set userDefinedRulesSet = (Set)analyze.targetToCategories.get("userRules");
        if (loadAllRules) {
            ReportBuilderHelper.loadAllRules(analyze);
        } else if (!data.isReplaceRules()) {
            EnumSet<ReportInputData.AppServer> targetAppServers = !isTA ? EnumSet.of(data.getTargetAppServer()) : EnumSet.of(DataCollectionHelper.getTWASTarget(data.getSourceAppServer(), data.getTargetAppServer()), ReportInputData.AppServer.LIBERTY, ReportInputData.AppServer.MANAGED_LIBERTY, ReportInputData.AppServer.OPEN_LIBERTY, ReportInputData.AppServer.EASE);
            for (ReportInputData.AppServer targetAppServer : targetAppServers) {
                ReportInputData.JavaVersion sourceJava;
                boolean isSourceAndTargetAppServerTheSame;
                analyze.createCategorySet(targetAppServer.toString());
                ReportInputData.TargetCloud targetCloud = data.getTargetCloud();
                ReportInputData.AppServer sourceAppServer = data.getSourceAppServer();
                boolean bl = isSourceAndTargetAppServerTheSame = sourceAppServer == null && targetAppServer == null || sourceAppServer != null && targetAppServer != null && sourceAppServer.equals((Object)targetAppServer);
                if (userDefinedRulesSet != null) {
                    ((Set)analyze.targetToCategories.get(targetAppServer.toString())).addAll(userDefinedRulesSet);
                }
                analyze.loadList("/rules/java/JavaList.xml", null, ReportBuilder.ListType.Analysis);
                if (targetCloud != null || !isSourceAndTargetAppServerTheSame) {
                    analyze.loadList("/rules/allServers/AllServersList.xml", null, ReportBuilder.ListType.Analysis);
                }
                if (!isSourceAndTargetAppServerTheSame && targetAppServer.isWAS_Traditional()) {
                    analyze.loadList("/rules/allServers/AllServersToTWASList.xml", null, ReportBuilder.ListType.Analysis);
                }
                ReportInputData.JavaEEVersion sourceJavaEE = data.getSourceJavaEE();
                ReportInputData.JavaEEVersion targetJavaEE = isTA ? DataCollectionHelper.getTargetJavaEE(sourceAppServer, targetAppServer) : data.getTargetJavaEE();
                ReportBuilderHelper.addCompetitiveRules(analyze, sourceAppServer, targetAppServer, targetJavaEE);
                ReportBuilderHelper.addCloudRules(analyze, targetCloud, targetAppServer);
                if (targetAppServer == null) continue;
                ReportInputData.JavaVersion targetJava = null;
                targetJava = isTA ? DataCollectionHelper.getTargetJava(sourceAppServer, targetAppServer, data.getSourceJava(), data.getTargetJava()) : data.getTargetJava();
                switch (targetAppServer) {
                    case LIBERTY: 
                    case EASE: 
                    case OPEN_LIBERTY: {
                        if (sourceAppServer.isLiberty()) break;
                        analyze.loadList("/rules/liberty/LibertyList.xml", null, ReportBuilder.ListType.Analysis);
                        if (targetAppServer == ReportInputData.AppServer.OPEN_LIBERTY) {
                            analyze.loadList("/rules/liberty/OpenLibertyList.xml", null, ReportBuilder.ListType.Analysis);
                        } else if (targetAppServer == ReportInputData.AppServer.EASE) {
                            analyze.loadList("/rules/liberty/Was2EASeList.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (!sourceAppServer.isWAS_Traditional()) break;
                        analyze.loadList("/rules/liberty/Was2LibertyList.xml", null, ReportBuilder.ListType.Analysis);
                        analyze.loadList("/rules/config/ConfigAnalysisLibertyList.xml", null, ReportBuilder.ListType.Analysis);
                        ReportBuilderHelper.addVersionToVersionRules(analyze, sourceAppServer, targetAppServer);
                        if (targetAppServer == ReportInputData.AppServer.OPEN_LIBERTY) {
                            analyze.loadList("/rules/liberty/Was2OpenLibertyList.xml", null, ReportBuilder.ListType.Analysis);
                            break;
                        }
                        analyze.loadList("/rules/liberty/Was2LibertyBaseNDzOSList.xml", null, ReportBuilder.ListType.Analysis);
                        break;
                    }
                    case LIBERTY_CORE: {
                        if (sourceAppServer != ReportInputData.AppServer.LIBERTY_CORE) {
                            analyze.loadList("/rules/liberty/LibertyCoreList.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (sourceAppServer.isLiberty()) break;
                        analyze.loadList("/rules/liberty/LibertyList.xml", null, ReportBuilder.ListType.Analysis);
                        if (!sourceAppServer.isWAS_Traditional()) break;
                        analyze.loadList("/rules/liberty/Was2LibertyCoreList.xml", null, ReportBuilder.ListType.Analysis);
                        analyze.loadList("/rules/liberty/Was2LibertyList.xml", null, ReportBuilder.ListType.Analysis);
                        analyze.loadList("/rules/config/ConfigAnalysisLibertyList.xml", null, ReportBuilder.ListType.Analysis);
                        ReportBuilderHelper.addVersionToVersionRules(analyze, sourceAppServer, targetAppServer);
                        break;
                    }
                    case MANAGED_LIBERTY: {
                        if (sourceAppServer.isLiberty()) break;
                        analyze.loadList("/rules/liberty/LibertyList.xml", null, ReportBuilder.ListType.Analysis);
                        if (!sourceAppServer.isWAS_Traditional()) break;
                        analyze.loadList("/rules/liberty/Was2LibertyList.xml", null, ReportBuilder.ListType.Analysis);
                        analyze.loadList("/rules/config/ConfigAnalysisLibertyList.xml", null, ReportBuilder.ListType.Analysis);
                        ReportBuilderHelper.addVersionToVersionRules(analyze, sourceAppServer, targetAppServer);
                        if (targetAppServer == ReportInputData.AppServer.MANAGED_LIBERTY) {
                            analyze.loadList("/rules/liberty/Was2ManagedLibertyList.xml", null, ReportBuilder.ListType.Analysis);
                            break;
                        }
                        analyze.loadList("/rules/liberty/Was2LibertyBaseNDzOSList.xml", null, ReportBuilder.ListType.Analysis);
                        break;
                    }
                    case WAS855: 
                    case WAS90: {
                        ReportBuilderHelper.addVersionToVersionRules(analyze, sourceAppServer, targetAppServer);
                        break;
                    }
                }
                if (!sourceAppServer.isCompetitiveAppServer()) {
                    if (targetJavaEE != null || targetJavaEE != null && targetJavaEE != ReportInputData.JavaEEVersion.EE7 && sourceJavaEE != ReportInputData.JavaEEVersion.EE7) {
                        ReportUtility.logger.get().log(Level.FINE, "ReportBuilderHelper: a targetJavaEE " + (Object)((Object)targetJavaEE) + " was specified. Loading the " + (Object)((Object)targetJavaEE) + " Java EE rules.");
                        analyze.loadJavaEERules(sourceAppServer, targetAppServer, sourceJavaEE, targetJavaEE, false);
                    } else if (data.filterAnalysisRulesByFeatureList()) {
                        ReportUtility.logger.get().log(Level.FINE, "ReportBuilderHelper: no target Java EE was specified. Loading all Java EE rules to filter later.");
                        analyze.loadJavaEERules(sourceAppServer, targetAppServer, sourceJavaEE, targetJavaEE, true);
                    }
                }
                if ((sourceJava = data.getSourceJava()) == null || targetJava == null) continue;
                if (sourceJava.isOracleJava() && targetJava.isIBMJava()) {
                    analyze.loadList("/rules/java/JavaOracleList.xml", null, ReportBuilder.ListType.Analysis);
                    analyze.loadList("/rules/java/JavaOracleInternalList.xml", null, ReportBuilder.ListType.Analysis);
                }
                int targetJavaVersion = targetJava.getVersionNumber();
                switch (sourceJava) {
                    case IBM5: {
                        if (targetJavaVersion >= ReportInputData.JavaVersion.JAVA11.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java11XmlList.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (targetJavaVersion == ReportInputData.JavaVersion.JAVA11.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java11OnlyList.xml", null, ReportBuilder.ListType.Analysis);
                        }
                    }
                    case ORACLE5: {
                        analyze.loadList("/rules/java/Java6List.xml", null, ReportBuilder.ListType.Analysis);
                        if (targetJavaVersion >= ReportInputData.JavaVersion.IBM7.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java7List.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (targetJavaVersion >= ReportInputData.JavaVersion.IBM8.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java8List.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (targetJavaVersion >= ReportInputData.JavaVersion.JAVA11.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java11List.xml", null, ReportBuilder.ListType.Analysis);
                            if (targetAppServer != ReportInputData.AppServer.LIBERTY_CORE) {
                                analyze.loadList("/rules/java/Java11NotLibertyCoreList.xml", null, ReportBuilder.ListType.Analysis);
                            }
                        }
                        if (targetJavaVersion == ReportInputData.JavaVersion.JAVA11.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java11OnlyList.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (targetJavaVersion >= ReportInputData.JavaVersion.JAVA17.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java17List.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (targetJavaVersion < ReportInputData.JavaVersion.JAVA21.getVersionNumber()) break;
                        analyze.loadList("/rules/java/Java21List.xml", null, ReportBuilder.ListType.Analysis);
                        break;
                    }
                    case IBM6: {
                        if (targetJavaVersion >= ReportInputData.JavaVersion.JAVA11.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java11XmlList.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (targetJavaVersion == ReportInputData.JavaVersion.JAVA11.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java11OnlyList.xml", null, ReportBuilder.ListType.Analysis);
                        }
                    }
                    case ORACLE6: {
                        if (targetJavaVersion >= ReportInputData.JavaVersion.IBM7.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java7List.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (targetJavaVersion >= ReportInputData.JavaVersion.IBM8.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java8List.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (targetJavaVersion >= ReportInputData.JavaVersion.JAVA11.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java11List.xml", null, ReportBuilder.ListType.Analysis);
                            if (targetAppServer != ReportInputData.AppServer.LIBERTY_CORE) {
                                analyze.loadList("/rules/java/Java11NotLibertyCoreList.xml", null, ReportBuilder.ListType.Analysis);
                            }
                        }
                        if (targetJavaVersion == ReportInputData.JavaVersion.JAVA11.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java11OnlyList.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (targetJavaVersion >= ReportInputData.JavaVersion.JAVA17.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java17List.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (targetJavaVersion < ReportInputData.JavaVersion.JAVA21.getVersionNumber()) break;
                        analyze.loadList("/rules/java/Java21List.xml", null, ReportBuilder.ListType.Analysis);
                        break;
                    }
                    case IBM7: {
                        if (targetJava.getVersionNumber() >= ReportInputData.JavaVersion.JAVA11.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java11XmlList.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (targetJavaVersion == ReportInputData.JavaVersion.JAVA11.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java11OnlyList.xml", null, ReportBuilder.ListType.Analysis);
                        }
                    }
                    case ORACLE7: {
                        if (targetJavaVersion >= ReportInputData.JavaVersion.IBM8.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java8List.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (targetJavaVersion >= ReportInputData.JavaVersion.JAVA11.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java11List.xml", null, ReportBuilder.ListType.Analysis);
                            if (targetAppServer != ReportInputData.AppServer.LIBERTY_CORE) {
                                analyze.loadList("/rules/java/Java11NotLibertyCoreList.xml", null, ReportBuilder.ListType.Analysis);
                            }
                        }
                        if (targetJavaVersion == ReportInputData.JavaVersion.JAVA11.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java11OnlyList.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (targetJavaVersion >= ReportInputData.JavaVersion.JAVA17.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java17List.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (targetJavaVersion < ReportInputData.JavaVersion.JAVA21.getVersionNumber()) break;
                        analyze.loadList("/rules/java/Java21List.xml", null, ReportBuilder.ListType.Analysis);
                        break;
                    }
                    case IBM8: {
                        if (targetJava.getVersionNumber() >= ReportInputData.JavaVersion.JAVA11.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java11XmlList.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (targetJavaVersion == ReportInputData.JavaVersion.JAVA11.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java11OnlyList.xml", null, ReportBuilder.ListType.Analysis);
                        }
                    }
                    case ORACLE8: {
                        if (targetJavaVersion >= ReportInputData.JavaVersion.JAVA11.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java11List.xml", null, ReportBuilder.ListType.Analysis);
                            if (targetAppServer != ReportInputData.AppServer.LIBERTY_CORE) {
                                analyze.loadList("/rules/java/Java11NotLibertyCoreList.xml", null, ReportBuilder.ListType.Analysis);
                            }
                        }
                        if (targetJavaVersion >= ReportInputData.JavaVersion.JAVA17.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java17List.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (targetJavaVersion >= ReportInputData.JavaVersion.JAVA21.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java21List.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (targetJavaVersion != ReportInputData.JavaVersion.JAVA11.getVersionNumber()) break;
                        analyze.loadList("/rules/java/Java11OnlyList.xml", null, ReportBuilder.ListType.Analysis);
                        break;
                    }
                    case JAVA11: {
                        if (targetJavaVersion >= ReportInputData.JavaVersion.JAVA17.getVersionNumber()) {
                            analyze.loadList("/rules/java/Java17List.xml", null, ReportBuilder.ListType.Analysis);
                        }
                        if (targetJavaVersion < ReportInputData.JavaVersion.JAVA21.getVersionNumber()) break;
                        analyze.loadList("/rules/java/Java21List.xml", null, ReportBuilder.ListType.Analysis);
                        break;
                    }
                    case JAVA17: {
                        if (targetJavaVersion < ReportInputData.JavaVersion.JAVA21.getVersionNumber()) break;
                        analyze.loadList("/rules/java/Java21List.xml", null, ReportBuilder.ListType.Analysis);
                        break;
                    }
                }
            }
        }
        return analyze;
    }

    protected static void addVersionToVersionRules(BinaryReportBuilder analyze, ReportInputData.AppServer sourceAppServer, ReportInputData.AppServer targetAppServer) {
        switch (sourceAppServer) {
            case WAS61: {
                if (targetAppServer.isWAS_Traditional()) {
                    analyze.loadList("/rules/was2was/deprecationsBeforeV8/DeprecationBefore80List.xml", null, ReportBuilder.ListType.Analysis);
                }
                analyze.loadList("/rules/was2was/70List.xml", null, ReportBuilder.ListType.Analysis);
            }
            case WAS70: {
                if (targetAppServer.isWAS_Traditional()) {
                    analyze.loadList("/rules/was2was/Deprecation80List.xml", null, ReportBuilder.ListType.Analysis);
                }
                analyze.loadList("/rules/was2was/80List.xml", null, ReportBuilder.ListType.Analysis);
                if (targetAppServer == ReportInputData.AppServer.WAS855) {
                    analyze.loadList("/rules/was2was/80_85List.xml", null, ReportBuilder.ListType.Analysis);
                }
            }
            case WAS80: {
                analyze.loadList("/rules/was2was/85List.xml", null, ReportBuilder.ListType.Analysis);
                if (targetAppServer == ReportInputData.AppServer.WAS855) {
                    analyze.loadList("/rules/was2was/Deprecation85OnlyList.xml", null, ReportBuilder.ListType.Analysis);
                }
                if (targetAppServer.isWAS_Traditional()) {
                    analyze.loadList("/rules/was2was/Deprecation85List.xml", null, ReportBuilder.ListType.Analysis);
                }
            }
            case WAS855: {
                if (targetAppServer == ReportInputData.AppServer.WAS90) {
                    analyze.loadList("/rules/was2was/90List.xml", null, ReportBuilder.ListType.Analysis);
                    analyze.loadList("/rules/was2was/Deprecation90OnlyList.xml", null, ReportBuilder.ListType.Analysis);
                } else if (!targetAppServer.isWAS_Traditional()) {
                    analyze.loadList("/rules/was2was/90List.xml", null, ReportBuilder.ListType.Analysis);
                }
                if (targetAppServer == sourceAppServer) break;
                analyze.loadList("/rules/was2was/80_85_90List.xml", null, ReportBuilder.ListType.Analysis);
            }
        }
    }

    protected static void addCloudRules(BinaryReportBuilder analyze, ReportInputData.TargetCloud targetCloud, ReportInputData.AppServer targetAppServer) {
        if (targetCloud != null) {
            boolean notLibertyCore = targetAppServer == null || targetAppServer != ReportInputData.AppServer.LIBERTY_CORE;
            boolean includeClassic = targetAppServer == null || targetAppServer == ReportInputData.AppServer.WAS855 || targetAppServer == ReportInputData.AppServer.WAS90;
            analyze.loadList("/rules/cloud/TechnologyConnectivityList.xml", null, ReportBuilder.ListType.Analysis);
            switch (targetCloud) {
                case THIRD_PARTY: {
                    analyze.loadList("/rules/liberty/CloudFoundryList.xml", null, ReportBuilder.ListType.Analysis);
                    analyze.loadList("/rules/cloud/TechnologyConnectivityNotLibertyCoreList.xml", null, ReportBuilder.ListType.Analysis);
                    analyze.loadList("/rules/cloud/ConnectivityThirdPartyPaaSList.xml", null, ReportBuilder.ListType.Analysis);
                    break;
                }
                case DOCKER: 
                case DOCKER_IBM_CLOUD: 
                case CONTAINERS: {
                    analyze.loadList("/rules/cloud/DockerList.xml", null, ReportBuilder.ListType.Analysis);
                }
                case WAS_VM: 
                case VM_IBM_CLOUD: {
                    if (notLibertyCore) {
                        analyze.loadList("/rules/cloud/TechnologyConnectivityNotLibertyCoreList.xml", null, ReportBuilder.ListType.Analysis);
                    }
                    if (includeClassic) {
                        analyze.loadList("/rules/cloud/TechnologyConnectivityClassicList.xml", null, ReportBuilder.ListType.Analysis);
                    }
                    analyze.loadList("/rules/cloud/ConnectivityDockerAndWASonCloudList.xml", null, ReportBuilder.ListType.Analysis);
                }
            }
        }
    }

    protected static void addCompetitiveRules(BinaryReportBuilder analyze, ReportInputData.AppServer sourceAppServer, ReportInputData.AppServer targetAppServer, ReportInputData.JavaEEVersion targetJavaEE) {
        if (sourceAppServer != null && sourceAppServer.isCompetitiveAppServer()) {
            analyze.loadList("/rules/competitive/AllCompetitive.xml", null, ReportBuilder.ListType.Analysis);
            analyze.loadList("/rules/framework/FrameworkList.xml", null, ReportBuilder.ListType.Analysis);
            analyze.loadList("/rules/framework/SpringBestPracticesList.xml", null, ReportBuilder.ListType.Analysis);
            analyze.loadList("/rules/tld/TLDList.xml", null, ReportBuilder.ListType.Analysis);
            switch (sourceAppServer) {
                case JBOSS: {
                    analyze.loadList("/rules/jboss/JbossList.xml", null, ReportBuilder.ListType.Analysis);
                    if (!targetAppServer.isWAS_Traditional()) break;
                    analyze.loadList("/rules/jboss/JbossToTWASList.xml", null, ReportBuilder.ListType.Analysis);
                    break;
                }
                case TOMCAT: {
                    analyze.loadList("/rules/tomcat/TomcatList.xml", null, ReportBuilder.ListType.Analysis);
                    if (!targetAppServer.isLiberty()) break;
                    analyze.loadList("/rules/tomcat/TomcatToLibertyList.xml", null, ReportBuilder.ListType.Analysis);
                    break;
                }
                case WEBLOGIC: {
                    analyze.loadList("/rules/weblogic/WebLogicList.xml", null, ReportBuilder.ListType.Analysis);
                    analyze.loadList("/rules/weblogic/WebLogicBeehiveList.xml", null, ReportBuilder.ListType.Analysis);
                    if (targetAppServer.isWAS_Traditional()) {
                        analyze.loadList("/rules/weblogic/WebLogicToTWASList.xml", null, ReportBuilder.ListType.Analysis);
                    }
                    if (targetAppServer == ReportInputData.AppServer.WAS855 || targetJavaEE != null && targetJavaEE == ReportInputData.JavaEEVersion.EE6) {
                        analyze.loadList("/rules/weblogic/WebLogicJPA20List.xml", null, ReportBuilder.ListType.Analysis);
                        break;
                    }
                    analyze.loadList("/rules/weblogic/WebLogicJPA21orLaterList.xml", null, ReportBuilder.ListType.Analysis);
                    break;
                }
                case OTHER_THIRD_PARTY: {
                    analyze.loadList("/rules/competitive/AllOtherThirdPartyServers.xml", null, ReportBuilder.ListType.Analysis);
                    break;
                }
            }
            if (targetAppServer.isWAS_Traditional()) {
                analyze.loadList("/rules/competitive/AllCompetitiveToTWAS.xml", null, ReportBuilder.ListType.Analysis);
                if (targetAppServer.isWAS90orLater()) {
                    analyze.loadList("/rules/competitive/AllCompetitiveToTWAS90orLater.xml", null, ReportBuilder.ListType.Analysis);
                }
            } else {
                analyze.loadList("/rules/competitive/AllCompetitiveToLiberty.xml", null, ReportBuilder.ListType.Analysis);
            }
        }
    }
}

