/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.asm.utilities;

import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassOrPackageDetails;
import com.ibm.ws.report.binary.asm.utilities.FieldDetails;
import com.ibm.ws.report.binary.asm.utilities.MethodDetails;
import com.ibm.ws.report.binary.asm.utilities.MethodInfo;
import com.ibm.ws.report.binary.asm.utilities.PackageHelper;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.asm.utilities.StackDetails;
import com.ibm.ws.report.binary.utilities.Constants;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.objectweb.asm.Type;

public class ClassDataStore {
    static final Pattern MATCH_CONTENT_AFTER_LAST_DOT_PATTERN = Pattern.compile("\\.[^.]+$");
    private static final Pattern ARCHIVE_REGEX = Pattern.compile(".*\\.(war|jar|ear|rar).*");
    private SimpleDataStore store = null;
    private String classNameWithContext = null;
    private String className = null;
    private String parentName = null;
    private String[] implementedInterfaces = null;
    private int classAccess = 0;
    private boolean collectAllReferencedClassNames = false;
    private Set<String> annotationClassesInterestedIn = null;
    private Set<String> classNamesInterestedIn = null;
    private Set<String> methodNamesInterestedIn = null;
    private Set<String> methodNamesRequireStackDetails = null;
    private Set<String> constructorOwnersInterestedIn = null;
    private Set<String> enumClassesInterestedIn = null;
    private boolean collectReferencedPackages = false;
    private boolean cacheGetterAndSetterMethodNames = false;
    private final Set<String> packageNames = new HashSet<String>();
    private final Set<String> classNames = new HashSet<String>();
    private final Set<String> stringLiterals = new HashSet<String>();
    private final Set<String> methodNames = new HashSet<String>();
    private final Set<String> annotations = new HashSet<String>();
    private final Map<String, ClassOrPackageDetails> packageDetails = new HashMap<String, ClassOrPackageDetails>();
    private final Map<String, ClassOrPackageDetails> classDetails = new HashMap<String, ClassOrPackageDetails>();
    private final Map<String, ClassOrPackageDetails> stringLiteralDetails = new HashMap<String, ClassOrPackageDetails>();
    private final Map<String, MethodDetails> methodDetails = new HashMap<String, MethodDetails>();
    private final List<MethodDetails> methodsImplemented = new ArrayList<MethodDetails>();
    private final Set<String> getterMethodsImplemented = new HashSet<String>();
    private final Set<String> setterMethodsImplemented = new HashSet<String>();
    private final Map<String, List<String>> qualifiedMethodNameToExceptions = new HashMap<String, List<String>>();
    private final List<AnnotationDetails> annotationDetails = new ArrayList<AnnotationDetails>();
    List<Pattern> packagesToExclude = new ArrayList<Pattern>();
    private final Map<String, Integer> fieldModifiers = new HashMap<String, Integer>();
    private final List<FieldDetails> fieldDetails = new ArrayList<FieldDetails>();
    private final Set<String> classAnnotations = new HashSet<String>();
    private boolean annotationsExist = false;
    private Map<String, Set<String>> mapOfReferencedPackages;
    private Map<String, Set<String>> mapOfReferencedClasses;
    private List<String> sharedLibraryArchiveNames;
    private ArrayDeque<StackDetails> lastAddedStack = null;
    private boolean scanClassFileForNonInventoryRules = false;

    public ClassDataStore(String name2, SimpleDataStore store) {
        store.addClassDataStoreByFileName(this, name2);
        this.classNameWithContext = name2;
        this.store = store;
    }

    public void initializeClassData(Set<String> classNames, Set<String> methodNames, Set<String> methodNamesNeedStackDetails, Set<String> constructorOwners, Set<String> annotationClasses, Set<String> enumClasses, boolean collectRefPackages, boolean referenceClassNames, List<Pattern> packagesToExclude, List<String> sharedLibraryArchiveNames, boolean cacheGetterAndSetterMethodNames, boolean scanClassFileForNonInventoryRules) {
        this.classNamesInterestedIn = classNames;
        this.methodNamesInterestedIn = methodNames;
        this.methodNamesRequireStackDetails = methodNamesNeedStackDetails;
        this.constructorOwnersInterestedIn = constructorOwners;
        this.annotationClassesInterestedIn = annotationClasses;
        this.enumClassesInterestedIn = enumClasses;
        this.collectAllReferencedClassNames = referenceClassNames;
        this.collectReferencedPackages = collectRefPackages;
        this.mapOfReferencedPackages = this.store.getMapReferencedPackageNames();
        this.mapOfReferencedClasses = this.store.getMapOfReferencedClassNames();
        this.packagesToExclude = packagesToExclude;
        this.sharedLibraryArchiveNames = sharedLibraryArchiveNames;
        this.cacheGetterAndSetterMethodNames = cacheGetterAndSetterMethodNames;
        this.scanClassFileForNonInventoryRules = scanClassFileForNonInventoryRules;
    }

    public String getClassNameWithContext() {
        return this.classNameWithContext;
    }

    public Map<String, MethodDetails> getMethodDetails() {
        return this.methodDetails;
    }

    public MethodDetails getMethodDetails(String methodName) {
        if (this.methodDetails.containsKey(methodName)) {
            return this.methodDetails.get(methodName);
        }
        return null;
    }

    public Map<String, MethodDetails> getMethodDetails(String[] methodNames) {
        HashMap<String, MethodDetails> mds = new HashMap<String, MethodDetails>();
        String[] stringArray = methodNames;
        int n = methodNames.length;
        int n2 = 0;
        while (n2 < n) {
            String methodName = stringArray[n2];
            MethodDetails md = this.methodDetails.get(methodName);
            if (md != null) {
                mds.put(methodName, md);
            }
            ++n2;
        }
        return mds;
    }

    public List<MethodDetails> getImplementedMethodDetails(String methodName) {
        ArrayList<MethodDetails> mds = new ArrayList<MethodDetails>();
        for (MethodDetails md : this.methodsImplemented) {
            if (!md.getName().equals(methodName)) continue;
            mds.add(md);
        }
        return mds;
    }

    public MethodDetails getImplementedMethodDetail(String methodSignature) {
        for (MethodDetails md : this.methodsImplemented) {
            String signature = md.getSignature();
            if (signature == null || !signature.equals(methodSignature)) continue;
            return md;
        }
        return null;
    }

    public List<MethodDetails> getImplementedMethodDetails() {
        return this.methodsImplemented;
    }

    public Set<String> getImplementedGetterMethods() {
        return this.getterMethodsImplemented;
    }

    public Set<String> getImplementedSetterMethods() {
        return this.setterMethodsImplemented;
    }

    public Set<ClassOrPackageDetails> getStringLiteralDetails(Pattern stringLiteral) {
        HashSet<ClassOrPackageDetails> cpds = new HashSet<ClassOrPackageDetails>();
        Set<String> keys = this.stringLiteralDetails.keySet();
        for (String key : keys) {
            if (!stringLiteral.matcher(key).matches()) continue;
            cpds.add(this.stringLiteralDetails.get(key));
        }
        return cpds;
    }

    public ClassOrPackageDetails getClassDetails(String className) {
        if (this.classDetails.containsKey(className)) {
            return this.classDetails.get(className);
        }
        return null;
    }

    public ClassOrPackageDetails[] getPackageDetails(String packageName) {
        return this.getPackageDetails(packageName, null);
    }

    public ClassOrPackageDetails[] getPackageDetails(String packageName, List<String> excludePackageNames) {
        ArrayList<ClassOrPackageDetails> matchingPackageDetails = new ArrayList<ClassOrPackageDetails>();
        if (packageName.endsWith("*")) {
            Set<String> keys = this.packageDetails.keySet();
            for (String key : keys) {
                ClassOrPackageDetails pd = this.packageDetails.get(key);
                String thisPackageName = pd.getClassOrPackageName();
                boolean match = PackageHelper.matchPackageName(thisPackageName, packageName);
                if (!match) continue;
                if (excludePackageNames != null) {
                    if (excludePackageNames.contains(thisPackageName)) continue;
                    boolean exclude = false;
                    for (String excludePackageName : excludePackageNames) {
                        if (excludePackageName.endsWith("*") && (exclude = PackageHelper.matchPackageName(thisPackageName, excludePackageName))) break;
                    }
                    if (exclude) continue;
                    matchingPackageDetails.add(pd);
                    continue;
                }
                matchingPackageDetails.add(pd);
            }
        } else if (this.packageDetails.containsKey(packageName)) {
            ClassOrPackageDetails pd = this.packageDetails.get(packageName);
            matchingPackageDetails.add(pd);
        }
        int size = matchingPackageDetails.size();
        if (size == 0) {
            return null;
        }
        ClassOrPackageDetails[] pds = new ClassOrPackageDetails[size];
        matchingPackageDetails.toArray(pds);
        return pds;
    }

    public Set<String> getPackageNames() {
        return this.packageNames;
    }

    public boolean containsPackageName(String packageName) {
        return PackageHelper.matchPackageName(this.packageNames, packageName);
    }

    public void addPackageName(String name2, String methodName, int lineNumber) {
        this.addPackageName(name2, methodName, lineNumber, 0);
    }

    public void addPackageName(String name2, String methodName, int lineNumber, int occurrenceType) {
        String packageName = "";
        String className = name2.replace('/', '.');
        this.addClass(className, methodName, lineNumber, occurrenceType);
        int slash = className.lastIndexOf(46);
        if (slash > -1) {
            packageName = className.substring(0, slash);
        }
        if (packageName.contains(".")) {
            if (!this.packageNames.contains(packageName)) {
                if (this.collectReferencedPackages && this.scanClassFileForNonInventoryRules) {
                    this.store.addReferencedPackageName(packageName);
                }
                this.packageNames.add(packageName);
                this.packageNames.add(String.valueOf(packageName) + "*");
                ClassOrPackageDetails pd = new ClassOrPackageDetails(packageName, methodName, lineNumber, occurrenceType, className);
                this.packageDetails.put(packageName, pd);
            } else {
                ClassOrPackageDetails pd = this.packageDetails.get(packageName);
                pd.addOccurrence(methodName, lineNumber, occurrenceType, className);
            }
        }
    }

    public void addPackageDesc(Type type, String methodName, int lineNumber) {
        this.addPackageDesc(type, methodName, lineNumber, 0);
    }

    public void addPackageDesc(Type type, String methodName, int lineNumber, int occurrenceType) {
        if (type == null) {
            return;
        }
        if (type.getSort() == 9) {
            this.addPackageName(type.getElementType().getClassName(), methodName, lineNumber, occurrenceType);
        } else if (type.getSort() == 10) {
            this.addPackageName(type.getClassName(), methodName, lineNumber, occurrenceType);
        }
    }

    public Set<String> getClassNames() {
        return this.classNames;
    }

    public boolean containsClassName(String name2) {
        boolean containsClassName = false;
        for (String className : this.classNames) {
            String parentClassName = null;
            if (className.contains("$")) {
                parentClassName = className.split("\\$")[0];
            }
            if (!name2.equals(className) && !name2.equals(parentClassName)) continue;
            containsClassName = true;
            break;
        }
        return containsClassName;
    }

    public void addClass(String name2, String methodName, int lineNumber, int occurrenceType) {
        if (this.collectAllReferencedClassNames && ARCHIVE_REGEX.matcher(this.classNameWithContext).matches()) {
            String archiveName = ReportUtility.getArchiveNamePath(this.classNameWithContext);
            String providedPack = MATCH_CONTENT_AFTER_LAST_DOT_PATTERN.matcher(this.className).replaceFirst("");
            String packageName = MATCH_CONTENT_AFTER_LAST_DOT_PATTERN.matcher(name2).replaceFirst("");
            if (providedPack != null && !providedPack.equals(packageName)) {
                boolean shouldFlag = true;
                for (Pattern reg : this.packagesToExclude) {
                    if (!reg.matcher(name2).matches()) continue;
                    shouldFlag = false;
                    break;
                }
                if (shouldFlag && archiveName != null) {
                    Set<Object> setOfPackages;
                    if (this.sharedLibraryArchiveNames.contains(archiveName)) {
                        Set<Object> setOfClasses;
                        if (this.mapOfReferencedClasses.containsKey(archiveName)) {
                            setOfClasses = this.mapOfReferencedClasses.get(archiveName);
                            setOfClasses.add(name2);
                        } else {
                            setOfClasses = new HashSet<String>();
                            setOfClasses.add(name2);
                            this.mapOfReferencedClasses.put(archiveName, setOfClasses);
                        }
                    }
                    if (this.mapOfReferencedPackages.containsKey(archiveName)) {
                        setOfPackages = this.mapOfReferencedPackages.get(archiveName);
                        setOfPackages.add(packageName);
                    } else {
                        setOfPackages = new HashSet<String>();
                        setOfPackages.add(packageName);
                        this.mapOfReferencedPackages.put(archiveName, setOfPackages);
                    }
                }
            }
        }
        if (this.isInterestedClass(name2)) {
            ClassOrPackageDetails cd;
            if (!this.classNames.contains(name2)) {
                this.classNames.add(name2);
                cd = new ClassOrPackageDetails(name2, methodName, lineNumber, occurrenceType);
                this.classDetails.put(name2, cd);
            } else {
                cd = this.classDetails.get(name2);
                cd.addOccurrence(methodName, lineNumber, occurrenceType);
            }
        }
    }

    public boolean isInterestedClass(String className) {
        boolean isInterestedClass = false;
        String parentClassName = null;
        if (this.classNamesInterestedIn != null) {
            if (className.contains("$")) {
                parentClassName = className.split("\\$")[0];
            }
            for (String interestedClass : this.classNamesInterestedIn) {
                if (!interestedClass.equals(className) && !interestedClass.equals(parentClassName)) continue;
                isInterestedClass = true;
                break;
            }
        }
        return isInterestedClass;
    }

    public Set<String> getStringLiterals() {
        return this.stringLiterals;
    }

    public boolean containsStringLiteral(Pattern name2) {
        boolean flag = false;
        for (String nextStr : this.stringLiterals) {
            if (!name2.matcher(nextStr).matches()) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public void addStringLiteral(String name2, String methodName, int lineNumber) {
        if (!this.stringLiterals.contains(name2)) {
            this.stringLiterals.add(name2);
            ClassOrPackageDetails cd = new ClassOrPackageDetails(name2, methodName, lineNumber);
            this.stringLiteralDetails.put(name2, cd);
        } else {
            ClassOrPackageDetails cd = this.stringLiteralDetails.get(name2);
            cd.addOccurrence(methodName, lineNumber);
        }
    }

    public String getTypeClassName(String name2) {
        Type type = Type.getType(name2);
        String className = null;
        if (type != null) {
            int typeInt = type.getSort();
            switch (typeInt) {
                case 9: {
                    className = type.getElementType().getClassName();
                    break;
                }
                case 10: {
                    className = type.getClassName();
                }
            }
        }
        if (className != null) {
            className = className.replace('/', '.');
        }
        return className;
    }

    public String getTypeString(Type type) {
        String typeString = null;
        if (type != null) {
            int typeInt = type.getSort();
            switch (typeInt) {
                case 9: {
                    typeString = String.valueOf(type.getElementType().getClassName()) + "[]";
                    break;
                }
                case 1: {
                    typeString = "boolean";
                    break;
                }
                case 3: {
                    typeString = "byte";
                    break;
                }
                case 2: {
                    typeString = "char";
                    break;
                }
                case 8: {
                    typeString = "double";
                    break;
                }
                case 6: {
                    typeString = "float";
                    break;
                }
                case 5: {
                    typeString = "int";
                    break;
                }
                case 7: {
                    typeString = "long";
                    break;
                }
                case 10: {
                    typeString = type.getClassName();
                    break;
                }
                case 4: {
                    typeString = "short";
                    break;
                }
                case 0: {
                    typeString = "void";
                }
            }
        }
        return typeString;
    }

    public String[] getArgumentTypes(Type[] argTypes) {
        if (argTypes == null || argTypes.length == 0) {
            return new String[0];
        }
        String[] argumentTypeStr = new String[argTypes.length];
        int i = 0;
        while (i < argTypes.length) {
            String typeString = this.getTypeString(argTypes[i]);
            if (typeString == null) {
                typeString = "null";
            }
            argumentTypeStr[i] = typeString;
            ++i;
        }
        return argumentTypeStr;
    }

    public void addMethodImplemented(String name2, String signature, String desc, List<String> exceptions, boolean isPublic) {
        if (this.methodNamesInterestedIn != null && (this.methodNamesInterestedIn.contains(name2) || this.methodNamesInterestedIn.contains("*"))) {
            Type type = Type.getType(desc);
            String returnTypeStr = null;
            String[] argumentTypeStr = null;
            if (type != null) {
                returnTypeStr = this.getTypeString(type.getReturnType());
                argumentTypeStr = this.getArgumentTypes(type.getArgumentTypes());
            }
            MethodDetails md = null;
            if (this.methodNamesInterestedIn.contains("*") && !name2.equals("<init>")) {
                String fullClassName = this.getClassNameWithContext();
                int indexOfArchiveName = fullClassName.lastIndexOf(ReportUtility.getFirstArchiveName(fullClassName));
                int indexOfDotClass = fullClassName.lastIndexOf(".class");
                this.qualifiedMethodNameToExceptions.put(String.valueOf(fullClassName.substring(indexOfArchiveName, indexOfDotClass).replace('/', '.')) + "." + name2, exceptions == null ? new ArrayList() : exceptions);
            }
            md = new MethodDetails(name2, signature, this.className, returnTypeStr, argumentTypeStr);
            md.setPublic(isPublic);
            this.methodsImplemented.add(md);
        }
        if (this.cacheGetterAndSetterMethodNames && Constants.GETTER_OR_SETTER_METHOD_REGEX.matcher(name2).matches()) {
            if (Constants.GETTER_METHOD_REGEX.matcher(name2).matches()) {
                this.getterMethodsImplemented.add(name2);
            } else {
                this.setterMethodsImplemented.add(name2);
            }
        }
    }

    public void addMethod(String name2, String signature, String owner, String desc, String methodName, int lineNumber, ArrayDeque<StackDetails> sd, List<String> activeCatchExceptions, List<String> activeThrowsExceptions, int methodNumber) {
        if (this.shouldAddMethod(name2)) {
            String ownerName = owner.replace('/', '.');
            boolean isConstructor = name2.equals("<init>");
            if (!isConstructor || isConstructor && this.constructorOwnersInterestedIn.contains(ownerName) || this.constructorOwnersInterestedIn.contains("*")) {
                Type type = Type.getType(desc);
                String returnTypeStr = null;
                String[] argumentTypeStr = null;
                if (type != null) {
                    returnTypeStr = this.getTypeString(type.getReturnType());
                    argumentTypeStr = this.getArgumentTypes(type.getArgumentTypes());
                }
                ArrayDeque<StackDetails> copySdd = null;
                copySdd = this.methodNamesRequireStackDetails.contains(name2) ? sd.clone() : new ArrayDeque<StackDetails>(0);
                this.lastAddedStack = copySdd;
                if (!this.methodNames.contains(name2)) {
                    this.methodNames.add(name2);
                    MethodDetails md = new MethodDetails(name2, signature, ownerName, returnTypeStr, argumentTypeStr, methodName, lineNumber, copySdd, activeCatchExceptions, activeThrowsExceptions, methodNumber);
                    this.methodDetails.put(name2, md);
                } else {
                    MethodDetails md = this.methodDetails.get(name2);
                    md.addOccurence(ownerName, returnTypeStr, argumentTypeStr, methodName, lineNumber, copySdd, activeCatchExceptions, activeThrowsExceptions, methodNumber);
                }
            }
        }
    }

    public boolean shouldAddMethod(String name2) {
        if (this.methodNamesInterestedIn != null) {
            for (String methodNameInterestedIn : this.methodNamesInterestedIn) {
                String regex;
                int length;
                int firstIndexOfAstrix;
                if (methodNameInterestedIn.equals(name2) || methodNameInterestedIn.equals("*")) {
                    return true;
                }
                if (!methodNameInterestedIn.contains("*") || !((firstIndexOfAstrix = methodNameInterestedIn.indexOf("*")) == methodNameInterestedIn.lastIndexOf("*") ? firstIndexOfAstrix == (length = methodNameInterestedIn.length()) - 1 && name2.startsWith(methodNameInterestedIn.substring(0, length - 1)) || firstIndexOfAstrix == 0 && name2.endsWith(methodNameInterestedIn.substring(1)) || name2.startsWith(methodNameInterestedIn.substring(0, length - 1)) && name2.endsWith(methodNameInterestedIn.substring(1)) : name2.matches(regex = ReportUtility.replace(methodNameInterestedIn, "*", ".*")))) continue;
                return true;
            }
        }
        return false;
    }

    public void addClassAnnotation(Type desc) {
        this.classAnnotations.add(this.getTypeString(desc));
    }

    public Set<String> getClassAnnotations() {
        return this.classAnnotations;
    }

    public boolean doesContainClassAnnotation(String name2) {
        return this.classAnnotations.contains(name2);
    }

    public List<AnnotationDetails> getAnnotationDetails(String name2) {
        ArrayList<AnnotationDetails> returnList = new ArrayList<AnnotationDetails>();
        for (AnnotationDetails ad : this.annotationDetails) {
            if (!ad.getName().equals(name2)) continue;
            returnList.add(ad);
        }
        return returnList;
    }

    public List<AnnotationDetails> getAnnotationDetailsByMethodSignature(String signature) {
        ArrayList<AnnotationDetails> returnList = new ArrayList<AnnotationDetails>();
        for (AnnotationDetails ad : this.annotationDetails) {
            if (!signature.equals(ad.getMethodSignature())) continue;
            returnList.add(ad);
        }
        return returnList;
    }

    public boolean containsAnnotation(String name2) {
        return this.annotations.contains(name2);
    }

    public AnnotationDetails addAnnotation(String annotationClass, String reference, int lineNumber, int referenceType) {
        String className = this.getTypeString(Type.getType(annotationClass));
        if (this.annotationClassesInterestedIn != null && this.annotationClassesInterestedIn.contains(className)) {
            if (!this.annotations.contains(className)) {
                this.annotations.add(className);
            }
            AnnotationDetails ad = new AnnotationDetails(className, reference, lineNumber, referenceType);
            this.annotationDetails.add(ad);
            return ad;
        }
        return null;
    }

    public void addAnnotationDetails(AnnotationDetails ad, String type, String name2, String value, String reference, int lineNumber) {
        String typeClass = this.getTypeString(Type.getType(type));
        ad.addOccurrence(name2, typeClass, value, reference, lineNumber);
    }

    public void addAnnotationDetails(AnnotationDetails ad, String name2, Object value, String reference, int lineNumber) {
        if (value != null) {
            if (value instanceof Type) {
                String valueStr = this.getTypeString((Type)value);
                ad.addOccurrence(name2, valueStr, reference, lineNumber);
            } else {
                ad.addOccurrence(name2, value, reference, lineNumber);
            }
        }
    }

    public void addField(Type type, String name2, String reference, int lineNumber) {
        String className = this.getTypeString(type);
        this.addField(className, name2, reference, lineNumber);
    }

    public void addField(String className, String name2, String reference, int lineNumber) {
        if (className != null) {
            className = className.replace('/', '.');
        }
        if (this.enumClassesInterestedIn != null && this.enumClassesInterestedIn.contains(className)) {
            FieldDetails fd = new FieldDetails(className, name2, reference, lineNumber);
            this.fieldDetails.add(fd);
        }
    }

    public List<FieldDetails> getFieldDetails(String type) {
        ArrayList<FieldDetails> fds = new ArrayList<FieldDetails>();
        for (FieldDetails fd : this.fieldDetails) {
            if (!fd.getType().equals(type)) continue;
            fds.add(fd);
        }
        return fds;
    }

    public void addClassField(String name2, int access) {
        this.fieldModifiers.put(name2, new Integer(access));
    }

    public Set<String> getFieldsForModifier(int onModifier, int offModifer) {
        HashSet<String> fieldsThatMatch = new HashSet<String>();
        Set<String> fieldNames = this.fieldModifiers.keySet();
        for (String name2 : fieldNames) {
            boolean matchModifier;
            Integer accessInteger = this.fieldModifiers.get(name2);
            boolean bl = matchModifier = (accessInteger & onModifier) == onModifier && (accessInteger & offModifer) == 0;
            if (!matchModifier) continue;
            fieldsThatMatch.add(name2);
        }
        return fieldsThatMatch;
    }

    public boolean doesFieldHaveModifier(String fieldName, int modifier) {
        if (this.fieldModifiers.containsKey(fieldName)) {
            Integer modifiers = this.fieldModifiers.get(fieldName);
            return (modifiers & modifier) == modifier;
        }
        return false;
    }

    public boolean isInterface() {
        return (this.classAccess & 0x200) == 512;
    }

    public boolean isPublicInterface() {
        return this.isInterface() && this.isPublic();
    }

    public boolean isPublic() {
        return (this.classAccess & 1) == 1;
    }

    public boolean isAbstract() {
        return (this.classAccess & 0x400) == 1024;
    }

    public void setClassData(String name2, String superName, String[] interfaces, int access) {
        this.className = name2.replace('/', '.');
        this.store.addClassDataStoreByClassName(this, this.className);
        if (superName != null) {
            this.parentName = superName.replace('/', '.');
        }
        if (interfaces != null && interfaces.length > 0) {
            this.implementedInterfaces = new String[interfaces.length];
            int i = 0;
            String[] stringArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                String interf = stringArray[n2];
                String interfaceNName = interf.replace('/', '.');
                this.implementedInterfaces[i++] = interfaceNName;
                ++n2;
            }
        }
        this.classAccess = access;
    }

    public String getClassName() {
        return this.className;
    }

    public String getParent() {
        return this.parentName;
    }

    public String[] getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public boolean doesClassImplement(String interfaceName) {
        boolean flag = false;
        if (this.implementedInterfaces != null) {
            String[] stringArray = this.implementedInterfaces;
            int n = this.implementedInterfaces.length;
            int n2 = 0;
            while (n2 < n) {
                String interf = stringArray[n2];
                if (interfaceName.equals(interf)) {
                    flag = true;
                    break;
                }
                ++n2;
            }
        }
        return flag;
    }

    public boolean doesClassImplementMethod(String methodName, String[] methodArgs, String accessFlag) {
        boolean flag = false;
        for (MethodDetails md : this.methodsImplemented) {
            if (!methodName.equals(md.getName())) continue;
            if (methodArgs != null && methodArgs.length > 0) {
                Set<MethodInfo> mis = md.getMethodInfo(this.className);
                if (mis == null) continue;
                for (MethodInfo thisMI : mis) {
                    if (!thisMI.matches(null, methodArgs)) continue;
                    if (accessFlag != null) {
                        if (!("public".equals(accessFlag) ? md.isPublic() : "non-public".equals(accessFlag) && !md.isPublic())) continue;
                        return true;
                    }
                    return true;
                }
                continue;
            }
            if (accessFlag != null) {
                if (!("public".equals(accessFlag) ? md.isPublic() : "non-public".equals(accessFlag) && !md.isPublic())) continue;
                return true;
            }
            return true;
        }
        return flag;
    }

    public boolean doesClassImplementMethod(String methodName, String[] methodArgs) {
        return this.doesClassImplementMethod(methodName, methodArgs, null);
    }

    public ArrayDeque<StackDetails> getLastAddedStack() {
        return this.lastAddedStack;
    }

    public boolean doesClassExtend(String superName) {
        if (!this.isInterface()) {
            if (superName.equals("*")) {
                return true;
            }
            if (this.parentName == null) {
                return false;
            }
            if (superName.startsWith("*")) {
                return this.parentName.endsWith(superName.substring(1));
            }
            return superName.equals(this.parentName);
        }
        return this.doesClassImplement(superName);
    }

    public boolean hasAnnotations() {
        return this.annotationsExist;
    }

    public void setHasAnnotations(boolean hasAnnotations) {
        this.annotationsExist = hasAnnotations;
    }

    public Map<String, List<String>> getQualifiedMethodNameToExceptions() {
        return this.qualifiedMethodNameToExceptions;
    }
}

