/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.reader.BinaryReportReader;
import com.ibm.ws.report.binary.rules.Rule;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class ReportInputData {
    private boolean _london = false;
    private boolean _migrateAllConfig = false;
    private boolean _generateAllSeparateReports = false;
    private static boolean _detectSharedLibraries = false;
    private boolean _hiddenJunitFlag = false;
    private static boolean _loadAllRules = false;
    private static boolean _showAllHelp = false;
    private static boolean _includeHelpLocation = false;
    private boolean _replaceRulesFlag = false;
    private File[] _ruleXmlFiles = null;
    private int _maxUserDefinedRuleResults;
    private String _userRuleLocation;
    private Pattern _excludeFilesPattern;
    private String _excludeFilesPatternOption = null;
    private String _includePackagesOption = null;
    private String _excludePackagesOption = null;
    private Set<String> _excludedRules = null;
    private String _includePackagesRegex = null;
    private String _excludePackagesRegex = null;
    private String _excludePackagesDefaultRegex = "(ch/qos/|com/cloudant/|com/cognos/|com/fasterxml/|com/filenet/|com/ibatis/|com/ibm/(?!websphere/samples/)|com/informix/|com/lowagie/|com/mchange/|com/meterware/|com/microsoft/|com/mongodb/|com/mysql/|com/sun/|com/sybase/|filenet/|freemarker/|groovy/|jakarta/|java/|javax/|net/|oracle/|org/|sqlj/|sun/|twitter4j/|_ibmjsp/).*";
    private String _excludePackagesDefaultPackages = "ch.qos,com.cloudant,com.cognos,com.fasterxml,com.filenet,com.ibatis,com.ibm,com.informix,com.lowagie,com.mchange,com.meterware,com.microsoft,com.mongodb,com.mysql,com.sun,com.sybase,filenet,freemarker,groovy,jakarta,java,javax,net,oracle,org,sqlj,sun,twitter4j,_ibmjsp";
    private String _excludePackagesDefaultOption = "--excludePackages=" + this._excludePackagesDefaultPackages;
    private static boolean _stopOnMissingBinary = false;
    private static boolean _stopOnMissingSharedLibrary = false;
    private static boolean targetJakartaEEParameterUsed = false;
    private static boolean sourceJakartaEEParameterUsed = false;
    private boolean _coreEdition = false;
    private boolean _baseEdition = false;
    private boolean _ndEdition = false;
    private boolean _zosEdition = false;
    private boolean _libertyProfile = false;
    private boolean _fullProfile = false;
    private AppServer _sourceAppServer = null;
    private AppServer _targetAppServer = null;
    private TargetCloud _targetCloud = null;
    private JavaVersion _sourceJava = null;
    private JavaVersion _targetJava = null;
    private JavaEEVersion _sourceJavaEE = null;
    private JavaEEVersion _targetJavaEE = null;
    private MicroProfileVersion _targetMicroProfile = null;
    private final boolean _version855 = true;
    private boolean _display = true;
    private boolean generateTA = false;
    private boolean _clean = false;
    private boolean _delete = false;
    private EnumSet<OutputType> _reportOutputType = EnumSet.noneOf(OutputType.class);
    private boolean _inputIsDirWithOneArchive = false;
    private File _outputDir = null;
    private Map<OutputType, File> _outputFileMap = new HashMap<OutputType, File>();
    private final EnumSet<ReportType> _reportTypes = EnumSet.noneOf(ReportType.class);
    private BinaryReportReader.BinaryType _projectInputStreamType = null;
    private InputStream _projectInputStream = null;
    private List<String> _projectNames = new ArrayList<String>();
    private List<File> _projectFiles = new ArrayList<File>();
    private List<File> _sharedLibraryFiles = new ArrayList<File>();
    private List<String> _applicationNames = new ArrayList<String>();
    private Set<File> _binaryLocations = new HashSet<File>();
    private final Set<String> _projectDirPaths = new HashSet<String>();
    private final Set<String> _projectDirPathsNormalized = new HashSet<String>();
    private final Map<AppServer, Boolean> filterAnalysisRulesByFeatureList = new HashMap<AppServer, Boolean>();
    private String _prefix = "_";
    private final Map<String, Boolean> PRODUCTS = new LinkedHashMap<String, Boolean>();
    public Map<String, Rule> _rules = new HashMap<String, Rule>();
    private Map<File, File> _appToConfigDir = null;
    private boolean _includeSensitiveData = false;
    private static Map<File, String> mapOfAppsToProfiles = null;
    private static Map<String, String> mapOfProfilesToPaths = null;
    private List<String> _includeApplications = null;
    private List<String> _excludeApplications = null;
    private boolean _runFromTaDc = false;

    public ReportInputData(List<File> projectFiles, List<String> projectNames, ReportType reportType) {
        this._projectFiles = projectFiles;
        this._projectNames = projectNames;
        this._reportTypes.add(reportType);
        this.setSpecifiedProducts();
    }

    public ReportInputData(InputStream projectInputStream, List<String> projectNames, String[] args, BinaryReportReader.BinaryType type) {
        this(new ArrayList<File>(), projectNames, args);
        this._projectInputStream = projectInputStream;
        this._projectInputStreamType = type;
    }

    public ReportInputData(List<File> projectFiles, List<String> projectNames, String targetJavaEE, String targetMicroProfile) {
        this._projectFiles = projectFiles;
        this._projectNames = projectNames;
        this._reportOutputType.add(OutputType.XML);
        AppServer sourceAppServer = AppServer.JBOSS;
        AppServer targetAppServer = AppServer.LIBERTY;
        JavaEEVersion targetJavaEEVersion = targetJavaEE != null ? JavaEEVersion.getJavaEEVersion(targetJavaEE) : null;
        MicroProfileVersion targetMicroProfileVersion = targetMicroProfile != null ? MicroProfileVersion.getMicroProfileVersion(targetMicroProfile) : null;
        this.initializeGenerateConfig(sourceAppServer, targetAppServer, targetJavaEEVersion, targetMicroProfileVersion, null, false, null);
    }

    public ReportInputData(AppServer targetAppServer, JavaEEVersion targetJavaEEVersion) {
        this._reportOutputType.add(OutputType.XML);
        this.initializeGenerateConfig(null, targetAppServer, targetJavaEEVersion, null, null, false, null);
    }

    public ReportInputData(List<File> projectFiles, List<String> projectNames, String[] args) {
        this._projectFiles = projectFiles;
        this._projectNames = projectNames;
        this._reportOutputType.add(OutputType.HTML);
        this.initializeEvaluate(false, false, false, false, false, false);
        this.initializeInventory(new ArrayList<File>());
        AppServer sourceAppServer = null;
        AppServer targetAppServer = null;
        JavaVersion sourceJavaVersion = null;
        JavaVersion targetJavaVersion = null;
        JavaEEVersion sourceJavaEEVersion = null;
        JavaEEVersion targetJavaEEVersion = null;
        TargetCloud targetCloud = null;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg != null) {
                if (arg.startsWith("--sourceAppServer=")) {
                    sourceAppServer = AppServer.getAppServer(arg);
                } else if (arg.startsWith("--targetAppServer=")) {
                    targetAppServer = AppServer.getAppServer(arg);
                } else if (arg.startsWith("--sourceJavaEE=") || arg.startsWith("--sourceJakartaEE=")) {
                    sourceJavaEEVersion = JavaEEVersion.getJavaEEVersion(arg);
                } else if (arg.startsWith("--targetJavaEE=") || arg.startsWith("--targetJakartaEE=")) {
                    targetJavaEEVersion = JavaEEVersion.getJavaEEVersion(arg);
                } else if (arg.startsWith("--targetCloud=")) {
                    targetCloud = TargetCloud.getTargetCloud(arg);
                } else if (arg.startsWith("--sourceJava=")) {
                    sourceJavaVersion = JavaVersion.getJavaVersion(arg);
                } else if (arg.startsWith("--targetJava=")) {
                    targetJavaVersion = JavaVersion.getJavaVersion(arg);
                } else if (arg.startsWith("--includePackages=")) {
                    String packages = arg.substring(arg.indexOf(61) + 1);
                    if (ReportUtility.validPackages(packages = packages.trim())) {
                        this._includePackagesOption = arg;
                        this._includePackagesRegex = this.getPackagesRegex(packages);
                        if (this._includePackagesRegex.length() > 0 || this._excludePackagesRegex.length() > 0) {
                            this._excludePackagesDefaultRegex = null;
                            this._excludePackagesDefaultOption = null;
                        }
                    }
                } else if (arg.equals("--scanAll")) {
                    this.setScanAll();
                }
            }
            ++n2;
        }
        this.initializeAnalyze(sourceAppServer, targetAppServer, sourceJavaVersion, targetJavaVersion, sourceJavaEEVersion, targetJavaEEVersion, targetCloud);
        this.initializeGenerateConfig(sourceAppServer, targetAppServer, targetJavaEEVersion, null, null, false, null);
    }

    public ReportInputData(File outputDir, boolean display, EnumSet<OutputType> reportOutputType, Map<OutputType, File> outputFileMap, List<File> projectFiles, List<String> projectNames, List<String> applicationNames, Map<File, File> appToConfigDir, boolean includeSensitiveData, String includePackages, String excludePackages, Pattern excludeFilesPattern, boolean libertyProfile, boolean fullProfile, boolean coreEdition, boolean baseEdition, boolean ndEdition, boolean zosEdition, AppServer sourceAppServer, AppServer targetAppServer, JavaVersion sourceJavaVersion, JavaVersion targetJavaVersion, JavaEEVersion sourceJavaEEVersion, JavaEEVersion targetJavaEEVersion, TargetCloud targetCloud, List<File> sharedLibraryFiles, boolean inputIsDirWithOneArchive, String prefix) {
        this._outputDir = outputDir;
        if (sourceAppServer == AppServer.WEBLOGIC) {
            this._excludePackagesDefaultRegex = "(ch/qos/|com/cognos|/com/cloudant/|com/fasterxml/|com/filenet/|com/ibatis/|com/ibm/(?!websphere/samples/)|com/informix/|com/lowagie/|com/mchange/|com/meterware/|com/microsoft/|com/mongodb/|com/mysql/|com/sun/|com/sybase/|filenet/|freemarker/|groovy/|jakarta/|java/|javax/|net/|oracle/|org/|sqlj/|sun/|twitter4j/|_ibmjsp/|weblogic/|kodo/|com/solarmetric/|com/bea/).*";
            this._excludePackagesDefaultPackages = "ch.qos,com.cloudant,com.cognos,com.fasterxml,com.filenet,com.ibatis,com.ibm,com.informix,com.lowagie,com.mchange,com.meterware,com.microsoft,com.mongodb,com.mysql,com.sun,com.sybase,filenet,freemarker,groovy,jakarta,java,javax,net,oracle,org,sqlj,sun,twitter4j,_ibmjsp,weblogic,kodo,com.solarmetric,com.bea";
            this._excludePackagesDefaultOption = "--excludePackages=" + this._excludePackagesDefaultPackages;
        }
        this.initializeCommon(display, reportOutputType, outputFileMap, projectFiles, projectNames, applicationNames, inputIsDirWithOneArchive, includePackages, excludePackages, excludeFilesPattern, prefix, null);
        this.initializeEvaluate(libertyProfile, fullProfile, coreEdition, baseEdition, ndEdition, zosEdition);
        this.initializeAnalyze(sourceAppServer, targetAppServer, sourceJavaVersion, targetJavaVersion, sourceJavaEEVersion, targetJavaEEVersion, targetCloud);
        this.initializeInventory(sharedLibraryFiles);
        this.initializeGenerateConfig(sourceAppServer, targetAppServer, targetJavaEEVersion, null, appToConfigDir, includeSensitiveData, sharedLibraryFiles);
    }

    public ReportInputData(File outputDir, boolean display, EnumSet<OutputType> reportOutputType, boolean libertyProfile, boolean fullProfile, boolean coreEdition, boolean baseEdition, boolean ndEdition, boolean zosEdition, Map<OutputType, File> outputFileMap, List<File> projectFiles, List<String> projectNames, List<String> applicationNames, ReportType reportType, String includePackages, String excludePackages, Pattern excludeFilesPattern, String prefix) {
        this._outputDir = outputDir;
        this.initializeCommon(display, reportOutputType, outputFileMap, projectFiles, projectNames, applicationNames, false, includePackages, excludePackages, excludeFilesPattern, prefix, null);
        this.initializeEvaluate(libertyProfile, fullProfile, coreEdition, baseEdition, ndEdition, zosEdition);
    }

    public ReportInputData(File outputDir, boolean display, EnumSet<OutputType> reportOutputType, AppServer sourceAppServer, AppServer targetAppServer, JavaVersion sourceJavaVersion, JavaVersion targetJavaVersion, JavaEEVersion sourceJavaEEVersion, JavaEEVersion targetJavaEEVersion, TargetCloud targetCloud, Map<OutputType, File> outputFileMap, List<File> projectFiles, List<String> projectNames, List<String> applicationNames, Map<File, File> appToConfigDir, ReportType reportType, String includePackages, String excludePackages, Pattern excludeFilesPattern, String prefix, Set<String> excludedRulesSet) {
        this._appToConfigDir = appToConfigDir;
        this._outputDir = outputDir;
        if (sourceAppServer == AppServer.WEBLOGIC) {
            this._excludePackagesDefaultRegex = "(ch/qos/|com/cognos|/com/cloudant/|com/fasterxml/|com/filenet/|com/ibatis/|com/ibm/(?!websphere/samples/)|com/informix/|com/lowagie/|com/mchange/|com/meterware/|com/microsoft/|com/mongodb/|com/mysql/|com/sun/|com/sybase/|filenet/|freemarker/|groovy/|jakarta/|java/|javax/|net/|oracle/|org/|sqlj/|sun/|twitter4j/|_ibmjsp/|weblogic/|kodo/|com/solarmetric/|com/bea/).*";
            this._excludePackagesDefaultPackages = "ch.qos,com.cloudant,com.cognos,com.fasterxml,com.filenet,com.ibatis,com.ibm,com.informix,com.lowagie,com.mchange,com.meterware,com.microsoft,com.mongodb,com.mysql,com.sun,com.sybase,filenet,freemarker,groovy,jakarta,java,javax,net,oracle,org,sqlj,sun,twitter4j,_ibmjsp,weblogic,kodo,com.solarmetric,com.bea";
            this._excludePackagesDefaultOption = "--excludePackages=" + this._excludePackagesDefaultPackages;
        }
        this.initializeCommon(display, reportOutputType, outputFileMap, projectFiles, projectNames, applicationNames, false, includePackages, excludePackages, excludeFilesPattern, prefix, excludedRulesSet);
        this.initializeAnalyze(sourceAppServer, targetAppServer, sourceJavaVersion, targetJavaVersion, sourceJavaEEVersion, targetJavaEEVersion, targetCloud);
    }

    public ReportInputData(File outputDir, boolean display, EnumSet<OutputType> reportOutputType, Map<OutputType, File> outputFileMap, List<File> projectFiles, List<String> projectNames, List<File> sharedLibraryFiles, ReportType reportType, String includePackages, String excludePackages, Pattern excludeFilesPattern, boolean inputIsDirWithOneArchive, String prefix, Map<File, File> appToConfigDir) {
        this._appToConfigDir = appToConfigDir;
        this._outputDir = outputDir;
        this.initializeCommon(display, reportOutputType, outputFileMap, projectFiles, projectNames, null, inputIsDirWithOneArchive, includePackages, excludePackages, excludeFilesPattern, prefix, null);
        this.initializeInventory(sharedLibraryFiles);
    }

    public ReportInputData(EnumSet<OutputType> reportOutputType, Map<OutputType, File> outputFileMap, AppServer sourceAppServer, AppServer targetAppServer, JavaEEVersion targetJavaEEVersion, List<File> projectFiles, List<String> projectNames, ReportType reportType, Map<File, File> appToConfigDir, boolean includeSensitiveData, String includePackages, String excludePackages, Pattern excludeFilesPattern, boolean inputIsDirWithOneArchive, String prefix, List<File> sharedLibraryFiles) {
        this.initializeCommon(false, reportOutputType, outputFileMap, projectFiles, projectNames, null, inputIsDirWithOneArchive, includePackages, excludePackages, excludeFilesPattern, prefix, null);
        this.initializeGenerateConfig(sourceAppServer, targetAppServer, targetJavaEEVersion, null, appToConfigDir, includeSensitiveData, sharedLibraryFiles);
    }

    private void initializeCommon(boolean display, EnumSet<OutputType> reportOutputType, Map<OutputType, File> outputFileMap, List<File> projectFiles, List<String> projectNames, List<String> applicationNames, boolean inputIsDirWithOneArchive, String includePackages, String excludePackages, Pattern excludeFilesPattern, String prefix, Set<String> excludedRulesSet) {
        this._display = display;
        this._reportOutputType = reportOutputType;
        this._outputFileMap = outputFileMap;
        this._projectFiles = projectFiles;
        this._projectNames = projectNames;
        this._applicationNames = applicationNames;
        this._inputIsDirWithOneArchive = inputIsDirWithOneArchive;
        this._includePackagesOption = includePackages;
        this._includePackagesRegex = this.getPackagesRegex(includePackages);
        this._excludePackagesOption = excludePackages;
        this._excludePackagesRegex = this.getPackagesRegex(excludePackages);
        this._excludedRules = excludedRulesSet;
        if (this._includePackagesRegex.length() > 0 || this._excludePackagesRegex.length() > 0) {
            this._excludePackagesDefaultRegex = null;
            this._excludePackagesDefaultOption = null;
        }
        if (excludeFilesPattern != null) {
            this._excludeFilesPattern = excludeFilesPattern;
            this._excludeFilesPatternOption = "--excludeFiles=" + this._excludeFilesPattern.toString();
        }
        this._prefix = prefix;
    }

    private void initializeEvaluate(boolean libertyProfile, boolean fullProfile, boolean coreEdition, boolean baseEdition, boolean ndEdition, boolean zosEdition) {
        this._reportTypes.add(ReportType.EVALUATE);
        this._libertyProfile = libertyProfile;
        this._fullProfile = fullProfile;
        this._coreEdition = coreEdition;
        this._baseEdition = baseEdition;
        this._ndEdition = ndEdition;
        this._zosEdition = zosEdition;
        this.setSpecifiedProducts();
    }

    private void initializeAnalyze(AppServer sourceAppServer, AppServer targetAppServer, JavaVersion sourceJavaVersion, JavaVersion targetJavaVersion, JavaEEVersion sourceJavaEEVersion, JavaEEVersion targetJavaEEVersion, TargetCloud targetCloud) {
        this._reportTypes.add(ReportType.ANALYZE);
        this._sourceAppServer = sourceAppServer;
        this._targetAppServer = targetAppServer;
        this._sourceJava = sourceJavaVersion;
        this._targetJava = targetJavaVersion;
        this._sourceJavaEE = sourceJavaEEVersion;
        this._targetJavaEE = targetJavaEEVersion;
        this._targetCloud = targetCloud;
    }

    private void initializeInventory(List<File> sharedLibraryFiles) {
        this._reportTypes.add(ReportType.INVENTORY);
        this._sharedLibraryFiles = sharedLibraryFiles;
    }

    private void initializeGenerateConfig(AppServer sourceAppServer, AppServer targetAppServer, JavaEEVersion targetJavaEEVersion, MicroProfileVersion targetMicroProfileVersion, Map<File, File> appToConfigDir, boolean includeSensitiveData, List<File> sharedLibraryFiles) {
        this._reportTypes.add(ReportType.GENERATE_CONFIG);
        this._targetJavaEE = targetJavaEEVersion;
        this._targetMicroProfile = targetMicroProfileVersion;
        this._sourceAppServer = sourceAppServer;
        this._targetAppServer = targetAppServer;
        this._appToConfigDir = appToConfigDir;
        this._includeSensitiveData = includeSensitiveData;
        if (sharedLibraryFiles != null) {
            this._sharedLibraryFiles = sharedLibraryFiles;
        }
    }

    public String getPrefix() {
        return this._prefix;
    }

    public EnumSet<ReportType> getReportTypes() {
        return this._reportTypes;
    }

    public boolean isEvaluationReport() {
        return this._reportTypes.contains((Object)ReportType.EVALUATE);
    }

    public boolean isInventoryReport() {
        return this._reportTypes.contains((Object)ReportType.INVENTORY);
    }

    public boolean isAnalysisReport() {
        return this._reportTypes.contains((Object)ReportType.ANALYZE);
    }

    public boolean isGenerateConfigReport() {
        return this._reportTypes.contains((Object)ReportType.GENERATE_CONFIG);
    }

    public boolean isInputDirectoryWithOneArchive() {
        return this._inputIsDirWithOneArchive;
    }

    public EnumSet<OutputType> getOutputType() {
        return this._reportOutputType;
    }

    public void addOutputType(OutputType type) {
        this._reportOutputType.add(type);
    }

    public void setDisplay(boolean flag) {
        this._display = flag;
    }

    public boolean isDisplay() {
        return this._display;
    }

    public void addOutputFile(File outputFile) {
        String path = outputFile.getAbsolutePath();
        int indexOfExtension = path.lastIndexOf(46);
        this._outputFileMap.put(OutputType.getOutputType(path.substring(indexOfExtension)), outputFile);
    }

    public Map<OutputType, File> getOutputFile() {
        return this._outputFileMap;
    }

    public File getOutputDir() {
        return this._outputDir;
    }

    public Pattern getExcludeFilesPattern() {
        return this._excludeFilesPattern;
    }

    public void setProjectData(List<File> projectFiles, List<String> projectNames) {
        this._projectFiles = projectFiles;
        this._projectNames = projectNames;
    }

    public BinaryReportReader.BinaryType getProjectInputStreamType() {
        return this._projectInputStreamType;
    }

    public InputStream getProjectInputStream() {
        return this._projectInputStream;
    }

    public List<File> getProjectFiles() {
        return this._projectFiles;
    }

    public List<String> getProjectNames() {
        return this._projectNames;
    }

    public List<String> getApplicationNames() {
        return this._applicationNames;
    }

    public Map<File, File> getAppToConfigDir() {
        return this._appToConfigDir;
    }

    public boolean getIncludeSensitiveData() {
        return this._includeSensitiveData;
    }

    public void setCoreEdition(boolean flag) {
        if (flag != this._coreEdition) {
            this._coreEdition = flag;
            this.setSpecifiedProducts();
        }
    }

    public void setBaseEdition(boolean flag) {
        if (flag != this._baseEdition) {
            this._baseEdition = flag;
            this.setSpecifiedProducts();
        }
    }

    public void setNdEdition(boolean flag) {
        if (flag != this._ndEdition) {
            this._ndEdition = flag;
            this.setSpecifiedProducts();
        }
    }

    public void setZosEdition(boolean flag) {
        if (flag != this._zosEdition) {
            this._zosEdition = flag;
            this.setSpecifiedProducts();
        }
    }

    public void setLibertyProfile(boolean flag) {
        if (flag != this._libertyProfile) {
            this._libertyProfile = flag;
            this.setSpecifiedProducts();
        }
    }

    public void setFullProfile(boolean flag) {
        if (flag != this._fullProfile) {
            this._fullProfile = flag;
            this.setSpecifiedProducts();
        }
    }

    public void setSpecifiedProducts() {
        this.PRODUCTS.put(com.ibm.ws.report.Messages.getString("OpenLiberty"), !this.isEditionSpecified() && (this._libertyProfile || !this.isProfileSpecified()));
        this.PRODUCTS.put(com.ibm.ws.report.Messages.getString("WASLibertyCore"), this._coreEdition || !this.isEditionSpecified() && (this._libertyProfile || !this.isProfileSpecified()));
        this.PRODUCTS.put(com.ibm.ws.report.Messages.getString("WASLibertyProfile"), !(!this._baseEdition && this.isEditionSpecified() || !this._libertyProfile && this.isProfileSpecified()));
        this.PRODUCTS.put(com.ibm.ws.report.Messages.getString("WASFullProfile"), !(!this._baseEdition && this.isEditionSpecified() || !this._fullProfile && this.isProfileSpecified()));
        this.PRODUCTS.put(com.ibm.ws.report.Messages.getString("WASNDLiberty"), !(!this._ndEdition && this.isEditionSpecified() || !this._libertyProfile && this.isProfileSpecified()));
        this.PRODUCTS.put(com.ibm.ws.report.Messages.getString("WASNDFullProfile"), !(!this._ndEdition && this.isEditionSpecified() || !this._fullProfile && this.isProfileSpecified()));
        this.PRODUCTS.put(com.ibm.ws.report.Messages.getString("WASZOSLiberty"), !(!this._zosEdition && this.isEditionSpecified() || !this._libertyProfile && this.isProfileSpecified()));
        this.PRODUCTS.put(com.ibm.ws.report.Messages.getString("WASZOSFull"), !(!this._zosEdition && this.isEditionSpecified() || !this._fullProfile && this.isProfileSpecified()));
    }

    public boolean isEditionSpecified() {
        return this._coreEdition || this._baseEdition || this._ndEdition || this._zosEdition;
    }

    public boolean isProfileSpecified() {
        return this._fullProfile || this._libertyProfile;
    }

    public boolean hasSharedLibraries() {
        return !this._sharedLibraryFiles.isEmpty();
    }

    public List<File> getSharedLibraryFiles() {
        return this._sharedLibraryFiles;
    }

    public List<String> getSpecifiedProducts() {
        ArrayList<String> productArray = new ArrayList<String>();
        for (Map.Entry<String, Boolean> product : this.PRODUCTS.entrySet()) {
            if (!product.getValue().booleanValue()) continue;
            productArray.add(product.getKey());
        }
        return productArray;
    }

    public boolean getMigrateAllConfig() {
        return this._migrateAllConfig;
    }

    public boolean london() {
        return this._london;
    }

    public void setMigrateAllConfig(boolean migrateAllConfig) {
        this._migrateAllConfig = migrateAllConfig;
    }

    public void setLondon(boolean london) {
        this._london = london;
    }

    public void setJunitFlag(boolean flag) {
        this._hiddenJunitFlag = flag;
    }

    public boolean isJunit() {
        return this._hiddenJunitFlag;
    }

    public void setDetectSharedLibraries(boolean flag) {
        _detectSharedLibraries = flag;
    }

    public boolean detectSharedLibraries() {
        return _detectSharedLibraries;
    }

    public void setShowAllHelp(boolean flag) {
        _showAllHelp = flag;
    }

    public boolean showAllHelp() {
        return _showAllHelp;
    }

    public void setLoadAllRules(boolean flag) {
        _loadAllRules = flag;
    }

    public void setIncludeHelpLocation(boolean flag) {
        _includeHelpLocation = flag;
    }

    public boolean includeHelpLocation() {
        return _includeHelpLocation;
    }

    public void setMapOfAppsToProfiles(Map<File, String> mapOfAppsToProfiles) {
        ReportInputData.mapOfAppsToProfiles = mapOfAppsToProfiles;
    }

    public void setMapOfProfilesToPaths(Map<String, String> mapOfProfilesToPaths) {
        ReportInputData.mapOfProfilesToPaths = mapOfProfilesToPaths;
    }

    public Map<File, String> getMapOfAppsToProfiles() {
        return mapOfAppsToProfiles;
    }

    public Map<String, String> getMapOfProfilesToPaths() {
        return mapOfProfilesToPaths;
    }

    public String getProfilePath(String profileName) {
        return mapOfProfilesToPaths.get(profileName);
    }

    public void setIncludeApplications(List<String> includeApplications) {
        this._includeApplications = includeApplications;
    }

    public List<String> getIncludeApplications() {
        return this._includeApplications;
    }

    public void setScanAll() {
        this._excludePackagesDefaultRegex = null;
        this._excludePackagesDefaultOption = null;
    }

    public void setExcludeApplications(List<String> excludeApplications) {
        this._excludeApplications = excludeApplications;
    }

    public List<String> getExcludeApplications() {
        return this._excludeApplications;
    }

    public void setStopOnMissingBinary(boolean stopOnMissingBinary) {
        _stopOnMissingBinary = stopOnMissingBinary;
    }

    public boolean getStopOnMissingBinary() {
        return _stopOnMissingBinary;
    }

    public void setStopOnMissingSharedLibrary(boolean stopOnMissingSharedLibrary) {
        _stopOnMissingSharedLibrary = stopOnMissingSharedLibrary;
    }

    public boolean getStopOnMissingSharedLibrary() {
        return _stopOnMissingSharedLibrary;
    }

    public boolean loadAllRules() {
        return _loadAllRules;
    }

    public void setReplaceRulesFlag(boolean flag) {
        this._replaceRulesFlag = flag;
    }

    public boolean isReplaceRules() {
        return this._replaceRulesFlag;
    }

    public void generateTA(boolean generateTA) {
        this.generateTA = generateTA;
    }

    public boolean isGenerateTA() {
        return this.generateTA;
    }

    public boolean isClean() {
        return this._clean;
    }

    public void setDelete(boolean delete) {
        this._delete = delete;
    }

    public boolean isDelete() {
        return this._delete;
    }

    public void setClean(boolean clean) {
        this._clean = clean;
    }

    public void setBinaryLocations(Set<File> binaryLocations) {
        this._binaryLocations = binaryLocations;
    }

    public Set<File> getBinaryLocations() {
        return this._binaryLocations;
    }

    public void setRuleXmlFiles(File[] rules) {
        this._ruleXmlFiles = rules;
    }

    public void setMaxUserDefinedRuleResults(int maxUserDefinedRuleResults) {
        this._maxUserDefinedRuleResults = maxUserDefinedRuleResults;
    }

    public int getMaxUserDefinedRuleResults() {
        return this._maxUserDefinedRuleResults;
    }

    public void setUserRuleLocation(String userRuleLocation) {
        this._userRuleLocation = userRuleLocation;
    }

    public String getUserRuleLocation() {
        return this._userRuleLocation;
    }

    public File[] getRuleXmlFiles() {
        return this._ruleXmlFiles;
    }

    public void setGenerateAllSeparateReports(boolean flag) {
        this._generateAllSeparateReports = flag;
    }

    public boolean generateAllSeparateReports() {
        return this._generateAllSeparateReports;
    }

    public void addProjectDirPath(String path) {
        this._projectDirPaths.add(path);
        this._projectDirPathsNormalized.add(path.replace("\\", "/"));
    }

    public String getProjectDirPath(String filePath) {
        for (String path : this._projectDirPaths) {
            if (!filePath.startsWith(path)) continue;
            return path;
        }
        if (!this._projectDirPaths.isEmpty()) {
            return this._projectDirPaths.iterator().next();
        }
        return null;
    }

    public String getProjectDirPathNormalized(String filePath) {
        for (String path : this._projectDirPathsNormalized) {
            if (!filePath.equals(path) && !filePath.startsWith(String.valueOf(path) + "/")) continue;
            return path;
        }
        if (!this._projectDirPathsNormalized.isEmpty()) {
            return this._projectDirPathsNormalized.iterator().next();
        }
        return null;
    }

    public AppServer getSourceAppServer() {
        return this._sourceAppServer;
    }

    public void setSourceAppServer(AppServer sourceAppServer) {
        this._sourceAppServer = sourceAppServer;
    }

    public AppServer getTargetAppServer() {
        return this._targetAppServer;
    }

    public void setTargetAppServer(AppServer targetAppServer) {
        this._targetAppServer = targetAppServer;
    }

    public TargetCloud getTargetCloud() {
        return this._targetCloud;
    }

    public static boolean targetJakartaEEParameterUsed() {
        return targetJakartaEEParameterUsed;
    }

    public void setTargetJakartaEEParameterUsed(boolean targetJakartaEEParameterUsed) {
        ReportInputData.targetJakartaEEParameterUsed = targetJakartaEEParameterUsed;
    }

    public static boolean sourceJakartaEEParameterUsed() {
        return sourceJakartaEEParameterUsed;
    }

    public void setSourceJakartaEEParameterUsed(boolean sourceJakartaEEParameterUsed) {
        ReportInputData.sourceJakartaEEParameterUsed = sourceJakartaEEParameterUsed;
    }

    public String getSourceAppServerOption() {
        return this._sourceAppServer == null ? null : this._sourceAppServer.getSourceOption();
    }

    public String getTargetAppServerOption() {
        return this._targetAppServer == null ? null : this._targetAppServer.getTargetOption();
    }

    public String getTargetCloudOption() {
        return this._targetCloud == null ? null : this._targetCloud.toString();
    }

    public JavaVersion getSourceJava() {
        return this._sourceJava;
    }

    public JavaVersion getTargetJava() {
        return this._targetJava;
    }

    public String getSourceJavaOption() {
        return this._sourceJava == null ? null : this._sourceJava.getSourceOption();
    }

    public String getTargetJavaOption() {
        return this._targetJava == null ? null : this._targetJava.getTargetOption();
    }

    public MicroProfileVersion getMicroProfile() {
        return this._targetMicroProfile;
    }

    public void setMicroProfile(MicroProfileVersion targetMicroProfile) {
        this._targetMicroProfile = targetMicroProfile;
    }

    public JavaEEVersion getSourceJavaEE() {
        return this._sourceJavaEE;
    }

    public JavaEEVersion getTargetJavaEE() {
        return this._targetJavaEE;
    }

    public void setTargetJava(JavaVersion targetJava) {
        this._targetJava = targetJava;
    }

    public void setTargetJavaEE(JavaEEVersion targetJavaEE) {
        this._targetJavaEE = targetJavaEE;
    }

    public String getTargetJavaEEOption() {
        return this._targetJavaEE == null ? null : this._targetJavaEE.getTargetJavaEEOption();
    }

    public String[] getSourceOptions() {
        int numOptions;
        int n = numOptions = this._sourceAppServer != null ? 1 : 0;
        if (this._sourceJava != null) {
            ++numOptions;
        }
        if (this._sourceJavaEE != null) {
            ++numOptions;
        }
        String[] sourceOptions = new String[numOptions];
        int index = 0;
        if (this._sourceAppServer != null) {
            sourceOptions[index++] = this._sourceAppServer.getSourceOption();
        }
        if (this._sourceJava != null) {
            sourceOptions[index++] = this._sourceJava.getSourceOption();
        }
        if (this._sourceJavaEE != null) {
            sourceOptions[index++] = this._sourceJavaEE.getSourceJavaEEOption();
        }
        return sourceOptions;
    }

    public String[] getTargetOptions() {
        int numOptions;
        int n = numOptions = this._targetAppServer != null ? 1 : 0;
        if (this._targetJava != null) {
            ++numOptions;
        }
        if (this._targetJavaEE != null) {
            ++numOptions;
        }
        if (this._targetCloud != null) {
            ++numOptions;
        }
        String[] targetOptions = new String[numOptions];
        int index = 0;
        if (this._targetAppServer != null) {
            targetOptions[index++] = this._targetAppServer.getTargetOption();
        }
        if (this._targetJava != null) {
            targetOptions[index++] = this._targetJava.getTargetOption();
        }
        if (this._targetJavaEE != null) {
            targetOptions[index++] = this._targetJavaEE.getTargetJavaEEOption();
        }
        if (this._targetCloud != null) {
            targetOptions[index++] = this._targetCloud.toString();
        }
        return targetOptions;
    }

    public String getIncludePackages() {
        return this._includePackagesRegex;
    }

    public String getExcludePackages() {
        return this._excludePackagesRegex;
    }

    public void overrideDefaultExcludePackagesRegex() {
        this._excludePackagesDefaultRegex = null;
        this._excludePackagesOption = null;
        this._excludePackagesDefaultOption = null;
    }

    public String getDefaultExcludePackagesRegex() {
        return this._excludePackagesDefaultRegex;
    }

    public String getDefaultExcludePackages() {
        return this._excludePackagesDefaultPackages;
    }

    public Set<String> getExcludedRules() {
        return this._excludedRules;
    }

    public SortedMap<String, String> getScanOptions() {
        TreeMap<String, String> scanOptions = new TreeMap<String, String>();
        if (this._includePackagesOption != null) {
            scanOptions.put("includePackages", this._includePackagesOption);
        }
        if (this._excludePackagesOption != null) {
            scanOptions.put("excludePackages", this._excludePackagesOption);
        }
        if (this._excludedRules != null) {
            StringBuilder result = new StringBuilder();
            for (String item : this._excludedRules) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(item);
            }
            scanOptions.put("excludeRules", "--excludedRules=" + result.toString());
        }
        if (this._excludePackagesDefaultRegex != null) {
            scanOptions.put("excludePackages", this._excludePackagesDefaultOption);
        }
        if (this._excludeFilesPattern != null) {
            scanOptions.put("excludeFiles", this._excludeFilesPatternOption);
        }
        if (_includeHelpLocation) {
            scanOptions.put("--includeHelpLocation", "--includeHelpLocation");
        }
        if (this._maxUserDefinedRuleResults != -1) {
            scanOptions.put("--maxUserDefinedRuleResults", "--maxUserDefinedRuleResults=" + Integer.toString(this._maxUserDefinedRuleResults));
        }
        if (this._userRuleLocation != null) {
            scanOptions.put("--userRuleLocation", "--userRuleLocation=" + this._userRuleLocation);
        }
        return scanOptions;
    }

    public SortedMap<String, String> getScanOptionsDisplay() {
        TreeMap<String, String> scanOptions = new TreeMap<String, String>();
        if (this._includePackagesOption != null) {
            scanOptions.put("includePackages", this._includePackagesOption.replaceAll("\\s+", "").replaceAll(",", ", "));
        }
        if (this._excludePackagesOption != null) {
            scanOptions.put("excludePackages", this._excludePackagesOption.replaceAll("\\s+", "").replaceAll(",", ", "));
        }
        if (this._excludedRules != null) {
            StringBuilder result = new StringBuilder();
            for (String item : this._excludedRules) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(item);
            }
            scanOptions.put("excludeRules", "--excludedRules=" + result.toString().replaceAll("\\s+", "").replaceAll(",", ", "));
        }
        if (this._excludePackagesDefaultRegex != null) {
            scanOptions.put("excludePackages", this._excludePackagesDefaultOption.replaceAll("\\s+", "").replaceAll(",", ", "));
        }
        if (this._excludeFilesPattern != null) {
            scanOptions.put("excludeFiles", this._excludeFilesPatternOption.replaceAll("\\s+", "").replaceAll(",", ", "));
        }
        if (_loadAllRules) {
            scanOptions.put("--loadAllRules", "--loadAllRules");
        }
        if (_showAllHelp) {
            scanOptions.put("--showAllHelp", "--showAllHelp");
        }
        if (this._maxUserDefinedRuleResults != -1) {
            scanOptions.put("--maxUserDefinedRuleResults", "--maxUserDefinedRuleResults=" + Integer.toString(this._maxUserDefinedRuleResults));
        }
        if (this._userRuleLocation != null) {
            scanOptions.put("--userRuleLocation", "--userRuleLocation=" + this._userRuleLocation);
        }
        return scanOptions;
    }

    public SortedMap<String, String> getEvalReportOptions(boolean html) {
        boolean defaultProfileOptions;
        TreeMap<String, String> optionsList = new TreeMap<String, String>();
        boolean defaultEditionOptions = !this.isEditionSpecified();
        boolean bl = defaultProfileOptions = !this.isProfileSpecified();
        if (this._baseEdition || defaultEditionOptions) {
            optionsList.put("--baseEdition", "--baseEdition");
        }
        if (this._coreEdition || defaultEditionOptions) {
            optionsList.put("--coreEdition", "--coreEdition");
        }
        if (this._ndEdition || defaultEditionOptions) {
            optionsList.put("--ndEdition", "--ndEdition");
        }
        if (this._zosEdition || defaultEditionOptions) {
            optionsList.put("--zosEdition", "--zosEdition");
        }
        if (this._fullProfile || defaultProfileOptions) {
            optionsList.put("--traditional", "--traditional");
        }
        if (this._libertyProfile || defaultProfileOptions) {
            optionsList.put("--liberty", "--liberty");
        }
        if (html) {
            if (this._includePackagesOption != null) {
                optionsList.put("includePackages", this._includePackagesOption.replaceAll("\\s+", "").replaceAll(",", ", "));
            }
            if (this._excludePackagesOption != null) {
                optionsList.put("excludePackages", this._excludePackagesOption.replaceAll("\\s+", "").replaceAll(",", ", "));
            } else if (this._excludePackagesDefaultRegex != null) {
                optionsList.put("excludePackages", this._excludePackagesDefaultOption.replaceAll("\\s+", "").replaceAll(",", ", "));
            }
            if (this._excludeFilesPattern != null) {
                optionsList.put("excludeFiles", this._excludeFilesPatternOption.replaceAll("\\s+", "").replaceAll(",", ", "));
            }
        } else {
            if (this._includePackagesOption != null) {
                optionsList.put("includePackages", this._includePackagesOption);
            }
            if (this._excludePackagesOption != null) {
                optionsList.put("excludePackages", this._excludePackagesOption);
            } else if (this._excludePackagesDefaultRegex != null) {
                optionsList.put("excludePackages", this._excludePackagesDefaultOption);
            }
            if (this._excludeFilesPattern != null) {
                optionsList.put("excludeFiles", this._excludeFilesPatternOption);
            }
        }
        if (_includeHelpLocation && !html) {
            optionsList.put("--includeHelpLocation", "--includeHelpLocation");
        }
        return optionsList;
    }

    public boolean filterAnalysisRulesByFeatureList() {
        Boolean filterAnalysisRulesByFeatureListBool = this.filterAnalysisRulesByFeatureList.get((Object)this._targetAppServer);
        if (filterAnalysisRulesByFeatureListBool == null) {
            if (this._sourceAppServer != null && this._targetAppServer != null) {
                boolean isSourceAndTargetAppServerSame = this._sourceAppServer.name().equals(this._targetAppServer.name()) || this._sourceAppServer.isLiberty() && this._targetAppServer.isLiberty();
                boolean isLibertyTargetNoTargetJavaEE = this._targetAppServer.isLiberty() && (this._targetJavaEE == null || this._targetJavaEE == JavaEEVersion.EE7 && this._sourceJavaEE == JavaEEVersion.EE7);
                boolean isTWAS90Target = this._targetAppServer == AppServer.WAS90;
                filterAnalysisRulesByFeatureListBool = !isSourceAndTargetAppServerSame && (isLibertyTargetNoTargetJavaEE || isTWAS90Target);
            } else {
                filterAnalysisRulesByFeatureListBool = false;
            }
        }
        this.filterAnalysisRulesByFeatureList.put(this._targetAppServer, filterAnalysisRulesByFeatureListBool);
        return filterAnalysisRulesByFeatureListBool;
    }

    private String getPackagesRegex(String packageOption) {
        StringBuilder sb = new StringBuilder();
        if (packageOption != null) {
            String packages = packageOption.substring(packageOption.indexOf(61) + 1);
            String[] packageNames = packages.split(",");
            int size = packageNames.length;
            if (size > 1) {
                sb.append("(");
            }
            int i = 0;
            while (i < size) {
                String packageName = packageNames[i];
                packageName = packageName.trim();
                packageName = packageName.replace("*", "");
                packageName = packageName.replace('.', '/');
                sb.append(packageName);
                if (!packageName.endsWith("/")) {
                    sb.append('/');
                }
                if (i < size - 1) {
                    sb.append('|');
                }
                ++i;
            }
            if (size > 1) {
                sb.append(")");
            }
            sb.append(".*");
        }
        return sb.toString();
    }

    public boolean isRunFromTaDc() {
        return this._runFromTaDc;
    }

    public void setIsRunFromTaDc(boolean runFromTaDc) {
        this._runFromTaDc = runFromTaDc;
    }

    public static enum AppServer {
        WAS61("--sourceAppServer=was61", null, Messages.getString("AppServer_was61")),
        WAS70("--sourceAppServer=was70", null, Messages.getString("AppServer_was70")),
        WAS80("--sourceAppServer=was80", null, Messages.getString("AppServer_was80")),
        WAS855("--sourceAppServer=was855", "--targetAppServer=was855", Messages.getString("AppServer_was855")),
        WAS90("--sourceAppServer=was90", "--targetAppServer=was90", Messages.getString("AppServer_was90")),
        LIBERTY("--sourceAppServer=liberty", "--targetAppServer=liberty", Messages.getString("AppServer_liberty")),
        MANAGED_LIBERTY("--sourceAppServer=managedLiberty", "--targetAppServer=managedLiberty", Messages.getString("AppServer_liberty_managed")),
        EASE("--sourceAppServer=EASe", "--targetAppServer=EASe", Messages.getString("AppServer_EASe")),
        LIBERTY_CORE("--sourceAppServer=libertyCore", "--targetAppServer=libertyCore", Messages.getString("AppServer_libertyCore")),
        OPEN_LIBERTY("--sourceAppServer=openLiberty", "--targetAppServer=openLiberty", Messages.getString("AppServer_openLiberty")),
        JBOSS("--sourceAppServer=jboss", null, Messages.getString("AppServer_jboss")),
        TOMCAT("--sourceAppServer=tomcat", null, Messages.getString("AppServer_tomcat")),
        WEBLOGIC("--sourceAppServer=weblogic", null, Messages.getString("AppServer_weblogic")),
        OTHER_THIRD_PARTY("--sourceAppServer=other", null, Messages.getString("AppServer_other"));

        private static final Map<String, AppServer> lookupSource;
        private static final Map<String, AppServer> lookupTarget;
        private static final EnumMap<AppServer, Integer> techSummaryColumnIndex;
        private static EnumMap<AppServer, EnumSet<AppServer>> sourceToTargetAppServerMapping;
        private static EnumSet<AppServer> wasTraditionalAppServers;
        private static EnumSet<AppServer> libertyAppServers;
        private static EnumSet<AppServer> competitiveAppServers;
        private static EnumSet<AppServer> was90orLater;
        private static EnumMap<AppServer, EnumSet<JavaEEVersion>> appServerToJavaEEVersionMapping;
        private static EnumMap<AppServer, EnumSet<JavaVersion>> appServerToSourceJavaVersionMapping;
        private static EnumMap<AppServer, EnumSet<JavaVersion>> appServerToTargetJavaVersionMapping;
        private static EnumMap<AppServer, EnumSet<TargetCloud>> targetAppServerToCloudMapping;
        private static EnumMap<ReportType, EnumSet<Options>> reportTypeToSupportedOptions;
        private static Set<String> removedOptions;
        private final String sourceParm;
        private final String targetParm;
        private final String name;

        static {
            lookupSource = new HashMap<String, AppServer>();
            lookupTarget = new HashMap<String, AppServer>();
            techSummaryColumnIndex = new EnumMap(AppServer.class);
            sourceToTargetAppServerMapping = null;
            wasTraditionalAppServers = EnumSet.of(WAS61, WAS70, WAS80, WAS855, WAS90);
            libertyAppServers = EnumSet.of(LIBERTY, EASE, LIBERTY_CORE, OPEN_LIBERTY, MANAGED_LIBERTY);
            competitiveAppServers = EnumSet.of(JBOSS, TOMCAT, WEBLOGIC, OTHER_THIRD_PARTY);
            was90orLater = EnumSet.of(WAS90);
            appServerToJavaEEVersionMapping = null;
            appServerToSourceJavaVersionMapping = null;
            appServerToTargetJavaVersionMapping = null;
            targetAppServerToCloudMapping = null;
            reportTypeToSupportedOptions = null;
            removedOptions = new HashSet<String>();
            reportTypeToSupportedOptions = new EnumMap(ReportType.class);
            reportTypeToSupportedOptions.put(ReportType.ANALYZE, EnumSet.of(Options.SOURCE_APP_SERVER, new Options[]{Options.TARGET_APP_SERVER, Options.TARGET_CLOUD, Options.SOURCE_JAVA, Options.TARGET_JAVA, Options.SOURCE_JAVAEE, Options.TARGET_JAVAEE, Options.FORMAT, Options.OUTPUT, Options.DEBUG, Options.EXCLUDE_FILES, Options.EXCLUDE_PACKAGES, Options.INCLUDE_PACKAGES, Options.CONFIG_LOCATION, Options.USER_RULE_LOCATION, Options.USER_RULES_ONLY, Options.MAX_USER_DEFINED_RULE_RESULTS, Options.NO_BROWSER, Options.SHOW_ALL_HELP, Options.LOAD_ALL_RULES, Options.INCLUDE_HELP_LOCATION, Options.SCAN_ALL}));
            reportTypeToSupportedOptions.put(ReportType.EVALUATE, EnumSet.of(Options.BASE_EDITION, new Options[]{Options.CORE_EDITION, Options.LIBERTY_BUILDPACK_EDITION, Options.ND_EDITION, Options.ZOS_EDITION, Options.LIBERTY, Options.TRADITIONAL, Options.FORMAT, Options.OUTPUT, Options.DEBUG, Options.EXCLUDE_FILES, Options.EXCLUDE_PACKAGES, Options.INCLUDE_PACKAGES, Options.NO_BROWSER, Options.LOAD_ALL_RULES, Options.SCAN_ALL}));
            reportTypeToSupportedOptions.put(ReportType.GENERATE_CONFIG, EnumSet.of(Options.SOURCE_APP_SERVER, new Options[]{Options.TARGET_APP_SERVER, Options.TARGET_JAVAEE, Options.OUTPUT, Options.DEBUG, Options.EXCLUDE_FILES, Options.EXCLUDE_PACKAGES, Options.INCLUDE_PACKAGES, Options.SHARED_LIBRARIES, Options.DETECT_SHARED_LIBRARIES, Options.CONFIG_LOCATION, Options.INCLUDE_SENSITIVE_DATA, Options.MIGRATE_ALL_CONFIG, Options.SCAN_ALL}));
            reportTypeToSupportedOptions.put(ReportType.INVENTORY, EnumSet.of(Options.FORMAT, new Options[]{Options.OUTPUT, Options.DEBUG, Options.EXCLUDE_FILES, Options.EXCLUDE_PACKAGES, Options.INCLUDE_PACKAGES, Options.SHARED_LIBRARIES, Options.DETECT_SHARED_LIBRARIES, Options.NO_BROWSER, Options.SCAN_ALL}));
            for (AppServer s : EnumSet.allOf(AppServer.class)) {
                lookupSource.put(s.sourceParm, s);
            }
            lookupSource.put("--sourceAppServer=fullProfile70", WAS70);
            lookupSource.put("--sourceAppServer=fullProfile80", WAS80);
            lookupSource.put("--sourceAppServer=fullProfile855", WAS855);
            lookupSource.put("--sourceAppServer=libertyProfile", LIBERTY);
            lookupSource.put("--sourceAppServer=cloud", LIBERTY);
            lookupSource.put("--sourceAppServer=jboss", JBOSS);
            lookupSource.put("--sourceAppServer=tomcat", TOMCAT);
            lookupSource.put("--sourceAppServer=weblogic", WEBLOGIC);
            lookupSource.put("--sourceAppServer=other", OTHER_THIRD_PARTY);
            for (AppServer s : EnumSet.allOf(AppServer.class)) {
                if (s.targetParm == null) continue;
                lookupTarget.put(s.targetParm, s);
            }
            lookupTarget.put("--targetAppServer=fullProfile855", WAS855);
            lookupTarget.put("--targetAppServer=libertyProfile", LIBERTY);
            lookupTarget.put("--targetAppServer=cloud", LIBERTY);
            techSummaryColumnIndex.put(OPEN_LIBERTY, 0);
            techSummaryColumnIndex.put(LIBERTY_CORE, 1);
            techSummaryColumnIndex.put(LIBERTY, 2);
            techSummaryColumnIndex.put(WAS855, 3);
            techSummaryColumnIndex.put(WAS90, 3);
            sourceToTargetAppServerMapping = new EnumMap(AppServer.class);
            sourceToTargetAppServerMapping.put(EASE, EnumSet.of(LIBERTY, EASE, LIBERTY_CORE, OPEN_LIBERTY));
            sourceToTargetAppServerMapping.put(OPEN_LIBERTY, EnumSet.of(LIBERTY, EASE, LIBERTY_CORE, OPEN_LIBERTY));
            sourceToTargetAppServerMapping.put(LIBERTY_CORE, EnumSet.of(LIBERTY, LIBERTY_CORE));
            sourceToTargetAppServerMapping.put(LIBERTY, EnumSet.of(LIBERTY, LIBERTY_CORE));
            sourceToTargetAppServerMapping.put(MANAGED_LIBERTY, EnumSet.of(LIBERTY, LIBERTY_CORE));
            sourceToTargetAppServerMapping.put(WAS90, EnumSet.of(WAS90, new AppServer[]{LIBERTY, MANAGED_LIBERTY, EASE, LIBERTY_CORE, OPEN_LIBERTY}));
            sourceToTargetAppServerMapping.put(WAS855, EnumSet.of(WAS855, new AppServer[]{WAS90, LIBERTY, MANAGED_LIBERTY, EASE, LIBERTY_CORE, OPEN_LIBERTY}));
            sourceToTargetAppServerMapping.put(WAS80, EnumSet.of(WAS855, new AppServer[]{WAS90, LIBERTY, MANAGED_LIBERTY, EASE, LIBERTY_CORE, OPEN_LIBERTY}));
            sourceToTargetAppServerMapping.put(WAS70, EnumSet.of(WAS855, new AppServer[]{WAS90, LIBERTY, EASE, LIBERTY_CORE, OPEN_LIBERTY}));
            sourceToTargetAppServerMapping.put(WAS61, EnumSet.of(WAS855, new AppServer[]{WAS90, LIBERTY, EASE, LIBERTY_CORE, OPEN_LIBERTY}));
            sourceToTargetAppServerMapping.put(JBOSS, EnumSet.of(WAS855, new AppServer[]{WAS90, LIBERTY, EASE, LIBERTY_CORE, OPEN_LIBERTY}));
            sourceToTargetAppServerMapping.put(TOMCAT, EnumSet.of(WAS855, new AppServer[]{WAS90, LIBERTY, EASE, LIBERTY_CORE, OPEN_LIBERTY}));
            sourceToTargetAppServerMapping.put(WEBLOGIC, EnumSet.of(WAS855, new AppServer[]{WAS90, LIBERTY, EASE, LIBERTY_CORE, OPEN_LIBERTY}));
            sourceToTargetAppServerMapping.put(OTHER_THIRD_PARTY, EnumSet.of(WAS855, new AppServer[]{WAS90, LIBERTY, EASE, LIBERTY_CORE, OPEN_LIBERTY}));
            appServerToJavaEEVersionMapping = new EnumMap(AppServer.class);
            appServerToJavaEEVersionMapping.put(WAS61, EnumSet.noneOf(JavaEEVersion.class));
            appServerToJavaEEVersionMapping.put(WAS70, EnumSet.noneOf(JavaEEVersion.class));
            appServerToJavaEEVersionMapping.put(WAS80, EnumSet.of(JavaEEVersion.EE6));
            appServerToJavaEEVersionMapping.put(WAS855, EnumSet.of(JavaEEVersion.EE6));
            appServerToJavaEEVersionMapping.put(WAS90, EnumSet.of(JavaEEVersion.EE7));
            appServerToJavaEEVersionMapping.put(LIBERTY, EnumSet.of(JavaEEVersion.EE6, new JavaEEVersion[]{JavaEEVersion.EE7, JavaEEVersion.EE8, JavaEEVersion.EE9, JavaEEVersion.EE10, JavaEEVersion.EE11}));
            appServerToJavaEEVersionMapping.put(MANAGED_LIBERTY, EnumSet.of(JavaEEVersion.EE10));
            appServerToJavaEEVersionMapping.put(LIBERTY_CORE, EnumSet.of(JavaEEVersion.EE6, new JavaEEVersion[]{JavaEEVersion.EE7, JavaEEVersion.EE8, JavaEEVersion.EE9, JavaEEVersion.EE10, JavaEEVersion.EE11}));
            appServerToJavaEEVersionMapping.put(EASE, EnumSet.of(JavaEEVersion.EE7, JavaEEVersion.EE8, JavaEEVersion.EE9, JavaEEVersion.EE10, JavaEEVersion.EE11));
            appServerToJavaEEVersionMapping.put(OPEN_LIBERTY, EnumSet.of(JavaEEVersion.EE7, JavaEEVersion.EE8, JavaEEVersion.EE9, JavaEEVersion.EE10, JavaEEVersion.EE11));
            appServerToJavaEEVersionMapping.put(JBOSS, EnumSet.noneOf(JavaEEVersion.class));
            appServerToJavaEEVersionMapping.put(TOMCAT, EnumSet.noneOf(JavaEEVersion.class));
            appServerToJavaEEVersionMapping.put(WEBLOGIC, EnumSet.noneOf(JavaEEVersion.class));
            appServerToJavaEEVersionMapping.put(OTHER_THIRD_PARTY, EnumSet.noneOf(JavaEEVersion.class));
            appServerToSourceJavaVersionMapping = new EnumMap(AppServer.class);
            appServerToSourceJavaVersionMapping.put(WAS61, EnumSet.of(JavaVersion.IBM5, JavaVersion.ORACLE5));
            appServerToSourceJavaVersionMapping.put(WAS70, EnumSet.of(JavaVersion.IBM6));
            appServerToSourceJavaVersionMapping.put(WAS80, EnumSet.of(JavaVersion.IBM6));
            appServerToSourceJavaVersionMapping.put(WAS855, EnumSet.of(JavaVersion.IBM6, JavaVersion.IBM7, JavaVersion.IBM8));
            appServerToSourceJavaVersionMapping.put(WAS90, EnumSet.of(JavaVersion.IBM8));
            appServerToSourceJavaVersionMapping.put(LIBERTY, EnumSet.of(JavaVersion.IBM6, new JavaVersion[]{JavaVersion.ORACLE6, JavaVersion.IBM7, JavaVersion.ORACLE7, JavaVersion.IBM8, JavaVersion.ORACLE8, JavaVersion.JAVA11, JavaVersion.JAVA17, JavaVersion.JAVA21}));
            appServerToSourceJavaVersionMapping.put(MANAGED_LIBERTY, EnumSet.of(JavaVersion.JAVA17));
            appServerToSourceJavaVersionMapping.put(LIBERTY_CORE, EnumSet.of(JavaVersion.IBM6, new JavaVersion[]{JavaVersion.ORACLE6, JavaVersion.IBM7, JavaVersion.ORACLE7, JavaVersion.IBM8, JavaVersion.ORACLE8, JavaVersion.JAVA11, JavaVersion.JAVA17, JavaVersion.JAVA21}));
            appServerToSourceJavaVersionMapping.put(OTHER_THIRD_PARTY, EnumSet.of(JavaVersion.IBM5, new JavaVersion[]{JavaVersion.ORACLE5, JavaVersion.IBM6, JavaVersion.ORACLE6, JavaVersion.IBM7, JavaVersion.ORACLE7, JavaVersion.IBM8, JavaVersion.ORACLE8, JavaVersion.JAVA11, JavaVersion.JAVA17, JavaVersion.JAVA21}));
            appServerToSourceJavaVersionMapping.put(OPEN_LIBERTY, EnumSet.of(JavaVersion.IBM6, new JavaVersion[]{JavaVersion.ORACLE6, JavaVersion.IBM7, JavaVersion.ORACLE7, JavaVersion.IBM8, JavaVersion.ORACLE8, JavaVersion.JAVA11, JavaVersion.JAVA17, JavaVersion.JAVA21}));
            appServerToSourceJavaVersionMapping.put(EASE, EnumSet.of(JavaVersion.IBM6, new JavaVersion[]{JavaVersion.ORACLE6, JavaVersion.IBM7, JavaVersion.ORACLE7, JavaVersion.IBM8, JavaVersion.ORACLE8, JavaVersion.JAVA11, JavaVersion.JAVA17, JavaVersion.JAVA21}));
            appServerToTargetJavaVersionMapping = new EnumMap(AppServer.class);
            appServerToTargetJavaVersionMapping.put(WAS855, EnumSet.of(JavaVersion.IBM7, JavaVersion.IBM8));
            appServerToTargetJavaVersionMapping.put(WAS90, EnumSet.of(JavaVersion.IBM8));
            appServerToTargetJavaVersionMapping.put(LIBERTY, EnumSet.of(JavaVersion.IBM8, JavaVersion.ORACLE8, JavaVersion.JAVA11, JavaVersion.JAVA17, JavaVersion.JAVA21));
            appServerToTargetJavaVersionMapping.put(LIBERTY_CORE, EnumSet.of(JavaVersion.IBM8, JavaVersion.ORACLE8, JavaVersion.JAVA11, JavaVersion.JAVA17, JavaVersion.JAVA21));
            appServerToTargetJavaVersionMapping.put(OPEN_LIBERTY, EnumSet.of(JavaVersion.IBM8, JavaVersion.ORACLE8, JavaVersion.JAVA11, JavaVersion.JAVA17, JavaVersion.JAVA21));
            appServerToTargetJavaVersionMapping.put(MANAGED_LIBERTY, EnumSet.of(JavaVersion.JAVA17));
            appServerToTargetJavaVersionMapping.put(EASE, EnumSet.of(JavaVersion.IBM8, JavaVersion.ORACLE8, JavaVersion.JAVA11, JavaVersion.JAVA17, JavaVersion.JAVA21));
            targetAppServerToCloudMapping = new EnumMap(AppServer.class);
            targetAppServerToCloudMapping.put(WAS61, EnumSet.noneOf(TargetCloud.class));
            targetAppServerToCloudMapping.put(WAS70, EnumSet.noneOf(TargetCloud.class));
            targetAppServerToCloudMapping.put(WAS80, EnumSet.noneOf(TargetCloud.class));
            targetAppServerToCloudMapping.put(WAS855, EnumSet.of(TargetCloud.CONTAINERS, TargetCloud.VM_IBM_CLOUD));
            targetAppServerToCloudMapping.put(WAS90, EnumSet.of(TargetCloud.CONTAINERS, TargetCloud.VM_IBM_CLOUD));
            targetAppServerToCloudMapping.put(LIBERTY, EnumSet.of(TargetCloud.THIRD_PARTY, TargetCloud.CONTAINERS, TargetCloud.VM_IBM_CLOUD));
            targetAppServerToCloudMapping.put(MANAGED_LIBERTY, EnumSet.of(TargetCloud.THIRD_PARTY, TargetCloud.CONTAINERS, TargetCloud.VM_IBM_CLOUD));
            targetAppServerToCloudMapping.put(LIBERTY_CORE, EnumSet.of(TargetCloud.THIRD_PARTY, TargetCloud.CONTAINERS, TargetCloud.VM_IBM_CLOUD));
            targetAppServerToCloudMapping.put(EASE, EnumSet.of(TargetCloud.THIRD_PARTY, TargetCloud.CONTAINERS, TargetCloud.VM_IBM_CLOUD));
            targetAppServerToCloudMapping.put(OPEN_LIBERTY, EnumSet.of(TargetCloud.THIRD_PARTY, TargetCloud.CONTAINERS, TargetCloud.VM_IBM_CLOUD));
            removedOptions.add("--targetAppServer=bluemix");
        }

        public JavaVersion getLatestSupportedJavaVersion() {
            switch (this) {
                case WAS855: 
                case WAS90: {
                    return JavaVersion.IBM8;
                }
                case MANAGED_LIBERTY: {
                    return JavaVersion.JAVA17;
                }
                case LIBERTY: 
                case EASE: 
                case LIBERTY_CORE: 
                case OPEN_LIBERTY: {
                    return JavaVersion.JAVA21;
                }
            }
            return JavaVersion.IBM8;
        }

        public String getWasVersion() {
            switch (this) {
                case WAS61: {
                    return "6.1";
                }
                case WAS70: {
                    return "7.0";
                }
                case WAS80: {
                    return "8.0";
                }
                case WAS855: {
                    return "8.5.5";
                }
                case WAS90: {
                    return "9.0";
                }
            }
            return null;
        }

        public EnumSet<JavaVersion> getSupportedTargetJavaVersions() {
            return appServerToTargetJavaVersionMapping.get((Object)this);
        }

        public static AppServer getAppServer(String option) {
            AppServer appSever = null;
            if (option.contains("--sourceAppServer=")) {
                appSever = lookupSource.get(option);
            } else if (option.contains("--targetAppServer=")) {
                appSever = lookupTarget.get(option);
            }
            return appSever;
        }

        public static boolean isRemoved(String option) {
            boolean removed = false;
            if (removedOptions.contains(option)) {
                removed = true;
            }
            return removed;
        }

        public static AppServer parseWebSphereVersion(String version) throws NumberFormatException {
            if (version != null) {
                String[] indexes = version.split("\\.");
                int firstIndexValue = Integer.parseInt(indexes[0]);
                int secondIndexValue = -1;
                if (indexes.length > 1) {
                    secondIndexValue = Integer.parseInt(indexes[1]);
                }
                switch (firstIndexValue) {
                    case 6: {
                        return WAS61;
                    }
                    case 7: {
                        return WAS70;
                    }
                    case 8: {
                        if (secondIndexValue >= 0 && secondIndexValue < 5 || secondIndexValue == -1) {
                            return WAS80;
                        }
                        if (secondIndexValue >= 5 && secondIndexValue <= 9) {
                            return WAS855;
                        }
                    }
                    case 9: {
                        return WAS90;
                    }
                }
                return null;
            }
            return null;
        }

        public JavaEEVersion getDefaultSourceJavaEE() {
            switch (this) {
                case WAS80: 
                case WAS855: 
                case LIBERTY: 
                case LIBERTY_CORE: {
                    return JavaEEVersion.EE6;
                }
                case WAS90: 
                case EASE: 
                case OPEN_LIBERTY: {
                    return JavaEEVersion.EE7;
                }
            }
            return null;
        }

        public Integer getTechColumn(TargetCloud targetCloud) {
            Integer index = techSummaryColumnIndex.get((Object)this);
            return index != null ? index : -1;
        }

        private AppServer(String sourceParm, String targetParm, String name2) {
            this.sourceParm = sourceParm;
            this.targetParm = targetParm;
            this.name = name2;
        }

        public String getName() {
            return this.name;
        }

        public String getSourceOption() {
            return this.sourceParm;
        }

        public String getTargetOption() {
            return this.targetParm;
        }

        public boolean isWAS_Traditional() {
            return wasTraditionalAppServers.contains((Object)this);
        }

        public boolean isLiberty() {
            return libertyAppServers.contains((Object)this);
        }

        public boolean isWAS90orLater() {
            return was90orLater.contains((Object)this);
        }

        public boolean isValidTargetAppServer(AppServer targetAppServer) {
            return sourceToTargetAppServerMapping.get((Object)this).contains((Object)targetAppServer);
        }

        public boolean isValidJavaEE(JavaEEVersion javaEEVersion) {
            return appServerToJavaEEVersionMapping.get((Object)this).contains((Object)javaEEVersion);
        }

        public boolean hasMultipleValidTargetJavaEEVersions() {
            return appServerToJavaEEVersionMapping.get((Object)this).size() > 1;
        }

        public EnumSet<JavaEEVersion> getSupportedTargetJavaEEVersions() {
            return appServerToJavaEEVersionMapping.get((Object)this);
        }

        public boolean isValidSourceJava(JavaVersion javaVersion) {
            return appServerToSourceJavaVersionMapping.get((Object)this).contains((Object)javaVersion);
        }

        public EnumSet<JavaVersion> getSupportedSourceJavaVersions() {
            return appServerToSourceJavaVersionMapping.get((Object)this);
        }

        public boolean isValidTargetJava(JavaVersion javaVersion) {
            return appServerToTargetJavaVersionMapping.get((Object)this).contains((Object)javaVersion);
        }

        public boolean isValidTargetCloud(TargetCloud targetCloud) {
            EnumSet<TargetCloud> mappings = targetAppServerToCloudMapping.get((Object)this);
            return mappings == null ? false : mappings.contains((Object)targetCloud);
        }

        public boolean isSupportedOnCloud() {
            EnumSet<TargetCloud> mappings = targetAppServerToCloudMapping.get((Object)this);
            return mappings == null ? false : !mappings.isEmpty();
        }

        public boolean isCompetitiveAppServer() {
            return competitiveAppServers.contains((Object)this);
        }

        public boolean isJboss() {
            return this == JBOSS;
        }

        public boolean isTomcat() {
            return this == TOMCAT;
        }

        public boolean isWebLogic() {
            return this == WEBLOGIC;
        }

        public static EnumSet<AppServer> getLibertyAppServers() {
            return libertyAppServers;
        }

        public static EnumSet<AppServer> getWasTraditionalAppServers() {
            return wasTraditionalAppServers;
        }
    }

    public static enum JavaEEVersion {
        EE6("ee6", Messages.getString("JavaEE_ee6")),
        EE7("ee7", Messages.getString("JavaEE_ee7")),
        EE8("ee8", Messages.getString("JavaEE_ee8")),
        EE9("ee9", Messages.getString("JavaEE_ee9")),
        EE10("ee10", Messages.getString("JavaEE_ee10")),
        EE11("ee11", Messages.getString("JavaEE_ee11"));

        private static final Map<String, JavaEEVersion> lookup;
        private static EnumMap<JavaEEVersion, EnumSet<JavaVersion>> javaEEToJavaVersionMapping;
        private static EnumMap<JavaEEVersion, String> javaEEToConvenienceFeatureMapping;
        private static Map<String, JavaEEVersion> convenienceFeatureToJavaEEMapping;
        private static Map<String, ArrayList<JavaEEVersion>> ejbConvenienceFeatureToJavaEEMapping;
        private final String stringValue;
        private final String name;
        private final int versionNum;

        static {
            lookup = new HashMap<String, JavaEEVersion>();
            javaEEToJavaVersionMapping = null;
            javaEEToConvenienceFeatureMapping = null;
            convenienceFeatureToJavaEEMapping = null;
            ejbConvenienceFeatureToJavaEEMapping = null;
            for (JavaEEVersion s : EnumSet.allOf(JavaEEVersion.class)) {
                lookup.put(s.stringValue, s);
            }
            javaEEToJavaVersionMapping = new EnumMap(JavaEEVersion.class);
            javaEEToJavaVersionMapping.put(EE6, EnumSet.of(JavaVersion.IBM6, new JavaVersion[]{JavaVersion.IBM7, JavaVersion.IBM8, JavaVersion.ORACLE6, JavaVersion.ORACLE7, JavaVersion.ORACLE8, JavaVersion.JAVA11, JavaVersion.JAVA17, JavaVersion.JAVA21}));
            javaEEToJavaVersionMapping.put(EE7, EnumSet.of(JavaVersion.IBM7, new JavaVersion[]{JavaVersion.IBM8, JavaVersion.ORACLE7, JavaVersion.ORACLE8, JavaVersion.JAVA11, JavaVersion.JAVA17, JavaVersion.JAVA21}));
            javaEEToJavaVersionMapping.put(EE8, EnumSet.of(JavaVersion.IBM8, JavaVersion.ORACLE8, JavaVersion.JAVA11, JavaVersion.JAVA17, JavaVersion.JAVA21));
            javaEEToJavaVersionMapping.put(EE9, EnumSet.of(JavaVersion.IBM8, JavaVersion.ORACLE8, JavaVersion.JAVA11, JavaVersion.JAVA17, JavaVersion.JAVA21));
            javaEEToJavaVersionMapping.put(EE10, EnumSet.of(JavaVersion.JAVA11, JavaVersion.JAVA17, JavaVersion.JAVA21));
            javaEEToJavaVersionMapping.put(EE11, EnumSet.of(JavaVersion.JAVA17, JavaVersion.JAVA21));
            javaEEToConvenienceFeatureMapping = new EnumMap(JavaEEVersion.class);
            javaEEToConvenienceFeatureMapping.put(EE6, "webProfile-6.0");
            javaEEToConvenienceFeatureMapping.put(EE7, "javaee-7.0");
            javaEEToConvenienceFeatureMapping.put(EE8, "javaee-8.0");
            javaEEToConvenienceFeatureMapping.put(EE9, "jakartaee-9.1");
            javaEEToConvenienceFeatureMapping.put(EE10, "jakartaee-10.0");
            javaEEToConvenienceFeatureMapping.put(EE11, "jakartaee-11.0");
            convenienceFeatureToJavaEEMapping = new HashMap<String, JavaEEVersion>();
            convenienceFeatureToJavaEEMapping.put("javaee-7.0", EE7);
            convenienceFeatureToJavaEEMapping.put("javaee-8.0", EE8);
            convenienceFeatureToJavaEEMapping.put("jakartaee-8.0", EE8);
            convenienceFeatureToJavaEEMapping.put("jakartaee-9.1", EE9);
            convenienceFeatureToJavaEEMapping.put("jakartaee-10.0", EE10);
            convenienceFeatureToJavaEEMapping.put("jakartaee-11.0", EE11);
            convenienceFeatureToJavaEEMapping.put("webProfile-7.0", EE7);
            convenienceFeatureToJavaEEMapping.put("webProfile-8.0", EE8);
            convenienceFeatureToJavaEEMapping.put("webProfile-9.1", EE9);
            convenienceFeatureToJavaEEMapping.put("webProfile-10.0", EE10);
            convenienceFeatureToJavaEEMapping.put("javaeeClient-7.0", EE7);
            convenienceFeatureToJavaEEMapping.put("javaeeClient-8.0", EE8);
            convenienceFeatureToJavaEEMapping.put("jakartaeeClient-9.1", EE9);
            convenienceFeatureToJavaEEMapping.put("jakartaeeClient-10.0", EE10);
            convenienceFeatureToJavaEEMapping.put("jakartaeeClient-11.0", EE11);
            ejbConvenienceFeatureToJavaEEMapping = new HashMap<String, ArrayList<JavaEEVersion>>();
            ejbConvenienceFeatureToJavaEEMapping.put("ejb-3.2", new ArrayList<JavaEEVersion>(Arrays.asList(EE7, EE8)));
            ejbConvenienceFeatureToJavaEEMapping.put("enterpriseBeans-4.0", new ArrayList<JavaEEVersion>(Arrays.asList(EE9, EE10)));
        }

        public static JavaEEVersion getJavaEEVersion(String option) {
            return lookup.get(option.substring(option.indexOf(61) + 1));
        }

        private JavaEEVersion(String stringValue, String name2) {
            this.stringValue = stringValue;
            this.name = name2;
            this.versionNum = Integer.parseInt(stringValue.replaceFirst("^[^0-9]*", ""));
        }

        public String toString() {
            return this.stringValue;
        }

        public int getVersionNumber() {
            return this.versionNum;
        }

        public String getName() {
            return this.name;
        }

        public String getSourceJavaEEOption() {
            if (ReportInputData.sourceJakartaEEParameterUsed()) {
                return "--sourceJakartaEE=" + this.stringValue;
            }
            return "--sourceJavaEE=" + this.stringValue;
        }

        public String getTargetJavaEEOption() {
            if (ReportInputData.targetJakartaEEParameterUsed()) {
                return "--targetJakartaEE=" + this.stringValue;
            }
            return "--targetJavaEE=" + this.stringValue;
        }

        public boolean isValid(JavaVersion javaVersion) {
            return javaEEToJavaVersionMapping.get((Object)this).contains((Object)javaVersion);
        }

        public static boolean isValidOption(String option) {
            JavaEEVersion entry = lookup.get(option.substring(option.indexOf(61) + 1));
            return entry != null;
        }

        public String getConvenienceFeature() {
            return javaEEToConvenienceFeatureMapping.get((Object)this);
        }

        public static JavaEEVersion getJavaEEVersionFromConvenienceFeature(String feature) {
            return convenienceFeatureToJavaEEMapping.get(feature);
        }

        public static ArrayList<JavaEEVersion> getJavaEEVersionsFromEjbConvenienceFeature(String feature) {
            return ejbConvenienceFeatureToJavaEEMapping.get(feature);
        }
    }

    public static enum JavaVersion {
        IBM5("--sourceJava=ibm5", null, 5, Messages.getString("JavaSE_ibm5")),
        IBM6("--sourceJava=ibm6", null, 6, Messages.getString("JavaSE_ibm6")),
        IBM7("--sourceJava=ibm7", "--targetJava=ibm7", 7, Messages.getString("JavaSE_ibm7")),
        IBM8("--sourceJava=ibm8", "--targetJava=ibm8", 8, Messages.getString("JavaSE_ibm8")),
        JAVA11("--sourceJava=java11", "--targetJava=java11", 11, Messages.getString("JavaSE_java11")),
        JAVA17("--sourceJava=java17", "--targetJava=java17", 17, Messages.getString("JavaSE_java17")),
        JAVA21("--sourceJava=java21", "--targetJava=java21", 21, Messages.getString("JavaSE_java21")),
        ORACLE5("--sourceJava=oracle5", null, 5, Messages.getString("JavaSE_oracle5")),
        ORACLE6("--sourceJava=oracle6", null, 6, Messages.getString("JavaSE_oracle6")),
        ORACLE7("--sourceJava=oracle7", "--targetJava=oracle7", 7, Messages.getString("JavaSE_oracle7")),
        ORACLE8("--sourceJava=oracle8", "--targetJava=oracle8", 8, Messages.getString("JavaSE_oracle8"));

        private static EnumSet<JavaVersion> oracleJava;
        private static EnumSet<JavaVersion> ibmJava;
        private static EnumSet<JavaVersion> java5;
        private static EnumSet<JavaVersion> java6;
        private static EnumSet<JavaVersion> java7;
        private static EnumSet<JavaVersion> java11;
        private static final Map<String, JavaVersion> lookupSource;
        private static final Map<String, JavaVersion> lookupTarget;
        private final String sourceParm;
        private final String targetParm;
        private final int versionNum;
        private final String name;

        static {
            oracleJava = EnumSet.of(ORACLE5, ORACLE6, ORACLE7, ORACLE8);
            ibmJava = EnumSet.of(IBM5, IBM6, IBM7, IBM8);
            java5 = EnumSet.of(IBM5, ORACLE5);
            java6 = EnumSet.of(IBM6, ORACLE6);
            java7 = EnumSet.of(IBM7, ORACLE7);
            java11 = EnumSet.of(JAVA11);
            lookupSource = new HashMap<String, JavaVersion>();
            lookupTarget = new HashMap<String, JavaVersion>();
            for (JavaVersion s : EnumSet.allOf(JavaVersion.class)) {
                lookupSource.put(s.sourceParm, s);
                lookupTarget.put(s.targetParm, s);
            }
        }

        public static JavaVersion getJavaVersion(String option) {
            JavaVersion javaVersion = null;
            if (option.contains("--sourceJava=")) {
                javaVersion = lookupSource.get(option);
            } else if (option.contains("--targetJava=")) {
                javaVersion = lookupTarget.get(option);
            }
            return javaVersion;
        }

        public static JavaVersion parseIBMJava(String version) throws NumberFormatException {
            if (version != null) {
                String[] indexes = version.split("\\.");
                int indexValue = Integer.parseInt(indexes[0]);
                if (indexValue == 1 && indexes.length > 1) {
                    indexValue = Integer.parseInt(indexes[1]);
                }
                switch (indexValue) {
                    case 5: {
                        return IBM5;
                    }
                    case 6: {
                        return IBM6;
                    }
                    case 7: {
                        return IBM7;
                    }
                    case 8: {
                        return IBM8;
                    }
                }
                return null;
            }
            return null;
        }

        public static boolean isJava5(String option) {
            boolean isJava5 = false;
            if (option.endsWith("ibm5") || option.endsWith("oracle5")) {
                isJava5 = true;
            }
            return isJava5;
        }

        public static boolean isJava6(String option) {
            boolean isJava6 = false;
            if (option.endsWith("ibm6") || option.endsWith("oracle6")) {
                isJava6 = true;
            }
            return isJava6;
        }

        public static boolean isJava7(String option) {
            boolean isJava7 = false;
            if (option.endsWith("ibm7") || option.endsWith("oracle7")) {
                isJava7 = true;
            }
            return isJava7;
        }

        public static boolean isIBMJAVA6(String option) {
            boolean isIBMJAVA6 = false;
            if (option.endsWith("ibm6")) {
                isIBMJAVA6 = true;
            }
            return isIBMJAVA6;
        }

        private JavaVersion(String sourceParm, String targetParm, int versionNum, String name2) {
            this.sourceParm = sourceParm;
            this.targetParm = targetParm;
            this.versionNum = versionNum;
            this.name = name2;
        }

        public String getName() {
            return this.name;
        }

        public String getSourceOption() {
            return this.sourceParm;
        }

        public String getTargetOption() {
            return this.targetParm;
        }

        public boolean isOracleJava() {
            return oracleJava.contains((Object)this);
        }

        public boolean isIBMJava() {
            return ibmJava.contains((Object)this);
        }

        public boolean isJava5() {
            return java5.contains((Object)this);
        }

        public boolean isJava6() {
            return java6.contains((Object)this);
        }

        public boolean isJava7() {
            return java7.contains((Object)this);
        }

        public boolean isJava11() {
            return java11.contains((Object)this);
        }

        public int getVersionNumber() {
            return this.versionNum;
        }
    }

    public static enum MicroProfileVersion {
        MP1("mp1"),
        MP1_2("mp1.2"),
        MP1_3("mp1.3"),
        MP1_4("mp1.4"),
        MP2("mp2"),
        MP2_0("mp2.0"),
        MP2_1("mp2.1"),
        MP2_2("mp2.2"),
        MP3("mp3"),
        MP3_0("mp3.0"),
        MP3_2("mp3.2"),
        MP3_3("mp3.3"),
        MP4("mp4"),
        MP4_0("mp4.0"),
        MP4_1("mp4.1"),
        MP5("mp5"),
        MP5_0("mp5.0"),
        MP6("mp6"),
        MP6_0("mp6.0");

        private static final Map<String, MicroProfileVersion> lookup;
        private static EnumMap<MicroProfileVersion, String> microprofileToConvenienceFeatureMapping;
        private final String stringValue;

        static {
            lookup = new HashMap<String, MicroProfileVersion>();
            microprofileToConvenienceFeatureMapping = null;
            for (MicroProfileVersion s : EnumSet.allOf(MicroProfileVersion.class)) {
                lookup.put(s.stringValue, s);
            }
            microprofileToConvenienceFeatureMapping = new EnumMap(MicroProfileVersion.class);
            String microProfile = "microProfile-";
            microprofileToConvenienceFeatureMapping.put(MP1, String.valueOf(microProfile) + "1.4");
            microprofileToConvenienceFeatureMapping.put(MP1_2, String.valueOf(microProfile) + "1.2");
            microprofileToConvenienceFeatureMapping.put(MP1_3, String.valueOf(microProfile) + "1.3");
            microprofileToConvenienceFeatureMapping.put(MP1_4, String.valueOf(microProfile) + "1.4");
            microprofileToConvenienceFeatureMapping.put(MP2, String.valueOf(microProfile) + "2.2");
            microprofileToConvenienceFeatureMapping.put(MP2_0, String.valueOf(microProfile) + "2.0");
            microprofileToConvenienceFeatureMapping.put(MP2_1, String.valueOf(microProfile) + "2.1");
            microprofileToConvenienceFeatureMapping.put(MP2_2, String.valueOf(microProfile) + "2.2");
            microprofileToConvenienceFeatureMapping.put(MP3, String.valueOf(microProfile) + "3.3");
            microprofileToConvenienceFeatureMapping.put(MP3_0, String.valueOf(microProfile) + "3.0");
            microprofileToConvenienceFeatureMapping.put(MP3_2, String.valueOf(microProfile) + "3.2");
            microprofileToConvenienceFeatureMapping.put(MP3_3, String.valueOf(microProfile) + "3.3");
            microprofileToConvenienceFeatureMapping.put(MP4, String.valueOf(microProfile) + "4.1");
            microprofileToConvenienceFeatureMapping.put(MP4_0, String.valueOf(microProfile) + "4.0");
            microprofileToConvenienceFeatureMapping.put(MP4_1, String.valueOf(microProfile) + "4.1");
            microprofileToConvenienceFeatureMapping.put(MP5, String.valueOf(microProfile) + "5.0");
            microprofileToConvenienceFeatureMapping.put(MP5_0, String.valueOf(microProfile) + "5.0");
            microprofileToConvenienceFeatureMapping.put(MP6, String.valueOf(microProfile) + "6.0");
            microprofileToConvenienceFeatureMapping.put(MP6_0, String.valueOf(microProfile) + "6.0");
        }

        public static MicroProfileVersion getMicroProfileVersion(String option) {
            return lookup.get(option.substring(option.indexOf(61) + 1));
        }

        private MicroProfileVersion(String s) {
            this.stringValue = s;
        }

        public String toString() {
            return this.stringValue;
        }

        public static boolean isValidOption(String option) {
            MicroProfileVersion entry = lookup.get(option.substring(option.indexOf(61) + 1));
            return entry != null;
        }

        public String getConvenienceFeature() {
            return microprofileToConvenienceFeatureMapping.get((Object)this);
        }

        public static MicroProfileVersion getMicroProfileVersionFromConvenienceFeature(String feature) {
            MicroProfileVersion version = null;
            for (Map.Entry<MicroProfileVersion, String> entry : microprofileToConvenienceFeatureMapping.entrySet()) {
                if (!entry.getValue().equals(feature)) continue;
                MicroProfileVersion key = entry.getKey();
                if (version != null && key.compareTo(version) <= 1) continue;
                version = key;
            }
            return version;
        }
    }

    public static enum Options {
        SOURCE_APP_SERVER("--sourceAppServer="),
        TARGET_APP_SERVER("--targetAppServer="),
        TARGET_CLOUD("--targetCloud="),
        SOURCE_JAVA("--sourceJava"),
        TARGET_JAVA("targetJava"),
        SOURCE_JAVAEE("--sourceJavaEE="),
        TARGET_JAVAEE("--targetJavaEE="),
        BASE_EDITION("--baseEdition"),
        CORE_EDITION("--coreEdition"),
        LIBERTY_BUILDPACK_EDITION("--libertyBuildpackEdition"),
        ND_EDITION("--ndEdition"),
        ZOS_EDITION("--zosEdition"),
        LIBERTY("--liberty"),
        TRADITIONAL("--traditional"),
        FORMAT("--format"),
        OUTPUT("--output"),
        DEBUG("--debug"),
        EXCLUDE_FILES("--excludeFiles"),
        EXCLUDE_PACKAGES("--excludePackages"),
        INCLUDE_PACKAGES("--includePackages"),
        SHARED_LIBRARIES("--sharedLibraries="),
        DETECT_SHARED_LIBRARIES("--detectSharedLibraries"),
        USER_RULE_LOCATION("--userRuleLocation"),
        USER_RULES_ONLY("--userRulesOnly"),
        MAX_USER_DEFINED_RULE_RESULTS("--maxUserDefinedRuleResults"),
        CONFIG_LOCATION("--configLocation"),
        INCLUDE_SENSITIVE_DATA("--includeSensitiveData"),
        NO_BROWSER("nobrowser"),
        SHOW_ALL_HELP("--showAllHelp"),
        LOAD_ALL_RULES("--loadAllRules"),
        INCLUDE_HELP_LOCATION("--includeHelpLocation"),
        MIGRATE_ALL_CONFIG("--migrateAllConfig"),
        EXCLUDE_RULES("--excludeRules="),
        SCAN_ALL("--scanAll");

        String stringValue;

        private Options(String s) {
            this.stringValue = s;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum OutputType {
        HTML(".html"),
        TEXT(".txt"),
        JSON(".json"),
        XML(".xml"),
        PY(".py");

        private final String extension;

        private OutputType(String extension) {
            this.extension = extension;
        }

        public String getExtension() {
            return this.extension;
        }

        public static OutputType getOutputType(String extension) {
            if (".html".equals(extension)) {
                return HTML;
            }
            if (".txt".equals(extension)) {
                return TEXT;
            }
            if (".json".equals(extension)) {
                return JSON;
            }
            if (".xml".equals(extension)) {
                return XML;
            }
            if (".py".equals(extension)) {
                return PY;
            }
            return null;
        }
    }

    public static enum ReportType {
        EVALUATE("--evaluate"),
        ANALYZE("--analyze"),
        INVENTORY("--inventory"),
        GENERATE_CONFIG("--generateConfig");

        private static EnumSet<ReportType> nonInventoryReportTypes;
        private static EnumSet<ReportType> nonEvaluateReportTypes;
        private static EnumSet<ReportType> inventoryReportTypes;
        private final String stringValue;

        static {
            nonInventoryReportTypes = EnumSet.of(EVALUATE, ANALYZE, GENERATE_CONFIG);
            nonEvaluateReportTypes = EnumSet.of(ANALYZE, GENERATE_CONFIG, INVENTORY);
            inventoryReportTypes = EnumSet.of(INVENTORY);
        }

        public static Set<ReportType> getNonEvaluateReportTypes() {
            return nonEvaluateReportTypes;
        }

        public static Set<ReportType> getNonInventoryReportTypes() {
            return nonInventoryReportTypes;
        }

        public static Set<ReportType> getInventoryReportTypes() {
            return inventoryReportTypes;
        }

        private ReportType(String s) {
            this.stringValue = s;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum TargetCloud {
        DOCKER("--targetCloud=docker", Messages.getString("Cloud_containers")),
        WAS_VM("--targetCloud=wasVM", Messages.getString("Cloud_vmIBMCloud")),
        DOCKER_IBM_CLOUD("--targetCloud=dockerIBMCloud", Messages.getString("Cloud_containers")),
        CONTAINERS("--targetCloud=containers", Messages.getString("Cloud_containers")),
        THIRD_PARTY("--targetCloud=thirdParty", Messages.getString("Cloud_thirdParty")),
        VM_IBM_CLOUD("--targetCloud=vmIBMCloud", Messages.getString("Cloud_vmIBMCloud"));

        private static final Map<String, TargetCloud> lookup;
        private static EnumSet<TargetCloud> deprecatedTargetClouds;
        private static Map<String, TargetCloud> currentTargetCloudMapping;
        private static Set<String> removedOptions;
        private final String stringValue;
        private final String name;

        static {
            lookup = new HashMap<String, TargetCloud>();
            deprecatedTargetClouds = EnumSet.of(DOCKER, WAS_VM, DOCKER_IBM_CLOUD);
            currentTargetCloudMapping = new HashMap<String, TargetCloud>();
            removedOptions = new HashSet<String>();
            removedOptions.add("--targetCloud=cfIBMCloud");
            removedOptions.add("--targetCloud=bluemix");
            for (TargetCloud s : EnumSet.allOf(TargetCloud.class)) {
                lookup.put(s.stringValue, s);
            }
            lookup.put("--targetAppServer=cloud", THIRD_PARTY);
            currentTargetCloudMapping.put("--targetCloud=docker", CONTAINERS);
            currentTargetCloudMapping.put("--targetCloud=wasVM", VM_IBM_CLOUD);
            currentTargetCloudMapping.put("--targetCloud=dockerIBMCloud", CONTAINERS);
        }

        public static TargetCloud getTargetCloud(String option) {
            TargetCloud theTargetCloud = lookup.get(option);
            if (theTargetCloud != null && deprecatedTargetClouds.contains((Object)theTargetCloud)) {
                theTargetCloud = currentTargetCloudMapping.get(option);
            }
            return theTargetCloud;
        }

        public static boolean isRemoved(String option) {
            boolean removed = false;
            if (removedOptions.contains(option)) {
                removed = true;
            }
            return removed;
        }

        private TargetCloud(String stringValue, String name2) {
            this.stringValue = stringValue;
            this.name = name2;
        }

        public String toString() {
            return this.stringValue;
        }

        public String getName() {
            return this.name;
        }
    }
}

