/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.appserver.tools.jaxrpc.common.data;

import com.ibm.websphere.appserver.tools.jaxrpc.common.ArchiveResources;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class XMLResources {
    private ArchiveResources archiveResource;
    private boolean ejbXmlIsValid = true;
    private boolean allXmlValid = true;
    private List<String> serviceDDs = new ArrayList<String>();
    private List<String> clientDDs = new ArrayList<String>();
    private HashMap<String, Set<String>> ejbJarXmlLinks = new HashMap();
    private HashMap<String, Set<String>> webXmlLinks = new HashMap();
    private Set<File> jaxRpcMappingFileElements = new HashSet<File>();
    private List<File> bindingAndExtensionFiles = new ArrayList<File>();

    public XMLResources(ArchiveResources ar) {
        this.archiveResource = ar;
    }

    public ArchiveResources getArchiveResources() {
        return this.archiveResource;
    }

    public void setEjbXmlIsValid(boolean ejbXmlIsValid) {
        this.ejbXmlIsValid = this.ejbXmlIsValid && ejbXmlIsValid;
    }

    public boolean getEjbXmlIsValid() {
        return this.ejbXmlIsValid;
    }

    public void consolidate(XMLResources xr) {
        this.serviceDDs.addAll(xr.getServiceDDList());
        this.clientDDs.addAll(xr.getClientDDList());
        this.webXmlLinks.putAll(xr.getWebXmlLinks());
        this.ejbJarXmlLinks.putAll(xr.getEjbJarXmlLinks());
        this.jaxRpcMappingFileElements.addAll(xr.getJaxRpcMappingFileElements());
        if (xr.getArchiveResources().getParentArchive().isEarArchive()) {
            this.setEjbXmlIsValid(xr.getEjbXmlIsValid());
        }
        this.allXmlValid &= xr.isAllXmlValid();
    }

    public List<String> getServiceDDList() {
        return this.serviceDDs;
    }

    public void addServiceDD(String webservicesXml) {
        this.serviceDDs.add(webservicesXml);
    }

    public List<String> getClientDDList() {
        return this.clientDDs;
    }

    public void addClientDD(String webXml) {
        this.clientDDs.add(webXml);
    }

    public List<String> getAllDeploymentDescriptors() {
        ArrayList<String> deploymentDescriptorsList = new ArrayList<String>();
        deploymentDescriptorsList.addAll(this.serviceDDs);
        deploymentDescriptorsList.addAll(this.clientDDs);
        deploymentDescriptorsList.addAll(this.getEjbJarXmlPaths());
        return deploymentDescriptorsList;
    }

    public Set<String> getWebXmlPaths() {
        return this.webXmlLinks.keySet();
    }

    public HashMap<String, Set<String>> getWebXmlLinks() {
        return this.webXmlLinks;
    }

    public Set<String> getEjbJarXmlPaths() {
        return this.ejbJarXmlLinks.keySet();
    }

    public HashMap<String, Set<String>> getEjbJarXmlLinks() {
        return this.ejbJarXmlLinks;
    }

    public Set<String> getWebXmlAndEjbPaths() {
        HashSet<String> union = new HashSet<String>(this.webXmlLinks.keySet());
        union.addAll(this.ejbJarXmlLinks.keySet());
        return union;
    }

    public Set<String> getLinkNames(String xmlFile) {
        return xmlFile.endsWith("web.xml") ? this.webXmlLinks.get(xmlFile) : this.ejbJarXmlLinks.get(xmlFile);
    }

    public void removeEjbDeploymentDescriptor(String xmlFile) {
        this.ejbJarXmlLinks.remove(xmlFile);
    }

    public void addXmlFile(String xmlFile) {
        this.addXmlFile(xmlFile, null);
    }

    public void addXmlFile(String xmlFile, String linkName) {
        if (xmlFile.endsWith("web.xml")) {
            if (linkName == null) {
                if (null == this.webXmlLinks.get(xmlFile)) {
                    this.webXmlLinks.put(xmlFile, null);
                }
            } else if (this.webXmlLinks.get(xmlFile) != null && this.webXmlLinks.get(xmlFile) != null) {
                Set<String> links = this.webXmlLinks.get(xmlFile);
                links.add(linkName);
            } else {
                HashSet<String> links = new HashSet<String>();
                links.add(linkName);
                this.webXmlLinks.put(xmlFile, links);
            }
        } else if (xmlFile.endsWith("ejb-jar.xml") || xmlFile.endsWith("ejb-jar_merged.xml")) {
            if (linkName == null) {
                if (null == this.ejbJarXmlLinks.get(xmlFile)) {
                    this.ejbJarXmlLinks.put(xmlFile, null);
                }
            } else if (this.ejbJarXmlLinks.containsKey(xmlFile) && this.ejbJarXmlLinks.get(xmlFile) != null) {
                Set<String> links = this.ejbJarXmlLinks.get(xmlFile);
                links.add(linkName);
            } else {
                HashSet<String> links = new HashSet<String>();
                links.add(linkName);
                this.ejbJarXmlLinks.put(xmlFile, links);
            }
        }
    }

    public void addJaxRpcMappingFileElement(File jaxRpcMappingFileElement) {
        this.jaxRpcMappingFileElements.add(jaxRpcMappingFileElement);
    }

    public Set<File> getJaxRpcMappingFileElements() {
        return this.jaxRpcMappingFileElements;
    }

    public void addBindingOrExtensionFile(File bindingOrExtensionFile) {
        this.bindingAndExtensionFiles.add(bindingOrExtensionFile);
    }

    public List<File> getBindingAndExtensionFiles() {
        return this.bindingAndExtensionFiles;
    }

    public boolean isAllXmlValid() {
        return this.allXmlValid;
    }

    public void setXmlInvalid() {
        this.allXmlValid = false;
    }
}

