/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.appserver.tools.jaxrpc.common.data;

import com.ibm.websphere.appserver.tools.jaxrpc.common.data.Param;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.WSDLResource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ServiceEndpointMethod {
    private WSDLResource wsdl;
    private String methodName;
    private Param[] paramArray;
    private String returnValue;
    private String returnXsd;
    private String returnWsdlReferenceName;
    private String signature;
    private List<Param> paramList = new ArrayList<Param>();

    public ServiceEndpointMethod() {
    }

    public ServiceEndpointMethod(WSDLResource wsdl, String methodName, List<Param> paramXsds, String returnValue, String returnXsd, String returnWsdlReferenceName) {
        this.wsdl = wsdl;
        this.methodName = methodName;
        this.paramList = paramXsds;
        this.returnValue = returnValue;
        this.returnXsd = returnXsd;
        this.returnWsdlReferenceName = returnWsdlReferenceName;
    }

    public String toString() {
        return "ServiceEndpointMethod[Method Name: " + this.methodName + "]";
    }

    public WSDLResource getWsdl() {
        return this.wsdl;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void addMethodParam(String position, String classType, String xsdType) {
        this.paramList.add(new Param(position, classType, xsdType, null));
    }

    public void addAllMethodParams(List<Param> params) {
        this.paramList.addAll(params);
    }

    public void buildMethodParams() {
        this.paramArray = new Param[this.paramList.size()];
        Iterator<Param> iterator = this.paramList.iterator();
        while (iterator.hasNext()) {
            Param p;
            this.paramArray[Integer.parseInt((String)p.getPosition())] = p = iterator.next();
        }
    }

    public Param[] getParamArray() {
        if (this.paramArray == null) {
            this.buildMethodParams();
        }
        return this.paramArray;
    }

    public List<Param> getParamList() {
        return this.paramList;
    }

    public void setReturnValue(String returnValue) {
        this.returnValue = returnValue;
    }

    public String getReturnValue() {
        return this.returnValue;
    }

    public void setReturnXsd(String returnXsdType) {
        this.returnXsd = returnXsdType;
    }

    public String getReturnXsd() {
        return this.returnXsd;
    }

    public String getReturnWsdlReferenceName() {
        return this.returnWsdlReferenceName;
    }

    public String getSignature() {
        if (this.signature == null) {
            StringBuilder sb = new StringBuilder("(");
            for (Param p : this.getParamArray()) {
                sb.append(this.signaturize(p.getClassType()));
            }
            sb.append(")");
            if (this.returnValue.equals("void")) {
                sb.append("V");
            } else {
                sb.append(this.signaturize(this.returnValue));
            }
            this.signature = sb.toString();
        }
        return this.signature;
    }

    private String signaturize(String classType) {
        StringBuilder signature = new StringBuilder();
        if (classType.contains("[]")) {
            classType = classType.replace("[]", "");
            signature.append("[");
        }
        signature.append("L" + classType.replace(".", "/") + ";");
        return signature.toString();
    }
}

